/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForGettingSELInfo
extends Command {
    public static String SEL_INFO_OBJECT = "SEL_INFO_OBJECT";

    public Result execute(Host host) {
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiSELCommand.setIPMIInterface(rmcp);
        ipmiSDRCommand.setIPMIInterface(rmcp);
        SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
        if (selInfo != null) {
            host.selInfo = selInfo;
            result.booleanResult = true;
            result.description = result.description + "\n";
            result.description = result.description + selInfo.toString();
            result.setSingleData(SEL_INFO_OBJECT, selInfo);
        } else {
            result.booleanResult = false;
            result.description = L.t("group.Get_SEL_Info_failed");
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Get SEL Info";
    }
}

