/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import java.util.Observable;

public class TenGPassThruEntity
extends Observable {
    private boolean powerOn;
    private boolean powerReset;
    private byte present;
    private byte v33Aux;
    private byte vvdd;
    private byte vram_3v3;
    private byte vcore_1v2;
    private byte temp_1v25;
    private byte temp_3v3;
    private byte i2cError;
    private byte busNumber;
    private byte channel;
    private byte initialized;
    private byte pollCount;
    private byte flag;
    private byte reserve2;
    private byte type;
    private byte reserve4;
    private byte reserve5;
    private byte reserve6;
    private byte reserve7;
    private byte reserve8;
    private byte[] raw;
    private int moduleIndex;
    private double vcore_1v2Formula;
    private double vram_3v3Formula;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npowerOn =" + this.powerOn);
        sb.append("\npowerReset =" + this.powerReset);
        sb.append("\npresent =" + this.present);
        sb.append("\nv33Aux =" + this.v33Aux);
        sb.append("\nvvdd =" + this.vvdd);
        sb.append("\nvram_3v3* =" + this.vram_3v3);
        sb.append("\nvcore_1v2* =" + this.vcore_1v2);
        sb.append("\ntemp_1v25* =" + this.temp_1v25);
        sb.append("\ntemp3v3* =" + this.temp_3v3);
        sb.append("\ni2cError =" + this.i2cError);
        sb.append("\nbusNumber =" + this.busNumber);
        sb.append("\nchannel =" + this.channel);
        sb.append("\ninitialized =" + this.initialized);
        sb.append("\npollCount =" + this.pollCount);
        sb.append("\nflag =" + this.flag);
        sb.append("\nreserve2 =" + this.reserve2);
        sb.append("\ntype* =" + this.type);
        sb.append("\nreserve4 =" + this.reserve4);
        sb.append("\nreserve5 =" + this.reserve5);
        sb.append("\nreserve6 =" + this.reserve6);
        sb.append("\nreserve7 =" + this.reserve7);
        sb.append("\nreserve8 =" + this.reserve8);
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        sb.append("\n* Only end of (*) is validate field. Others is dummy field");
        sb.append("\nVram 3v3 = " + this.getVram_3v3Formula());
        sb.append("\nVcore 1v2 = " + this.getVcore_1v2Formula());
        return sb.toString();
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != 22) {
            return false;
        }
        try {
            this.powerOn = (raw[0] & 1) != 1;
            this.powerReset = (raw[0] & 2) == 2;
            this.present = raw[2];
            this.v33Aux = raw[3];
            this.vvdd = raw[4];
            this.vram_3v3 = raw[5];
            this.vcore_1v2 = raw[6];
            this.temp_1v25 = raw[7];
            this.temp_3v3 = raw[8];
            this.i2cError = raw[9];
            this.busNumber = raw[10];
            this.channel = raw[11];
            this.initialized = raw[12];
            this.pollCount = raw[13];
            this.flag = raw[14];
            this.reserve2 = raw[15];
            this.type = raw[16];
            this.reserve4 = raw[17];
            this.reserve5 = raw[18];
            this.reserve6 = raw[19];
            this.reserve7 = raw[20];
            this.reserve8 = raw[21];
            this.raw = raw;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        return true;
    }

    public double getVram_3v3Formula() {
        return (double)(this.vram_3v3 & 0xFF) * 0.008 * 2.0;
    }

    public double getVcore_1v2Formula() {
        return (double)(this.vcore_1v2 & 0xFF) * 0.008;
    }

    public byte getBusNumber() {
        return this.busNumber;
    }

    public byte getChannel() {
        return this.channel;
    }

    public byte getFlag() {
        return this.flag;
    }

    public byte getI2cError() {
        return this.i2cError;
    }

    public byte getInitialized() {
        return this.initialized;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public byte getPollCount() {
        return this.pollCount;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isPowerReset() {
        return this.powerReset;
    }

    public byte getPresent() {
        return this.present;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public byte getReserve2() {
        return this.reserve2;
    }

    public byte getReserve4() {
        return this.reserve4;
    }

    public byte getReserve5() {
        return this.reserve5;
    }

    public byte getReserve6() {
        return this.reserve6;
    }

    public byte getReserve7() {
        return this.reserve7;
    }

    public byte getTemp_1v25() {
        return this.temp_1v25;
    }

    public byte getType() {
        return this.type;
    }

    public byte getTemp_3v3() {
        return this.temp_3v3;
    }

    public byte getV33Aux() {
        return this.v33Aux;
    }

    public byte getVcore_1v2() {
        return this.vcore_1v2;
    }

    public byte getVram_3v3() {
        return this.vram_3v3;
    }

    public byte getVvdd() {
        return this.vvdd;
    }

    public byte getReserve8() {
        return this.reserve8;
    }

    public void setBusNumber(byte busNumber) {
        this.busNumber = busNumber;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public void setI2cError(byte i2cError) {
        this.i2cError = i2cError;
    }

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public void setInitialized(byte initialized) {
        this.initialized = initialized;
    }

    public void setPollCount(byte pollCount) {
        this.pollCount = pollCount;
    }

    public void setPowerOn(boolean powerOn) {
        this.powerOn = powerOn;
    }

    public void setPowerReset(boolean powerReset) {
        this.powerReset = powerReset;
    }

    public void setPresent(byte present) {
        this.present = present;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public void setReserve2(byte reserve2) {
        this.reserve2 = reserve2;
    }

    public void setReserve4(byte reserve4) {
        this.reserve4 = reserve4;
    }

    public void setReserve5(byte reserve5) {
        this.reserve5 = reserve5;
    }

    public void setReserve6(byte reserve6) {
        this.reserve6 = reserve6;
    }

    public void setReserve7(byte reserve7) {
        this.reserve7 = reserve7;
    }

    public void setReserve8(byte reserve8) {
        this.reserve8 = reserve8;
    }

    public void setTemp_1v25(byte temp_1v25) {
        this.temp_1v25 = temp_1v25;
    }

    public void setTemp_3v3(byte temp_3v3) {
        this.temp_3v3 = temp_3v3;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setV33Aux(byte v33Aux) {
        this.v33Aux = v33Aux;
    }

    public void setVcore_1v2(byte vcore_1v2) {
        this.vcore_1v2 = vcore_1v2;
    }

    public void setVcore_1v2Formula(double vcore_1v2Formula) {
        this.vcore_1v2Formula = vcore_1v2Formula;
    }

    public void setVram_3v3(byte vram_3v3) {
        this.vram_3v3 = vram_3v3;
    }

    public void setVram_3v3Formula(double vram_3v3Formula) {
        this.vram_3v3Formula = vram_3v3Formula;
    }

    public void setVvdd(byte vvdd) {
        this.vvdd = vvdd;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-14s | %-5s | %13s | %13s | %6s | %6s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "10G Pass Thru", "Power", "Temp. VR3.3V", "Temp. VR1.25V", "3.3V", "1.2V"));
        header.append(String.format(formatTemplate, "-------------", "-----", "------------", "-------------", "----", "----"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.getPresent() == 0) {
            return "";
        }
        String formatTemplate = " %-14s | %-5s | %13s | %13s | %6s | %6s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "10G Pass" + this.moduleIndex;
        String power = "On";
        String temp1v25 = "" + this.showCandF(this.getTemp_1v25());
        String temp3v3 = "" + this.showCandF(this.getTemp_3v3());
        String v33 = this.d2StrV(this.getVram_3v3Formula());
        String v12 = this.d2StrV(this.getVcore_1v2Formula());
        formatedString.append(String.format(formatTemplate, index, power, temp3v3, temp1v25, v33, v12));
        return formatedString.toString();
    }

    protected String showCandF(byte c) {
        if (c == -127) {
            return "N/A";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + f + "F";
    }

    public String d2StrV(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d + "V";
    }
}

