/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.Debug;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.LogUtil;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.AbstractMBSensorEntity;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.blade.DisconnectListener;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.FrontLEDEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.blade.MBSensorEntityFactory;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import com.supermicro.ipmi.blade.TenGPassThruEntity;
import com.supermicro.ipmi.lang.L;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class BladeSystemEntity
extends Observable {
    boolean debug = false;
    public boolean isLoginSuccessful = false;
    public boolean isLogoutSuccessful = false;
    public boolean isBladeEntityAvailable = false;
    public boolean isCMMModuleEntityAvailable = false;
    public boolean isGigabitSwitchEntityAvailable = false;
    public boolean isInfiniBandEntityAvailable = false;
    public boolean isPowerSupplyEntityAvailable = false;
    public boolean isMBSensorEntityAvailable = false;
    public boolean isFrontLEDEntityAvailable = false;
    public boolean isQueryBladeEntity = true;
    public boolean isQueryCMMModuleEntity = true;
    public boolean isQueryGigabitSwitchEntity = true;
    public boolean isQueryInfiniBandEntity = true;
    public boolean isQueryPowerSupplyEntity = true;
    public boolean isQueryMBSensorEntity = true;
    public boolean isQueryFrontLEDEntity = true;
    public boolean isQueryFanControlMode = true;
    public boolean isGenerateFailureReport = true;
    public boolean isGetPowerConsumptionStatus = true;
    public static final int BLADE_DATA_SIZE = 18;
    public static final int CMM_MODULE_DATA_SIZE = 11;
    public static final int GIGABIT_SWITCH_MODULE_DATA_SIZE = 19;
    public static final int INFINI_BAND_MODULE_DATA_SIZE = 22;
    public static final int POWER_SUPPLY_MODULE_DATA_SIZE = 34;
    public static final int MOTHER_BOARD_SENSORS_DATA_SIZE = 35;
    public static final int FRONT_PANEL_LED_DATA_SIZE = 2;
    private BladeEntity[] blades;
    private AbstractMBSensorEntity[] mbSensors;
    private CMMModuleEntity[] cmmModules;
    private GigabitSwitchEntity[] gigabitSwitchs;
    private InfiniBandEntity[] infiniBands;
    private PowerSupplyEntity[] powerSupplies;
    private TenGPassThruEntity[] tenGPassThrus;
    private FrontLEDEntity frontLED;
    private IPMICMMOEMCommand.PowerConsumptionStatus powerConsumptionStatus;
    private ArrayList failures = new ArrayList();
    boolean isMaster;
    ArrayList disconnectListeners = new ArrayList();
    private byte fanControlMode = 0;
    private boolean isSupportIPMB = false;
    public boolean ifCheckOnlyOneTime = false;
    private int poolingInterval = 4;
    Timer poolingTimer;
    private ISessionController sessionController;
    private IPMIInterfaceConfig ipmiInterfaceConfig;
    IPMICMMOEMCommand ipmiCMMOEMCommand;
    boolean useExistConnection = false;
    int count = 0;
    SimpleDateFormat f = new SimpleDateFormat("MM/dd HH:mm:ss");
    int countOfGetData = 0;
    int queryCount = 0;

    public BladeSystemEntity(IPMIInterfaceConfig ipmiInterfaceConfig) {
        int i;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ipmiInterfaceConfig.getIp());
        int bladeSize = 10;
        int cmmModuleSize = 2;
        int powerSupplySize = 4;
        int infiniBandSize = 2;
        int gigabitSwitchSize = 2;
        int tenGPassThruSize = 2;
        if (guid != null && IPMIMessagingCommand.isCMMGUID(guid)) {
            bladeSize = guid[8];
            cmmModuleSize = guid[9];
            powerSupplySize = guid[10];
            infiniBandSize = guid[11];
            gigabitSwitchSize = guid[12];
        }
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
        this.blades = new BladeEntity[bladeSize];
        this.mbSensors = new AbstractMBSensorEntity[bladeSize];
        this.cmmModules = new CMMModuleEntity[cmmModuleSize];
        this.gigabitSwitchs = new GigabitSwitchEntity[gigabitSwitchSize];
        this.infiniBands = new InfiniBandEntity[infiniBandSize];
        this.powerSupplies = new PowerSupplyEntity[powerSupplySize];
        this.tenGPassThrus = new TenGPassThruEntity[tenGPassThruSize];
        for (i = 0; i < bladeSize; ++i) {
            this.blades[i] = new BladeEntity();
            this.blades[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < cmmModuleSize; ++i) {
            this.cmmModules[i] = new CMMModuleEntity();
            this.cmmModules[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < gigabitSwitchSize; ++i) {
            this.gigabitSwitchs[i] = new GigabitSwitchEntity();
            this.gigabitSwitchs[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < infiniBandSize; ++i) {
            this.infiniBands[i] = new InfiniBandEntity();
            this.infiniBands[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < powerSupplySize; ++i) {
            this.powerSupplies[i] = new PowerSupplyEntity();
            this.powerSupplies[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < tenGPassThruSize; ++i) {
            this.tenGPassThrus[i] = new TenGPassThruEntity();
            this.tenGPassThrus[i].setModuleIndex(i + 1);
        }
        this.frontLED = new FrontLEDEntity();
    }

    public BladeSystemEntity(IPMIInterfaceConfig ipmiInterfaceConfig, int bladeSize, int cmmModuleSize, int gigabitSwitchSize, int infiniBandSize, int powerSupplySize) {
        int i;
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
        this.blades = new BladeEntity[bladeSize];
        this.mbSensors = new AbstractMBSensorEntity[bladeSize];
        this.cmmModules = new CMMModuleEntity[cmmModuleSize];
        this.gigabitSwitchs = new GigabitSwitchEntity[gigabitSwitchSize];
        this.infiniBands = new InfiniBandEntity[infiniBandSize];
        this.powerSupplies = new PowerSupplyEntity[powerSupplySize];
        for (i = 0; i < bladeSize; ++i) {
            this.blades[i] = new BladeEntity();
            this.blades[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < cmmModuleSize; ++i) {
            this.cmmModules[i] = new CMMModuleEntity();
            this.cmmModules[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < gigabitSwitchSize; ++i) {
            this.gigabitSwitchs[i] = new GigabitSwitchEntity();
            this.gigabitSwitchs[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < infiniBandSize; ++i) {
            this.infiniBands[i] = new InfiniBandEntity();
            this.infiniBands[i].setModuleIndex(i + 1);
        }
        for (i = 0; i < powerSupplySize; ++i) {
            this.powerSupplies[i] = new PowerSupplyEntity();
            this.powerSupplies[i].setModuleIndex(i + 1);
        }
        this.frontLED = new FrontLEDEntity();
    }

    public void addObserver(Observer o) {
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] [AddObserver] " + o.getClass().getName());
        }
        super.addObserver(o);
    }

    public void poolingData() {
        TimerTask t = new TimerTask(){

            public void run() {
                try {
                    BladeSystemEntity.this.getData();
                }
                catch (Exception ex) {
                    System.out.println("An exception occured in poolingData " + ex.toString());
                    ex.printStackTrace();
                }
            }
        };
        this.poolingTimer = new Timer();
        this.poolingTimer.schedule(t, 0L, (long)(this.poolingInterval * 1000));
    }

    public void stopPooling() {
        if (this.poolingTimer != null) {
            this.poolingTimer.cancel();
            this.poolingTimer = null;
        }
    }

    public void addDisconnectListener(DisconnectListener l) {
        this.disconnectListeners.add(l);
    }

    public void removeDisconnectListener(DisconnectListener l) {
        this.disconnectListeners.remove(l);
    }

    public void removeallDisconnectListener() {
        this.disconnectListeners.clear();
    }

    public void notifyDisconnectListener() {
        for (DisconnectListener item : this.disconnectListeners) {
            item.disconnect(this);
        }
    }

    private boolean helpLogin() {
        this.sessionController = IPMIVersion.getSessionController(this.ipmiInterfaceConfig);
        this.ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        if (this.sessionController == null) {
            return false;
        }
        IPMINetworkInterface rmcp = this.sessionController.startup(this.ipmiInterfaceConfig);
        if (rmcp == null) {
            return false;
        }
        this.ipmiCMMOEMCommand.setIPMIInterface(rmcp);
        return true;
    }

    private boolean helpLogout() {
        return this.sessionController.closeSession();
    }

    private void delayForDebug() {
    }

    public synchronized void getData() {
        this.helpGetData();
        this.notifyUI();
    }

    private void helpGetData() {
        IPMIMessage resMessage;
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 0.Start query");
        }
        ++this.countOfGetData;
        this.isLoginSuccessful = false;
        this.isBladeEntityAvailable = false;
        this.isCMMModuleEntityAvailable = false;
        this.isGigabitSwitchEntityAvailable = false;
        this.isInfiniBandEntityAvailable = false;
        this.isPowerSupplyEntityAvailable = false;
        this.isMBSensorEntityAvailable = false;
        this.isFrontLEDEntityAvailable = false;
        this.isLogoutSuccessful = false;
        Calendar cStart = Calendar.getInstance();
        if (this.useExistConnection) {
            this.isLoginSuccessful = true;
        } else {
            boolean result = false;
            for (int count = 0; count != 2; ++count) {
                result = this.helpLogin();
                if (!result) continue;
            }
            if (!result) {
                this.isLoginSuccessful = false;
                this.notifyDisconnectListener();
                return;
            }
            this.isLoginSuccessful = true;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 0.Login");
        }
        if (this.isQueryBladeEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)1);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachBlade(resMessage.data);
                    this.isBladeEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 1.get Blade ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryCMMModuleEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)2);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachCMMModule(resMessage.data);
                    this.isCMMModuleEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 2.CMMModule ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryPowerSupplyEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)3);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachPowerSupplyModule(resMessage.data);
                    this.isPowerSupplyEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 3.Power Supply ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryGigabitSwitchEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)4);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachGigabitSwitchModule(resMessage.data);
                    this.isGigabitSwitchEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 4.Gigabit ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryInfiniBandEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)5);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachInfiniBandModule(resMessage.data);
                    this.isInfiniBandEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 5.Infiniband ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryMBSensorEntity) {
            for (int i = 0; i < this.blades.length; ++i) {
                if (this.mbSensors[i] != null && MBSensorEntityFactory.checkMBSensorType(this.blades[i].getMBModel(), this.mbSensors[i])) continue;
                this.mbSensors[i] = MBSensorEntityFactory.createAbstractMBSensorEntity(this.blades[i].getMBModel());
                this.mbSensors[i].setModuleIndex(i + 1);
            }
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)6);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachMBSensor(resMessage.data);
                    this.isMBSensorEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 6.MB Sensors ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryFrontLEDEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)7);
            if (resMessage != null) {
                if (resMessage.completionCode == 0 && resMessage.data.length == 2) {
                    this.frontLED.fromRaw(resMessage.data);
                    this.isFrontLEDEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 7.get front panel ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryFanControlMode) {
            resMessage = this.ipmiCMMOEMCommand.getFanControlModeCommand();
            if (resMessage != null && resMessage.completionCode == 0) {
                this.fanControlMode = resMessage.data[0];
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 8.fan control mode ok");
            }
            this.delayForDebug();
        }
        if (this.isGetPowerConsumptionStatus) {
            try {
                this.powerConsumptionStatus = this.ipmiCMMOEMCommand.getPowerConsumptionStatus();
            }
            catch (IPMIException ex) {
            }
            catch (ArrayIndexOutOfBoundsException exa) {
                // empty catch block
            }
        }
        this.tempTestHere();
        if (!this.ifCheckOnlyOneTime) {
            this.helpCheckWhichCMMWeConnected(this.ipmiCMMOEMCommand);
            this.helpCheckIsSupportIPMB(this.ipmiCMMOEMCommand);
            this.ifCheckOnlyOneTime = true;
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 9.one time query ok");
            }
            this.delayForDebug();
        }
        this.checkIsMaster();
        this.isLogoutSuccessful = this.useExistConnection ? true : this.helpLogout();
        if (!this.isLogoutSuccessful) {
            this.notifyDisconnectListener();
            return;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 10.logout ok");
        }
        this.delayForDebug();
        if (this.debug) {
            this.debugMessage();
        }
        Calendar cMiddle = Calendar.getInstance();
        if (this.isGenerateFailureReport) {
            this.generateFailureReport();
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 11.generfailure report ok");
            }
            this.delayForDebug();
        }
        Calendar cEnd = Calendar.getInstance();
        double time1 = cMiddle.getTimeInMillis() - cStart.getTimeInMillis();
        String queryTimeStr = " Query  = " + time1 / 1000.0;
        StringBuffer sb = new StringBuffer();
        sb.append("Login:" + (this.isLoginSuccessful ? "OK" : "X"));
        sb.append(", Blade:" + (this.isBladeEntityAvailable ? "OK" : "X"));
        sb.append(", CMM:" + (this.isCMMModuleEntityAvailable ? "OK" : "X"));
        sb.append(", GB:" + (this.isGigabitSwitchEntityAvailable ? "OK" : "X"));
        sb.append(", IB:" + (this.isInfiniBandEntityAvailable ? "OK" : "X"));
        sb.append(", PW:" + (this.isPowerSupplyEntityAvailable ? "OK" : "X"));
        sb.append(", MBSensor:" + (this.isMBSensorEntityAvailable ? "OK" : "X"));
        sb.append(", FrontLED:" + (this.isFrontLEDEntityAvailable ? "OK" : "X"));
        sb.append(", Logout:" + (this.isLoginSuccessful ? "O" : "X"));
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 12.done");
        }
    }

    private void tempTestHere() {
    }

    public void checkB7DCE_SIMBL_Is_ExistViaIPMB() {
        for (int i = 0; i < this.blades.length; ++i) {
            boolean result;
            if (!this.getIsMaster() || this.blades[i].getPresent() == 0 || !this.checkMB(this.blades[i].getMBModel()) || this.blades[i].isV3_3v() || !this.blades[i].isSimCardDetectPin() || !this.isSupportIPMB || (result = this.getSIMBLIPViaIPMB((byte)(i + 1)))) continue;
            this.blades[i].setSimCardDetectPin(true);
        }
    }

    private boolean checkMB(byte mbModel) {
        return mbModel == 3 || mbModel == 4;
    }

    private boolean getSIMBLIPViaIPMB(byte moduleIndex) {
        boolean result = false;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, ipmiLanCommand);
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel(moduleIndex);
        if (sessionController != null) {
            String ip = ipmiLanCommand.getIP();
            if (ip != null) {
                result = true;
            }
            sessionController.closeSession();
        }
        return result;
    }

    public void checkIsMaster() {
        this.isMaster = false;
        for (int i = 0; i < this.cmmModules.length; ++i) {
            if (!this.cmmModules[i].isConnected()) continue;
            this.isMaster = this.cmmModules[i].getMasterSlave() == 0;
            return;
        }
    }

    private void helpCheckWhichCMMWeConnected(IPMICMMOEMCommand ipmiCMMOEMCommand) {
        int slot = 0;
        try {
            slot = ipmiCMMOEMCommand.getCMMSlot();
            this.cmmModules[slot].setConnected(true);
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
    }

    private void helpCheckIsSupportIPMB(IPMICMMOEMCommand ipmiCMMOEMCommand) {
        try {
            this.isSupportIPMB = ipmiCMMOEMCommand.isCMMSupportIPMB();
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
    }

    private void notifyUI() {
        if (!this.isLoginSuccessful || !this.isLogoutSuccessful) {
            return;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 13.Start Notify");
        }
        Calendar cStart = Calendar.getInstance();
        this.setChanged();
        this.notifyObservers();
        Calendar cEnd = Calendar.getInstance();
        double time = cEnd.getTimeInMillis() - cStart.getTimeInMillis();
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 14.End Notify  Notify(" + this.countObservers() + ") = " + time / 1000.0 + "secs");
        }
    }

    private void debugMessage() {
        int i;
        System.out.println("query count =" + this.queryCount++);
        for (i = 0; i < this.blades.length; ++i) {
            System.out.print("================Start  Blade (" + (i + 1) + ")================");
            System.out.println(this.blades[i].toString());
            System.out.println("================End Blade (" + (i + 1) + ")================");
        }
        for (i = 0; i < this.cmmModules.length; ++i) {
            System.out.println("================Start CMM Module (" + (i + 1) + ")================");
            System.out.println(this.cmmModules[i].toString());
            System.out.println("================End CMM Module (" + (i + 1) + ")================");
        }
        for (i = 0; i < this.powerSupplies.length; ++i) {
            System.out.println("================Start Power Supply (" + (i + 1) + ")================");
            System.out.println(this.powerSupplies[i].toString());
            System.out.println("================End Power Supply (" + (i + 1) + ")================");
        }
        for (i = 0; i < this.gigabitSwitchs.length; ++i) {
            System.out.println("================Start gigabit switch (" + (i + 1) + ")================");
            System.out.println(this.gigabitSwitchs[i].toString());
            System.out.println("================End gigabit switch (" + (i + 1) + ")================");
        }
        for (i = 0; i < this.infiniBands.length; ++i) {
            System.out.println("================Start InfiniBand (" + (i + 1) + ")================");
            System.out.println(this.infiniBands[i].toString());
            System.out.println("================End InfiniBand (" + (i + 1) + ")================");
        }
    }

    private void divideDataForEachBlade(byte[] raw) {
        if (raw.length != this.blades.length * 18) {
            return;
        }
        for (int i = 0; i < this.blades.length; ++i) {
            byte[] aRaw = new byte[18];
            System.arraycopy(raw, i * 18, aRaw, 0, 18);
            this.blades[i].fromRaw(aRaw);
        }
    }

    private void divideDataForEachCMMModule(byte[] raw) {
        if (raw.length != this.cmmModules.length * 11) {
            return;
        }
        for (int i = 0; i < this.cmmModules.length; ++i) {
            byte[] aRaw = new byte[11];
            System.arraycopy(raw, i * 11, aRaw, 0, 11);
            this.cmmModules[i].fromRaw(aRaw);
        }
    }

    private void divideDataForEachPowerSupplyModule(byte[] raw) {
        if (raw.length != this.powerSupplies.length * 34) {
            return;
        }
        for (int i = 0; i < this.powerSupplies.length; ++i) {
            byte[] aRaw = new byte[34];
            System.arraycopy(raw, i * 34, aRaw, 0, 34);
            this.powerSupplies[i].fromRaw(aRaw);
        }
    }

    private void divideDataForEachGigabitSwitchModule(byte[] raw) {
        if (raw.length != this.gigabitSwitchs.length * 19) {
            return;
        }
        for (int i = 0; i < this.gigabitSwitchs.length; ++i) {
            byte[] aRaw = new byte[19];
            System.arraycopy(raw, i * 19, aRaw, 0, 19);
            this.gigabitSwitchs[i].fromRaw(aRaw);
        }
    }

    private void divideDataForEachInfiniBandModule(byte[] raw) {
        if (raw.length != this.infiniBands.length * 22) {
            return;
        }
        for (int i = 0; i < this.infiniBands.length; ++i) {
            byte[] aRaw = new byte[22];
            System.arraycopy(raw, i * 22, aRaw, 0, 22);
            this.infiniBands[i].fromRaw(aRaw);
            this.tenGPassThrus[i].fromRaw(aRaw);
        }
    }

    private void divideDataForEachMBSensor(byte[] raw) {
        if (raw.length != this.mbSensors.length * 35) {
            return;
        }
        for (int i = 0; i < this.mbSensors.length; ++i) {
            byte[] aRaw = new byte[35];
            System.arraycopy(raw, i * 35, aRaw, 0, 35);
            this.mbSensors[i].fromRaw(aRaw);
        }
    }

    public void setEnableAllQuery(boolean enable) {
        this.isQueryBladeEntity = enable;
        this.isQueryCMMModuleEntity = enable;
        this.isQueryGigabitSwitchEntity = enable;
        this.isQueryInfiniBandEntity = enable;
        this.isQueryPowerSupplyEntity = enable;
        this.isQueryMBSensorEntity = enable;
        this.isQueryFrontLEDEntity = enable;
        this.isQueryFanControlMode = enable;
        this.isGenerateFailureReport = enable;
        this.isGetPowerConsumptionStatus = enable;
    }

    private byte[] getPCA9xxxSlaveAddresses() {
        int size = this.blades.length;
        byte[] slaveAddrs = null;
        boolean bladeCount = true;
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getPCA9xxxSlaveAddrCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            slaveAddrs = new byte[size];
            for (int i = 0; i < size; ++i) {
                slaveAddrs[i] = resMessage.data[i * 11];
            }
        }
        return slaveAddrs;
    }

    private Vector getPCA955Infos(byte index) {
        int i;
        Vector<byte[]> PCA9555Infos = null;
        if (!this.helpLogin()) {
            return null;
        }
        byte[] slaveAddrs = this.getPCA9xxxSlaveAddresses();
        if (slaveAddrs == null) {
            System.out.println("Get PCA9xxx Slave Addresses failed!");
            System.out.println("Use 0x40 as the slave address.");
            slaveAddrs = new byte[this.blades.length];
            for (i = 0; i < slaveAddrs.length; ++i) {
                slaveAddrs[i] = 32;
            }
        }
        PCA9555Infos = new Vector<byte[]>(this.blades.length);
        if (index == 0) {
            for (i = 0; i < this.blades.length; ++i) {
                byte slaveAddr = (byte)(slaveAddrs[i] * 2);
                IPMIMessage resMessage = this.ipmiCMMOEMCommand.getPCA9xxxInfoCommand((byte)(i + 1), slaveAddr);
                if (resMessage == null || resMessage.completionCode != 0) continue;
                PCA9555Infos.add(resMessage.data);
            }
        } else {
            byte slaveAddr = (byte)(slaveAddrs[index - 1] * 2);
            IPMIMessage resMessage = this.ipmiCMMOEMCommand.getPCA9xxxInfoCommand(index, slaveAddr);
            if (resMessage != null && resMessage.completionCode == 0) {
                PCA9555Infos.add(resMessage.data);
            }
        }
        this.helpLogout();
        return PCA9555Infos;
    }

    private Vector getPCA955statistics() {
        Vector<byte[]> statistics = null;
        if (!this.helpLogin()) {
            return null;
        }
        statistics = new Vector<byte[]>(this.blades.length);
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getPCA955StatisticCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            for (int i = 0; i < this.blades.length; ++i) {
                byte[] aRaw = new byte[6];
                System.arraycopy(resMessage.data, i * 6, aRaw, 0, 6);
                statistics.add(aRaw);
            }
        }
        this.helpLogout();
        return statistics;
    }

    public void generateFailureReport() {
        int i;
        this.failures.clear();
        for (i = 0; i < this.blades.length; ++i) {
            BladeEntity bladeEntity = this.blades[i];
            AbstractMBSensorEntity mbSensor = this.mbSensors[i];
            if (bladeEntity.getPresent() == 0) continue;
            if (bladeEntity.isError1LED()) {
                this.failures.add(this.generateBladeErrorLEDFailure(bladeEntity, i));
            }
            if (bladeEntity.getI2cError() != 0) {
                // empty if block
            }
            this.failures.addAll(mbSensor.generateFailureReport(bladeEntity, i));
        }
        for (i = 0; i < this.powerSupplies.length; ++i) {
            PowerSupplyEntity powerSupplyEntity = this.powerSupplies[i];
            if (powerSupplyEntity.getPresent() == 0 || powerSupplyEntity.getStatus() == 0) continue;
            if (powerSupplyEntity.getStatus() == 2) {
                this.failures.add(this.generatePowerSupplyPowerFailure(powerSupplyEntity, i));
            }
            if (powerSupplyEntity.getI2cError() != 0) {
                // empty if block
            }
            int fan1RPM = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan1Speed());
            int fan1RPMLimit = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan1SpeedLowLimit());
            int fan2RPM = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan2Speed());
            int fan2RPMLimit = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan2SpeedLowLimit());
            int fan3RPM = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan3Speed());
            int fan3RPMLimit = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan3SpeedLowLimit());
            int fan4RPM = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan4Speed());
            int fan4RPMLimit = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan4SpeedLowLimit());
            byte temp = powerSupplyEntity.getTemperature();
            byte tempLimit = powerSupplyEntity.getTemperatureHighLimit();
            if (fan1RPM <= fan1RPMLimit) {
                this.failures.add(this.generatePowerSupplyFanFailure(powerSupplyEntity, i, 1, fan1RPM, fan1RPMLimit));
            }
            if (fan2RPM <= fan2RPMLimit) {
                this.failures.add(this.generatePowerSupplyFanFailure(powerSupplyEntity, i, 2, fan2RPM, fan2RPMLimit));
            }
            if (fan3RPM <= fan3RPMLimit && powerSupplyEntity.getNumOfFans() == 4) {
                this.failures.add(this.generatePowerSupplyFanFailure(powerSupplyEntity, i, 3, fan3RPM, fan3RPMLimit));
            }
            if (fan4RPM <= fan4RPMLimit && powerSupplyEntity.getNumOfFans() == 4) {
                this.failures.add(this.generatePowerSupplyFanFailure(powerSupplyEntity, i, 4, fan4RPM, fan4RPMLimit));
            }
            if (temp >= tempLimit) {
                this.failures.add(this.generatePowerSupplyTemperatureFailure(powerSupplyEntity, i, temp, tempLimit));
            }
            if (powerSupplyEntity.getDcCurrentLimit() != 0 && (double)powerSupplyEntity.getDcOuputCurrentFormula() > powerSupplyEntity.getDcCurrentLimitFormula()) {
                this.failures.add(this.generatePowerSupplyCurrentFailure(powerSupplyEntity, i, "DC"));
            }
            if (powerSupplyEntity.getAcCurrentLimit() == 0 || !(powerSupplyEntity.getAcRMSCurrentFormula() > powerSupplyEntity.getAcCurrentLimitFormula())) continue;
            this.failures.add(this.generatePowerSupplyCurrentFailure(powerSupplyEntity, i, "AC RMS"));
        }
        for (i = 0; i < this.gigabitSwitchs.length; ++i) {
            GigabitSwitchEntity gigabitSwitchEntity = this.gigabitSwitchs[i];
            if (gigabitSwitchEntity.getPresent() == 0 || !gigabitSwitchEntity.isPowerOn() || gigabitSwitchEntity.getP1v25() == 0 || gigabitSwitchEntity.getP2v5() == 0 || (gigabitSwitchEntity.getFlag() & 1) == 1) continue;
            if (gigabitSwitchEntity.isError()) {
                this.failures.add(this.generateSwitchErrorLEDFailure(gigabitSwitchEntity, i));
            }
            if (gigabitSwitchEntity.getInitialized() == 0) {
                this.failures.add(this.generateSwitchInitializedFailure(gigabitSwitchEntity, i));
            }
            if (gigabitSwitchEntity.getBoardTemperature() >= 80) {
                // empty if block
            }
            if (gigabitSwitchEntity.getSwitchTemperature() >= 80) {
                this.failures.add(this.generateSwitchTemperatureFailure(gigabitSwitchEntity, i, "Chip Temperature", "Chip temperature out of range "));
            }
            double p2v5 = gigabitSwitchEntity.p2v5Formula();
            double p2v5LowLimit = 2.25;
            double p2v5HighLimit = 2.75;
            double p1v25 = gigabitSwitchEntity.p1v25Formula();
            double p1v25LowLimit = 1.025;
            double p1v25HighLimit = 1.375;
            if (p2v5 <= p2v5LowLimit || p2v5 >= p2v5HighLimit) {
                this.failures.add(this.generateSwitchVoltageFailure(gigabitSwitchEntity, i, "2.5V", "2.5V out of range"));
            }
            if (p1v25 <= p1v25LowLimit || p1v25 >= p1v25HighLimit) {
                this.failures.add(this.generateSwitchVoltageFailure(gigabitSwitchEntity, i, "1.25V", "1.25V out of range"));
            }
            if (gigabitSwitchEntity.getI2cError() == 0) continue;
        }
        for (i = 0; i < this.cmmModules.length; ++i) {
            CMMModuleEntity cmmModuleEntity = this.cmmModules[i];
            if (cmmModuleEntity.getPresent() == 0 || cmmModuleEntity.getStatus() == 0) continue;
            this.failures.add(this.generateCMMStatusFailure(cmmModuleEntity, i));
        }
        for (i = 0; i < this.infiniBands.length; ++i) {
            InfiniBandEntity infiniBandEntity = this.infiniBands[i];
            if (infiniBandEntity.getPresent() == 0 || !infiniBandEntity.isPowerOn()) continue;
            if (infiniBandEntity.getInitialized() == 0) {
                this.failures.add(this.generateIBInitializedFailure(infiniBandEntity, i));
            }
            if (infiniBandEntity.getTemperature() >= 80) {
                this.failures.add(this.generateIBTemperatureFailure(infiniBandEntity, i, "Temperature", "Chip temperature out of range "));
            }
            double v33Aux = infiniBandEntity.getV33AuxFormula();
            double v33AuxLogLimit = 2.9699999999999998;
            double v33AuxHighLimit = 3.63;
            double vvdd = infiniBandEntity.getVvddFormula();
            double vvddLogLimit = 1.4400000000000002;
            double vvddHighLimit = 1.7600000000000002;
            double v33 = infiniBandEntity.getV33Formula();
            double v33LogLimit = 2.9699999999999998;
            double v33HighLimit = 3.63;
            double v18 = infiniBandEntity.getV18Formula();
            double v18LogLimit = 1.62;
            double v18HighLimit = 1.9800000000000002;
            double v12 = infiniBandEntity.getV12Formula();
            double v12LogLimit = 1.08;
            double v12HighLimit = 1.32;
            if (v33Aux <= v33AuxLogLimit || v33Aux >= v33AuxHighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i, "3.3V Aux", "3.3V Aux out of range"));
            }
            if (vvdd <= vvddLogLimit || vvdd >= vvddHighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i, "VVDD", "VVDD out of range"));
            }
            if (v33 <= v33LogLimit || v33 >= v33HighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i, "3.3V ", "3.3V out of range"));
            }
            if (v18 <= v18LogLimit || v18 >= v18HighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i, "1.8V ", "1.8V out of range"));
            }
            if (v12 <= v12LogLimit || v12 >= v12HighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i, "1.2V ", "1.2V out of range"));
            }
            if (infiniBandEntity.getI2cError() == 0) continue;
        }
        for (i = 0; i < this.tenGPassThrus.length; ++i) {
            TenGPassThruEntity tenGPassThruEntity = this.tenGPassThrus[i];
            if (tenGPassThruEntity.getPresent() == 0 || tenGPassThruEntity.getType() != 1) continue;
            if (tenGPassThruEntity.getTemp_1v25() >= 80) {
                this.failures.add(this.generate10GTemperatureFailure(tenGPassThruEntity, i, "Temperature", "Temp. VR1.25V temperature out of range "));
            }
            if (tenGPassThruEntity.getTemp_3v3() >= 80) {
                this.failures.add(this.generate10GTemperatureFailure(tenGPassThruEntity, i, "Temperature", "Temp. VR3.3V temperature out of range "));
            }
            double v33 = tenGPassThruEntity.getVram_3v3Formula();
            double v33LogLimit = 2.9699999999999998;
            double v33HighLimit = 3.63;
            double v12 = tenGPassThruEntity.getVcore_1v2Formula();
            double v12LogLimit = 1.08;
            double v12HighLimit = 1.32;
            if (v33 <= v33LogLimit || v33 >= v33HighLimit) {
                this.failures.add(this.generate10GVoltageFailure(tenGPassThruEntity, i, "3.3V", "3.3V out of range"));
            }
            if (v12 <= v12LogLimit || v12 >= v12HighLimit) {
                this.failures.add(this.generate10GVoltageFailure(tenGPassThruEntity, i, "1.2V", "1.2V out of range"));
            }
            if (tenGPassThruEntity.getI2cError() == 0) continue;
        }
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d;
    }

    private FailureEntity generateBladePowerFailure(BladeEntity bladeEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(bladeEntity);
        failureEntity.setSource("Blade " + (moduleIndex + 1));
        failureEntity.setFailureItem("Power");
        failureEntity.setFailureDetail(L.t("cmm.error.Power_Failure"));
        return failureEntity;
    }

    private FailureEntity generateBladeSensorFailure(BladeEntity bladeEntity, int moduleIndex, String sensor) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(bladeEntity);
        failureEntity.setSource("Blade " + (moduleIndex + 1));
        failureEntity.setFailureItem(sensor);
        failureEntity.setFailureDetail(L.t("cmm.error.Reading_out_of_range"));
        return failureEntity;
    }

    private FailureEntity generateBladeErrorLEDFailure(BladeEntity bladeEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(bladeEntity);
        failureEntity.setSource("Blade " + (moduleIndex + 1));
        failureEntity.setFailureItem(L.t("cmm.error.Error_LED"));
        failureEntity.setFailureDetail(L.t("cmm.error.Error"));
        return failureEntity;
    }

    private FailureEntity generatePowerSupplyPowerFailure(PowerSupplyEntity powerSupplyEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(powerSupplyEntity);
        failureEntity.setSource("Power Supply " + (moduleIndex + 1));
        failureEntity.setFailureItem("Power Supply");
        failureEntity.setFailureDetail(L.t("cmm.error.Power_supply_power_failure"));
        return failureEntity;
    }

    private FailureEntity generatePowerSupplyFanFailure(PowerSupplyEntity powerSupplyEntity, int moduleIndex, int fanIndex, int fanRPM, int fanLowLimitRPM) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(powerSupplyEntity);
        failureEntity.setSource("Power Supply " + (moduleIndex + 1));
        if (fanIndex == 1 || fanIndex == 2) {
            failureEntity.setFailureItem(L.t("cmm.error.Fan") + " " + fanIndex);
            failureEntity.setFailureDetail(L.t("cmm.error.Fan_speed_out_of_range") + " ");
        } else {
            failureEntity.setFailureItem("Fan set");
            failureEntity.setFailureDetail(L.t("cmm.error.Fan_speed_out_of_range") + " ");
        }
        return failureEntity;
    }

    private FailureEntity generatePowerSupplyTemperatureFailure(PowerSupplyEntity powerSupplyEntity, int moduleIndex, int temp, int tempHighLimit) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(powerSupplyEntity);
        failureEntity.setSource("Power Supply " + (moduleIndex + 1));
        failureEntity.setFailureItem(L.t("cmm.error.Temperature") + " ");
        failureEntity.setFailureDetail(L.t("cmm.error.Temperature_out_of_range") + " ");
        return failureEntity;
    }

    private FailureEntity generatePowerSupplyCurrentFailure(PowerSupplyEntity powerSupplyEntity, int moduleIndex, String currentType) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(powerSupplyEntity);
        failureEntity.setSource("Power Supply " + (moduleIndex + 1));
        failureEntity.setFailureItem(currentType);
        failureEntity.setFailureDetail(currentType + " " + L.t("cmm.error.out_of_range"));
        return failureEntity;
    }

    private FailureEntity generateSwitchErrorLEDFailure(GigabitSwitchEntity gigabitSwitchEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(gigabitSwitchEntity);
        failureEntity.setSource("Gigabit Switch " + (moduleIndex + 1));
        failureEntity.setFailureItem(L.t("cmm.error.Error_LED"));
        failureEntity.setFailureDetail(L.t("cmm.error.Error"));
        return failureEntity;
    }

    private FailureEntity generateSwitchInitializedFailure(GigabitSwitchEntity gigabitSwitchEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(gigabitSwitchEntity);
        failureEntity.setSource("Gigabit Switch " + (moduleIndex + 1));
        failureEntity.setFailureItem("Gigabit Switch");
        failureEntity.setFailureDetail(L.t("cmm.error.Initialized_Failed"));
        return failureEntity;
    }

    private FailureEntity generateSwitchVoltageFailure(GigabitSwitchEntity gigabitSwitchEntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(gigabitSwitchEntity);
        failureEntity.setSource("Gigabit Switch " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateSwitchTemperatureFailure(GigabitSwitchEntity gigabitSwitchEntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(gigabitSwitchEntity);
        failureEntity.setSource("Gigabit Switch " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateCMMStatusFailure(CMMModuleEntity cmmModuleEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(cmmModuleEntity);
        failureEntity.setSource("CMM " + (moduleIndex + 1));
        failureEntity.setFailureItem("CMM");
        failureEntity.setFailureDetail(L.t("cmm.error.failure"));
        return failureEntity;
    }

    private FailureEntity generateI2CFailure(Object moduleEntity, String moduleName, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(1);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(moduleEntity);
        failureEntity.setSource(moduleName + " " + (moduleIndex + 1));
        failureEntity.setFailureItem(moduleName);
        failureEntity.setFailureDetail(L.t("cmm.error.I2C_communcation_failed"));
        return failureEntity;
    }

    private FailureEntity generateIBInitializedFailure(InfiniBandEntity infiniBandEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(infiniBandEntity);
        failureEntity.setSource("InfiniBand " + (moduleIndex + 1));
        failureEntity.setFailureItem("InfiniBand");
        failureEntity.setFailureDetail(L.t("cmm.error.Initialized_Failed"));
        return failureEntity;
    }

    private FailureEntity generateIBVoltageFailure(InfiniBandEntity infiniBandEntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(infiniBandEntity);
        failureEntity.setSource("InfiniBand " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateIBTemperatureFailure(InfiniBandEntity infiniBandEntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(infiniBandEntity);
        failureEntity.setSource("InfiniBand " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generate10GTemperatureFailure(TenGPassThruEntity tenGPassThruEntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(tenGPassThruEntity);
        failureEntity.setSource("10G Pass Thru " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generate10GVoltageFailure(TenGPassThruEntity tenGPassThruEntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(tenGPassThruEntity);
        failureEntity.setSource("10G Pass Thru " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    public String getDataTimeString() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
        return f.format(date);
    }

    public BladeEntity[] getBlades() {
        return this.blades;
    }

    public CMMModuleEntity[] getCmmModules() {
        return this.cmmModules;
    }

    public GigabitSwitchEntity[] getGigabitSwitchs() {
        return this.gigabitSwitchs;
    }

    public InfiniBandEntity[] getInfiniBands() {
        return this.infiniBands;
    }

    public PowerSupplyEntity[] getPowerSupplies() {
        return this.powerSupplies;
    }

    public TenGPassThruEntity[] getTenGPassThrus() {
        return this.tenGPassThrus;
    }

    public int getPoolingInterval() {
        return this.poolingInterval;
    }

    public ArrayList getFailures() {
        return this.failures;
    }

    public AbstractMBSensorEntity[] getMbSensors() {
        return this.mbSensors;
    }

    public FrontLEDEntity getFrontLED() {
        return this.frontLED;
    }

    public boolean isIsBladeEntityAvailable() {
        return this.isBladeEntityAvailable;
    }

    public boolean isIsCMMModuleEntityAvailable() {
        return this.isCMMModuleEntityAvailable;
    }

    public boolean isIsFrontLEDEntityAvailable() {
        return this.isFrontLEDEntityAvailable;
    }

    public boolean isIsGigabitSwitchEntityAvailable() {
        return this.isGigabitSwitchEntityAvailable;
    }

    public boolean isIsInfiniBandEntityAvailable() {
        return this.isInfiniBandEntityAvailable;
    }

    public boolean isIsLoginSuccessful() {
        return this.isLoginSuccessful;
    }

    public boolean isIsLogoutSuccessful() {
        return this.isLogoutSuccessful;
    }

    public boolean isIsMBSensorEntityAvailable() {
        return this.isMBSensorEntityAvailable;
    }

    public boolean isIsPowerSupplyEntityAvailable() {
        return this.isPowerSupplyEntityAvailable;
    }

    public byte getFanControlMode() {
        return this.fanControlMode;
    }

    public boolean isIsSupportIPMB() {
        return this.isSupportIPMB;
    }

    public boolean getIsMaster() {
        return this.isMaster;
    }

    public boolean isUseExistConnection() {
        return this.useExistConnection;
    }

    public IPMICMMOEMCommand.PowerConsumptionStatus getPowerConsumptionStatus() {
        return this.powerConsumptionStatus;
    }

    public boolean isIfCheckOnlyOneTime() {
        return this.ifCheckOnlyOneTime;
    }

    public void setPoolingInterval(int poolingInterval) {
        this.poolingInterval = poolingInterval;
    }

    public void setIsQueryBladeEntity(boolean isQueryBladeEntity) {
        this.isQueryBladeEntity = isQueryBladeEntity;
    }

    public void setIsQueryCMMModuleEntity(boolean isQueryCMMModuleEntity) {
        this.isQueryCMMModuleEntity = isQueryCMMModuleEntity;
    }

    public void setIsQueryFanControlMode(boolean isQueryFanControlMode) {
        this.isQueryFanControlMode = isQueryFanControlMode;
    }

    public void setIsQueryFrontLEDEntity(boolean isQueryFrontLEDEntity) {
        this.isQueryFrontLEDEntity = isQueryFrontLEDEntity;
    }

    public void setIsQueryGigabitSwitchEntity(boolean isQueryGigabitSwitchEntity) {
        this.isQueryGigabitSwitchEntity = isQueryGigabitSwitchEntity;
    }

    public void setIsQueryInfiniBandEntity(boolean isQueryInfiniBandEntity) {
        this.isQueryInfiniBandEntity = isQueryInfiniBandEntity;
    }

    public void setIsQueryMBSensorEntity(boolean isQueryMBSensorEntity) {
        this.isQueryMBSensorEntity = isQueryMBSensorEntity;
    }

    public void setIsQueryPowerSupplyEntity(boolean isQueryPowerSupplyEntity) {
        this.isQueryPowerSupplyEntity = isQueryPowerSupplyEntity;
    }

    public void setIsGenerateFailureReport(boolean isGenerateFailureReport) {
        this.isGenerateFailureReport = isGenerateFailureReport;
    }

    public void setUseExistConnection(boolean useExistConnection) {
        this.useExistConnection = useExistConnection;
    }

    public void setIpmiCMMOEMCommand(IPMICMMOEMCommand ipmiCMMOEMCommand) {
        this.ipmiCMMOEMCommand = ipmiCMMOEMCommand;
    }

    public void setIfCheckOnlyOneTime(boolean ifCheckOnlyOneTime) {
        this.ifCheckOnlyOneTime = ifCheckOnlyOneTime;
    }

    public void presentAllForTest() {
        int i;
        for (i = 0; i < this.blades.length; ++i) {
            this.blades[i].setPresent((byte)1);
        }
        for (i = 0; i < this.cmmModules.length; ++i) {
            this.cmmModules[i].setPresent((byte)1);
        }
        for (i = 0; i < this.gigabitSwitchs.length; ++i) {
            this.gigabitSwitchs[i].setPresent((byte)1);
        }
        for (i = 0; i < this.infiniBands.length; ++i) {
            this.infiniBands[i].setPresent((byte)1);
        }
        for (i = 0; i < this.powerSupplies.length; ++i) {
            this.powerSupplies[i].setPresent((byte)1);
        }
    }

    public String toBladeFormatedString() {
        BladeEntity b;
        int i;
        StringBuffer sb = new StringBuffer();
        int bladeCount = 0;
        for (i = 0; i < this.getBlades().length; ++i) {
            b = this.getBlades()[i];
            if (b.getPresent() <= 0) continue;
            ++bladeCount;
        }
        if (bladeCount > 0) {
            sb.append("Blade Module (" + bladeCount + "/" + this.getBlades().length + ")\n");
            sb.append("--------------------\n");
            sb.append(this.getBlades()[0].toFormatedHeader());
            for (i = 0; i < this.getBlades().length; ++i) {
                b = this.getBlades()[i];
                sb.append(b.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toGigabitSwitchFormatedString() {
        GigabitSwitchEntity g;
        int i;
        StringBuffer sb = new StringBuffer();
        int gbCount = 0;
        for (i = 0; i < this.getGigabitSwitchs().length; ++i) {
            g = this.getGigabitSwitchs()[i];
            if (g.getPresent() <= 0) continue;
            ++gbCount;
        }
        if (gbCount > 0) {
            sb.append("Gigabit Switch Module (" + gbCount + "/" + this.getGigabitSwitchs().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getGigabitSwitchs()[0].toFormatedHeader());
            for (i = 0; i < this.getGigabitSwitchs().length; ++i) {
                g = this.getGigabitSwitchs()[i];
                sb.append(g.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toPowerSupplyFormatedString() {
        PowerSupplyEntity p;
        int i;
        StringBuffer sb = new StringBuffer();
        int powerCount = 0;
        for (i = 0; i < this.getPowerSupplies().length; ++i) {
            p = this.getPowerSupplies()[i];
            if (p.getPresent() <= 0) continue;
            ++powerCount;
        }
        if (powerCount > 0) {
            sb.append("Power Supply Module (" + powerCount + "/" + this.getPowerSupplies().length + ")\n");
            sb.append("--------------------------\n");
            sb.append(this.getPowerSupplies()[0].toFormatedHeader());
            for (i = 0; i < this.getPowerSupplies().length; ++i) {
                p = this.getPowerSupplies()[i];
                sb.append(p.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toInfiniBandFormatedString() {
        int i;
        StringBuffer sb = new StringBuffer();
        int ibCount = 0;
        for (i = 0; i < this.getInfiniBands().length; ++i) {
            InfiniBandEntity ib = this.getInfiniBands()[i];
            if (ib.getPresent() <= 0 || ib.getReserve3() != 0) continue;
            ++ibCount;
        }
        if (ibCount > 0) {
            sb.append("Infiniband Module (" + ibCount + "/" + this.getInfiniBands().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getInfiniBands()[0].toFormatedHeader());
            for (i = 0; i < this.getInfiniBands().length; ++i) {
                InfiniBandEntity e = this.getInfiniBands()[i];
                sb.append(e.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String to10gPassThruFormatedString() {
        int i;
        StringBuffer sb = new StringBuffer();
        int ten10gCount = 0;
        for (i = 0; i < this.getTenGPassThrus().length; ++i) {
            TenGPassThruEntity tenGPassThru = this.getTenGPassThrus()[i];
            if (tenGPassThru.getPresent() <= 0 || tenGPassThru.getType() != 1) continue;
            ++ten10gCount;
        }
        if (ten10gCount > 0) {
            sb.append("10G Pass Thru Module (" + ten10gCount + "/" + this.getTenGPassThrus().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getTenGPassThrus()[0].toFormatedHeader());
            for (i = 0; i < this.getTenGPassThrus().length; ++i) {
                TenGPassThruEntity e = this.getTenGPassThrus()[i];
                sb.append(e.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toCMMFormatedString() {
        int i;
        StringBuffer sb = new StringBuffer();
        int cmmCount = 0;
        for (i = 0; i < this.getCmmModules().length; ++i) {
            CMMModuleEntity cmm = this.getCmmModules()[i];
            if (cmm.getPresent() <= 0) continue;
            ++cmmCount;
        }
        if (cmmCount > 0) {
            sb.append("CMM Module(" + cmmCount + "/" + this.getCmmModules().length + ")\n");
            sb.append("----------------\n");
            sb.append(this.getCmmModules()[0].toFormatedHeader());
            for (i = 0; i < this.getCmmModules().length; ++i) {
                CMMModuleEntity e = this.getCmmModules()[i];
                sb.append(e.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toFormatedString() {
        StringBuffer sb = new StringBuffer();
        String s1 = this.toBladeFormatedString();
        String s2 = this.toGigabitSwitchFormatedString();
        String s3 = this.toPowerSupplyFormatedString();
        String s4 = this.to10gPassThruFormatedString();
        String s5 = this.toInfiniBandFormatedString();
        String s6 = this.toCMMFormatedString();
        sb.append(s1 + (s1.length() != 0 ? "\n" : ""));
        sb.append(s2 + (s2.length() != 0 ? "\n" : ""));
        sb.append(s3 + (s3.length() != 0 ? "\n" : ""));
        sb.append(s4 + (s4.length() != 0 ? "\n" : ""));
        sb.append(s5 + (s5.length() != 0 ? "\n" : ""));
        sb.append(s6);
        return sb.toString();
    }

    public static void main(String[] args) {
        String ip = "";
        String id = "ADMIN";
        String pw = "ADMIN";
        String module = "";
        int index = 0;
        int number = 1;
        boolean infinite = false;
        if (args.length != 5 && args.length != 6) {
            System.out.println("BladeSystemEntity Build:070710");
            System.out.println("Usage: BladeSystemEntity IP USERNAME PASSWORD MODULE_NAME INDEX [number]");
            System.out.println("  IP:          IP address of CMM");
            System.out.println("  USERNAME:    username");
            System.out.println("  PASSWORD:    password");
            System.out.println("  MODULE_NAME: b(Blade),c(CMM),g(Gigabit Switch),");
            System.out.println("               i(Infiniband),p(Power Supply),s(MB sensors),l(front LED),");
            System.out.println("               a(PCA955 informations), t(PCA955 Can't match statistics)");
            System.out.println("  INDEX:       1-based index number of module. Use 0 for all ");
            System.out.println("  number:      run number of this command. Use 0 for infinite times (Ctr-C to stop).");
            System.exit(0);
        }
        ip = args[0];
        id = args[1];
        pw = args[2];
        module = args[3];
        try {
            index = Integer.parseInt(args[4]);
        }
        catch (NumberFormatException ex1) {
            System.out.println("INDEX parameter error");
            System.exit(0);
        }
        if (args.length == 6) {
            try {
                number = Integer.parseInt(args[5]);
            }
            catch (NumberFormatException ex1) {
                System.out.println("[number] parameter error");
                System.exit(0);
            }
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(id);
        config.setPassword(pw);
        config.setPrivilege((byte)4);
        BladeSystemEntity bladeSystem = new BladeSystemEntity(config);
        if (number == 0) {
            number = 2;
            infinite = true;
        }
        int i = 0;
        while (i < number) {
            bladeSystem.getData();
            if (module.equalsIgnoreCase("b")) {
                if (index != 0) {
                    System.out.print("===== Blade " + index + ":");
                    System.out.println(bladeSystem.blades[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.blades.length; ++j) {
                        System.out.print("===== Blade " + (j + 1) + ":");
                        System.out.println(bladeSystem.blades[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("c")) {
                if (index != 0) {
                    System.out.print("===== CMM " + index + ":");
                    System.out.println(bladeSystem.cmmModules[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.cmmModules.length; ++j) {
                        System.out.print("===== CMM " + (j + 1) + ":");
                        System.out.println(bladeSystem.cmmModules[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("g")) {
                if (index != 0) {
                    System.out.print("===== Gigabit Switch " + index + ":");
                    System.out.println(bladeSystem.gigabitSwitchs[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.gigabitSwitchs.length; ++j) {
                        System.out.print("===== Gigabit Switch " + (j + 1) + ":");
                        System.out.println(bladeSystem.gigabitSwitchs[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("i")) {
                if (index != 0) {
                    System.out.print("===== InfiniBand " + index + ":");
                    System.out.println(bladeSystem.infiniBands[index - 1].toString());
                    System.out.print("===== 10G pass thru " + index + ":");
                    System.out.println(bladeSystem.tenGPassThrus[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.infiniBands.length; ++j) {
                        System.out.print("===== InfiniBand " + (j + 1) + ":");
                        System.out.println(bladeSystem.infiniBands[j].toString());
                        System.out.print("===== 10G pass thru " + (j + 1) + ":");
                        System.out.println(bladeSystem.tenGPassThrus[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("p")) {
                if (index != 0) {
                    System.out.print("===== Power Supply " + index + ":");
                    System.out.println(bladeSystem.powerSupplies[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.powerSupplies.length; ++j) {
                        System.out.print("===== Power Supply " + (j + 1) + ":");
                        System.out.println(bladeSystem.powerSupplies[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("s")) {
                if (index != 0) {
                    System.out.print("===== Blade " + index + " Sensor:");
                    System.out.println(bladeSystem.mbSensors[index - 1].toString());
                } else {
                    for (int j = 0; j < bladeSystem.mbSensors.length; ++j) {
                        System.out.print("===== Blade " + (j + 1) + " Sensor:");
                        System.out.println(bladeSystem.mbSensors[j].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("l")) {
                System.out.print("===== Front Panel LED:");
                System.out.println(bladeSystem.frontLED.toString());
            } else if (module.equalsIgnoreCase("a")) {
                Vector PCA955Infos = bladeSystem.getPCA955Infos((byte)index);
                if (PCA955Infos != null) {
                    if (PCA955Infos.size() != 0) {
                        if (index != 0) {
                            System.out.print("\n=====Blade " + index + " PCA955 Info: ");
                            System.out.println(ByteUtility.bytesToHex((byte[])PCA955Infos.get(0)));
                        } else {
                            for (int j = 0; j < PCA955Infos.size(); ++j) {
                                System.out.print("\n=====Blade " + (j + 1) + " PCA955 Info: ");
                                System.out.println(ByteUtility.bytesToHex((byte[])PCA955Infos.get(j)));
                            }
                        }
                    } else {
                        System.out.println("Get PCA955 Infos failed!");
                    }
                } else {
                    System.out.println("Login failed!");
                }
            } else if (module.equalsIgnoreCase("t")) {
                BladeSystemEntity.doGetPCA955Statistics(bladeSystem, index);
            }
            if (i != number - 1) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (infinite) continue;
            ++i;
        }
    }

    private static void doGetPCA955Statistics(BladeSystemEntity bladeSystem, int index) {
        Vector statistics = bladeSystem.getPCA955statistics();
        byte[] statistic = new byte[4];
        byte[] value = new byte[2];
        if (statistics != null) {
            if (statistics.size() != 0) {
                if (index != 0) {
                    System.arraycopy((byte[])statistics.get(index - 1), 0, statistic, 0, 4);
                    System.arraycopy((byte[])statistics.get(index - 1), 4, value, 0, 2);
                    System.out.print("\n=====Blade " + index + " PCA955CanNotMatch: ");
                    System.out.print(ByteUtility.fourBytesToLongByLSBFirst(statistic));
                    System.out.println("\tValue: " + ByteUtility.bytesToHex(value));
                } else {
                    for (int j = 0; j < statistics.size(); ++j) {
                        System.arraycopy((byte[])statistics.get(j), 0, statistic, 0, 4);
                        System.arraycopy((byte[])statistics.get(j), 4, value, 0, 2);
                        System.out.print("\n=====Blade " + (j + 1) + " PCA955CanNotMatch: ");
                        System.out.print(ByteUtility.fourBytesToLongByLSBFirst(statistic));
                        System.out.println("\tValue: " + ByteUtility.bytesToHex(value));
                    }
                }
            } else {
                System.out.println("Get PCA955 statistics failed!");
            }
        } else {
            System.out.println("Login failed!");
        }
    }

    public static void main_poolingTest(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.240");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        BladeSystemEntity bladeSystem = new BladeSystemEntity(config);
        bladeSystem.debug = true;
        bladeSystem.poolingData();
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        bladeSystem.stopPooling();
    }
}

