/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;
import java.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMBSensorEntity
extends Observable {
    public static final byte TEMPERATURE_VALUE_FOR_NO_CPU_INSTALLED = -127;
    public static final int READING_SAFE = 0;
    public static final int READING_UNSAFE = 1;
    public static final int READING_UNKNOWN = 2;
    protected int moduleIndex;
    protected byte flag;
    StringBuffer formatedString = null;
    String formatTemplate = "  %-6s | %-20s | %12s | %9s | %10s |\n";

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public byte getFlag() {
        return this.flag;
    }

    public abstract boolean fromRaw(byte[] var1);

    public abstract ArrayList generateFailureReport(BladeEntity var1, int var2);

    public String toFormatedString() {
        return this.toString();
    }

    protected void addRaw(int checkedResult, String name, String value, String low, String high) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        this.formatedString.append(String.format(this.formatTemplate, result, name, value, low, high));
    }

    public TemperatureData createTemperatureData(int checkedResult, String name, String value, String low, String high) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        return new TemperatureData(result, name, value, low, high);
    }

    public abstract ArrayList<TemperatureData> getTemperatures();

    public String showCandF(byte c) {
        if (c == -127) {
            return "n/a";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + (f < 100L ? " " : "") + f + "F";
    }

    public String showCPUTempString(byte value) {
        String reading = "";
        switch (value) {
            case 0: {
                reading = "Low";
                break;
            }
            case 1: {
                reading = "Medium";
                break;
            }
            case 2: {
                reading = "High";
                break;
            }
            case 4: {
                reading = "Overheat";
                break;
            }
            default: {
                reading = "N/A";
            }
        }
        return reading;
    }

    public String d2StrV(double value) {
        if (value == 0.0) {
            return "N/A";
        }
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d + " V";
    }
}

