/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;

public class IPMIAMIOEMCommand
extends IPMICommand {
    public static final byte AMI_MOUSE_MODE_RELATIVE = 1;
    public static final byte AMI_MOUSE_MODE_ABSOLUTE = 2;
    public static final byte AMI_MOUSE_MODE_OTHER = 3;

    public IPMIAMIOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getKVMSessionTokenCommand(byte[] username, byte[] ip) {
        username = new byte[]{65, 68, 77, 73, 78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ip = new byte[]{49, 57, 50, 46, 49, 54, 56, 46, 49, 48, 48, 46, 49, 50, 52, 0};
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[33];
        data[0] = 1;
        System.arraycopy(username, 0, data, 1, username.length);
        System.arraycopy(ip, 0, data, 17, ip.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMouseModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setMouseModeCommand(byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public String getKVMSessionToken() {
        IPMIMessage resMessage = this.getKVMSessionTokenCommand(null, null);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte[] token = new byte[16];
            System.arraycopy(resMessage.data, 76, token, 0, 16);
            return new String(token);
        }
        return null;
    }

    public byte getMouseMode() throws Exception {
        IPMIMessage resMessage = this.getMouseModeCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("Call getMouseMode failed");
    }

    public boolean setMouseMode(byte mode) throws Exception {
        IPMIMessage resMessage = this.setMouseModeCommand(mode);
        if (resMessage != null && resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("Call setMouseMode failed");
    }

    private void INNER_CLASS____________() {
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.213");
        config.setUserName("root");
        config.setPassword("superuser");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiAMIOEMCommand.setIPMIInterface(rmcp);
        System.out.println("Token = " + ipmiAMIOEMCommand.getKVMSessionToken());
        sessionController.closeSession();
    }

    public class YafuHeader {
        public byte[] seqnum = new byte[4];
        public byte[] yafuCmd = new byte[2];
        public byte[] datalen = new byte[2];
        public byte[] crc32CheckSum = new byte[4];

        public byte[] toRaw() {
            byte[] raw = new byte[this.seqnum.length + this.yafuCmd.length + this.datalen.length + this.crc32CheckSum.length];
            int index = 0;
            System.arraycopy(this.seqnum, 0, raw, index, this.seqnum.length);
            System.arraycopy(this.yafuCmd, 0, raw, index += this.seqnum.length, this.yafuCmd.length);
            System.arraycopy(this.datalen, 0, raw, index += this.yafuCmd.length, this.datalen.length);
            System.arraycopy(this.crc32CheckSum, 0, raw, index += this.datalen.length, this.crc32CheckSum.length);
            return raw;
        }
    }
}

