/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.FRU;

public class FRUInfo {
    private byte boardLanguageCode;
    private String boardMfgDataTime;
    private String boardManufacturerName;
    private String boardProductName;
    private String boardSerialNumber;
    private String boardPartNumber;
    private byte productLanguageCode;
    private String productManufacturerName;
    private String productName;
    private String productPartModelNumber;
    private String productVersion;
    private String productSerialNumber;
    public FRU fru = new FRU();

    public static FRUInfo fromRaw(byte[] raw) {
        FRUInfo fruInfo = new FRUInfo();
        byte commonHeaderVersion = raw[0];
        byte internalUseAreaStringOffset = raw[1];
        byte chassisInfoAreaStringOffset = raw[2];
        byte boardInfoAreaStringOffset = raw[3];
        byte productInfoAreaStringOffset = raw[4];
        byte multiRecordAreaStringOffset = raw[5];
        fruInfo.fru.common.formatVersion = raw[0];
        fruInfo.fru.common.internalUserArea = raw[1];
        fruInfo.fru.common.chassisInfoArea = raw[2];
        fruInfo.fru.common.boardInfoArea = raw[3];
        fruInfo.fru.common.productInfoArea = raw[4];
        fruInfo.fru.common.multiRecordArea = raw[5];
        if (commonHeaderVersion != 1) {
            return null;
        }
        if (internalUseAreaStringOffset != 0) {
            // empty if block
        }
        if (chassisInfoAreaStringOffset != 0) {
            // empty if block
        }
        if (boardInfoAreaStringOffset != 0) {
            FRUInfo.parseFRUBoardInfo(fruInfo, boardInfoAreaStringOffset, raw);
        }
        if (productInfoAreaStringOffset != 0) {
            FRUInfo.parseFRUProductInfo(fruInfo, productInfoAreaStringOffset, raw);
        }
        if (multiRecordAreaStringOffset != 0) {
            // empty if block
        }
        return fruInfo;
    }

    private static void parseFRUBoardInfo(FRUInfo fruInfo, int offset, byte[] data) {
        int index = offset * 8;
        byte languageCode = data[index + 2];
        String mfgDataTime = "" + data[index + 3] + "" + data[index + 4] + "" + data[index + 5];
        fruInfo.fru.board.formatVesion = data[index];
        fruInfo.fru.board.length = data[index + 1];
        fruInfo.fru.board.languageCode = data[index + 2];
        fruInfo.fru.board.mfgDateTime[0] = data[index + 3];
        fruInfo.fru.board.mfgDateTime[1] = data[index + 4];
        fruInfo.fru.board.mfgDateTime[2] = data[index + 5];
        byte[] tempBytes = new byte[data[index + 6] & 0x3F];
        System.arraycopy(data, index + 7, tempBytes, 0, tempBytes.length);
        String manufacturerName = new String(tempBytes);
        fruInfo.fru.board.boardManufacturer = tempBytes;
        int accIndex = index + 6 + tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productName = new String(tempBytes);
        fruInfo.fru.board.boardProductName = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardSerialNumber = new String(tempBytes);
        fruInfo.fru.board.boardSerialNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardPartNumber = new String(tempBytes);
        fruInfo.fru.board.boardPartNumber = tempBytes;
        fruInfo.boardLanguageCode = languageCode;
        fruInfo.boardMfgDataTime = mfgDataTime;
        fruInfo.boardManufacturerName = manufacturerName;
        fruInfo.boardProductName = productName;
        fruInfo.boardSerialNumber = boardSerialNumber;
        fruInfo.boardPartNumber = boardPartNumber;
    }

    private static void parseFRUProductInfo(FRUInfo fruInfo, int offset, byte[] data) {
        int index = offset * 8;
        byte languageCode = data[index + 2];
        fruInfo.fru.product.formatVesion = data[index];
        fruInfo.fru.product.length = data[index + 1];
        fruInfo.fru.product.languageCode = data[index + 2];
        byte[] tempBytes = new byte[data[index + 3] & 0x3F];
        System.arraycopy(data, index + 4, tempBytes, 0, tempBytes.length);
        String productManufacturerName = new String(tempBytes);
        fruInfo.fru.product.productManufacturerName = tempBytes;
        int accIndex = index + 3 + tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productName = new String(tempBytes);
        fruInfo.fru.product.productName = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productPartModelNumber = new String(tempBytes);
        fruInfo.fru.product.productPartModelNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productVersion = new String(tempBytes);
        fruInfo.fru.product.productVersion = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productSerialNumber = new String(tempBytes);
        fruInfo.fru.product.productSerialNumber = tempBytes;
        fruInfo.productLanguageCode = languageCode;
        fruInfo.productManufacturerName = productManufacturerName;
        fruInfo.productName = productName;
        fruInfo.productPartModelNumber = productPartModelNumber;
        fruInfo.productVersion = productVersion;
        fruInfo.productSerialNumber = productSerialNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("board Language Code       = " + this.boardLanguageCode + "\n");
        sb.append("board MfgData Time        = " + this.boardMfgDataTime + "\n");
        sb.append("board Manufacturer Name   = " + this.boardManufacturerName + "\n");
        sb.append("board Product Name        = " + this.boardProductName + "\n");
        sb.append("board Serial Number       = " + this.boardSerialNumber + "\n");
        sb.append("board Part Number         = " + this.boardPartNumber + "\n");
        sb.append("product Language Code     = " + this.productLanguageCode + "\n");
        sb.append("product Manufacturer Name = " + this.productManufacturerName + "\n");
        sb.append("product Name              = " + this.productName + "\n");
        sb.append("product PartModel Number  = " + this.productPartModelNumber + "\n");
        sb.append("product Version           = " + this.productVersion + "\n");
        sb.append("product Serial Number     = " + this.productSerialNumber + "\n");
        return sb.toString();
    }

    public String toReadableString() {
        StringBuffer sb = new StringBuffer();
        sb.append("board Manufacturer Name   = " + this.boardManufacturerName + "\n");
        sb.append("board Product Name        = " + this.boardProductName + "\n");
        sb.append("board Serial Number       = " + this.boardSerialNumber + "\n");
        sb.append("board Part Number         = " + this.boardPartNumber + "\n");
        sb.append("product Manufacturer Name = " + this.productManufacturerName + "\n");
        sb.append("product Name              = " + this.productName + "\n");
        sb.append("product PartModel Number  = " + this.productPartModelNumber + "\n");
        sb.append("product Version           = " + this.productVersion + "\n");
        sb.append("product Serial Number     = " + this.productSerialNumber + "\n");
        return sb.toString();
    }

    public byte getBoardLanguageCode() {
        return this.boardLanguageCode;
    }

    public String getBoardManufacturerName() {
        return this.boardManufacturerName;
    }

    public String getBoardMfgDataTime() {
        return this.boardMfgDataTime;
    }

    public String getBoardPartNumber() {
        return this.boardPartNumber;
    }

    public String getBoardProductName() {
        return this.boardProductName;
    }

    public String getBoardSerialNumber() {
        return this.boardSerialNumber;
    }

    public byte getProductLanguageCode() {
        return this.productLanguageCode;
    }

    public String getProductManufacturerName() {
        return this.productManufacturerName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductPartModelNumber() {
        return this.productPartModelNumber;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProductSerialNumber() {
        return this.productSerialNumber;
    }

    public void setBoardLanguageCode(byte boardLanguageCode) {
        this.boardLanguageCode = boardLanguageCode;
    }

    public void setBoardManufacturerName(String boardManufacturerName) {
        this.boardManufacturerName = boardManufacturerName;
    }

    public void setBoardMfgDataTime(String boardMfgDataTime) {
        this.boardMfgDataTime = boardMfgDataTime;
    }

    public void setBoardPartNumber(String boardPartNumber) {
        this.boardPartNumber = boardPartNumber;
    }

    public void setBoardProductName(String boardProductName) {
        this.boardProductName = boardProductName;
    }

    public void setProductLanguageCode(byte productLanguageCode) {
        this.productLanguageCode = productLanguageCode;
    }

    public void setBoardSerialNumber(String boardSerialNumber) {
        this.boardSerialNumber = boardSerialNumber;
    }

    public void setProductManufacturerName(String productManufacturerName) {
        this.productManufacturerName = productManufacturerName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setProductPartModelNumber(String productPartModelNumber) {
        this.productPartModelNumber = productPartModelNumber;
    }

    public void setProductSerialNumber(String productSerialNumber) {
        this.productSerialNumber = productSerialNumber;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }
}

