/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class EventFilterTable {
    private byte filterNumber;
    private byte filterConfiguration;
    private byte eventFilterAction;
    private byte alertPolicyNumber;
    private byte eventSeverity;
    private byte generatorIDByte1;
    private byte generatorIDByte2;
    private byte sensorType;
    private byte sensorNumber;
    private byte eventTrigger;
    private byte eventData1EventOffsetMask1;
    private byte eventData1EventOffsetMask2;
    private byte eventData1AndMask;
    private byte eventData1Compare1;
    private byte eventData1Compare2;
    private byte eventData2AndMask;
    private byte eventData2Compare1;
    private byte eventData2Compare2;
    private byte eventData3AndMask;
    private byte eventData3Compare1;
    private byte eventData3Compare2;

    public static EventFilterTable getDefault() {
        EventFilterTable t = new EventFilterTable();
        t.filterConfiguration = (byte)-128;
        t.eventFilterAction = 1;
        t.alertPolicyNumber = 0;
        t.eventSeverity = 0;
        t.generatorIDByte1 = (byte)-1;
        t.generatorIDByte2 = (byte)-1;
        t.sensorType = (byte)-1;
        t.sensorNumber = (byte)-1;
        t.eventTrigger = (byte)-1;
        t.eventData1EventOffsetMask1 = (byte)-1;
        t.eventData1EventOffsetMask2 = (byte)-1;
        return t;
    }

    public static EventFilterTable getDefaultForAMI() {
        EventFilterTable t = new EventFilterTable();
        t.filterConfiguration = (byte)-128;
        t.eventFilterAction = 1;
        t.alertPolicyNumber = 0;
        t.eventSeverity = (byte)2;
        t.generatorIDByte1 = (byte)-1;
        t.generatorIDByte2 = (byte)-1;
        t.sensorType = (byte)-1;
        t.sensorNumber = (byte)-1;
        t.eventTrigger = (byte)-1;
        t.eventData1EventOffsetMask1 = (byte)-1;
        t.eventData1EventOffsetMask2 = (byte)-1;
        return t;
    }

    public byte[] toRaw() {
        byte[] raw = new byte[]{this.filterNumber, this.filterConfiguration, this.eventFilterAction, this.alertPolicyNumber, this.eventSeverity, this.generatorIDByte1, this.generatorIDByte2, this.sensorType, this.sensorNumber, this.eventTrigger, this.eventData1EventOffsetMask1, this.eventData1EventOffsetMask2, this.eventData1AndMask, this.eventData1Compare1, this.eventData1Compare2, this.eventData2AndMask, this.eventData2Compare1, this.eventData2Compare2, this.eventData3AndMask, this.eventData3Compare1, this.eventData3Compare2};
        return raw;
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != 21) {
            return false;
        }
        this.filterNumber = raw[0];
        this.filterConfiguration = raw[1];
        this.eventFilterAction = raw[2];
        this.alertPolicyNumber = raw[3];
        this.eventSeverity = raw[4];
        this.generatorIDByte1 = raw[5];
        this.generatorIDByte2 = raw[6];
        this.sensorType = raw[7];
        this.sensorNumber = raw[8];
        this.eventTrigger = raw[9];
        this.eventData1EventOffsetMask1 = raw[10];
        this.eventData1EventOffsetMask2 = raw[11];
        this.eventData1AndMask = raw[12];
        this.eventData1Compare1 = raw[13];
        this.eventData1Compare2 = raw[14];
        this.eventData2AndMask = raw[15];
        this.eventData2Compare1 = raw[16];
        this.eventData2Compare2 = raw[17];
        this.eventData3AndMask = raw[18];
        this.eventData3Compare1 = raw[19];
        this.eventData3Compare2 = raw[20];
        System.out.println("raw = " + ByteUtility.bytesToHex(raw));
        return true;
    }

    public void setFilterConfiguration(byte filterConfiguration) {
        this.filterConfiguration = filterConfiguration;
    }

    public void setEventFilterAction(byte eventFilterAction) {
        this.eventFilterAction = eventFilterAction;
    }

    public void setAlertPolicyNumber(byte alertPolicyNumber) {
        this.alertPolicyNumber = alertPolicyNumber;
    }

    public void setEventSeverity(byte eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    public void setGeneratorIDByte1(byte generatorIDByte1) {
        this.generatorIDByte1 = generatorIDByte1;
    }

    public void setGeneratorIDByte2(byte generatorIDByte2) {
        this.generatorIDByte2 = generatorIDByte2;
    }

    public void setSensorType(byte sensorType) {
        this.sensorType = sensorType;
    }

    public void setSensorNumber(byte sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public void setEventTrigger(byte eventTrigger) {
        this.eventTrigger = eventTrigger;
    }

    public void setEventData1EventOffsetMask1(byte eventData1EventOffsetMask1) {
        this.eventData1EventOffsetMask1 = eventData1EventOffsetMask1;
    }

    public void setEventData1EventOffsetMask2(byte eventData1EventOffsetMask2) {
        this.eventData1EventOffsetMask2 = eventData1EventOffsetMask2;
    }

    public void setEventData1AndMask(byte eventData1AndMask) {
        this.eventData1AndMask = eventData1AndMask;
    }

    public void setEventData1Compare1(byte eventData1Compare1) {
        this.eventData1Compare1 = eventData1Compare1;
    }

    public void setEventData1Compare2(byte eventData1Compare2) {
        this.eventData1Compare2 = eventData1Compare2;
    }

    public void setEventData2AndMask(byte eventData2AndMask) {
        this.eventData2AndMask = eventData2AndMask;
    }

    public void setEventData2Compare1(byte eventData2Compare1) {
        this.eventData2Compare1 = eventData2Compare1;
    }

    public void setEventData2Compare2(byte eventData2Compare2) {
        this.eventData2Compare2 = eventData2Compare2;
    }

    public void setEventData3AndMask(byte eventData3AndMask) {
        this.eventData3AndMask = eventData3AndMask;
    }

    public void setEventData3Compare1(byte eventData3Compare1) {
        this.eventData3Compare1 = eventData3Compare1;
    }

    public void setEventData3Compare2(byte eventData3Compare2) {
        this.eventData3Compare2 = eventData3Compare2;
    }

    public void setFilterNumber(byte filterNumber) {
        this.filterNumber = filterNumber;
    }

    public byte getFilterConfiguration() {
        return this.filterConfiguration;
    }

    public byte getEventFilterAction() {
        return this.eventFilterAction;
    }

    public byte getAlertPolicyNumber() {
        return this.alertPolicyNumber;
    }

    public byte getEventSeverity() {
        return this.eventSeverity;
    }

    public byte getGeneratorIDByte1() {
        return this.generatorIDByte1;
    }

    public byte getGeneratorIDByte2() {
        return this.generatorIDByte2;
    }

    public byte getSensorType() {
        return this.sensorType;
    }

    public byte getSensorNumber() {
        return this.sensorNumber;
    }

    public byte getEventTrigger() {
        return this.eventTrigger;
    }

    public byte getEventData1EventOffsetMask1() {
        return this.eventData1EventOffsetMask1;
    }

    public byte getEventData1EventOffsetMask2() {
        return this.eventData1EventOffsetMask2;
    }

    public byte getEventData1AndMask() {
        return this.eventData1AndMask;
    }

    public byte getEventData1Compare1() {
        return this.eventData1Compare1;
    }

    public byte getEventData1Compare2() {
        return this.eventData1Compare2;
    }

    public byte getEventData2AndMask() {
        return this.eventData2AndMask;
    }

    public byte getEventData2Compare1() {
        return this.eventData2Compare1;
    }

    public byte getEventData2Compare2() {
        return this.eventData2Compare2;
    }

    public byte getEventData3AndMask() {
        return this.eventData3AndMask;
    }

    public byte getEventData3Compare1() {
        return this.eventData3Compare1;
    }

    public byte getEventData3Compare2() {
        return this.eventData3Compare2;
    }

    public byte getFilterNumber() {
        return this.filterNumber;
    }
}

