/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.video;

import com.ami.kvm.jviewer.kvmpkts.FrameHdr;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VSCDecoder {
    public static final int VSC_RECT_HDR_SIZE = 16;
    public static final int TILE_WIDTH = 16;
    public static final int TILE_HEIGHT = 16;
    public static final byte LRLE_COLOR_15BIT_DIRECT = 8;
    public static final byte LRLE_COLOR_7BIT_DIRECT = 9;
    public static final byte LRLE_COLOR_4BIT_PALETTE = 10;
    public static final byte LRLE_COLOR_4BIT_GREY = 3;
    public static final byte LRLE_COLOR_3BIT_GREY = 2;
    public static final byte NO_COMPRESSION = 0;
    public static final byte LRLE_8BIT = 1;
    public static final byte LRLE_16BIT = 2;
    public static final byte LRLE_32BIT = 3;
    public static final byte DEFAULT_COLOR_MODE = 8;

    public static void UnCompress(short[] imagebuf_short, byte[] imagebuf_byte, short[] LRLEBuff_short, byte[] LRLEBuff_byte, ByteBuffer srcByteBuf, FrameHdr frame_hdr, Vector<Rectangle> vector_rects) {
        int size;
        byte[] round_4 = new byte[]{0, 3, 2, 1};
        srcByteBuf.order(ByteOrder.LITTLE_ENDIAN);
        for (int buf_counter = 0; buf_counter < frame_hdr.frameSize; buf_counter += 16 + size) {
            short x = srcByteBuf.getShort();
            short y = srcByteBuf.getShort();
            short w = srcByteBuf.getShort();
            short h = srcByteBuf.getShort();
            int scrsize = w * h;
            int encoding = srcByteBuf.getInt();
            size = srcByteBuf.getInt();
            if (frame_hdr.color_mode == 8) {
                if (encoding == 2) {
                    VSCDecoder.UnCompressLRLE_15_direct_16(LRLEBuff_short, srcByteBuf, size, scrsize);
                } else if (encoding == 3) {
                    VSCDecoder.UnCompressLRLE_15_direct_32(LRLEBuff_short, srcByteBuf, size, scrsize);
                } else if (encoding == 0) {
                    VSCDecoder.UnCompressLRLE_15_direct(LRLEBuff_short, srcByteBuf, size);
                }
                VSCDecoder.Draw_15_direct(imagebuf_short, LRLEBuff_short, x, y, w, h, frame_hdr.resX, frame_hdr.resY);
            } else if (frame_hdr.color_mode == 9) {
                if (encoding == 2) {
                    VSCDecoder.UnCompressLRLE_7_direct_16(LRLEBuff_byte, srcByteBuf, size, scrsize);
                } else if (encoding == 3) {
                    VSCDecoder.UnCompressLRLE_7_direct_32(LRLEBuff_byte, srcByteBuf, size, scrsize);
                } else if (encoding == 0) {
                    VSCDecoder.UnCompressLRLE_7_direct(LRLEBuff_byte, srcByteBuf, size);
                }
                VSCDecoder.Draw_7_direct(imagebuf_byte, LRLEBuff_byte, x, y, w, h, frame_hdr.resX, frame_hdr.resY);
            } else if (frame_hdr.color_mode == 10 || frame_hdr.color_mode == 3) {
                VSCDecoder.UnCompressLRLE_CRLE_4(LRLEBuff_byte, srcByteBuf, size);
                VSCDecoder.Draw_7_direct(imagebuf_byte, LRLEBuff_byte, x, y, w, h, frame_hdr.resX, frame_hdr.resY);
            } else if (frame_hdr.color_mode == 2) {
                VSCDecoder.UnCompressLRLE_CRLE_3(LRLEBuff_byte, srcByteBuf, size);
                VSCDecoder.Draw_7_direct(imagebuf_byte, LRLEBuff_byte, x, y, w, h, frame_hdr.resX, frame_hdr.resY);
            } else {
                srcByteBuf.position(srcByteBuf.position() + size);
            }
            byte round = round_4[size % 4];
            vector_rects.add(new Rectangle(x, y, w, h));
        }
    }

    public static void Draw_15_RAW(short[] destbuf, ByteBuffer srcByteBuf, short x, short y, short w, short h, int screen_width, int screen_height) {
        for (int count_y = y; count_y < y + h; count_y += 16) {
            for (int count_x = x; count_x < x + w; count_x += 16) {
                int position = count_y * screen_width + count_x;
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        destbuf[position + j] = srcByteBuf.getShort();
                    }
                    position += screen_width;
                }
            }
        }
    }

    public static void UnCompressLRLE_15_direct(short[] destbuf, ByteBuffer srcByteBuf, int size) {
        int dest_counter = 0;
        boolean prev_pixel = false;
        short curr_byte = 0;
        for (int src_counter = 0; src_counter < size; ++src_counter) {
            curr_byte = (short)(0xFF & srcByteBuf.get());
            ++src_counter;
            curr_byte = (short)(curr_byte | (short)(0xFF & srcByteBuf.get()) << 8);
            destbuf[dest_counter++] = curr_byte;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void UnCompressLRLE_15_direct_16(short[] destbuf, ByteBuffer srcByteBuf, int size, int scrsize) {
        dest_counter = scrsize - 1;
        curr_byte = 0;
        len = 0;
        old_pos = srcByteBuf.position();
        src_counter = old_pos + (size - 2);
        block0: while (true) {
            len = srcByteBuf.getShort(src_counter);
            if ((src_counter -= 2) < old_pos) break;
            if (0 != (32768 & len)) {
                len = (short)(len & 32767);
                curr_byte = srcByteBuf.getShort(src_counter);
                src_counter -= 2;
                while (true) {
                    if (0 == len || dest_counter < 0) continue block0;
                    destbuf[dest_counter--] = curr_byte;
                    len = (short)(len - 1);
                }
            }
            while (true) {
                if (0 != len && dest_counter >= 0 && src_counter >= old_pos) ** break;
                continue block0;
                curr_byte = srcByteBuf.getShort(src_counter);
                src_counter -= 2;
                destbuf[dest_counter--] = curr_byte;
                len = (short)(len - 1);
            }
            break;
        }
        srcByteBuf.position(srcByteBuf.position() + size);
    }

    /*
     * Unable to fully structure code
     */
    public static void UnCompressLRLE_15_direct_32(short[] destbuf, ByteBuffer srcByteBuf, int size, int scrsize) {
        dest_counter = scrsize - 1;
        curr_byte_l = 0;
        curr_byte_m = 0;
        curr_byte = 0;
        len = 0;
        old_pos = srcByteBuf.position();
        src_counter = old_pos + (size - 4);
        block0: while (true) {
            len = srcByteBuf.getInt(src_counter);
            if ((src_counter -= 4) < old_pos) break;
            if (0 != (-2147483648 & len)) {
                len = (short)(len & 0x7FFFFFFF);
                curr_byte = srcByteBuf.getInt(src_counter);
                src_counter -= 4;
                curr_byte_m = (short)(65535 & curr_byte >> 16);
                curr_byte_l = (short)(65535 & curr_byte);
                while (true) {
                    if (0 == len || dest_counter < 0) continue block0;
                    destbuf[dest_counter--] = curr_byte_m;
                    destbuf[dest_counter--] = curr_byte_l;
                    --len;
                }
            }
            while (true) {
                if (0 != len && dest_counter >= 0 && src_counter >= old_pos) ** break;
                continue block0;
                curr_byte = srcByteBuf.getInt(src_counter);
                src_counter -= 4;
                curr_byte_m = (short)(65535 & curr_byte >> 16);
                curr_byte_l = (short)(65535 & curr_byte);
                destbuf[dest_counter--] = curr_byte_m;
                destbuf[dest_counter--] = curr_byte_l;
                --len;
            }
            break;
        }
        srcByteBuf.position(srcByteBuf.position() + size);
    }

    public static void Draw_15_direct(short[] destbuf, short[] srcbuf, short x, short y, short w, short h, int screen_width, int screen_height) {
        int src_counter = 0;
        for (int count_y = y; count_y < y + h; ++count_y) {
            short count_x = x;
            int position = count_y * screen_width + count_x;
            for (int i = 0; i < w; ++i) {
                destbuf[position + i] = srcbuf[src_counter++];
            }
        }
    }

    public static void Draw_7_direct(byte[] destbuf, byte[] srcbuf, short x, short y, short w, short h, int screen_width, int screen_height) {
        int src_counter = 0;
        for (int count_y = y; count_y < y + h; ++count_y) {
            short count_x = x;
            int position = count_y * screen_width + count_x;
            for (int i = 0; i < w; ++i) {
                destbuf[position + i] = srcbuf[src_counter++];
            }
        }
    }

    public static void UnCompressLRLE_7_direct(byte[] destbuf, ByteBuffer srcByteBuf, int size) {
        int dest_counter = 0;
        byte curr_byte = 0;
        for (int src_counter = 0; src_counter < size; ++src_counter) {
            curr_byte = srcByteBuf.get();
            destbuf[dest_counter++] = curr_byte;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void UnCompressLRLE_7_direct_16(byte[] destbuf, ByteBuffer srcByteBuf, int size, int scrsize) {
        dest_counter = scrsize - 1;
        curr_byte_l = 0;
        curr_byte_m = 0;
        curr_byte = 0;
        len = 0;
        old_pos = srcByteBuf.position();
        src_counter = old_pos + (size - 2);
        block0: while (true) {
            len = srcByteBuf.getShort(src_counter);
            if ((src_counter -= 2) < old_pos) break;
            if (0 != (32768 & len)) {
                len = (short)(len & 32767);
                curr_byte = srcByteBuf.getShort(src_counter);
                src_counter -= 2;
                curr_byte_m = (byte)(255 & curr_byte >> 8);
                curr_byte_l = (byte)(255 & curr_byte);
                while (true) {
                    if (0 == len || dest_counter < 0) continue block0;
                    destbuf[dest_counter--] = curr_byte_m;
                    destbuf[dest_counter--] = curr_byte_l;
                    len = (short)(len - 1);
                }
            }
            while (true) {
                if (0 != len && dest_counter >= 0 && src_counter >= old_pos) ** break;
                continue block0;
                curr_byte = srcByteBuf.getShort(src_counter);
                src_counter -= 2;
                curr_byte_m = (byte)(255 & curr_byte >> 8);
                curr_byte_l = (byte)(255 & curr_byte);
                destbuf[dest_counter--] = curr_byte_m;
                destbuf[dest_counter--] = curr_byte_l;
                len = (short)(len - 1);
            }
            break;
        }
        srcByteBuf.position(srcByteBuf.position() + size);
    }

    /*
     * Unable to fully structure code
     */
    public static void UnCompressLRLE_7_direct_32(byte[] destbuf, ByteBuffer srcByteBuf, int size, int scrsize) {
        dest_counter = scrsize - 1;
        curr_byte_1 = 0;
        curr_byte_2 = 0;
        curr_byte_3 = 0;
        curr_byte_4 = 0;
        curr_byte = 0;
        len = 0;
        old_pos = srcByteBuf.position();
        src_counter = old_pos + (size - 4);
        block0: while (true) {
            len = srcByteBuf.getInt(src_counter);
            if ((src_counter -= 4) < old_pos) break;
            if (0 != (-2147483648 & len)) {
                len = (short)(len & 0x7FFFFFFF);
                curr_byte = srcByteBuf.getInt(src_counter);
                src_counter -= 4;
                curr_byte_4 = (byte)(255 & curr_byte >> 24);
                curr_byte_3 = (byte)(255 & curr_byte >> 16);
                curr_byte_2 = (byte)(255 & curr_byte >> 8);
                curr_byte_1 = (byte)(255 & curr_byte);
                while (true) {
                    if (0 == len || dest_counter < 0) continue block0;
                    destbuf[dest_counter--] = curr_byte_4;
                    destbuf[dest_counter--] = curr_byte_3;
                    destbuf[dest_counter--] = curr_byte_2;
                    destbuf[dest_counter--] = curr_byte_1;
                    --len;
                }
            }
            while (true) {
                if (0 != len && dest_counter >= 0 && src_counter >= old_pos) ** break;
                continue block0;
                curr_byte = srcByteBuf.getInt(src_counter);
                src_counter -= 4;
                curr_byte_4 = (byte)(255 & curr_byte >> 24);
                curr_byte_3 = (byte)(255 & curr_byte >> 16);
                curr_byte_2 = (byte)(255 & curr_byte >> 8);
                curr_byte_1 = (byte)(255 & curr_byte);
                destbuf[dest_counter--] = curr_byte_4;
                destbuf[dest_counter--] = curr_byte_3;
                destbuf[dest_counter--] = curr_byte_2;
                destbuf[dest_counter--] = curr_byte_1;
                --len;
            }
            break;
        }
        srcByteBuf.position(srcByteBuf.position() + size);
    }

    public static void UnCompressLRLE_CRLE_4(byte[] destbuf, ByteBuffer srcByteBuf, int size) {
        int dest_counter = 0;
        int src_counter = 0;
        boolean prev_pixel = false;
        byte curr_byte = 0;
        while (src_counter < size) {
            int run_value;
            curr_byte = srcByteBuf.get();
            ++src_counter;
            if ((0xE0 & curr_byte) == 224) {
                run_value = 0;
                if ((0xFF & curr_byte) == 255) {
                    run_value = (0xFF & srcByteBuf.get()) + 1;
                    ++src_counter;
                } else {
                    run_value = (0x1F & curr_byte) + 1;
                }
                int prev_line_index = dest_counter - 16;
                while (run_value > 0) {
                    destbuf[dest_counter++] = destbuf[prev_line_index++];
                    --run_value;
                }
                continue;
            }
            byte pixel_value = (byte)(0xF & curr_byte);
            for (run_value = ((0xF0 & curr_byte) >> 4) + 1; run_value > 0; --run_value) {
                destbuf[dest_counter++] = pixel_value;
            }
        }
    }

    public static void UnCompressLRLE_CRLE_3(byte[] destbuf, ByteBuffer srcByteBuf, int size) {
        int dest_counter = 0;
        int src_counter = 0;
        boolean prev_pixel = false;
        byte curr_byte = 0;
        while (src_counter < size) {
            int run_value;
            curr_byte = srcByteBuf.get();
            ++src_counter;
            if ((0xE0 & curr_byte) == 224) {
                run_value = 0;
                if ((0xFF & curr_byte) == 255) {
                    run_value = (0xFF & srcByteBuf.get()) + 1;
                    ++src_counter;
                } else {
                    run_value = (0x1F & curr_byte) + 1;
                }
                int prev_line_index = dest_counter - 16;
                while (run_value > 0) {
                    destbuf[dest_counter++] = destbuf[prev_line_index++];
                    --run_value;
                }
                continue;
            }
            byte pixel_value = (byte)(7 & curr_byte);
            for (run_value = ((0xF8 & curr_byte) >> 3) + 1; run_value > 0; --run_value) {
                destbuf[dest_counter++] = pixel_value;
            }
        }
    }
}

