/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.USBMessage;
import java.awt.Toolkit;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class USBMouseRep
extends USBMessage {
    private static final int DIRABS_MAX_SCALED_X = Short.MAX_VALUE;
    private static final int DIRABS_MAX_SCALED_Y = Short.MAX_VALUE;
    public static byte INVALID_MOUSE_MODE = (byte)-1;
    public static byte RELATIVE_MOUSE_MODE = 1;
    public static byte ABSOLUTE_MOUSE_MODE = (byte)2;
    public static byte OTHER_MOUSE_MODE = (byte)3;
    private byte m_MouseMode = INVALID_MOUSE_MODE;
    public static byte m_btnStatus = 0;
    public int m_xDisp;
    public int m_yDisp;
    private ByteBuffer m_repBuf;
    private byte[] m_report;
    private byte[] m_encReport;
    private byte[] m_usbData;
    private static int SeqNum = 0;
    private double m_screenwidth;
    private double m_screenheight;
    Toolkit m_toolkit = Toolkit.getDefaultToolkit();

    public USBMouseRep() {
        this(0, 0, 0);
    }

    public USBMouseRep(byte btnStatus, int xDisp, int yDisp) {
        m_btnStatus = btnStatus;
        this.m_xDisp = xDisp;
        this.m_yDisp = yDisp;
    }

    public void set(byte btnStatus, int xDisp, int yDisp, byte MouseMode, int view_width, int view_height) {
        m_btnStatus = btnStatus;
        this.m_xDisp = xDisp;
        this.m_yDisp = yDisp;
        this.m_MouseMode = MouseMode;
        this.m_screenwidth = view_width;
        this.m_screenheight = view_height;
    }

    public byte[] ABSreport() {
        short X = (short)((double)(this.m_xDisp * Short.MAX_VALUE) / this.m_screenwidth + 0.5);
        short Y = (short)((double)(this.m_yDisp * Short.MAX_VALUE) / this.m_screenheight + 0.5);
        this.m_vHdr = new IVTPPktHdr(4, 38, 0);
        this.m_report = new byte[45];
        int DataPktLen = 6;
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        this.m_vHdr.setSize(38);
        this.m_vHdr.setStatus((short)0);
        this.m_repBuf.put(this.m_vHdr.array());
        this.m_repBuf.put(this.m_signature);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(DataPktLen);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)49);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)-128);
        this.m_repBuf.put((byte)2);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(SeqNum);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)5);
        this.m_repBuf.put(m_btnStatus);
        this.m_repBuf.putShort(X);
        this.m_repBuf.putShort(Y);
        int temp = 0;
        for (int i = 7; i < 39; ++i) {
            temp = temp + (this.m_repBuf.get(i) & 0xFF) & 0xFF;
        }
        this.m_repBuf.put(18, -((byte)(temp & 0xFF)));
        ++SeqNum;
        return this.m_report;
    }

    public byte[] RELreport() {
        this.m_vHdr = new IVTPPktHdr(4, 36, 0);
        this.m_report = new byte[43];
        int DataPktLen = 4;
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        this.m_vHdr.setSize(36);
        this.m_vHdr.setStatus((short)0);
        this.m_repBuf.put(this.m_vHdr.array());
        this.m_repBuf.put(this.m_signature);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(DataPktLen);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)49);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)-128);
        this.m_repBuf.put((byte)2);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(SeqNum);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)3);
        this.m_repBuf.put(m_btnStatus);
        this.m_repBuf.put((byte)this.m_xDisp);
        this.m_repBuf.put((byte)this.m_yDisp);
        int temp = 0;
        for (int i = 7; i < 39; ++i) {
            temp = temp + (this.m_repBuf.get(i) & 0xFF) & 0xFF;
        }
        this.m_repBuf.put(18, -((byte)(temp & 0xFF)));
        ++SeqNum;
        return this.m_report;
    }

    public byte[] report() {
        if (this.m_MouseMode == ABSOLUTE_MOUSE_MODE) {
            return this.ABSreport();
        }
        if (this.m_MouseMode == RELATIVE_MOUSE_MODE || this.m_MouseMode == OTHER_MOUSE_MODE) {
            return this.RELreport();
        }
        Debug.out.println("INVALID_MOUSE_MODE");
        return null;
    }
}

