/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.hid.CtrlReader;
import com.ami.kvm.jviewer.hid.FragNumReader;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.hid.KVMReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class HeaderReader
implements KVMReader {
    private KVMClient m_client;
    private byte[] m_hdrBuf;
    private ByteBuffer m_hdrByteBuf;
    private IVTPPktHdr m_pktHdr;
    private int m_hdrIx;

    public HeaderReader(KVMClient client) {
        this.m_client = client;
        this.m_hdrBuf = new byte[7];
        this.m_hdrByteBuf = ByteBuffer.wrap(this.m_hdrBuf);
        this.m_pktHdr = new IVTPPktHdr();
        this.m_hdrIx = 0;
    }

    public void initialize() {
        this.m_hdrIx = 0;
        this.m_hdrByteBuf.clear();
    }

    public int read(SocketChannel sockCh, SSLWrapper ssl_wrapper) {
        try {
            this.m_hdrIx = ssl_wrapper != null ? (this.m_hdrIx += ssl_wrapper.GetBytes(this.m_hdrByteBuf)) : (this.m_hdrIx += sockCh.read(this.m_hdrByteBuf));
            if (7 <= this.m_hdrIx) {
                this.m_pktHdr.set(this.m_hdrByteBuf);
                this.m_client.m_pktHdr = this.m_pktHdr;
                if (this.m_pktHdr.type == 3) {
                    FragNumReader reader = this.m_client.getFragNumReader();
                    reader.initialize();
                    this.m_client.setState(reader);
                } else if (this.m_pktHdr.pktSize > 0) {
                    CtrlReader reader = this.m_client.getCtrlReader();
                    reader.initialize();
                    this.m_client.setState(reader);
                } else {
                    this.m_client.onControlMessage();
                    HeaderReader reader = this.m_client.getHdrReader();
                    reader.initialize();
                    this.m_client.setState(reader);
                }
            }
        }
        catch (Exception e) {
            Debug.out.println("HDR_RDR " + e);
            return -1;
        }
        return 0;
    }
}

