/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.hid.FragReader;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.hid.KVMReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class FragNumReader
implements KVMReader {
    private KVMClient m_client;
    private ByteBuffer m_fragNumBuf;
    private int m_fragNumIx;

    public FragNumReader(KVMClient client) {
        this.m_client = client;
        this.m_fragNumBuf = ByteBuffer.allocate(2);
        this.m_fragNumBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_fragNumIx = 0;
    }

    public void initialize() {
        this.m_fragNumIx = 0;
        this.m_fragNumBuf.clear();
    }

    public int read(SocketChannel sockCh, SSLWrapper ssl_wrapper) {
        try {
            this.m_fragNumIx = ssl_wrapper != null ? (this.m_fragNumIx += ssl_wrapper.GetBytes(this.m_fragNumBuf)) : (this.m_fragNumIx += sockCh.read(this.m_fragNumBuf));
            if (2 <= this.m_fragNumIx) {
                this.m_client.m_fragNum = this.m_fragNumBuf.getShort(0);
                FragReader reader = this.m_client.getFragReader();
                reader.initialize();
                this.m_client.setState(reader);
            }
        }
        catch (Exception e) {
            Debug.out.println("ON_READ_FRAG_SZ " + e);
            return -1;
        }
        return 0;
    }
}

