/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.hid.KMEncode;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.USBKeyboardRep;
import com.ami.kvm.jviewer.kvmpkts.USBMouseRep;
import com.ami.kvm.jviewer.video.ColorTable;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class JViewerView
extends JComponent {
    JViewerApp app;
    public static final int DEFAULT_VIEW_WIDTH = 1024;
    public static final int DEFAULT_VIEW_HEIGHT = 768;
    private static final int REL_MOUSE_MIN_WND_WIDTH = 200;
    private static final int REL_MOUSE_MIN_WND_HEIGHT = 200;
    private static final int MOUSE_ACCELERATION = 2;
    private static final int ACCEL_THRESHOLD = 4;
    private int m_width;
    private int m_height;
    private int m_act_width;
    private int m_act_height;
    private BufferedImage m_image = null;
    private int m_mousePrevX = 0;
    private int m_mousePrevY = 0;
    private KMEncode m_keyCoder;
    RCMouseListener m_mouseListener;
    RCKeyListener m_keyListener;
    public static final boolean m_isG4 = true;
    private USBKeyboardRep m_USBKeyRep;
    private USBMouseRep m_USBMouseRep;
    private byte m_USBMouseMode = USBMouseRep.INVALID_MOUSE_MODE;
    private int lastX = -1;
    private int lastY = -1;
    public byte m_current_color_mode = (byte)8;
    private boolean m_bLeftCtrlDown = false;
    private boolean m_bRightCtrlDown = false;
    private boolean m_bLeftAltDown = false;
    private boolean m_bRightAltDown = false;
    private boolean m_bMouseRedirRunning = false;
    private boolean m_bMouseWasOut = true;

    public JViewerView(int width, int height, JViewerApp app) {
        this.app = app;
        this.setRCView(width, height, this.m_current_color_mode);
        this.m_USBKeyRep = new USBKeyboardRep();
        this.m_USBMouseRep = new USBMouseRep();
        this.m_mouseListener = new RCMouseListener();
        this.m_keyListener = new RCKeyListener();
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(new RCFocusListener());
        this.addMouseListener(new RCDoubleClickListener());
    }

    public void addKMListeners() {
        this.addKeyListener(this.m_keyListener);
    }

    public void removeKMListeners() {
        this.removeKeyListener(this.m_keyListener);
    }

    public void DisableKMListeners(boolean disable) {
        this.m_mouseListener.DisableEvents(disable);
        this.m_keyListener.DisableEvents(disable);
    }

    public short[] imageMemory() {
        WritableRaster r = this.m_image.getRaster();
        DataBuffer buf = r.getDataBuffer();
        if (buf instanceof DataBufferUShort) {
            DataBufferUShort dbuf = (DataBufferUShort)buf;
            return dbuf.getData();
        }
        return null;
    }

    public byte[] imageMemory_ByteArray() {
        WritableRaster r = this.m_image.getRaster();
        DataBuffer buf = r.getDataBuffer();
        if (buf instanceof DataBufferByte) {
            DataBufferByte dbuf = (DataBufferByte)buf;
            return dbuf.getData();
        }
        return null;
    }

    public int viewWidth() {
        return this.m_width;
    }

    public int viewHeight() {
        return this.m_height;
    }

    public void setRCView(int width, int height, byte color_model) {
        this.m_act_width = this.m_width = width;
        this.m_act_height = this.m_height = height;
        if (this.m_act_height == 608) {
            this.m_act_height = 600;
        }
        this.m_current_color_mode = color_model;
        Debug.out.println("View - width: " + this.m_width + " height: " + this.m_height);
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        this.prepareBufImage();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        try {
            Rectangle full_view = new Rectangle(0, 0, this.m_width, this.m_height);
            Rectangle r = full_view.intersection(g.getClipBounds());
            BufferedImage rgn = this.m_image.getSubimage(r.x, r.y, r.width, r.height);
            g.drawImage(rgn, r.x, r.y, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ShowCursor(boolean show) {
        if (show) {
            this.setCursor(null);
        } else {
            BufferedImage invisCursor = new BufferedImage(32, 32, 3);
            Cursor invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(invisCursor, new Point(0, 0), "Invisible Cursor");
            this.setCursor(invisibleCursor);
        }
    }

    public void SetUSBMouseMode(byte mode) {
        this.m_USBMouseMode = mode;
    }

    public byte GetUSBMouseMode() {
        return this.m_USBMouseMode;
    }

    private void mouse_resync_linux_mode(int x, int y) {
        this.m_mouseListener.splitandsend(-this.m_width, -this.m_height, true);
        Point currMousePos = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(currMousePos, this);
        this.lastX = (int)currMousePos.getX();
        this.lastY = (int)currMousePos.getY();
        this.m_mouseListener.splitandsend(this.lastX, this.lastY, true);
    }

    public boolean USBsyncCursor(boolean state) {
        if (state) {
            if (this.m_bMouseRedirRunning) {
                return true;
            }
            if (this.m_USBMouseMode == USBMouseRep.INVALID_MOUSE_MODE) {
                this.app.generalErrorMessage(LocaleStrings.GetString("E_2_JVIEW"));
                return false;
            }
            if (this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                this.m_bMouseWasOut = true;
            } else if (this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE) {
                Point currMousePos = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(currMousePos, this);
                this.lastX = (int)currMousePos.getX();
                this.lastY = (int)currMousePos.getY();
            }
            this.addMouseListener(this.m_mouseListener);
            this.addMouseMotionListener(this.m_mouseListener);
            this.m_bMouseRedirRunning = true;
        } else {
            this.removeMouseListener(this.m_mouseListener);
            this.removeMouseMotionListener(this.m_mouseListener);
            this.m_bMouseRedirRunning = false;
            this.m_bMouseWasOut = true;
        }
        return true;
    }

    public BufferedImage GetRedirImage() {
        return this.m_image;
    }

    private void prepareBufImage() {
        if (this.m_current_color_mode == 8) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 9);
        } else if (this.m_current_color_mode == 9) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 13, ColorTable.get7BitDirectIndexColorModel());
        } else if (this.m_current_color_mode == 10) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 13, ColorTable.get4BitPaletteIndexColorModel());
        } else if (this.m_current_color_mode == 3) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 13, ColorTable.get4BitGreyIndexColorModel());
        } else if (this.m_current_color_mode == 2) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 13, ColorTable.get3BitGreyIndexColorModel());
        } else {
            JOptionPane.showMessageDialog(this, LocaleStrings.GetString("E_8_JVIEW"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
        }
        if (this.app != null) {
            this.app.getJVMenu().notifyColorMode(this.m_current_color_mode);
        }
    }

    public void sendDVO() {
        KVMClient kvmClnt = this.app.getKVMClient();
        this.m_USBKeyRep.set(68, 1, true);
        kvmClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(86, 1, true);
        kvmClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(79, 1, true);
        kvmClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(10, 1, true);
        kvmClnt.sendKMMessage(this.m_USBKeyRep);
    }

    private void wait100ms() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class RCFocusListener
    extends FocusAdapter {
        RCFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            KVMClient kvmClnt;
            if (JViewerView.this.m_bLeftCtrlDown) {
                kvmClnt = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBKeyRep.set(17, 2, false);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_bLeftCtrlDown = false;
            }
            if (JViewerView.this.m_bRightCtrlDown) {
                kvmClnt = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBKeyRep.set(17, 3, false);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_bRightCtrlDown = false;
            }
            if (JViewerView.this.m_bLeftAltDown) {
                kvmClnt = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBKeyRep.set(18, 2, false);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_bLeftAltDown = false;
            }
            if (JViewerView.this.m_bRightAltDown) {
                kvmClnt = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBKeyRep.set(18, 3, false);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_bRightAltDown = false;
            }
        }
    }

    class RCMouseListener
    extends MouseInputAdapter {
        public static final byte MOUSE_MOVE = 0;
        public static final byte LBUTTON_DOWN = 1;
        public static final byte RBUTTON_DOWN = 2;
        public static final byte MBUTTON_DOWN = 4;
        private byte m_btnStatus = 0;
        private boolean m_bDisable = false;

        RCMouseListener() {
        }

        public void DisableEvents(boolean disable) {
            this.m_bDisable = disable;
        }

        public void mousePressed(MouseEvent e) {
            e.getComponent().requestFocusInWindow();
            int curX = e.getX();
            int curY = e.getY();
            if (curX < 0) {
                curX = 0;
            }
            if (curY < 0) {
                curY = 0;
            }
            if (this.m_bDisable) {
                e.consume();
                return;
            }
            switch (e.getButton()) {
                case 1: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 1);
                    break;
                }
                case 2: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 4);
                    break;
                }
                case 3: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 2);
                    break;
                }
                default: {
                    return;
                }
            }
            if (curX < JViewerView.this.m_act_width && curY < JViewerView.this.m_act_height) {
                KVMClient kvmClnt = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, 0, 0, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
            }
        }

        public void mouseReleased(MouseEvent e) {
            int curX = e.getX();
            int curY = e.getY();
            if (curX < 0) {
                curX = 0;
            }
            if (curY < 0) {
                curY = 0;
            }
            if (this.m_bDisable) {
                e.consume();
                return;
            }
            switch (e.getButton()) {
                case 1: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFE);
                    break;
                }
                case 2: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFB);
                    break;
                }
                case 3: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFD);
                    break;
                }
                default: {
                    return;
                }
            }
            if (curX < JViewerView.this.m_act_width && curY < JViewerView.this.m_act_height) {
                KVMClient kvmClnt = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, 0, 0, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
            }
        }

        private Point calculateCenter() {
            Container topLevelWindow = JViewerView.this.getTopLevelAncestor();
            Dimension screenSize = topLevelWindow.getSize();
            Point windowCenter = new Point(screenSize.width / 2, screenSize.height / 2);
            return windowCenter;
        }

        public void mouseMoved(MouseEvent e) {
            if (this.m_bDisable) {
                e.consume();
                return;
            }
            int curX = e.getX();
            int curY = e.getY();
            if (curX < 0) {
                curX = 0;
            }
            if (curY < 0) {
                curY = 0;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE) {
                if (curX < JViewerView.this.m_act_width && curY < JViewerView.this.m_act_height) {
                    KVMClient kvmClnt = JViewerView.this.app.getKVMClient();
                    JViewerView.this.m_USBMouseRep.set((byte)0, curX, curY, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                    kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
                }
                return;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                if (curX >= JViewerView.this.m_act_width || curY >= JViewerView.this.m_act_height) {
                    JViewerView.this.m_bMouseWasOut = true;
                    return;
                }
                if (JViewerView.this.m_bMouseWasOut) {
                    JViewerView.this.mouse_resync_linux_mode(curX, curY);
                    JViewerView.this.m_bMouseWasOut = false;
                    return;
                }
                int xDisp = curX - JViewerView.this.lastX;
                int yDisp = curY - JViewerView.this.lastY;
                this.splitandsend(xDisp, yDisp, true);
                JViewerView.this.lastX = curX;
                JViewerView.this.lastY = curY;
            } else {
                if (curX >= JViewerView.this.m_act_width || curY >= JViewerView.this.m_act_height) {
                    return;
                }
                int xDisp = curX - JViewerView.this.lastX;
                int yDisp = curY - JViewerView.this.lastY;
                this.splitandsend(xDisp, yDisp, false);
                JViewerView.this.lastX = curX;
                JViewerView.this.lastY = curY;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.m_bDisable) {
                e.consume();
                return;
            }
            this.m_btnStatus = (byte)(this.m_btnStatus | 1);
            int curX = e.getX();
            int curY = e.getY();
            if (curX < 0) {
                curX = 0;
            }
            if (curY < 0) {
                curY = 0;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE) {
                if (curX < JViewerView.this.m_act_width && curY < JViewerView.this.m_act_height) {
                    KVMClient kvmClnt = JViewerView.this.app.getKVMClient();
                    JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, curX, curY, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                    kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
                }
                return;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                if (curX >= JViewerView.this.m_act_width || curY >= JViewerView.this.m_act_height) {
                    JViewerView.this.m_bMouseWasOut = true;
                    return;
                }
                if (JViewerView.this.m_bMouseWasOut) {
                    JViewerView.this.mouse_resync_linux_mode(curX, curY);
                    JViewerView.this.m_bMouseWasOut = false;
                    return;
                }
                int xDisp = curX - JViewerView.this.lastX;
                int yDisp = curY - JViewerView.this.lastY;
                this.splitandsend(xDisp, yDisp, true);
                JViewerView.this.lastX = curX;
                JViewerView.this.lastY = curY;
            } else {
                if (curX >= JViewerView.this.m_act_width || curY >= JViewerView.this.m_act_height) {
                    return;
                }
                int xDisp = curX - JViewerView.this.lastX;
                int yDisp = curY - JViewerView.this.lastY;
                this.splitandsend(xDisp, yDisp, false);
                JViewerView.this.lastX = curX;
                JViewerView.this.lastY = curY;
            }
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().requestFocusInWindow();
        }

        public void mouseExited(MouseEvent e) {
            JViewerView.this.m_bMouseWasOut = true;
        }

        public void splitandsend(int xDisp, int yDisp, boolean isLinuxMode) {
            int xDir = xDisp >= 0 ? 1 : -1;
            int yDir = yDisp >= 0 ? 1 : -1;
            xDisp = Math.abs(xDisp);
            yDisp = Math.abs(yDisp);
            do {
                int x = xDisp > 126 ? 126 : xDisp;
                int y = yDisp > 126 ? 126 : yDisp;
                xDisp -= x;
                yDisp -= y;
                if (isLinuxMode) {
                    this.send_linux_mouse_mode_report(x * xDir, y * yDir);
                    continue;
                }
                KVMClient kvmClnt = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, x * xDir, y * yDir, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
            } while (xDisp > 0 || yDisp > 0);
        }

        private int ABS(int x) {
            return x < 0 ? -x : x;
        }

        private float ABS(float x) {
            return x < 0.0f ? -x : x;
        }

        private void sendto_linux_target(int dx, int dy) {
            KVMClient kvmClnt = JViewerView.this.app.getKVMClient();
            JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, dx, dy, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
        }

        private int send_linux_mouse_mode_report(int dx, int dy) {
            if (this.ABS(dx) + this.ABS(dy) < 4) {
                this.sendto_linux_target(dx, dy);
                return 0;
            }
            int first_dx = dx / 2;
            int first_dy = dy / 2;
            if (first_dx != 0 || first_dy != 0) {
                if (this.ABS(first_dx) + this.ABS(first_dy) >= 4) {
                    this.sendto_linux_target(first_dx, first_dy);
                } else {
                    for (int i = 0; i < 2; ++i) {
                        this.sendto_linux_target(first_dx, first_dy);
                    }
                }
            }
            int second_dx = dx % 2;
            int second_dy = dy % 2;
            if (second_dx != 0 || second_dy != 0) {
                if (this.ABS(second_dx) + this.ABS(second_dy) < 4) {
                    this.sendto_linux_target(second_dx, second_dy);
                } else {
                    float div_factor = (float)(this.ABS(second_dx) + this.ABS(second_dy)) / 3.0f;
                    float div_x = (float)second_dx / div_factor;
                    float div_y = (float)second_dy / div_factor;
                    float total_x_sent = 0.0f;
                    float total_y_sent = 0.0f;
                    float cummulative_dx = 0.0f;
                    float cummulative_dy = 0.0f;
                    int total_rounded_x = 0;
                    int total_rounded_y = 0;
                    while (this.ABS(total_x_sent) < (float)this.ABS(second_dx) || this.ABS(total_y_sent) < (float)this.ABS(second_dy)) {
                        this.sendto_linux_target((int)((cummulative_dx += div_x) - (float)total_rounded_x), (int)((cummulative_dy += div_y) - (float)total_rounded_y));
                        total_x_sent = cummulative_dx;
                        total_y_sent = cummulative_dy;
                        total_rounded_x = (int)total_x_sent;
                        total_rounded_y = (int)total_y_sent;
                    }
                }
            }
            return 0;
        }
    }

    class RCDoubleClickListener
    extends MouseInputAdapter {
        private boolean m_bDisable = false;

        RCDoubleClickListener() {
        }

        public void DisableEvents(boolean disable) {
            this.m_bDisable = disable;
        }

        public void StartMouseRedirectionOnDblClick() {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.m_bDisable) {
                e.consume();
                return;
            }
            if (e.getClickCount() == 2 && !JViewerView.this.m_bMouseRedirRunning) {
                Debug.out.println("Double click");
                JViewerView.this.app.OnUSBMouseSyncCursor(true);
            }
        }
    }

    class RCKeyListener
    extends KeyAdapter {
        private boolean m_bDisable = false;

        RCKeyListener() {
        }

        public void DisableEvents(boolean disable) {
            this.m_bDisable = disable;
        }

        public void keyPressed(KeyEvent e) {
            if (this.m_bDisable) {
                e.consume();
                return;
            }
            KVMClient kvmClnt = JViewerView.this.app.getKVMClient();
            if (e.getKeyCode() == 524) {
                e.consume();
                return;
            }
            if (e.getKeyCode() == 144 || e.getKeyCode() == 20 || e.getKeyCode() == 145) {
                kvmClnt.send_keybd_led_sync_pkt(JViewerView.this.m_USBKeyRep.getModifiers());
                e.consume();
                return;
            }
            if (!JViewerView.this.app.m_FullKeyboard && (e.getModifiersEx() & 0x200) == 512) {
                if (JViewerView.this.app.isFullScreenMode()) {
                    if (e.getKeyCode() == 70) {
                        JViewerView.this.app.OnVideoFullScreen(false);
                    } else if (e.getKeyCode() == 77) {
                        if (JViewerView.this.m_bMouseRedirRunning) {
                            JViewerView.this.app.OnUSBMouseSyncCursor(false);
                        } else {
                            JViewerView.this.app.OnUSBMouseSyncCursor(true);
                        }
                    }
                    e.consume();
                }
                return;
            }
            if ((e.getModifiersEx() & 0x80) == 128) {
                if (e.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftCtrlDown = true;
                } else {
                    JViewerView.this.m_bRightCtrlDown = true;
                }
            }
            if ((e.getModifiersEx() & 0x200) == 512) {
                if (e.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftAltDown = true;
                } else {
                    JViewerView.this.m_bRightAltDown = true;
                }
            }
            JViewerView.this.m_USBKeyRep.set(e.getKeyCode(), e.getKeyLocation(), true);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
            e.consume();
        }

        public void keyReleased(KeyEvent e) {
            if (this.m_bDisable) {
                e.consume();
                return;
            }
            KVMClient kvmClnt = JViewerView.this.app.getKVMClient();
            if ((e.getModifiersEx() & 0x200) == 512) {
                return;
            }
            if ((e.getModifiersEx() & 0x80) == 128) {
                if (e.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftCtrlDown = false;
                } else {
                    JViewerView.this.m_bRightCtrlDown = false;
                }
            }
            JViewerView.this.m_USBKeyRep.set(e.getKeyCode(), e.getKeyLocation(), false);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
            e.consume();
        }
    }
}

