/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.FSMenu;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JVStatusBar;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerContainer;
import com.ami.kvm.jviewer.gui.JViewerPanel_jFullScreenButton_actionAdapter;
import com.ami.kvm.jviewer.gui.JViewerPanel_jRefreshButton_actionAdapter;
import com.ami.kvm.jviewer.gui.JViewerPanel_jScreenShotButton_actionAdapter;
import com.ami.kvm.jviewer.gui.JViewerPanel_jSoftKeyboardButton_actionAdapter;
import com.ami.kvm.jviewer.gui.JViewerPanel_jStartButton_actionAdapter;
import com.ami.kvm.jviewer.gui.JViewerPanel_jStopButton_actionAdapter;
import com.ami.kvm.jviewer.gui.JViewerPanel_jVirtualMediaButton_actionAdapter;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class JViewerPanel
extends JPanel
implements JViewerContainer {
    public JViewerApp app;
    JScrollPane m_viewSP;
    JVStatusBar m_status;
    FSMenu m_fsMenu;
    JPopupMenu m_popupMenu;
    ImageIcon start = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/start.gif"));
    ImageIcon pause = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/pause.gif"));
    ImageIcon stop = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/stop.gif"));
    ImageIcon screenshot = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/screenshot.gif"));
    ImageIcon fullscreen = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/fullscreen.gif"));
    ImageIcon refresh = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/refresh.gif"));
    ImageIcon vmedia = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/vmedia.gif"));
    ImageIcon softkb = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/keyboard.gif"));
    ImageIcon menu = new ImageIcon(this.getClass().getResource("/com/ami/kvm/jviewer/res/jviewer.jpg"));
    public JButton jStartButton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar jToolBar = new JToolBar();
    JButton jStopButton = new JButton();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JToolBar jMenuToolBar = new JToolBar();
    JButton jMenuButton = new JButton();
    JButton jFullScreenButton = new JButton();
    JButton jScreenShotButton = new JButton();
    JButton jRefreshButton = new JButton();
    JButton jVirtualMediaButton = new JButton();
    JButton label = new JButton("Full screen mode");
    JLabel jfpsLabel = new JLabel();
    JButton jSoftKeyboardButton = new JButton();

    public JViewerPanel(JViewerApp app) {
        this.app = app;
        try {
            this.jbInit();
            this.constructUserIf();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jStopButton.setToolTipText(LocaleStrings.GetString("Stop"));
        this.jStopButton.setIcon(this.stop);
        this.jStopButton.addActionListener(new JViewerPanel_jStopButton_actionAdapter(this));
        this.jStartButton.setToolTipText(LocaleStrings.GetString("Start"));
        this.jStartButton.setIcon(this.start);
        this.jStartButton.addActionListener(new JViewerPanel_jStartButton_actionAdapter(this));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jMenuButton.setIcon(this.menu);
        this.jMenuButton.setText(LocaleStrings.GetString("Menu"));
        this.jToolBar.setFloatable(false);
        this.jMenuToolBar.setFloatable(false);
        this.jFullScreenButton.setToolTipText(LocaleStrings.GetString("Full Screen"));
        this.jFullScreenButton.setIcon(this.fullscreen);
        this.jFullScreenButton.setText(LocaleStrings.GetString("Full Screen"));
        this.jFullScreenButton.addActionListener(new JViewerPanel_jFullScreenButton_actionAdapter(this));
        this.jScreenShotButton.setToolTipText(LocaleStrings.GetString("Screenshot"));
        this.jScreenShotButton.setIcon(this.screenshot);
        this.jScreenShotButton.addActionListener(new JViewerPanel_jScreenShotButton_actionAdapter(this));
        this.jRefreshButton.setToolTipText(LocaleStrings.GetString("Refresh"));
        this.jRefreshButton.setIcon(this.refresh);
        this.jRefreshButton.addActionListener(new JViewerPanel_jRefreshButton_actionAdapter(this));
        this.jVirtualMediaButton.setToolTipText(LocaleStrings.GetString("Virtual Media"));
        this.jVirtualMediaButton.setIcon(this.vmedia);
        this.jVirtualMediaButton.setText(LocaleStrings.GetString("Virtual Media"));
        this.jVirtualMediaButton.addActionListener(new JViewerPanel_jVirtualMediaButton_actionAdapter(this));
        this.jSoftKeyboardButton.setIcon(this.softkb);
        this.jSoftKeyboardButton.setText(LocaleStrings.GetString("Soft Keyboard"));
        this.jSoftKeyboardButton.addActionListener(new JViewerPanel_jSoftKeyboardButton_actionAdapter(this));
        this.jToolBar.add(this.jStartButton);
        this.jToolBar.add(this.jStopButton);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.jScreenShotButton);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.jRefreshButton);
        this.jMenuToolBar.add(this.jfpsLabel);
        this.jMenuToolBar.addSeparator();
        this.jMenuToolBar.add(this.jMenuButton);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.jFullScreenButton);
        this.jToolBar.add(this.jVirtualMediaButton);
        this.jToolBar.add(this.jSoftKeyboardButton);
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jToolBar, "West");
        this.jPanel1.add((Component)this.jMenuToolBar, "East");
    }

    public void getWindowFocus() {
        this.app.getRCView().setFocusable(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        boolean b = this.app.getRCView().requestFocusInWindow();
    }

    public void setConnectedUIStatus() {
        this.jStartButton.setEnabled(false);
        this.jStopButton.setEnabled(true);
        this.jFullScreenButton.setEnabled(true);
        this.jScreenShotButton.setEnabled(true);
        this.jRefreshButton.setEnabled(true);
        this.jMenuButton.setEnabled(true);
        this.jSoftKeyboardButton.setEnabled(true);
    }

    public void setDisconnectedUIStatus() {
        this.jStartButton.setEnabled(true);
        this.jStopButton.setEnabled(false);
        this.jFullScreenButton.setEnabled(false);
        this.jScreenShotButton.setEnabled(false);
        this.jRefreshButton.setEnabled(false);
        this.jMenuButton.setEnabled(false);
        this.jSoftKeyboardButton.setEnabled(false);
    }

    public void setAllDisableUIStatus() {
        this.jStartButton.setEnabled(false);
        this.jStopButton.setEnabled(false);
        this.jFullScreenButton.setEnabled(false);
        this.jScreenShotButton.setEnabled(false);
        this.jRefreshButton.setEnabled(false);
        this.jMenuButton.setEnabled(false);
        this.jSoftKeyboardButton.setEnabled(false);
    }

    public void attachView() {
        this.m_viewSP = new JScrollPane(this.app.getRCView());
        this.m_viewSP.getHorizontalScrollBar().setUnitIncrement(10);
        this.m_viewSP.getVerticalScrollBar().setUnitIncrement(10);
        this.m_viewSP.setViewportBorder(null);
        this.m_viewSP.setBorder(null);
        this.add((Component)this.m_viewSP, "Center");
        this.validate();
    }

    public void detachView() {
        if (this.m_viewSP != null) {
            this.remove(this.m_viewSP);
        }
        this.validate();
    }

    public void showFullScreenModeMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JViewerPanel.this.helpShowFullScreenModeMessage();
            }
        });
    }

    public void helpShowFullScreenModeMessage() {
        this.label.setEnabled(false);
        this.add((Component)this.label, "Center");
        this.validate();
        this.label.repaint();
    }

    public void hideFullScreenModeMessage() {
        this.remove(this.label);
        this.invalidate();
    }

    private void constructUserIf() {
        this.m_fsMenu = new FSMenu(this.app);
        this.m_popupMenu = this.m_fsMenu.getPopupMenu();
        this.jMenuButton.addMouseListener(new PopupListener());
        this.m_status = new JVStatusBar();
        this.add((Component)this.m_status.getStatusBar(), "Last");
        this.m_status.setStatus(LocaleStrings.GetString("A_1_GLOBAL") + LocaleStrings.GetString("Z_1_MISC") + "... ");
    }

    public JVMenu getMenu() {
        return this.m_fsMenu;
    }

    public void setStatus(String msg) {
        this.m_status.setStatus(msg);
    }

    public void resetStatus() {
        this.m_status.resetStatus();
    }

    public void exitApp() {
    }

    public void setWndLabel(String label) {
        this.jfpsLabel.setText(label);
    }

    public void jStartButton_actionPerformed(ActionEvent e) {
        this.app.OnVideoStartRedirection();
    }

    public void jPauseButton_actionPerformed(ActionEvent e) {
        this.app.OnVideoPause();
    }

    public void jStopButton_actionPerformed(ActionEvent e) {
        this.app.OnVideoStopRedirection();
    }

    public void jFullScreenButton_actionPerformed(ActionEvent e) {
        this.app.OnVideoFullScreen(true);
    }

    public void jScreenShotButton_actionPerformed(ActionEvent e) {
        this.app.OnVideoCapture();
    }

    public void jRefreshButton_actionPerformed(ActionEvent e) {
        this.app.OnVideoRefresh();
    }

    public void jVirtualMediaButton_actionPerformed(ActionEvent e) {
        this.app.OnvMedia();
    }

    public void jSoftKeyboardButton_actionPerformed(ActionEvent e) {
        this.app.OnSoftKeyboard();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (((JComponent)e.getSource()).isEnabled()) {
                Debug.out.println("Popup event");
                JViewerPanel.this.m_popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

