/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public abstract class JVMenu {
    public JViewerApp app;
    JMenuItem menuItemMouseModeAbsolute;
    JMenuItem menuItemMouseModeRelative;
    public static final String VIDEO_FULL_SCREEN = "VideoFullScreen";
    public static final String VIDEO_EXIT = "VideoExit";
    public static final String VIDEO_PAUSE = "PauseVideo";
    public static final String VIDEO_RESUME = "ResumeVideo";
    public static final String VIDEO_REFRESH = "RefreshVideo";
    public static final String VIDEO_CAPTURE = "VideoCapture";
    public static final String KEYBOARD_RIGHT_ALT_KEY = "KeyboardHoldRightAltKey";
    public static final String KEYBOARD_LEFT_ALT_KEY = "KeyboardHoldLeftAltKey";
    public static final String KEYBOARD_LEFT_WINKEY_PRESSHOLD = "KeyboardLeftWindowsKeyHoldDown";
    public static final String KEYBOARD_LEFT_WINKEY_PRESSRELEASE = "KeyboardLeftWindowsKeyPressRelease";
    public static final String KEYBOARD_RIGHT_WINKEY_PRESSHOLD = "KeyboardRightWindowsKeyHoldDown";
    public static final String KEYBOARD_RIGHT_WINKEY_PRESSRELEASE = "KeyboardRightWindowsKeyPressRelease";
    public static final String KEYBOARD_CTRL_ALT_DEL = "KeyboardAltCtrlDel";
    public static final String KEYBOARD_ALT_TAB = "KeyboardAltTab";
    public static final String KEYBOARD_ALT_ESC = "KeyboardAltEsc";
    public static final String KEYBOARD_CTRL_ESC = "KeyboardCtrlEsc";
    public static final String KEYBOARD_ALT_SPACE = "KeyboardAltSpace";
    public static final String KEYBOARD_ALT_ENTER = "KeyboardAltEnter";
    public static final String KEYBOARD_ALT_HYPHEN = "KeyboardAltHyphen";
    public static final String KEYBOARD_ALT_F4 = "KeyboardAltF4";
    public static final String KEYBOARD_ALT_PRNTSCRN = "KeyboardAltPrntScrn";
    public static final String KEYBOARD_PRNTSCRN = "KeyboardPrntScrn";
    public static final String KEYBOARD_F1 = "KeyboardF1";
    public static final String KEYBOARD_PAUSE = "KeyboardPause";
    public static final String KEYBOARD_FULL_KEYBOARD = "KeyboardFullKeyboard";
    public static final String KEYBOARD_SOFT_KEYBOARD = "KeyboardSoftKeyboard";
    public static final String MOUSE_SYNC_CURSOR = "MouseSyncCursor";
    public static final String MOUSE_MODE_ABSOLUTE = "MouseModeAbsolute";
    public static final String MOUSE_MODE_RELATIVE = "MouseModeRelative";
    public static final String DEVICE_MEDIA_DIALOG = "DeviceMediaDialog";
    public static final String OPTIONS_COLORMODE_15BIT = "15-Bit";
    public static final String OPTIONS_COLORMODE_7BIT = "7-Bit";
    public static final String OPTIONS_COLORMODE_4BIT_COLOR = "4-Bit color";
    public static final String OPTIONS_COLORMODE_4BIT_GREY = "4-Bit grey";
    public static final String OPTIONS_COLORMODE_3BIT_GREY = "3-Bit grey";
    public static final String HELP_ABOUT_RCONSOLE = "HelpAboutJViewer";
    protected static JVMenuListener m_menuListener;
    protected static JVMenuStatusListener m_menuStatus;
    protected static JVMenuItemStatusListener m_itemStatus;
    protected Hashtable<String, JMenuItem> m_menuItems;
    protected static boolean m_stateRedir;
    protected static boolean m_stateFullScr;
    protected static boolean m_stateRAlt;
    protected static boolean m_stateLAlt;
    protected static boolean m_stateRWinDown;
    protected static boolean m_stateLWinDown;
    protected static boolean m_stateMouseRedir;
    protected static byte m_stateColorMode;

    public JVMenu(JViewerApp app) {
        this.app = app;
        m_menuListener = new JVMenuListener(app);
        m_menuStatus = new JVMenuStatusListener(app);
        m_itemStatus = new JVMenuItemStatusListener(app);
        this.m_menuItems = new Hashtable();
    }

    public JMenuItem getMenuItem(String name) {
        return this.m_menuItems.get(name);
    }

    public void notifyFullScreen(boolean state) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(VIDEO_FULL_SCREEN).setSelected(state);
            m_stateFullScr = state;
        }
    }

    public void notifyRAlt(boolean state) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(KEYBOARD_RIGHT_ALT_KEY).setSelected(state);
            m_stateRAlt = state;
        }
    }

    public void notifyLAlt(boolean state) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(KEYBOARD_LEFT_ALT_KEY).setSelected(state);
            m_stateLAlt = state;
        }
    }

    public void notifyRWinDown(boolean state) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(KEYBOARD_RIGHT_WINKEY_PRESSHOLD).setSelected(state);
            m_stateRWinDown = state;
        }
    }

    public void notifyLWinDown(boolean state) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(KEYBOARD_LEFT_WINKEY_PRESSHOLD).setSelected(state);
            m_stateLWinDown = state;
        }
    }

    public void notifyMouseRedir(boolean state) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            this.getMenuItem(MOUSE_SYNC_CURSOR).setSelected(state);
            m_stateMouseRedir = state;
        }
    }

    public void notifyColorMode(byte colormode) {
        if (this.app.getParams().isKVMUser() && this.app.getParams().isKVMEnabled()) {
            if (colormode == 8) {
                this.getMenuItem(OPTIONS_COLORMODE_15BIT).setSelected(true);
            } else if (colormode == 9) {
                this.getMenuItem(OPTIONS_COLORMODE_7BIT).setSelected(true);
            } else if (colormode == 10) {
                this.getMenuItem(OPTIONS_COLORMODE_4BIT_COLOR).setSelected(true);
            } else if (colormode == 3) {
                this.getMenuItem(OPTIONS_COLORMODE_4BIT_GREY).setSelected(true);
            } else if (colormode == 2) {
                this.getMenuItem(OPTIONS_COLORMODE_3BIT_GREY).setSelected(true);
            }
            m_stateColorMode = colormode;
        }
    }

    public void refreshMenu() {
        this.notifyFullScreen(m_stateFullScr);
        this.notifyRAlt(m_stateRAlt);
        this.notifyLAlt(m_stateLAlt);
        this.notifyRWinDown(m_stateRWinDown);
        this.notifyLWinDown(m_stateLWinDown);
        this.notifyMouseRedir(m_stateMouseRedir);
        this.notifyColorMode(m_stateColorMode);
    }

    protected JMenu constructVideoMenu() {
        JMenu menu = new JMenu(LocaleStrings.GetString("F_1_JVM"));
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('V');
        JMenuItem menuItem = new JMenuItem(LocaleStrings.GetString("F_2_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(VIDEO_PAUSE);
        menuItem.setMnemonic('P');
        menu.add(menuItem);
        this.m_menuItems.put(VIDEO_PAUSE, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_3_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(VIDEO_RESUME);
        menuItem.setMnemonic('R');
        menu.add(menuItem);
        this.m_menuItems.put(VIDEO_RESUME, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_4_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(VIDEO_REFRESH);
        menuItem.setMnemonic('s');
        menu.add(menuItem);
        this.m_menuItems.put(VIDEO_REFRESH, menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(LocaleStrings.GetString("F_5_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(VIDEO_CAPTURE);
        menuItem.setMnemonic('C');
        menu.add(menuItem);
        this.m_menuItems.put(VIDEO_CAPTURE, menuItem);
        menu.addSeparator();
        menuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_6_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setMnemonic('F');
        menuItem.setActionCommand(VIDEO_FULL_SCREEN);
        menu.add(menuItem);
        this.m_menuItems.put(VIDEO_FULL_SCREEN, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_7_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(VIDEO_EXIT);
        menuItem.setMnemonic('E');
        this.m_menuItems.put(VIDEO_EXIT, menuItem);
        return menu;
    }

    protected JMenu constructKeyboardMenu() {
        JMenu menu = new JMenu(LocaleStrings.GetString("F_8_JVM"));
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('K');
        JMenuItem menuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_9_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setMnemonic('A');
        menuItem.setActionCommand(KEYBOARD_RIGHT_ALT_KEY);
        menu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_RIGHT_ALT_KEY, menuItem);
        menuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_10_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setMnemonic('l');
        menuItem.setActionCommand(KEYBOARD_LEFT_ALT_KEY);
        menu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_LEFT_ALT_KEY, menuItem);
        JMenu subMenu = new JMenu(LocaleStrings.GetString("F_11_JVM"));
        subMenu.addMouseListener(m_menuStatus);
        menuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_12_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_LEFT_WINKEY_PRESSHOLD);
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_LEFT_WINKEY_PRESSHOLD, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_13_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_LEFT_WINKEY_PRESSRELEASE);
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_LEFT_WINKEY_PRESSRELEASE, menuItem);
        menu.add(subMenu);
        subMenu = new JMenu(LocaleStrings.GetString("F_14_JVM"));
        subMenu.addMouseListener(m_menuStatus);
        menuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_12_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_RIGHT_WINKEY_PRESSHOLD);
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_RIGHT_WINKEY_PRESSHOLD, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_13_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_RIGHT_WINKEY_PRESSRELEASE);
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_RIGHT_WINKEY_PRESSRELEASE, menuItem);
        menu.add(subMenu);
        subMenu = new JMenu(LocaleStrings.GetString("F_15_JVM"));
        subMenu.setMnemonic('M');
        subMenu.addMouseListener(m_itemStatus);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_16_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_CTRL_ALT_DEL);
        menuItem.setMnemonic('D');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_CTRL_ALT_DEL, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_17_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_ALT_TAB);
        menuItem.setMnemonic('T');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_ALT_TAB, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_18_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_ALT_ESC);
        menuItem.setMnemonic('E');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_ALT_ESC, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_19_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_CTRL_ESC);
        menuItem.setMnemonic('C');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_CTRL_ESC, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_20_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_ALT_SPACE);
        menuItem.setMnemonic('S');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_ALT_SPACE, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_21_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_ALT_ENTER);
        menuItem.setMnemonic('n');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_ALT_ENTER, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_22_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_ALT_HYPHEN);
        menuItem.setMnemonic('H');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_ALT_HYPHEN, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_23_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_ALT_F4);
        menuItem.setMnemonic('4');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_ALT_F4, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_24_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_ALT_PRNTSCRN);
        menuItem.setMnemonic('P');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_ALT_PRNTSCRN, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_25_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_PRNTSCRN);
        menuItem.setMnemonic('l');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_PRNTSCRN, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_26_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_F1);
        menuItem.setMnemonic('1');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_F1, menuItem);
        menuItem = new JMenuItem(LocaleStrings.GetString("F_27_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_PAUSE);
        menuItem.setMnemonic('u');
        subMenu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_PAUSE, menuItem);
        menu.add(subMenu);
        menuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_28_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_FULL_KEYBOARD);
        menuItem.setMnemonic('K');
        menu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_FULL_KEYBOARD, menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Soft Keyboard");
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(KEYBOARD_SOFT_KEYBOARD);
        menuItem.setMnemonic('S');
        menu.add(menuItem);
        this.m_menuItems.put(KEYBOARD_SOFT_KEYBOARD, menuItem);
        return menu;
    }

    protected JMenu constructMouseMenu() {
        JMenu menu = new JMenu(LocaleStrings.GetString("F_29_JVM"));
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('u');
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(LocaleStrings.GetString("F_30_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(MOUSE_SYNC_CURSOR);
        menuItem.setMnemonic('S');
        menu.add(menuItem);
        this.m_menuItems.put(MOUSE_SYNC_CURSOR, menuItem);
        menu.addSeparator();
        this.menuItemMouseModeAbsolute = new JRadioButtonMenuItem(LocaleStrings.GetString("F_SM_01_JVM"));
        this.menuItemMouseModeAbsolute.addActionListener(m_menuListener);
        this.menuItemMouseModeAbsolute.addMouseListener(m_itemStatus);
        this.menuItemMouseModeAbsolute.setActionCommand(MOUSE_MODE_ABSOLUTE);
        menu.add(this.menuItemMouseModeAbsolute);
        this.m_menuItems.put(MOUSE_MODE_ABSOLUTE, this.menuItemMouseModeAbsolute);
        this.menuItemMouseModeRelative = new JRadioButtonMenuItem(LocaleStrings.GetString("F_SM_02_JVM"));
        this.menuItemMouseModeRelative.addActionListener(m_menuListener);
        this.menuItemMouseModeRelative.addMouseListener(m_itemStatus);
        this.menuItemMouseModeRelative.setActionCommand(MOUSE_MODE_RELATIVE);
        menu.add(this.menuItemMouseModeRelative);
        this.m_menuItems.put(MOUSE_MODE_RELATIVE, this.menuItemMouseModeRelative);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.menuItemMouseModeAbsolute);
        bg.add(this.menuItemMouseModeRelative);
        return menu;
    }

    protected JMenu constructOptionsMenu() {
        JMenu menu = new JMenu(LocaleStrings.GetString("F_31_JVM"));
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('O');
        JMenu subMenu = new JMenu(LocaleStrings.GetString("F_32_JVM"));
        subMenu.addMouseListener(m_menuStatus);
        subMenu.setMnemonic('C');
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(LocaleStrings.GetString("F_33_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(OPTIONS_COLORMODE_15BIT);
        menuItem.setSelected(true);
        menuItem.setMnemonic('1');
        group.add(menuItem);
        subMenu.add(menuItem);
        this.m_menuItems.put(OPTIONS_COLORMODE_15BIT, menuItem);
        menuItem = new JRadioButtonMenuItem(LocaleStrings.GetString("F_34_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(OPTIONS_COLORMODE_7BIT);
        menuItem.setMnemonic('7');
        group.add(menuItem);
        subMenu.add(menuItem);
        this.m_menuItems.put(OPTIONS_COLORMODE_7BIT, menuItem);
        menu.add(subMenu);
        return menu;
    }

    protected JMenu constructDeviceRedirMenu() {
        JMenu menu = new JMenu(LocaleStrings.GetString("F_38_JVM"));
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('e');
        JMenuItem menuItem = new JMenuItem(LocaleStrings.GetString("F_39_JVM"));
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(DEVICE_MEDIA_DIALOG);
        menuItem.setMnemonic('V');
        menu.add(menuItem);
        this.m_menuItems.put(DEVICE_MEDIA_DIALOG, menuItem);
        return menu;
    }

    protected JMenu constructHelpMenu() {
        JMenu menu = new JMenu(LocaleStrings.GetString("F_40_JVM"));
        menu.setMnemonic('H');
        menu.addMouseListener(m_menuStatus);
        JMenuItem menuItem = new JMenuItem(LocaleStrings.GetString("F_41_JVM") + " " + LocaleStrings.GetString("A_1_GLOBAL") + "...");
        menuItem.addActionListener(m_menuListener);
        menuItem.addMouseListener(m_itemStatus);
        menuItem.setActionCommand(HELP_ABOUT_RCONSOLE);
        menuItem.setMnemonic('A');
        menu.add(menuItem);
        this.m_menuItems.put(HELP_ABOUT_RCONSOLE, menuItem);
        return menu;
    }

    public void setMouseMode(byte mode) {
        switch (mode) {
            case 2: {
                this.menuItemMouseModeAbsolute.setSelected(true);
                this.menuItemMouseModeRelative.setSelected(false);
                break;
            }
            case 1: {
                this.menuItemMouseModeAbsolute.setSelected(false);
                this.menuItemMouseModeRelative.setSelected(true);
                break;
            }
        }
    }

    static {
        m_stateRedir = false;
        m_stateFullScr = false;
        m_stateRAlt = false;
        m_stateLAlt = false;
        m_stateRWinDown = false;
        m_stateLWinDown = false;
        m_stateMouseRedir = false;
        m_stateColorMode = (byte)8;
    }

    class GridMenu
    extends JMenu {
        GridMenu(String label, int rows, int cols) {
            super(label);
            JPopupMenu pm = this.getPopupMenu();
            pm.setLayout(new GridLayout(rows, cols));
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void setPopupMenuVisible(boolean b) {
            boolean isVisible = this.isPopupMenuVisible();
            if (b != isVisible) {
                if (b && this.isShowing()) {
                    int x = this.getWidth();
                    int y = 0;
                    this.getPopupMenu().show(this, x, y);
                } else {
                    this.getPopupMenu().setVisible(false);
                }
            }
        }
    }

    private static class JVMenuItemStatusListener
    extends MouseAdapter {
        JViewerApp app;

        public JVMenuItemStatusListener(JViewerApp app) {
            this.app = app;
        }

        public void mouseEntered(MouseEvent e) {
            String cmdStr = ((JMenuItem)e.getSource()).getActionCommand();
            if (cmdStr.equals(JVMenu.VIDEO_FULL_SCREEN)) {
                this.app.setStatus(LocaleStrings.GetString("F_47_JVM"));
            } else if (cmdStr.equals(JVMenu.VIDEO_EXIT)) {
                this.app.setStatus(LocaleStrings.GetString("F_7_JVM") + " " + LocaleStrings.GetString("A_1_GLOBAL"));
            } else if (cmdStr.equals(JVMenu.VIDEO_PAUSE)) {
                this.app.setStatus(LocaleStrings.GetString("F_48_JVM"));
            } else if (cmdStr.equals(JVMenu.VIDEO_RESUME)) {
                this.app.setStatus(LocaleStrings.GetString("F_49_JVM"));
            } else if (cmdStr.equals(JVMenu.VIDEO_REFRESH)) {
                this.app.setStatus(LocaleStrings.GetString("F_50_JVM"));
            } else if (cmdStr.equals(JVMenu.VIDEO_CAPTURE)) {
                this.app.setStatus(LocaleStrings.GetString("F_51_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_ALT_KEY)) {
                this.app.setStatus(LocaleStrings.GetString("F_52_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_ALT_KEY)) {
                this.app.setStatus(LocaleStrings.GetString("F_53_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSHOLD)) {
                this.app.setStatus(LocaleStrings.GetString("F_54_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSRELEASE)) {
                this.app.setStatus(LocaleStrings.GetString("F_55_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSHOLD)) {
                this.app.setStatus(LocaleStrings.GetString("F_56_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSRELEASE)) {
                this.app.setStatus(LocaleStrings.GetString("F_57_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_CTRL_ALT_DEL)) {
                this.app.setStatus(LocaleStrings.GetString("F_58_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_TAB)) {
                this.app.setStatus(LocaleStrings.GetString("F_59_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_ESC)) {
                this.app.setStatus(LocaleStrings.GetString("F_60_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_CTRL_ESC)) {
                this.app.setStatus(LocaleStrings.GetString("F_61_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_SPACE)) {
                this.app.setStatus(LocaleStrings.GetString("F_62_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_ENTER)) {
                this.app.setStatus(LocaleStrings.GetString("F_63_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_HYPHEN)) {
                this.app.setStatus(LocaleStrings.GetString("F_64_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_F4)) {
                this.app.setStatus(LocaleStrings.GetString("F_65_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_PRNTSCRN)) {
                this.app.setStatus(LocaleStrings.GetString("F_66_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_PRNTSCRN)) {
                this.app.setStatus(LocaleStrings.GetString("F_67_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_F1)) {
                this.app.setStatus(LocaleStrings.GetString("F_68_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_PAUSE)) {
                this.app.setStatus(LocaleStrings.GetString("F_69_JVM"));
            } else if (cmdStr.equals(JVMenu.KEYBOARD_FULL_KEYBOARD)) {
                this.app.setStatus(LocaleStrings.GetString("F_70_JVM"));
            } else if (cmdStr.equals(JVMenu.MOUSE_SYNC_CURSOR)) {
                this.app.setStatus(LocaleStrings.GetString("F_71_JVM"));
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_15BIT)) {
                this.app.setStatus(LocaleStrings.GetString("F_82_JVM"));
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_7BIT)) {
                this.app.setStatus(LocaleStrings.GetString("F_83_JVM"));
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_4BIT_COLOR)) {
                this.app.setStatus(LocaleStrings.GetString("F_84_JVM"));
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_4BIT_GREY)) {
                this.app.setStatus(LocaleStrings.GetString("F_85_JVM"));
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_3BIT_GREY)) {
                this.app.setStatus(LocaleStrings.GetString("F_86_JVM"));
            } else if (cmdStr.equals(JVMenu.DEVICE_MEDIA_DIALOG)) {
                this.app.setStatus(LocaleStrings.GetString("F_80_JVM"));
            } else if (cmdStr.equals(JVMenu.HELP_ABOUT_RCONSOLE)) {
                this.app.setStatus(LocaleStrings.GetString("F_41_JVM") + " " + LocaleStrings.GetString("A_1_GLOBAL"));
            }
        }

        public void mouseExited(MouseEvent e) {
            this.app.resetStatus();
        }
    }

    private static class JVMenuStatusListener
    extends MouseAdapter {
        JViewerApp app;

        public JVMenuStatusListener(JViewerApp app) {
            this.app = app;
        }

        public void mouseEntered(MouseEvent e) {
            JMenu evtSrcItem = (JMenu)e.getSource();
            String menuBarLabel = evtSrcItem.getText();
            if (menuBarLabel.equals(LocaleStrings.GetString("F_1_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_42_JVM"));
            } else if (menuBarLabel.equals(LocaleStrings.GetString("F_8_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_43_JVM"));
            } else if (menuBarLabel.equals(LocaleStrings.GetString("F_29_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_44_JVM"));
            } else if (menuBarLabel.equals(LocaleStrings.GetString("F_31_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_45_JVM"));
            } else if (menuBarLabel.equals(LocaleStrings.GetString("F_38_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_79_JVM"));
            } else if (menuBarLabel.equals(LocaleStrings.GetString("F_32_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_81_JVM"));
            } else if (menuBarLabel.equals(LocaleStrings.GetString("F_40_JVM"))) {
                this.app.setStatus(LocaleStrings.GetString("F_46_JVM"));
            }
        }

        public void mouseExited(MouseEvent e) {
            this.app.resetStatus();
        }
    }

    private static class JVMenuListener
    implements ActionListener {
        JViewerApp app;

        public JVMenuListener(JViewerApp app) {
            this.app = app;
        }

        public void actionPerformed(ActionEvent e) {
            String cmdStr = e.getActionCommand();
            if (cmdStr.equals(JVMenu.VIDEO_FULL_SCREEN)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                this.app.OnVideoFullScreen(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.VIDEO_EXIT)) {
                this.app.OnVideoExit();
            } else if (cmdStr.equals(JVMenu.VIDEO_PAUSE)) {
                this.app.OnVideoPause();
            } else if (cmdStr.equals(JVMenu.VIDEO_RESUME)) {
                this.app.OnVideoResume();
            } else if (cmdStr.equals(JVMenu.VIDEO_REFRESH)) {
                this.app.OnVideoRefresh();
            } else if (cmdStr.equals(JVMenu.VIDEO_CAPTURE)) {
                this.app.OnVideoCapture();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_ALT_KEY)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                this.app.OnKeyboardHoldRightAltKey(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_ALT_KEY)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                this.app.OnKeyboardHoldLeftAltKey(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSHOLD)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                this.app.OnKeyboardLeftWindowsKeyHoldDown(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSRELEASE)) {
                this.app.OnKeyboardLeftWindowsKeyPressRelease();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSHOLD)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                this.app.OnKeyboardRightWindowsKeyHoldDown(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSRELEASE)) {
                this.app.OnKeyboardRightWindowsKeyPressRelease();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_CTRL_ALT_DEL)) {
                this.app.OnKeyboardAltCtrlDel();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_TAB)) {
                this.app.OnKeyboardAltTab();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_ESC)) {
                this.app.OnKeyboardAltEsc();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_CTRL_ESC)) {
                this.app.OnKeyboardCtrlEsc();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_SPACE)) {
                this.app.OnKeyboardAltSpace();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_ENTER)) {
                this.app.OnKeyboardAltEnter();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_HYPHEN)) {
                this.app.OnKeyboardAltHyphen();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_F4)) {
                this.app.OnKeyboardAltF4();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_ALT_PRNTSCRN)) {
                this.app.OnKeyboardAltPrntScrn();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_PRNTSCRN)) {
                this.app.OnKeyboardPrntScrn();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_F1)) {
                this.app.OnKeyboardF1();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_PAUSE)) {
                this.app.OnKeyboardPause();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_FULL_KEYBOARD)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                this.app.OnKeyboardFullKeyboard(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_SOFT_KEYBOARD)) {
                this.app.OnSoftKeyboard();
            } else if (cmdStr.equals(JVMenu.MOUSE_SYNC_CURSOR)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                this.app.OnUSBMouseSyncCursor(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.MOUSE_MODE_ABSOLUTE)) {
                this.app.OnMouseModeAbsolute();
            } else if (cmdStr.equals(JVMenu.MOUSE_MODE_RELATIVE)) {
                this.app.OnMouseModeRelative();
            } else if (cmdStr.equals(JVMenu.HELP_ABOUT_RCONSOLE)) {
                this.app.OnHelpAboutJViewer();
            } else if (cmdStr.equals(JVMenu.DEVICE_MEDIA_DIALOG)) {
                this.app.OnvMedia();
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_15BIT)) {
                this.app.OnChangeColorMode((byte)8);
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_7BIT)) {
                this.app.OnChangeColorMode((byte)9);
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_4BIT_COLOR)) {
                this.app.OnChangeColorMode((byte)10);
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_4BIT_GREY)) {
                this.app.OnChangeColorMode((byte)3);
            } else if (cmdStr.equals(JVMenu.OPTIONS_COLORMODE_3BIT_GREY)) {
                this.app.OnChangeColorMode((byte)2);
            }
        }
    }
}

