/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.FSFrame;
import com.ami.kvm.jviewer.gui.FSMenu;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FSMenuBar
extends JDialog {
    JViewerApp app;
    FSFrame m_frame;
    FSMenu m_fsMenu;
    JPopupMenu m_popupMenu;
    MouseEnterExit m_msEE;
    ButtonListener m_btnListener;
    private int m_slide = 0;
    private Timer m_timer;
    private boolean m_show;
    private JLabel m_idLbl;
    private JButton m_menuBtn;
    private JPanel m_autoPanel;
    private JButton m_autoPin;
    private JButton m_autoUnpin;
    private boolean m_auto;
    private JButton m_close;
    private JButton m_min;
    private JButton m_restore;

    public FSMenuBar(FSFrame frame, JViewerApp app) {
        super(frame);
        this.app = app;
        this.m_frame = frame;
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(sd.width / 2 - 200, 0, 400, this.m_slide);
        this.setUndecorated(true);
        this.setResizable(false);
        this.m_msEE = new MouseEnterExit();
        this.addMouseListener(this.m_msEE);
        this.addMouseListener(new WindowMouseEvents());
        this.m_btnListener = new ButtonListener();
        JComponent c = (JComponent)this.getContentPane();
        c.setBackground(new Color(250, 250, 250));
        c.setLayout(new BoxLayout(c, 0));
        c.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_autoPin = this.createButton("res/pin.jpg", LocaleStrings.GetString("B_1_FMB"), "Pin");
        this.m_autoUnpin = this.createButton("res/unpin.jpg", LocaleStrings.GetString("B_1_FMB"), "Unpin");
        this.m_autoPanel = new JPanel();
        this.m_autoPanel.setLayout(new BoxLayout(this.m_autoPanel, 0));
        this.m_autoPanel.setPreferredSize(new Dimension(15, 15));
        this.m_autoPanel.setMaximumSize(new Dimension(15, 15));
        this.m_autoPanel.add(this.m_autoPin);
        this.m_auto = false;
        c.add(this.m_autoPanel);
        c.add(Box.createRigidArea(new Dimension(50, 0)));
        this.m_menuBtn = this.createButton("res/menu.jpg", LocaleStrings.GetString("B_2_FMB"), "Menu");
        this.m_fsMenu = new FSMenu(app);
        this.m_popupMenu = this.m_fsMenu.getPopupMenu();
        this.m_popupMenu.addPopupMenuListener(new PopupMenuEventListener());
        this.m_menuBtn.addMouseListener(new PopupListener());
        c.add(this.m_menuBtn);
        c.add(Box.createRigidArea(new Dimension(65, 0)));
        this.m_idLbl = new JLabel(LocaleStrings.GetString("B_3_FMB"));
        this.m_idLbl.setForeground(new Color(0, 100, 100));
        this.m_idLbl.setFont(new Font("SansSerif", 0, 12));
        this.m_idLbl.setPreferredSize(new Dimension(150, 15));
        this.m_idLbl.setMaximumSize(new Dimension(150, 15));
        c.add(this.m_idLbl);
        c.add(Box.createRigidArea(new Dimension(48, 0)));
        this.m_min = this.createButton("res/min.jpg", LocaleStrings.GetString("B_4_FMB"), "Minimize");
        c.add(this.m_min);
        c.add(Box.createRigidArea(new Dimension(1, 0)));
        this.m_restore = this.createButton("res/max.jpg", LocaleStrings.GetString("B_5_FMB"), "ToFrame");
        c.add(this.m_restore);
        c.add(Box.createRigidArea(new Dimension(1, 0)));
        this.m_close = this.createButton("res/close.jpg", LocaleStrings.GetString("B_6_FMB"), "Close");
        c.add(this.m_close);
        c.add(Box.createHorizontalGlue());
    }

    public JVMenu getFSMenu() {
        return this.m_fsMenu;
    }

    public void showMenu() {
        this.m_show = true;
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new SlideTask(), 0L, 20L);
        if (this.app.isPanelMode()) {
            this.m_close.setVisible(false);
            this.m_min.setVisible(false);
        } else {
            this.m_close.setVisible(true);
            this.m_min.setVisible(true);
        }
    }

    public void hideMenu() {
        this.m_show = false;
        this.m_timer = new Timer();
        this.m_timer.schedule((TimerTask)new SlideTask(), 0L, 20L);
    }

    public void setIDLabel(String idLbl) {
        this.m_idLbl.setText(idLbl);
    }

    private void slide() {
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(sd.width / 2 - 200, 0, 400, this.m_slide);
        this.setVisible(true);
    }

    private JButton createButton(String image, String tip, String actionCmd) {
        URL imageURL = JViewer.class.getResource(image);
        JButton btn = new JButton();
        if (imageURL != null) {
            btn.setIcon(new ImageIcon(imageURL));
        }
        btn.setToolTipText(tip);
        btn.setPreferredSize(new Dimension(15, 15));
        btn.setMaximumSize(new Dimension(15, 15));
        btn.addMouseListener(this.m_msEE);
        btn.setActionCommand(actionCmd);
        btn.addActionListener(this.m_btnListener);
        return btn;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JViewerApp RCApp = FSMenuBar.this.app;
            String cmd = e.getActionCommand();
            if (cmd.equals("Unpin")) {
                Debug.out.println("Disable Auto hide");
                FSMenuBar.this.m_autoPanel.removeAll();
                FSMenuBar.this.m_autoPanel.add(FSMenuBar.this.m_autoPin);
                FSMenuBar.this.m_autoPanel.repaint();
                FSMenuBar.this.m_auto = false;
                FSMenuBar.this.app.getRCView().requestFocus();
            } else if (cmd.equals("Pin")) {
                Debug.out.println("Enable Auto hide");
                FSMenuBar.this.m_autoPanel.removeAll();
                FSMenuBar.this.m_autoPanel.add(FSMenuBar.this.m_autoUnpin);
                FSMenuBar.this.m_auto = true;
                FSMenuBar.this.app.getRCView().requestFocus();
            } else if (cmd.equals("ToFrame")) {
                Debug.out.println("Toggle to frame window");
                FSMenuBar.this.m_auto = false;
                RCApp.OnVideoFullScreen(false);
            } else if (cmd.equals("Minimize")) {
                Debug.out.println("Minimize");
                FSMenuBar.this.m_frame.setState(1);
            } else if (cmd.equals("Close")) {
                Debug.out.println("Close");
                RCApp.OnVideoExit();
            } else if (cmd.equals("Menu")) {
                Debug.out.println("Menu");
            } else {
                FSMenuBar.this.app.getRCView().requestFocus();
            }
        }
    }

    class PopupMenuEventListener
    implements PopupMenuListener {
        boolean m_autoCanceled = false;

        PopupMenuEventListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            Debug.out.println("Popup canceled");
            if (this.m_autoCanceled) {
                FSMenuBar.this.m_auto = true;
                this.m_autoCanceled = false;
                FSMenuBar.this.hideMenu();
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Debug.out.println("Popup visible");
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_auto = false;
                this.m_autoCanceled = true;
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            Debug.out.println("Popup invisible");
            if (this.m_autoCanceled) {
                FSMenuBar.this.m_auto = true;
                this.m_autoCanceled = false;
                FSMenuBar.this.hideMenu();
            }
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            Debug.out.println("Popup event");
            FSMenuBar.this.m_popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class MouseEnterExit
    extends MouseAdapter {
        MouseEnterExit() {
        }

        public void mouseEntered(MouseEvent e) {
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.showMenu();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (FSMenuBar.this.m_auto) {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.hideMenu();
            }
        }
    }

    class WindowMouseEvents
    extends MouseAdapter {
        WindowMouseEvents() {
        }

        public void mouseClicked(MouseEvent e) {
            FSMenuBar.this.app.getRCView().requestFocus();
        }
    }

    class SlideTask
    extends TimerTask {
        SlideTask() {
        }

        public void run() {
            if (FSMenuBar.this.m_show) {
                if (FSMenuBar.this.m_slide < 20) {
                    FSMenuBar.this.m_slide++;
                    FSMenuBar.this.slide();
                } else {
                    FSMenuBar.this.m_timer.cancel();
                    FSMenuBar.this.app.getRCView().requestFocus();
                }
            } else if (FSMenuBar.this.m_slide > 1) {
                FSMenuBar.this.m_slide--;
                FSMenuBar.this.slide();
            } else {
                FSMenuBar.this.m_timer.cancel();
                FSMenuBar.this.app.getRCView().requestFocus();
            }
        }
    }
}

