/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.MOut;
import java.awt.GraphicsEnvironment;
import java.io.IOException;

public class SMCJViewerPlugIn
extends CommandPlugIn {
    public void execute() throws Exception {
        if (!this.isKVMSupported()) {
            this.printUnavailableMessage();
            return;
        }
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.print("No graphic environment here !");
            return;
        }
        MOut.print("Starting JViewer Process...");
        try {
            Process p = Runtime.getRuntime().exec("java -jar JViewerSMC.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword());
        }
        catch (IOException ex) {
            MOut.println(" Failed");
            return;
        }
        MOut.println("Done");
        MOut.println("Please wait for JViewer window");
    }

    public boolean isKVMSupported() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            return false;
        }
        if (IPMIMessagingCommand.isAMIGUID(guid)) {
            return true;
        }
        return IPMIMessagingCommand.isAMISIMBLGUID(guid);
    }

    public void printUnavailableMessage() {
        MOut.println("This function is unavailable for this device.");
    }

    public String getAlternateValue() {
        return null;
    }

    public String getComment() {
        return "SIMSOW KVM console (graphic mode)";
    }

    public String getName() {
        return "kvmw";
    }

    public String getValue() {
        return "kvmw";
    }

    public boolean isSupportCLIMode() {
        return true;
    }

    public boolean isSupportShellMode() {
        return true;
    }

    public static void main(String[] args) {
    }
}

