/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.EncryptionException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.RedirHeader;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public abstract class RedirPacket {
    public RedirHeader header;
    protected boolean encrypted = false;
    protected Cipher packetCipher;
    protected SecretKeySpec encryptionKey;

    protected RedirPacket() {
    }

    public void setEncryptionMethod(Cipher packetCipher, SecretKeySpec encryptionKey) throws EncryptionException {
        try {
            this.encrypted = true;
            this.packetCipher = packetCipher;
            this.encryptionKey = encryptionKey;
            packetCipher.init(1, encryptionKey);
        }
        catch (InvalidKeyException e) {
            this.encrypted = false;
            throw new EncryptionException(LocaleStrings.GetString("9_1_IUSBREDIR"));
        }
    }

    protected void encryptData(ByteBuffer inBuffer, ByteBuffer outBuffer, int offset) throws EncryptionException {
        int dataLen = inBuffer.limit() - this.header.headerLen - offset;
        try {
            this.packetCipher.init(1, this.encryptionKey);
            inBuffer.limit(this.header.headerLen + offset);
            outBuffer.put(inBuffer);
            inBuffer.limit(inBuffer.capacity());
            this.packetCipher.doFinal(inBuffer, outBuffer);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException(LocaleStrings.GetString("9_1_IUSBREDIR"));
        }
        catch (ShortBufferException e) {
            throw new EncryptionException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new EncryptionException(e.getMessage());
        }
    }

    protected void encryptData(ByteBuffer inBuffer, ByteBuffer outBuffer) throws EncryptionException {
        this.encryptData(inBuffer, outBuffer, 0);
    }

    public int getPacketStatus() {
        return this.header.status;
    }

    public abstract void writePacket(ByteBuffer var1) throws EncryptionException;

    public abstract void readPacket(ByteBuffer var1) throws RedirectionException, BufferUnderflowException;

    public abstract void readData(ByteBuffer var1) throws BufferUnderflowException;
}

