/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.RedirPacket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class IUSBSCSI
extends RedirPacket {
    public int opcode;
    public int connectionStatus = -1;
    public int dataLen;
    private boolean packetRead = false;
    public ByteBuffer data;
    private boolean preBuffered;
    public static final int IUSB_SCSI_PKT_SIZE = 62;
    public String m_otherIP;

    public IUSBSCSI(IUSBHeader header) {
        this.header = header;
        this.dataLen = (int)header.dataPacketLen;
    }

    public IUSBSCSI(ByteBuffer packetBuffer, boolean preBuffered) throws RedirProtocolException {
        this.preBuffered = preBuffered;
        this.header = new IUSBHeader();
        this.header.read(packetBuffer);
        ((IUSBHeader)this.header).dataPacketLen = packetBuffer.limit() - this.header.headerLen;
        this.dataLen = (int)((IUSBHeader)this.header).dataPacketLen;
        this.data = packetBuffer.slice();
    }

    public void writePacket(ByteBuffer buffer) {
        ((IUSBHeader)this.header).direction = 128;
        this.header.write(buffer);
        if (this.preBuffered) {
            buffer.limit(this.dataLen + 32);
            buffer.position(buffer.limit());
        } else {
            buffer.put(this.data);
        }
    }

    public void readPacket(ByteBuffer buffer) throws RedirectionException, BufferUnderflowException {
        this.header.read(buffer);
        this.readData(buffer);
    }

    public void readData(ByteBuffer buffer) throws BufferUnderflowException {
        byte[] otherIP = new byte[24];
        this.data = ByteBuffer.allocate(this.dataLen);
        if (buffer.remaining() < this.dataLen) {
            throw new BufferUnderflowException();
        }
        this.data.put(buffer);
        this.opcode = this.data.get(9) & 0xFF;
        if (this.opcode == 241 && this.dataLen > 30) {
            this.connectionStatus = this.data.get(30);
            try {
                this.data.position(31);
                this.data.get(otherIP);
                this.m_otherIP = new String(otherIP).trim();
            }
            catch (BufferUnderflowException e) {
                System.err.println(e.getMessage());
                this.m_otherIP = new String("");
                throw new BufferUnderflowException();
            }
        } else {
            this.connectionStatus = -1;
        }
    }
}

