/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JListDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static JListDialog dialog;
    private static Object selection;
    private static JTextField manualTextField;
    private static boolean useManualField;
    private JList list;

    public JListDialog(Frame frame, Component locationComp, String labelText, String title, String manualText, Object[] data, Object initialValue) {
        super(frame, title, true);
        this.list = new JList<Object>(data);
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        JButton cancelButton = new JButton(LocaleStrings.GetString("1_3_Cancel"));
        cancelButton.setMnemonic('C');
        cancelButton.getAccessibleContext().setAccessibleDescription(LocaleStrings.GetString("7_1_JLIST"));
        cancelButton.addActionListener(this);
        JButton okButton = new JButton(LocaleStrings.GetString("1_2_OK"));
        okButton.setMnemonic('O');
        okButton.getAccessibleContext().setAccessibleDescription(LocaleStrings.GetString("7_2_JLIST"));
        okButton.addActionListener(this);
        okButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(okButton);
        JScrollPane listScroller = new JScrollPane(this.list);
        JLabel manualLabel = new JLabel(manualText);
        manualTextField = new JTextField((String)initialValue);
        manualTextField.getAccessibleContext().setAccessibleDescription(LocaleStrings.GetString("7_3_JLIST"));
        manualLabel.setLabelFor(manualTextField);
        this.list.addListSelectionListener(this);
        listScroller.setPreferredSize(new Dimension(200, 200));
        listScroller.setAlignmentX(0.0f);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        JLabel label = new JLabel(labelText);
        label.setLabelFor(this.list);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 10)));
        listPane.add(listScroller);
        if (manualText != null) {
            listPane.add(Box.createRigidArea(new Dimension(0, 10)));
            listPane.add(manualLabel);
            listPane.add(Box.createRigidArea(new Dimension(0, 5)));
            listPane.add(manualTextField);
            useManualField = true;
        } else {
            useManualField = false;
        }
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(okButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        if (initialValue != null) {
            this.setSelection(initialValue);
        } else {
            this.setSelection(data[0]);
        }
        this.pack();
        this.setLocationRelativeTo(locationComp);
    }

    public static Object showDialog(Component frameComp, Component locationComp, String labelText, String title, Object[] data, Object initialValue) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        dialog = new JListDialog(frame, locationComp, labelText, title, null, data, initialValue);
        dialog.getAccessibleContext().setAccessibleName(title + " " + LocaleStrings.GetString("7_4_JLIST"));
        dialog.getAccessibleContext().setAccessibleDescription(labelText);
        dialog.setVisible(true);
        return selection;
    }

    public static Object showDialog(Component frameComp, Component locationComp, String labelText, String title, String manualText, Object[] data, Object initialValue) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        dialog = new JListDialog(frame, locationComp, labelText, title, manualText, data, initialValue);
        dialog.getAccessibleContext().setAccessibleName(title + " " + LocaleStrings.GetString("7_4_JLIST"));
        dialog.getAccessibleContext().setAccessibleDescription(labelText);
        dialog.setVisible(true);
        return selection;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(LocaleStrings.GetString("1_2_OK"))) {
            if (useManualField) {
                this.setSelection(manualTextField.getText());
            } else {
                this.setSelection(this.list.getSelectedValue());
            }
        } else {
            selection = null;
        }
        this.setVisible(false);
    }

    public void valueChanged(ListSelectionEvent e) {
        manualTextField.setText((String)this.list.getSelectedValue());
    }

    public void setSelection(Object newSelection) {
        selection = newSelection;
        this.list.setSelectedValue(selection, true);
    }
}

