/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.FloppyProtocol;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FloppyRedir
extends Thread {
    JViewerApp app;
    private PacketMaster packetMaster;
    private FloppyProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private boolean physicalDevice;
    private String sourceFloppy = null;
    private int nBytesRedirected = 0;
    private static final int PORT = 5123;
    private static final int START_LOCAL_IMAGE_REDIRECTION = 240;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    public static final int AUTH_CMD = 242;
    public static final int TRANSFER_CMD = 243;
    private static final int CONNECTION_ACCEPTED = 1;
    private static final int CONNECTION_DENIED = 2;
    private static final int LOGIN_FAILED = 3;
    private static final int CONNECTION_IN_USE = 4;
    private static final int CONNECTION_PERM_DENIED = 5;
    private static final int OTHER_ERROR = 6;
    private static final int MEDIA_IN_DETACH_STATE = 7;
    private static final int MAX_READ_SECTORS = 256;
    private static final int MAX_READ_SIZE = 131072;

    public FloppyRedir(boolean physicalDevice, JViewerApp app) {
        this.app = app;
        this.physicalDevice = physicalDevice;
        this.protocol = new FloppyProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(131072);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131072);
    }

    private void floppyConnect(String host, int port, boolean useSSL) throws IOException {
        this.packetMaster = new PacketMaster(host, port, false, this.protocol, useSSL);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        this.packetMaster.connect();
    }

    private void floppyDisconnect() {
        try {
            this.packetMaster.close();
        }
        catch (IOException e) {
            System.err.println(LocaleStrings.GetString("5_2_FLOPPYREDIR") + e.getMessage());
        }
    }

    public boolean startRedirection(String host, int port, boolean useSSL, String session_token, String floppyDrive) throws RedirectionException {
        block15: {
            if (this.running) {
                return true;
            }
            try {
                this.floppyConnect(host, port, useSSL);
                this.SendAuth_SessionToken(session_token);
                IUSBSCSI request = this.recvRequest();
                if (request.opcode == 241) {
                    if (request.connectionStatus != 1) {
                        this.floppyDisconnect();
                        if (request.connectionStatus == 5) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_3_FLOPPYREDIR"));
                        } else if (request.connectionStatus == 7) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_10_FLOPPYREDIR"));
                        } else if (request.connectionStatus == 3) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_11_FLOPPYREDIR"));
                        } else if (request.m_otherIP != null) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_4_FLOPPYREDIR") + request.m_otherIP);
                        } else {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_5_FLOPPYREDIR"));
                        }
                        return false;
                    }
                    break block15;
                }
                this.floppyDisconnect();
                throw new RedirectionException(LocaleStrings.GetString("5_6_FLOPPYREDIR") + request.opcode);
            }
            catch (IOException e) {
                throw new RedirectionException(e.getMessage());
            }
        }
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(this.physicalDevice);
        }
        this.sourceFloppy = floppyDrive;
        if (!this.openFloppy(floppyDrive)) {
            this.app.generalErrorMessage(LocaleStrings.GetString("5_7_FLOPPYREDIR"));
            this.deleteFloppyReader();
            this.floppyDisconnect();
            return false;
        }
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (this.running) {
            this.stopRunning = true;
            try {
                this.packetMaster.wakeup();
                this.redirThread.join();
            }
            catch (InterruptedException e) {
                System.err.println(LocaleStrings.GetString("5_8_FLOPPYREDIR"));
            }
            this.floppyDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeFloppy();
            this.deleteFloppyReader();
        }
        this.nBytesRedirected = 0;
        return true;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            this.stopRunning = true;
            this.floppyDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeFloppy();
            this.deleteFloppyReader();
            this.app.reportFloppyAbnormal();
        }
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket(true);
    }

    public boolean isRedirActive() {
        return this.running;
    }

    public void run() {
        int nTempLen = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI request = this.recvRequest();
                if (request == null) continue;
                int dataLen = this.executeFloppySCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                this.packetWriteBuffer.limit(dataLen);
                IUSBSCSI response = new IUSBSCSI(this.packetWriteBuffer, true);
                this.packetMaster.sendPacket(response);
                this.nBytesRedirected += (nTempLen += dataLen) / 1024;
                nTempLen %= 1024;
            }
            catch (IOException e) {
                if (this.stopRunning) continue;
                this.stopRedirectionAbnormal();
                this.handleError(e.getMessage());
                return;
            }
            catch (RedirectionException e) {
                if (this.stopRunning) continue;
                this.stopRedirectionAbnormal();
                this.handleError(e.getMessage());
                return;
            }
        }
    }

    public String[] getFloppyList() {
        if (!this.physicalDevice) {
            this.DisplayErrorMsg(LocaleStrings.GetString("5_9_FLOPPYREDIR"));
            return null;
        }
        String[] floppylist = null;
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(true);
            floppylist = this.listFloppyDrives();
            this.deleteFloppyReader();
        }
        return floppylist;
    }

    public String getLIBFLOPPYVersion() {
        String version;
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(false);
            version = this.getVersion();
            this.deleteFloppyReader();
        } else {
            version = this.getVersion();
        }
        return version;
    }

    public void DisplayErrorMsg(String str) {
        this.app.generalErrorMessage(str);
    }

    public void handleError(String str) {
        this.DisplayErrorMsg(str);
    }

    public boolean isPhysicalDevice() {
        return this.physicalDevice;
    }

    public String getSourceDrive() {
        return this.sourceFloppy;
    }

    public void SendAuth_SessionToken(String session_token) throws RedirectionException, IOException {
        int dataLen = 128;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(160);
        IUSBHeader AuthPktIUSBHeader = IUSBHeader.createCDROMHeader(dataLen);
        AuthPktIUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(session_token.getBytes());
        this.packetWriteBuffer.position(0);
        IUSBSCSI pkt = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(pkt);
    }

    public void sendTransferCmd() throws RedirectionException, IOException {
        int dataLen = 30;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(62);
        IUSBHeader transferCmdIUSBHeader = IUSBHeader.createCDROMHeader(dataLen);
        transferCmdIUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-13);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.position(0);
        IUSBSCSI pkt = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(pkt);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    public byte ReadKeybdLEDStatus() {
        return this.GetLEDStatus();
    }

    private native String[] listFloppyDrives();

    private native void newFloppyReader(boolean var1);

    private native void deleteFloppyReader();

    private native boolean openFloppy(String var1);

    private native void closeFloppy();

    private native int executeFloppySCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String getVersion();

    private native byte GetLEDStatus();

    static {
        try {
            System.loadLibrary("javafloppywrapper");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(LocaleStrings.GetString("5_1_FLOPPYREDIR"));
        }
    }
}

