/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import IPMIView20.blade.SummaryAbstractPanel;
import IPMIView20.blade.SummaryFailurePanel_jClearButton_actionAdapter;
import IPMIView20.blade.SummaryFailurePanel_jEmailButton_actionAdapter;
import IPMIView20.blade.SummaryFailurePanel_jGoButton_actionAdapter;
import IPMIView20.blade.SummaryFailurePanel_jRefreshButton_actionAdapter;
import IPMIView20.blade.SummaryFailurePanel_jSaveButton_actionAdapter;
import IPMIView20.blade.SummaryFailureSelectionListener;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import com.supermicro.ipmi.blade.TenGPassThruEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class SummaryFailurePanel
extends SummaryAbstractPanel {
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon deleteIcon = new ImageIcon(this.getClass().getResource("/images/delete.gif"));
    Icon refreshIcon = new ImageIcon(this.getClass().getResource("/images/Refresh24.gif"));
    Icon emailIcon = new ImageIcon(this.getClass().getResource("/images/SendMail24.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    Icon warningYellowIcon = new ImageIcon(this.getClass().getResource("/images/warning_yellow.gif"));
    Icon frontIcon = new ImageIcon(this.getClass().getResource("/images/front.gif"));
    Icon front14bIcon = new ImageIcon(this.getClass().getResource("/images/front14b.gif"));
    Icon rearIcon = new ImageIcon(this.getClass().getResource("/images/rear.gif"));
    Icon[] frontBladeIcon = new Icon[10];
    Icon[] frontBlade14Icon = new Icon[14];
    Icon[] rearPowerSupplyIcon = new Icon[4];
    Icon[] rearCMM = new Icon[2];
    Icon[] rearIB = new Icon[2];
    Icon[] rearGBSwtich = new Icon[2];
    Icon[] rear10PassThru = new Icon[2];
    TableSorter ts;
    DefaultTableModel dtm;
    ArrayList failures;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jCenterPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable = null;
    JPanel jNorthPanel = new JPanel();
    JToolBar jToolBar = new JToolBar();
    JButton jRefreshButton = new JButton();
    JButton jSaveButton = new JButton();
    JButton jEmailButton = new JButton();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jSouthPanel = new JPanel();
    JLabel jTimeLabel = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();
    JButton jClearButton = new JButton();
    boolean firstLoad = false;
    BladeSystemEntity bladeSystemEntity = null;
    String pathName;
    JPanel jFailureDetailAndIconPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    JLabel jRearLabel = new JLabel();
    JLabel jFrontLabel = new JLabel();
    JButton jGoButton = new JButton();
    JLabel jRearStringLabel = new JLabel();
    JLabel jFrontStringLabel = new JLabel();
    JPanel jFrontPanel = new JPanel();
    JPanel jRearPanel = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel3 = new JPanel();
    TitledBorder titledBorder2 = new TitledBorder("");
    JPanel jPanel4 = new JPanel();
    JLabel jFailureItemLabel = new JLabel();
    JPanel jFailureTablePanel = new JPanel();
    BorderLayout borderLayout8 = new BorderLayout();
    JPanel jPanel6 = new JPanel();
    BorderLayout borderLayout9 = new BorderLayout();
    JLabel jFailureDetailLabel = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    static JFileChooser fileChooser;

    public SummaryFailurePanel() {
        try {
            this.myInit();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        ArrayList headerList = this.getHeader();
        this.dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(this.dtm);
        this.jTable = new JTable(){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
        this.jTable.setModel(this.ts);
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.jTable.getColumnModel().getColumn(2).setPreferredWidth(190);
        this.jTable.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.jTable.getColumnModel().getColumn(4).setPreferredWidth(550);
        this.jTable.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.jTable.setSelectionMode(0);
        this.jTable.getSelectionModel().addListSelectionListener(new SummaryFailureSelectionListener(this));
        this.initializeIcons();
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jEmailButton.setVisible(false);
    }

    private void initializeIcons() {
        int i;
        for (i = 0; i < this.frontBladeIcon.length; ++i) {
            this.frontBladeIcon[i] = new ImageIcon(this.getClass().getResource("/images/front_b" + (i + 1) + ".gif"));
        }
        for (i = 0; i < this.frontBlade14Icon.length; ++i) {
            this.frontBlade14Icon[i] = new ImageIcon(this.getClass().getResource("/images/front14b_b" + (i + 1) + ".gif"));
        }
        for (i = 0; i < this.rearPowerSupplyIcon.length; ++i) {
            this.rearPowerSupplyIcon[i] = new ImageIcon(this.getClass().getResource("/images/rear_p" + (i + 1) + ".gif"));
        }
        for (i = 0; i < this.rearCMM.length; ++i) {
            this.rearCMM[i] = new ImageIcon(this.getClass().getResource("/images/rear_cmm" + (i + 1) + ".gif"));
        }
        for (i = 0; i < this.rearIB.length; ++i) {
            this.rearIB[i] = new ImageIcon(this.getClass().getResource("/images/rear_ib" + (i + 1) + ".gif"));
        }
        for (i = 0; i < this.rearGBSwtich.length; ++i) {
            this.rearGBSwtich[i] = new ImageIcon(this.getClass().getResource("/images/rear_gb" + (i + 1) + ".gif"));
        }
        for (i = 0; i < this.rear10PassThru.length; ++i) {
            this.rear10PassThru[i] = new ImageIcon(this.getClass().getResource("/images/rear_ib" + (i + 1) + ".gif"));
        }
    }

    private ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(L.t("cmm.summary.failure.No"));
        headerList.add(L.t("cmm.summary.failure.Level"));
        headerList.add(L.t("cmm.summary.failure.Source"));
        headerList.add(L.t("cmm.summary.failure.Item"));
        headerList.add(L.t("cmm.summary.failure.Detail"));
        headerList.add(L.t("cmm.summary.failure.Side"));
        return headerList;
    }

    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SummaryFailurePanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SummaryFailurePanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        int i;
        int rowSelectIndex = this.jTable.getSelectedRow();
        int rowCount = this.dtm.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            this.dtm.removeRow(0);
        }
        this.failures = this.bladeSystemEntity.getFailures();
        for (i = 0; i < this.bladeSystemEntity.getFailures().size(); ++i) {
            FailureEntity failureEntity = (FailureEntity)this.bladeSystemEntity.getFailures().get(i);
            ArrayList<Object> raw = new ArrayList<Object>();
            raw.add("" + (i + 1));
            if (failureEntity.getLevel() == 2) {
                raw.add(this.xRedIcon);
            } else {
                raw.add(this.warningYellowIcon);
            }
            raw.add(failureEntity.getSource());
            raw.add(failureEntity.getFailureItem());
            raw.add(failureEntity.getFailureDetail());
            if (failureEntity.getSourceObject() instanceof BladeEntity) {
                raw.add(L.t("cmm.summary.failure.Front"));
            } else {
                raw.add(L.t("cmm.summary.failure.Rear"));
            }
            if (i == 0) {
                this.jTimeLabel.setText(L.t("cmm.summary.failure.update") + " " + failureEntity.getDateTime());
            }
            ((DefaultTableModel)this.ts.getTableModel()).addRow(raw.toArray());
        }
        this.jTable.setModel(this.ts);
        if (rowSelectIndex >= 0 && this.jTable.getRowCount() > 0) {
            this.jTable.setRowSelectionInterval(rowSelectIndex, rowSelectIndex);
        }
        if (!this.firstLoad && this.jTable.getRowCount() != 0) {
            this.jTable.setRowSelectionInterval(0, 0);
            this.firstLoad = true;
        }
        if (rowSelectIndex < 0 && this.jTable.getRowCount() > 0) {
            this.jTable.setRowSelectionInterval(0, 0);
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder2 = new TitledBorder(L.t("cmm.summary.failure.Failure_Table"));
        this.titledBorder1 = new TitledBorder(L.t("cmm.summary.failure.Failure_Location"));
        this.setLayout(this.borderLayout1);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.jSaveButton.setToolTipText(L.t("cmm.summary.failure.Save_to_file"));
        this.jSaveButton.setIcon(this.saveIcon);
        this.jSaveButton.addActionListener(new SummaryFailurePanel_jSaveButton_actionAdapter(this));
        this.jEmailButton.setEnabled(false);
        this.jEmailButton.setToolTipText("Email Setting");
        this.jEmailButton.setIcon(this.emailIcon);
        this.jEmailButton.setText("Email");
        this.jEmailButton.addActionListener(new SummaryFailurePanel_jEmailButton_actionAdapter(this));
        this.jNorthPanel.setLayout(this.borderLayout3);
        this.jToolBar.setFloatable(false);
        this.jSouthPanel.setLayout(this.borderLayout4);
        this.jClearButton.setToolTipText(L.t("cmm.summary.failure.Clear"));
        this.jClearButton.setIcon(this.deleteIcon);
        this.jClearButton.setMnemonic('0');
        this.jClearButton.addActionListener(new SummaryFailurePanel_jClearButton_actionAdapter(this));
        this.jTimeLabel.setToolTipText("");
        this.jTimeLabel.setIcon(null);
        this.jRefreshButton.setToolTipText(L.t("cmm.summary.failure.Refresh"));
        this.jRefreshButton.setIcon(this.refreshIcon);
        this.jRefreshButton.addActionListener(new SummaryFailurePanel_jRefreshButton_actionAdapter(this));
        this.jFailureDetailAndIconPanel.setLayout(this.borderLayout7);
        this.jRearLabel.setEnabled(false);
        this.jRearLabel.setIcon(this.rearIcon);
        this.jFrontLabel.setEnabled(false);
        this.jFrontLabel.setHorizontalTextPosition(10);
        this.jFrontLabel.setIcon(this.frontIcon);
        this.jGoButton.setEnabled(false);
        this.jGoButton.setText(L.t("cmm.summary.failure.Go"));
        this.jGoButton.addActionListener(new SummaryFailurePanel_jGoButton_actionAdapter(this));
        this.jRearStringLabel.setHorizontalAlignment(0);
        this.jRearStringLabel.setText(L.t("cmm.summary.failure.Rear"));
        this.jFrontStringLabel.setHorizontalAlignment(0);
        this.jFrontStringLabel.setHorizontalTextPosition(0);
        this.jFrontStringLabel.setText(L.t("cmm.summary.failure.Front"));
        this.jFrontPanel.setLayout(this.borderLayout5);
        this.jRearPanel.setLayout(this.borderLayout6);
        this.jFailureDetailAndIconPanel.setBorder(this.titledBorder1);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jScrollPane1.setPreferredSize(new Dimension(452, 200));
        this.jFailureItemLabel.setForeground(Color.red);
        this.jFailureItemLabel.setText(" ");
        this.jFailureTablePanel.setLayout(this.borderLayout8);
        this.jFailureTablePanel.setBorder(this.titledBorder2);
        this.jPanel6.setLayout(this.borderLayout9);
        this.jFailureDetailLabel.setForeground(Color.red);
        this.jFailureDetailLabel.setText(" ");
        this.jPanel4.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setHgap(5);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setVgap(5);
        this.jToolBar.add(this.jRefreshButton);
        this.jToolBar.add(this.jSaveButton);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.jClearButton);
        this.jToolBar.addSeparator();
        this.jToolBar.add(this.jEmailButton);
        this.jNorthPanel.add((Component)this.jToolBar, "North");
        this.jSouthPanel.add((Component)this.jTimeLabel, "Center");
        this.add((Component)this.jNorthPanel, "North");
        this.add((Component)this.jCenterPanel, "Center");
        this.add((Component)this.jSouthPanel, "South");
        this.jFrontPanel.add((Component)this.jFrontLabel, "Center");
        this.jFrontPanel.add((Component)this.jFrontStringLabel, "South");
        this.jPanel1.add(this.jFrontPanel);
        this.jPanel1.add(this.jRearPanel);
        this.jRearPanel.add((Component)this.jRearStringLabel, "South");
        this.jRearPanel.add((Component)this.jRearLabel, "Center");
        this.jPanel4.add(this.jFailureItemLabel);
        this.jPanel4.add(this.jFailureDetailLabel);
        this.jPanel3.add(this.jGoButton);
        this.jCenterPanel.add((Component)this.jFailureTablePanel, "Center");
        this.jFailureTablePanel.add((Component)this.jScrollPane1, "Center");
        this.jCenterPanel.add((Component)this.jFailureDetailAndIconPanel, "South");
        this.jPanel6.add((Component)this.jPanel1, "Center");
        this.jFailureDetailAndIconPanel.add((Component)this.jPanel4, "Center");
        this.jFailureDetailAndIconPanel.add((Component)this.jPanel6, "West");
        this.jFailureDetailAndIconPanel.add((Component)this.jPanel3, "East");
    }

    public void jRefreshButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SummaryFailurePanel.this.cmmSessionPanel.bladeSystemEntity.getData();
            }
        };
        thread.start();
    }

    public void jSaveButton_actionPerformed(ActionEvent e) {
        int rowCount;
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        if ((rowCount = this.jTable.getModel().getRowCount()) == 0) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("cmm.summary.failure.No_data"));
            return;
        }
        boolean save = false;
        if (fileChooser.showSaveDialog(null) == 0) {
            this.pathName = fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(this.pathName);
            if (xfi.exists()) {
                int ret = JOptionPane.showConfirmDialog(this.findParentFrame(), L.t("cmm.summary.failure.Do_you_write"), L.t("cmm.summary.failure.Request_Confirmation"), 0);
                if (ret == 0) {
                    save = true;
                }
            } else {
                save = true;
            }
        }
        if (!save) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int i;
                StringBuffer sb = new StringBuffer();
                ArrayList list = SummaryFailurePanel.this.getHeader();
                for (i = 0; i < list.size(); ++i) {
                    if (i == 1) continue;
                    sb.append(list.get(i));
                    if (i == list.size() - 1) continue;
                    sb.append(",");
                }
                sb.append("\n");
                for (i = 0; i < SummaryFailurePanel.this.jTable.getRowCount(); ++i) {
                    for (int j = 0; j < SummaryFailurePanel.this.jTable.getColumnCount(); ++j) {
                        if (j == 1) continue;
                        sb.append(((TableSorter)SummaryFailurePanel.this.jTable.getModel()).getValueAt(i, j).toString());
                        if (j == SummaryFailurePanel.this.jTable.getColumnCount() - 1) continue;
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                try {
                    FileWriter fout = new FileWriter(SummaryFailurePanel.this.pathName);
                    PrintWriter pw = new PrintWriter(fout);
                    pw.println(sb.toString());
                    fout.close();
                    JOptionPane.showMessageDialog(SummaryFailurePanel.this.findParentFrame(), L.t("cmm.summary.failure.save_to") + " " + SummaryFailurePanel.this.pathName + " " + L.t("cmm.summary.failure.completed"));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(SummaryFailurePanel.this.findParentFrame(), L.t("cmm.summary.failure.Cannot_save"), L.t("cmm.summary.failure.Warning"), 0);
                }
            }
        };
        thread.start();
    }

    public void jClearButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int rowCount = SummaryFailurePanel.this.dtm.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    SummaryFailurePanel.this.dtm.removeRow(0);
                }
                SummaryFailurePanel.this.jTable.invalidate();
            }
        };
        thread.start();
    }

    public void jEmailButton_actionPerformed(ActionEvent e) {
    }

    public void jtableValueChanged() {
        int selectedRow = this.jTable.getSelectedRow();
        if (selectedRow < 0) {
            this.jFrontLabel.setIcon(this.frontIcon);
            this.jRearLabel.setIcon(this.rearIcon);
            this.jFrontLabel.setEnabled(false);
            this.jRearLabel.setEnabled(false);
            this.jGoButton.setEnabled(false);
            this.jFailureItemLabel.setText(" ");
            this.jFailureDetailLabel.setText(" ");
            return;
        }
        if (selectedRow >= this.failures.size()) {
            return;
        }
        FailureEntity failureEntity = (FailureEntity)this.failures.get(selectedRow);
        if (failureEntity.getSourceObject() instanceof BladeEntity) {
            BladeEntity bladeEntity = (BladeEntity)failureEntity.getSourceObject();
            if (this.bladeSystemEntity.getBlades().length == 14) {
                this.jFrontLabel.setIcon(this.frontBlade14Icon[bladeEntity.getModuleIndex() - 1]);
            } else {
                this.jFrontLabel.setIcon(this.frontBladeIcon[bladeEntity.getModuleIndex() - 1]);
            }
            this.jRearLabel.setIcon(this.rearIcon);
            this.jFailureItemLabel.setText(L.t("cmm.summary.failure.Blade") + " " + bladeEntity.getModuleIndex() + ":" + failureEntity.getFailureItem());
        } else if (failureEntity.getSourceObject() instanceof CMMModuleEntity) {
            CMMModuleEntity cmmModuleEntity = (CMMModuleEntity)failureEntity.getSourceObject();
            this.setBladeIcon();
            this.jRearLabel.setIcon(this.rearCMM[cmmModuleEntity.getModuleIndex() - 1]);
            this.jFailureItemLabel.setText(L.t("cmm.summary.failure.CMM") + " " + cmmModuleEntity.getModuleIndex() + ":" + failureEntity.getFailureItem());
        } else if (failureEntity.getSourceObject() instanceof PowerSupplyEntity) {
            PowerSupplyEntity powerSupplyEntity = (PowerSupplyEntity)failureEntity.getSourceObject();
            this.setBladeIcon();
            this.jRearLabel.setIcon(this.rearPowerSupplyIcon[powerSupplyEntity.getModuleIndex() - 1]);
            this.jFailureItemLabel.setText(L.t("cmm.summary.failure.Power_Supply") + " " + powerSupplyEntity.getModuleIndex() + ":" + failureEntity.getFailureItem());
        } else if (failureEntity.getSourceObject() instanceof InfiniBandEntity) {
            InfiniBandEntity infiniBandEntity = (InfiniBandEntity)failureEntity.getSourceObject();
            this.setBladeIcon();
            this.jRearLabel.setIcon(this.rearIB[infiniBandEntity.getModuleIndex() - 1]);
            this.jFailureItemLabel.setText(L.t("cmm.summary.failure.InfiniBand") + " " + infiniBandEntity.getModuleIndex() + ":" + failureEntity.getFailureItem());
        } else if (failureEntity.getSourceObject() instanceof GigabitSwitchEntity) {
            GigabitSwitchEntity gigabitSwitchEntity = (GigabitSwitchEntity)failureEntity.getSourceObject();
            this.setBladeIcon();
            this.jRearLabel.setIcon(this.rearGBSwtich[gigabitSwitchEntity.getModuleIndex() - 1]);
            this.jFailureItemLabel.setText(L.t("cmm.summary.failure.Gigabit_Switch") + " " + gigabitSwitchEntity.getModuleIndex() + ":" + failureEntity.getFailureItem());
        } else if (failureEntity.getSourceObject() instanceof TenGPassThruEntity) {
            TenGPassThruEntity tenGPassThruEntity = (TenGPassThruEntity)failureEntity.getSourceObject();
            this.setBladeIcon();
            this.jRearLabel.setIcon(this.rear10PassThru[tenGPassThruEntity.getModuleIndex() - 1]);
            this.jFailureItemLabel.setText(L.t("cmm.summary.failure.10G_Pass_Thru") + " " + tenGPassThruEntity.getModuleIndex() + ":" + failureEntity.getFailureItem());
        }
        this.jFailureDetailLabel.setText(failureEntity.getFailureDetail());
        this.jFrontLabel.setEnabled(true);
        this.jRearLabel.setEnabled(true);
        this.jGoButton.setEnabled(true);
        this.jFailureItemLabel.setVisible(true);
    }

    private void setBladeIcon() {
        if (this.bladeSystemEntity.getBlades().length == 14) {
            this.jFrontLabel.setIcon(this.front14bIcon);
        } else {
            this.jFrontLabel.setIcon(this.frontIcon);
        }
    }

    public void jGoButton_actionPerformed(ActionEvent e) {
        int selectedRow = this.jTable.getSelectedRow();
        if (selectedRow >= this.failures.size()) {
            return;
        }
        FailureEntity failureEntity = (FailureEntity)this.failures.get(selectedRow);
        LabelBladeComponent c = null;
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.labelBladeGroup.setIndicatorUnique(true);
        if (failureEntity.getSourceObject() instanceof BladeEntity) {
            BladeEntity bladeEntity = (BladeEntity)failureEntity.getSourceObject();
            int moduleIndex = bladeEntity.getModuleIndex();
            c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemFront.labelBlades[moduleIndex - 1];
            c.setIndicatorVisible(true);
        } else if (failureEntity.getSourceObject() instanceof CMMModuleEntity) {
            CMMModuleEntity cmmModuleEntity = (CMMModuleEntity)failureEntity.getSourceObject();
            int moduleIndex = cmmModuleEntity.getModuleIndex();
            c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelCMM[moduleIndex - 1];
            c.setIndicatorVisible(true);
        } else if (failureEntity.getSourceObject() instanceof PowerSupplyEntity) {
            PowerSupplyEntity powerSupplyEntity = (PowerSupplyEntity)failureEntity.getSourceObject();
            int moduleIndex = powerSupplyEntity.getModuleIndex();
            c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelPowerSupply[moduleIndex - 1];
            c.setIndicatorVisible(true);
        } else if (failureEntity.getSourceObject() instanceof InfiniBandEntity) {
            InfiniBandEntity infiniBandEntity = (InfiniBandEntity)failureEntity.getSourceObject();
            int moduleIndex = infiniBandEntity.getModuleIndex();
            c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelInfiniBand[moduleIndex - 1];
            c.setIndicatorVisible(true);
        } else if (failureEntity.getSourceObject() instanceof GigabitSwitchEntity) {
            GigabitSwitchEntity gigabitSwitchEntity = (GigabitSwitchEntity)failureEntity.getSourceObject();
            int moduleIndex = gigabitSwitchEntity.getModuleIndex();
            c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelGigibitSwitch[moduleIndex - 1];
            c.setIndicatorVisible(true);
        }
        String label = c.getModuleName() + " " + c.getNumber();
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setIcon(this.cmmSessionPanel.cmmBladeSystemPanel.bookmarkIcon);
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setText("[ " + label + " ]");
        this.cmmSessionPanel.cmmBladeSystemPanel.cardLayout.show(this.cmmSessionPanel.cmmBladeSystemPanel.jSinglePanel, c.getModuleName() + c.getNumber());
    }
}

