/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

class SWindow
extends Window {
    ImageIcon splashIm = new ImageIcon(this.getClass().getResource("/images/Import24.gif"));
    String msg1;
    String msg2;
    String msg3;
    int width = 350;
    int height = 50;
    WatchDog watchDog;
    private BufferedImage bimg;

    public SWindow(Frame parent, String msg1, String msg2, String msg3) {
        super(parent);
        this.setSize(this.width, this.height);
        this.msg1 = msg1;
        this.msg2 = msg2;
        this.msg3 = msg3;
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle winDim = this.getBounds();
        this.setLocation((screenDim.width - winDim.width) / 2, (screenDim.height - winDim.height) / 2);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SWindow.this.hide();
            }
        });
    }

    public void setImage(ImageIcon image) {
        this.splashIm = image;
    }

    public void setMessage(String msg1, String msg2, String msg3) {
        this.msg1 = msg1;
        this.msg2 = msg2;
        this.msg3 = msg3;
        this.repaint();
    }

    public void setWatchDogTime(int time) {
        this.watchDog.reset();
        this.watchDog.setcountLimit(time);
    }

    public void paintBufferImage() {
        if (this.bimg == null) {
            this.bimg = (BufferedImage)this.createImage(this.width, this.height);
        }
        if (this.splashIm != null) {
            Graphics2D g = this.bimg.createGraphics();
            g.setColor(new Color(204, 204, 255));
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(Color.lightGray);
            g.drawLine(0, 0, this.width - 1, 0);
            g.drawLine(0, 0, 0, this.height - 1);
            g.setColor(Color.GRAY);
            g.drawLine(this.width - 1, this.height - 1, this.width - 1, 0);
            g.drawLine(this.width - 1, this.height - 1, 0, this.height - 1);
            g.drawImage(this.splashIm.getImage(), 10, 15, this);
            g.setFont(Font.getFont("Arrial"));
            g.setColor(Color.black);
            ((Graphics)g).drawString(this.msg1, 50, 30);
            ((Graphics)g).drawString(this.msg2, 20, 40);
            ((Graphics)g).drawString(this.msg3, 20, 60);
        }
    }

    public void paint(Graphics g) {
        if (this.splashIm != null) {
            g.setColor(new Color(204, 204, 255));
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(Color.lightGray);
            g.drawLine(0, 0, this.width - 1, 0);
            g.drawLine(0, 0, 0, this.height - 1);
            g.setColor(Color.GRAY);
            g.drawLine(this.width - 1, this.height - 1, this.width - 1, 0);
            g.drawLine(this.width - 1, this.height - 1, 0, this.height - 1);
            g.drawImage(this.splashIm.getImage(), 10, 15, this);
            g.setFont(Font.getFont("Arrial"));
            g.setColor(Color.black);
            g.drawString(this.msg1, 50, 30);
            g.drawString(this.msg2, 20, 40);
            g.drawString(this.msg3, 20, 60);
        }
    }

    class WatchDog
    extends Thread {
        SWindow w;
        int count = 0;
        int countLimit = 0;

        public WatchDog(SWindow w, int countLimit) {
            this.w = w;
            this.countLimit = countLimit;
        }

        public void setcountLimit(int countLimit) {
            this.countLimit = countLimit;
        }

        public void reset() {
            this.count = 0;
        }

        public void timeUp() {
            this.w.hide();
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.count;
                if (this.count != this.countLimit) continue;
                this.timeUp();
            }
        }
    }
}

