/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JVolPanel
extends JPanel {
    public JVolMeter volMeter = new JVolMeter();
    JLabel NameLabel = new JLabel();
    int SensorNumber;
    int M;
    int B;
    int RExp;
    int BExp;
    boolean isNA = false;
    float offset = 0.0f;

    public JVolPanel() {
        this.initComponents();
    }

    public void updateValue(byte value, String valueString) {
        this.volMeter.m_VoltReading = value;
        this.volMeter.m_ShowString = valueString;
        double high = Double.parseDouble(this.volMeter.m_HighString);
        double low = Double.parseDouble(this.volMeter.m_LowString);
        double temp = Double.parseDouble(this.volMeter.m_ShowString);
        if (temp <= low || temp >= high) {
            this.NameLabel.setForeground(Color.RED);
        } else {
            this.NameLabel.setForeground(Color.BLUE);
        }
        this.isNA = false;
        this.volMeter.paintBufferImage();
        this.volMeter.repaint();
    }

    public void setNA() {
        this.isNA = true;
        this.volMeter.paintBufferImage();
        this.volMeter.repaint();
        this.NameLabel.setForeground(Color.BLUE);
    }

    public void init(String labelName, byte value, byte high, byte low, String valueString, String highString, String lowString) {
        this.volMeter.setValue(value, high, low);
        this.volMeter.setString(valueString, highString, lowString);
        this.volMeter.setBorder(new EtchedBorder());
        this.add((Component)this.volMeter, "Center");
        this.NameLabel.setText(labelName);
        this.NameLabel.setBorder(new EtchedBorder());
        this.NameLabel.setForeground(Color.blue);
        this.NameLabel.setHorizontalAlignment(0);
        this.add((Component)this.NameLabel, "South");
        this.add((Component)this.volMeter, "Center");
    }

    public void showVol() {
        this.add((Component)this.volMeter, "Center");
    }

    public void showHisotry() {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public float maxValue() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.volMeter.m_HighString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value >= 0.0f) {
            this.offset = 0.0f;
            return 15.0f;
        }
        this.offset = 15.0f;
        return 15.0f;
    }

    public float getValue() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.volMeter.m_ShowString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public float getOffset() {
        return this.offset;
    }

    public String getTitle() {
        return this.NameLabel.getText();
    }

    public float highLimit() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.volMeter.m_HighString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public float lowLimit() {
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.volMeter.m_LowString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    class JVolMeter
    extends JPanel {
        int value;
        Color colorvalue;
        byte m_HighLimit = (byte)-64;
        byte m_LowLimit = (byte)-128;
        byte m_VoltReading = (byte)-48;
        String m_ShowString = "12.34V";
        String m_HighString = "15.00V";
        String m_LowString = "0.0V";
        private BufferedImage bimg;

        public JVolMeter() {
            super.setPreferredSize(new Dimension(98, 58));
        }

        public void setValue(byte value, byte hight, byte low) {
            this.m_VoltReading = value;
            this.m_HighLimit = hight;
            this.m_LowLimit = low;
        }

        public void setString(String valueString, String HeightString, String LowString) {
            this.m_ShowString = valueString;
            this.m_HighString = HeightString;
            this.m_LowString = LowString;
        }

        public void paintComponent(Graphics g1) {
            if (this.bimg != null) {
                g1.drawImage(this.bimg, 0, 0, this);
            }
        }

        public void paintBufferImage() {
            Dimension d = this.getPreferredSize();
            if (this.bimg == null) {
                this.bimg = (BufferedImage)this.createImage(d.width, d.height);
            }
            if (this.bimg == null) {
                return;
            }
            if (JVolPanel.this.isNA) {
                this.paintNA();
            } else {
                this.paintContent();
            }
        }

        private void paintNA() {
            Graphics2D g1;
            Graphics2D g = g1 = this.bimg.createGraphics();
            Dimension rcBounds = this.getPreferredSize();
            int m_Radius = (rcBounds.height > rcBounds.width ? rcBounds.width : rcBounds.height) / 2;
            int centerx = (int)((double)rcBounds.width / 2.0);
            int centery = (int)((double)rcBounds.height / 2.0);
            g.setColor(Color.lightGray);
            boolean xleft = false;
            boolean xtop = false;
            int xright = rcBounds.width - 1;
            int xbottom = rcBounds.height - 2;
            GradientPaint comet = new GradientPaint((float)xleft, (float)xtop, Color.gray, 0.0f, xbottom, Color.gray);
            g.setPaint(comet);
            g.fillRect(0, 0, xright, xbottom);
            g.setColor(Color.white);
            Font mFont = new Font("New Times Roman", 1, 11);
            FontMetrics fm = g.getFontMetrics(mFont);
            int fwidth = fm.stringWidth("RPM");
            g.setColor(Color.black);
            g.drawString("N/A", centerx - (int)((double)fwidth / 2.0) + 2 + 1, centery - (int)((double)m_Radius * 0.8 / 2.0) + 6 + 1);
            g.setColor(Color.white);
            g.drawString("N/A", centerx - (int)((double)fwidth / 2.0) + 2, centery - (int)((double)m_Radius * 0.8 / 2.0) + 6);
        }

        private void paintContent() {
            int angle;
            Graphics2D g1 = this.bimg.createGraphics();
            super.paintComponent(g1);
            Graphics2D g = g1;
            RenderingHints hints = new RenderingHints(null);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.addRenderingHints(hints);
            int[] cPointx = new int[180];
            int[] cPointy = new int[180];
            Dimension rcBounds = this.getPreferredSize();
            int m_Radius = (int)((double)rcBounds.height > (double)rcBounds.width / 2.0 / Math.cos(0.5235986666666667) ? (double)rcBounds.width / 2.0 / Math.cos(0.5235986666666667) : (double)rcBounds.height);
            int centerx = (int)((double)rcBounds.width / 2.0);
            int centery = m_Radius;
            g.setColor(Color.lightGray);
            int xleft = centerx - (int)((double)m_Radius * Math.cos(0.5235986666666667));
            int xtop = 0;
            int xright = centerx + (int)((double)m_Radius * Math.cos(0.5235986666666667));
            int xbottom = centery;
            GradientPaint comet = new GradientPaint(xleft, xtop, Color.gray, xleft, xbottom - xtop, Color.gray);
            g.setPaint(comet);
            g.fillRect(xleft, xtop, xright - xleft, xbottom - xtop);
            g.setColor(Color.white);
            g.drawLine(centerx + (int)((double)m_Radius * Math.cos(0.5235986666666667)), 0, centerx + (int)((double)m_Radius * Math.cos(0.5235986666666667)), centery);
            g.drawLine(centerx + (int)((double)m_Radius * Math.cos(0.5235986666666667)), centery, 0, centery);
            g.setColor(Color.red);
            int ix2 = centerx + (int)((double)m_Radius * 0.7 * Math.cos(0.5235993333333333));
            int iy2 = centery - (int)((double)m_Radius * 0.7 * Math.sin(0.5235993333333333));
            cPointx[0] = ix2;
            cPointy[0] = iy2;
            int i = 1;
            for (angle = 30; angle < 30 + (int)((double)(256 - (this.m_HighLimit & 0xFF)) * 120.0 / 256.0); angle += 10) {
                cPointx[i] = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i] = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i;
            }
            int ix1 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((30.0 + (double)(256 - (this.m_HighLimit & 0xFF)) * 120.0 / 256.0) / 180.0 * 3.141596));
            int iy1 = centery - (int)((double)m_Radius * 0.9 * Math.sin((30.0 + (double)(256 - (this.m_HighLimit & 0xFF)) * 120.0 / 256.0) / 180.0 * 3.141596));
            cPointx[i] = ix1;
            cPointy[i] = iy1;
            ++i;
            for (angle = 30 + (int)((double)(256 - (this.m_HighLimit & 0xFF)) * 120.0 / 256.0); angle >= 30; angle -= 10) {
                cPointx[i] = centerx + (int)((double)m_Radius * 0.7 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i] = centery - (int)((double)m_Radius * 0.7 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i;
            }
            g.fillPolygon(cPointx, cPointy, i);
            ix2 = centerx + (int)((double)m_Radius * 0.7 * Math.cos(2.6179966666666665));
            iy2 = centery - (int)((double)m_Radius * 0.7 * Math.sin(2.6179966666666665));
            cPointx[0] = ix2;
            cPointy[0] = iy2;
            i = 1;
            for (angle = 150; angle >= 30 + (int)((double)(256 - (this.m_LowLimit & 0xFF)) * 120.0 / 256.0); angle -= 10) {
                cPointx[i] = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i] = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i;
            }
            ix1 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((30.0 + (double)(256 - (this.m_LowLimit & 0xFF)) * 120.0 / 256.0) / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.9 * Math.sin((30.0 + (double)(256 - (this.m_LowLimit & 0xFF)) * 120.0 / 256.0) / 180.0 * 3.141596));
            cPointx[i] = ix1;
            cPointy[i] = iy1;
            ++i;
            for (angle = 30 + (int)((double)(256 - (this.m_LowLimit & 0xFF)) * 120.0 / 256.0); angle <= 150; angle += 10) {
                cPointx[i] = centerx + (int)((double)m_Radius * 0.7 * Math.cos((double)angle / 180.0 * 3.141596));
                cPointy[i] = centery - (int)((double)m_Radius * 0.7 * Math.sin((double)angle / 180.0 * 3.141596));
                ++i;
            }
            g.fillPolygon(cPointx, cPointy, i);
            g.setColor(Color.black);
            angle = 30;
            ix1 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
            angle = 30;
            ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
            iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
            g.drawLine(ix1, iy1, ix2, iy2);
            ix1 = ix2;
            iy1 = iy2;
            for (angle = 40; angle < 151; angle += 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                g.drawLine(ix1, iy1, ix2, iy2);
                ix1 = ix2;
                iy1 = iy2;
            }
            angle = 150;
            ix2 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
            iy2 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
            g.drawLine(ix1, iy1, ix2, iy2);
            ix1 = ix2;
            iy1 = iy2;
            for (angle = 150; angle > 29; angle -= 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
                g.drawLine(ix1, iy1, ix2, iy2);
                ix1 = ix2;
                iy1 = iy2;
            }
            g.setColor(Color.white);
            angle = 30;
            ix1 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
            angle = 30;
            ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
            iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
            g.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
            ix1 = ix2;
            iy1 = iy2;
            for (angle = 40; angle < 151; angle += 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                g.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
                ix1 = ix2;
                iy1 = iy2;
            }
            angle = 150;
            ix2 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
            iy2 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
            g.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
            ix1 = ix2;
            iy1 = iy2;
            for (angle = 150; angle > 29; angle -= 10) {
                ix2 = centerx + (int)((double)m_Radius * 0.4 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.4 * Math.sin((double)angle / 180.0 * 3.141596));
                g.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
                ix1 = ix2;
                iy1 = iy2;
            }
            g.setColor(Color.black);
            for (angle = 30; angle < 151; angle += 10) {
                ix1 = centerx + (int)((double)m_Radius * 0.85 * Math.cos((double)angle / 180.0 * 3.141596));
                iy1 = centery - (int)((double)m_Radius * 0.85 * Math.sin((double)angle / 180.0 * 3.141596));
                ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                g.drawLine(ix1, iy1, ix2, iy2);
            }
            g.setColor(Color.white);
            for (angle = 30; angle < 151; angle += 10) {
                ix1 = centerx + (int)((double)m_Radius * 0.85 * Math.cos((double)angle / 180.0 * 3.141596));
                iy1 = centery - (int)((double)m_Radius * 0.85 * Math.sin((double)angle / 180.0 * 3.141596));
                ix2 = centerx + (int)((double)m_Radius * 0.9 * Math.cos((double)angle / 180.0 * 3.141596));
                iy2 = centery - (int)((double)m_Radius * 0.9 * Math.sin((double)angle / 180.0 * 3.141596));
                g.drawLine(ix1 - 1, iy1 - 1, ix2 - 1, iy2 - 1);
            }
            g.setColor(Color.WHITE);
            Font mFont = new Font("New Times Roman", 1, 12);
            FontMetrics fm = g.getFontMetrics(mFont);
            int fwidth = fm.stringWidth("V");
            g.drawString("V", centerx - (int)((double)fwidth / 2.0) + 2, (int)((double)rcBounds.height / 2.0) + 3);
            g.setColor(Color.black);
            angle = (int)(30.0 + (double)(256 - (this.m_VoltReading & 0xFF)) / 256.0 * 120.0);
            cPointx[0] = centerx + (int)((double)m_Radius * 0.97 * Math.cos((double)angle / 180.0 * 3.141596));
            cPointy[0] = centery - (int)((double)m_Radius * 0.97 * Math.sin((double)angle / 180.0 * 3.141596));
            ix1 = centerx + (int)((double)m_Radius * 0.35 * Math.cos((double)angle / 180.0 * 3.141596));
            iy1 = centery - (int)((double)m_Radius * 0.35 * Math.sin((double)angle / 180.0 * 3.141596));
            cPointx[1] = ix1 + (int)((double)m_Radius * 0.08 * Math.cos((double)(90 + angle) / 180.0 * 3.141596));
            cPointy[1] = iy1 - (int)((double)m_Radius * 0.08 * Math.sin((double)(90 + angle) / 180.0 * 3.141596));
            cPointx[2] = ix1 + (int)((double)m_Radius * 0.08 * Math.cos((double)(270 + angle) / 180.0 * 3.141596));
            cPointy[2] = iy1 - (int)((double)m_Radius * 0.08 * Math.sin((double)(270 + angle) / 180.0 * 3.141596));
            g.fillPolygon(cPointx, cPointy, 3);
            g.setColor(Color.white);
            angle = (int)(30.0 + (double)(256 - (this.m_VoltReading & 0xFF)) / 256.0 * 120.0);
            cPointx[0] = centerx + (int)((double)m_Radius * 0.97 * Math.cos((double)angle / 180.0 * 3.141596)) - 1;
            cPointy[0] = centery - (int)((double)m_Radius * 0.97 * Math.sin((double)angle / 180.0 * 3.141596)) - 1;
            ix1 = centerx + (int)((double)m_Radius * 0.35 * Math.cos((double)angle / 180.0 * 3.141596)) - 1;
            iy1 = centery - (int)((double)m_Radius * 0.35 * Math.sin((double)angle / 180.0 * 3.141596)) - 1;
            cPointx[1] = ix1 + (int)((double)m_Radius * 0.08 * Math.cos((double)(90 + angle) / 180.0 * 3.141596)) - 1;
            cPointy[1] = iy1 - (int)((double)m_Radius * 0.08 * Math.sin((double)(90 + angle) / 180.0 * 3.141596)) - 1;
            cPointx[2] = ix1 + (int)((double)m_Radius * 0.08 * Math.cos((double)(270 + angle) / 180.0 * 3.141596)) - 1;
            cPointy[2] = iy1 - (int)((double)m_Radius * 0.08 * Math.sin((double)(270 + angle) / 180.0 * 3.141596)) - 1;
            g.fillPolygon(cPointx, cPointy, 3);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.addRenderingHints(hints);
            mFont = new Font("New Times Roman", 0, 11);
            fm = g.getFontMetrics(mFont);
            fwidth = fm.stringWidth(this.m_ShowString);
            g.setColor(Color.black);
            g.drawString(this.m_ShowString, centerx - (int)((double)fwidth / 2.0) + 1, centery - 3 + 1);
            g.setColor(Color.yellow);
            g.drawString(this.m_ShowString, centerx - (int)((double)fwidth / 2.0), centery - 3);
            mFont = new Font("New Times Roman", 0, 10);
            fm = g.getFontMetrics(mFont);
            fwidth = fm.stringWidth(this.m_LowString);
            g.setColor(Color.black);
            g.drawString(this.m_LowString, 2, centery - 3 + 1);
            g.setColor(Color.red);
            g.drawString(this.m_LowString, 1, centery - 3);
            fwidth = fm.stringWidth(this.m_HighString);
            g.setColor(Color.black);
            g.drawString(this.m_HighString, rcBounds.width - fwidth - 5 + 1, centery - 3 + 1);
            g.setColor(Color.red);
            g.drawString(this.m_HighString, rcBounds.width - fwidth - 5, centery - 3);
        }
    }
}

