/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ByteUtility;
import IPMIView20.CSession;
import IPMIView20.Logger;
import IPMIView20.RMCP;
import IPMIView20.algo.AES_CBC_128;
import IPMIView20.algo.HMAC_MD5_128;
import IPMIView20.algo.HMAC_SHA1_96;
import IPMIView20.algo.MD5_128;
import IPMIView20.algo.XRC4_128;
import IPMIView20.algo.XRC4_40;
import java.util.Vector;

public class RMCPPlus
extends RMCP {
    SessionHeader sessionHeader = new SessionHeader();
    Payload payload = new Payload();
    SessionTrailer sessionTrailer = new SessionTrailer();
    byte payLoadType = 0;
    public static final byte PAYLOAD_IPMI_MESSAGE = 0;
    public static final byte PAYLOAD_SOL = 1;
    public static final byte PAYLOAD_OEM_EXPLICIT = 2;
    public static final byte PAYLOAD_OPEN_SESSION_REQUEST = 16;
    public static final byte PAYLOAD_OPEN_SESSION_RESPONSE = 17;
    public static final byte PAYLOAD_RAKP_MESSAGE_1 = 18;
    public static final byte PAYLOAD_RAKP_MESSAGE_2 = 19;
    public static final byte PAYLOAD_RAKP_MESSAGE_3 = 20;
    public static final byte PAYLOAD_RAKP_MESSAGE_4 = 21;
    public static final String[] RMCPPlusStatusCode = new String[]{"No errors (status code = 00h)", "Insufficient resources to create a session (status code = 01h)", "Invalid Session ID (status code = 02h)", "Invalid payload type (status code = 03h)", "Invalid authentication algorithm (status code = 04h)", "Invalid integrity algorithm (status code = 05h)", "No matching authentication payload (status code = 06h)", "No matching integrity payload (status code = 07h)", "Inactive Session ID (status code = 08h)", "Invalid role (status code = 09h)", "Unauthorized role or privilege level requested (status code = 0Ah)", "Insufficient resources to create a session at the requested role (status code = 0Bh)", "Invalid name length (status code = 0Ch)", "Unauthorized name (status code = 0Dh)", "Unauthorized GUID (status code = 0Eh). (GUID that BMC submitted in RAKP Message 2 was not accepted by remote console)", "Invalid integrity check value (status code = 0Fh)", "Invalid confidentiality algorithm (status code = 10h)", "No Cipher Suite match with proposed security algorithms (status code = 11h)", "Illegal or unrecognized parameter (status code = 12h)"};

    public void RAKPSetup(Vector pPara, CSession iSession, byte[] rawData, int[] length) {
        this.retValue.removeAllElements();
        byte[] payLoadLength = new byte[2];
        this.Header.init();
        this.Session = iSession;
        this.sessionHeader.initForRMCPPlus(pPara);
        byte[] aRAKPBytes = (byte[])pPara.get(4);
        length[0] = 4 + this.sessionHeader.size() + 2 + aRAKPBytes.length;
        int index = 0;
        System.arraycopy(this.Header.rawData(), 0, rawData, index, this.Header.size());
        System.arraycopy(this.sessionHeader.rawData(), 0, rawData, index += this.Header.size(), this.sessionHeader.size());
        ByteUtility.intTo2Bytes(payLoadLength, 0, aRAKPBytes.length);
        System.arraycopy(payLoadLength, 0, rawData, index += this.sessionHeader.size(), payLoadLength.length);
        System.arraycopy(aRAKPBytes, 0, rawData, index += payLoadLength.length, aRAKPBytes.length);
    }

    public void RMCPSetup(byte ClassMsg, byte NetFn, byte CmdFn, byte RqSa, Vector pPara, CSession iSession, byte[] rawData, int[] length) {
        this.retValue.removeAllElements();
        this.Header.init(ClassMsg);
        this.Session = iSession;
        this.sessionHeader.init(pPara);
        this.sessionHeader.setAuthTypeToBeRMCPPLus();
        this.setIPMIMessagePayLoadTypeByCipherSuite();
        this.IMessage.MessageCmd(NetFn, CmdFn, RqSa);
        this.IMessage.MessageData(pPara);
        this.IMessage.Data[this.IMessage.DataPointer] = this.IMessage.checksum2();
        byte[] encryptedPayLoad = this.encryptPayLoad();
        length[0] = this.finalSignAuthCode(rawData, encryptedPayLoad);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("IPMI Command:  =" + ByteUtility.bytesToHex(rawData, length[0]));
        }
    }

    public void RMCPSOLSetup(Vector pPara, Vector solPara, CSession iSession, byte[] rawData, int[] length) {
        this.payLoadType = 1;
        this.retValue.removeAllElements();
        this.Header.init();
        this.Session = iSession;
        this.sessionHeader.init(pPara);
        this.sessionHeader.setAuthTypeToBeRMCPPLus();
        this.setIPMIMessagePayLoadTypeByCipherSuite();
        this.solMessage.init(solPara);
        byte[] encryptedPayLoad = this.encryptPayLoad();
        length[0] = this.finalSignAuthCode(rawData, encryptedPayLoad);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("IPMI Command:  =" + ByteUtility.bytesToHex(rawData, length[0]));
        }
        this.payLoadType = 0;
    }

    private byte[] encryptPayLoad() {
        byte[] encrypted = null;
        switch (this.Session.cipherSuite.getConfidentialityAlgorithm()) {
            case 0: {
                encrypted = this.encryptPayLoad_NONE();
                break;
            }
            case 1: {
                encrypted = this.encryptPayLoad_AES_CBC_128();
                break;
            }
            case 2: {
                encrypted = this.encryptPayLoad_XRC4_128();
                break;
            }
            case 3: {
                encrypted = this.encryptPayLoad_XRC4_40();
            }
        }
        return encrypted;
    }

    private byte[] encryptPayLoad_NONE() {
        int index = 0;
        byte[] payLoad = null;
        if (this.payLoadType == 0) {
            payLoad = new byte[this.IMessage.size()];
            payLoad[index++] = this.IMessage.rsSA;
            payLoad[index++] = this.IMessage.NetFnLun;
            payLoad[index++] = this.IMessage.checksum1;
            payLoad[index++] = this.IMessage.rqSA;
            payLoad[index++] = this.IMessage.rqSeqLun;
            payLoad[index++] = this.IMessage.cmd;
            System.arraycopy(this.IMessage.Data, 0, payLoad, index, this.IMessage.size() - 6);
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("payLoad =" + ByteUtility.bytesToHex(payLoad));
            }
        }
        if (this.payLoadType == 1) {
            payLoad = this.solMessage.getContent();
        }
        return payLoad;
    }

    private byte[] encryptPayLoad_AES_CBC_128() {
        byte[] originalPayLoad = this.encryptPayLoad_NONE();
        byte[] iv = ByteUtility.random16Bytes();
        int padSize = 0;
        byte[] pad = null;
        if ((originalPayLoad.length + 1) % 16 == 0) {
            padSize = 0;
            pad = new byte[]{};
        } else {
            padSize = 16 - (originalPayLoad.length + 1) % 16;
            pad = new byte[padSize];
            for (int i = 0; i < padSize; ++i) {
                pad[i] = (byte)(i + 1);
            }
        }
        byte[] tobeEncryptedPayLoad = new byte[originalPayLoad.length + padSize + 1];
        System.arraycopy(originalPayLoad, 0, tobeEncryptedPayLoad, 0, originalPayLoad.length);
        System.arraycopy(pad, 0, tobeEncryptedPayLoad, originalPayLoad.length, pad.length);
        tobeEncryptedPayLoad[originalPayLoad.length + pad.length] = (byte)padSize;
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("tobeEncryptedPayLoad =" + ByteUtility.bytesToHex(tobeEncryptedPayLoad));
        }
        byte[] encryptedPayLoad = new AES_CBC_128().encrypt(iv, this.Session.K2, tobeEncryptedPayLoad);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("encryptedPayLoad =" + ByteUtility.bytesToHex(encryptedPayLoad));
        }
        byte[] AES_CBC_payLoad = new byte[iv.length + encryptedPayLoad.length];
        System.arraycopy(iv, 0, AES_CBC_payLoad, 0, 16);
        System.arraycopy(encryptedPayLoad, 0, AES_CBC_payLoad, 16, encryptedPayLoad.length);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("AES_CBC_PAYLOAD:" + ByteUtility.bytesToHex(AES_CBC_payLoad));
        }
        return AES_CBC_payLoad;
    }

    private byte[] encryptPayLoad_XRC4_128() {
        byte[] originalPayLoad = this.encryptPayLoad_NONE();
        byte[] encryptPayLoad = null;
        if (this.Session.SessionSeq[0] == 1 && this.Session.SessionSeq[1] == 0 && this.Session.SessionSeq[2] == 0 && this.Session.SessionSeq[3] == 0) {
            byte[] iv = ByteUtility.random16Bytes();
            this.Session.ivForEncrypt = iv;
            byte[] temp = new byte[32];
            System.arraycopy(this.Session.K2, 0, temp, 0, 16);
            System.arraycopy(iv, 0, temp, 16, 16);
            this.Session.keyRcForEncrypt = new MD5_128().code(null, temp);
            ByteUtility.intTo4Bytes(this.Session.dataOffsetBytes, 0, 0);
            this.Session.xrc4_128_encrypt = new XRC4_128();
            byte[] encrypt = this.Session.xrc4_128_encrypt.encrypt(iv, this.Session.keyRcForEncrypt, originalPayLoad);
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-128)iv:" + ByteUtility.bytesToHex(iv));
            }
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-128)keyRcForEncrypt:" + ByteUtility.bytesToHex(this.Session.keyRcForEncrypt));
            }
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-128)encrypt:" + ByteUtility.bytesToHex(encrypt));
            }
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-128)test decrypt:" + ByteUtility.bytesToHex(this.Session.xrc4_128_encrypt.decrypt(iv, this.Session.keyRcForEncrypt, encrypt)));
            }
            encryptPayLoad = new byte[20 + encrypt.length];
            System.arraycopy(this.Session.dataOffsetBytes, 0, encryptPayLoad, 0, 4);
            System.arraycopy(iv, 0, encryptPayLoad, 4, 16);
            System.arraycopy(encrypt, 0, encryptPayLoad, 20, encrypt.length);
        } else {
            ByteUtility.intTo4Bytes(this.Session.dataOffsetBytes, 0, this.Session.dataOffsetForEncrypt);
            byte[] encrypt = this.Session.xrc4_128_encrypt.encrypt(this.Session.ivForEncrypt, this.Session.keyRcForEncrypt, originalPayLoad);
            encryptPayLoad = new byte[4 + encrypt.length];
            System.arraycopy(this.Session.dataOffsetBytes, 0, encryptPayLoad, 0, 4);
            System.arraycopy(encrypt, 0, encryptPayLoad, 4, encrypt.length);
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-128)dataOffsetBytes:" + ByteUtility.bytesToHex(this.Session.dataOffsetBytes));
            }
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-128)test decrypt:" + ByteUtility.bytesToHex(this.Session.xrc4_128_encrypt.decrypt(this.Session.ivForEncrypt, this.Session.keyRcForEncrypt, encrypt)));
            }
        }
        this.Session.dataOffsetForEncrypt += originalPayLoad.length;
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(XRC4-128)encryptPayLoad:" + ByteUtility.bytesToHex(encryptPayLoad));
        }
        return encryptPayLoad;
    }

    private byte[] encryptPayLoad_XRC4_40() {
        byte[] originalPayLoad = this.encryptPayLoad_NONE();
        byte[] encryptPayLoad = null;
        if (this.Session.SessionSeq[0] == 1 && this.Session.SessionSeq[1] == 0 && this.Session.SessionSeq[2] == 0 && this.Session.SessionSeq[3] == 0) {
            byte[] iv = ByteUtility.random16Bytes();
            this.Session.ivForEncrypt = iv;
            byte[] temp = new byte[32];
            System.arraycopy(this.Session.K2, 0, temp, 0, 16);
            System.arraycopy(iv, 0, temp, 16, 16);
            this.Session.keyRcForEncrypt = new MD5_128().code(null, temp);
            ByteUtility.intTo4Bytes(this.Session.dataOffsetBytes, 0, 0);
            this.Session.xrc4_40_encrypt = new XRC4_40();
            byte[] encrypt = this.Session.xrc4_40_encrypt.encrypt(iv, this.Session.keyRcForEncrypt, originalPayLoad);
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-40)iv:" + ByteUtility.bytesToHex(iv));
            }
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-40)keyRcForEncrypt:" + ByteUtility.bytesToHex(this.Session.keyRcForEncrypt));
            }
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-40)encrypt:" + ByteUtility.bytesToHex(encrypt));
            }
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-40)test decrypt:" + ByteUtility.bytesToHex(this.Session.xrc4_40_encrypt.decrypt(iv, this.Session.keyRcForEncrypt, encrypt)));
            }
            encryptPayLoad = new byte[20 + encrypt.length];
            System.arraycopy(this.Session.dataOffsetBytes, 0, encryptPayLoad, 0, 4);
            System.arraycopy(iv, 0, encryptPayLoad, 4, 16);
            System.arraycopy(encrypt, 0, encryptPayLoad, 20, encrypt.length);
        } else {
            ByteUtility.intTo4Bytes(this.Session.dataOffsetBytes, 0, this.Session.dataOffsetForEncrypt);
            byte[] encrypt = this.Session.xrc4_40_encrypt.encrypt(this.Session.ivForEncrypt, this.Session.keyRcForEncrypt, originalPayLoad);
            encryptPayLoad = new byte[4 + encrypt.length];
            System.arraycopy(this.Session.dataOffsetBytes, 0, encryptPayLoad, 0, 4);
            System.arraycopy(encrypt, 0, encryptPayLoad, 4, encrypt.length);
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-40)dataOffsetBytes:" + ByteUtility.bytesToHex(this.Session.dataOffsetBytes));
            }
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog("(XRC4-40)test decrypt:" + ByteUtility.bytesToHex(this.Session.xrc4_40_encrypt.decrypt(this.Session.ivForEncrypt, this.Session.keyRcForEncrypt, encrypt)));
            }
        }
        this.Session.dataOffsetForEncrypt += originalPayLoad.length;
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(XRC4-40)encryptPayLoad:" + ByteUtility.bytesToHex(encryptPayLoad));
        }
        return encryptPayLoad;
    }

    public int refinalSignAuthCode(byte[] rawData, byte[] encryptedPayLoad) {
        int length = 0;
        switch (this.Session.cipherSuite.getIntegrityAlgorithm()) {
            case 1: {
                length = this.finalSignAuthCode_HMAC_SHA1_96(rawData, encryptedPayLoad, true);
                break;
            }
            case 2: {
                length = this.finalSignAuthCode_HMAC_MD5_128(rawData, encryptedPayLoad, true);
                break;
            }
            case 3: {
                length = this.finalSignAuthCode_MD5_128(rawData, encryptedPayLoad, true);
            }
        }
        return length;
    }

    private int finalSignAuthCode(byte[] rawData, byte[] encryptedPayLoad) {
        int length = 0;
        switch (this.Session.cipherSuite.getIntegrityAlgorithm()) {
            case 0: {
                length = this.finalSignAuthCode_NONE(rawData, encryptedPayLoad);
                break;
            }
            case 1: {
                length = this.finalSignAuthCode_HMAC_SHA1_96(rawData, encryptedPayLoad, false);
                break;
            }
            case 2: {
                length = this.finalSignAuthCode_HMAC_MD5_128(rawData, encryptedPayLoad, false);
                break;
            }
            case 3: {
                length = this.finalSignAuthCode_MD5_128(rawData, encryptedPayLoad, false);
            }
        }
        return length;
    }

    private int finalSignAuthCode_NONE(byte[] rawData, byte[] encryptedPayLoad) {
        int beforeSignPacketSize = this.Header.size() + this.sessionHeader.size() + 2 + encryptedPayLoad.length;
        int index = 0;
        System.arraycopy(this.Header.rawData(), 0, rawData, index, this.Header.size());
        index += this.Header.size();
        rawData[index++] = this.sessionHeader.AuthType;
        rawData[index++] = this.sessionHeader.payLoadType;
        System.arraycopy(this.sessionHeader.SessionID, 0, rawData, index, 4);
        System.arraycopy(this.sessionHeader.SessionSeq, 0, rawData, index += 4, 4);
        byte[] payLoadLength = new byte[2];
        ByteUtility.intTo2Bytes(payLoadLength, 0, encryptedPayLoad.length);
        System.arraycopy(payLoadLength, 0, rawData, index += 4, payLoadLength.length);
        System.arraycopy(encryptedPayLoad, 0, rawData, index += 2, encryptedPayLoad.length);
        this.Session.originalEncryptedpayLoadWithoutAuthcode = new byte[beforeSignPacketSize];
        System.arraycopy(rawData, 0, this.Session.originalEncryptedpayLoadWithoutAuthcode, 0, beforeSignPacketSize);
        return beforeSignPacketSize;
    }

    private int finalSignAuthCode_HMAC_SHA1_96(byte[] rawData, byte[] encryptedPayLoad, boolean forRetry) {
        int beforeSignPacketSize = forRetry ? encryptedPayLoad.length : this.finalSignAuthCode_NONE(rawData, encryptedPayLoad);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("before encode :=" + ByteUtility.bytesToHex(rawData, beforeSignPacketSize));
        }
        int padSize = 4 - (beforeSignPacketSize + 2) % 4;
        int tempSignPacketSize = beforeSignPacketSize + padSize + 2;
        byte[] tempPacket = new byte[tempSignPacketSize];
        for (int i = 0; i < padSize; ++i) {
            rawData[beforeSignPacketSize + i] = -1;
        }
        rawData[beforeSignPacketSize + padSize] = (byte)padSize;
        rawData[beforeSignPacketSize + padSize + 1] = 7;
        byte[] temp = new byte[beforeSignPacketSize + padSize + 2];
        System.arraycopy(rawData, 0, temp, 0, temp.length);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("before encode 2=" + ByteUtility.bytesToHex(temp));
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("K1 =" + ByteUtility.bytesToHex(this.Session.K1));
        }
        byte[] temp2 = new byte[temp.length - 4];
        System.arraycopy(temp, 4, temp2, 0, temp2.length);
        byte[] authCode = new HMAC_SHA1_96().code(this.Session.K1, temp2);
        System.arraycopy(authCode, 0, rawData, beforeSignPacketSize + padSize + 2, authCode.length);
        return beforeSignPacketSize + padSize + 2 + authCode.length;
    }

    private int finalSignAuthCode_HMAC_MD5_128(byte[] rawData, byte[] encryptedPayLoad, boolean forRetry) {
        int beforeSignPacketSize = forRetry ? encryptedPayLoad.length : this.finalSignAuthCode_NONE(rawData, encryptedPayLoad);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("before encode :=" + ByteUtility.bytesToHex(rawData, beforeSignPacketSize));
        }
        int padSize = 4 - (beforeSignPacketSize + 2) % 4;
        int tempSignPacketSize = beforeSignPacketSize + padSize + 2;
        byte[] tempPacket = new byte[tempSignPacketSize];
        for (int i = 0; i < padSize; ++i) {
            rawData[beforeSignPacketSize + i] = -1;
        }
        rawData[beforeSignPacketSize + padSize] = (byte)padSize;
        rawData[beforeSignPacketSize + padSize + 1] = 7;
        byte[] temp = new byte[beforeSignPacketSize + padSize + 2];
        System.arraycopy(rawData, 0, temp, 0, temp.length);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("size =" + temp.length);
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("before encode 2=" + ByteUtility.bytesToHex(temp));
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("K1 =" + ByteUtility.bytesToHex(this.Session.K1));
        }
        byte[] temp2 = new byte[temp.length - 4];
        System.arraycopy(temp, 4, temp2, 0, temp2.length);
        byte[] authCode = new HMAC_MD5_128().code(this.Session.K1, temp2);
        System.arraycopy(authCode, 0, rawData, beforeSignPacketSize + padSize + 2, authCode.length);
        return beforeSignPacketSize + padSize + 2 + authCode.length;
    }

    private int finalSignAuthCode_MD5_128(byte[] rawData, byte[] encryptedPayLoad, boolean forRetry) {
        int beforeSignPacketSize = forRetry ? encryptedPayLoad.length : this.finalSignAuthCode_NONE(rawData, encryptedPayLoad);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("before encode :=" + ByteUtility.bytesToHex(rawData, beforeSignPacketSize));
        }
        int padSize = 4 - (beforeSignPacketSize + 2) % 4;
        for (int i = 0; i < padSize; ++i) {
            rawData[beforeSignPacketSize + i] = -1;
        }
        rawData[beforeSignPacketSize + padSize] = (byte)padSize;
        rawData[beforeSignPacketSize + padSize + 1] = 7;
        byte[] temp = new byte[beforeSignPacketSize + padSize + 2];
        System.arraycopy(rawData, 0, temp, 0, temp.length);
        byte[] temp2 = new byte[temp.length - 4];
        System.arraycopy(temp, 4, temp2, 0, temp2.length);
        byte[] paddingPassword = new byte[20];
        System.arraycopy(this.Session.UserPassword, 0, paddingPassword, 0, this.Session.PasswordLength);
        byte[] tempAll = new byte[temp2.length + paddingPassword.length * 2];
        System.arraycopy(paddingPassword, 0, tempAll, 0, paddingPassword.length);
        System.arraycopy(temp2, 0, tempAll, paddingPassword.length, temp2.length);
        System.arraycopy(paddingPassword, 0, tempAll, temp2.length + paddingPassword.length, paddingPassword.length);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("size =" + tempAll.length);
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("before encode 2=" + ByteUtility.bytesToHex(tempAll));
        }
        byte[] authCode = new MD5_128().code(this.Session.K1, tempAll);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("auth code =" + ByteUtility.bytesToHex(authCode));
        }
        System.arraycopy(authCode, 0, rawData, beforeSignPacketSize + padSize + 2, authCode.length);
        return beforeSignPacketSize + padSize + 2 + authCode.length;
    }

    private void setIPMIMessagePayLoadTypeByCipherSuite() {
        if (this.payLoadType == 0) {
            this.sessionHeader.payLoadType = 0;
        } else if (this.payLoadType == 1) {
            this.sessionHeader.payLoadType = 1;
        }
        if (this.Session.cipherSuite.getConfidentialityAlgorithm() > 0) {
            this.sessionHeader.payLoadType = (byte)(this.sessionHeader.payLoadType | 0xFFFFFF80);
        }
        if (this.Session.cipherSuite.getIntegrityAlgorithm() > 0) {
            this.sessionHeader.payLoadType = (byte)(this.sessionHeader.payLoadType | 0x40);
        }
    }

    public void ResolvePacket(byte[] recvBuf, int authcodeflag, int recvLength) {
        boolean result = this.checkRecvAuthCode(recvBuf, recvLength);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("IPMI Response  =" + ByteUtility.bytesToHex(recvBuf, recvLength));
        }
        byte[] decryptRecvBuf = this.decryptPayLoad(recvBuf, recvLength);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("decryptRecvBuf =" + ByteUtility.bytesToHex(decryptRecvBuf));
        }
        byte[] reverseReceBuf = this.returnToOriginalRMCP(decryptRecvBuf, authcodeflag);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("reverseReceBuf =" + ByteUtility.bytesToHex(reverseReceBuf));
        }
        super.ResolvePacket(reverseReceBuf, authcodeflag, recvLength);
    }

    public byte[] ResolvePacketToOriginal(byte[] recvBuf, int authcodeflag, int recvLength) {
        boolean result = this.checkRecvAuthCode(recvBuf, recvLength);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("IPMI Response  =" + ByteUtility.bytesToHex(recvBuf, recvLength));
        }
        byte[] decryptRecvBuf = this.decryptPayLoad(recvBuf, recvLength);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("decryptRecvBuf =" + ByteUtility.bytesToHex(decryptRecvBuf));
        }
        return decryptRecvBuf;
    }

    private byte[] decryptPayLoad(byte[] recvBuf, int recvLength) {
        byte[] decrypted = null;
        switch (this.Session.cipherSuite.getConfidentialityAlgorithm()) {
            case 0: {
                decrypted = this.decryptPayLoad_NONE(recvBuf, recvLength);
                break;
            }
            case 1: {
                decrypted = this.decryptPayLoad_AES_CBC_128(recvBuf, recvLength);
                break;
            }
            case 2: {
                decrypted = this.decryptPayLoad_XRC4_128(recvBuf, recvLength);
                break;
            }
            case 3: {
                decrypted = this.decryptPayLoad_XRC4_40(recvBuf, recvLength);
            }
        }
        return decrypted;
    }

    private byte[] decryptPayLoad_NONE(byte[] recvBuf, int recvLength) {
        byte[] decrypted = new byte[recvLength];
        System.arraycopy(recvBuf, 0, decrypted, 0, recvLength);
        return decrypted;
    }

    private byte[] decryptPayLoad_AES_CBC_128(byte[] recvBuf, int recvLength) {
        byte[] payLoadLength = new byte[2];
        System.arraycopy(recvBuf, 14, payLoadLength, 0, 2);
        byte[] wholePayLoad = new byte[ByteUtility.twoBytesToInt(payLoadLength)];
        if (ByteUtility.twoBytesToInt(payLoadLength) < 16) {
            return null;
        }
        System.arraycopy(recvBuf, 16, wholePayLoad, 0, ByteUtility.twoBytesToInt(payLoadLength));
        byte[] iv = new byte[16];
        byte[] encryptPayLoad = new byte[wholePayLoad.length - 16];
        System.arraycopy(wholePayLoad, 0, iv, 0, iv.length);
        System.arraycopy(wholePayLoad, iv.length, encryptPayLoad, 0, encryptPayLoad.length);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(AES-CBC)iv  =" + ByteUtility.bytesToHex(iv));
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(AES-CBC)encryptPayLoad  =" + ByteUtility.bytesToHex(encryptPayLoad));
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(AES-CBC)encryptPayLoad.length =" + encryptPayLoad.length);
        }
        byte[] decryptPayLoad = new AES_CBC_128().decrypt(iv, this.Session.K2, encryptPayLoad);
        byte padLength = 0;
        byte[] originalPayLoad = null;
        if (decryptPayLoad[decryptPayLoad.length - 1] >= 0 && decryptPayLoad[decryptPayLoad.length - 1] <= 15) {
            padLength = decryptPayLoad[decryptPayLoad.length - 1];
            originalPayLoad = new byte[decryptPayLoad.length - padLength - 1];
        } else {
            padLength = 0;
            originalPayLoad = new byte[decryptPayLoad.length];
        }
        System.arraycopy(decryptPayLoad, 0, originalPayLoad, 0, originalPayLoad.length);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(AES-CBC)DecryptPayload  =" + ByteUtility.bytesToHex(decryptPayLoad));
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(AES-CBC)originalPayLoad =" + ByteUtility.bytesToHex(originalPayLoad));
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(AES-CBC)padLength =" + padLength);
        }
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("(AES-CBC)OriginalPayLoad.length =" + originalPayLoad.length);
        }
        byte[] originalPacket = new byte[16 + originalPayLoad.length];
        byte[] blength = new byte[2];
        ByteUtility.intTo2Bytes(blength, 0, originalPayLoad.length);
        System.arraycopy(recvBuf, 0, originalPacket, 0, 14);
        System.arraycopy(blength, 0, originalPacket, 14, 2);
        System.arraycopy(originalPayLoad, 0, originalPacket, 16, originalPayLoad.length);
        return originalPacket;
    }

    private byte[] decryptPayLoad_XRC4_128(byte[] recvBuf, int recvLength) {
        byte[] originalPayLoad = null;
        byte[] payLoadLength = new byte[2];
        System.arraycopy(recvBuf, 14, payLoadLength, 0, 2);
        byte[] wholePayLoad = new byte[ByteUtility.twoBytesToInt(payLoadLength)];
        System.arraycopy(recvBuf, 16, wholePayLoad, 0, ByteUtility.twoBytesToInt(payLoadLength));
        byte[] dataOffsetBytes = new byte[4];
        System.arraycopy(wholePayLoad, 0, dataOffsetBytes, 0, 4);
        if (dataOffsetBytes[0] == 0 && dataOffsetBytes[1] == 0 && dataOffsetBytes[2] == 0 && dataOffsetBytes[3] == 0) {
            byte[] iv = new byte[16];
            System.arraycopy(wholePayLoad, 4, iv, 0, 16);
            this.Session.ivForDecrypt = iv;
            byte[] temp = new byte[32];
            System.arraycopy(this.Session.K2, 0, temp, 0, 16);
            System.arraycopy(iv, 0, temp, 16, 16);
            this.Session.keyRcForDecrypt = new MD5_128().code(null, temp);
            byte[] encryptPayLoad = new byte[wholePayLoad.length - 4 - 16];
            System.arraycopy(wholePayLoad, 20, encryptPayLoad, 0, encryptPayLoad.length);
            this.Session.xrc4_128_decrypt = new XRC4_128();
            originalPayLoad = this.Session.xrc4_128_decrypt.decrypt(iv, this.Session.keyRcForDecrypt, encryptPayLoad);
        } else {
            byte[] encryptPayLoad = new byte[wholePayLoad.length - 4];
            System.arraycopy(wholePayLoad, 4, encryptPayLoad, 0, encryptPayLoad.length);
            originalPayLoad = this.Session.xrc4_128_decrypt.decrypt(this.Session.ivForDecrypt, this.Session.keyRcForDecrypt, encryptPayLoad);
        }
        byte[] originalPacket = new byte[16 + originalPayLoad.length];
        byte[] blength = new byte[2];
        ByteUtility.intTo2Bytes(blength, 0, originalPayLoad.length);
        System.arraycopy(recvBuf, 0, originalPacket, 0, 14);
        System.arraycopy(blength, 0, originalPacket, 14, 2);
        System.arraycopy(originalPayLoad, 0, originalPacket, 16, originalPayLoad.length);
        return originalPacket;
    }

    private byte[] decryptPayLoad_XRC4_40(byte[] recvBuf, int recvLength) {
        byte[] originalPayLoad = null;
        byte[] payLoadLength = new byte[2];
        System.arraycopy(recvBuf, 14, payLoadLength, 0, 2);
        byte[] wholePayLoad = new byte[ByteUtility.twoBytesToInt(payLoadLength)];
        System.arraycopy(recvBuf, 16, wholePayLoad, 0, ByteUtility.twoBytesToInt(payLoadLength));
        byte[] dataOffsetBytes = new byte[4];
        System.arraycopy(wholePayLoad, 0, dataOffsetBytes, 0, 4);
        if (dataOffsetBytes[0] == 0 && dataOffsetBytes[1] == 0 && dataOffsetBytes[2] == 0 && dataOffsetBytes[3] == 0) {
            byte[] iv = new byte[16];
            System.arraycopy(wholePayLoad, 4, iv, 0, 16);
            this.Session.ivForDecrypt = iv;
            byte[] temp = new byte[32];
            System.arraycopy(this.Session.K2, 0, temp, 0, 16);
            System.arraycopy(iv, 0, temp, 16, 16);
            this.Session.keyRcForDecrypt = new MD5_128().code(null, temp);
            byte[] encryptPayLoad = new byte[wholePayLoad.length - 4 - 16];
            System.arraycopy(wholePayLoad, 20, encryptPayLoad, 0, encryptPayLoad.length);
            this.Session.xrc4_40_decrypt = new XRC4_40();
            originalPayLoad = this.Session.xrc4_40_decrypt.decrypt(iv, this.Session.keyRcForDecrypt, encryptPayLoad);
        } else {
            byte[] encryptPayLoad = new byte[wholePayLoad.length - 4];
            System.arraycopy(wholePayLoad, 4, encryptPayLoad, 0, encryptPayLoad.length);
            originalPayLoad = this.Session.xrc4_40_decrypt.decrypt(this.Session.ivForDecrypt, this.Session.keyRcForDecrypt, encryptPayLoad);
        }
        byte[] originalPacket = new byte[16 + originalPayLoad.length];
        byte[] blength = new byte[2];
        ByteUtility.intTo2Bytes(blength, 0, originalPayLoad.length);
        System.arraycopy(recvBuf, 0, originalPacket, 0, 14);
        System.arraycopy(blength, 0, originalPacket, 14, 2);
        System.arraycopy(originalPayLoad, 0, originalPacket, 16, originalPayLoad.length);
        return originalPacket;
    }

    private byte[] returnToOriginalRMCP(byte[] decryptRecvBuf, int authcodeflag) {
        byte[] dumpAuthCode = new byte[]{119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119};
        byte[] original = new byte[256];
        boolean oIndex = false;
        byte version = decryptRecvBuf[0];
        byte reserved = decryptRecvBuf[1];
        byte rmcpSeq = decryptRecvBuf[2];
        byte ClassOfMessage = decryptRecvBuf[3];
        byte authType = decryptRecvBuf[4];
        byte[] sessionID = new byte[4];
        byte[] sessionSeq = new byte[4];
        byte[] payloadlength = new byte[2];
        byte[] payload = new byte[decryptRecvBuf.length - 16];
        System.arraycopy(decryptRecvBuf, 6, sessionID, 0, 4);
        System.arraycopy(decryptRecvBuf, 10, sessionSeq, 0, 4);
        System.arraycopy(decryptRecvBuf, 14, payloadlength, 0, 2);
        System.arraycopy(decryptRecvBuf, 16, payload, 0, ByteUtility.twoBytesToInt(payloadlength));
        int index = 0;
        original[index++] = version;
        original[index++] = reserved;
        original[index++] = rmcpSeq;
        original[index++] = ClassOfMessage;
        original[index++] = authType;
        System.arraycopy(sessionSeq, 0, original, index, 4);
        System.arraycopy(sessionID, 0, original, index += 4, 4);
        index += 4;
        if (authcodeflag == 1) {
            System.arraycopy(dumpAuthCode, 0, original, index, 16);
            index += 16;
        }
        original[index++] = (byte)ByteUtility.twoBytesToInt(payloadlength);
        System.arraycopy(payload, 0, original, index, payload.length);
        index += payload.length;
        original[index++] = 0;
        return original;
    }

    public boolean checkRecvAuthCode(byte[] recvBuf, int recvLength) {
        boolean result = false;
        switch (this.Session.cipherSuite.getIntegrityAlgorithm()) {
            case 0: {
                result = this.checkRecvAuthCode_NONE(recvBuf, recvLength);
                break;
            }
            case 1: {
                result = this.checkRecvAuthCode_HMAC_SHA1_96(recvBuf, recvLength);
                break;
            }
            case 2: {
                result = this.checkRecvAuthCode_HMAC_MD5_128(recvBuf, recvLength);
                break;
            }
            case 3: {
                result = this.checkRecvAuthCode_MD5_128(recvBuf, recvLength);
            }
        }
        return result;
    }

    public boolean checkRecvAuthCode_NONE(byte[] recvBuf, int recvLength) {
        return true;
    }

    public boolean checkRecvAuthCode_HMAC_SHA1_96(byte[] recvBuf, int recvLength) {
        return true;
    }

    public boolean checkRecvAuthCode_HMAC_MD5_128(byte[] recvBuf, int recvLength) {
        return true;
    }

    public boolean checkRecvAuthCode_MD5_128(byte[] recvBuf, int recvLength) {
        return true;
    }

    public class SessionTrailer {
        byte[] integrityPAD;
        byte padLength;
        byte nextHeader = (byte)7;
        byte[] authCode;

        public int size() {
            return 0;
        }
    }

    public class Payload {
        byte[] payloadLength = new byte[]{0, 0};
        byte[] confidentialityHeader;
        private RMCP.IPMIMessage ipmiMessage;
        byte[] confidentialityTrailer;

        private void calPayloadLength() {
            int length = this.ipmiMessage.size();
        }
    }

    public class SessionHeader {
        byte AuthType = 0;
        byte payLoadType = 0;
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] OEM_IANA = new byte[]{0, 0, 0, 0};
        byte[] OEM_Payload_ID = new byte[]{0, 0};

        public byte size() {
            return 10;
        }

        public byte[] rawData() {
            byte[] raw = new byte[this.size()];
            raw[0] = this.AuthType;
            raw[1] = this.payLoadType;
            System.arraycopy(this.SessionID, 0, raw, 2, 4);
            System.arraycopy(this.SessionSeq, 0, raw, 6, 4);
            return raw;
        }

        public void init(Vector pPara) {
            byte[] bytes = (byte[])pPara.get(0);
            this.AuthType = bytes[0];
            bytes = (byte[])pPara.get(1);
            System.arraycopy(bytes, 0, this.SessionSeq, 0, 4);
            bytes = (byte[])pPara.get(2);
            System.arraycopy(bytes, 0, this.SessionID, 0, 4);
        }

        public void setAuthTypeToBeRMCPPLus() {
            this.AuthType = (byte)6;
        }

        public void initForRMCPPlus(Vector pPara) {
            byte[] bytes = (byte[])pPara.get(0);
            this.AuthType = bytes[0];
            bytes = (byte[])pPara.get(1);
            this.payLoadType = bytes[0];
            bytes = (byte[])pPara.get(2);
            System.arraycopy(bytes, 0, this.SessionSeq, 0, 4);
            bytes = (byte[])pPara.get(3);
            System.arraycopy(bytes, 0, this.SessionID, 0, 4);
        }

        public void setPayLoadType(byte payLoadType) {
            this.payLoadType = payLoadType;
        }
    }
}

