/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CMMDebug;
import IPMIView20.CMMKVMSwitchSubPanel;
import IPMIView20.CMMSessionPanel;
import IPMIView20.CMMUIPanel;
import IPMIView20.L;
import IPMIView20.Logger;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.sol.SOLPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class CMMSOLPanel
extends CMMUIPanel {
    Icon warningYellowIcon = new ImageIcon(this.getClass().getResource("/images/warning_yellow.gif"));
    CMMKVMSwitchSubPanel cmmKVMSwitchSubPanel = new CMMKVMSwitchSubPanel();
    SOLPanel solPanel = new SOLPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane jSplitPane1 = new JSplitPane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jNorthPanel = new JPanel();
    JLabel jInfoLabel = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    BladeSystemEntity bladeSystemEntity = null;

    public CMMSOLPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() {
        this.jSplitPane1.resetToPreferredSizes();
        this.jPanel1.add((Component)this.solPanel, "Center");
        this.solPanel.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                CMMSOLPanel.this.solPanel.requestFocusInWindow();
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.jInfoLabel.setVisible(false);
        MessageCenter.getInstance().deleteObserver(this.solPanel);
    }

    public void setUserPrivilege() {
        for (int i = 0; i < 14; ++i) {
            this.cmmKVMSwitchSubPanel.getPowerButton(i + 1).setEnabled(false);
        }
    }

    public void setOperatorPrivilege() {
        for (int i = 0; i < 14; ++i) {
            this.cmmKVMSwitchSubPanel.getPowerButton(i + 1).setEnabled(true);
        }
    }

    public void setAdministratorPrivilege() {
        for (int i = 0; i < 14; ++i) {
            this.cmmKVMSwitchSubPanel.getPowerButton(i + 1).setEnabled(true);
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("Text Console");
        this.setLayout(this.borderLayout1);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setEnabled(false);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(null);
        this.jInfoLabel.setForeground(Color.blue);
        this.jInfoLabel.setToolTipText("");
        this.jInfoLabel.setHorizontalAlignment(2);
        this.jInfoLabel.setIcon(this.warningYellowIcon);
        this.jInfoLabel.setText("");
        this.jNorthPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel1, "bottom");
        this.jPanel1.add((Component)this.jNorthPanel, "North");
        this.jNorthPanel.add(this.jInfoLabel);
        this.jSplitPane1.add((Component)this.cmmKVMSwitchSubPanel, "top");
    }

    public void preset(CMMSessionPanel cmmSessionPanel, JLabel xMessage) {
        super.preset(cmmSessionPanel, xMessage);
        cmmSessionPanel.bladeSystemEntity.addObserver(this);
        if (cmmSessionPanel.bladeSystemEntity.getBlades().length == 10) {
            this.cmmKVMSwitchSubPanel.setBladeType(0);
        } else {
            this.cmmKVMSwitchSubPanel.setBladeType(1);
        }
        this.cmmKVMSwitchSubPanel.preset(cmmSessionPanel, xMessage);
        this.solPanel.setIP(cmmSessionPanel.ipmiInterfaceConfig.getIp());
        this.solPanel.setUsername(cmmSessionPanel.ipmiInterfaceConfig.getUserName());
        this.solPanel.setPassword(cmmSessionPanel.ipmiInterfaceConfig.getPassword());
        this.solPanel.hideUIForCMM();
    }

    public void closeSOLUI() {
        if (this.solPanel.isSOLActivated) {
            this.solPanel.stopSOL();
        }
        if (this.cmmKVMSwitchSubPanel != null) {
            this.cmmKVMSwitchSubPanel.closePanel();
        }
        this.cmmSessionPanel = null;
    }

    public void present() {
    }

    public void update(Observable o, Object arg) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[CMMSOLPanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    CMMSOLPanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        BladeEntity[] blades = this.bladeSystemEntity.getBlades();
        for (int i = 0; i < blades.length; ++i) {
            if (blades[i].getPresent() == 0 || blades[i].getKvmEnable() != 1) continue;
            if (blades[i].isSimCardDetectPin()) {
                this.jInfoLabel.setText(L.t("cmm.SOL.The_Text_console_on_Blade") + " " + (i + 1) + " " + L.t("cmm.SOL.is_monitor_only"));
                this.jInfoLabel.setVisible(true);
                this.solPanel.setEditableSOL(false);
                continue;
            }
            this.jInfoLabel.setVisible(false);
            this.solPanel.setEditableSOL(true);
        }
    }
}

