/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999-2001, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
 this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation 
 and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
 may be used to endorse or promote products derived from this software 
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
****************************************************************************/

/**********************************************************************
*                                                                     *
* INTEL CORPORATION                                                   *
*                                                                     *
* This software is supplied under the terms of the license included   *
* above.  All use of this driver must be in accordance with the terms *
* of that license.                                                    *
*                                                                     *
* Module Name:  e100.c                                                *
*                                                                     *
* Abstract:     Functions for the driver entry points like load,      *
*               unload, open and close. All board specific calls made *
*               by the network interface section of the driver.       *
*                                                                     *
* Environment:  This file is intended to be specific to the Linux     *
*               operating system.                                     *
*                                                                     *
**********************************************************************/



#define PHY_NC3133      1

#define COND_FREE(X)            if (X) kfree(X)
#define ALLOC_SKBS(bddp, nskb)  \
  for (; (bddp)->skb_req > 0; (bddp)->skb_req--) { \
      (nskb) = e100_alloc_skb(bddp);\
      if ((nskb) == NULL) break;\
      e100_add_skb_to_end( (bddp), (nskb) );\
  }

 
#define _IANS_MAIN_MODULE_C_

#ifdef __i386__
#define CSUM_i386  
#endif  /* __i386__ */

#define VLAN_SIZE      2
#define CSUM_559_SIZE  2

/* includes */
#undef __NO_VERSION__
#include "e100.h"
#include "rcvbundl.h"
#include "e100_config.h"
#include "e100_proc.h"

/****************************************************************************
 * Parameter checking for compile time variables
 */
char           *e100_ifname = IFNAME;

uint8_t         e100_tx_thld =
(TX_THRSHLD < 0) ? DEFAULT_TRANSMIT_THRESHOLD : ((TX_THRSHLD >
    200) ? DEFAULT_TRANSMIT_THRESHOLD : TX_THRSHLD);

/* Congestion enable flag for National Phy */
uint_t          e100_cong_enbl = TX_CONG_DFLT;

/* 
 * Auto-polarity enable/disable
 * e100_autopolarity = 0 => disable auto-polarity
 * e100_autopolarity = 1 => enable auto-polarity
 * e100_autopolarity = 2 => let software determine
 */

int             e100_autopolarity = 2;

/* 
 * Number of consecutive transmit frames without the CU getting suspended or
 * going idle before generating an interrupt
 */

unsigned int    e100_batch_tx_frames = TX_FRAME_CNT;

/* 
 * ################### 82558 and 82559 feature set ##########################
 *
 * These should be enabled only for 82558 or later based (PRO/100+) boards .
 * These should be changed only by someone with an intimate knowledge
 * of the hardware of the system that the driver is loaded.
 */

/* e100_enhanced_tx_enable
 * 
 * Enable/Disable 82558 enhanced transmit features.
 * 0 - Disable
 * 1 - Enable
 */
int             e100_enhanced_tx_enable = 1;

/* 
 * e100_cna_backoff_enable
 * 
 * Enable/Disable delaying of CNA (Control Unit Not Active) Interrupts
 * 0 - Disable
 * 1 - Enable
 *
 * Note: This should be enabled only for an 82558 based adapter (PRO/100+).
 * If enabled, then the value of e100_current_CNA_backoff should be set to 
 * a value between 0 and 31.
 */

int             e100_cna_backoff_enable = 0;

/* e100_current_cna_backoff
 * 
 * Delay in assertion of CNA (Control Unit Not Active) Interrupts
 * 
 * Permitted values - 0 through 31
 *
 * Note: This should be enabled only for an 82558 based adapter (PRO/100+).
 * Larger values increase the delay in assertion of CNA interrupts and
 * possibly improve performance. 
 * If this is set to any value other than 0, make sure that 
 * e100_cna_backoff_enable is set to 1. 
 */

int             e100_current_cna_backoff = 0;   /* 0-31 only */

/* e100_max_rx
 * number of packets that are recieved in single isr */

int             e100_max_rx = 24;
/* 
 * ################## End of 82558 and 82559  feature set ###################
 */

/* Global Data structures and variables */
char  e100id_string[128] =  "e100 - Intel(R) PRO/100 Fast Ethernet Adapter, ";
char  e100_copyright[] =    "Copyright (c) 2001 Intel Corporation";

#define E100_VERSION  "1.6.22"
#define E100_FULL_DRIVER_NAME 	"Intel(R) PRO/100 Fast Ethernet Adapter - Loadable driver, ver "

const char *e100_version = E100_VERSION;
const char *e100_full_driver_name = E100_FULL_DRIVER_NAME E100_VERSION;
const char *e100_short_driver_name = "e100";

//PCI Vendor ID,PCI Device ID,PCI Sub Vendor ID,PCI Sub system ID,PCI Rev,Branding String,
e100_vendor_info_t e100_vendor_info_array[] = {  
  { 0x8086,0x1229,0x8086,0x0001,1,"Intel(R) PRO/100B PCI Adapter (TX)"},
  { 0x8086,0x1229,0x8086,0x0002,1,"Intel(R) PRO/100B PCI Adapter (T4)"},
  { 0x8086,0x1229,0x8086,0x0003,1,"Intel(R) PRO/10+ PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x0004,1,"Intel(R) PRO/100 WfM PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x0005,1,"Intel(R) 82557-based Integrated Ethernet PCI (10/100)"},
  { 0x8086,0x1229,0x8086,0x0006,1,"Intel(R) 82557-based Integrated Ethernet with Wake on LAN*"},
  { 0x8086,0x1229,0x8086,0x0002,2,"Intel(R) PRO/100B PCI Adapter (T4)"},
  { 0x8086,0x1229,0x8086,0x0003,2,"Intel(R) PRO/10+ PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x0004,2,"Intel(R) PRO/100 WfM PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x0005,2,"Intel(R) 82557-based Integrated Ethernet PCI (10/100)"},
  { 0x8086,0x1229,0x8086,0x0006,2,"Intel(R) 82557-based Integrated Ethernet with Wake on LAN*"},
  { 0x8086,0x1229,0x8086,0x0007,4,"Intel(R) 82558-based Integrated Ethernet"},
  { 0x8086,0x1229,0x8086,0x0008,4,"Intel(R) 82558-based Integrated Ethernet with Wake on LAN*"},
  { 0x8086,0x1229,0x8086,0x0009,5,"Intel(R) PRO/100+ PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x000A,5,"Intel(R) PRO/100+ Management Adapter"},
  { 0x8086,0x1229,0x8086,0x000A,5,"Intel(R) PRO/100+ Management Adapter"},
  { 0x8086,0x1229,0x8086,0x000B,8,"Intel(R) PRO/100+ Adapter"},
  { 0x8086,0x1229,0x8086,0x000C,8,"Intel(R) PRO/100+ Management Adapter"},
  { 0x8086,0x1229,0x8086,0x000D,8,"Intel(R) PRO/100+ Alert on LAN* 2 Management Adapter"},
  { 0x8086,0x1229,0x8086,0x000E,8,"Intel(R) PRO/100+ Alert on LAN* Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0010,9,"Intel(R) PRO/100 S Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0011,9,"Intel(R) PRO/100 S Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0012,9,"Intel(R) PRO/100 S Advanced Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0013,9,"Intel(R) PRO/100 S Advanced Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0030,8,"Intel(R) PRO/100+ Management Adapter with Alert On LAN* GC"},
  { 0x8086,0x1229,0x8086,0x0040,0xC,"Intel(R) PRO/100 S Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x0041,0xC,"Intel(R) PRO/100 S Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x0042,0xC,"Intel(R) PRO/100 Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x0050,0xD,"Intel(R) PRO/100 S Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x0070,0xF,"Intel(R) PRO/100 M Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x1009,4,"Intel(R) PRO/100+ Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1009,5,"Intel(R) PRO/100+ Server Adapter"},
  { 0x8086,0x1229,0x8086,0x100C,8,"Intel(R) PRO/100+ Server Adapter (PILA8470B)"},
  { 0x8086,0x1229,0x8086,0x1012,9,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1013,9,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1014,0xD,"Intel(R) PRO/100 Dual Port Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1015,0xD,"Intel(R) PRO/100 S Dual Port Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1016,0xD,"Intel(R) PRO/100 S Dual Port Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1017,8,"Intel(R) PRO/100+ Dual Port Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1030,8,"Intel(R) PRO/100+ Management Adapter with Alert On LAN* G Server"},
  { 0x8086,0x1229,0x8086,0x1040,0xC,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1041,0xC,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1042,0xC,"Intel(R) PRO/100 Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1050,0xD,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x10F0,4,"Intel(R) PRO/100+ Dual Port Server Adapter "}, 
  { 0x8086,0x1229,0x8086,0x10F0,5,"Intel(R) PRO/100+ Dual Port Server Adapter "}, 
  { 0x8086,0x1229,0x8086,0x2009,0xC,"Intel(R) PRO/100 S Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x200D,8,"Intel(R) PRO/100 CardBus II"},
  { 0x8086,0x1229,0x8086,0x200D,8,"Intel(R) PRO/100 CardBus II"},
  { 0x8086,0x1229,0x8086,0x200E,8,"Intel(R) PRO/100 LAN+Modem56 CardBus II"},
  { 0x8086,0x1229,0x8086,0x200E,8,"Intel(R) PRO/100 LAN+Modem56 CardBus II"},
  { 0x8086,0x1229,0x8086,0x200F,0xC,"Intel(R) PRO/100 SR Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2010,0xC,"Intel(R) PRO/100 S Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2013,0xC,"Intel(R) PRO/100 SR Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2016,0xD,"Intel(R) PRO/100 S Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2017,0xD,"Intel(R) PRO/100 S Combo Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2018,0xD,"Intel(R) PRO/100 SR Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2019,0xD,"Intel(R) PRO/100 SR Combo Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2101,0xC,"Intel(R) PRO/100 P Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2102,0xC,"Intel(R) PRO/100 SP Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2103,0xC,"Intel(R) PRO/100 SP Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2104,0xC,"Intel(R) PRO/100 SP Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2105,0xC,"Intel(R) PRO/100 SP Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2106,0xA,"Intel(R) PRO/100 P Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2107,0xA,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1229,0x8086,0x2108,0xC,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1229,0x8086,0x2200,0xC,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2201,0xC,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2202,0xC,"Intel(R) PRO/100 SP Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2203,CATCHALL,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x2204,CATCHALL,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x2205,0xC,"Intel(R) PRO/100 SP Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2206,0xC,"Intel(R) PRO/100 SP Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2207,0xC,"Intel(R) PRO/100 SP Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2208,0xC,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2408,9,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x240F,9,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x2411,9,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x3400,8,"Intel(R) 82559 Fast Ethernet LAN on Motherboard"},
  { 0x8086,0x1229,0x8086,0x3000,8,"Intel(R) 82559 Fast Ethernet LAN on Motherboard"},
  { 0x8086,0x1229,0x8086,0x3001,8,"Intel(R) 82559 Fast Ethernet LOM with Alert on LAN*"},
  { 0x8086,0x1229,0x8086,0x3002,8,"Intel(R) 82559 Fast Ethernet LOM with Alert on LAN* 2"},
  { 0x8086,0x1229,0x8086,0x3006,0xC,"Intel(R) PRO/100 S Network Connection"},
  { 0x8086,0x1229,0x8086,0x3007,0xC,"Intel(R) PRO/100 S Network Connection"},
  { 0x8086,0x1229,0x8086,0x3008,0xC,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1229,0x8086,0x3010,CATCHALL,"Intel(R) PRO/100 S Network Connection"},
  { 0x8086,0x1229,0x8086,0x3011,CATCHALL,"Intel(R) PRO/100 S Network Connection"},
  { 0x8086,0x1229,0x8086,0x3012,CATCHALL,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1229,0x1014,0x005C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x305C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x405C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x605C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x505C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x105C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x805C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x705C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x01F1,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x0232,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x0207,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01BC,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01CE,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01DC,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01EB,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01EC,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x0202,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x0205,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x0217,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x0E11,0xB01E,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB01F,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB02F,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB04A,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0C6,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0C7,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0D7,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0DD,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0DE,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0E1,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB134,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB13C,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB144,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB163,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB164,CATCHALL,"Compaq Fast Ethernet Server Adapter"},
  { 0x8086,0x2449,0x8086,0x3010,1,"Intel(R) PRO/100 VE Desktop Adapter"},
  { 0x8086,0x2449,0x8086,0x3010,3,"Intel(R) PRO/100 VE Desktop Adapter"},
  { 0x8086,0x2449,0x8086,0x3011,1,"Intel(R) PRO/100 VM Desktop Adapter"},
  { 0x8086,0x2449,0x8086,0x3011,3,"Intel(R) PRO/100 VM Desktop Adapter"},
  { 0x8086,0x2449,0x8086,0x3013,1,"Intel(R) PRO/100 VE Network ConnectionPLC LOM"},
  { 0x8086,0x2449,0x8086,0x3013,3,"Intel(R) PRO/100 VE Network Connection"},
  { 0x8086,0x2449,0x8086,0x3014,1,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x2449,0x8086,0x3014,3,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x2449,0x8086,0x3016,1,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x2449,0x8086,0x3016,3,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x2449,0x8086,0x3017,1,"Intel(R) PRO/100 P Mobile Adapter"},
  { 0x8086,0x2449,0x8086,0x3017,3,"Intel(R) PRO/100 P Mobile Adapter"},
  { 0x8086,0x2449,0x8086,0x3018,1,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x2449,0x8086,0x3018,3,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1031,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VE Network Connection"}, 
  { 0x8086,0x1032,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VE Network Connection"},
  { 0x8086,0x1033,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"}, 
  { 0x8086,0x1034,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"}, 
  { 0x8086,0x1038,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"},
  {CATCHALL, CATCHALL, CATCHALL, CATCHALL, CATCHALL, "Intel(R) 8255x-based Ethernet Adapter"},
  {0x0, 0x0, 0x0, 0x0, 0x0, NULL}  // This has to be the last entry
};



bd_config_t    *e100_first = NULL;
int             e100nics = 0;


/*********************************************************************/
/*! This is a GCC extension to ANSI C.
 *  See the item "Labeled Elements in Initializers" in the section
 *  "Extensions to the C Language Family" of the GCC documentation.
 *********************************************************************/

#define E100_OPTION_INIT { [0 ... MAX_NIC-1] = -1 }

/* Start Command Line Options */
/* 
 * Set the line speed and duplex mode of the controller.
 *  0 indicates autodetection for both speed and duplex mode
 *  1 indicates a speed of 10Mbps and a duplex mode of half 
 *  2 indicates a speed of 10Mbps and a duplex mode of full 
 *  3 indicates a speed of 100Mbps and a duplex mode of half 
 *  4 indicates a speed of 100Mbps and a duplex mode of full 
 *
 *    NOTE: The PRO/10+ can't autodetect so if the setting is left at
 *    0 the driver will force it to 10/HALF.  If full duplex is desired
 *    a setting of 2 is required.  Setting 3 and 4 are invalid for the
 *    PRO/10+ hardware.
 *
 * We support up to 16 nics with this structure.  If you need more, 
 * add new members to the structure.
 */
int e100_speed_duplex[MAX_NIC] = E100_OPTION_INIT;
int RxDescriptors[MAX_NIC] = E100_OPTION_INIT;
int TxDescriptors[MAX_NIC] = E100_OPTION_INIT; 
int XsumRX[MAX_NIC] =  E100_OPTION_INIT; 
int ucode[MAX_NIC] = E100_OPTION_INIT;
int TcoWA[MAX_NIC] = E100_OPTION_INIT;
int IntDelay[MAX_NIC] = E100_OPTION_INIT;
int BundleMax[MAX_NIC] = E100_OPTION_INIT;
int ber[MAX_NIC] = E100_OPTION_INIT;
int flow_control[MAX_NIC] = E100_OPTION_INIT;
int IFS[MAX_NIC] = E100_OPTION_INIT;

/* global (per driver) statistic */



/* ====================================================================== */

void e100_D102_check_checksum(bd_config_t *, struct sk_buff *);
static int e100_ioctl(device_t *dev, struct ifreq *ifr, int cmd);
static void e100_free_rfd_pool(bd_config_t *bddp);
static void e100_free_tbds(bd_config_t *bdp);



static int  e100_open (device_t *),
    e100_close (device_t *),
    e100_xmit_frame (struct sk_buff *, device_t *),
    e100init (bd_config_t *), e100_set_mac (device_t *, void *);

static struct net_device_stats *e100_get_stats (device_t *);

static void e100intr (int, void *, struct pt_regs *),
    e100_print_brd_conf (bd_config_t *),
        e100_set_multi (device_t *);

static char *e100_GetBrandingMesg (bd_config_t *);

static boolean_t e100_get_pci_info (pci_dev_t *, bd_config_t *);
static boolean_t e100_sw_init (bd_config_t *);

static boolean_t e100_alloc_space (pci_dev_t *, bd_config_t **);
static int e100_alloc_tcbs(bd_config_t *);


static void e100_dealloc_space (bd_config_t *),
    e100_setup_tcb_pool (ptcb_t, uint_t, bd_config_t *);

static sk_buff_t *e100_alloc_rfd_pool (bdd_t *);


/* EEPROM access functions */
static void e100_rd_eaddr (bd_config_t *),
        e100_rd_pwa_no(bd_config_t * bdp);

extern void WriteEEprom (bd_config_t *, uint16_t, uint16_t);
extern uint16_t ReadEEprom (bd_config_t *, uint16_t);
extern uint16_t  GetEEpromSize (bd_config_t *);
extern void UpdateChecksum (bd_config_t *);

/* Functions for accessing the adapter hardware */
static boolean_t e100_clr_cntrs (bd_config_t *),
    e100_load_microcode (bd_config_t *, uint8_t),
    e100_hw_init (bd_config_t *, uint32_t),
    e100_setup_iaaddr (bd_config_t *, e100_eaddr_t *);

static void e100_start_ru (bd_config_t *),
    e100_dis_intr (bd_config_t *),
    e100_enbl_intr (bd_config_t *),
    e100_trigger_SWI(bd_config_t * bdp),
    e100_dump_stats_cntrs (bd_config_t *);
static boolean_t e100_update_stats(bd_config_t *); 
void e100_check_options(int board, uint8_t rev_id);
void e100_set_int_option(int *option, int min, int max, int default_val, char *name);
void e100_set_bool_option(int *option, int default_val, char *name);


/* all inline func must be declared with body, here they're */

/* 
 * Procedure:   e100_alloc_skb
 *
 * Description: allocates skb with enough room for rfd, ans and data,
 *              and reserve non-data space
 * Arguments:
 *      bddp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      sk_buff_t * - the new sk_buff or NULL if we failed to allocate one.
 */

inline sk_buff_t *
e100_alloc_skb(bdd_t * bddp)
{
    sk_buff_t      *new_skb;

    new_skb = (sk_buff_t *) dev_alloc_skb(sizeof(rfd_t)
#ifdef IANS
        + BD_ANS_INFO_SIZE
#endif
					  + CSUM_559_SIZE + VLAN_SIZE);
    if (new_skb) {

#if (defined __ia64__)
        /* The IP data should be 
           DWORD aligned. since the ethernet header is 14 bytes long, 
           we need to reserve 2 extra bytes so that the TCP/IP headers
           will be DWORD aligned. */
        skb_reserve(new_skb, 2);
#endif  /* __ia64__ */


#ifdef IANS
        /* we need to allocate extra room for the ans stuff */
        bd_ans_os_ReserveSpaceForANS(new_skb);
#endif
        skb_reserve(new_skb, bddp->rfd_size);
        
        return new_skb;
    }
    
    return NULL;
}



/* 
 * Procedure:   e100_add_skb_to_end
 *
 * Description: Adds an skb to the end of our rfd list.
 *        
 * Arguments:
 *      bddp - Ptr to this card's e100_bdconfig structure
 *      skb_buff_t *new_skb - Ptr to the new skb
 *
 * Returns:
 *    -     NONE
 */


inline void
e100_add_skb_to_end(bdd_t * bddp, sk_buff_t * new_skb)
{
    rfd_t          *rfdn;      /* The new rfd */
    rfd_t          *rfdp;      /* The old rfd */
    bd_config_t * bdp = bddp->bdp;
   
    /* set who this is from */
    new_skb->dev = bdp->device;
    
    rfdn = RFD_POINTER(new_skb, bddp);
 
    /* init all fields in rfd */
    rfdn->rfd_header.cb_status = 0;
    rfdn->rfd_header.cb_cmd = __constant_cpu_to_le16(RFD_EL_BIT);
    rfdn->rfd_rbd_ptr = __constant_cpu_to_le32(E100_NULL);   /* not really necessary */
    rfdn->rfd_act_cnt = 0;
    rfdn->rfd_sz = cpu_to_le16(sizeof(eth_rx_buffer_t) + CSUM_559_SIZE + VLAN_SIZE);

    /* append new_skb to the end of the rx skb queue */
    rfdn->prev = bddp->rfd_tail;
    rfdn->next = NULL;
    rfdn->dma_addr =  pci_map_single(bdp->ppci_dev,rfdn,
				     sizeof(rfd_t),PCI_DMA_FROMDEVICE);
    
     pci_dma_sync_single(bdp->ppci_dev,rfdn->dma_addr,bddp->rfd_size,PCI_DMA_TODEVICE);

    if (bddp->rfd_tail != NULL) {
        rfdp = RFD_POINTER(bddp->rfd_tail, bddp);
        rfdp->next = new_skb;

        // sync up only the first dword of RFD
        pci_dma_sync_single(bdp->ppci_dev,rfdp->dma_addr,4 ,PCI_DMA_FROMDEVICE);
	
        //first write the link pointer
	rfdp->rfd_header.cb_lnk_ptr = cpu_to_le32(rfdn->dma_addr);
        pci_dma_sync_single(bdp->ppci_dev,rfdp->dma_addr,8,PCI_DMA_TODEVICE);
        
        // next clear the EL bit on the previous rfd 
        rfdp->rfd_header.cb_cmd &= __constant_cpu_to_le16((uint16_t) ~RFD_EL_BIT);
	pci_dma_sync_single(bdp->ppci_dev,rfdp->dma_addr,4,PCI_DMA_TODEVICE);

    }
    bddp->rfd_tail = new_skb;      /* reset the tail pointer */
    if (bddp->rfd_head == NULL) 
        bddp->rfd_head = new_skb;

    return;
}



/* 
 * Procedure:   e100_wait_exec_cmd
 *
 * Description: This general routine will issue a command to the e100.
 *      bdp -          Ptr to this card's e100_bdconfig structure
 *      scb_cmd_low - The command that is to be issued.
 * Returns:
 *      B_TRUE if the command was issued to the chip successfully
 *      B_FALSE if the command was not issued to the chip
 */
inline boolean_t
e100_wait_exec_cmd(bd_config_t * bdp, uint8_t scb_cmd_low)
{
    bdd_t          *bddp;      /* stores all adapter specific info */
    bddp = (pbdd_t) bdp->bddp;   /* get the bddp for this board */

    if (e100_wait_scb(bdp) != B_TRUE) {
            printk(KERN_ERR "%s e100_wait_exec_cmd: Wait failed.\n",bdp->device->name);
            return (B_FALSE);
    }
    
    e100_exec_cmd(bdp, scb_cmd_low);
    return (B_TRUE);

}


//void e100_tx_queued_frames (bd_config_t *);
void e100_tx_srv (bd_config_t *);
void e100_rx_srv (bd_config_t *);
void e100_watchdog (device_t *);
void e100_refresh_txthld (bd_config_t *);
void e100_manage_adaptive_ifs(bd_config_t *);
void e100_clear_structs(device_t *, bd_config_t *);

static ptcb_t e100_prepare_xmit_buff (bd_config_t *, sk_buff_t *),
    e100_prepare_ext_xmit_buff (bd_config_t *, sk_buff_t *);

/* Functions for accessing the physical layer (PHY) hardware */
static boolean_t e100_SetupPhy (bd_config_t *),
    e100_PhyLinkState (bd_config_t *),
    e100_phydetect (bd_config_t *);

void e100_FindPhySpeedAndDpx (bd_config_t *, uint_t);
void e100_ForceSpeedAndDuplex (bd_config_t *);
void e100_auto_neg (bd_config_t *);
void e100_fix_polarity (bd_config_t * bdp);
void e100_ResetPhy (bd_config_t *);
void e100_MdiWrite (bd_config_t *, uint32_t, uint32_t, uint16_t);
void e100_MdiRead (bd_config_t *, uint32_t, uint32_t, uint16_t *);
void e100_phy_check (bd_config_t *);

static void e100_handle_zero_lock_state(bd_config_t * bdp);

static void e100_set_multi_exec(device_t * dev);

static void e100_tx_notify_stop(bd_config_t *bdp);



static void e100_tx_notify_stop(bd_config_t *bdp){
#ifdef IANS
        if (ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) {
            if (ans_notify)
                ans_notify(bdp->device, IANS_IND_XMIT_QUEUE_FULL);
        }
#endif
        netif_stop_queue(bdp->device);
       

}

 void e100_tx_notify_start(bd_config_t *bdp){

        if (netif_queue_stopped(bdp->device) &&
            (bdp)->flags & DF_OPENED) {
#ifdef IANS
                if (ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP)   {
                        if (ans_notify)
                                ans_notify(bdp->device, IANS_IND_XMIT_QUEUE_READY);
                }
                
#endif
                netif_wake_queue(bdp->device);
        }
}



#ifdef MODULE
/* Exported symbols */
/* vars */
EXPORT_SYMBOL(e100_speed_duplex);
EXPORT_SYMBOL(e100_first);
EXPORT_SYMBOL(e100nics);
#endif


/***************************************************************************/
/***************************************************************************/
/*     Module Install/Uninstall Stuff                                      */
/***************************************************************************/

static int e100_found1(struct pci_dev *pcid, const struct pci_device_id *ent);

/****************************************************************************
 * Name:        e100_probe1
 *
 * Description: This routine is called when the dynamic driver module
 *              "e100" is loaded using the command "insmod".
 *              It calls the initialization routine e100init.
 *
 *               This is a Linux required routine.
 *
 * Born on Date:    07/11/99
 *
 * Arguments: dev *   
 *
 * Returns: number of boards
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
static int
e100_probe1(void)
{
    pci_dev_t      *pcid = NULL;
    
    if (!pci_present()) {
        return 0;
    }
    
    /* loop through all of the ethernet PCI devices looking for ours.
     * if we encounter device that we can't "pick up" we pass to the next,
     * while after memory error we stop looking further for NICs */
    while ((pcid = pci_find_class(PCI_CLASS_NETWORK_ETHERNET << 8, pcid))) {
        if ((pcid->vendor != 0x8086) ||
            ((pcid->device != 0x1229) &&
             (pcid->device != 0x1029) &&
             (pcid->device != 0x1209) &&
             (pcid->device != 0x2449) &&
             !((pcid->device > 0x1030) && (pcid->device < 0x1039)))) {
            continue;
        }
        
        if (e100_found1(pcid, NULL)) {
            continue;
        }
        
        if (e100nics == MAX_NIC) {
            printk(KERN_NOTICE "e100: found %d NICs, stop searching further\n", MAX_NIC);
            break;
        }
    }
    
    return e100nics;
}
#endif

static int 
e100_found1(struct pci_dev *pcid, const struct pci_device_id *ent)
{
    static int	 first_time = B_TRUE;
    device_t    *dev = NULL;
    bd_config_t *bdp = NULL;
    bdd_t       *bddp;
    static int   e100_ohio_flag = 0;   /* will be set if ohio found */
    
    /* first check if the max number of supported NICs was already found */
    if (e100nics == MAX_NIC) {
        printk(KERN_NOTICE "e100: found %d NICs, stop searching further\n", MAX_NIC);
        return -ENODEV;
    }
    
    dev = init_etherdev(dev, 0);
    
    if (dev == NULL) {
        printk(KERN_ERR "Not able to alloc etherdev struct\n");
        return -ENODEV;
    }
    
    if (first_time == B_TRUE) {
        /* print out the version */
        first_time = B_FALSE;
        printk(KERN_NOTICE "%s\n", e100_full_driver_name);
        printk(KERN_NOTICE "%s\n", e100_copyright);
    }
    
    /* Allocate all the memory that the driver will need */
    /* Tx and Rx descriptors will be allocated later in this function */
    if (!e100_alloc_space(pcid, &bdp)) {
        printk(KERN_ERR "%s - Failed to allocate memory\n", e100_short_driver_name);
        e100_clear_structs(dev, bdp);
        return -ENOMEM;
    }
    
    /* link the device and the bdp */
    bdp->device = dev;
    dev->priv = bdp;
    
    bdp->flags  = 0;
    bddp = bdp->bddp;
    bdp->ppci_dev = pcid;
    
    /* zero out fields - just in case */
    bdp->ifs_state = 0;
    bdp->ifs_value = 0;
    bdp->io_start = 0;
    bddp->scbp = 0;
    
    
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
    if (pci_enable_device(pcid)) {
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    
    pcid->driver_data = dev;
#endif
    
    /* Obtain the PCI specific information about the driver. */
    if (e100_get_pci_info(pcid, bdp) == B_FALSE) {
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    
    if (check_region(bdp->io_start, 32)) { /* card is taken */
        printk(KERN_ERR "%s - Failed to find PCI device\n", e100_short_driver_name);
        bdp->io_start = 0;  /* so we'll know not to release the region */
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    request_region(bdp->io_start, 32, e100_short_driver_name);
    
    /* Decide whether to load or not based on the * sub-device ID file.
     * This also sets the id string. */
    if (!e100_GetBrandingMesg(bdp)) {
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    /* init the timer */
    bdp->timer_val = -1;
    
    /* save off the needed information */
    dev->base_addr = bdp->mem_start;   /* set in e100_get_pci_info */
    dev->irq = pcid->irq;
    
    if ( ((bdp->ppci_dev->device > 0x1030) && (bdp->ppci_dev->device < 0x1039)) ||
         bdp->ppci_dev->device == 0x2449) {
        bdp->rev_id = 0xff; /* workaround for ICH3 */ 
    }
    
    /* set up other board info based on PCI info */
    if (bdp->rev_id == 0xff)
        bdp->rev_id = 1; 
    /* If rev_id is invalid, treat this 
                           * as a 82557 */
    
    if ((uint8_t) bdp->rev_id >= D101A4_REV_ID)
        bddp->flags |= IS_BACHELOR;
    
    if((uint8_t) bdp->rev_id >= D102_REV_ID) {
        bddp->flags |= USE_IPCB;
        bddp->rfd_size = 32;
    } else {
        bddp->rfd_size = 16;
    }
    
    if ( (bdp->ppci_dev->device == 0x2449) || 
	 ((bdp->ppci_dev->device > 0x1030) && (bdp->ppci_dev->device < 0x1039)) )  
        bddp->flags |= IS_ICH;
    
    /* Identify Ohio's Port number */
    if (bdp->sub_dev_id == PCI_OHIO_BOARD) {
        /* identify Port 1 or Port 2 based on static ohio flag */
        if (!e100_ohio_flag) {
            strcat(e100id_string, " (Port 1)");
            e100_ohio_flag = 1; /* so that the next 
                                 * port shows as port 2 */
        } else {
            strcat(e100id_string, " (Port 2)");
            e100_ohio_flag = 0;   /* in case there is > 1 
                                   * ohio board */
        }
    }
    
    printk(KERN_NOTICE "\n");
    printk(KERN_NOTICE "%s: %s\n", bdp->device->name, e100id_string);
    e100_check_options(e100nics,bdp->rev_id);
    /* init all the data structure and find the rest of the pci info */
    if (!e100init(bdp)) {
        printk(KERN_ERR "Failed to initialize e100, instance #%d\n", e100nics);
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    
    if (create_e100_proc_subdir(bdp) < 0) {
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }

    /* Printout the board configuration */
    e100_print_brd_conf(bdp);
    
    /* assign driver methods */
    dev->open = &e100_open;
    dev->hard_start_xmit = &e100_xmit_frame;
    dev->stop = &e100_close;
    dev->get_stats = &e100_get_stats;
    dev->set_multicast_list = &e100_set_multi;
    dev->set_mac_address = &e100_set_mac;
    dev->do_ioctl = &e100_ioctl;
    e100nics++;

#ifdef STB_WA
    if(bdp->rev_id >= D101MA_REV_ID)
    {
                __u16 id_reg;
                id_reg = ReadEEprom(bdp, EEPROM_ID_WORD);
                
                if(id_reg & (0x02)){ 
                        
                        id_reg &=  ( (__u16)(~0x02) );
                        
                        WriteEEprom(bdp, EEPROM_ID_WORD, id_reg);

                        UpdateChecksum(bdp);
                        printk("%s Changed the eeprom values\n",dev->name);
                        printk("for sane operation, a reboot is required\n");
                }
        }
#endif /* STB_WA */

   

    return 0;
}

/****************************************************************************
 * Name:        e100_clear_structs
 *
 * Description: free all device specific structs, unregister the device,
 *                   unmap i/o address, etc.
 *
 *             
 * Born on Date:    03/18/01
 *
 * Arguments: dev * - a pointer to the device
 *                  bdp * - a pointer to the bd_config struct associated with the device
 *
 *                  Both these parameters are needed, because this function might be called
 *                  before the 'dev' and the 'bdp' were linked to each other.
 *
 * Returns: none
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
void
e100_clear_structs(device_t *dev, bd_config_t *bdp)
{
    bdd_t       *bddp;
    
    if (!dev) {
        return;
    }
    
    unregister_netdev(dev);
    
    if (!bdp) {
        kfree(dev);
        return;
    }
    
    bddp = bdp->bddp;
    
    if (bddp) {
        if (bddp->scbp) {
            iounmap(bddp->scbp);
        }
    }
    
    if (bdp->io_start) {
        release_region(bdp->io_start, 32);
    }
    
    e100_dealloc_space(bdp);
    kfree(dev);
}

MODULE_AUTHOR("Intel Corporation, <linux.nics@intel.com>");
MODULE_DESCRIPTION(E100_FULL_DRIVER_NAME E100_VERSION);
MODULE_PARM(TxDescriptors, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(RxDescriptors, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(XsumRX, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(e100_speed_duplex, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(ucode, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(ber, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(flow_control, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(TcoWA, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(IntDelay, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(BundleMax, "1-"  __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(IFS, "1-"  __MODULE_STRING(MAX_NIC) "i");



#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)

/* Set some of the modules specific things here */
#ifdef MODULE
/****************************************************************************
 * Name:        init_module
 *
 * Description: This routine is an entry point into the driver.
 *
 *               This is a Linux required routine.
 *
 * Born on Date:    07/11/99
 *
 * Arguments:   
 *       NONE
 *
 * Returns:
 *        It returns 0 if at least 1 nic was found and initialized
 *         else it returns -ENODEV.
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
int
init_module(void)
{
    return  e100_probe1() ? 0 : -ENODEV;
}

/****************************************************************************
 * Name:        cleanup_module
 *
 * Description: This routine is an entry point into the driver.
 *
 *               This is a Linux required routine.
 *
 * Born on Date:    07/11/99
 *
 * Arguments:   
 *       NONE
 *
 * Returns:
 *        It returns 0  and can not fail
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
int
cleanup_module(void)
{
    bd_config_t    *bdp,
        *next_bdp;
    device_t       *dev,
        *next_dev;
    bdd_t          *bddp;

    /* start looking at the first device */
    if (!e100_first) return 0;
    
    dev = e100_first->device;
    while (dev) {
        bdp = (bd_config_t *) dev->priv;
        bddp = bdp->bddp;
        next_bdp = bdp->bd_next;
        next_dev =  (next_bdp) ? next_bdp->device : NULL;
        
        e100_proc_remove_one(dev);
        
        e100_ResetPhy(bdp);
        e100_sw_reset(bdp, PORT_SOFTWARE_RESET);

        e100_clear_structs(dev, bdp);

        dev = next_dev;
    }
    
    return 0;
}

#else /* MODULE */

static int
e100_probe(void)
{
    return  e100_probe1() ? 0 : -ENODEV;    
}
#endif /* MODULE */

#else /* LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0) */

static void __devexit e100_remove1(struct pci_dev *pcid)
{
    bd_config_t    *bdp;
    bdd_t          *bddp;
    device_t       *dev = pcid->driver_data;
    
    bdp = (bd_config_t *) dev->priv;
    bddp = bdp->bddp;

    e100_proc_remove_one(dev);
    
    e100_ResetPhy(bdp);
    e100_sw_reset(bdp, PORT_SOFTWARE_RESET);
    
    e100_clear_structs(dev, bdp);
    
    --e100nics;
}

static struct pci_device_id e100_id_table[] __devinitdata = {
	{ 0x8086, 0x1029, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1031, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1032, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1033, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1034, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1038, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1209, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1229, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x2449, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0, }
};
MODULE_DEVICE_TABLE(pci, e100_id_table);
	
static struct pci_driver e100_driver = {
        name:		"e100",
        id_table:	e100_id_table,
        probe:		e100_found1,
        remove:		e100_remove1,
	suspend:	NULL,
        resume:		NULL
};

static int __init e100_init_module(void)
{
    return pci_module_init(&e100_driver);
}

static void __exit e100_cleanup_module(void)
{
    pci_unregister_driver(&e100_driver);
}

module_init(e100_init_module);
module_exit(e100_cleanup_module);
#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0) */


/****************************************************************************
 * Name:          e100_check_options
 *
 * Description:   This routine does range checking on command-line options
 *
 * Born on Data:  05/02/2000
 *
 * Arguments:     int board
 *				  uint8_t rev_id  - Revision ID of the board
 *
 * Returns:       void  (cannot fail)
 *
 ***************************************************************************/
void
e100_check_options(int board, uint8_t rev_id)
{
    e100_set_int_option(&TxDescriptors[board], E100_MIN_TCB, E100_MAX_TCB,
                        E100_DEFAULT_TCB, "TxDescriptor count");
    
    e100_set_int_option(&RxDescriptors[board], E100_MIN_RFD, E100_MAX_RFD,
                        E100_DEFAULT_RFD, "RxDescriptor count");
    
    e100_set_int_option(&e100_speed_duplex[board], 0, 4,
                        E100_DEFAULT_SPEED_DUPLEX, "speed/duplex mode");
    
    e100_set_int_option(&ber[board], 0, ZLOCK_MAX_ERRORS,
                        E100_DEFAULT_BER, "Bit Error Rate count");

    e100_set_bool_option(&XsumRX[board], E100_DEFAULT_XSUM, "XsumRX value");
    
    e100_set_bool_option(&ucode[board], E100_DEFAULT_UCODE, "ucode value");

    e100_set_bool_option(&flow_control[board], E100_DEFAULT_FC, "flow control value");

    e100_set_bool_option(&IFS[board], E100_DEFAULT_IFS, "IFS value");

    e100_set_bool_option(&TcoWA[board], E100_DEFAULT_TCO_WA,
                         "TCO work around for 82550B value");

    e100_set_int_option(&IntDelay[board], 0x0, 0xFFFF, E100_DEFAULT_CPUSAVER_INTERRUPT_DELAY,
                        "CPU saver interrupt delay value");

    e100_set_int_option(&BundleMax[board], 0x1, 0xFFFF,	E100_DEFAULT_CPUSAVER_BUNDLE_MAX,
                        "CPU saver bundle max value");

    /* In 82550B adapters the TCO work around and the CPU Saver are mutualy exclusive.
     * If both the TCO work around and CPU Saver are set,
     * the adapter will load only the TCO work around uCode. */
    if ( (rev_id == D102_REV_ID) && (IntDelay[board] > 0) && (TcoWA[board] == TRUE) ) {
        printk(KERN_NOTICE "52550B: 'TCO work around' override the CPU saver feature.");
    }
}

/****************************************************************************
 * Name:          e100_set_int_option
 *
 * Description:   This routine does range checking on a command-line option.
 *                      If the option's value is '-1' use the specified default.
 *                      Otherwise, if the value is invalid, change it to the default.
 *
 * Arguments:     int *option - a pointer to the relevant option field
 *                      int min - the minimum valid value
 *                      int max - the maximum valid value
 *                      int default_val - the default value
 *                      char *name - the name of the option
 *
 * Returns:       void  (cannot fail)
 *
 ***************************************************************************/
void
e100_set_int_option(int *option, int min, int max, int default_val, char *name)
{
    if (*option == -1) {  /* no value specified. use default */
        *option = default_val;
        
    } else if ( (*option < min) || (*option > max) ) {
        printk(KERN_NOTICE "Invalid %s specified (%i). Valid range is %i-%i.\n",
               name, *option, min, max);
        printk(KERN_NOTICE "Using default %s of %i.\n", name, default_val);
        
        *option = default_val;
        
    } else {
        printk(KERN_INFO "Using specified %s of %i.\n", name, *option);
    }
}

/****************************************************************************
 * Name:          e100_set_bool_option
 *
 * Description:   This routine checks a boolean command-line option.
 *                      If the option's value is '-1' use the specified default.
 *                      Otherwise, if the value is invalid (not 0 or 1), change it to the default.
 *
 * Arguments:     int *option - a pointer to the relevant option field
 *                      int default_val - the default value
 *                      char *name - the name of the option
 *
 * Returns:       void  (cannot fail)
 *
 ***************************************************************************/
void
e100_set_bool_option(int *option, int default_val, char *name)
{
    if (*option == -1) {  /* no value specified. use default */
        *option = default_val;
        
    } else if ( (*option != TRUE) && (*option != FALSE) ) {
        printk(KERN_NOTICE "Invalid %s specified (%i). Valid values are %i/%i.\n",
               name, *option, FALSE, TRUE);
        printk(KERN_NOTICE "Using default %s of %i.\n", name, default_val);
        
        *option = default_val;
        
    } else {
	printk(KERN_INFO "Using specified %s of %i.\n", name, *option);
    }
}


/***************************************************************************/
/***************************************************************************/
/*       Driver Methods (i.e. procvars at device_t                    */
/***************************************************************************/


/****************************************************************************
 * Name:        e100_open
 *
 * Description: This routine is the open call for the interface.
 *
 *               This is a Linux required routine.
 *
 * Born on Date:    07/11/99
 *
 * Arguments:    dev *
 *
 * Returns:
 *        It returns 0 on success 
 *         -EAGAIN on failure
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static int
e100_open(device_t * dev)
{
    bd_config_t    *bdp;
    bdd_t          *bddp;
    pbuf_pool_t     ptcb_pool;

    bdp = dev->priv;
    bddp = bdp->bddp;



    
    if (bdp->flags & DF_OPENED) {



      return -EBUSY;
    }

 
    /* setup the tcb pool */    
    if (!e100_alloc_tcbs(bdp)) {
        e100_free_tbds(bdp);

        return -ENOMEM;
    }
    bddp->last_tcbp = NULL;

    ptcb_pool = &bddp->tcb_pool;
    ptcb_pool->head = 0;
    ptcb_pool->tail = 2;
    e100_setup_tcb_pool((ptcb_t) ptcb_pool->data,
        TxDescriptors[bdp->bd_number], bdp);

    /* Arrange dynamic RFD's in a circular queue & setup buffer pool */
    if (e100_alloc_rfd_pool(bddp) == NULL) {

        e100_free_rfd_pool(bdp);
        e100_free_tbds(bdp );

        return -ENOMEM;
    }

    
    /* We have to reload CU and RU base because they could have been
       corrupted from a TCO packet */
    /* Load the CU BASE (set to 0, because we use linear mode) */
    
    writel(0,&bddp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_CUC_LOAD_BASE);

    /* Wait for the SCB command word to clear before we set the * general
     * pointer */
    if (e100_wait_scb(bdp) != B_TRUE){
      
        e100_free_rfd_pool(bdp);
        e100_free_tbds(bdp);

        return -EAGAIN;
    }

    /* Load the RU BASE (set to 0, because we use linear mode) */
    writel(0,&bddp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_RUC_LOAD_BASE);
    

#ifdef MODULE
    /* up the mod use count used by the system */
    MOD_INC_USE_COUNT;
#endif  /* MODULE */

    /* launch the watchdog timer */

    init_timer(&bdp->timer_id);
	bdp->timer_id.expires = bdp->timer_val = jiffies + (2 * HZ);
	bdp->timer_id.data = (ulong_t) dev;
	bdp->timer_id.function = (void *) &e100_watchdog;
	add_timer(&bdp->timer_id);

	

    netif_start_queue(dev);

    e100_start_ru(bdp);
   if (request_irq(dev->irq, &e100intr, SA_SHIRQ, e100_short_driver_name, dev)) {
        e100_free_rfd_pool(bdp);
        e100_free_tbds(bdp);
        del_timer(&bdp->timer_id);

        return -EAGAIN;
    }

    e100_enbl_intr(bdp);

    bdp->flags |= DF_OPENED;



    return 0;
}

/****************************************************************************
 * Name:        e100_close
 *
 * Description: This routine is an entry point into the driver.
 *
 *               This is a Linux required routine.
 *
 * Born on Date:    07/11/99
 *
 * Arguments:   
 *         device_t pointer
 *
 * Returns:
 *        It returns 0 and can not fail.
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/

static int
e100_close(device_t * dev)
{
        bd_config_t    *bdp;
        bdd_t          *bddp;

        bdp = dev->priv;
        bddp = bdp->bddp;

        e100_isolate_driver(bdp);

        /* we don't want to receive more interrupts */
        free_irq(dev->irq, dev);
	bdp->bddp->last_tcbp = NULL;

        /* free tx and rx memory structures */
        e100_free_tbds(bdp);
        e100_free_rfd_pool(bdp);

#ifdef MODULE
        MOD_DEC_USE_COUNT;
#endif /* MODULE */
        bdp->flags &= ~DF_OPENED;

        e100_deisolate_driver(bdp,B_FALSE);

    

        return (0);
}


/****************************************************************************
 * Name:        e100_xmit_frame
 *
 * Description: This routine is called to transmit a frame.
 *
 *
 * Born on Date:    07/11/99
 *
 * Arguments:   
 *         sb_buff   pointer
 *         device_t pointer
 *
 * Returns:
 *        1 on failure
 *        0 on success
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static int
e100_xmit_frame(sk_buff_t * skb, device_t * dev)
{
    bd_config_t    *bdp = dev->priv;
    bdd_t          *bddp = bdp->bddp;
    net_device_stats_t *stats = &(bddp->net_stats);

    // check if a non-cu is currently running
    if (!spin_trylock(&bdp->bd_tx_lock)){
            e100_tx_notify_stop(bdp);
            return 1;
    }

    
    /* if there are no tcbs, tell stack to stop sending frames to us for now */
    if (!TCBS_AVAIL(&(bddp->tcb_pool))) {
            e100_tx_notify_stop(bdp);
            spin_unlock(&bdp->bd_tx_lock);
            return 1;
    }
        
        
    if (bddp->flags & USE_IPCB) 
        e100_prepare_xmit_buff(bdp, skb);
    else if ((bddp->flags & IS_BACHELOR) && (e100_enhanced_tx_enable))
        e100_prepare_ext_xmit_buff(bdp, skb);
    else
        e100_prepare_xmit_buff(bdp, skb);
    stats->tx_bytes += skb->len;

    
    dev->trans_start = jiffies;
    spin_unlock(&bdp->bd_tx_lock);
	
    return 0;
}


/****************************************************************************
 * Name:        e100_get_stats
 *
 * Description: This routine is called when the OS wants the nic stats returned
 *
 * Arguments:   
 *        device_t dev         - the device stucture to return stats on
 *
 * Returns:
 *         the address of the net_device_stats stucture for the device
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static struct net_device_stats *
e100_get_stats(device_t * dev)
{
    bd_config_t    *bdp = dev->priv;
    bdd_t          *bddp = bdp->bddp;
    err_stats_t    *bd_stats = bddp->perr_stats;

    struct net_device_stats *stats = &(bddp->net_stats);

    /* copy over from out stats struct into the Linux one */
    /* rx_bytes is updated in e100_rx_srv */
    stats->rx_packets = bd_stats->gd_recvs;
    /* tx_bytes is updated in e100_xmit_frame */
    stats->tx_packets = bd_stats->gd_xmits;
    /* add up all the bad recv counters for total number of recv errors */
    stats->rx_errors = bd_stats->rcv_crc_err + bd_stats->rcv_align_err +
        bd_stats->rcv_runts + bd_stats->rcv_cdt_frames;

    /* add up all the tx errors for the total number of tx frames dropped */
    stats->tx_errors         = bd_stats->tx_lost_csrs + bd_stats->tx_abrt_xs_col;
    stats->rx_dropped        = bd_stats->rcv_rsrc_err;
    stats->collisions        = bd_stats->tx_tot_retries;
    stats->rx_length_errors  = bd_stats->rcv_runts;
    stats->rx_over_errors    = bd_stats->rcv_rsrc_err;
    stats->rx_crc_errors     = bd_stats->rcv_crc_err;
    stats->rx_frame_errors   = bd_stats->rcv_align_err;
    stats->rx_fifo_errors    = bd_stats->rcv_dma_orun;
    stats->tx_aborted_errors = bd_stats->tx_abrt_xs_col;
    stats->tx_carrier_errors = bd_stats->tx_lost_csrs;
    stats->tx_fifo_errors    = bd_stats->tx_dma_urun;

    return (stats);
}


/****************************************************************************
 * Name:        e100_set_mac
 *
 * Description: This routine sets the ethernet address of the board
 *
 * Born on Date:    07/11/99
 *
 * Arguments:   
 *        dev    - Ptr to the dev structure for this card
 *      addr   - Ptr to the new ethernet address
 *
 * Returns:
 *      0  - If successful
 *      -1 - If not successful
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static int
e100_set_mac(device_t * dev, void *addr)
{

  bd_config_t    *bdp;
  e100_eaddr_t   *eaddrp;
  struct sockaddr *p_sockaddr = (struct sockaddr *) addr;

  bdp = dev->priv;


  eaddrp = (e100_eaddr_t *) p_sockaddr->sa_data;
  if(e100_setup_iaaddr(bdp, eaddrp) == B_TRUE ){
    memcpy(&(dev->dev_addr), eaddrp, ETHERNET_ADDRESS_LENGTH);

   return 0;
  }
  return  -1;
    
}

/*****************************************************************************
 * Name:        e100_set_multi_exec
 *
 * Description:
 *
 * Born on Date:   
 *
 * Arguments:
 *            dev - device structure
 *
 * Returns:
 *      (none)
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  --------------------------------------------------------
 *
 *****************************************************************************/
static void
e100_set_multi_exec(device_t * dev)
{
    bd_config_t        *bdp = dev->priv;
    bdd_t              *bddp = bdp->bddp;
    mltcst_cb_t        *mcast_buff;
    cb_header_t        *cb_hdr;
    struct dev_mc_list *mc_list;
    int                 timeout;
    uint_t              i;
    unsigned long	lock_flag;

    mcast_buff = &(bddp->pntcb->ntcb.multicast);
    cb_hdr = &(bddp->pntcb->ntcb.multicast.mc_cbhdr);

    /* initialize the multi cast command */
    cb_hdr->cb_status = 0;
    cb_hdr->cb_cmd = __constant_cpu_to_le16(CB_MULTICAST);
    cb_hdr->cb_lnk_ptr = 0;

    /* now fill in the rest of the multicast command */
    *(uint16_t *)(&(mcast_buff->mc_count)) = cpu_to_le16(dev->mc_count*6);
    for (i = 0, mc_list = dev->mc_list;
         (i < dev->mc_count) && (i < MAX_MULTICAST_ADDRS);
         i++, mc_list = mc_list->next) {
        /* copy into the command */
        memcpy(&(mcast_buff->mc_addr[i * ETHERNET_ADDRESS_LENGTH]),
            (uint8_t *) & (mc_list->dmi_addr), ETHERNET_ADDRESS_LENGTH);
    }

    timeout = 1000*500;

    /* wait for the last tcb to complete transmition */  
    if (bdp->bddp->last_tcbp) {
        E100_WAIT_FOR_CONDITION(timeout,
                                (bdp->bddp->last_tcbp->tcb_hdr.cb_status & 
                                 __constant_cpu_to_le16(CB_STATUS_COMPLETE)));
    }
    E100_WAIT_FOR_CONDITION(timeout,
                            ((readb(&bddp->scbp->scb_status) & SCB_CUS_MASK) != SCB_CUS_ACTIVE));

    if(timeout <= 0){
            printk(KERN_WARNING "%s: Multicast setup failed\n",dev->name);
            return;  
    }

     spin_lock_irqsave(&(bdp->bd_lock), lock_flag);    
    /* Wait for the SCB command word to clear before we set the * general
     * pointer */
    if (e100_wait_scb(bdp) != B_TRUE) {
        spin_unlock_irqrestore(&bdp->bd_lock, lock_flag);
        printk(KERN_WARNING "%s: Multicast setup failed\n",dev->name);
        return;
    }
       
    /* Update the command list pointer.  */
    writel(bddp->nontx_paddr,&bddp->scbp->scb_gen_ptr);
    e100_exec_non_cu_cmd(bdp);
    bddp->next_cu_cmd = START_WAIT;

    spin_unlock_irqrestore(&bdp->bd_lock, lock_flag);

    if (!e100_poll_cmd(bdp)) {
            printk(KERN_WARNING "%s: Multicast setup failed\n",dev->name);
    }
    return;

}


/*****************************************************************************
 * Name:        e100_set_multi
 *
 * Description: this routine is called to add multicast addresses
 *
 * Born on Date:    1/5/00
 *
 * Arguments:
 *            dev - device structure
 *
 * Returns:
 *      (none)
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  --------------------------------------------------------
 *
 *****************************************************************************/
static void
e100_set_multi(device_t * dev)
{
    bd_config_t    *bdp = dev->priv;
    uint8_t         rx_mode;
    boolean_t       promisc_enbl;
    boolean_t       mulcast_enbl;


    promisc_enbl = (dev->flags & IFF_PROMISC) ? B_TRUE : B_FALSE;
    mulcast_enbl = ((dev->flags & IFF_ALLMULTI) ||
                    (dev->mc_count > MAX_MULTICAST_ADDRS)) ? B_TRUE : B_FALSE;

    if (promisc_enbl == B_TRUE)       rx_mode = 3;
    else if (mulcast_enbl == B_TRUE)  rx_mode = 1;
    else                              rx_mode = 0;

    e100_config_promisc(bdp, promisc_enbl);
    e100_config_mulcast_enbl(bdp, mulcast_enbl);

    /* if rx mode has changed - reconfigure the chip */
    if (bdp->prev_rx_mode != rx_mode) {
        bdp->prev_rx_mode = rx_mode;
        e100_config(bdp);
    }

    if ((promisc_enbl == B_TRUE) || (mulcast_enbl == B_TRUE)){

        return;               /* no need for Multicast Cmd */
    }
    /* get the multicast CB */
    spin_lock_bh(&(bdp->bd_tx_lock));

    e100_set_multi_exec(dev);

    spin_unlock_bh(&(bdp->bd_tx_lock));
    e100_tx_notify_start(bdp);


    return;

}



/****************************************************************************
 * Name:    e100_ioctl
 *
 * Description: Driver's ioctl method
 *
 * Arguments: 
 *        
 * Returns: 0 - on success, negative value on failure
 ****************************************************************************/
static int
e100_ioctl(device_t *dev, struct ifreq *ifr, int cmd)
{
#ifdef IANS
    /* get the private data structure from the dev struct */
    BOARD_PRIVATE_STRUCT *bps = dev->priv;
    IANS_BD_PARAM_HEADER *header =  (IANS_BD_PARAM_HEADER *)ifr->ifr_data;
    iANSsupport_t *iANSdata = ANS_PRIVATE_DATA_FIELD(bps);
    BD_ANS_STATUS status;
#endif
    
    /* switch on the command */
    switch(cmd) {
#ifdef IANS     
    case IANS_BASE_SIOC:
        status = bd_ans_ProcessRequest(bps, iANSdata, header);
        if (status == BD_ANS_SUCCESS)
            return 0;
        /* some problem occured, return error value */
        return -EAGAIN;
#endif
    default:
        return -EOPNOTSUPP;
    }
    return 0;

}


/***************************************************************************/
/***************************************************************************/
/*       Initialization Routines                                           */
/***************************************************************************/


/****************************************************************************
 * Name:        e100init
 *
 * Description: This routine is called when this driver is loaded. This is
 *        the initialization routine which allocates memory
 *        configures the adapter & determines the system
 *        resources.
 *
 * Arguments: bd_config_t *bdp  
 *        
 *
 * Returns:
 *       NONE 
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
int
e100init(bd_config_t * bdp)
{
    device_t       *dev = bdp->device;
    bdd_t          *bddp = bdp->bddp;

    /* init private vars: never fails */
    e100_sw_init(bdp);    

    /* Do a self test of the adapter */
    if (e100_selftest(bdp, NULL, NULL) != B_TRUE) {
        printk(KERN_ERR "selftest failed\n");
        return 0;
    }

    /* read the MAC address from the eprom */
    e100_rd_eaddr(bdp);
    /* read NIC's part number */
    e100_rd_pwa_no(bdp);

    /* Do the adapter initialization */
    if (!e100_hw_init(bdp, PORT_SOFTWARE_RESET)) {
        printk(KERN_ERR "hw init failed\n");
        return 0;
    }
    /* Disable interrupts on the PRO/100 card */
    e100_dis_intr(bdp);

    dev->base_addr = bdp->io_start;
    dev->mem_start = (ulong_t) bddp->scbp;
    dev->mem_end = (ulong_t) (bddp->scbp + sizeof(scb_t));

    return 1;
}


/****************************************************************************
 * Procedure : e100_sw_init
 * 
 * Description : This routine initializes all software structures. Sets up
 *    the circular structures for the RFD's & TCB's. Allocates the per board
 *    structure for storing adapter information. The CSR is also memory 
 *    mapped in this routine.
 *
 * Input : 
 *    bdp - 
 *
 * Returns :
 *    B_TRUE  - if successfully initialized
 *    B_FALSE - if S/W initialization failed
 */
boolean_t
e100_sw_init(bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */

#ifdef IANS
    bd_ans_drv_InitANS(bdp, bdp->iANSdata);
#endif
    
    bddp->next_cu_cmd = START_WAIT; // init the next cu state
    bdp->prev_rx_mode = 0;
    
    /* 
     * Set the value for # of good xmits per underrun. the value assigned
     * here is an intelligent  suggested default. Nothing magical about it.
     */
    bddp->tx_per_underrun = DEFAULT_TX_PER_UNDERRUN;

    /* Initialize the checksum flag. If it is supported by the hardware It
     * will be truned on in the configure command. */
    bdp->checksum_offload_enabled = 0;

    /* get the default transmit threshold value */
    bddp->tx_thld = e100_tx_thld;

    /* get the EPROM size */
    bdp->EEpromSize = GetEEpromSize(bdp);

    /* Initialize our spinlocks */
    spin_lock_init(&(bdp->bd_lock));
    spin_lock_init(&(bdp->bd_tx_lock));
    spin_lock_init(&(bdp->config_lock));

    
    bdp->ZeroLockState = ZLOCK_INITIAL;
    
#ifdef CONFIG_PROC_FS
    
    /* Initialize blink led structure */
    bdp->blink_led.at_cleanup = B_FALSE;
    bdp->blink_led.blink_is_running = B_FALSE;
    bdp->blink_led.blink_count = 0;
    spin_lock_init(&(bdp->blink_led.blink_led_lock));
    
#endif /*CONFIG_PROC_FS*/
    return 1;
}


/*****************************************************************************
 * Procedure:   e100_hw_init
 *
 * Description: This routine performs a reset on the adapter, and configures
 *              the adapter.  This includes configuring the 82557 LAN
 *              controller, validating and setting the node address, detecting
 *              and configuring the Phy chip on the adapter, and initializing
 *              all of the on chip counters.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *        reset_cmd - s/w reset or selective reset. 
 *
 * Returns:
 *      B_TRUE - If the adapter was initialized
 *      B_FALSE - If the adapter failed initialization
 */
boolean_t
e100_hw_init(bd_config_t * bdp, uint32_t reset_cmd)
{
    bdd_t          *bddp = (bdd_t *) bdp->bddp;
    e100_eaddr_t   *eaddrp;
  
    /* Detect the serial component, and set up the Phy if necessary */
    if (!e100_phydetect(bdp))
        return (B_FALSE);
    
    e100_fix_polarity(bdp);
    
    /* Issue a software reset to the e100 */
    e100_sw_reset(bdp, reset_cmd);

    /* Load the CU BASE (set to 0, because we use linear mode) */

    writel(0,&bddp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_CUC_LOAD_BASE);
    

    /* Wait for the SCB command word to clear before we set the * general
     * pointer */
    if (e100_wait_scb(bdp) != B_TRUE)
        return (B_FALSE);

    /* Load the RU BASE (set to 0, because we use linear mode) */
    writel(0,&bddp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_RUC_LOAD_BASE);
    
   
    /* Configure the adapter in non promiscuous mode */
    e100_config_init(bdp);
    if (e100_config(bdp) != B_TRUE) {
        return (B_FALSE);
    }

    /* Load interrupt microcode  */
    if (e100_load_microcode(bdp, bdp->rev_id) == B_TRUE) {
        bdp->flags |= DF_UCODE_LOADED;
        mdelay(1);   
    }
    
    eaddrp = (e100_eaddr_t *) &(bdp->device->dev_addr);
    if (e100_setup_iaaddr(bdp, eaddrp) != B_TRUE)
        return (B_FALSE);

    /* Clear the internal counters */
    if (e100_clr_cntrs(bdp) != B_TRUE)
        return (B_FALSE);

    /* Change for 82558 enhancement */
    /* If 82558/9 and if the user has enabled flow control, set up * the
     * Flow Control Reg. in the CSR */
    if ((bddp->flags & IS_BACHELOR) && (flow_control[bdp->bd_number] == TRUE)) {
        writeb(DFLT_FC_THLD,&bddp->scbp->scb_ext.d101_scb.scb_fc_thld);
        writeb(DFLT_FC_CMD,&bddp->scbp->scb_ext.d101_scb.scb_fc_xon_xoff);
    }

    return (B_TRUE);
}



/**************************************************************************** 
 * Procedure : e100_setup_tcb_pool
 * 
 * Description : This routine arranges the contigiously allocated TCB's 
 *    in a circular list . Also does the one time initialization of the 
 *    TCBs.
 *
 * Input : 
 *    head - Pointer to head of the allocated TCBs'.
 *    qlen - Number of elements in the queue.
 *    bdp    - Ptr to this card's e100_bdconfig structure
 *
 * Returns :
 *    NONE
 */
static void
e100_setup_tcb_pool(ptcb_t head, uint_t qlen, bd_config_t * bdp)
{
    int             ele_no;
    ptcb_t          pcurr_tcb;   /* point to current tcb */
    ptcb_t          pnext_tcb;   /* point to next tcb */
    uint32_t         next_paddr;   /* the next phys addr */
    bdd_t          *bddp = bdp->bddp;

    pcurr_tcb = head;
    pnext_tcb = head;

    for (ele_no = 0, next_paddr = bddp->tcb_paddr;
         ele_no < qlen; ele_no++, pcurr_tcb++) {

        /* set the phys addr for this TCB, next_paddr has not incr. yet */
        pcurr_tcb->tcb_paddr = next_paddr;

        pnext_tcb++;         /* point to next tcb */

        next_paddr += sizeof(tcb_t);

        /* set the link to next tcb */
        if (ele_no == (qlen - 1))
            pcurr_tcb->tcb_hdr.cb_lnk_ptr = cpu_to_le32( bddp->tcb_paddr);
        else
            pcurr_tcb->tcb_hdr.cb_lnk_ptr = cpu_to_le32(next_paddr);
        
        /* initialize TCB status to zero */
        pcurr_tcb->tcb_hdr.cb_status = 0;

        
        /* init the fixed fields in the TCB */
        pcurr_tcb->tcb_cnt = 0; //no immidiate data
        if ((bddp->flags & IS_BACHELOR) &&
            (e100_enhanced_tx_enable)){
                pcurr_tcb->tcb_tbd_num = 0xff; 
                
                pcurr_tcb->tcb_tbd_ptr = 
                        __constant_cpu_to_le32(0xFFFFFFFF);
                /* set the 2nd tbd to end the chain */
                (pcurr_tcb->tcbu).tcb_ext.tbd1_buf_addr = 
                        __constant_cpu_to_le32(0xFFFFFFFF);
                (pcurr_tcb->tcbu).tcb_ext.tbd1_buf_cnt  = 
                        __constant_cpu_to_le32(CB_EL_BIT);
        }
        /* initialize TCB skb pointer to NULL */
        pcurr_tcb->tcb_skb = NULL;

        /* initialize TCB command */
        pcurr_tcb->tcb_hdr.cb_cmd =cpu_to_le16( CB_EL_BIT |   /* Last in CBL */
            CB_TRANSMIT |      /* Xmit cmd */
            CB_TX_SF_BIT);      /* set flexible mod  */
        if(ele_no < 2){
                pcurr_tcb->tcb_hdr.cb_status = 
                        cpu_to_le16(CB_STATUS_COMPLETE);
        }
        /* initialize the early xmit threshold */
        pcurr_tcb->tcb_thrshld = bddp->tx_thld;
    }
    

    return;
}




/***************************************************************************/
/***************************************************************************/
/*       Memory Management Routines                                        */
/***************************************************************************/



/****************************************************************************
 * Name:        e100_alloc_space
 *
 * Description : This routine allocates memory for
 *                the driver. Memory allocated is for the following structures
 *               - bdp, bddp 
 *               - error count structure for adapter statistics
 *
 * Arguments:   
 *   pcid: ptr to pci device  kernel struct
 *
 * Returns: bd_config_t *
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
boolean_t
e100_alloc_space(pci_dev_t *pcid, bd_config_t **bdpp)
{
    bd_config_t    *bdp, *temp_bd;
    bdd_t          *bddp;
    
    /* allocate space for the private structures */
    if (!(bdp = (bd_config_t *) kmalloc(sizeof(bd_config_t), GFP_ATOMIC)))
        return B_FALSE;
    memset(bdp, 0x00, sizeof(*bdp));
    
    *bdpp = bdp;
    
    /* link the bdp's, if needed */
    if (!e100_first) {         /* do we have at least 1 already alloc'd? */
        e100_first = bdp;
        bdp->bd_number = 0;
        bdp->bd_next = NULL;
        bdp->bd_prev = NULL;
    } else {
        /* No, so find last in list and link the new one in */
        temp_bd = e100_first;
        bdp->bd_number = 1;      /* it is at least 1 */
        while (temp_bd->bd_next != NULL) {
            temp_bd = (bd_config_t *) temp_bd->bd_next;
            bdp->bd_number++;   /* set the board number */
        }
        temp_bd->bd_next = bdp;
        bdp->bd_next = NULL;
        bdp->bd_prev = temp_bd;
    }
    
#ifdef IANS
    if (!(bdp->iANSdata = kmalloc(sizeof(iANSsupport_t), GFP_ATOMIC)))
        return B_FALSE;
    memset((void *) bdp->iANSdata, 0, sizeof(iANSsupport_t));
#endif
      
    /* Allocate the bdd_t structure */
    if (!(bddp = (bdd_t *) kmalloc(sizeof(bdd_t), GFP_ATOMIC))) 
        return B_FALSE;
    memset(bddp, 0x00, sizeof(bdd_t));
    bdp->bddp = bddp;         /* Hang it of the bdp */
    bddp->bdp = bdp;         /* point back to the bdp */

    /* allocate space for self test results */
    if (!(bddp->pselftest = 
	  pci_alloc_consistent(pcid,sizeof(self_test_t),&(bddp->selftest_paddr) )))
        return B_FALSE;
    
    /* allocate space for 82557 adapter statistics area */
    if (!(bddp->pstats_counters = 
	  pci_alloc_consistent(pcid,sizeof(max_counters_t),&bddp->stat_cnt_paddr)))
      return B_FALSE;
   
    
    /* allocate space for non transmit cb commands */
     if (!(bddp->pntcb =
	   pci_alloc_consistent(pcid,sizeof(nxmit_cb_t),&bddp->nontx_paddr)))
       return B_FALSE;
   
    /* allocate space for stats results */
      if (!(bddp->perr_stats = 
	    pci_alloc_consistent(pcid,sizeof(err_stats_t),&bddp->estat_paddr)))
	return B_FALSE;
     
      memset(bddp->perr_stats, 0, sizeof(err_stats_t));
      
      return B_TRUE;
}


/****************************************************************************
 * Name:        e100_alloc_tcbs
 *
 * Description : This routine allocates memory for the transmit
 *               descriptors.
 *
 * Arguments:   
 *    bd_config_t *
 *
 * Returns:
 *       0 - Allocation has failed.
 *       1 - Otherwise. 
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
int
e100_alloc_tcbs(bd_config_t *bdp)
{
    bdd_t * bddp = bdp->bddp;
    int stcb = sizeof(tcb_t) * TxDescriptors[bdp->bd_number];
    int stbd = sizeof(tbd_t) * TxDescriptors[bdp->bd_number];
    
    /* allocate space for the TCBs */
    if (!(bddp->tcb_pool.data = 
	  pci_alloc_consistent(bdp->ppci_dev,stcb,&bddp->tcb_paddr)))
      return 0;

    memset(bddp->tcb_pool.data, 0x00, stcb);

    /* there is ALWAYS only going to 1 phys frag  */
    /* tbd_paddr is a phys_addr but stored as an unsigned long */
    if (!(bddp->tbd_pool.data =
	  pci_alloc_consistent(bdp->ppci_dev,stbd,&(bddp->tbd_paddr))))
      return 0;
    
    memset(bddp->tbd_pool.data, 0x00, stbd);

    return 1;
}

void
e100_free_tbds(bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;
    
    int stcb = sizeof(tcb_t) * TxDescriptors[bdp->bd_number];
    int stbd = sizeof(tbd_t) * TxDescriptors[bdp->bd_number];
    pci_free_consistent(bdp->ppci_dev, stcb, bddp->tcb_pool.data, bddp->tcb_paddr);
    pci_free_consistent(bdp->ppci_dev, stbd, bddp->tbd_pool.data, bddp->tbd_paddr);
   
}

/****************************************************************************
 * Name:        e100_dealloc_space
 *
 * Description : This routine frees all the memory allocated by "alloc_space".
 *               and e100_alloc_tbds.
 *
 * Born on Date:    7/17/97
 *
 * Arguments:   bd_config_t * 
 *
 * Returns:
 *    none
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static void
e100_dealloc_space(bd_config_t * bdp)
{
  bdd_t          *bddp = bdp->bddp;

  /* do we have valid board structure? */
  if (!bdp) return;

#ifdef IANS
  COND_FREE(bdp->iANSdata);
#endif
 
  /* is bddp valid? */
  if (bdp->bddp) {
    pci_free_consistent(bdp->ppci_dev,sizeof(self_test_t),
			bddp->pselftest,bddp->selftest_paddr);
    pci_free_consistent(bdp->ppci_dev,sizeof(max_counters_t),
			bddp->pstats_counters,bddp->stat_cnt_paddr);
    pci_free_consistent(bdp->ppci_dev,sizeof(nxmit_cb_t),
			bddp->pntcb,bddp->nontx_paddr);
    pci_free_consistent(bdp->ppci_dev,sizeof(err_stats_t),
			bddp->perr_stats,bddp->estat_paddr);
  
    bddp->tcb_paddr = 0;
    bddp->tbd_paddr = 0;
    bddp->selftest_paddr = 0;
    bddp->stat_cnt_paddr = 0;
    bddp->nontx_paddr = 0;
    bddp->estat_paddr = 0;

    kfree(bdp->bddp);
  }
  /* un-link the bdp from the linked list */
  if (bdp == e100_first) {
    e100_first = (bd_config_t *) bdp->bd_next;
    if (bdp->bd_next)
      ((bd_config_t *) bdp->bd_next)->bd_prev = NULL;
  } else {
    if (bdp->bd_next)
      ((bd_config_t *) bdp->bd_next)->bd_prev = bdp->bd_prev;
    if (bdp->bd_prev)
      ((bd_config_t *) bdp->bd_prev)->bd_next = bdp->bd_next;
  }
    
  kfree(bdp);
}

void
e100_free_rfd_pool(bd_config_t *bdp)
{
    sk_buff_t  *skb, *nskb;
    bdd_t      *bddp = bdp->bddp;

    while (bddp->rfd_head != NULL) {
        skb = bddp->rfd_head;
        nskb = (sk_buff_t *) RFD_POINTER(skb,bddp)->next;
        // use TODEVICE to avoid memcpy 
        pci_unmap_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(skb,bddp),
			 sizeof(rfd_t),PCI_DMA_TODEVICE);
	dev_kfree_skb_irq(skb);
        bddp->rfd_head = nskb;
    }
    bddp->rfd_head = NULL;
    bddp->rfd_tail = NULL;
}



/* 
 * Procedure : e100_alloc_rfd_pool
 *
 * Description : allocates initial pool of skb which holds both rfd and data
 * Input : 
 *    bddp  - pointer to board specific data
 *
 * Returns :
 *    pointer to head of list
 */

static sk_buff_t *
e100_alloc_rfd_pool(bdd_t * bddp)
{
    sk_buff_t *nskb;
    
    bddp->rfd_tail = NULL;
    bddp->rfd_head = NULL;
    bddp->skb_req  = RxDescriptors[bddp->bdp->bd_number];

    ALLOC_SKBS(bddp, nskb);
    return bddp->rfd_head;
}





/*****************************************************************************/
/*****************************************************************************/
/*      Run Time Functions                                                   */
/*****************************************************************************/ 

/*****************************************************************************
 * Name:        e100_watchdog
 *
 * Description: This routine updates our statitics and refreshs the txthld
 *                  value.
 *
 * Born on Date:    1/5/00
 *
 * Arguments:
 *            dev - device structure
 *
 * Returns:
 *      (none)
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  --------------------------------------------------------
 *
 *****************************************************************************/
void
e100_watchdog(device_t * dev)
{
        bd_config_t    *bdp = dev->priv;
        bdd_t          *bddp = bdp->bddp;

        e100_phy_check(bdp);

        if(e100_update_stats(bdp) == B_TRUE){    

                /* Check if a change in the IFS parameter is needed, 
                   and configure the device accordingly */
                if (IFS[bdp->bd_number] == TRUE)
                        e100_manage_adaptive_ifs(bdp);

                /* Now adjust our dynamic tx threshold value */
                e100_refresh_txthld(bdp);
                
                /* Now if we are on a 557 and we havn't received any frames then we
                 * should issue a multicast command to reset the RU */
                if ((bdp->rev_id < D101A4_REV_ID) && (!(bddp->flags & IS_ICH))) {
                        /* if we haven't received any frames then issue the multicast
                         * command */
                        if (bddp->pstats_counters->basic_stats.rcv_gd_frames == 0) {
                                e100_set_multi(dev);
                        }
                }

                /* Update the statistics needed by the upper interface */
                /* This should be the last statistic related command
                 * as it's async. now */
                e100_dump_stats_cntrs(bdp);
        }

   
#ifdef IANS
        /* Now do the ANS stuff */
        if ((ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) &&
            (ANS_PRIVATE_DATA_FIELD(bdp)->reporting_mode == IANS_STATUS_REPORTING_ON))
                {
                        bd_ans_os_Watchdog(dev, bdp);
                }
#endif

        e100_handle_zero_lock_state(bdp);
    
        /* relaunch watchdog timer in 2 sec */
	bdp->timer_id.expires = bdp->timer_val = jiffies + (2 * HZ);
	add_timer(&bdp->timer_id);

        if (bddp->rfd_head == NULL) 
                e100_trigger_SWI(bdp);
    
        // handle non-cu vs. tx cu race condition
        e100_tx_notify_start(bdp);
        return;
}

/*
 * Procedure:  e100_manage_adaptive_ifs
 *
 * Description: This routine manages the adaptive IFS algorithm
 *              using a state machine.
 *
 * Returns:
 *      NONE
 *
 */

void
e100_manage_adaptive_ifs(bd_config_t *bdp)
{
    bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */
    
    static uint16_t state_table[9][4] = {     // rows are states
        {2, 0,  0,  0},   // state0         // column0: next state if increasing
        {2, 0,  5, 30},   // state1         // column1: next state if decreasing
        {5, 1,  5, 30},   // state2         // column2: IFS value for 100 mbit
        {5, 3,  0,  0},   // state3         // column3: IFS value for 10 mbit
        {5, 3, 10, 60},   // state4
        {8, 4, 10, 60},   // state5
        {8, 6,  0,  0},   // state6
        {8, 6, 20, 60},   // state7
        {8, 7, 20, 60}    // state8
    };

    uint32_t        transmits  = le32_to_cpu(bddp->pstats_counters->basic_stats.xmt_gd_frames);
    uint32_t        collisions = le32_to_cpu(bddp->pstats_counters->basic_stats.xmt_ttl_coll);
    uint32_t        state      = bdp->ifs_state;
    uint32_t        old_value  = bdp->ifs_value;
    int             next_col;
    uint32_t        min_transmits;
    
    if (bddp->cur_dplx_mode == FULL_DUPLEX) {
        bdp->ifs_state = 0;
        bdp->ifs_value = 0;

    } else {   /* Half Duplex */
        /* Set speed specific parameters */
        if (bddp->cur_line_speed == 100) {
            next_col = 2;
            min_transmits = MIN_NUMBER_OF_TRANSMITS_100;
            
        } else {   /* 10 Mbps */
            next_col = 3;
            min_transmits = MIN_NUMBER_OF_TRANSMITS_10;
        }
        
        if ((transmits / 32 < collisions) && (transmits > min_transmits)) {
            state = state_table[state][0];                 /* increment */
            
        } else if (transmits < min_transmits) {
            state = state_table[state][1];                 /* decrement */
        }
        
        bdp->ifs_value = state_table[state][next_col];
        bdp->ifs_state = state;
    }        

    /* If the IFS value has changed, configure the device */
    if (bdp->ifs_value != old_value) {
        e100_config_ifs(bdp);
        e100_config(bdp);
    }
}


/* 
 * Procedure:   e100intr
 *
 * Description: This routine is the ISR for the e100 board. It services
 *        the RX & TX queues & starts the RU if it has stopped due
 *        to no resources.
 *
 * Returns:
 *      NONE
 *
 */
void
e100intr(int irq, void *dev_inst, struct pt_regs *regs)
{

    device_t       *dev;
    bd_config_t    *bdp;
    bdd_t          *bddp;
    uint16_t        intr_status;
   
    dev = (device_t *) dev_inst;
    bdp = dev->priv;
    bddp = bdp->bddp;

    intr_status = readw(&bddp->scbp->scb_status) ;
    if (!intr_status){ 
            return;   
    }
    writew(intr_status,&bddp->scbp->scb_status);   /* ack intrs */   
    
    e100_dis_intr(bdp);    /* prevent intr from happen on another CPU */
        
    /* SWI intr (triggered by watchdog) is signal to allocate new skb buffers */
    if (intr_status & SCB_STATUS_ACK_SWI) {
        sk_buff_t  *nskb;
        ALLOC_SKBS(bddp, nskb);
    }
    /* do recv work if any */
    if (intr_status & (SCB_STATUS_ACK_FR | SCB_STATUS_ACK_RNR | SCB_STATUS_ACK_SWI)) {


        e100_rx_srv(bdp);  
        /* restart the RU if it has stopped */
        if ((readw(&bddp->scbp->scb_status) & SCB_RUS_MASK) != SCB_RUS_READY) 
            e100_start_ru(bdp);
    }
    
    /* clean up after tx'ed packets */
    if (intr_status & (SCB_STATUS_ACK_CNA | SCB_STATUS_ACK_CX)) {
        bdp->tx_count = 0;   /* restart tx interrupt batch count */
        e100_tx_srv(bdp);
    }

    e100_enbl_intr(bdp);
   
    return;
    
}

/* 
 * Procedure:   e100_tx_skb_free
 *
 * Description: routine to free resources of TX skbs.
 *
 *Arguments:
 * bdp - Ptr to this card's e100_bdconfig structure.
 * tcbp- Ptr to the associated tcb of the freed skb.
 *
 * Returns:
 * NONE
 */
static void inline e100_tx_skb_free(bd_config_t * bdp,tcb_t *tcbp)
{
  if (tcbp->tcb_skb) {
    pci_unmap_single(bdp->ppci_dev,tcbp->dma_data_addr,tcbp->tcb_skb->len,PCI_DMA_TODEVICE);
    dev_kfree_skb_irq(tcbp->tcb_skb);
    tcbp->tcb_skb = NULL;
  }
} 

/* 
 * Procedure:   e100_tx_srv
 *
 * Description: This routine services the TX queues. It reclaims the
 *        TCB's & TBD's & other resources used during the transmit
 *        of this buffer. It is called from the ISR. We don't need a tx_lock
 * 	  since we always access buffers which were already prepared.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *    NONE
 */



void
e100_tx_srv(bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;
    buf_pool_t     *tcb_poolp;
    uint_t          tcb_head = 0;
    tcb_t          *tcbp;
    int             loop_cnt = 0;

    tcb_poolp = &bddp->tcb_pool;
    tcb_head = tcb_poolp->head;
    tcbp = tcb_poolp->data;
    tcbp += tcb_head;

    while ((tcbp->tcb_hdr.cb_status & 
	    __constant_cpu_to_le16(CB_STATUS_COMPLETE)) &&
        (loop_cnt < TxDescriptors[bdp->bd_number])) {

        if (IS_IT_GAP(tcb_poolp)) {
	    e100_tx_skb_free(bdp,tcbp);
            /* move head to next buffer & service it */
            if ((tcb_head + 1) >= TxDescriptors[bdp->bd_number])
                tcbp = tcb_poolp->data;
            else
                tcbp++;

            if (tcbp->tcb_hdr.cb_status & __constant_cpu_to_le16(CB_STATUS_COMPLETE)) {
                e100_tx_skb_free(bdp,tcbp);
            }
            e100_tx_notify_start(bdp);
            break;
        }

        /* update statistics & free this msg */
        /* xmits is a counter for update CID. */
	e100_tx_skb_free(bdp,tcbp);    

        /* clear the out of resource condition */
        e100_tx_notify_start(bdp);
        /* move head to next buffer & service it */
        tcb_head++;
        /* check for wrap condition */
        if (tcb_head >= TxDescriptors[bdp->bd_number]) {
            tcb_head = 0;
            tcbp = tcb_poolp->data;
        } else
            tcbp++;
        tcb_poolp->head = tcb_head;
        loop_cnt++;

        tcb_poolp->head = tcb_head;

    }                     /* end of while */

    tcb_poolp->head = tcb_head;
    return;
}

/* 
 * Procedure:   e100_rx_srv
 *
 * Description: This routine processes the RX interrupt & services the 
 *        RX queues. For each successful RFD, it allocates a new msg
 *        block, links that into the RFD list, & sends the old msg upstream.
 *        The new RFD is then put at the end of the free list of RFD's.
 *
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *    NONE
 */
void
e100_rx_srv(bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;
    rfd_t          *rfdp;      /* new rfd, received rfd */
    int          i;
    uint16_t        rfd_status;
    sk_buff_t      *skb, *nskb;
    device_t       *dev;
    net_device_stats_t *stats;
#ifdef CSUM_i386   
    ip_v4_header   *IPPacket;
    int             HeaderOffset = 0;
#endif
    unsigned int data_sz;
    unsigned int rx_congestion = 0;
    
    dev = bdp->device;
    stats = &(bddp->net_stats);

    /* current design of rx is as following:
     * 1. socket buffer (skb) used to pass network packet to upper layer
     * 2. all HW host memory structures (like RFDs, RBDs and data buffers)
     *    are placed in a skb's data room
     * 3. when rx process is complete, we change skb internal pointers to exclude
     *    from data area all unrelated things (RFD, RDB) and to leave
     *    just rx'ed packet netto
     * 4. for each skb passed to upper layer, new one is allocated instead.
     * 5. if no skb left, in 2 sec another atempt to allocate skbs will be made
     *    (watchdog trigger SWI intr and isr should allocate new skbs)
     */
    
    for (i = 0; i < RxDescriptors[bdp->bd_number] ; i++ )
    {
        skb = bddp->rfd_head;
        if (skb == NULL) /* no buffers left - exit and watchdog take care later */
            return;  
	
        rfdp = RFD_POINTER(skb, bddp);            /* locate RFD within skb */
	
        // sync only the RFD header
        pci_dma_sync_single(bdp->ppci_dev,rfdp->dma_addr,bddp->rfd_size,PCI_DMA_FROMDEVICE);
        rfd_status = le16_to_cpu(rfdp->rfd_header.cb_status);  /* get RFD's status */
        if (!(rfd_status & RFD_STATUS_COMPLETE))  /* does not contains data yet - exit */
            return;

        /* to allow manipulation with current skb we need to advance rfd head */
        bddp->rfd_head = rfdp->next;
	
	data_sz = le16_to_cpu(rfdp->rfd_act_cnt) & 0x3fff;
        
        // now sync all the data 
	pci_dma_sync_single(bdp->ppci_dev,rfdp->dma_addr,
			    E100_MIN(data_sz+bddp->rfd_size,sizeof(rfd_t)),
				PCI_DMA_FROMDEVICE);
        
        // we unmap using DMA_TODEVICE to avoid another memcpy from the 
        // bounce buffer
	pci_unmap_single(bdp->ppci_dev,rfdp->dma_addr,sizeof(rfd_t),PCI_DMA_TODEVICE);
        /* do not free badly recieved packet - move it to the end of skb list for reuse */
        if (!(rfd_status & RFD_STATUS_OK) || rx_congestion) {
            e100_add_skb_to_end(bddp, skb);
            continue;
        }
	/* end of dma access to rfd */
	
       
	bddp->skb_req++;           /* incr number of requested skbs */
        ALLOC_SKBS(bddp, nskb);    /* and get them */

        /* set packet size, excluding checksum (2 last bytes) if it is present */
        if (bdp->checksum_offload_enabled && (bdp->rev_id < D102_REV_ID)) 
            skb_put(skb,(int) data_sz - 2);
        else 
            skb_put(skb, (int)data_sz);

        /* set the checksum info */
        skb->ip_summed = CHECKSUM_NONE;
        if(bdp->checksum_offload_enabled) {
            if(bdp->rev_id >= D102_REV_ID)  {
                e100_D102_check_checksum(bdp, skb);
            } 
#ifdef CSUM_i386
            else if ((IPPacket = e100_check_for_ip(&HeaderOffset, skb))) {
                e100_calculate_checksum(IPPacket, HeaderOffset, skb,
                    data_sz);
            }
#endif /* CSUM_i386 */
        }


#ifdef IANS
        /* Before we give it to the stack lets let ANS process it */
        if (ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP)   {
            if (bd_ans_os_Receive(bdp, RFD_POINTER(skb, bddp), skb)  == BD_ANS_FAILURE) {
                dev_kfree_skb_irq(skb);
                continue;
            }
        } else 
#endif          
            /* set the protocol */
            skb->protocol = eth_type_trans(skb, dev);

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
        netif_rx(skb);

        stats->rx_bytes += skb->len;
#else

        if (netif_rx(skb) != NET_RX_DROP) {
                stats->rx_bytes += skb->len;
        } else {
                /* recycle pending RFDs */
                rx_congestion = 1;
        }
#endif
    }                       /* end of rfd loop */

    return;
}







/* 
 * Procedure:   e100_refresh_txthld
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *    -     NONE
 */
void
e100_refresh_txthld(bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;
    basic_cntr_t *pstat = &(bddp->pstats_counters->basic_stats);
    /* as long as tx_per_underrun is not 0, we can go about dynamically *
     * adjusting the xmit threshold. we stop doing that & resort to defaults
     * * once the adjustments become meaningless. the value is adjusted by *
     * dumping the error counters & checking the # of xmit underrun errors *
     * we've had. */
    if (bddp->tx_per_underrun) {
        /* We are going to last values dumped from the dump statistics
         * command */
        if (le32_to_cpu(pstat->xmt_gd_frames)) {
            if (le32_to_cpu(pstat->xmt_uruns)) {
                /* 
                 * if we have had more than one underrun per "DEFAULT #
                 * OF XMITS ALLOWED PER UNDERRUN" good xmits, raise the
                 * THRESHOLD.
                 */
                if ((le32_to_cpu(pstat->xmt_gd_frames) /
                    le32_to_cpu(pstat->xmt_uruns)) <
                    bddp->tx_per_underrun) {
                    bddp->tx_thld += 3;
                }
            }

            /* 
             * if we've had less than one underrun per the DEFAULT number of
             * of good xmits allowed, lower the THOLD but not less than 0 
             */
            if (le32_to_cpu(pstat->xmt_gd_frames) >
                bddp->tx_per_underrun) {
                bddp->tx_thld--;

                if (bddp->tx_thld < 6)
                    bddp->tx_thld = 6;

            }
        }

        /* end good xmits */
        /* 
         * * if our adjustments are becoming unresonable, stop adjusting &
         * resort * to defaults & pray. A THOLD value > 190 means that the
         * adapter will * wait for 190*8=1520 bytes in TX FIFO before it
         * starts xmit. Since * MTU is 1514, it doesn't make any sense for
         * further increase. */
        if (bddp->tx_thld >= 190) {
            bddp->tx_per_underrun = 0;
            bddp->tx_thld = 189;
        }
    }                     /* end underrun check */
    return;
}


/* 
 * Procedure:   e100_prepare_xmit_buff
 *
 * Description: This routine prepare a buffer for transmission. It checks
 *        the message length for the appropiate size. It picks
 *        up a free tcb from the TCB pool & sets up the corresponding
 *        TBD's. If number of fragments are more the the # of TBD/TCB
 *        it copies all the fragments in a coalesce buffer. 
 *
 * Arguments:
 *      bdp    - Ptr to this card's e100_bdconfig structure
 *      ksb    - Ptr to the skb to send
 *
 * Returns:
 *     ptcb   - Ptr to the prepared TCB
 */
static          ptcb_t
e100_prepare_xmit_buff(bd_config_t * bdp, sk_buff_t * skb)
{
    bdd_t          *bddp = bdp->bddp;
    buf_pool_t     *tcb_poolp;
    buf_pool_t     *tbd_poolp;
    tcb_t          *tcbp, *prev_tcbp;
    tbd_t          *tbdp;
    uint16_t            txcommand;

    tcb_poolp = &(bddp->tcb_pool);
    tbd_poolp = &(bddp->tbd_pool);
    tcbp = tcb_poolp->data;
    tbdp = tbd_poolp->data;

    /* get the TCB & the TBD we may be using for this MSG */
    tcbp += TCB_TO_USE(tcb_poolp);
    tbdp += (TCB_TO_USE(tcb_poolp));

    if (bddp->flags & USE_IPCB) {
      //TBD how do we treat packed integers on multi_platforms
        (tcbp->tcbu).ipcb.ip_activation = IPCB_IP_ACTIVATION_DEFAULT;
        (tcbp->tcbu).ipcb.vlan = 0;
        txcommand = CB_IPCB_TRANSMIT | CB_S_BIT | CB_TX_SF_BIT;
    }
    else 
        txcommand = CB_TRANSMIT | CB_S_BIT | CB_TX_SF_BIT;
   
#ifdef IANS
    if (ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) 
        bd_ans_os_Transmit(bdp, tcbp, &skb);
#endif
    tcbp->tcb_hdr.cb_status = 0;
    tcbp->tcb_cnt = 0;
    tcbp->tcb_tbd_num = 1;
    tcbp->tcb_thrshld = bddp->tx_thld;
    tcbp->tcb_tbd_ptr = cpu_to_le32(bddp->tbd_paddr +
        (TCB_TO_USE(tcb_poolp) * sizeof(tbd_t)));
    tcbp->tcb_hdr.cb_cmd = cpu_to_le16(txcommand);


    /* set the I bit on the modulo tcbs, so we will get an interrupt * to
     * clean things up */
    if (!(++bdp->tx_count % e100_batch_tx_frames)) {
        tcbp->tcb_hdr.cb_cmd |= __constant_cpu_to_le16(CB_I_BIT);
    }

    /* save a pointer to the skb to free it later */
    tcbp->tcb_skb = skb;

    tcbp->dma_data_addr = pci_map_single(bdp->ppci_dev,skb->data,skb->len,PCI_DMA_TODEVICE);
    if (bddp->flags & USE_IPCB) {
        /* setup the ipcb fields */
      (tcbp->tcbu).ipcb.tbd_sec_addr.tbd_zero_address =cpu_to_le32(tcbp->dma_data_addr);

        (tcbp->tcbu).ipcb.tbd_sec_size.tbd_zero_size = cpu_to_le16(skb->len);
    } else {
        /* copy the phys addrs and len to the tbds */
      tbdp->tbd_buf_addr = cpu_to_le32(tcbp->dma_data_addr);

        tbdp->tbd_buf_cnt = cpu_to_le32(skb->len);
    }

   
    /* Clear the S-Bit of the Previous Command */
    prev_tcbp = tcb_poolp->data;
    prev_tcbp += PREV_TCB_USED(tcb_poolp);
    prev_tcbp->tcb_hdr.cb_cmd &= __constant_cpu_to_le16((uint16_t)~CB_S_BIT);

    /* update the tail */
    tcb_poolp->tail = NEXT_TCB_TOUSE(tcb_poolp->tail);

    /* start the CU if needed */
    e100_cu_start(bdp, tcbp);

    return (tcbp);
}


/* 
 * Procedure:   e100_prepare_ext_xmit_buff
 *
 * Description: This is a 82558/9 specific routine.
 *  This sets up the extended TCBs and dynamically chains TBDs.
 *      This routine prepare a buffer for transmission. It checks
 *      the message length for the appropiate size. It picks
 *      up a free tcb from the TCB pool & sets up the corresponding
 *      TBD's. If number of fragments are more the the # of TBD/TCB
 *      it copies all the fragments in a coalesce buffer. 
 *
 *
 * Arguments:
 *      bdp    - Ptr to this card's e100_bdconfig structure
 *      skb    - skb to send.
 *
 * Returns:
 *  ptcb   - Ptr to the prepared TCB
 */
static          ptcb_t
e100_prepare_ext_xmit_buff(bd_config_t * bdp, sk_buff_t * skb)
{
    bdd_t          *bddp;
    buf_pool_t     *tcb_poolp;
    tcb_t          *tcbp;
    tcb_t          *prev_tcbp;

    bddp = (bdd_t *) bdp->bddp;
    tcb_poolp = &bddp->tcb_pool;
    tcbp = tcb_poolp->data;

    /* get the TCB & the TBD we may be using for this MSG */
    /* since Linux only use 1 physical address the number of tdbs use is 1 * 
     * which will fit into the extended tcb */
    tcbp += TCB_TO_USE(tcb_poolp);

#ifdef IANS
    if (ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) 
        bd_ans_os_Transmit(bdp, tcbp, &skb);
#endif

    tcbp->tcb_hdr.cb_status = 0;
    tcbp->tcb_thrshld = bddp->tx_thld;
    tcbp->tcb_hdr.cb_cmd = __constant_cpu_to_le16(CB_S_BIT | CB_TRANSMIT | CB_TX_SF_BIT);

    /* set the I bit on the modulo tcbs, so we will get an interrupt * to
     * clean things up */
    if (!(++bdp->tx_count % e100_batch_tx_frames)) {
        tcbp->tcb_hdr.cb_cmd |= __constant_cpu_to_le16(CB_I_BIT);
    }

    /* set the CNA backoff */
    tcbp->tcb_hdr.cb_cmd |= cpu_to_le16(bddp->current_cna_backoff << 8);

    /* save a pointer to the skb to free it later */
    tcbp->tcb_skb = skb;

    /* set the data size of the SKB */
   
    tcbp->dma_data_addr = pci_map_single(bdp->ppci_dev,skb->data,skb->len,PCI_DMA_TODEVICE);
    /* set the ext tbd to the skb */
    (tcbp->tcbu).tcb_ext.tbd0_buf_addr = cpu_to_le32(tcbp->dma_data_addr);
    (tcbp->tcbu).tcb_ext.tbd0_buf_cnt  = cpu_to_le32( skb->len);

    /* clear the S-BIT on the previous tcb */
    prev_tcbp = tcb_poolp->data;
    prev_tcbp += PREV_TCB_USED(tcb_poolp);
    prev_tcbp->tcb_hdr.cb_cmd &= __constant_cpu_to_le16((uint16_t)~CB_S_BIT);

    /* start the CU if needed */
    e100_cu_start(bdp, tcbp);

    /* update the tail */
    tcb_poolp->tail = NEXT_TCB_TOUSE(tcb_poolp->tail);

    return (tcbp);
}


/* Changed for 82558 enhancement */
/* 
 * Procedure:   e100_cu_start
 *
 * Description: This routine issues a CU Start or CU Resume command
 * to the 82558/9. This routine was added because the prepare_ext_xmit_buff
 * takes advantage of the 82558/9's Dynamic TBD chaining feature and has to
 * start the CU as soon as the first TBD is ready. 
 *
 * cu_start must be called while holding the tx_lock ! 
 *
 * Arguments:
 *      bdp    - Ptr to this card's e100_bdconfig structure
 *      tcbp   - Ptr to the TCB to be transmitted        
 *      
 */
void
e100_cu_start(bd_config_t * bdp, tcb_t * tcbp)
{
    bdd_t          *bddp = (bdd_t *) bdp->bddp;
    unsigned long	lock_flag;
    int timeout;
  
    spin_lock_irqsave(&(bdp->bd_lock), lock_flag);
    switch(bddp->next_cu_cmd){
     case RESUME_NO_WAIT:
	    /*last cu command was a CU_RESMUE if this is a 558 or newer we dont need to
	     * wait for command word to clear, we reach here only if we are bachlor
	     */
             //	ASSERT(bddp->flags & IS_BACHELOR);
	e100_exec_cmd(bdp,SCB_CUC_RESUME);
	break;        
    case RESUME_WAIT:
        if ((bddp->flags & IS_ICH) &&
            (bddp->cur_line_speed == 10) &&
            (bddp->cur_dplx_mode == HALF_DUPLEX)) {
            e100_wait_exec_cmd(bdp, SCB_CUC_NOOP);
            udelay(1);
        }
        if(e100_wait_exec_cmd(bdp, SCB_CUC_RESUME) == B_TRUE &&
           (bddp->flags & IS_BACHELOR)){
	    bddp->next_cu_cmd = RESUME_NO_WAIT;
	}
	break;
    case START_WAIT:
	    // The last command was a non_tx CU command
            if(e100_wait_scb(bdp) != B_TRUE){
                    printk("%s cu_start: timeout waiting for scb\n",
                           bdp->device->name);
                    
            }
            timeout = 1000*500;
            E100_WAIT_FOR_CONDITION(timeout,
                                  ((readw(&(bddp->scbp->scb_status)) & SCB_CUS_MASK)
                                   != SCB_CUS_ACTIVE));
            if(timeout <= 0){
                    printk("%s cu_start:timeout waiting for cu\n",
                           bdp->device->name);
            }
            writel(tcbp->tcb_paddr,&bddp->scbp->scb_gen_ptr);
            e100_exec_cmd(bdp, SCB_CUC_START);
            bddp->next_cu_cmd = RESUME_WAIT; 
            
            break;
    }
            
    /* save the last tcbp */
    bdp->bddp->last_tcbp = tcbp;

    spin_unlock_irqrestore(&(bdp->bd_lock), lock_flag);
    return;
}


/* ====================================================================== */
/* hw                                                                     */
/* ====================================================================== */

/* 
 * Procedure:   SelfTestHardware
 *
 * Description: This routine will issue PORT Self-test command to test the
 *          e100.  The self-test will fail if the adapter's master-enable
 *         bit is not set in the PCI Command Register, or if the adapter
 *         is not seated in a PCI master-enabled slot. we also disable interrupts
 *         when the command is completed.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *    -     B_TRUE if adapter passes self_test
 *        B_FALSE if adapter fails self_test
 */
boolean_t
e100_selftest(bd_config_t *bdp, uint32_t *st_timeout, uint32_t *st_result)
{

    bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */
    uint32_t         SelfTestCommandCode;

    /* initialize the nic state before running test */
    e100_sw_reset(bdp, PORT_SOFTWARE_RESET);
    /* Setup the address of the self_test area */
    SelfTestCommandCode =  bddp->selftest_paddr;

    /* Setup SELF TEST Command Code in D3 - D0 */
    SelfTestCommandCode |= PORT_SELFTEST;

    /* Initialize the self-test signature and results DWORDS */
    bddp->pselftest->st_sign = 0;
    bddp->pselftest->st_result = 0xffffffff;

    /* Do the port command */
    writel(SelfTestCommandCode,&bddp->scbp->scb_port);

    /* Wait 10 milliseconds for the self-test to complete */
    mdelay(10);

    /* disable interrupts since the're now enabled */
    e100_dis_intr(bdp);
    /* if The First Self Test DWORD Still Zero, We've timed out. If the
     * second DWORD is not zero then we have an error. */
    if ((bddp->pselftest->st_sign == 0) ||
        (bddp->pselftest->st_result != 0)) {
        
        if (st_timeout)
            *st_timeout = !(le32_to_cpu(bddp->pselftest->st_sign));
        
        if (st_result)
            *st_result = le32_to_cpu(bddp->pselftest->st_result);
        
        return B_FALSE;
    }

    return B_TRUE;
}

/* 
 * Procedure:   e100_setup_iaaddr
 *
 * Description: This routine will issue the IA setup command.  This command
 *              will notify the 82557 (e100) of what its individual (node)
 *              address is.  This command will be executed in polled mode.
 *
 * Arguments:
 *      bdp      - Ptr to this card's e100_bdconfig structure
 *      peaddr   - Ptr to the new ethernet address
 *
 * Returns:
 *      B_TRUE - If the IA setup command was successfully issued and completed
 *      B_FALSE - If the IA setup command failed to complete properly
 */

boolean_t
e100_setup_iaaddr(bd_config_t * bdp, e100_eaddr_t * peaddr)
{
        uint_t          i;
        bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */
        pcb_header_t    pntcb_hdr;
        unsigned long   lock_flag;
        int timeout;
  
        /* We lock before we start using the non tcb cmd */
        spin_lock_bh(&bdp->bd_tx_lock);
        

        timeout = 1000*500;

        /* wait for the last tcb to complete transmition */
        if (bdp->bddp->last_tcbp) {
                E100_WAIT_FOR_CONDITION(timeout,
                                        (bdp->bddp->last_tcbp->tcb_hdr.cb_status & 
                                         __constant_cpu_to_le16(CB_STATUS_COMPLETE)));
        }
        E100_WAIT_FOR_CONDITION(timeout,
                                ((readw(&bddp->scbp->scb_status) & SCB_CUS_MASK)
                                 != SCB_CUS_ACTIVE));
        if(timeout <= 0){
                spin_unlock_bh(&bdp->bd_tx_lock);
                e100_tx_notify_start(bdp);

                printk(KERN_WARNING "%s Set MAC failed\n",bdp->device->name);
                return (B_FALSE);  
        }
               
        pntcb_hdr = (pcb_header_t) bddp->pntcb;   /* get hdr of non tcb cmd */

        /* Setup the non-transmit command block header for the configure command. 
         */
        pntcb_hdr->cb_status = 0;
        pntcb_hdr->cb_cmd = __constant_cpu_to_le16(CB_IA_ADDRESS);
        /* Note: cb_lnk_ptr is a physical address stored in an unsigned long */
        pntcb_hdr->cb_lnk_ptr = 0;

        /* Copy in the station's individual address */
        for (i = 0; i < ETHERNET_ADDRESS_LENGTH; i++) {
                bddp->pntcb->ntcb.setup.ia_addr[i] = peaddr->bytes[i];
        }

        spin_lock_irqsave(&bdp->bd_lock, lock_flag);

        /* Wait for the SCB command word to clear before we set the * general
         * pointer */
        if (e100_wait_scb(bdp) != B_TRUE) {
                spin_unlock_irqrestore(&(bdp->bd_lock), lock_flag);
                spin_unlock_bh(&bdp->bd_tx_lock);
                e100_tx_notify_start(bdp);
                return (B_FALSE);
        }
        /* Update the command list pointer.  */
        writel(bddp->nontx_paddr,&bddp->scbp->scb_gen_ptr);
        
        /* store the command */
        bddp->next_cu_cmd = START_WAIT;
        
        e100_exec_non_cu_cmd(bdp);
        spin_unlock_irqrestore(&bdp->bd_lock, lock_flag);

        if (!e100_poll_cmd(bdp)) {
                spin_unlock_bh(&bdp->bd_tx_lock);
                e100_tx_notify_start(bdp);
                printk(KERN_WARNING "%s IA setup failed\n",bdp->device->name);
                return (B_FALSE);
        }

        spin_unlock_bh(&bdp->bd_tx_lock);
        e100_tx_notify_start(bdp);

        return (B_TRUE);        
}


/* 
 * Procedure:   e100_start_ru
 *
 * Description: This routine checks the status of the 82557's receive unit(RU),
 *              and starts the RU if it was not already active.  However,
 *              before restarting the RU, the driver gives the RU the buffers 
 *        it freed up during the servicing of the ISR. If there are
 *        no free buffers to give to the RU, ( i.e. we have reached a
 *        no resource condition ) the RU will not be started till the
 *        next ISR.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NONE
 */


void
e100_start_ru(bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;   /* get the bddp for this board */
    sk_buff_t       *skb; 

   /* If the receiver is ready, then don't try to restart. */
    if ((readw(&bddp->scbp->scb_status) & SCB_RUS_MASK) == SCB_RUS_READY) {
        return;
    }
    for(skb = bddp->rfd_head; skb != NULL; skb = NEXT_SKB(skb,bddp)){
        pci_dma_sync_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(skb,bddp),
			    bddp->rfd_size,PCI_DMA_FROMDEVICE);
	if (!((SKB_RFD_STATUS(skb,bddp) & 
	       __constant_cpu_to_le16(RFD_STATUS_COMPLETE)))){
	    break;
	}
    }
    /* No available buffers */
    if(skb == NULL){
	return;
    }
    spin_lock(&bdp->bd_lock);
    
    if(e100_wait_scb(bdp) == B_FALSE){
            printk("%s start_ru: wait_scb failed\n",
                   bdp->device->name);

    }
    writel(GET_SKB_DMA_ADDR(skb,bddp),&bddp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_RUC_START);
    if(bddp->next_cu_cmd == RESUME_NO_WAIT){
            bddp->next_cu_cmd = RESUME_WAIT;
    }
    spin_unlock(&bdp->bd_lock);
}


/* 
 * Procedure:   e100_cmd_complete_location
 *
 * Description: This routine returns a pointer to the location of the 
 *              command-complete DWord in the dump statistical counters area, 
 *              according to the statistical counters mode (557 - basic, 
 *              558 - extended, or 559 - TCO mode)
 *		see e100_configure() for the setting of the statistical 
 *              counters mode.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      pointer to the command complete dword.
 *
 */
static uint32_t *
e100_cmd_complete_location (bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp; 
    uint32_t	   *pcmd_complete;
	
    switch (bddp->stat_mode) {
    case E100_EXTENDED_STATS:
      pcmd_complete = (__u32 *)&(((perr_cntr_558_t)
				  (bddp->pstats_counters))->cmd_complete);
	    break;
    case E100_TCO_STATS:
      pcmd_complete = (__u32 *)&(((perr_cntr_559_t)
				  (bddp->pstats_counters))->cmd_complete);
	    break;
    case E100_BASIC_STATS:
    default:      /* should never happen ! just return something safe */
      pcmd_complete = (__u32 *)
	    &(((perr_cntr_557_t)(bddp->pstats_counters))->cmd_complete);
	    break;
    }
    return pcmd_complete;
}

/* 
 * Procedure:   e100_clr_cntrs
 *
 * Description: This routine will clear the adapter error statistic 
 *              counters.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      B_TRUE  - If successfully cleared stat counters
 *      B_FALSE - If command failed to complete properly
 *
 */
static          boolean_t
e100_clr_cntrs(bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */
    int             timeout;
    uint32_t	    *pcmd_complete;
    
    /* clear the dump counter complete word */
    pcmd_complete = e100_cmd_complete_location (bdp);
    *pcmd_complete = 0;
    
    if (e100_wait_scb(bdp) != B_TRUE)
        return (B_FALSE);

    writel(bddp->stat_cnt_paddr,&bddp->scbp->scb_gen_ptr);
    
    /* Issue the load dump counters address command */
    e100_exec_cmd(bdp, SCB_CUC_DUMP_ADDR);
    
    /* wait for the cmd to be fetched */
    if (e100_wait_scb(bdp) != B_TRUE)
        return (B_FALSE);

    /* wait 10 microseconds for the command to complete */
    udelay(10);
    
    /* Now dump and reset all of the statistics */
    e100_exec_cmd(bdp, SCB_CUC_DUMP_RST_STAT);
    
    /* Now wait for the dump/reset to complete */
    if (bddp->next_cu_cmd == RESUME_NO_WAIT) {
        bddp->next_cu_cmd = RESUME_WAIT;
    }
    
    timeout = 1000*500;
    E100_WAIT_FOR_CONDITION(timeout,
                            (*pcmd_complete == 
                             cpu_to_le32(DUMP_RST_STAT_COMPLETED)));

    if (timeout <= 0) {
	return (B_FALSE);
    }
    
    return (B_TRUE);
}


static boolean_t e100_update_stats(bd_config_t *bdp)
{
    bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */
    uint32_t	    *pcmd_complete;
    basic_cntr_t *pstat = &(bddp->pstats_counters->basic_stats);

    // check if last dump command completed
    pcmd_complete = e100_cmd_complete_location (bdp);
    if(*pcmd_complete != le32_to_cpu(DUMP_RST_STAT_COMPLETED) &&
       *pcmd_complete != le32_to_cpu(DUMP_STAT_COMPLETED)){
            return B_FALSE;
    }
    /* increment the staticitcs */
    bddp->perr_stats->gd_xmits        += le32_to_cpu(pstat->xmt_gd_frames);
    bddp->perr_stats->gd_recvs        += le32_to_cpu(pstat->rcv_gd_frames);
    bddp->perr_stats->tx_abrt_xs_col  += le32_to_cpu(pstat->xmt_max_coll);
    bddp->perr_stats->tx_late_col     += le32_to_cpu(pstat->xmt_late_coll);
    bddp->perr_stats->tx_dma_urun     += le32_to_cpu(pstat->xmt_uruns);
    bddp->perr_stats->tx_lost_csrs    += le32_to_cpu(pstat->xmt_lost_crs);
    bddp->perr_stats->tx_ok_defrd     += le32_to_cpu(pstat->xmt_deferred);
    bddp->perr_stats->tx_one_retry    += le32_to_cpu(pstat->xmt_sngl_coll);
    bddp->perr_stats->tx_mt_one_retry += le32_to_cpu(pstat->xmt_mlt_coll);
    bddp->perr_stats->tx_tot_retries  += le32_to_cpu(pstat->xmt_ttl_coll);
    bddp->perr_stats->rcv_crc_err     += le32_to_cpu(pstat->rcv_crc_errs);
    bddp->perr_stats->rcv_align_err   += le32_to_cpu(pstat->rcv_algn_errs);
    bddp->perr_stats->rcv_rsrc_err    += le32_to_cpu(pstat->rcv_rsrc_err);
    bddp->perr_stats->rcv_dma_orun    += le32_to_cpu(pstat->rcv_oruns);
    bddp->perr_stats->rcv_cdt_frames  += le32_to_cpu(pstat->rcv_err_coll);
    bddp->perr_stats->rcv_runts       += le32_to_cpu(pstat->rcv_shrt_frames);

    if (bddp->stat_mode != E100_BASIC_STATS) {
      ext_cntr_t *pex_stat = &bddp->pstats_counters->extended_stats;
      bddp->perr_stats->xmt_fc_pkts        += le32_to_cpu(pex_stat->xmt_fc_frames);
      bddp->perr_stats->rcv_fc_pkts        += le32_to_cpu(pex_stat->rcv_fc_frames);
      bddp->perr_stats->rcv_fc_unsupported += le32_to_cpu(pex_stat->rcv_fc_unsupported);
    }

    if (bddp->stat_mode == E100_TCO_STATS) {  
      tco_cntr_t *ptco_stat = &bddp->pstats_counters->tco_stats;
        bddp->perr_stats->xmt_tco_pkts += le16_to_cpu(ptco_stat->xmt_tco_frames);
        bddp->perr_stats->rcv_tco_pkts += le16_to_cpu(ptco_stat->rcv_tco_frames);
    }

    *pcmd_complete = 0;
    return B_TRUE;
}


/* 
 * Procedure:   e100_dump_stat_cntrs
 *
 * Description: This routine will dump the board statistical counters without waiting
 * for stat_dump to complete. Any access to this stats should verify the completion
 * of the command 
 *
 * Arguments:
 *      bdp -          Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NONE
 */
void
e100_dump_stats_cntrs(bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */
    unsigned long   lock_flag_bd;

    spin_lock_irqsave(&(bdp->bd_lock), lock_flag_bd);

    /* dump h/w stats counters */
   if(e100_wait_exec_cmd(bdp, SCB_CUC_DUMP_RST_STAT) == B_TRUE){
           if(bddp->next_cu_cmd == RESUME_NO_WAIT){
                   bddp->next_cu_cmd = RESUME_WAIT;
           }
   }
   
   spin_unlock_irqrestore(&(bdp->bd_lock), lock_flag_bd);

    return;
}



/* 
 * Procedure:   e100_exec_non_cu_cmd
 *
 * Description: This routine will submit a command block to be executed,
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 */

void e100_exec_non_cu_cmd(bd_config_t * bdp)
{

    pcb_header_t    pntcb_hdr;
    pntcb_hdr = (pcb_header_t) bdp->bddp->pntcb;   /* get hdr of non tcb cmd */

    /* Set the Command Block to be the last command block */
    pntcb_hdr->cb_cmd |= __constant_cpu_to_le16(CB_EL_BIT);

    pntcb_hdr->cb_status = 0;

    /* Start the command unit. */
    e100_exec_cmd(bdp, SCB_CUC_START);

}

/* 
 * Procedure:   e100_poll_cmd
 *
 * Description: This routine will wait for the completion of
 * 		a non-tx command.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns: B_FALSE - if command not completed with in 100 msec
 *	    B_TRUE - if otherwise
 *			
 */

boolean_t e100_poll_cmd(bd_config_t *bdp)
{
    uint_t          delay;
    boolean_t       status = 0;
    pcb_header_t    pntcb_hdr;

    pntcb_hdr = (pcb_header_t) bdp->bddp->pntcb;   /* get hdr of non tcb cmd */
    
    /* Wait 100ms for some status */
    for (delay = 0; delay < 20; delay++) {
        mdelay(1);

        if ((pntcb_hdr->cb_status &
	     __constant_cpu_to_le16(CB_STATUS_COMPLETE))) {
            status = TRUE;
            break;
        } else {
            status = FALSE;
        }
    }

    if (delay == 20) {
        return (B_FALSE);
    }

    return (status);
}



/* 
 * Procedure:    e100_wait_scb
 *
 * Description: This routine checks to see if the e100 has accepted a command.
 *              It does so by checking the command field in the SCB, which will
 *              be zeroed by the e100 upon accepting a command.  The loop waits
 *              for up to 30 milliseconds for command acceptance.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      B_TRUE if the SCB cleared within 5 milliseconds.
 *      B_FALSE if it didn't clear within 5 milliseconds
 */
boolean_t
e100_wait_scb(bd_config_t * bdp)
{
    int          wait_count = 5000; 
    bdd_t       *bddp = bdp->bddp;   /* stores all adapter specific info */

    do {
        if (!readb(&bddp->scbp->scb_cmd_low))
            return B_TRUE;

        udelay(1);
    }
    while (wait_count--);

    return B_FALSE;
}


/* 
 * Procedure:   e100_sw_reset
 *
 * Description: This routine will issue a software reset to the adapter.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *        reset_cmd - s/w reset or selective reset. 
 *
 * Returns:
 */
void
e100_sw_reset(bd_config_t * bdp, uint32_t reset_cmd)
{
    bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */

    /* Issue a PORT command with a data word of 0 */
    writel(reset_cmd,&bddp->scbp->scb_port);

    /* wait for the reset to take effect */
    udelay(20);
    // a selective reset is required to avoid a potential
    // PCI hang
    if(reset_cmd == PORT_SOFTWARE_RESET){
	    writel(PORT_SOFTWARE_RESET,&bddp->scbp->scb_port);
	    /* wait 20 micro seconds for the reset to take effect */
	    udelay(20);

    }

    /* Mask off our interrupt line -- its unmasked after reset */
    e100_dis_intr(bdp);

    return;
}




/* 
 * Procedure:   e100_load_microcode
 *
 * Description: This routine downloads microcode on to the controller. This
 *      microcode is available for the 82558/9. The microcode
 *      reduces the number of receive interrupts by "bundling" them. The amount
 *      of reduction in interrupts is configurable thru a command line parameter.
 *
 * Arguments:
 *      bdp      - Pointer to this device's board config.
 *      rev_id  - Revision ID of the board.
 *
 * Returns: B_TRUE - Success
 *              B_FALSE - Failure
 *
 */
static boolean_t
e100_load_microcode(bd_config_t * bdp, uint8_t rev_id)
{
        uint_t          i;
        uint_t          microcode_length;
        bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */
        pcb_header_t    pntcb_hdr;

        static uint32_t  d101a_ucode   [] = D101_A_RCVBUNDLE_UCODE;
        static uint32_t  d101b0_ucode  [] = D101_B0_RCVBUNDLE_UCODE;
        static uint32_t  d101ma_ucode  [] = D101M_B_RCVBUNDLE_UCODE;
        static uint32_t  d101s_ucode   [] = D101S_RCVBUNDLE_UCODE;
        static uint32_t  d102_ucode    [] = D102_B_RCVBUNDLE_UCODE;
	static uint32_t  d102_tco_ucode[] =	D102_B_TCO_UCODE;
        static uint32_t  d102c_ucode   [] = D102_C_RCVBUNDLE_UCODE;
	uint32_t		*mlong;//convenient variable to hold the uCode.
        uint16_t        *mshort;//convenient viriable to hold the uCode.
	//relative pointer in the uCode to the dead man timer word. 
        uint16_t         cpusaver_dword;
	//relative pointer in the uCode to the bundle max word.
	uint16_t	     cpusaver_bundle_max_dword = 1;	

        /* user turned ucode loading off */
        if (!ucode[bdp->bd_number])
                return B_FALSE;
        /* this chips do not need ucode */
        if ((bddp->flags & IS_ICH) ||  (bdp->rev_id < D101A4_REV_ID)) {
                return B_FALSE;
        }


        /* Decide which ucode to use by looking at the board's rev_id */
	switch(rev_id){
			
        case(D101A4_REV_ID):
        	mshort = (uint16_t *) d101a_ucode;
                mlong  = 			  d101a_ucode;
        	microcode_length = D101_NUM_MICROCODE_DWORDS;
        	cpusaver_dword 	 = D101_CPUSAVER_DWORD;
                break;

        case(D101B0_REV_ID):
        	mshort = (uint16_t *) d101b0_ucode;
                mlong  = 			  d101b0_ucode;
        	microcode_length = D101_NUM_MICROCODE_DWORDS;
        	cpusaver_dword   = D101_CPUSAVER_DWORD;
                break;

        case(D101MA_REV_ID):
        	mshort = (uint16_t *) d101ma_ucode;
                mlong  = 			  d101ma_ucode;
        	microcode_length = D101M_NUM_MICROCODE_DWORDS;
        	cpusaver_dword   = D101M_CPUSAVER_DWORD;
                cpusaver_bundle_max_dword =
                        D101M_CPUSAVER_BUNDLE_MAX_DWORD;	
                break;

        case(D101S_REV_ID):
        	mshort = (uint16_t *) d101s_ucode;
                mlong  = 			  d101s_ucode;
        	microcode_length = D101S_NUM_MICROCODE_DWORDS;
        	cpusaver_dword   = D101S_CPUSAVER_DWORD;
                cpusaver_bundle_max_dword =
                        D101S_CPUSAVER_BUNDLE_MAX_DWORD;	
                break;

        case(D102_REV_ID):
                if(TcoWA[bdp->bd_number]){
        		mshort = (uint16_t *) d102_tco_ucode;
                        mlong  = 			  d102_tco_ucode;
                }
                else{
        		mshort = (uint16_t *) d102_ucode;
                        mlong  = 			  d102_ucode;;
                }
        	microcode_length = D102_NUM_MICROCODE_DWORDS;
        	cpusaver_dword   = D102_B_CPUSAVER_DWORD;
                cpusaver_bundle_max_dword =
                        D102_B_CPUSAVER_BUNDLE_MAX_DWORD;	
                break;
  
        case(D102C_REV_ID):
        	mshort = (uint16_t *) d102c_ucode;
                mlong  = 			  d102c_ucode;
        	microcode_length = D102C_NUM_MICROCODE_DWORDS;
        	cpusaver_dword   = D102_C_CPUSAVER_DWORD;
                cpusaver_bundle_max_dword =
                        D102_C_CPUSAVER_BUNDLE_MAX_DWORD;	
                break;

        default:
        	return B_FALSE;      /* we don't have ucode for this board */
    
        } //end switch(rev_id)

        /* Get the tunable value from e100.c and stick in in the right spot */
        mshort[cpusaver_dword * 2] = IntDelay[bdp->bd_number];

        /* Get tunable parameter for maximum number of * frames that will be
         * bundled (from revison D101M and later). 
         */
        if (rev_id >= D101MA_REV_ID)
                mshort[cpusaver_bundle_max_dword * 2] =	BundleMax[bdp->bd_number];

        /* Setup the non-transmit command block header for the command. */
        pntcb_hdr = (pcb_header_t) bddp->pntcb;   /* get hdr of non tcb cmd */
	pntcb_hdr->cb_status = 0;
        pntcb_hdr->cb_cmd = __constant_cpu_to_le16(CB_LOAD_MICROCODE);
        /* Note: cb_lnk_ptr is a physical address stored in an unsigned long */
        pntcb_hdr->cb_lnk_ptr = 0;

        /* Copy in the microcode */
        for (i = 0; i < microcode_length; i++)
                bddp->pntcb->ntcb.load_ucode.ucode_dword[i] = cpu_to_le32(mlong[i]);

        /* Wait for the SCB command word to clear before we set the * general
         * pointer */
        if (e100_wait_scb(bdp) != B_TRUE)
                return (B_FALSE);

        i = 0;
        while (((readw(&bddp->scbp->scb_status) & SCB_CUS_MASK) == SCB_CUS_ACTIVE)
               && (i < 5)) {
                mdelay(20);
                i++;
        }
        if (i == 5) {
                return (B_FALSE);
        }
        bddp->next_cu_cmd = START_WAIT;

        /* Update the command list pointer.  */
        writel( bddp->nontx_paddr,&bddp->scbp->scb_gen_ptr);

        /* store the command */

        /* Submit the Load microcode command to the chip, and wait for it * to
         * complete. */
        e100_exec_non_cu_cmd(bdp);
        if (!e100_poll_cmd(bdp))
                return (B_FALSE);
        else
                return (B_TRUE);
}

/***************************************************************************/
/***************************************************************************/
/*       EEPROM  Functions                                                 */
/***************************************************************************/

/* 
 * Procedure:   e100_rd_pwa_no
 *
 * Description: read pwa (printed wired assembly) number
 */
void 
e100_rd_pwa_no(bd_config_t * bdp)
{
    bdd_t *bddp = (bdd_t *) bdp->bddp;

    bddp->pwa_no = ReadEEprom(bdp, EEPROM_PWA_NO);
    bddp->pwa_no <<= 16;
    bddp->pwa_no |= ReadEEprom(bdp, EEPROM_PWA_NO+1);
}


/* 
 * Procedure:   e100_rd_eaddr 
 *
 * Description: Reads the permanent ethernet address from the eprom.
 * 
 * Arguments: 
 *      bdp - Ptr to this card's e100_bdconfig structure
 * 
 * Returns: (none) 
 */
void
e100_rd_eaddr(bd_config_t * bdp)
{
    int             i;
    uint16_t        EepromWordValue;
    bdd_t          *bddp = (bdd_t *) bdp->bddp;

    for (i = 0; i < 6; i += 2) {
        EepromWordValue =
            ReadEEprom(bdp, EEPROM_NODE_ADDRESS_BYTE_0 + (i / 2));

        /* added code to set the perm_address in bddp */
        bdp->device->dev_addr[i] =
            bddp->perm_node_address[i] = (uint8_t) EepromWordValue;
        bdp->device->dev_addr[i + 1] =
            bddp->perm_node_address[i + 1] = (uint8_t) (EepromWordValue >> 8);
    }
    
    return;
}


 

/***************************************************************************/
/***************************************************************************/
/*       PHY Functions                                                     */
/***************************************************************************/


/* 
 * Procedure:   PhyDetect
 *
 * Description: This routine will detect what phy we are using, set the line
 *              speed, FDX or HDX, and configure the phy if necessary.
 *
 *              The following combinations are supported:
 *              - TX or T4 PHY alone at PHY address 1
 *              - T4 or TX PHY at address 1 and MII PHY at address 0
 *              - 82503 alone (10Base-T mode, no full duplex support)
 *              - 82503 and MII PHY (TX or T4) at address 0
 *
 *              The sequence / priority of detection is as follows:
 *              - PHY 1 with cable termination
 *              - PHY 0 with cable termination
 *              - PHY 1 (if found) without cable termination
 *              - 503 interface
 *
 *              Additionally auto-negotiation capable (NWAY) and parallel
 *              detection PHYs are supported. The flow-chart is described*/
boolean_t
e100_phydetect(bd_config_t * bdp)
{
    uint_t          CurrPhy;
    uint_t          Phy1;
    uint16_t        MdiControlReg, MdiStatusReg;
    uint8_t         ReNegotiateTime = 35;
    bdd_t          *bddp;
    int             old_speed_duplex;
    int             board_speed_duplex;

    board_speed_duplex = e100_speed_duplex[bdp->bd_number];

    bddp = (pbdd_t) bdp->bddp;   /* get the bddp for this board */
    Phy1 = 0;

    /* Check for a phy from address 1 - 31 */
    for (CurrPhy = 1; CurrPhy <= MAX_PHY_ADDR; CurrPhy++) {
        /* Read the MDI control register at CurrPhy. */
        e100_MdiRead(bdp, MDI_CONTROL_REG, CurrPhy, &MdiControlReg);

        /* Read the status register at phy 1 */
        e100_MdiRead(bdp, MDI_STATUS_REG, CurrPhy, &MdiStatusReg);

        /* check if we found a valid phy */
        if (!((MdiControlReg == 0xffff) ||
            ((MdiStatusReg == 0) && (MdiControlReg == 0)))) {
            /* we have a valid phy1 */
            Phy1 = CurrPhy;

            /* Read the status register again because of sticky bits */
            e100_MdiRead(bdp, MDI_STATUS_REG, CurrPhy, &MdiStatusReg);

            /* If there is a valid link then use this Phy. */
            if (MdiStatusReg & MDI_SR_LINK_STATUS) {
                /* Mark link up */
                bdp->flags |= DF_LINK_UP;
#ifdef IANS             
                bdp->cur_link_status = IANS_STATUS_LINK_OK;
#endif

                bdp->phy_addr = Phy1;

                return (e100_SetupPhy(bdp));
            }
            /* found a valid phy without a link, so break */
            break;
        }
    }

    /* 
     * Next try to detect a PHY at address 0x00 because there was no Phy 1, 
     * or Phy 1 didn't have link
     */

    /* Read the MDI control register at phy 0 */
    e100_MdiRead(bdp, MDI_CONTROL_REG, 0, &MdiControlReg);

    /* Read the status register at phy 0 */
    e100_MdiRead(bdp, MDI_STATUS_REG, 0, &MdiStatusReg);

    /* check if we found a valid phy 0 */
    if ((MdiControlReg == 0xffff) ||
        ((MdiStatusReg == 0) && (MdiControlReg == 0))) {
        /* we don't have a valid phy at address 0 */

        if (Phy1) {
            /* no phy 0, so use phy 1 */
            bdp->phy_addr = Phy1;

            /* no phy 0, but there is a phy 1, so use phy 1 */
            return (e100_SetupPhy(bdp));
        } else {
            /* didn't find phy 0 or phy 1, so assume a 503 interface */
            bdp->phy_addr = 32;

            /* 
             *    This fix is for the board which has the 503 interface
             *    and need to have the speed and duplex mode set here.  The only
             *    way for a user to get a FULL duplex setting is to have it forced
             *    in the e100.c file.
             *
             *    The second test is for an invalid setting for the hardware.
             */
            /* The adapter can't autoneg. so set to 10/HALF */
            if (board_speed_duplex == 0) {
                old_speed_duplex = board_speed_duplex;
                board_speed_duplex = e100_speed_duplex[bdp->bd_number] = 1;
                e100_ForceSpeedAndDuplex(bdp);
                /* Restore speed_duplex value. */
                board_speed_duplex = e100_speed_duplex[bdp->bd_number] =
                    old_speed_duplex;
            }
            else if ((board_speed_duplex == 1)
                || (board_speed_duplex == 2)) {
                e100_ForceSpeedAndDuplex(bdp);
            } else if (board_speed_duplex > 2) {
                printk(KERN_ERR "503 serial component detected which does not "
		       "support 100Mbps.\n");
                printk(KERN_ERR "Change the forced speed/duplex "
		       "to a supported setting.\n");
                return (B_FALSE);
            }

            return (B_TRUE);
        }
    } else {
        /* We have a valid phy at address 0.  If phy 0 has a link then * we
         * use phy 0.  If Phy 0 doesn't have a link then we use Phy 1 * (
         * which also doesn't have a link ) if phy 1 is present, else use *
         * phy 0 if phy 1 is not present */
        /* If phy 1 was present, then we must isolate phy 1 before we *
         * enable phy 0 to see if Phy 0 has a link. */
        if (Phy1) {
            /* isolate phy 1 */
            e100_MdiWrite(bdp, MDI_CONTROL_REG, Phy1, MDI_CR_ISOLATE);

            /* wait 100 milliseconds for the phy to isolate. */
            udelay(200);
        }

#ifdef PHY_NC3133
        if ((bdp->sub_ven_id == 0x0E11) &&
            (bdp->sub_dev_id == 0xB0E1)) {
            uint16_t        MdiIntReg;

            bdp->phy_addr = 0;

            /* Compaq NC3133 100BASE FX adapter module; will always be at */
            /* Phy address 0; unisolate Phy 0                             */
            e100_MdiRead(bdp, MDI_CONTROL_REG, bdp->phy_addr, &MdiControlReg);
            MdiControlReg &= ~MDI_CR_ISOLATE;
            e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr, MdiControlReg);
            mdelay(100);

            /* enable 100BASE fiber interface */
            e100_MdiWrite(bdp, MDI_NC3133_CONFIG_REG, bdp->phy_addr,
                          MDI_NC3133_100FX_ENABLE);

            if ((e100_speed_duplex[bdp->bd_number] != 0) &&
                (e100_speed_duplex[bdp->bd_number] != 4)) {
                /* just inform user about 100 full */
                printk(KERN_ERR
                       "NC3133 NIC can only run at 100Mbps full duplex.\n");
            }

            e100_speed_duplex[bdp->bd_number] = 4; /* 100 full */
            e100_ForceSpeedAndDuplex(bdp);

            /* enable interrupts */
            e100_MdiRead(bdp, MDI_NC3133_INT_ENABLE_REG,
                         bdp->phy_addr, &MdiIntReg);
            MdiIntReg |= MDI_NC3133_INT_ENABLE;
            e100_MdiWrite(bdp, MDI_NC3133_INT_ENABLE_REG,
                          bdp->phy_addr, MdiIntReg);

            /* link status is latched low, so read twice */
            /* to get the real status...                 */
            e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &MdiStatusReg);
            e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &MdiStatusReg);
            if (MdiStatusReg & MDI_SR_LINK_STATUS) {
                bdp->flags |= DF_LINK_UP;
            
            } else {
                bdp->flags &= ~DF_LINK_UP;
                bddp->flags |= INVALID_SPEED_DPLX;
            }

            return (e100_SetupPhy(bdp)); 
        }
#endif /* PHY_NC3133 */

        /* Since this Phy is at address 0, we must enable it.  So clear */
        /* the isolate bit, and set the auto-speed select bit */
        e100_MdiWrite(bdp, MDI_CONTROL_REG, 0, MDI_CR_AUTO_SELECT);

        /* wait 100 milliseconds for the phy to be enabled. */
        udelay(200);

        /* restart the auto-negotion process */
        e100_MdiWrite(bdp, MDI_CONTROL_REG, 0,
            MDI_CR_RESTART_AUTO_NEG | MDI_CR_AUTO_SELECT);

        /* wait no more than 3.5 seconds for auto-negotiation to complete */
        while (ReNegotiateTime) {
            /* Read the status register twice because of sticky bits */
            e100_MdiRead(bdp, MDI_STATUS_REG, 0, &MdiStatusReg);
            e100_MdiRead(bdp, MDI_STATUS_REG, 0, &MdiStatusReg);

            if (MdiStatusReg & MDI_SR_AUTO_NEG_COMPLETE)
                break;

            mdelay(10);
            ReNegotiateTime--;
        }

        /* Read the status register again because of sticky bits */
        e100_MdiRead(bdp, MDI_STATUS_REG, 0, &MdiStatusReg);

        /* Mark link up */
        if (MdiStatusReg & MDI_SR_LINK_STATUS)
        {
#ifdef IANS
            bdp->cur_link_status = IANS_STATUS_LINK_OK;
#endif
            bdp->flags |= DF_LINK_UP;
        }

        /* If the link was not set */
        if (!(MdiStatusReg & MDI_SR_LINK_STATUS)) {
            /* the link wasn't set, so use phy 1 if phy 1 was present */
            if (Phy1) {
                /* isolate phy 0 */
                e100_MdiWrite(bdp, MDI_CONTROL_REG, 0, MDI_CR_ISOLATE);

                /* wait for the phy to isolate. */
                udelay(100);

                /* Now re-enable PHY 1 */
                e100_MdiWrite(bdp, MDI_CONTROL_REG, Phy1,
                    MDI_CR_AUTO_SELECT);

                /* wait 100 milliseconds for the phy to be enabled. */
                udelay(100);
                
                /* restart the auto-negotion process */
                e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr,
                    MDI_CR_RESTART_AUTO_NEG |
                    MDI_CR_AUTO_SELECT);

                bdp->phy_addr = Phy1;

                /* Don't wait for it 2 complete (no link from earlier) */
                return (e100_SetupPhy(bdp));
            }

        }

        /* Definitely using Phy 0 */
        bdp->phy_addr = 0;

        return (e100_SetupPhy(bdp));
    }
}


/* 
 * Procedure:   e100_SetupPhy
 *
 * Description: This routine will setup phy 1 or phy 0 so that it is configured
 *              to match line speed.  This driver assumes assume the adapter 
 *        is automatically setting the line speed, and the duplex mode. 
 *        At the end of this routine, any truly Phy specific code will 
 *        be executed (each Phy has its own quirks, and some require 
 *        that certain special bits are set).
 *
 *   NOTE:  The driver assumes that SPEED and FORCEFDX are specified at the
 *          same time. If FORCEDPX is set without speed being set, the driver
 *          will encouter a fatal error.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Result:
 * Returns:
 *      B_TRUE  - If the phy could be configured correctly
 *      B_FALSE - If the phy couldn't be configured correctly, because an 
 *           */
static          boolean_t
e100_SetupPhy(bd_config_t * bdp)
{
    uint16_t        MdiIdLowReg, MdiIdHighReg;
    uint16_t        MdiMiscReg;
    uint_t          PhyId;
    bdd_t          *bddp;
    int             board_speed_duplex;

    board_speed_duplex = e100_speed_duplex[bdp->bd_number];

    bddp = (pbdd_t) bdp->bddp;   /* get the bddp for this board */

    /* Find out specifically what Phy this is.  We do this because for *
     * certain phys there are specific bits that must be set so that the *
     * phy and the 82557 work together properly. */

    e100_MdiRead(bdp, PHY_ID_REG_1, bdp->phy_addr, &MdiIdLowReg);
    e100_MdiRead(bdp, PHY_ID_REG_2, bdp->phy_addr, &MdiIdHighReg);

    PhyId = ((uint_t) MdiIdLowReg | ((uint_t) MdiIdHighReg << 16));

    bdp->PhyState = 0;
    bdp->PhyDelay = 0;

    /* get the revsion field of the Phy ID so that we'll be able to detect */
    /* future revs of the same Phy. */
    PhyId &= PHY_MODEL_REV_ID_MASK;
    bdp->PhyId = PhyId;     

    /* If Intel Phy, set flag to indicate this */
    if (PhyId == PHY_82555_TX) {
        bdp->flags |= DF_PHY_82555;
    }

    /* Handle the National TX */
    if (PhyId == PHY_NSC_TX) {
        e100_MdiRead(bdp, NSC_CONG_CONTROL_REG, bdp->phy_addr,
            &MdiMiscReg);

        MdiMiscReg |= NSC_TX_CONG_TXREADY;

        /* If we are configured to do congestion control, then enable the */
        /* congestion control bit in the National Phy */
        if (e100_cong_enbl)
            MdiMiscReg |= NSC_TX_CONG_ENABLE;
        else
            MdiMiscReg &= ~NSC_TX_CONG_ENABLE;

        e100_MdiWrite(bdp, NSC_CONG_CONTROL_REG, bdp->phy_addr,
            MdiMiscReg);
    }

    if ((board_speed_duplex >= 1) && (board_speed_duplex <= 4))
        e100_ForceSpeedAndDuplex(bdp);

    /* Set bddp values for speed and duplex modes only if autonegotiation *
     * happened. If it was forced, the bddp values would have been set by *
     * the ForceSpeedAndUplex routine. If it isn't then we need to check * to 
     * see if autoneg has completed and if we need to restart it. */
    if (!((board_speed_duplex >= 1) && (board_speed_duplex <= 4))) {
        e100_auto_neg(bdp);
        e100_FindPhySpeedAndDpx(bdp, PhyId);
    }
    return (B_TRUE);
}



/* 
 * Procedure:   e100_fix_polarity
 *
 * Description:
 *      Fix for 82555 auto-polarity toggle problem. With a short cable 
 *      connecting an 82555 with an 840A link partner, if the medium is noisy,
 *      the 82555 sometime thinks that the polarity might be wrong and so 
 *      toggles polarity. This happens repeatedly and results in a high bit 
 *      error rate.
 *      NOTE: This happens only at 10 Mbps
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NOTHING
 */
void
e100_fix_polarity (bd_config_t * bdp)
{
    bdd_t          *bddp = (bdd_t *) bdp->bddp;
    unsigned long   PhyAdd;
    unsigned short  Status;
    unsigned short  errors;
    int             speed;

    PhyAdd = bdp->phy_addr;

    /* If the user wants auto-polarity disabled, do only that and nothing *
     * else. * e100_autopolarity == 0 means disable --- we do just the
     * disabling * e100_autopolarity == 1 means enable  --- we do nothing at
     * all * e100_autopolarity >= 2 means we do the workaround code. */
    /* Change for 82558 enhancement */
    if (!(bddp->flags & IS_BACHELOR)) {
        if (e100_autopolarity == 0) {
            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL,
                PhyAdd, DISABLE_AUTO_POLARITY);
        } else if (e100_autopolarity >= 2) {
            /* we do this only if we have an 82555 and if link is up */
            if ((bdp->flags & DF_PHY_82555) && (bdp->flags & DF_LINK_UP)) {
                
                e100_MdiRead(bdp, PHY_82555_CSR, PhyAdd, &Status);
                speed = (Status & PHY_82555_SPEED_BIT) ? 100 : 10;

                /* we need to do this only if speed is 10 */
                if (speed == 10) {
                    /* see if we have any end of frame errors */
                    e100_MdiRead(bdp, PHY_82555_EOF_COUNTER, PhyAdd, &errors);

                    /* if non-zero, wait for 100 ms before reading again */
                    if (errors) {
                        udelay(200);
                        e100_MdiRead(bdp, PHY_82555_EOF_COUNTER, PhyAdd, &errors);

                        /* if non-zero again, we disable polarity */
                        if (errors) {
                            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL,
                                PhyAdd, DISABLE_AUTO_POLARITY);
                        }
                    } else {
                        /* it is safe to read the polarity now */
                        e100_MdiRead(bdp, PHY_82555_CSR, PhyAdd, &Status);

                        /* if polarity is normal, disable polarity */
                        if (!(Status & PHY_82555_POLARITY_BIT)) {
                            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL,
                                PhyAdd, DISABLE_AUTO_POLARITY);
                        }
                    }
                }            /* end if speed == 10 */
            }               /* end if PHY 82555 */
        }                  /* end of polarity fix */
    }

    
}


/* 
 * Procedure:   e100_auto_neg
 *
 * Description: This routine will start autonegotiation and wait
 *                   for it to complete
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NOTHING
 */
void
e100_auto_neg(bd_config_t * bdp)
{
    uint16_t        mdi_status_reg;
    bdd_t          *bddp = bdp->bddp;
    uint_t          i;
    wait_queue_head_t event;
    /* first we need to check to see if autoneg has already completed. Sticky 
     * so read twice */
    e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &(mdi_status_reg));
    e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &(mdi_status_reg));
    /* if it is finished then leave */
    if (mdi_status_reg & MDI_SR_AUTO_NEG_COMPLETE) {
        return;
    }

    /* if we are capable of performing autoneg then we restart */
    if (mdi_status_reg & MDI_SR_AUTO_SELECT_CAPABLE) {
        e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr,
            MDI_CR_AUTO_SELECT | MDI_CR_RESTART_AUTO_NEG);

        init_waitqueue_head(&event);
        /* now wait for autoneg to complete this could be up to 3 seconds */
        for (i = 0; 
             (!(mdi_status_reg & MDI_SR_AUTO_NEG_COMPLETE)) &&(i < 60); i++) {
            /* delay 10 milliseconds */
                sleep_on_timeout(&event,E100_MAX(HZ/20,1)); // at least 50 ms

            /* now re-read the value. Sticky so read twice */
            e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr,
                &(mdi_status_reg));
            e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr,
                &(mdi_status_reg));
        }
        if (i >= 60)
	    bddp->flags |= INVALID_SPEED_DPLX;
    }
    return;
}



/* 
 * Procedure:   e100_FindPhySpeedAndDpx
 *
 * Description: This routine will figure out what line speed and duplex mode
 *              the PHY is currently using.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *      PhyId - The ID of the PHY in question.
 *
 * Returns:
 *      NOTHING
 */
void
e100_FindPhySpeedAndDpx(bd_config_t * bdp, uint_t PhyId)
{
    uint16_t        MdiStatusReg;
    uint16_t        MdiMiscReg;
    uint16_t        MdiOwnAdReg;
    uint16_t        MdiLinkPartnerAdReg;
    bdd_t          *bddp = bdp->bddp;

    /* First we should check to see if we have link */
    /* If we don't have link no reason to print a speed and duplex */
    if ( e100_GetPhyLinkState(bdp) == B_FALSE ) {
        bddp->cur_line_speed = 0;
        bddp->cur_dplx_mode = NO_DUPLEX;
        return;
    }

    /* Check if the PHY was already forced */
    if (bdp->flags & DF_SPEED_FORCED) {
        switch (e100_speed_duplex[bdp->bd_number]) {
        case 1:
            bddp->cur_line_speed = 10;
            bddp->cur_dplx_mode = HALF_DUPLEX;
            break;
            
        case 2:
            bddp->cur_line_speed = 10;
            bddp->cur_dplx_mode = FULL_DUPLEX;
            break;
            
        case 3:
            bddp->cur_line_speed = 100;
            bddp->cur_dplx_mode = HALF_DUPLEX;
            break;
            
        case 4:
            bddp->cur_line_speed = 100;
            bddp->cur_dplx_mode = FULL_DUPLEX;
            break;
        }
        
        return;
    }

    /* On the 82559 and later controllers, speed/duplex is part of the *
     * SCB. So, we save an MdiRead and get these from the SCB. * */
    if ((bdp->rev_id >= 8) || (bddp->flags & IS_ICH)) {
        /* Read speed */
        if (readb(&bddp->scbp->scb_ext.d101m_scb.scb_gen_stat)
	    & BIT_1)
            bddp->cur_line_speed = 100;
        else
            bddp->cur_line_speed = 10;

        /* Read duplex */
        if (readb(&bddp->scbp->scb_ext.d101m_scb.scb_gen_stat)
	    & BIT_2)
            bddp->cur_dplx_mode = FULL_DUPLEX;
        else
            bddp->cur_dplx_mode = HALF_DUPLEX;

        return;
    }

    /* If this is a Phy 100, then read bits 1 and 0 of extended register 0,
     * * to get the current speed and duplex settings. */
    if ((PhyId == PHY_100_A) ||
        (PhyId == PHY_100_C) || (PhyId == PHY_82555_TX)) {
        /* Read Phy 100 extended register 0 */
        e100_MdiRead(bdp, EXTENDED_REG_0, bdp->phy_addr, &MdiMiscReg);

        /* Get current speed setting */
        if (MdiMiscReg & PHY_100_ER0_SPEED_INDIC)
            bddp->cur_line_speed = 100;
        else
            bddp->cur_line_speed = 10;

        /* Get current duplex setting -- if bit is set then FDX is enabled */
        if (MdiMiscReg & PHY_100_ER0_FDX_INDIC)
            bddp->cur_dplx_mode = FULL_DUPLEX;
        else
            bddp->cur_dplx_mode = HALF_DUPLEX;

        return;
    }

    /* See if link partner was capable of Auto-Negotiation (bit 0, reg 6) */
    e100_MdiRead(bdp, AUTO_NEG_EXPANSION_REG, bdp->phy_addr, &MdiMiscReg);

    /* See if Auto-Negotiation was complete (bit 5, reg 1) */
    e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &MdiStatusReg);

    /* If a True NWAY connection was made, then we can detect speed/dplx *
     * by ANDing our adapter's advertised abilities with our link partner's * 
     * advertised ablilities, and then assuming that the highest common *
     * denominator was chosed by NWAY. */
    if ((MdiMiscReg & NWAY_EX_LP_NWAY) &&
        (MdiStatusReg & MDI_SR_AUTO_NEG_COMPLETE)) {

        /* Read our advertisement register */
        e100_MdiRead(bdp, AUTO_NEG_ADVERTISE_REG, bdp->phy_addr,
            &MdiOwnAdReg);

        /* Read our link partner's advertisement register */
        e100_MdiRead(bdp, AUTO_NEG_LINK_PARTNER_REG, bdp->phy_addr,
            &MdiLinkPartnerAdReg);

        /* AND the two advertisement registers together, and get rid of any
         * * extraneous bits. */
        MdiOwnAdReg &= (MdiLinkPartnerAdReg & NWAY_LP_ABILITY);

        /* Get speed setting */
        if (MdiOwnAdReg &
            (NWAY_AD_TX_HALF_DPX | NWAY_AD_TX_FULL_DPX |
                NWAY_AD_T4_CAPABLE)) bddp->cur_line_speed = 100;
        else
            bddp->cur_line_speed = 10;

        /* Get duplex setting -- use priority resolution algorithm */
        if (MdiOwnAdReg & (NWAY_AD_T4_CAPABLE)) {
            bddp->cur_dplx_mode = HALF_DUPLEX;
            return;
        } else if (MdiOwnAdReg & (NWAY_AD_TX_FULL_DPX)) {
            bddp->cur_dplx_mode = FULL_DUPLEX;
            return;
        } else if (MdiOwnAdReg & (NWAY_AD_TX_HALF_DPX)) {
            bddp->cur_dplx_mode = HALF_DUPLEX;
            return;
        } else if (MdiOwnAdReg & (NWAY_AD_10T_FULL_DPX)) {
            bddp->cur_dplx_mode = FULL_DUPLEX;
            return;
        } else {
            bddp->cur_dplx_mode = HALF_DUPLEX;
            return;
        }
    }

    /* If we are connected to a dumb (non-NWAY) repeater or hub, and the line 
     * speed was determined automatically by parallel detection, then we have
     * no way of knowing exactly what speed the PHY is set to unless that PHY
     * has a propietary register which indicates speed in this situation.  The
     * NSC TX PHY does have such a register.  Also, since NWAY didn't establish
     * the connection, the duplex setting should HALF duplex. 
     */

    bddp->cur_dplx_mode = HALF_DUPLEX;

    if (PhyId == PHY_NSC_TX) {
        /* Read register 25 to get the SPEED_10 bit */
        e100_MdiRead(bdp, NSC_SPEED_IND_REG, bdp->phy_addr, &MdiMiscReg);

        /* If bit 6 was set then we're at 10Mbps */
        if (MdiMiscReg & NSC_TX_SPD_INDC_SPEED)
            bddp->cur_line_speed = 10;
        else
            bddp->cur_line_speed = 100;

    } else {
        /* If we don't know what line speed we are set at, then we'll default 
         * to 10Mbps */
        bddp->cur_line_speed = 10;
    }
}


/* 
 * Procedure: e100_ForceSpeedAndDuplex
 *
 * Description: This routine forces line speed and duplex mode of the
 * adapter based on the values the user has set in e100.c.
 *
 * Arguments:  bdp - Pointer to the bd_config_t structure for the board
 *
 * Returns: void
 *
 */
void
e100_ForceSpeedAndDuplex(bd_config_t * bdp)
{
    bdd_t          *bddp = (bdd_t *) bdp->bddp;
    uint16_t        control;
    int             board_speed_duplex;
    wait_queue_head_t event;
    int neg_timeout = 2*HZ; //2 sec in jiffies
    int sleep_time = E100_MAX(HZ/20,1) ;// at least 50 msec
    board_speed_duplex = e100_speed_duplex[bdp->bd_number];

    bdp->flags |= DF_SPEED_FORCED;
    e100_MdiRead(bdp, MDI_CONTROL_REG, bdp->phy_addr, &control);
    control &= ~MDI_CR_AUTO_SELECT;

    /* Check e100.c values */
    switch (board_speed_duplex) {
        /* 10 half */
    case 1:
        control &= ~MDI_CR_10_100;
        control &= ~MDI_CR_FULL_HALF;
        bddp->cur_line_speed = 10;
        bddp->cur_dplx_mode = HALF_DUPLEX;
        break;

        /* 10 full */
    case 2:
        control &= ~MDI_CR_10_100;
        control |= MDI_CR_FULL_HALF;
        bddp->cur_line_speed = 10;
        bddp->cur_dplx_mode = FULL_DUPLEX;
        break;

        /* 100 half */
    case 3:
        control |= MDI_CR_10_100;
        control &= ~MDI_CR_FULL_HALF;
        bddp->cur_line_speed = 100;
        bddp->cur_dplx_mode = HALF_DUPLEX;
        break;

        /* 100 full */
    case 4:
        control |= MDI_CR_10_100;
        control |= MDI_CR_FULL_HALF;
        bddp->cur_line_speed = 100;
        bddp->cur_dplx_mode = FULL_DUPLEX;
        break;
    }

    e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr, control);

    init_waitqueue_head(&event);
    do{
            sleep_on_timeout(&event, sleep_time);
            /* check if there's no link */
            if ( e100_GetPhyLinkState(bdp) == B_TRUE ) {
                    break;
            }
            neg_timeout -= sleep_time; // in msec
    }while(neg_timeout >0 );
    
    if(neg_timeout <= 0){
        bddp->cur_line_speed = 0;
        bddp->cur_dplx_mode = NO_DUPLEX;
        bddp->flags |= INVALID_SPEED_DPLX;
        return;
    }
}


/* 
 * Procedure: e100_phy_check
 * 
 * Arguments:  bdp - Pointer to the bd_config_t structure for the board
 *                  
 *
 * Returns: void
 *
 */
void
e100_phy_check(bd_config_t * bdp)
{
    bdd_t          *bddp = (bdd_t *) bdp->bddp;
    boolean_t       LinkState;
    
    LinkState = e100_PhyLinkState(bdp);
    if ((LinkState == B_TRUE) && (bddp->flags & INVALID_SPEED_DPLX)) {
        e100_FindPhySpeedAndDpx(bdp, bdp->PhyId);
        bddp->flags &= ~INVALID_SPEED_DPLX;
        
        if (bddp->cur_dplx_mode == HALF_DUPLEX)
	    printk(KERN_ERR "e100: %s NIC Link is Up %d Mbps Half duplex\n",
		   bdp->device->name, bddp->cur_line_speed);
        else
	    printk(KERN_ERR "e100: %s NIC Link is Up %d Mbps Full duplex\n",
		   bdp->device->name, bddp->cur_line_speed);
    }
    
    if ((!(bdp->flags & DF_PHY_82555)) || (bdp->flags & DF_SPEED_FORCED))
        return;

    if (LinkState == B_TRUE) {
        switch (bdp->PhyState) {
        case 0:
            break;
        case 1:
            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL, bdp->phy_addr, 0x0000);
            break;
        case 2:
            e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0x3000);
            break;
        }
        bdp->PhyState = 0;
        bdp->PhyDelay = 0;
    } else if (!bdp->PhyDelay--) {
        switch (bdp->PhyState) {
        case 0:
            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL, bdp->phy_addr,
                EXTENDED_SQUELCH_BIT);
            bdp->PhyState = 1;
            break;
        case 1:
            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL, bdp->phy_addr,
                0x0000);
            e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0x2010);
            bdp->PhyState = 2;
            break;
        case 2:
            e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0x3000);
            bdp->PhyState = 0;
            break;
        }

        e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr,
            MDI_CR_AUTO_SELECT | MDI_CR_RESTART_AUTO_NEG);
        bdp->PhyDelay = 3;
    }
}


void e100_ResetPhy(bd_config_t *bdp)
{
    uint16_t mdi_control_reg;

    mdi_control_reg = (MDI_CR_AUTO_SELECT | MDI_CR_RESTART_AUTO_NEG |
        MDI_CR_RESET);

    e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr, mdi_control_reg);

    udelay(100);
}


/* 
 * Procedure: e100_PhyLinkState
 * 
 * Description: This routine updates the link status of the adapter
 *
 * Arguments:  bdp - Pointer to the bd_config_t structure for the board
 *                  
 *
 * Returns: B_TRUE - If a link is found
 *              B_FALSE - If there is no link
 *
 */
boolean_t
e100_PhyLinkState(bd_config_t * bdp)
{

    bdd_t          *bddp = (bdd_t *) bdp->bddp;

    /* Check link status */
    if (e100_GetPhyLinkState(bdp) == B_TRUE)
    {
        /* Link is up */
        if (!(bdp->flags & DF_LINK_UP))
        {
#ifdef IANS
            bdp->cur_link_status = IANS_STATUS_LINK_OK;
#endif
            bdp->flags |= DF_LINK_UP;
        }
        return (B_TRUE);
    }
    /* Link is down */
    if (bdp->flags & DF_LINK_UP)
    {
#ifdef IANS
        bdp->cur_link_status = IANS_STATUS_LINK_FAIL;
#endif    

        bdp->flags &= ~DF_LINK_UP;

        /* Invalidate the speed and duplex values */
        bddp->flags |= INVALID_SPEED_DPLX;

        /* reset the zerol lock state */
        bdp->ZeroLockState = ZLOCK_INITIAL;
                
        // set auto lock for phy auto-negotiation on link up
        e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0);
	
	printk(KERN_ERR "e100: %s NIC Link is Down\n", bdp->device->name);
    }

    return (B_FALSE);
}

/* 
 * Procedure: e100_GetPhyLinkState
 * 
 * Description: This routine checks the link status of the adapter
 *
 * Arguments:  bdp - Pointer to the bd_config_t structure for the board
 *                  
 *
 * Returns: B_TRUE - If a link is found
 *              B_FALSE - If there is no link
 *
 */
boolean_t
e100_GetPhyLinkState(bd_config_t * bdp)
{

    bdd_t          *bddp = (bdd_t *) bdp->bddp;
    uint16_t        Status;

    /* Check link status */
    /* If the controller is a 82559 or later one, link status is available
     * from the CSR. This avoids the MdiRead. */
    if ((bdp->rev_id >= 8) || (bddp->flags & IS_ICH)) {
        if (readb(&bddp->scbp->scb_ext.d101m_scb.scb_gen_stat)
	    & BIT_0) {
            /* Link is up */
            return (B_TRUE);
        } else 
            /* Link is down */
            return (B_FALSE);
    }
    else {
        /* Read the status register */
        e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &Status);

        /* Read the status register again because of sticky bits */
        e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &Status);

        if (Status & MDI_SR_LINK_STATUS) {
            return (B_TRUE);
        } else {
            return (B_FALSE);
        }
    }       
}

/* 
 * Procedure:   e100_MdiWrite
 *
 * Description: This routine will write a value to the specified MII register
 *              of an external MDI compliant device (e.g. PHY 100).  The
 *              command will execute in polled mode.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *      RegAddress - The MII register that we are writing to
 *      PhyAddress - The MDI address of the Phy component.
 *      DataValue - The value that we are writing to the MII register.
 *
 * Returns:
 *      NOTHING
 */
void
e100_MdiWrite(bd_config_t * bdp,
    uint32_t RegAddress, uint32_t PhyAddress, uint16_t DataValue)
{
    bdd_t          *bddp;
    int             e100_retry;
    uint32_t         temp_val;

    bddp = (pbdd_t) bdp->bddp;   /* get the bddp for this board */

    temp_val = (((uint32_t) DataValue) |
        (RegAddress << 16) | (PhyAddress << 21) | (MDI_WRITE <<
            26));
    writel(temp_val,&bddp->scbp->scb_mdi_cntrl);

    /* wait 20usec before checking status */
    udelay(20);     

    /* poll for the mdi write to complete */
    e100_retry = E100_CMD_WAIT;
    while ((!(readl(&bddp->scbp->scb_mdi_cntrl) & MDI_PHY_READY)) && (e100_retry)) {
        udelay(20); 
        e100_retry--;
    }
}


/* 
 * Procedure:   e100_MdiRead
 *
 * Description: This routine will read a value from the specified MII register
 *              of an external MDI compliant device (e.g. PHY 100), and return
 *              it to the calling routine.  The command will execute in polled
 *              mode.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *      RegAddress - The MII register that we are reading from
 *      PhyAddress - The MDI address of the Phy component.
 *
 * Results:
 *      DataValue - The value that we read from the MII register.
 *
 * Returns:
 *      NOTHING
 */
void
e100_MdiRead(bd_config_t * bdp,
    uint32_t RegAddress, uint32_t PhyAddress, uint16_t * DataValue)
{
    bdd_t          *bddp;
    int             e100_retry;
    uint32_t         temp_val;

    bddp = (pbdd_t) bdp->bddp;   /* get the bddp for this board */

    /* Issue the read command to the MDI control register. */
    temp_val =
        ((RegAddress << 16) | (PhyAddress << 21) | (MDI_READ << 26));
    writel(temp_val,&bddp->scbp->scb_mdi_cntrl);

    /* wait 20usec before checking status */
    udelay(20);

    /* poll for the mdi read to complete */
    e100_retry = E100_CMD_WAIT;
    while ((!(readl(&bddp->scbp->scb_mdi_cntrl) & MDI_PHY_READY)) && (e100_retry)) {
        udelay(20);
        e100_retry--;
    }

    /* return 0 blindly as datavalue if we have timed out * and hope that
     * someone above smells a rat */

    if (!e100_retry)
        *DataValue = 0;

    // return the lower word
    *DataValue = (uint16_t) readl(&bddp->scbp->scb_mdi_cntrl);
}


/***************************************************************************/
/***************************************************************************/
/*       Checksum Functions                                                */
/***************************************************************************/


/* 
 * Procedure: e100_check_for_ip
 * 
 * Description: Looks for an TCP/IP or UDP/IP packet.
 *
 * Arguments:  int *HeaderOffset. Where does the ethernet header stop.
 *                  struct sk_buff *. Pointer to the packet data
 *                  
 *
 * Returns: IP Packet if we can checksum this packet.
 *              NULL if we can not checksum this packet.
 *
 */
ip_v4_header   *
e100_check_for_ip(int *HeaderOffset, struct sk_buff * skb)
{
    ip_v4_header   *IPPacket = NULL;
    ethernet_snap_header *snapHeader;
    ethernet_ii_header *eIIHeader;

    snapHeader = (ethernet_snap_header *) skb->data;
    eIIHeader = (ethernet_ii_header *) skb->data;

    /* Check for Ethernet_II IP encapsulation */
    if (eIIHeader->TypeLength == IP_PROTOCOL) {
        /* We need to point the IPPacket past the Ethernet_II header. */
        IPPacket =
            (ip_v4_header *) ((uint8_t *) eIIHeader +
                sizeof(ethernet_ii_header));

        if (IPPacket->ProtocolCarried == TCP_PROTOCOL) {
            *HeaderOffset = sizeof(ethernet_ii_header);
            return IPPacket;
        }

        if (IPPacket->ProtocolCarried == UDP_PROTOCOL) {
            *HeaderOffset = sizeof(ethernet_ii_header);
            return IPPacket;
        }
    }
    /* To qualify for IP encapsulated SNAP the type/length field must contain 
     * a length value i.e. less than 1500  */
    else if (snapHeader->TypeLength <= MAX_PKT_LEN_FIELD) {
        /* Check for SNAP IP encapsulation  */
        if ((snapHeader->DSAP == 0xAA) && (snapHeader->SSAP == 0xAA) &&
            (snapHeader->Ctrl == 0x03)) {
            if (*(uint16_t *) & snapHeader->ProtocolId == IP_PROTOCOL) {
                IPPacket =
                    (ip_v4_header *) ((uint8_t *) snapHeader +
                        sizeof(ethernet_snap_header));

                if (IPPacket->ProtocolCarried == UDP_PROTOCOL) {
                    *HeaderOffset = sizeof(ethernet_snap_header);
                    return IPPacket;
                }

                if (IPPacket->ProtocolCarried == TCP_PROTOCOL) {
                    *HeaderOffset = sizeof(ethernet_snap_header);
                    return IPPacket;
                }
            }
        }
    }

    /* If we didn't find IP encapsulation */
    return NULL;
}



/* 
 * Procedure: e100_calculate_checksum
 * 
 * Description: Calculates the checksum value from the hardware value.
 *
 * Arguments:  uint32_t *HeaderOffset. Where does the ethernet header stop.
 *                  struct sk_buff *skb. Pointer to the packet data
 *                  
 *
 * Returns: B_TRUE == Valid Checksum
 *              B_FALSE == Invalid Checksum
 *
 */
boolean_t
e100_calculate_checksum(ip_v4_header * IPPacket, uint32_t HeaderOffset,
    struct sk_buff * skb, uint32_t packetSize)
{

    uint16_t        hwCheckSum;
    uint8_t        *dataFragment;
    uint32_t        adjustValue = 0;
    uint16_t        IPTotalLength = 0;
    uint32_t        i;
    uint16_t        totalPacketLength;
    uint32_t        addLength;
    udp_header     *udpPacket;
    union {
        uint8_t         byteValue[2];
        uint16_t        wordValue;
    } protocolCarriedSwapped = { {
        0 } };
    union {
        uint8_t         byteValue[2];
        uint16_t        wordValue;
    } padWord = { {
        0 } };

    if (skb->len <= MINIMUM_ETHERNET_PACKET_SIZE) {
        skb->ip_summed = CHECKSUM_NONE;
        return B_TRUE;
    }

    /* Initialize the total packet length. This could include the CRC if we
     * are DMAing CRC's. */
    totalPacketLength = packetSize;

    /* Initialize the dataFragment pointer to point at the begining of the
     * data area. */
    dataFragment = (uint8_t *) skb->data;

    /* If we have a UDP packet we are now pointing to it. */
    udpPacket =
        (udp_header *) ((uint8_t *) IPPacket + (IPPacket->HdrLength * 4));

    /* If we have a UDP packet with a zero checksum, do not perform checksum
     * validation and return ZERO  */
    if ((IPPacket->ProtocolCarried == UDP_PROTOCOL)
        && (udpPacket->Checksum == 0)) {
        return 0;
    }
    /* Add up the IP Header and whats left of a SNAP header if it is a SNAP
     * frame. Have to convert HeaderOffset to words from bytes */
    addLength = (IPPacket->HdrLength * 2) + ((HeaderOffset -
        HARDWARE_CHECKSUM_START_OFFSET)
        / 2);
    for (i = 0; i < addLength; i++) {
        adjustValue += *((uint16_t *) IPPacket + i);
    }

    /* Now add back in the pseudo header parts. */
    adjustValue -= IPPacket->SrcAddr.Fields.SrcAddrLo;
    adjustValue -= IPPacket->SrcAddr.Fields.SrcAddrHi;
    adjustValue -= IPPacket->DestAddr.Fields.DestAddrLo;
    adjustValue -= IPPacket->DestAddr.Fields.DestAddrHi;

    /* Now take out the protocolID field */
    protocolCarriedSwapped.byteValue[0] = 0;
    protocolCarriedSwapped.byteValue[1] = IPPacket->ProtocolCarried;
    adjustValue -= protocolCarriedSwapped.wordValue;

    IPTotalLength = BYTE_SWAP_WORD(IPPacket->Length);

    /*******************************************************************
     * Layer4Length is part of TCP or UDP checksum
     *****************************************************************/
    adjustValue -= BYTE_SWAP_WORD(IPTotalLength - (IPPacket->HdrLength *
        sizeof(uint32_t)));

    /* adjustValue = BYTE_SWAP_WORD((uint16_t)adjustValue); */

    /* This is to take out any padding bytes. If we are posting CRC's this
     * code will need to change. */
    if ((totalPacketLength - CHKSUM_SIZE - HeaderOffset) != IPTotalLength) {
        padWord.byteValue[1] =
            *(uint8_t *) (dataFragment + totalPacketLength - CHKSUM_SIZE -
                1);

        padWord.byteValue[0] = 0;

        adjustValue += padWord.wordValue;
    }

    adjustValue = CHECK_FOR_CARRY(adjustValue);

    /* Get the Checksum value from the end of the packet */
    hwCheckSum =
        *(uint16_t *) (dataFragment + (totalPacketLength - CHKSUM_SIZE));

    if ((((adjustValue + ~hwCheckSum) & 0x0000FFFF) == 0xFFFF) ||
        (adjustValue + ~hwCheckSum == 0)) {

        /****************************************************************
         * Set the appropriate status bit to indicate that we performed
         * the transport layer protocol checksum and it is valid.
         **************************************************************/

        skb->ip_summed = CHECKSUM_HW;
        skb->csum = hwCheckSum;
        return B_TRUE;
    } else {
        /****************************************************************
         * Set the appropriate status bit to indicate that we performed
         * the transport layer protocol checksum and it is NOT valid.
         **************************************************************/
        skb->ip_summed = CHECKSUM_NONE;
        return B_FALSE;
    }
}


/*
 * Procedure: e100_D102_check_checksum
 * 
 * Description: Checks the D102 RFD flags to see if the checksum passed
 *
 * Arguments:  struct sk_buff *skb. Pointer to the packet data
 *               
 */
 
void
e100_D102_check_checksum(bd_config_t *bdp, struct sk_buff *skb)
{
    rfd_t *rfd = RFD_POINTER(skb, bdp->bddp);
    uint16_t status = cpu_to_le16(rfd->rfd_header.cb_status);

    if (/* frame parsing succeed */
        (status & RFD_PARSE_BIT)
        /* frame recognized as a TCP or UDP frame */
        && (((rfd->rcvparserstatus & CHECKSUM_PROTOCOL_MASK) == RFD_TCP_PACKET) || 
            ((rfd->rcvparserstatus & CHECKSUM_PROTOCOL_MASK) == RFD_UDP_PACKET))
        /* checksum was calculated */
        && (rfd->checksumstatus & TCPUDP_CHECKSUM_BIT_VALID) 
        /* and it happens to be valid */
        && (rfd->checksumstatus & TCPUDP_CHECKSUM_VALID)) 

        skb->ip_summed = CHECKSUM_UNNECESSARY;

}


/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/*       Auxilary Functions                                                */
/***************************************************************************/


/* 
 * Procedure:   e100_print_brd_conf
 *
 * Description: This routine printd the board configuration.
 *
 * Arguments:
 *      bdp    - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NONE
 *
 */
void
e100_print_brd_conf(bd_config_t * bdp)
{
    bdd_t          *bddp = (bdd_t *) bdp->bddp;

    printk(KERN_NOTICE "  Mem:0x%p  IRQ:%d  Speed:%d Mbps  Dx:%s\n",
        (void*)bdp->mem_start,
        bdp->device->irq, bddp->cur_line_speed,
        bddp->cur_dplx_mode == FULL_DUPLEX ? "Full" :
        ((bddp->cur_dplx_mode == NO_DUPLEX) ? "N/A" : "Half"));
    if (bddp->flags & INVALID_SPEED_DPLX) {
        /* Auto negotiation failed so we should display an error */
        printk(KERN_NOTICE "  Failed to detect cable link.\n");
        printk(KERN_NOTICE "  Speed and duplex will be determined at time of connection.\n");
    }
    
    /* Print the string if checksum Offloading was enabled */
    if (bdp->checksum_offload_enabled) 
        printk(KERN_NOTICE "  Hardware receive checksums enabled\n");
    else 
        printk(KERN_NOTICE "  Hardware receive checksums disabled\n");
    
    if ((bdp->flags & DF_UCODE_LOADED))
        printk(KERN_NOTICE "  cpu cycle saver enabled\n");
}


/* New routine for checking sub-dev & sub-ven IDs. */

/* 
 * Procedure:   e100_GetBrandingMesg
 *
 * Description: This routine checks if the sub_ven and sub_dev found
 * on the board is a valid one for the driver to load. If it is, the
 * routine determines the right string to be printed. The routine knows
 * what IDs to load on by scanning a predefined array.
 *
 * Arguments:
 *      sub_ven - Subsystem vendor ID on the board
 *      sub_dev - Subsystem device ID on the board
 *
 * Returns:
 *      1 - if it is valid to load on this board
 *      0 - if it is not valid to load on this board
 *
 */
static char *
e100_GetBrandingMesg(bd_config_t *bdp)
{
    uint16_t    sub_ven, sub_dev;
    char        *mesg = NULL;
    int         i = 0;

    sub_ven = bdp->sub_ven_id;
    sub_dev = bdp->sub_dev_id;
    
    /* Go through the list of all valid device, vendor and subsystem IDs */
    while (e100_vendor_info_array[i].idstr != NULL) {
        /* Look for a match on device id */
        if ((e100_vendor_info_array[i].dev_id == bdp->ppci_dev->device)
            || (e100_vendor_info_array[i].dev_id == CATCHALL)) {
            /* Look for a match on sub_ven */
            if ((e100_vendor_info_array[i].sub_ven == sub_ven)
                /* Is this driver to load on all adapters from this vendor? */
                || (e100_vendor_info_array[i].sub_ven == CATCHALL)) { 
                /* Look for a match on sub_dev */
                if ((e100_vendor_info_array[i].sub_dev == sub_dev)
                    /* Is this driver to load on all adapters with this subsytem dev id? */
                    || (e100_vendor_info_array[i].sub_dev == CATCHALL)) {
                    mesg = e100_vendor_info_array[i].idstr;
                    break;
                }
            }
        }
        i++;
    }

    if (mesg)   strncpy(e100id_string, mesg, sizeof(e100id_string)-1);
    else        printk(KERN_WARNING "e100: Vendor ID Mismatch\n");
    return mesg;
    
}




/* 
 * Procedure:   e100_dis_intr
 *
 * Description: This routine disables interrupts at the hardware, by setting
 *              the M (mask) bit in the adapter's CSR SCB command word.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NOTHING
 */
void
e100_dis_intr(bd_config_t * bdp)
{
    bdd_t          *bddp;      /* stores all adapter specific info */

    bddp = (pbdd_t) bdp->bddp;   /* get the bddp for this board */

    /* Disable interrupts on our PCI board by setting the mask bit */
    writeb(SCB_INT_MASK,&bddp->scbp->scb_cmd_hi);
}


/* 
 * Procedure:   e100_enbl_intr
 *
 * Description: This routine enables interrupts at the hardware, by resetting
 *              the M (mask) bit in the adapter's CSR SCB command word
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NOTHING
 */
void
e100_enbl_intr(bd_config_t * bdp)
{
    bdd_t          *bddp;      /* stores all adapter specific info */

    bddp = (pbdd_t) bdp->bddp;   /* get the bddp for this board */

    /* Enable interrupts on our PCI board by clearing the mask bit */
    writeb(0,&bddp->scbp->scb_cmd_hi);
}


void
e100_trigger_SWI(bd_config_t * bdp)
{
    bdd_t          *bddp;      /* stores all adapter specific info */

    bddp = (pbdd_t) bdp->bddp; 
    /* Trigger interrupt on our PCI board by asserting SWI bit */
    writeb(SCB_SOFT_INT,&bddp->scbp->scb_cmd_hi);
}



/*****************************************************************************
 * Name:        e100_get_pci_info
 *
 * Description: This routine finds all PCI adapters that have the given Device
 *              ID and Vendor ID.  It will store the IRQ, I/O, mem address,
 *              amd node address for each adapter in the
 *              CardsFound structure.  This routine will also enable the bus
 *              master bit on any of our adapters (some BIOS don't do this).
 *
 *
 * Arguments:
 *      vendor_id - Vendor ID of our adapter.
 *      device_id - Device ID of our adapter.
 *
 * Returns:
 *      B_TRUE     - if found pci devices successfully
 *      B_FALSE     - if no pci devices found
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  --------------------------------------------------------
 *
 *****************************************************************************/
static boolean_t
e100_get_pci_info(pci_dev_t * pcid, bd_config_t * bdp)
{
    bdd_t          *bddp = bdp->bddp;
    uint32_t         tmp_base_addr;
    uint16_t        pci_cmd = 0;
    uint16_t        regValue;

    /* dev and ven ID have already been check so it is our device */
    pci_read_config_byte(pcid, PCI_REVISION_ID, (uint8_t *) & (bdp->rev_id));
    pci_read_config_word(pcid, PCI_SUBSYSTEM_ID, (uint16_t *) & (bdp->sub_dev_id));
    pci_read_config_word(pcid, PCI_SUBSYSTEM_VENDOR_ID, (uint16_t *) & (bdp->sub_ven_id));
    pci_read_config_word(pcid, PCI_COMMAND, (uint16_t *) & (pci_cmd));
    
    pci_read_config_word(pcid, PMCSR, &regValue);
    regValue |= PM_ENABLE_BIT;
    pci_write_config_word(pcid, PMCSR, regValue);
    
    /* if Bus Mastering is off, turn it on! */
    pci_set_master(pcid);

    /* address #0 is a memory mapping */
    bddp->scbp = (pscb_t) ioremap(pci_resource_start(pcid, 0) & PCI_BASE_ADDRESS_MEM_MASK,
                                  sizeof(scb_t));
    
    if (!bddp->scbp) {
        printk(KERN_ERR "%s - %s: Failed to map PCI address 0x%lX\n",
               e100_short_driver_name, bdp->device->name,
               pci_resource_start(pcid, 0));
        return B_FALSE;
    }
    
    bdp->mem_start = pci_resource_start(pcid, 0);
    
    /* address #1 is a IO region */
    tmp_base_addr = (uint32_t)pci_resource_start(pcid, 1);
    bdp->io_start = (tmp_base_addr & ~0x3UL);
  
    return B_TRUE;
}



/**************************************************************************\
 **
 ** PROC NAME:     e100_handle_zero_lock_state
 **    This function manages a state machine that controls
 **    the driver's zero locking algorithm.
 **    This function is called by e100_watchdog() every ~2 second.
 ** States:
 **    The current link handling state is stored in 
 **    bdp->ZeroLockState, and is one of:
 **    ZLOCK_INITIAL, ZLOCK_READING, ZLOCK_SLEEPING
 **    Detailed description of the states and the transitions
 **    between states is found below.
 **    Note that any time the link is down / there is a reset
 **    state will be changed outside this function to ZLOCK_INITIAL
 ** Algorithm:
 **    1. If link is up & 100 Mbps continue else stay in #1:
 **    2. Set 'auto lock'
 **    3. Read & Store 100 times 'Zero' locked in 1 sec interval
 **    4. If max zero read >= 0xB continue else goto 1
 **    5. Set most popular 'Zero' read in #3
 **    6. Sleep 5 minutes
 **    7. Read number of errors, if it is > 300 goto 2 else goto 6
 ** Data Structures (in DRIVER_DATA):
 **    ZeroLockState           - current state of the algorithm
 **    ZeroLockReadCounter     - counts number of reads (up to 100)
 **    ZeroLockReadData[i] - counts number of times 'Zero' read was i, 0 <= i <= 15
 **    ZeroLockSleepCounter - keeps track of "sleep" time (up to 300 secs = 5 minutes)
 **                                
 ** Parameters:    DRIVER_DATA    *bdp
 **
 **                bdp  - Pointer to HSM's adapter data space
 **
 ** Return Value:  NONE
 **
 ** See Also:      e100_watchdog()
 **
 \**************************************************************************/
static void e100_handle_zero_lock_state(bd_config_t * bdp)
{
    uint16_t        ArrayPosition;
    uint16_t        EqRegValue;
    uint8_t         MostPopularZero;
    uint16_t        ErrorCounter;
    bdd_t               *bddp = (bdd_t *)bdp->bddp;

    switch (bdp->ZeroLockState)
    {
    case ZLOCK_INITIAL:

        if ( ((uint8_t)bdp->rev_id <= D102_REV_ID) || 
            !(bddp->cur_line_speed == 100) || 
            !(bdp->flags & DF_LINK_UP) ) 
        {
            break;
        }
                
        //initialize hw and sw and start reading                        
                
        e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0);
        // reset read counters:
        bdp->ZeroLockReadCounter = 0;
        for (ArrayPosition=0; ArrayPosition < 16; ArrayPosition++)
            bdp->ZeroLockReadData[ArrayPosition] = 0;
        // start reading in the next call back:
        bdp->ZeroLockState = ZLOCK_READING;

        /* fall through !! */
                
    case ZLOCK_READING:
        // state: reading (100 times) zero locked in 1 sec interval
        // prev states: ZLOCK_INITIAL
        // next states: ZLOCK_INITIAL, ZLOCK_SLEEPING

        e100_MdiRead(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, &EqRegValue);
        ArrayPosition = (EqRegValue & ZLOCK_ZERO_MASK) >> 4;
        bdp->ZeroLockReadData[ArrayPosition]++;
        bdp->ZeroLockReadCounter++;

        if (bdp->ZeroLockReadCounter == ZLOCK_MAX_READS)
        {
            // check if we have read a 'Zero' value of 0xB or greater:
            if ((bdp->ZeroLockReadData[0xB]) || (bdp->ZeroLockReadData[0xC]) ||
                (bdp->ZeroLockReadData[0xD]) || (bdp->ZeroLockReadData[0xE]) ||
                (bdp->ZeroLockReadData[0xF]))
            {
                // we have read a 'Zero' value of 0xB or greater, find the most popular 'Zero'
                // value and lock it:
                MostPopularZero = 0;
                // this loop finds the most popular 'Zero':
                for (ArrayPosition = 1; ArrayPosition < 16; ArrayPosition++)
                {
                    if (bdp->ZeroLockReadData[ArrayPosition] > bdp->ZeroLockReadData[MostPopularZero])
                        MostPopularZero = ArrayPosition;
                }
                // now lock the most popular 'Zero': 
                EqRegValue = (ZLOCK_SET_ZERO | MostPopularZero);
                e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, EqRegValue);

                // sleep for 5 minutes:
                bdp->ZeroLockSleepCounter = jiffies;
                bdp->ZeroLockState = ZLOCK_SLEEPING;
                // we will be reading the # of errors after 5 minutes, so we need to reset the
                // error counters - these registers are self clearing on read , so just read them:
                                
                e100_MdiRead(bdp, PHY_82555_SYMBOL_ERR, bdp->phy_addr, &ErrorCounter);
            }
            else
            {
                // we did not read a 'Zero' value of 0xB or above. go back to the start:
                bdp->ZeroLockState = ZLOCK_INITIAL;
            }

        }
        break;
        
    case ZLOCK_SLEEPING:
        // state: sleeping for 5 minutes
        // prev states: ZLOCK_READING
        // next states: ZLOCK_READING, ZLOCK_SLEEPING

        // if 5 minutes have passed:
        if (( jiffies - bdp->ZeroLockSleepCounter ) >= ZLOCK_MAX_SLEEP)
        {
            // read and sum up the number of errors:
            e100_MdiRead(bdp, PHY_82555_SYMBOL_ERR, bdp->phy_addr, &ErrorCounter);
            // if we have more than 300 errors (this number was calculated according
            //to the spec max allowed errors (80 errors per 1 million frames)
            //for 5 minutes in 100 Mbps (or the user specified max BER number)
            if (ErrorCounter > ber[bdp->bd_number])
            {
                // start again in the next callback:
                bdp->ZeroLockState = ZLOCK_INITIAL;
            }
            else
            {
                // we don't have more errors than allowed, sleep for another 5 minutes:
                bdp->ZeroLockSleepCounter = jiffies;
            }
        }
        break;
    } // switch
} // e100_handle_zero_lock_state

static void
e100_tcb_add_C_bit(bd_config_t* bdp)
{

	tcb_t* tcbp = (tcb_t*)bdp->bddp->tcb_pool.data;
        int i;
    
	for(i=0;i< TxDescriptors[bdp->bd_number];i++,tcbp++){
		tcbp->tcb_hdr.cb_status |= 
			cpu_to_le16(CB_STATUS_COMPLETE);
        }

}

void 
e100_isolate_driver(bd_config_t *bdp)
{
  

        del_timer(&bdp->timer_id);

        e100_tx_notify_stop(bdp);

        bdp->bddp->last_tcbp = NULL;

        e100_sw_reset(bdp, PORT_SELECTIVE_RESET);   
	
}

/* 
 * Procedure:   e100_hw_reset_recover
 *
 * Description: This routine will recover the hw after reset.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *        reset_cmd - s/w reset or selective reset. 
 *
 * Returns:
 *        B_TRUE upon success
 *        B_FALSE upon failure
 */
boolean_t
e100_hw_reset_recover(bd_config_t *bdp, uint32_t reset_cmd)
{
        bdd_t          *bddp = bdp->bddp;   /* stores all adapter specific info */
        e100_eaddr_t * eaddrp;

        bdp->bddp->last_tcbp = NULL;
        if(reset_cmd == PORT_SOFTWARE_RESET){

                /*load CU & RU base */
                if (e100_wait_scb(bdp) != B_TRUE){
                        printk(KERN_ERR "e100_hw_reset_recover: Wait failed\n");
                        return B_FALSE;
                }
                writel(0,&bddp->scbp->scb_gen_ptr);
	        e100_exec_cmd(bdp, SCB_CUC_LOAD_BASE);

                if (e100_wait_scb(bdp) != B_TRUE){
                        printk(KERN_ERR "e100_hw_reset_recover: Wait failed\n");
                        return B_FALSE;
                }

	      	writel(0,&bddp->scbp->scb_gen_ptr);
                e100_exec_cmd(bdp, SCB_RUC_LOAD_BASE);

                /* Issue the load dump counters address command */
                if (e100_wait_scb(bdp) != B_TRUE){
                        printk(KERN_ERR "e100_hw_reset_recover: Wait failed\n");
                        return B_FALSE;
                }
                writel(bddp->stat_cnt_paddr,&bddp->scbp->scb_gen_ptr);
                e100_exec_cmd(bdp, SCB_CUC_DUMP_ADDR);

    		eaddrp = (e100_eaddr_t *) &(bdp->device->dev_addr);

		                if(e100_setup_iaaddr(bdp,eaddrp) != B_TRUE){
		      printk(KERN_ERR "e100_hw_reset_recover: setup iaaddr failed\n");
                        return B_FALSE;
                }


                e100_set_multi_exec(bdp->device);

                if (e100_load_microcode(bdp, bdp->rev_id) == B_TRUE) 
                        mdelay(1);   

                /* Change for 82558 enhancement */
                /* If 82558/9 and if the user has enabled flow control, set up * the
                 * Flow Control Reg. in the CSR */
                if ((bddp->flags & IS_BACHELOR) && (flow_control[bdp->bd_number] == TRUE)) {
		        writeb(DFLT_FC_THLD,&bddp->scbp->scb_ext.d101_scb.scb_fc_thld);
		        writeb(DFLT_FC_CMD,&bddp->scbp->scb_ext.d101_scb.scb_fc_xon_xoff);
                }

	}

        e100_force_config(bdp);

        return B_TRUE;

}


void 
e100_deisolate_driver(bd_config_t *bdp, boolean_t recover)
{

	bdd_t* bddp = bdp->bddp;
	
        if(recover){

                bddp->next_cu_cmd = START_WAIT;
                bdp->bddp->last_tcbp = NULL;

		/* lets reset the chip */
                e100_sw_reset(bdp, PORT_SELECTIVE_RESET);
		
                if( e100_hw_reset_recover(bdp,PORT_SELECTIVE_RESET) != B_TRUE)
        		printk(KERN_ERR "e100_deisolate_driver: HW reset recover failed.\n");
                
                if (e100_wait_scb(bdp) != B_TRUE)
	        	printk(KERN_ERR "e100_deisolate_driver: Wait failed.\n");
                e100_start_ru(bdp);


                /* relaunch watchdog timer in 2 sec */
                bdp->timer_id.expires = bdp->timer_val = jiffies + (2 * HZ);
                add_timer(&bdp->timer_id);

                // we must clear tcbs since we may have lost Tx intrrupt
                // or have unsent frames on the tcb chain
                e100_tcb_add_C_bit(bdp);
                e100_tx_srv(bdp);


                e100_enbl_intr(bdp);

        }

        e100_tx_notify_start(bdp);
}


