/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999-2001, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
 this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation 
 and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
 may be used to endorse or promote products derived from this software 
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
****************************************************************************/

/**********************************************************************
*                                                                     *
* INTEL CORPORATION                                                   *
*                                                                     *
* This software is supplied under the terms of the license included   *
* above.  All use of this driver must be in accordance with the terms *
* of that license.                                                    *
*                                                                     *
* Module Name:  ans_hw.c                                              *
*                                                                     *
* Abstract: hardware specific files for the 8255x adapters            *
*                                                                     *
* Environment:                                                        *
*                                                                     *
**********************************************************************/


#include "ans_driver.h"






UINT32
bd_ans_hw_AvailableSpeeds(UINT32 phy)
{
    UINT32 speeds;

    
    speeds =
        IANS_STATUS_LINK_SPEED_10MBPS | IANS_STATUS_LINK_SPEED_100MBPS;
    
    
    
    
       
    return (speeds);
    
}



UINT32
bd_ans_hw_flags(BOARD_PRIVATE_STRUCT *bps, UINT16 revid)
{                                        
    UINT16 CompatibilityFlagsReg;
    UINT32 flags = 0;
    
    if (revid < I82559_REV_ID) {
        flags |= IANS_BD_FLAG4;
        
    } else {
        CompatibilityFlagsReg = READ_EEPROM(bps, EEPROM_COMPATIBILITY_FLAGS);
        
        if ((HIGH_BYTE(CompatibilityFlagsReg) & EEPROM_COMPATIBILITY_BIT_4) &&
            !(HIGH_BYTE(CompatibilityFlagsReg) & EEPROM_COMPATIBILITY_BIT_2)) {
            
            flags |= IANS_BD_FLAG4;
        }
    }
    
    return flags;
}
          
BD_ANS_BOOLEAN
bd_ans_hw_SupportsIEEETagging(BOARD_PRIVATE_STRUCT *bps, UINT16 revid)
{
    /* we only support IEEE tagging if we are on a bachelor or better card. */
    DEBUGLOG1("bd_ans_hw_SupportsIEEETagging: revid = %d\n", revid);

    if (revid >= I82558_REV_ID) {
        return BD_ANS_TRUE;
    }
    return BD_ANS_FALSE;
}

#ifdef IANS_BASE_VLAN_TAGGING
BD_ANS_BOOLEAN
bd_ans_hw_IsQtagPacket(BOARD_PRIVATE_STRUCT *bps, HW_RX_DESCRIPTOR *rxd)
{
    /* check the T bit */
     if (RXD_STATUS(rxd) & BIT_12) {  /* underrun */
        return BD_ANS_TRUE;
    }
    return BD_ANS_FALSE;
}



BD_ANS_STATUS
bd_ans_hw_InsertQtagHW(BOARD_PRIVATE_STRUCT *bps, HW_TX_DESCRIPTOR *txd, UINT16 *vlanid)
{  

    txd->tcbu.ipcb.ip_activation |= IPCB_INSERT_VLAN_ENABLE;
    txd->tcbu.ipcb.vlan = BYTE_SWAP_WORD(*vlanid);
    return BD_ANS_SUCCESS;
}

UINT16 
bd_ans_hw_GetVlanId(BOARD_PRIVATE_STRUCT *bps,
    HW_RX_DESCRIPTOR *rxd)
{
    UINT16 VlanId = INVALID_VLAN_ID;

    /* check the T bit */
    if (RXD_STATUS(rxd) & BIT_12) { /* underrun */
        VlanId = BYTE_SWAP_WORD(RXD_VLANID(rxd)) & VLAN_ID_MASK;
        /* clear out the vlan id bits just to be safe */
        RXD_STATUS(rxd) &= ~BIT_12;
        RXD_VLANID(rxd) = 0;
    }
    DEBUGLOG1("bd_ans_hw_GetVlanId: got %d\n", VlanId);
    return VlanId;
}     


/* this function will setup the config bytes for the 8255x to enable
 * tagging.  The driver must call the this routine as part of it's normal
 * configure routine if it wants to enable 802.1q tagging.  To disable
 * tagging, the driver should just call configure without calling
 * this routine.
 */
void
bd_ans_hw_ConfigEnableTagging(UINT8 *ConfigBytes, UINT16 rev_id)
{
        // not in use for e100
}

#endif

BD_ANS_BOOLEAN
bd_ans_hw_SupportsVlanOffload(BOARD_PRIVATE_STRUCT *bps, UINT16 rev_id)
{
        
    if (rev_id >= GAMLA_REV_ID) {
        DEBUGLOG("bd_ans_hw_SupportsVlanOffload: does support\n");
        return BD_ANS_TRUE;
    }
    DEBUGLOG("bd_ans_hw_SupportsVlanOffload: does NOT support\n");
    return BD_ANS_FALSE;
}

