/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999-2001, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
 this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation 
 and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
 may be used to endorse or promote products derived from this software 
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
****************************************************************************/
/*
*                                                                     		*
* This software is supplied under the terms of the license included   		*
* above.  All use of this driver must be in accordance with the terms 		*
* of that license.                                                    		*
*                                                                                        *
* Module Name:                                                                           *
*     eeprom.h                                                                           *
*                                                                                        *
* Abstract:                                                                              *
*     This module contains procedure declarations to read and write to a serial EEPROM   *
*                                                                                        *
*     This driver runs on the following hardware:                                        *
*     8255x based PCI 10/100Mb ethernet adapters                                         *
*                                                                                        *
******************************************************************************************/

#ifndef _EEPROM_H_
#define _EEPROM_H_

#include "e100.h"




#define CSR_GENERAL_CONTROL2	scb_ext.d102_scb.scb_gen_ctrl2
#define CSR_EEPROM_CONTROL	scb_eprm_cntrl
#define AiRevID		bddp->rev_id
#define EEpromSize	bddp->EEpromSize

#define CSR_GCR2_EEPROM_ACCESS_SEMAPHORE	SCB_GCR2_EEPROM_ACCESS_SEMAPHORE
#define D102_A_STEP				D102_REV_ID
#define EEPROM_SEMAPHORE_TIMEOUT		500
#define ETH_LENGTH_OF_ADDRESS			ETHERNET_ADDRESS_LENGTH			

#define CAT_SCB(bdp,scb_member) ((bdp)->bddp->scbp->scb_member)

#define _STATUS		int 
#define VOID		void
#define USHORT		__u16
#define BOOLEAN		boolean_t
#define PUSHORT		__u16 *
#define PUCHAR		__u8 *		 
#define UINT		unsigned int
#define ULONG		unsigned long
#define UCHAR		__u8

#define IN
#define OUT
#define INLINE inline

#define TRACE(X) 
#define ASSERT(X)

#define _STATUS_SUCCESS	0
#define _STATUS_FAILURE	1

#define Csr_Write16(bdp, member, data) \
     writew( (data) , &CAT_SCB( (bdp), member))

#define Csr_Read16(bdp,member) readw(&CAT_SCB( (bdp), member))

#define Csr_Write8(bdp, member, data) \
     writeb( (data) , &CAT_SCB( (bdp), member))

#define Csr_Read8(bdp,member) readb(&CAT_SCB( (bdp), member))

#define StallExecutionMicro(time_in_mili)	udelay(time_in_mili)
#define ETH_COPY_NETWORK_ADDRESS(dst,src)	memcpy((__u8 *)(dst), (__u8 *)(src),6)
 
#define PD100_ADAPTER bd_config_t *




#define WAIT_FOR_CONDITION(adapter, count, expr)                \
{   UINT    counter = (count) / 2;                              \
    while (!(expr) ) {                                          \
        StallExecutionMicro (2);                                \
        if (!--counter) {                                       \
            TRACE ((LVL_INFO,                                   \
                "WAIT_FOR_CONDITION: failed at %s:%d\n\t%s\n",  \
                __FILE__, __LINE__, #expr));                    \
                                                                \
            break;                                              \
}}}

/*             */

#define STALL_TIME          100
#define EEPROM_CHECKSUM     (USHORT)0xBABA


_STATUS
InitializeEEpromStructure (
    IN PD100_ADAPTER adapter
);

_STATUS  
ValidateEEprom (
	IN PD100_ADAPTER adapter
);

VOID
InitializeEEpromBuffer (
    IN PD100_ADAPTER adapter
);

USHORT GetEEpromSize (
    IN PD100_ADAPTER adapter
);

USHORT
ReadEEprom (
    IN PD100_ADAPTER adapter,
    IN USHORT reg
);

VOID
ShiftOutBits (
    IN PD100_ADAPTER adapter,
    IN USHORT data,
    IN USHORT count
);

VOID
RaiseClock (
    IN PD100_ADAPTER adapter,
    IN OUT PUSHORT x
);

VOID
LowerClock (
    IN PD100_ADAPTER adapter,
    IN OUT PUSHORT x
);

USHORT
ShiftInBits (
    IN PD100_ADAPTER adapter
);

VOID
EEpromCleanup (
    IN PD100_ADAPTER adapter
);

BOOLEAN
ReadEEpromNodeAddress (
    IN PD100_ADAPTER adapter,
    OUT PUCHAR buffer,
    IN UINT size
);

VOID
UpdateChecksum (
    IN PD100_ADAPTER adapter
);

VOID
WriteEEprom (
    IN PD100_ADAPTER adapter,
    IN USHORT reg,
    IN USHORT data
);

USHORT
WaitEEpromCmdDone (
    IN PD100_ADAPTER adapter
);

VOID
StandBy (
    IN PD100_ADAPTER adapter
);























//----------------------------------------------------------------------------------------
// Procedure:   EepromSetSemaphore
//
// Description: This function set (write 1) Gamla EEPROM semaphore bit (bit 23 word 0x1C in the CSR).
//
// Arguments:
//      Adapter                 - Adapter context
//
// Returns:  TRUE if success
//           else return FALSE 
//
//----------------------------------------------------------------------------------------

INLINE
BOOLEAN
EepromSetSemaphore (
    IN PD100_ADAPTER adapter
)
{
    USHORT  data=0;
    
    // Get current value of General Control 2
    data = Csr_Read8(adapter, CSR_GENERAL_CONTROL2);
    
    // Set bit 23 word 0x1C in the CSR.
    data |= CSR_GCR2_EEPROM_ACCESS_SEMAPHORE ;
    Csr_Write8(adapter,  CSR_GENERAL_CONTROL2, data);

    // Check to see if this bit set or not.
    data = Csr_Read8(adapter, CSR_GENERAL_CONTROL2);
    
    return ((data & CSR_GCR2_EEPROM_ACCESS_SEMAPHORE) ? TRUE: FALSE);   
}

//----------------------------------------------------------------------------------------
// Procedure:   EepromResetSemaphore
//
// Description: This function reset (write 0) Gamla EEPROM semaphore bit (bit 23 word 0x1C in the CSR).
//
// Arguments:
//      Adapter                 - Adapter context
//
// Returns:  Nothing
//
//----------------------------------------------------------------------------------------

INLINE
VOID
EepromResetSemaphore(
    IN PD100_ADAPTER adapter
)
{
    USHORT  data=0;

    // Get current value of General Control 2
    data = Csr_Read8(adapter, CSR_GENERAL_CONTROL2);
    
    // Reset bit 23 word 0x1C in the CSR.
    data &= ~(CSR_GCR2_EEPROM_ACCESS_SEMAPHORE) ;
    Csr_Write8(adapter,  CSR_GENERAL_CONTROL2, data);
}

#endif      // _EEPROM_H_
