<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
	<DataArea backpagetarget="./DataArea?plugin=security.X509.webplugins.ReuseWebPlugin&amp;help=Certificate&amp;app=oma">
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCertificateEntry"/></xsl:attribute>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strX509CertificateContents"/></xsl:attribute>
		</PageTitle>
		<ListData type="custom">
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strAlias"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="CertEntry/Alias"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strCreationDate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="CertEntry/CreationDate"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strProvider"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="CertEntry/Provider"/></xsl:attribute>
			</Data>	
		</ListData>	
		<xsl:for-each select="CertEntry/CertChainElement">
			<xsl:call-template name="CertificateDisplay"/>
		</xsl:for-each>		
	</DataArea>
</xsl:template>

<xsl:template name ="CertificateDisplay">
		<ListData type="custom"  columnspacing="true">
      <Header>
        <Data>
        <xsl:attribute name="display"><xsl:value-of select="$strCertificateChain"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strCertificateChain"/></xsl:attribute>
          </Data>
      </Header>

      <xsl:attribute name="name">certchain<xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param></xsl:call-template></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strCertificateChainElement"/><xsl:text disable-output-escaping="yes">  </xsl:text>
				<xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param></xsl:call-template>
			</xsl:attribute>
			<Header>
        <Data>
        <xsl:attribute name="display">
        <xsl:value-of select="$strCertificateChainElement1"/><xsl:text disable-output-escaping="yes">  </xsl:text>
				<xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param></xsl:call-template>
          </xsl:attribute>
            <xsl:attribute name="value">
        <xsl:value-of select="$strCertificateChainElement1"/><xsl:text disable-output-escaping="yes">  </xsl:text>
				<xsl:call-template name="count"><xsl:with-param name="index"><xsl:value-of select="@index"/></xsl:with-param></xsl:call-template>
          </xsl:attribute>
          </Data>
			</Header>
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Type"/></xsl:attribute>
				</Data>		
			
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strVersion"/></xsl:attribute>
				  <xsl:attribute name="value"><xsl:value-of select="Version"/></xsl:attribute>
				</Data>		
	
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIsValid"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Valid"/></xsl:attribute>
				</Data>		
				

				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSubject"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Subject"/></xsl:attribute>
				</Data>		
			
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIssuer"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Issuer"/></xsl:attribute>
				</Data>		
			
		
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strValidFrom"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ValidFrom"/></xsl:attribute>
				</Data>		
			
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strValidTo"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ValidTo"/></xsl:attribute>
				</Data>		
		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSerialNumber"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SerialNumber"/></xsl:attribute>
				</Data>		
			
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strPublicKey"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="PublicKey"/></xsl:attribute>
				</Data>		
			
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strPublicKeyAlgorithm"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="PublicKeyAlg"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strKeyUsage"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="KeyUsage"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSignature"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Signature"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSignatureAlgorithmName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SigAlgName"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSignatureAlgorithmOID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SigAlgOID"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSignatureAlgorithmParameters"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SigAlgPara"/></xsl:attribute>
				</Data>		
		
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strTBSCertificate"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="TBSCert"/></xsl:attribute>
				</Data>		
		
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strBasicConstraints"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="BasicConstraints"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSubjectUniqueID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SubUNID"/></xsl:attribute>
				</Data>		
		
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIssuerUniqueID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="IssuerUNID"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strMD5Fingerprints"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="MD5FingerPrints"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSHA1Fingerprints"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SHA1FingerPrints"/></xsl:attribute>
				</Data>		
			
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strEncodedCertificate"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="EncodedCert"/></xsl:attribute>
				</Data>		
			
		</ListData>
</xsl:template>

<xsl:template name="count">
	<xsl:param name="index"/>
	<xsl:choose>
		<xsl:when test="/OMA/CertEntry/@count='1'">1</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="index1" select="$index"/>
			<xsl:value-of select="number($index1)+1"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
