#!/bin/bash

if [ ! -e /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh ]; then
    # omilcore already gone, cant unreg at this point. give up
    exit 0
fi

# Remove Ndx registration with the Data Engine
. /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh
DCECFG=`GetRegVal /opt/dell/srvadmin/etc/omreg.cfg OMDataEngine.configtool`

# data engine already gone, cannot unreg
[ -n "$DCECFG" ]  || exit 0

${DCECFG} command=removedareg prefix=is

#Unregister Event Plug-In implementer from the Data Engine.
${DCECFG} command=removeepialias aliasname=dcisep

# Unregister FRU SNMP MIB implementer from the Data Engine.
${DCECFG} command=removempialias aliasname=dcsfru
# Unregister SNMP MIB implementer from the Data Engine.
${DCECFG} command=removempialias aliasname=dcsnis

poplist="dcadpt dcosp dccoop dcsecp dcwfm dclra dciemp dcienv dcipm9 dcip10 dcifru dcrac5"
if [ "$(uname -m)" = "i386" ]; then
    # ESM2 data populator is only supported on 32-bit systems
    # TVM data populator is only supported on 32-bit systems
    poplist="$poplist dcesmp dctvm"
fi
for i in $poplist
do
    ${DCECFG} command=removepopalias aliasname=$i
done


