#!/bin/bash
    # fixup omreg
    cat /opt/dell/srvadmin/etc/omreg.d/*.cfg > /opt/dell/srvadmin/etc/omreg.cfg 2>/dev/null ||:

    ##########################################
    # Perform Data Engine configuration
    ##########################################
    [ ! -e /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh ] || . /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh
    DCECFG=$(GetRegVal /opt/dell/srvadmin/etc/omreg.cfg OMDataEngine.configtool)

    if [ -z "$DCECFG" ]; then
        # data engine not installed (not really possible)
        echo "Could not register data engine components because data engine not installed."
        exit 1
    fi

	# Prepare file access
    ${DCECFG} command=prepfileaccess dirpath=/opt/dell/srvadmin/etc/srvadmin-isvc/ini
    ${DCECFG} command=prepfileaccess dirpath=/opt/dell/srvadmin/var/log/openmanage
    ${DCECFG} command=prepfileaccess dirpath=/opt/dell/srvadmin/etc/srvadmin-isvc/ndx

    # Register Ndx info
    ${DCECFG} command=adddareg prefix=is product=Instrumentation enable=true

    CMD_ADDEPI="command=addepialias update=TRUE startuptype=automatic"
    CMD_ADDPOP="command=addpopalias update=TRUE startuptype=automatic"
    CMD_ADDMPI="command=addmpialias update=TRUE startuptype=automatic"

    ${DCECFG} ${CMD_ADDEPI} \
        aliasname=dcisep    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcisep.so" \
        dispatchfn=DCISEP_SMEventImplementerDispatch    \
        displayname="Instrumentation Service Event Plugin Implementer"

    ${DCECFG} ${CMD_ADDMPI} \
        aliasname=dcsfru    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcsfru.so" \
        dispatchfn=DCSFRU_SMMIBImplementerDispatch  \
        displayname="Field Replaceable Unit SNMP MIB Implementer"

    ${DCECFG} ${CMD_ADDMPI} \
        aliasname=dcsnis    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcsnis.so" \
        dispatchfn=DCSNIS_SMMIBImplementerDispatch  \
        displayname="Instrumentation Service SNMP MIB Implementer"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcadpt    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcadpt.so" \
        dispatchfn=DCADPT_SMPopulatorDispatch   \
        displayname="Adapter Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcosp \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcosp.so"  \
        dispatchfn=DCOSP_SMPopulatorDispatch    \
        displayname="Operating System Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dccoop    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdccoop.so" \
        dispatchfn=DCCOOP_SMPopulatorDispatch   \
        displayname="Cost of Ownership Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcsecp    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcsecp.so" \
        dispatchfn=DCSECP_SMPopulatorDispatch   \
        displayname="Security Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcwfm \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcwfm.so"  \
        dispatchfn=DCWFM_SMPopulatorDispatch    \
        displayname="Wired for Management Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dclra \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdclra.so"  \
        dispatchfn=DCLRA_SMPopulatorDispatch    \
        displayname="Local Response Agent Data Populator"

    if [ $(uname -m) = "i386" ]; then
    # ESM2 data populator is only supported on 32-bit systems
    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcesmp    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcesmp.so" \
        dispatchfn=DCESMP_SMPopulatorDispatch   \
        displayname="ESM2 Data Populator"
    fi

    if [ $(uname -m) = "i386" ]; then
    # TVM data populator is only supported on 32-bit systems
    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dctvm \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdctvm.so"  \
        dispatchfn=DCTVM_SMPopulatorDispatch    \
        displayname="TVM Data Populator"
    fi

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dciemp    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdciemp.so" \
        dispatchfn=DCIEMP_SMPopulatorDispatch   \
        displayname="IPMI Embedded Management Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcienv    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcienv.so" \
        dispatchfn=DCIENV_SMPopulatorDispatch   \
        displayname="IPMI Environmental Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcipm9    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcipm9.so" \
        dispatchfn=DCIPM9_SMPopulatorDispatch   \
        displayname="IPMI 0.9 Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcip10    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcip10.so" \
        dispatchfn=DCIP10_SMPopulatorDispatch   \
        displayname="IPMI 1.0 Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcifru    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcifru.so" \
        dispatchfn=DCIFRU_SMPopulatorDispatch   \
        displayname="IPMI Field Replaceable Unit Data Populator"

    ${DCECFG} ${CMD_ADDPOP} \
        aliasname=dcrac5    \
        pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcrac5.so" \
        dispatchfn=DCRAC5_SMPopulatorDispatch   \
        displayname="Remote Access Controller 5 Data Populator"


