<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
			<xsl:otherwise>debrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>

	<xsl:template match="/OMA">
    
    <HTML>    
			<head>
				<title><xsl:value-of select="$strAbout"/>&#160;
				<xsl:value-of select="normalize-space(OEM/OEMTitleCompanyName)"/><xsl:if test="normalize-space(OEM/OEMTitleCompanyName) != ''"><xsl:text> </xsl:text></xsl:if>
				<xsl:value-of select="normalize-space(OEM/OEMTitleCoreProductName)"/><xsl:if test="normalize-space(OEM/OEMTitleCoreProductName) != ''"><xsl:text> </xsl:text></xsl:if>
				<xsl:call-template name="Pref"><xsl:with-param name="prodname"><xsl:value-of select="OEM/ProdName" /></xsl:with-param></xsl:call-template></title>		
				<script src="/oma/js/favicon.js" type="text/javascript"></script>
				<script language="javascript">		
					changeFavicon('/oma/images/<xsl:value-of select="$brand"/>/favicon.ico'); 
				</script>
			</head>
					
					<frameset rows="100%" border="0">
						

				<frame name="about" scrolling="auto" marginheight="0" marginwidth="0" frameborder="no" framespacing="0" >
					<xsl:attribute name="src">./UDataArea?plugin=com.dell.oma.webplugins.AboutWebPlugin&amp;vid=<xsl:value-of select="VID"/></xsl:attribute> 
				</frame>	
			</frameset>
			<noframes />
		</HTML>
	</xsl:template>
		
	<xsl:template name="Pref">
		<xsl:param name="prodname"/>
		<xsl:choose>
			<xsl:when test="$prodname = 'Preferences'"><xsl:value-of select="$strPreferences"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>