<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>
<xsl:template match="SystemInfo">
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <link href="/oma/css/sysinfo.css" rel="stylesheet" type="text/css" />
    <title></title>
	<script language="javascript">
		function select () {
			try {
				if (parent.ct.g_bModal == false) {
					var vvid = top.gnv.getVID();
					parent.ct.g_bModal = true;
					parent.ct.location.href='./ComponentTree?refresh=true&amp;vid='+vvid;
				}
			}
			catch (e) {
			}
		}
	</script>

</head>
			<body>
			    <div class="sysinfo_padding">
				<div class="sysinfo_container">
				    <div class="sysinfo_top_left">
				    </div>
				    
				    <div class="sysinfo_background">
						<div class="sysinfo_text">
							<div class="sysinfo_hardware_name" id="system_name">
							 <a  href="#" onclick="javascript:select()">
								<xsl:attribute name="title"><xsl:value-of select="Server/@name"/></xsl:attribute>
								<xsl:choose>
									<xsl:when test="string-length(Server/@name)>15">
										<xsl:value-of select="substring(Server/@name, 1, 15)"/>...</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="Server/@name"/>
									</xsl:otherwise>
								</xsl:choose>
							</a>
							</div>
							<div class="sysinfo_hardware_type">
								<xsl:apply-templates select="System"/>			
							</div>
							<div class="sysinfo_user">
								<xsl:apply-templates select="User"/>			
							</div>
						</div>
			        </div>
                    <div class="sysinfo_top_right">
		    		</div>
					<div class="sysinfo_middle_left">
			        </div>
					<div class="sysinfo_middle_right">
			        </div>                 

		        </div>
		    </div>			            
</body>
</html>
</xsl:template>

<xsl:template match="System">
	<xsl:value-of select="ChassisInfo/ChassisProps1/ChassModel" />
</xsl:template>
<xsl:template match="User">
	<xsl:value-of select="@name" /><br/><xsl:value-of select="@rights" />
</xsl:template>

</xsl:stylesheet>
