<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >

  <xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>
<xsl:output method="html"/>
<xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
			<xsl:otherwise>debrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>
<xsl:template match="/OMA">
	<HTML>
	<HEAD>
     <xsl:choose>
		  <xsl:when test="$brand = 'dell'">
			<title>OpenManage<xsl:text disable-output-escaping="yes">&amp;trade;</xsl:text> Server Administrator</title>
		  </xsl:when>		  
		  <xsl:otherwise>
			<title>Server Administrator</title>
		  </xsl:otherwise>
	</xsl:choose>

    <link href="/oma/css/loginmaster.css" rel="stylesheet" type="text/css" />
    <style type="text/css"></style>
    <script language="javascript" src="/oma/js/prototype.js" type="text/javascript"></script>
    <script language="javascript" src="/oma/js/gnavbar.js" type="text/javascript"></script>
    <script language="javascript" src="/oma/js/Clarity.js" type="text/javascript"></script>
    <script src="/oma/js/favicon.js" type="text/javascript"></script>
    <script language="javascript">		
	changeFavicon('/oma/images/<xsl:value-of select="$brand"/>/favicon.ico'); 
    </script>
  </HEAD>
  <script language="javascript">
    var id = 0;
    function init() {
    if(id == 1)
    {
    //[ pp 03/18/2003 ] DFCT 75148: Adding code to determine if server is being rebooted
    // or shutdown so that appropriate message can be displayed during log out.
    // Changes for this defect are also included in shtdwnWebPlugin.java, OMSALogoutServlet.java,
    // ClBrowserWebPlugin.java, locond.xsl, clbrowser.xsl(code and str)
    <xsl:variable name="action"><xsl:value-of select="SvrAction"/></xsl:variable>
				<xsl:choose>
					<xsl:when test="$action='reboot'">document.getElementById("logout_message").innerHTML=<xsl:value-of select="$strRebootMsg"/>;</xsl:when>
					<xsl:otherwise>document.getElementById("logout_message").innerHTML=<xsl:value-of select="$strShtdwnMsg"/>;</xsl:otherwise>
				</xsl:choose>
				
				
			}
			if(id == 0)
			{
				id++;
			}
			var t1 = window.setTimeout("init()", 2000);
			
			
			<xsl:if test="ClBrowser/@login='true' and Remote='true'">
				document.getElementById("login").noWrap = true;
			</xsl:if>
			<xsl:if test="Remote='true'">
        var div_CloseBrowser = document.getElementById ("clbr");
        document.getElementById("clbr").noWrap = true;
        window.opener=top;
        //window.opener is still null we cannot close the window so lets hide "Close Browser" button
        if ( window.opener == null )
        {
        div_CloseBrowser.style.display = "none";
        }
      </xsl:if>
			
		
		}
	</script>
	<BODY onload="javascript:init()">
    <div class="login">
      <div class="login_header_brand">
       <xsl:attribute name="style">background-image:url('/oma/images/<xsl:value-of select="$brand"/>/login_table_header.png')</xsl:attribute>
        <xsl:choose>
		  <xsl:when test="$brand = 'dell'">
		   <img alt="OpenManage" title="Open Manage" >
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:when>
		  <xsl:otherwise>
		   <img>
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:otherwise>
	     </xsl:choose>       
      </div>
      <div class="login_left">
        <div class="login_right">
          <div class="logout_content">
            <div class="hr">
            </div>
            <xsl:if test="not(StopWebServer)">
              <div class="login_help">
                <a href="javascript:popUp.openWindow('./UOMSAHelp', 'null')" title="Help">
                  <span class="login_help_icon">
                    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                  </span>
                </a>
              </div>
            </xsl:if>

            <br></br>
            <div class="logout">
              <div class="logout_title">
                <!-- WARNING: Three-part order-dependent message goes here. -->
                <!-- Japanese wants the product name first; all other languages want it last. -->
                <xsl:value-of select="$strThankYouFor_Part1"/>
                <!-- Part2 of the three-part message is not used. -->
                <xsl:call-template name="ProdName">
                  <xsl:with-param name="prodname">
                    <xsl:value-of select="ProdName"/>
                  </xsl:with-param>
                </xsl:call-template>
                <xsl:value-of select="$strThankYouFor_Part3"/>
              </div>
                <div id ="logout_message" >
                  <!-- WARNING: Three-part order-dependent message goes here. -->
                  <!-- Japanese wants the product name first; all other languages want it last. -->
                  <xsl:value-of select="$strYouHaveSuccessfully_Part1"/>
                  <!-- Part2 of the three-part message is not used. -->
                  <xsl:call-template name="ProdName">
                    <xsl:with-param name="prodname">
                      <xsl:value-of select="ProdName"/>
                    </xsl:with-param>
                  </xsl:call-template>
                  <xsl:value-of select="$strYouHaveSuccessfully_Part3"/>
                </div>
            </div>
            <div class="hr">
            </div>
            <div>
              <div class="button_clear" id="login_buttons">
                <xsl:if test="Remote='true'">
                  <a class="blackpage_button_emphasized" id="clbr" href="javascript:window.close()">
                    <span>
                      <xsl:value-of select="$strClose160Browser"/>
                    </span>
                  </a>
                  <a id="login" class="blackpage_button">
                    <xsl:choose>
                      <xsl:when test="MANAGEDWS">
                        <xsl:attribute name="href">
                          <xsl:value-of select="Scheme"/>://<xsl:value-of select="ClBrowser/@ipaddress"/>:<xsl:value-of select="ClBrowser/@port"/><xsl:value-of select="ClBrowser/@appcontext"/>/OMSALogin?msgStatus=null&amp;manageDWS=<xsl:value-of select="MANAGEDWS" /></xsl:attribute>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:attribute name="href">
                          <xsl:value-of select="Scheme"/>://<xsl:value-of select="ClBrowser/@ipaddress"/>:<xsl:value-of select="ClBrowser/@port"/><xsl:value-of select="ClBrowser/@appcontext"/>/OMSALogin?msgStatus=null</xsl:attribute>
                      </xsl:otherwise>
                    </xsl:choose>
                    <span>
                      <xsl:value-of select="$strLog160in"/>
                    </span>
                  </a>
                </xsl:if>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="login_footer">
      </div>
      <div class="title_links">
        <a href="#" onclick="javascript:popUp.openWindow('http://support.dell.com/','support');">
          <xsl:value-of select="$strSupport"/>
        </a>
        <xsl:if test="not(StopWebServer)">
          |<a href="#" id="About" name="About" onclick="javascript:popUp.openWindow('./UOMSAAbout',  'notlogin');">
            <xsl:value-of select="$strAbout"/>
          </a>
        </xsl:if>
      </div>
    </div>
	</BODY>
	</HTML>
</xsl:template>
<xsl:template name="ProdName">
	<xsl:param name="prodname"/>
	<xsl:choose>
		<xsl:when test="$prodname = 'Preferences'"><xsl:value-of select="$strPreferences"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
