<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >

  <xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>
	<xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
			<xsl:otherwise>debrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>
	<xsl:template match="/OMA">
	<html>
	<head>
        <xsl:choose>
	<xsl:when test="$brand = 'dell'">
		<title>OpenManage<xsl:text disable-output-escaping="yes">&amp;trade;</xsl:text></title>
	</xsl:when>		  
	<xsl:otherwise>
		<title></title>
	</xsl:otherwise>
	</xsl:choose>
        <link href="/oma/css/loginmaster.css" rel="stylesheet" type="text/css" />
        <style type="text/css"></style>
        <script language="javascript" src="/oma/js/prototype.js" type="text/javascript"></script>
        <script language="javascript" src="/oma/js/gnavbar.js" type="text/javascript"></script>
        <script language="javascript" src="/oma/js/Clarity.js" type="text/javascript"></script>
				<script language="javascript">
           if(window != top) {
						// Load page in the top frame.
						top.location.href = window.location.href
					}
					// QueryString
					//

 




					function QueryString(key) {					 
						var value = null;
						for (var i = 0; i &lt; QueryString.keys.length; i++) {
							if (QueryString.keys[i]==key)
							{
								value = QueryString.values[i];
								break;
							}
						}
						return value;
					}
					QueryString.keys = new Array();
					QueryString.values = new Array();

					function QueryString_Parse()
					{
						var query = window.location.search.substring(1);
						var pairs = query.split("&amp;");
						
						for (var i = 0;i &lt; pairs.length; i++)
						{
							var pos = pairs[i].indexOf('=');
							if (pos >= 0)
							{
								var argname = pairs[i].substring(0,pos);
								var value = pairs[i].substring(pos+1);
								QueryString.keys[QueryString.keys.length] = argname;
								QueryString.values[QueryString.values.length] = value;		
							}
						}
					
					}
					
					QueryString_Parse();
				</script>
				<script language="javascript">
				    var sQueryString = "";
				        if(QueryString("mnip") != null) {
                              sQueryString += '&amp;mnip=' + QueryString("mnip");   
                              }
                            if(QueryString("authType") != null) {
                              sQueryString += '&amp;authType=' + QueryString("authType");    
                              sQueryString += '&amp;application=' + QueryString("application");
                            }
                            if(QueryString("locallogin") != null) {
                              sQueryString += '&amp;locallogin=' + QueryString("locallogin");    
                            }

					if (QueryString("denyLevel") == null) {
						document.write('&lt;meta http-equiv="REFRESH" content="0;url=./OMSALogin?msgStatus=' + QueryString("msgStatus") + sQueryString + '"&gt;');
					}
					else {
						document.write('&lt;meta http-equiv="REFRESH" content="0;url=./OMSALogin?msgStatus=' + QueryString("msgStatus") + '&amp;denyLevel=' + QueryString("denyLevel") + sQueryString + '"&gt;');
					}
                   	</script>

			</head>
      <noscript>
			<body >
        <div class="login">
          <div class="login_header_brand">
	  <xsl:attribute name="style">background-image:url('/oma/images/<xsl:value-of select="$brand"/>/login_table_header.png')</xsl:attribute>	           
	     <xsl:choose>
		  <xsl:when test="$brand = 'dell'">
		   <img alt="OpenManage" title="OpenManage" >
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:when>
		  <xsl:otherwise>
		   <img>
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:otherwise>
	     </xsl:choose> 
          </div>
          <div class="login_left">
            <div class="login_right">
              <div class="login_content">
                <div id="login_info" style="display: block;">
                  <div class="hr">
                  </div>
                     <div class="login_help">
                  
				<a href="./HelpViewer?file=Redirect&amp;app=oma" title="Help">
                      <span class="login_help_icon">
                        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                      </span>
                    </a>
                  </div>
                <br></br>

                </div>

                <div id="reboot">
                  <div id="login_failed_text">
                  </div>
                  <div id="server_reboot_message">
                    <xsl:value-of select="$strFailureReason"/>
                  </div>
                </div>
                <div class="hr">
                </div>
                <div>
                  <div class="button_clear" id="login_buttons">
                  </div>
                </div>
              </div>
            </div>
          </div>


          <div class="login_footer">
          </div>
          <div class="title_links">
          </div>
        </div>
		
			</body>
      </noscript>
		</html>
	</xsl:template>
</xsl:stylesheet>
