<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
  
  <xsl:variable name="chassisblade">
    <xsl:value-of select="/OMA/Chassisinfo/chassistype"/>
  </xsl:variable>
  
  <xsl:template match="/">
      <ComponentTree>
        <xsl:choose>
          <xsl:when test="$chassisblade=25 or $chassisblade=29">
            <xsl:call-template name="BladeCompTree"></xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="MonoCompTree"></xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </ComponentTree>
    </xsl:template>
    <!-- End of Main Component Tree -->

    <!-- template for chassistype 25 alone-->
  <xsl:template name="BladeCompTree">
    <Component name="Module" help="System">
      <xsl:attribute name="display">
        <xsl:value-of select ="$strModularChassis"/>
      </xsl:attribute>
      <xsl:call-template name="MonoCompTree"></xsl:call-template>
    </Component>
  </xsl:template>
   <!--template for the MonoCompTree-->
    <xsl:template name="MonoCompTree">
      <Component name="System" help="System">
        <xsl:choose>
          <xsl:when test="$chassisblade=25 or $chassisblade=29">
            <xsl:attribute name="display">
              <xsl:value-of select="$strBlade"/>
            </xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="display">
              <xsl:value-of select="$strSystem"/>
            </xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">     <!-- Show all things only when instrumentation is present -->       
        <SNBMenuItem name="Properties" help="">
			<xsl:attribute name="display"><xsl:value-of select="$strProperties"/></xsl:attribute>
			<LSNBMenuItem name="Health" default="true" href="./DataArea?plugin=com.dell.oma.webplugins.OverallHealthWebPlugin&amp;amp;component=System&amp;amp;root=true" help="OverallHealth">
				<xsl:attribute name="display"><xsl:value-of select="$strHealth"/></xsl:attribute>
			</LSNBMenuItem>
			<LSNBMenuItem name="Summary" href="./DataArea?plugin=com.dell.oma.webplugins.SummaryWebPlugin" help="Summary">
				<xsl:attribute name="display"><xsl:value-of select="$strSummary"/></xsl:attribute>
			</LSNBMenuItem>
		<!--	<LSNBMenuItem name="Software" display="Software" href="./DataArea?plugin=com.dell.oma.webplugins.SummaryWebPlugin&amp;amp;section=Software" help="Summary"/>-->
		</SNBMenuItem>
		<!-- Add entries for shutdown and logs as place holders for the HIP version of these items.-->
		<SNBMenuItem name="Shutdown" help="Shutdown" app="hip">
			<xsl:attribute name="display"><xsl:value-of select="$strShutdown"/></xsl:attribute>
		</SNBMenuItem>
		<SNBMenuItem name="Logs" help="HardwareLog" app="hip">
			<xsl:attribute name="display"><xsl:value-of select="$strLogs"/></xsl:attribute>
		</SNBMenuItem>
		
		<!--SNBMenuItem name="Update" help="">
			<xsl:attribute name="display"><xsl:value-of select="$strUpdate"/></xsl:attribute>
			<LSNBMenuItem name="Software" href="./DataArea?plugin=com.dell.oma.webplugins.UpdateWebPlugin" help="VersionReport">
				<xsl:attribute name="display"><xsl:value-of select="$strSoftware"/></xsl:attribute>
			</LSNBMenuItem>
		</SNBMenuItem!-->
		
		<!--SNBMenuItem name="Inventory" help="">
			<xsl:attribute name="display"><xsl:value-of select="$strInventory"/></xsl:attribute>
			<LSNBMenuItem name="Inventory" href="./DataArea?plugin=com.dell.oma.webplugins.InventoryWebPlugin" help="InventoryReport">
				<xsl:attribute name="display"><xsl:value-of select="$strInventory"/></xsl:attribute>
			</LSNBMenuItem>
		</SNBMenuItem-->

		<Component name="Software" help="">
			<xsl:attribute name="display"><xsl:value-of select="$strSoftware1"/></xsl:attribute>
			<SNBMenuItem name="Properties" help="">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties1"/></xsl:attribute>
				<LSNBMenuItem name="Summary" href="./DataArea?plugin=com.dell.oma.webplugins.SummaryWebPlugin&amp;amp;section=Software" help="Software">
					<xsl:attribute name="display"><xsl:value-of select="$strSummary1"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
		</Component>
	</xsl:if>  <!-- Show all things only when instrumentation is present -->		
        <xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">     <!-- Show storage only when instrumentation is present -->       		
		<Component name="Storage" help="">
			<xsl:attribute name="display"><xsl:value-of select="$strStorage"/></xsl:attribute>
			<SNBMenuItem name="Properties" help="">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties2"/></xsl:attribute>
			</SNBMenuItem>
		</Component>
	</xsl:if>	 <!-- Show storage only when instrumentation is present --> 
	</Component>
</xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
