<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
	<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>	
	<xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
			<xsl:otherwise>debrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>
	<xsl:template match="/OMA">		
		<xsl:apply-templates select="Login"/>
	</xsl:template>
	<xsl:template match="Login">
		<html>
	<head>
		
		<xsl:choose>
		  <xsl:when test="$brand = 'dell'">
			<title>OpenManage</title>
		  </xsl:when>		  
		  <xsl:otherwise>
			<title></title>
		  </xsl:otherwise>
		</xsl:choose>
		<link href="/oma/css/loginmaster.css" rel="stylesheet" type="text/css" />
		<script language="javascript" src="/oma/js/prototype.js" type="text/javascript"></script>
		<script language="javascript" src="/oma/js/gnavbar.js" type="text/javascript"></script>
		<script language="javascript" src="/oma/js/Clarity.js" type="text/javascript"></script>
    
    <!--For preloading of images-->
    <script type="text/javascript">
      
      var images = new Array();
      images[0] = "/oma/images/login_progress.gif";
      images[1] = "/oma/images/blackpage_button_right_emphasized.png";
      images[2] = "/oma/images/blackpage_button_left_emphasized.png";
      images[3] = "/oma/images/blackpage_button_right.png";
      images[4] = "/oma/images/blackpage_button_left.png";
	  images[5] = "/oma/images/blackpage_button_right_emphasized_hover.png";
      images[6] = "/oma/images/blackpage_button_left_emphasized_hover.png";
      images[7] = "/oma/images/blackpage_button_right_hover.png";
      images[8] = "/oma/images/blackpage_button_left_hover.png";
	  
      var i = 0;
      for(i=0; i&lt;=8; i++){
		preload_image_object = new Image();
        preload_image_object.src = images[i];
      }
    </script>


    <script type="text/javascript">

    function gotoTryAgain()
    {
      login.showTryAgain();
    }


    var login = {
    loginFailed: null,
    clicked: null,
    showProgress: function (obj) {
    if (!login.clicked) {
    login.clicked = true;
    $('login_info').hide();
    $('login_failed').hide();
    $('login_submit').className = 'blackpage_button_emphasized_clicked';
    $('login_progress').show();
    
    }
    },
    showFailed: function() {
    $('login_info').hide();
    $('login_progress').hide();
    $('login_buttons').hide();
    $('login_failed').show();
    $('login_failed_buttons').show();
    login.loginFailed = 1;
    login.clicked = false;
    setTimeout(login.showTryAgain, 30000);
    },
    showTryAgain: function() {
    $('login_failed').hide();
    $('login_progress').hide();
    $('login_failed_buttons').hide();
    $('login_info').show();
    $('login_buttons').show();
    $('login_submit').className = 'blackpage_button_emphasized';
    login.clicked = false;
    },
    reset: function(obj) {
    obj.href = "login.html";
    }
    }
  </script>
			<script language="javascript">
				var cancel = 'false';
				var ok = 'false';
				var username = 'false';
				var password = 'false';
				var ADarray = new Array();
				var browserValidateReturnValue=2;
        var haveDomain = 'false';

		
                <!-- if have any domains for list then set flag --> 
		<xsl:if test="DomainList">
                    <xsl:text>haveDomain='true';</xsl:text>
                </xsl:if>


                <xsl:for-each select="/OMA/InstalledProducts/Product">           
                <xsl:if test="ADSupport='true'">
                  <xsl:text>ADarray[</xsl:text>
				  <xsl:value-of select="position()-1"/>
				  <xsl:text>] = "</xsl:text>
			      <xsl:value-of select="ID"/> 
				  <xsl:text>"; </xsl:text>   
			    </xsl:if>	         
	  		    </xsl:for-each>
	  		    
                function isADEnabled(val) {
				   var i = 0;
				   while(ADarray[i] != null)
				    {
                       if(ADarray[i] == val)
                           return true;
						   
					   i++;	               
                    }
                 }        
                 
		

		function setLocalLogin() {
                  <xsl:if test="OSType='1'"> <!-- windows only -->

                    if(haveDomain == 'false')
                      {
                        <!-- if have no domains in list, then disable active directory checkbox --> 
                        <!-- ad disabled -->
                    document.login.locallogin.checked=false;
                    document.getElementById("activedirectory").style.visibility = "hidden";
                    document.getElementById("locallogintext").style.visibility = "hidden";
                    return;
                    }

                    so = document.login.application.options;
                    <!-- do we have only one product -->
                    if(document.login.application.type == "hidden") {
                      if(isADEnabled(document.login.application.value)) {
                         // only one application installed
                         <!-- ad enabled -->
                         document.login.locallogin.checked=false;
                         document.getElementById("locallogintext").style.visibility = "visible";
                        }
                       else {
                         <!-- ad disabled -->
                    document.login.locallogin.checked=false;
                    document.getElementById("activedirectory").style.visibility = "hidden";
                    document.getElementById("locallogintext").style.visibility = "hidden";
                    }
                    }
                    else
                    {
                    <!-- do we have multiple products -->
                        if(isADEnabled(so[so.selectedIndex].value))
                          {
                           <!-- ad enabled -->
                          document.login.locallogin.checked=false;
                          document.getElementById("locallogintext").style.visibility="visible";
                          }
                        else {
                          <!-- ad disabled -->
                    if(document.getElementById) {
                    document.login.locallogin.checked=false;
                    document.getElementById("activedirectory").style.visibility = "hidden";
                    document.getElementById("locallogintext").style.visibility = "hidden";
                    }
                    }
                    }
                  </xsl:if>
	                 <xsl:if test="/OMA/MANAGEDWS='true'">
	                 <xsl:choose>
	                 	<xsl:when test="OSType='1'"></xsl:when>
	                 	<xsl:otherwise>
                      document.login.locallogin.checked=false;
                      document.getElementById("activedirectory").style.visibility = "hidden";
                      document.getElementById("locallogintext").style.visibility = "hidden";
                    </xsl:otherwise>
	                 </xsl:choose>	
	                 </xsl:if>
	                 
                    }

          
				function setCancel(val){
					cancel = val;
				}
				function setOk(val){
					ok = val;
				}
				function setUsername(val){
					username = val;
				}
				function setPassword(val){
					password = val;
				}

				
				function init() {
				<xsl:choose>
				<xsl:when test="/OMA/MANAGEDWS='true'">
				    setLocalLogin(); 
				</xsl:when>    
				<xsl:otherwise>
				    	document.login.ignorecertificate.checked=false;
				 </xsl:otherwise>
				 </xsl:choose>

        QueryString_Parse();
        if(QueryString("msgStatus") != "false" )
        {
        document.getElementById("login_failed").style.visibility = "hidden";
        }
        else{
        login.showFailed();
        if (QueryString("UserEmpty") == "true")
        {
        document.getElementById("login_failed").style.visibility = "visible";
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strUserName_Blank"/>";
        }
        if (QueryString("PasswordEmpty") == "true")
        {
        document.getElementById("login_failed").style.visibility = "visible";
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strPassword_Blank"/>";
        }
        if (QueryString("denyLevel") == null)
        {
        document.getElementById("login_failed").style.visibility = "visible";
        if (QueryString("wsErr") != null)
        {
        var msgVal = QueryString("wsErr");
        if( msgVal == "2")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strHostname_IPAddress_Blank"/>";
		else if( msgVal == "1" )
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_COULDNT_CONNECT"/>";
        else if( msgVal == "4")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_URL_MALFORMAT"/>";
        else if( msgVal == "6")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_COULDNT_RESOLVE_HOST"/>";
        else if( msgVal == "7" )
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_COULDNT_CONNECT"/>";
        else if( msgVal == "11")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_OUT_OF_MEMORY"/>";
        else if( msgVal == "12")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_OPERATION_TIMEOUTED"/>";
                  <!-- 17, 21 and 22 are specific for Linux cert errors -->
        else if( msgVal == "16" || msgVal == "17" || msgVal == "20" || msgVal == "21")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_SSL_CONNECT_ERROR"/>";
        else if( msgVal == "26")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_LOGIN_DENIED"/>";
        else if( msgVal == "27")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_BAD_CRL_FILE"/>";
        else if( msgVal == "401")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strPassword_Blank"/>";
		else if( msgVal == "500" )
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_COULDNT_CONNECT"/>";
		else if( msgVal == "503" )
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_COULDNT_CONNECT"/>";
        else if( msgVal == "1201")
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_LASTERR_LCK_DWN_MODE"/>";
        else
        document.getElementById("login_failed_message").innerHTML += "<xsl:value-of select="$strWS_INTERNAL_ERROR"/>";
        }
        else if(QueryString("versionErr") == "true")
        {
        document.getElementById("login_failed_message").innerHTML = "<xsl:value-of select="$strProductVersionError"/>";
        }
        else if(QueryString("portErr") == "true")
        {
        document.getElementById("login_failed_message").innerHTML = "<xsl:value-of select="$strPortError"/>";
        }

        }
        else {
        if (QueryString("denyLevel") == "usr") {
        document.getElementById("login_failed").style.visibility = "visible";
        document.getElementById("login_failed_message").innerHTML = <xsl:value-of select="$strDenyLevelUser"/>;
        }
        else if (QueryString("denyLevel") == "pwrusr") {
        document.getElementById("login_failed").style.visibility = "visible";
        document.getElementById("login_failed_message").innerHTML = <xsl:value-of select="$strDenyLevelPwrUser"/>;
        }
        else if (QueryString("denyLevel") == "adminonly") {
        document.getElementById("login_failed").style.visibility = "visible";
        document.getElementById("login_failed_message").innerHTML = <xsl:value-of select="$strDenyLevelAdminOnly"/>;
        }
        else {
        document.getElementById("login_failed").style.visibility = "visible";
        }
        }
        }
        <xsl:if test="/OMA/ProductNum > '1'">
						if ((QueryString("mode") != null)  &amp;&amp; (QueryString("mode") != "")){
							for(var i = 0 ; i &lt;  document.getElementById("application").options.length ; i++){
								if (QueryString("mode") == document.getElementById("application").options[i].value){
									document.getElementById("application").options[i].selected = true;
									break;
								}
							}
						}
						else{
							for(var i = 0 ; i &lt;  document.getElementById("application").options.length ; i++){
								if (document.getElementById("application").options[i].value == "omsa"){
									document.getElementById("application").options[i].selected = true;
									break;
								}
							}
						}
					</xsl:if>
					browserValidateReturnValue=browserValidate();
					if (browserValidateReturnValue==0)
					{
						<xsl:choose>
							<xsl:when test="/OMA/MANAGEDWS='true'">
                try{
                document.login.user.focus();
                }catch(e){}
              </xsl:when>
              <xsl:otherwise>
                try{
                document.login.targetmachine.focus();
                }catch(e){}
              </xsl:otherwise>
						</xsl:choose>
        }
        else
        if(browserValidateReturnValue==1)
        {
		login.showFailed();
	  document.getElementById("login_failed_text").innerHTML = "";
        document.getElementById("login_failed_message").innerHTML = "<xsl:value-of select="$strBrowserVersionToo"/>";
        document.getElementById("login_failed").style.visibility = "visible";
        }
        else
        if(browserValidateReturnValue==2)
        {
		login.showFailed();
	  document.getElementById("login_failed_text").innerHTML = "";
        document.getElementById("login_failed_message").innerHTML = "<xsl:value-of select="$strBrowserTypeUnsupported"/>";
        document.getElementById("login_failed").style.visibility = "visible";
        }
        }


        //
        // QueryString
        //

        function QueryString(key)
        {
        var value = null;
        for (var i=0;i&lt;QueryString.keys.length;i++)
        {
        if (QueryString.keys[i]==key)
        {
        value = QueryString.values[i];
        break;
        }
        }
        return value;
        }

        function QueryString_Parse()
        {
        QueryString.keys = new Array();
        QueryString.values = new Array();
        var query = parent.location.search.substring(1);
        var pairs = query.split('&amp;');
					
					for (var i=0;i&lt;pairs.length;i++)
					{
						var pos = pairs[i].indexOf('=');
						if (pos &gt;= 0)
        {
        var argname = pairs[i].substring(0,pos);
        var value = pairs[i].substring(pos+1);
        QueryString.keys[QueryString.keys.length] = argname;
        QueryString.values[QueryString.values.length] = value;
        }
        }

        }

        function showPortError(flag)
        {
        if( flag == false )
        {
        document.getElementById("login_failed").style.visibility="hidden";
        }
        else
        {
		login.showFailed();
        document.getElementById("login_failed").style.visibility="visible";
        document.getElementById("login_failed_message").innerHTML = "<xsl:value-of select="$strPortErrorClient"/>";
				}
				}
				function validatePort(port)
				{
					showPortError(false);
					if(isNaN(port))
					{
						showPortError(true);
						return -1;
					}
					var val = parseInt(port);
					if(val &lt; 0 || val &gt; 65535)
        {
        showPortError(true);
        return -1;
        }

        return 0;
        }

        function formSubmit(){
        //document.getElementById("login_progress_text").style.visibility="visible";
        //document.getElementById("login_progress_text").innerHTML = <xsl:value-of select="$strLoading"/>;
        setTimeout(login.showProgress(this), 3000);
        }

        function frmSubmit () {

        login.showProgress(this);
        <xsl:choose>
					<xsl:when test="/OMA/MANAGEDWS='true'">  						
						document.login.action=document.login.action+"&amp;managedws=true";
					</xsl:when>
					<xsl:otherwise>
					if(document.login.targetmachine)
						{
							var mnip = document.login.targetmachine.value;
							var pos = mnip.indexOf("]");
							var pcolon = mnip.lastIndexOf(":");
							var port = "";
							if( pcolon != -1 )
							{
								if(pos == -1)
								{
									port = mnip.substring(pcolon+1,mnip.length);
									if( validatePort(port) == -1 )
									{
										return -1;
									}
									
								}
								else
								{
									if(pos != (mnip.length-1))
									{
										port = mnip.substring(pcolon+1,mnip.length);
										if( validatePort(port) == -1 )
										{
												return -1;
										}
									}
								
								}
							}
								
						}

						document.login.action=document.login.action+"&amp;managedws=false";
					</xsl:otherwise>
					</xsl:choose>
				
					document.login.submit();
									
					QueryString_Parse();
					
					var msgstat = QueryString("msgStatus");
								
					//document.getElementById("login_progress_text").style.visibility="visible";					
					//document.getElementById("login_progress_text").innerHTML = <xsl:value-of select="$strLoading"/>;
          }
				
				function keyselect (evt) {
					var keyCode = evt.keyCode || evt.which;
						if(keyCode == 13) {
						
							if(cancel == 'false')
							{
								<!-- If you press enter in screen it will submit the form
								     irrespective of whether you are in focus with username, password fields or not 
								-->
								if(ok == 'false')
									frmSubmit();
							}
							else
							{
								frmCancel();
							}
						}

				}
				function frmCancel() {
					document.login.user.value="";
					document.login.password.value="";
					if(document.login.locallogin)
						document.login.locallogin.checked=false;					
					<xsl:choose>
					<xsl:when test="/OMA/MANAGEDWS='true'">
						document.login.user.focus();
					</xsl:when>
					<xsl:otherwise>
						document.login.targetmachine.value="";
						document.login.ignorecertificate.checked=false;
						document.login.targetmachine.focus();
					</xsl:otherwise>
					</xsl:choose>
				}
				
				function browserValidate()
				{
				
				//	<!-- Return Value =0 for Supported Browser ;Return Value =2 for UnSupported Browser -->
					var BrowserSupportStatusReturnValue=2;
					if((BrowserSupportStatusReturnValue=BrowserSupportStatusIE())!=2)								
					{
					return BrowserSupportStatusReturnValue;
					}
					if((BrowserSupportStatusReturnValue=BrowserSupportStatusIE11andAbove())!=2)		<!-- navigator.appName value comes as Netscape for IE11 and above versions-->		
					{		
					return BrowserSupportStatusReturnValue;
					}
					if((BrowserSupportStatusReturnValue=BrowserSupportStatusFireFox())!=2)				
					{		
					return BrowserSupportStatusReturnValue;
					}
					if((BrowserSupportStatusReturnValue=BrowserSupportStatusChrome())!=2)				
					{		
					return BrowserSupportStatusReturnValue;
					}
					if((BrowserSupportStatusReturnValue=BrowserSupportStatusSafari())!=2)				
					{		
					return BrowserSupportStatusReturnValue;
					}
					return BrowserSupportStatusReturnValue;
				}
				
				function BrowserSupportStatusIE(){
					var returnvalue = 2;
					if (navigator.appName == "Microsoft Internet Explorer")
					{ 
						var sAppVersion = navigator.appVersion;
						sAppVersion = sAppVersion.replace (/.*MSIE /i, "");
						sAppVersion = sAppVersion.split (';')[0];
						if ( (parseInt(sAppVersion) == parseInt('6.0'))  || (parseInt(sAppVersion) &lt; parseInt('6.0') ))
						{
							returnvalue = 1;
						}
						else
						{
							returnvalue = 0;
						}
					}
					return returnvalue;
				}


				function BrowserSupportStatusIE11andAbove(){
					var returnvalue = 2;
					if (navigator.userAgent.indexOf("Mozilla/") != -1)
					{ 
							var sAppVersion = navigator.userAgent;
							sAppVersion = sAppVersion.split (' ');
							var sAppVersion1 = sAppVersion[sAppVersion.length -3];
							sAppVersion = sAppVersion1.split (')');
							sAppVersion1 = sAppVersion[sAppVersion.length -2];
							sAppVersion = sAppVersion1.split (':');
							sAppVersion = sAppVersion[sAppVersion.length -1];
							if (parseInt(sAppVersion1) &lt; parseInt('10.0'))
							{
								returnvalue = 1;
							}else{
								returnvalue = 0;
							}
					}
					return returnvalue;
				}


				function BrowserSupportStatusFireFox(){				
					var returnvalue = 2;
					if(navigator.userAgent.indexOf("Firefox/") != -1)
					{		
							var sAppVersion = navigator.userAgent;
							sAppVersion = sAppVersion.split (' ');
							var sAppVersion1 = sAppVersion[sAppVersion.length -1];
							sAppVersion = sAppVersion1.split ('/');
							sAppVersion1 = sAppVersion[sAppVersion.length -1];
							sAppVersion = sAppVersion1.split ('.');
							sAppVersion1 = sAppVersion[0]+'.'+sAppVersion[1];
							if (parseInt(sAppVersion1) &lt; parseInt('3.0'))
							{
								returnvalue = 1;
							}else{
								returnvalue = 0;
							}	
					}
					return returnvalue;					
				}

				function BrowserSupportStatusChrome(){				
					var returnvalue = 2;
					if(navigator.userAgent.indexOf("Chrome/") != -1)
					{		
							var sAppVersion = navigator.userAgent;
							sAppVersion = sAppVersion.split (' ');
							var sAppVersion1 = sAppVersion[sAppVersion.length -2];
							sAppVersion = sAppVersion1.split ('/');
							sAppVersion1 = sAppVersion[sAppVersion.length -1];
							sAppVersion = sAppVersion1.split ('.');
							sAppVersion1 = sAppVersion[0]+'.'+sAppVersion[1];
							if (parseInt(sAppVersion1) &lt; parseInt('16.0'))
							{
								returnvalue = 1;
							}else{
								returnvalue = 0;
							}	
					}
					return returnvalue;					
				}
				
				function BrowserSupportStatusSafari(){	
					var returnvalue = 2;
					if(navigator.userAgent.indexOf("Safari/") != -1)
					{		
							var sAppVersion = navigator.appVersion;
							sAppVersion = sAppVersion.split (' ');
							var sAppVersion1="1";
							if(sAppVersion.length > 0)
							{							
							 sAppVersion1 = sAppVersion[0];
							}

							if (parseInt(sAppVersion1) &lt; parseInt('5.0'))
							{
								returnvalue = 1;
							}else{
								returnvalue = 0;
							}	
					}
						
					return returnvalue;					
				}
				

</script>
</head>
	<body leftmargin="0" onload="init()" onKeypress="javascript:keyselect (event);">
    <div class="login">
      <div class="login_header_brand">
	<xsl:attribute name="style">background-image:url('/oma/images/<xsl:value-of select="$brand"/>/login_table_header.png')</xsl:attribute>	 
	 <xsl:choose>
		  <xsl:when test="$brand = 'dell'">
		   <img alt="OpenManage" title="OpenManage" >
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:when>
		  <xsl:otherwise>
		   <img>
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:otherwise>
	     </xsl:choose>   
      </div>
      <div class="login_left">
        <div class="login_right">
          <div class="login_content">
            <div id="login_info" style="display: block;">
              <div class="hr">
              </div>
              <div class="login_help">
                <a href="javascript:popUp.openWindow('./UOMSAHelp' , 'null')">
                   <xsl:attribute name="title"><xsl:value-of select="$strHelp"/></xsl:attribute>
                  <span class="login_help_icon">
                    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                  </span>
                </a>
              </div>
              <div class="login_title">
                <div class="login_text" nowrap="">
                  <xsl:choose>
                    <xsl:when test="/OMA/MANAGEDWS='true'">
                      <xsl:choose>
                      <xsl:when test="/OMA/LEGACY='true'">
                          <xsl:value-of select="$strLogIn"/>
                      </xsl:when>
                       <xsl:otherwise>
                        <xsl:value-of select="$strWebLogIn"/>
                       </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$strRemoteLogIn"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </div>
              </div>
              <div class="login_server_info">
                <span class="login_server_name">
                  <xsl:value-of select="/OMA/Server/@name"/>
                </span>  
                <xsl:if test="/OMA/ChassisInfo">
                  |<span class="login_server_type" id="sys-info">
                    <xsl:value-of select="/OMA/ChassisInfo/ChassisProps1/ChassModel" />
                  </span>
                </xsl:if>
              </div>
              <div class="login_instructional_text">
                <xsl:choose>
                  <xsl:when test="/OMA/MANAGEDWS='true'">
                    <xsl:value-of select="$strTypeInUsername"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$strTypeRemoteNode"/>
                  </xsl:otherwise>
                </xsl:choose>
              </div>
              <div class="login_userinfo">
                <FORM AUTOCOMPLETE="OFF" method="post" name="login" action="./LoginServlet?flag=true" target="_top">
                  <input type="hidden" name="manuallogin" value="true"/>
                  <table>
                    <xsl:choose>
                      <xsl:when test="/OMA/MANAGEDWS='true'"></xsl:when>
                      <xsl:otherwise>
                        <tr>
                          <td class="left">
                            <span>
                              <xsl:value-of select="$strHostname_IPAddress"/>
                            </span>
                          </td>
                        </tr>
                        <tr>
                          <td class="left input" style="width: 150px;">
                            <input class="login"  type="text" size="20" maxlength="256" name="targetmachine" style="width: 150px">
                              <xsl:if test="/OMA/mnip">
                                <xsl:attribute name="value">
                                  <xsl:value-of select="/OMA/mnip"/>
                                </xsl:attribute>
                              </xsl:if>
                            </input>
                          </td>
                       </tr>
                      </xsl:otherwise>
                    </xsl:choose>
                    <tr>
                      <td class="left">
                        <span>
                          <xsl:value-of select="$strUsername"/>
                        </span>
                      </td>

                      <td class="right">
                        <span>
                          <xsl:value-of select="$strPassword"/>
                        </span>
                      </td>
                    </tr>
                    <tr>
                      <td class="left input" style="width: 111px">
                        <input class="login" name="user" maxlength="256" size="20" type="text" onblur="javascript:setUsername('false')" onFocus="javascript:setUsername('true')" style="width: 150px" />
                      </td>
                      <td class="right input" style="width: 150px;">
                        <input class="login" onFocus="javascript:setPassword('true')" onblur="javascript:setPassword('false')" type="password" size="20" maxlength="256" name="password"  style="width: 150px" />
                      </td>
                    </tr>
                    
                    <xsl:apply-templates select="/OMA/InstalledProducts"/>
                    
                    <tr>
                      <td class="left" colspan="2" nowrap="nowrap">
                        <input type="checkbox" class="checkbox" id="locallogintext" value="1" name="locallogin"/>
                        <span class="checkbox" id="activedirectory">
                          <xsl:value-of select="$strLocalLogin"/>
                        </span>
                      <xsl:choose>
                        <xsl:when test="/OMA/MANAGEDWS='true'"></xsl:when>
                        <xsl:otherwise>
                              <input type="checkbox" value="1" class="checkbox" name="ignorecertificate" />
                              <span class="checkbox">
                                <xsl:value-of select="$strIgnoreCertificateWarnings"/>
                              </span>
                        </xsl:otherwise>
                    </xsl:choose>
                      </td>
                    </tr>
                  </table>
                </FORM>
                </div>
              <div class="hr">
              </div>
            </div>
            
            <div id="login_progress" style="display: none;">
              <div class="hr">
              </div>
              <div id="login_progress_text">
                <xsl:value-of select="$strLoading"/>
              </div>
              <div class="hr">
              </div>
            </div>
            
            <div id="login_failed" style="display: none;">
			<div class="login_failed_hr_top">
              </div>
              <div id="login_failed_text" nowrap="nowrap">
                <xsl:value-of select="$strLoginFailed"/>
              </div>
              <div id="login_failed_message"></div>
			   <div class="login_failed_hr_bottom">
              </div>
              </div>

            <div>
              <div class="button_clear" id="login_buttons">
                <a id="login_submit" class="blackpage_button_emphasized" onclick="javascript:frmSubmit();" href="#">
                  <span>
                    <xsl:value-of select="$strSubmit"/>
                  </span>
                </a>
                <a class="blackpage_button" href="#" onclick="javascript:frmCancel();">
                  <span>
                    <xsl:value-of select="$strCancel"/>
                  </span>
                </a>
              </div>
              <div class="button_clear" id="login_failed_buttons" style="display: none;">
                <a class="blackpage_button" onclick="javascript:gotoTryAgain();" href="#">
                  <span>
                    <xsl:value-of select="$strTryAgain"/>
                  </span>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="login_footer">
      </div>
      <div class="title_links">
        <xsl:choose>
          <xsl:when test="/OMA/MANAGEDWS='true'">
            <a href="#" id="ManageWS" name="ManageWS" onclick="javascript:gotoURL ('./OMSALogin?manageDWS=false')">
              <xsl:value-of select="$strManageRemoteMN"/>
            </a>|
          </xsl:when>
          <xsl:when test="/OMA/MANAGEDWS='false' and /OMA/LEGACY='true'">
            <a href="#" id="ManageWS" name="ManageWS" onclick="javascript:gotoURL ('./OMSALogin?manageDWS=true')">
              <xsl:value-of select="$strManageLocalnode"/>
            </a>|
          </xsl:when>
          <xsl:when test="/OMA/MANAGEDWS='false'">
            <a href="#" id="ManageWS" name="ManageWS" onclick="javascript:gotoURL ('./OMSALogin?manageDWS=true')" >
              <xsl:value-of select="$strManageWebServer"/>
            </a>|
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>

        <xsl:choose>
		  <xsl:when test="$brand = 'debrand'">
			<a href="#" onclick="javascript:popUp.openWindow('./SupportPageServlet','support');">
			<xsl:value-of select="$strSupport"/>
			</a>
		  </xsl:when>
		  <xsl:when test="$brand = 'dell'">
			<a href="#" onclick="javascript:popUp.openWindow('http://support.dell.com/','support');">
			<xsl:value-of select="$strSupport"/>
			</a>
		  </xsl:when>
		  <xsl:otherwise>
			<a href="#" onclick="javascript:popUp.openWindow('http://support.dell.com/','support');">
			<xsl:value-of select="$strSupport"/>
			</a>
		  </xsl:otherwise>
	  </xsl:choose> |
        <a  href="#" id="About" name="About" onclick="javascript:popUp.openWindow('./UOMSAAbout','notlogin');">
          <xsl:value-of select="$strAbout"/>
        </a>
      </div>
    </div>
</body>
</html>
</xsl:template>


	<xsl:template name="button_details">
		<xsl:param name="display" />
		<xsl:param name="href" />
		<xsl:param name="id" />
		<xsl:param name="onclick" />
		<td align="center" valign="middle" style="width: 80px">
			<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$href" /></xsl:attribute>
				<xsl:attribute name="onclick"><xsl:value-of select="$onclick" /></xsl:attribute>
				<xsl:attribute name="id"><xsl:value-of select="$display" /></xsl:attribute>
				<xsl:attribute name="name"><xsl:value-of select="$display" /></xsl:attribute>
				<xsl:if test="$id='cancel'">
					<xsl:attribute name="onFocus">javascript:setCancel('true');</xsl:attribute>
					<xsl:attribute name="onblur">javascript:setCancel('false');</xsl:attribute>
				</xsl:if>
				<xsl:if test="$id='ok'">
					<xsl:attribute name="onFocus">javascript:setOk('true');</xsl:attribute>
					<xsl:attribute name="onblur">javascript:setOk('false');</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="$display" />
			</a>
		</td>
	</xsl:template>

	<xsl:template match="/OMA/InstalledProducts">
		<xsl:if test="Product">
		<tr>
      <td class="left" colspan="2">
        <span><xsl:value-of select="$strApplication"/></span>
        <xsl:choose>
          <xsl:when test="/OMA/ProductNum = '1'">
            <span class="application" id="application">
              <xsl:value-of select="Product/Name"/>
            </span>
            <xsl:element name="input">
              <xsl:attribute name="type">hidden</xsl:attribute>
              <xsl:attribute name="name">application</xsl:attribute>
              <xsl:attribute name="id">application</xsl:attribute>
              <xsl:attribute name="value">
                <xsl:value-of select="Product/ID"/>
              </xsl:attribute>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
              <select name="application" onchange="javascript:setLocalLogin()">
                <xsl:for-each select="Product">
                  <xsl:variable name="var" select="ID"/>
                  <option value="{$var}">
                    <xsl:value-of select="Name"/>
                  </option>
                </xsl:for-each>
              </select>
          </xsl:otherwise>
        </xsl:choose>
      </td>
		</tr>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>

