<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
  <xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="DataArea">
		<html>
			<head>
				<title/>
				<!-- Comment 1: -->
				<xsl:choose>
					<xsl:when test="ProgressBar/@progressdata='true'"><!-- Do nothing here --></xsl:when>
					<xsl:otherwise>
						<link rel="stylesheet" type="text/css" href="/oma/css/stylesheet.css"/>
						<link rel="stylesheet" type="text/css" href="/oma/css/clarity.css"/>
						<script language="javascript">							
							if (navigator.appName == "Microsoft Internet Explorer")
							{
								document.write('<link rel="stylesheet" type="text/css" href="/oma/css/iehacks.css"/>');
							}	
						</script>
						<xsl:if test="not(@nographics)">
						<script language="javascript">
							document.write('<style>');
							document.write('DIV.table_gutter{min-width: 700px;}');
							document.write('</style>');
						</script>	
						</xsl:if>
						<script type="text/javascript" src="/oma/js/prototype.js"></script> 
						<script type="text/javascript" src="/oma/js/prototype-adapter.js"></script>
						<script type="text/javascript" src="/oma/js/scriptaculous.js"></script>							
						<script type="text/javascript" src="/oma/js/Clarity.js"></script> 
						<script type="text/javascript" src="/oma/js/global.js"></script> 
						<xsl:if test="/OMA/@component != ''">
							<script type="text/javascript" src="/oma/js/dabb.js"></script>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Comment 1: END-->
				<script language="javascript">
					function g_appendVid_InvokeAction(var1)
					{
						var1 = top.gnv.appendVID(var1);
						document.location.href = var1;
							
					}
				</script>
				
				<script language="javascript">
					var g_bSubmit = false;
					var g_bStopOldRefresh = false; 
					var numOfTables = 0;
					var g_sPrintURL = '<xsl:value-of select="@printURL"/>';
					
					<!-- Comment 2: -->
					<xsl:choose>
						<xsl:when test="@onLoad ='true'">
							moreFuncInInit = new Boolean(true);
						</xsl:when>
						<xsl:otherwise>
							moreFuncInInit = new Boolean(false);
						</xsl:otherwise>
					</xsl:choose>
					<!-- Comment 2: END-->
					<!-- Comment 3: -->
					<xsl:choose>
						<!-- Comment 4: -->
						<xsl:when test="@progressbar='true'">
							<xsl:choose>
								<!-- Comment 5: -->
								<xsl:when test="ProgressBar/@progressdata='true'">
									function init()
									{
										<xsl:for-each select="ProgressBar/ProgressData/DataBar">
											parent.updateProgressBar('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', '<xsl:value-of select="@percentcomplete"/>', <xsl:value-of select="@execstatus"/>, '<xsl:value-of select="@allpassesdone"/>', '<xsl:value-of select="@passnum"/>', '<xsl:value-of select="@totalpasses"/>','<xsl:value-of select="@message"/>', '<xsl:value-of select="@statusmsg"/>');
										</xsl:for-each>
										<xsl:if test="ProgressBar/ProgressData/@iscomplete='true'">
											parent.update(false);
											<xsl:if test="ProgressBar/ProgressData/@reset">
												document.location.href = '<xsl:value-of select="ProgressBar/ProgressData/@reset"/>';
											</xsl:if>
										</xsl:if>
									}
								</xsl:when>
								<!-- Comment 5:END -->
								<!-- Comment 6: -->
								<xsl:when test="ProgressBar/@uidata='true'">
									var flag 				= false;
									var updateStatus = true;
									var isRunning 		= false;

									var complete 		= new Image();
									var fail 				= new Image();
									var abort 			= new Image();
									var suspend 		= new Image();
									var warning 		= new Image();
									var running 		= new Image();

									complete.src 		= "/oma/images/ok.gif";
									fail.src 				= "/oma/images/critical.gif";
									abort.src 			= "/oma/images/abort.gif";
									suspend.src 		= "/oma/images/suspend.gif";
									warning.src 		= "/oma/images/non-critical.gif";
									running.src 		= "/oma/images/progress.gif";

									function init()
									{
										try{
											parent.ct.daLoad = true;
										}
										catch(e) {
										}
										<xsl:choose>
											<xsl:when test="@ignoreJumpBar"></xsl:when>
											<xsl:otherwise>
												var tmp_div	= document.getElementById("tableBar");
												if((numOfTables &gt; 1) &amp;&amp;  ( tmp_div!=null ) )
												{
													tmp_div.style.display = "";
													tmp_div.className="data-area-jump-bar";
												}
											</xsl:otherwise>
										</xsl:choose>

										if(moreFuncInInit.toString() == "true")
										{
											initializationRoutine();
										}

										getProgress();
									}

									function getProgress()
									{
										if (updateStatus == true)
										{
											var timer1 = setTimeout("getProgress()", <xsl:value-of select="ProgressBar/@frequency"/>);

											if (isRunning != true)
											{
												isRunning = true;
												window.frames[0].location.href="<xsl:value-of select="ProgressBar/UIData/Update/@href"/>";
												var timer2 = setTimeout("resetProgress()", 30000);
											}
										}
									}

									function resetProgress()
									{
										isRunning = false;
									}

									function update(value)
									{
										if (value == false)
										{
											updateStatus = false;
											updateButton('none');
										}
									}

									function updateProgressBar(obj, progress, code, isComplete, start, end, msg, statusmsg)
									{
										isRunning = false;

										var a = document.getElementById("statusPercentage" + obj);
										if (a == null || a == "") return;
										if (a.innerHTML != progress + "%")
										{
											a.innerHTML = progress + "%";

											var bars = Math.floor(progress / 4);

											for (var i = 1; 25 &gt;= i; i++)
											{
												var a = document.getElementById("bar" + i + "_" + obj);
												if (a == null || a == "") return;

												if (bars &gt;= i) a.style.backgroundColor = "#000084";
												else a.style.backgroundColor = "";
											}
										}

										if (isComplete == "true")
										{
											c_Success = 2;
											c_Failed = 0;
											c_Aborted = 1;
											c_Warning = 5;
											
											if (code == c_Success)
											{
												var a = document.images["statusImage" + obj];
												if (a == null || a == "") return;
												a.src = complete.src;
												a.title = '<xsl:value-of select="$strStatusCompleted"/>';
											}
											else if (code == c_Aborted)
											{
												var a = document.images["statusImage" + obj];
												if (a == null || a == "") return;
												a.src = abort.src;
												a.title = '<xsl:value-of select="$strStatusAborted"/>';
											}
											else if (code == c_Failed)
											{
												var a = document.images["statusImage" + obj];
												if (a == null || a == "") return;
												a.src = fail.src;
												a.title = '<xsl:value-of select="$strStatusFailed"/>';

												a = document.getElementById("statusText" + obj);
												if (a == null || a == "") return;
												a.innerHTML = "&lt;a href='#' onclick='javascript:alert(<xsl:value-of select="$strMsg"/>)' style='color: blue'&gt;<xsl:value-of select="$strDetails"/>&lt;/a&gt;";
											}
										     <!-- 96791 add warning icon capability to progress bar -->
											else if (code == c_Warning)
											{
												var a = document.images["statusImage" + obj];
												if (a == null || a == "") return;
												a.src = warning.src;
												a.title = '<xsl:value-of select="$strStatusNonCritical"/>';

												a = document.getElementById("statusText" + obj);
												if (a == null || a == "") return;
												a.innerHTML = "&lt;a href='#' onclick='javascript:alert(<xsl:value-of select="$strMsg"/>)' style='color: blue'&gt;<xsl:value-of select="$strDetails"/>&lt;/a&gt;";
											}

										}
										<!-- C68431 - Adding support for multiple Interrupt Actions -->
										else
										{
											c_Suspended = 4;
											c_Running = 3;
											if(code == c_Suspended)
											{
												var a = document.images["statusImage" + obj];
												if ( a == null || a =="") return;
												a.src = suspend.src;
												a.title = '<xsl:value-of select="$strSuspended"/>';
											}
											else if(code == c_Running)
											{
												var a = document.images["statusImage" + obj];
												if ( a == null || a =="") return;
												a.src = running.src;
												a.title = '<xsl:value-of select="$strRunning"/>';											}
											
										}
										<!-- MOH change 75429 . Only display pass if number of passes greater than 0 -->
										if ( end > 0 )
										{
											var a = document.getElementById("statusPass" + obj);
											if (a == null || a == "") 
												return;
											// 75556 - if custom status msg is not provided, display standard 'pass x of y' else display custom msg
											if(statusmsg == ""){
												if (a.innerHTML != <xsl:value-of select="$strPass" />) 
													a.innerHTML = <xsl:value-of select="$strPass1"/>;
											}
											else{
												if (a.innerHTML != statusmsg) 
													a.innerHTML = statusmsg;
											}
										}
									}
									
									<!-- C68431 - Adding support for multiple Interrupt Actions -->
									function updateButton(name)
									{
										var abortBtn		= document.getElementById("abortbutton");
										var suspendBtn	= document.getElementById("suspendbutton");
										var resumeBtn		= document.getElementById("resumebutton");
										var resultBtn		= document.getElementById("resultbutton");
										
										<!--case 1: Abort has been clicked. Hide Abort, Suspend, Resume and display Results--> 
										if (name == 'abort')
										{
											if (abortBtn != null &amp;&amp; abortBtn !="")
											{
												abortBtn.style.display = "none";
											}
											if (suspendBtn != null &amp;&amp; suspendBtn !="")
											{
											    suspendBtn.style.display = "none";
											}
   											if (resumeBtn != null &amp;&amp; resumeBtn !="")
											{
												resumeBtn.style.display = "none";
											}
   											if (resultBtn != null &amp;&amp; resultBtn !="")
											{
												resultBtn.style.display = "";
											}
										}
										
										<!-- case 2 : Suspend has been clicked. Hide Suspend, Results and Display resume, abort -->
										else if(name == 'suspend')
										{
											if (abortBtn != null &amp;&amp; abortBtn !="")
											{
												abortBtn.style.display = "";
											}
											if (suspendBtn != null &amp;&amp; suspendBtn !="")
											{
											    suspendBtn.style.display = "none";
											}
   											if (resumeBtn != null &amp;&amp; resumeBtn !="")
											{
												resumeBtn.style.display = "";
											}
   											if (resultBtn != null &amp;&amp; resultBtn !="")
											{
												resultBtn.style.display = "none";
											}
										}
										
										<!-- case 3 : Resume has been clicked. Hide Resume, results and display abort, suspend -->
										
										else if(name == 'resume')
										{
											if (abortBtn != null &amp;&amp; abortBtn !="")
											{
												abortBtn.style.display = "";
											}
											if (suspendBtn != null &amp;&amp; suspendBtn !="")
											{
											    suspendBtn.style.display = "";
											}
   											if (resumeBtn != null &amp;&amp; resumeBtn !="")
											{
												resumeBtn.style.display = "none";
											}
   											if (resultBtn != null &amp;&amp; resultBtn !="")
											{
												resultBtn.style.display = "none";
											}
										}										
										<!-- Case 4 : Default existing code, added code to hide suspend and resume
												This case will be exceuted when test is complete. -->
										else if(name == 'none')
										{
											if (abortBtn != null &amp;&amp; abortBtn != "")
											{
												if(abortBtn.style.display == "")
												{
													abortBtn.style.display = "none";
												}
												if (suspendBtn != null &amp;&amp; suspendBtn !="")
												{
												    suspendBtn.style.display = "none";
												}
	   											if (resumeBtn != null &amp;&amp; resumeBtn !="")
												{
													resumeBtn.style.display = "none";
												}
											}										
	
											if (resultBtn != null &amp;&amp; resultBtn != "")
											{
												if(resultBtn.style.display == "none")
												{
													resultBtn.style.display = "";
												}
											}
	
											flag = true;
										}
										
										<!-- Old code to be deleted 
										if (abutton != null &amp;&amp; abutton != "")
										{
											if(abutton.style.display == "")
											{
												a.style.display = "none";
											}
										}

										var b = document.getElementById("resultbutton");
										if (b != null &amp;&amp; b != "")
										{
											if(b.style.display == "none")
											{
												b.style.display = "";
											}
										}

										flag = true; 
										Code to be deleted ends -->

										<!--following code is only used by local update. -->
										<xsl:if test="ProgressBar/@autoredirect">
											var redirecttimer = setTimeout('autoRedirect()',3000);
										</xsl:if>
									}

									<!--following code is only used by local update. -->
									<xsl:if test="ProgressBar/@autoredirect">
										function autoRedirect()
										{
											document.location.href = '<xsl:value-of select="ProgressBar/UIData/Result/@href"/>;
										}
									</xsl:if>

									function buttonCall(action, href)
									{
										if (flag)
										{
											document.location.href = <xsl:value-of select="ProgressBar/UIData/Result/@href"/>;
										}
										else
										{
											var pgbar = document.getElementById("progressbar");
											if (pgbar == null || pgbar == "") return;
											pgbar.src = href;
											<!-- Call updateButton only if action is suspend or resume since it was not being done for legacy abort code -->
											if(action == 'suspend')
												updateButton('suspend');
											else if(action == 'resume')
												updateButton('resume');
										}
									}
								</xsl:when>
								<!-- [pp] 10/09/03 - adding empty init function when ProgressBar is not defined to prevent javascript 
									   error from ocuuring when Progressbr is not defined -->
								<xsl:when test="not(ProgressBar)">
									function init(){}
								</xsl:when>
								<xsl:otherwise></xsl:otherwise>
								<!-- Comment 6: END-->
							</xsl:choose>
						</xsl:when>
						<!-- Comment 4: END-->
						<!-- Comment 7: -->
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="PerformanceData/@type='realdata'">
									function init()
									{
										<xsl:for-each select="PerformanceData/UpdateData/Graph">
											parent.reDrawGraphs('<xsl:value-of select="@name"/>', '<xsl:value-of select="@percent"/>', <xsl:value-of select="Data/@ptime"/>,
																		<xsl:value-of select="Data/@utime"/>, <xsl:value-of select="Data/@pvtime"/>, <xsl:value-of select="Data/@interrupts"/>);
										</xsl:for-each>

										<xsl:for-each select="PerformanceData/UpdateData/BoxData/DiskData">
											parent.reDrawDisk('<xsl:value-of select="@name"/>', '<xsl:value-of select="Data/@wrs"/>', '<xsl:value-of select="Data/@bwps"/>',
																		'<xsl:value-of select="Data/@rps"/>', '<xsl:value-of select="Data/@brps"/>');
										</xsl:for-each>

										<xsl:for-each select="PerformanceData/UpdateData/BoxData/MemData">
											parent.reDrawMem('<xsl:value-of select="@name"/>', '<xsl:value-of select="Data/@pfps"/>', <xsl:value-of select="Data/@pps"/>,
																		<xsl:value-of select="Data/@ab"/>, <xsl:value-of select="Data/@cb"/>, <xsl:value-of select="Data/@cl"/>);
										</xsl:for-each>

										<xsl:for-each select="PerformanceData/UpdateData/BoxData/VirMemData">
											parent.reDrawVirMem('<xsl:value-of select="@name"/>', '<xsl:value-of select="Data/@pu"/>', <xsl:value-of select="Data/@pup"/>);
										</xsl:for-each>

										<xsl:for-each select="PerformanceData/UpdateData/BoxData/NTWData">
											parent.reDrawNtw('<xsl:value-of select="@name"/>',  '<xsl:value-of select="Data/@btps"/>', '<xsl:value-of select="Data/@pps"/>',
																	'<xsl:value-of select="Data/@prps"/>', '<xsl:value-of select="Data/@psps"/>', '<xsl:value-of select="Data/@cb"/>',
																	'<xsl:value-of select="Data/@brps"/>', '<xsl:value-of select="Data/@bsps"/>');
										</xsl:for-each>
									}
								</xsl:when>
								<xsl:otherwise>
									function init()
									{
										try{
											parent.ct.daLoad = true;
										}
										catch(e) {
										}
										<xsl:choose>
											<xsl:when test="@ignoreJumpBar"></xsl:when>
											<xsl:otherwise>
												var tmp_div	= document.getElementById("tableBar");

												if((numOfTables &gt; 1) &amp;&amp;  ( tmp_div!=null ) )
												{
													tmp_div.style.display = "";
													tmp_div.className="data-area-jump-bar";
												}
											</xsl:otherwise>
										</xsl:choose>

										if(moreFuncInInit.toString() == "true")
										{
											initializationRoutine();
										}
										try {
											g_bStopOldRefresh = false;
											// [jj] A data area servlet call, so unlock the frameset.
											parent.ct.clearLock ();
										}
										catch (e) {
										}
										<!-- 
										      C81980
										      Allow the user to refresh the view when component updates are available in the server.
										-->
										<xsl:if test="/OMA/@update-available='true'">
											component_update();
										</xsl:if>
										<xsl:if test="Guage">
											adjustThermoMeter();
										</xsl:if>
									}
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
						<!-- Comment 7: END-->
					</xsl:choose>
					<!-- Comment 3: END-->
					<!-- Comment 8: -->

			<xsl:choose>
				<xsl:when test="ProgressBar/@progressdata='true'"><!-- Do nothing here --></xsl:when>
				<xsl:otherwise>
					<!-- C107102 - Need ability to disable buttons -->
					function disableButtons(sSubmit, sBack, sCancel){
						if (sSubmit == 'submit'){
							document.getElementById("submitbuttoncontent").style.display='none';
					  	}
					  	if (sBack == 'back'){
							document.getElementById("backbutton").style.display='none';									
                              }
					  	if (sCancel == 'cancel'){
							document.getElementById("cancelbutton").style.display='none';									
                              }
                                        }
					function DataAreaPrint(expandFlag)
					{
						if (g_sPrintURL != '') {
							g_sPrintURL = top.gnv.appendVID(g_sPrintURL);
							parent.pf.document.location.replace (g_sPrintURL);
							window.setTimeout (printCallback(expandFlag), 100);
						}
						else {
							<!--  expand all the divs  -->
							if (expandFlag == true){
								alterImage("plus" , "minus");
								expandDiv(document.getElementsByTagName("HTML")[0]);
							}

							parent.da.focus();
							parent.da.print();

							<!--  collapse all the divs  -->
							
							if (expandFlag == true){
								parent.da.location.reload();
								/*alterImage("minus" , "plus");
								collapseDiv(document.getElementsByTagName("HTML")[0]);*/
							}
						}
					}

					function printCallback (expandFlag) {
						if (parent.pf.document.readyState != 'complete') {
							window.setTimeout (printCallback(expandFlag), 100);
						}
						else {

							<!--  expand all the divs  -->
							if (expandFlag == true){
								alterImage("plus" , "minus");
								expandDiv(document.getElementsByTagName("HTML")[0]);
							}

							parent.pf.focus ();
							parent.pf.print ();

							<!--  collapse all the divs  -->
							if (expandFlag == true){
								parent.da.location.reload();
								/*alterImage("minus" , "plus");
								collapseDiv(document.getElementsByTagName("HTML")[0]);*/
							}
						}
					}
					<!-- Comment 8: END-->
					<!-- Comment 9: -->
					function changeStateTbl(name, numofitems)
					{
						var changeImgTo = "";
						numofitems++;
						for(var item=1; numofitems &gt; item; item++)
						{
							var tableID	= document.getElementById("div"+item+name);

							if(tableID.style.display == "none")
							{
								tableID.style.display = "";
								changeImgTo = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctminus.gif";
							}
							else
							{
								tableID.style.display = "none";
								changeImgTo = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif" ;
							}
						}

						document.images["image_" + name].src =  changeImgTo;
					}
					<!-- Comment 9: END-->

					<!-- Comment 10: Add this script only in the presence of date objects.-->
					<xsl:if test="@date='true'">
					
						<!--89828 Allow initialize of date value-->
					     function convertDate(  dateName, dateInit, srvoffset  )
						{
							if ( ( dateInit.length != 0 ) &amp;&amp; ( !isNaN( dateInit ) ) )
							{
								var initNum =  Number( dateInit );
								var date_var1 = new Date( initNum );
								if ( ( srvoffset.length != 0 ) &amp;&amp; ( !isNaN( srvoffset ) ) )
								{
									var client_offset_cal = new Date();
									var clientOffsetMins = client_offset_cal.getTimezoneOffset();
									
									var adjustedFinalTime = new Number( dateInit ) + new Number( srvoffset ) + new Number( clientOffsetMins * 60 * 1000 );
									date_var1 = new Date( adjustedFinalTime );									
								}
														
								var sdispLongDate = date_var1.toString();
								var sdateString1 = sdispLongDate.substr(0,sdispLongDate.indexOf(':')-2);
								var sYear = date_var1.getYear();
								if (navigator.appName == 'Netscape')
						        	{
						        	    var sdispDate = sdateString1;
						        	}
						        	else
						        	{
								var sdispDate = sdateString1 + sYear;
						        	}								
								if ( typeof sdispDate != "undefined")
								{
			                                        document.getElementById( dateName + "Hid" ).value = sdispDate ;
       		                              document.getElementById( dateName ).value = date_var1.getTime();
								}				    						
							}
						}
					
						function validateDate( userdate )
						{
							<!-- any date after [January 18, 19:14:07, 2038] is invalid on a 32 bit machine.-->
							
							var restrictedDateOn32BitMachine = new Date( 2038, 0, 18, "19", "14", "07" );

							if( userdate &gt; restrictedDateOn32BitMachine.getTime() )
							{
								if( parent.ct.machineArchType == 32 )
								{
									alert("<xsl:value-of select="$strInvalidDateMsg"/>");
							   		return false;
								}
								else
								{
									return true;
								}
							}
							else
							{
								return true;
							}
						}

						function showCalendar(img, datebox)
						{
							document.getElementById("currentDateObj").value = datebox;

							var state = document.getElementById("calendar");
							if (state.style.display == "")
							{
								state.style.display = "none";
							}
							else
							{
								var el = document.images[img];
								var height;

								if (document.all) height = document.body.clientHeight;
								else height = eval(window.innerHeight);

								var x = y = 0;
								do
								{
									x += el.offsetLeft;
									y += el.offsetTop;
								}
								while ((el = el.offsetParent));
								var left, top;
								if (height - y - 21 &gt; 161)
								{
									<!-- display the calendar below the image -->
									left = x + 1 + 34;
									top = y;
								}
								else
								{
									<!-- display the calendar above the image -->
									left = x + 1 + 34;
									top = y - 162 + 22;
								}
								state.style.left=left+'px';
								state.style.top=top+'px';
								state.style.display = "";
								state.focus();
							}
						}
					</xsl:if>
					<!-- Comment 10: END-->
					<!-- Comment 11: -->
					function incTableCount()
					{
						numOfTables = numOfTables + 1;
					}
					<!-- Comment 11: END-->
					<!-- Comment 12: -->
          var g_bFirstItemAdded = false;
          var g_bSpanAdded = false;
          var g_sCurrentJumpDataSelection = "";
          var g_cellNumber = 0;

          function addJumpDataItem (sName, sDisplay){
          var tableBarContent = document.getElementById ("tableBarContent");

          if (tableBarContent == null || sName =='' || sDisplay == '') return;

          if(g_bSpanAdded == false)
          {
          var span = document.createElement('span');
          span.setAttribute('id','span_jumpbar');
          span.setAttribute('class', 'data-area-jump-items');
          var txt = document.createTextNode('<xsl:value-of select="$strJumpTo"/>');
          span.appendChild(txt);
          tableBarContent.appendChild(span);
          }
          if (g_bFirstItemAdded == true)
          {
          var txt = document.createTextNode('|');
          var spantableBarContent = document.getElementById ("span_jumpbar");
          /* Add a spacer cell */
          if(spantableBarContent)
          spantableBarContent.appendChild(txt);
          else
          tableBarContent.appendChild(txt);
          }

          g_bFirstItemAdded = true;
          g_bSpanAdded = true;

          var anchor = document.createElement('a');
          var txt = document.createTextNode(sDisplay); // create text node
          anchor.setAttribute('id','a_' + sName);
          anchor.setAttribute('name','a_' + sName);
          anchor.setAttribute('class', 'data-area-jump-bar');        // set DIV class attribute
          anchor.setAttribute('className', 'data-area-jump-bar');        // set DIV class attribute
          anchor.setAttribute('href',' #' + sName);
          anchor.setAttribute('onclick','javascript:selectJumpDataItem (\'' + sName + '\')');
          anchor.appendChild(txt);                    // append text node to the DIV

          var spantableBarContent = document.getElementById ("span_jumpbar");
          if(spantableBarContent)
          spantableBarContent.appendChild(anchor);
          else
          tableBarContent.appendChild(anchor);

          }

          function selectJumpDataItem (sName)
          {
          if (g_sCurrentJumpDataSelection != "") {
          var oSelectedAnchor = document.getElementById ("a_" + g_sCurrentJumpDataSelection);
          oSelectedAnchor.className = "data-area-jump-bar";
          }
          g_sCurrentJumpDataSelection = sName;
          var oSelectedAnchor = document.getElementById ("a_" + sName);
          oSelectedAnchor.className = "data-area-jump-bar data-area-jump-bar-selection";
          }

          <!-- Start of  email script -->
					function sendEmail(expandFlag)
					{
						document.getElementById("dataarea").encoding="application/x-www-form-urlencoded";
						document.getElementById("dataarea").enctype= "application/x-www-form-urlencoded";
						<!--  clears cache content and loads the page -->
						<xsl:choose>
							<xsl:when test="@callerReplace = 'true'">
								var locRef = document.location.href;
								locRef = locRef.replace('<xsl:value-of select="@paramReplaced"/>', '<xsl:value-of select="@paramReplacing"/>');
								locRef = top.gnv.appendVID(locRef);
								document.getElementById("caller").value = locRef;
							</xsl:when>
							<xsl:otherwise>document.getElementById("caller").value=document.location.href;</xsl:otherwise>
						</xsl:choose>
						document.getElementById("dataarea").action = top.gnv.appendVID("./DataArea?plugin=com.dell.oma.webplugins.ShowSendEmailWebPlugin");
						document.getElementById("pageCode").value = "";

						<!--  dynamically load the content of the page with all the divs opened  -->
						if (expandFlag == true){
							alterImage("plus" , "minus");
							expandDiv(document.getElementsByTagName("HTML")[0]);
						}
						
						document.getElementById("pageCode").value = (document.getElementsByTagName("HTML")[0].innerHTML).stripScripts();

						if(document.getElementById("pageTitle")!=null)
						{
							document.getElementById("pageName").value = document.getElementById("pageTitle").innerHTML;
						}		
						

						<!-- collapse all the divs -->
						if (expandFlag == true){
							alterImage("minus" , "plus");
							collapseDiv(document.getElementsByTagName("HTML")[0]);
						}

						document.getElementById("dataarea").submit();
					}
					<!-- End of email script -->
					
					<!-- 
					      C81980
					      This function allows the user to refresh their current view based on
					      changes in the component tree representation in the server.  It is
					      invoked by the init function when updates are available.
					-->
					function component_update ()
					{
						if (confirm (<xsl:value-of select="$strComponentUpdate" />)) {
							parent.ct.location.href=top.gnv.appendVID('./ComponentTree?refresh=true');
						}
					}

					function alterImage(orgImg , altImg){
						temp = new Array();
						<xsl:for-each select="CustomTable/CustomRow">
							var val = "<xsl:value-of select="@name"/>";
							temp = temp.concat(val);
						</xsl:for-each>
						var changeImgTo;
						if (altImg == "plus"){
							changeImgTo = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of 	select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif";
						}
						else if (altImg == "minus"){
							changeImgTo = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of 	select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctminus.gif";
						}

						var obj = document.images;
						for(i = 0 ; i &lt; obj.length ; i++)
						{
							if(obj[i].src.indexOf("ct" + orgImg + ".gif") != -1)
							{
								obj[i].src = changeImgTo;
							}
						}

					}

					function expandDiv(doc){
						var aDivs;
						aDivs = doc.getElementsByTagName("DIV");
						for(var j = 0 ; j  &lt; aDivs.length ; j++){
							if (aDivs[j].id !="tableBar")
								aDivs[j].style.display="block";
						}
					}

					function collapseDiv(doc){
						var aDivs;
						aDivs = doc.getElementsByTagName("DIV");
						for(var j = 1 ; j  &lt; aDivs.length ; j++){
								aDivs[j].style.display="none";
						}
					}
					<!-- This script is enabled only when requested -->
					<xsl:if test="@stringValidation = 'true'">

					</xsl:if>
					<!-- This script is only for data elements of IP address type -->
					<xsl:if test="@ipbox='true'">
						var mj = false;

						function rchar(name, a, b)
						{
							var x = document.getElementById(name + a);
							var y = document.getElementById(name + b);

							var i = eval(x).value.indexOf(".");
							if (i &gt;= 0)
							{
								eval(x).value = eval(x).value.substring(0,i);
								eval(y).focus();
								eval(y).select();
							}
							else if (eval(x).value.length == 3 &amp;&amp; mj)
							{
								eval(y).focus();
								eval(y).select();
							}
						}
					</xsl:if>

					</xsl:otherwise>
				</xsl:choose>
					<!-- Comment 12: END-->
					<!-- This script is required for guage template. -->
						<xsl:if test="Guage">
							var value	= '<xsl:value-of select="Guage/Reading"/>';
							var cmax	= '<xsl:value-of select="Guage/MXFThresh"/>';
							var cmin	   	= '<xsl:value-of select="Guage/MFThresh"/>';
							var ncmax	= '<xsl:value-of select="Guage/MXWThresh"/>';
							var ncmin	= '<xsl:value-of select="Guage/MWThresh"/>';
							var units		= '<xsl:value-of select="Guage/@units"/>';
              var numdec	= '<xsl:value-of select="Guage/@digits"/>';
              var hideminthresh	= '<xsl:value-of select="Guage/@hideminthresh"/>';
              
              var showcmax = cmax;
              var showcmin = cmin;

              value					= parseFloat(value);
              cmax					= parseFloat(cmax);
              cmin					= parseFloat(cmin);
              var total				= parseFloat((cmax - cmin) * (1.25));
              var max				= parseFloat(cmax + parseFloat(total / 10));
              var min				= parseFloat(cmin - parseFloat(total / 10));
              var tempncmax	= parseFloat(ncmax);
              var tempncmin		= parseFloat(ncmin);
              var five_percent	= parseFloat(total / 20);
              var a 					= parseFloat(cmax - ncmax);
              var b					= parseFloat(ncmax - ncmin);
              var c					= parseFloat(ncmin - cmin);

              var autoAdjust		= 0;

			   var scale				=50;
				var scale_2				=100;
		
             




var  tcmax=cmax;
var num_of_dig=0;
var cexp=1;
if(tcmax &gt; scale)
{
if(tcmax%10==0)
{
tcmax=tcmax-1;
}

num_of_dig=parseInt(Math.floor((Math.log(tcmax)/Math.log(10)))+1);
cexp=Math.pow(10,num_of_dig);
cexp=(cexp/scale);

if(cmin==0 &amp;&amp; ncmin==0){
<!-- This code is to ensure that red color portion in the graph will be always around 20 to 30% -->
	var tmxmore=cmax*120/100; 
	<!-- Rounding the top most value in the graph to the multiple of 50 (scale) -->
	cexp= (tmxmore+ (scale-(tmxmore%scale)))/scale;
}

}

              <!-- This code is to snap the reading pointer to either the center of max or the center of min -->
								tempvalue = value;

								if( (tempvalue &gt; max) || ( tempvalue &gt; cmax))
								{
									value = parseFloat(max - five_percent);
								}
								else if( (tempvalue &lt; min) || (tempvalue &lt; cmin) )
								{
									value = parseFloat(parseFloat(min) + five_percent);
								}

							<!-- End here.  -->

							if( (a &lt; five_percent)  &amp;&amp; (b &gt;= five_percent) &amp;&amp; (c &lt; five_percent) )
							{
								autoAdjust = 1;
								tempncmax = parseFloat(parseFloat(cmax) - five_percent);
								tempncmin = parseFloat(parseFloat(cmin) + five_percent);
							}
							else if( (a &gt;= five_percent)  &amp;&amp; (b &lt; five_percent) &amp;&amp; (c &gt;= five_percent) )
							{
								autoAdjust = 2;
								if( a &lt; c)
								{
									tempncmin = parseFloat(parseFloat(ncmax) - five_percent);
								}
								else if( a &gt; c)
								{
									tempncmax = parseFloat(parseFloat(ncmin) + five_percent);
								}
								else if( a == c)
								{
									tempncmax = parseFloat(parseFloat(ncmin) + five_percent);
								}
							}
							else if( (a &lt; five_percent)  &amp;&amp; (b &lt; five_percent) &amp;&amp; (c &gt;= five_percent) )
							{
								autoAdjust = 3;
								tempncmax = parseFloat(parseFloat(cmax) - five_percent);
								tempncmin = parseFloat( tempncmax - five_percent );
							}
							else if( (a &gt;= five_percent)  &amp;&amp; (b &lt; five_percent) &amp;&amp; (c &lt; five_percent) )
							{
								autoAdjust = 4;
								tempncmin = parseFloat( parseFloat(cmin) + five_percent );
								tempncmax = parseFloat( tempncmin + five_percent );
							}
							else if( (a &lt; five_percent)  &amp;&amp; (b &gt;= five_percent) &amp;&amp; (c &gt;= five_percent) )
							{
								autoAdjust = 5;
								tempncmax = parseFloat(parseFloat(cmax) - five_percent);
							}
							else if( (a &gt;= five_percent)  &amp;&amp; (b &gt;= five_percent) &amp;&amp; (c &lt; five_percent) )
							{
								autoAdjust = 6;
								tempncmin = parseFloat( parseFloat(cmin) + five_percent );
							}
							
							<!-- 104463 - If the warn thresh and Fail thresh are same, Gauge still shows them at different points
								  Hence, checking to see if they are same. -->
							if (cmin == ncmin)
								{
									tempncmin = parseFloat(cmin);
								}
								if (cmax == ncmax)
								{
									tempncmax = parseFloat(cmax);
								}

							// Auto adjustment of reading pointer.
							if(autoAdjust == 1)
							{
								// Reading may be pointing between (cmax-ncmax) and (ncmin-cmin)
								if((value &lt;= cmax) &amp;&amp; (value &gt;= ncmax))
								{
									value = parseFloat(parseFloat(cmax) - parseFloat(five_percent/2));
								}
								else if((value &lt;= ncmax) &amp;&amp; (value &gt;= tempncmax))
								{
									value = parseFloat(tempncmax - parseFloat(five_percent/2));
								}
								else if((value &lt;= ncmin) &amp;&amp; (value &gt;= cmin))
								{
									value = parseFloat(parseFloat(cmin) + parseFloat(five_percent/2));
								}
								else if((value &lt;= tempncmin) &amp;&amp; (value &gt;= ncmin))
								{
									value = parseFloat( tempncmin + parseFloat(five_percent/2));
								}
							}
							else if(autoAdjust == 2)
							{
								// Reading may be pointing between (ncmax-ncmin)

								if( a &lt; c)
								{
									if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
									{
										value = parseFloat(parseFloat(tempncmin) + parseFloat(five_percent/2));
									}
									else if((value &lt; ncmin) &amp;&amp; (value &gt;= tempncmin))
									{
										value = parseFloat(parseFloat(tempncmin) - parseFloat(five_percent/2));
									}
								}
								else if( a &gt; c)
								{
									if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
									{
										value = parseFloat(parseFloat(ncmin) + parseFloat(five_percent/2));
									}
									else if((value &lt;= tempncmax) &amp;&amp; (value &gt; ncmax))
									{
										value = parseFloat(tempncmax + parseFloat(five_percent/2));
									}
								}
								else if( a == c)
								{
									if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
									{
										value = parseFloat(parseFloat(ncmin) + parseFloat(five_percent/2));
									}
									else if((value &lt;= tempncmax) &amp;&amp; (value &gt; ncmax))
									{
										value = parseFloat(tempncmax + parseFloat(five_percent/2));
									}
								}
							}
							else if(autoAdjust == 3)
							{
								// Reading may be pointing between (cmax-ncmax) and (ncmax-ncmin)
								if((value &lt; ncmin) &amp;&amp; (value &gt;= tempncmin))
								{
									value = parseFloat(parseFloat(tempncmin) - parseFloat(five_percent/2));
								}
								else if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
								{
									value = parseFloat(parseFloat(tempncmin) + parseFloat(five_percent/2));
								}
								else if((value &lt;= cmax) &amp;&amp; (value &gt;ncmax))
								{
									value = parseFloat(parseFloat(cmax) - parseFloat(five_percent/2));
								}
							}
							else if(autoAdjust == 4)
							{
								// Reading may be pointing between (ncmax-ncmin) and (ncmin-cmin)

								if((value &gt; ncmax) &amp;&amp; (value &lt;= tempncmax))
								{
									value = parseFloat(tempncmax + parseFloat(five_percent/2));
								}
								else if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
								{
									value = parseFloat(parseFloat(tempncmax) - parseFloat(five_percent/2));
								}
								else if((value &gt;= cmin) &amp;&amp; (value &lt; ncmin))
								{
									value = parseFloat(parseFloat(cmin) + parseFloat(five_percent/2));
								}
							}
							else if(autoAdjust == 5)
							{
								// Reading may be pointing between (cmax-ncmax)
								if((value &lt;= cmax) &amp;&amp; (value &gt;= ncmax))
								{
									value = parseFloat(parseFloat(cmax) - parseFloat(five_percent/2));
								}
								else if((value &lt; ncmax) &amp;&amp; (value &gt;= tempncmax))
								{
									value = parseFloat(tempncmax - parseFloat(five_percent/2));
								}
							}
							else if(autoAdjust == 6)
							{
								// Reading may be pointing between (ncmin-cmin)
								if((value &gt;= cmin) &amp;&amp; (value &lt;= ncmin))
								{
									value = parseFloat(parseFloat(cmin) + parseFloat(five_percent/2));
								}
								else if((value &gt; ncmin) &amp;&amp; (value &lt;= tempncmin))
              {
              value = parseFloat(tempncmin + parseFloat(five_percent/2));
              }
              }

              var pointer 		= Math.round(parseFloat(((value - min) / (max - min)) * 250));
              var cmaxmark 		= Math.round(parseFloat(((cmax - min) / (max - min)) * 250));
              var ncmaxmark 	= Math.round(parseFloat(((tempncmax - min) / (max - min)) * 250));
              var cminmark 		= Math.round(parseFloat(((cmin - min) / (max - min)) * 250));
              var ncminmark 	= Math.round(parseFloat(((tempncmin - min) / (max - min)) * 250));
              var minmark			= 0;
              var counter 		= 1;

              <!-- If we do not want to display the minimum threshold values, set the ncminmark (non-critical minimum)
                   and cminmark (critical minimum) to zero. This is to bring down the ncminmark to the end of guage -->
              if("true" == hideminthresh)
              {
                ncminmark = 0;
                cminmark = 0;
                <!-- If the non-critical maximum itself is zero, then set ncmaxmark to zero so that this will be the end of guage -->
                if(0 == ncmax)
                {
                  ncmaxmark = 0;
                }
              }

              function numberFormat(number, places)
              {
              <xsl:choose>
									<xsl:when test="Guage/@showdecsep !='.'">
										var temp = new String(number);
										var index = temp.indexOf(".");
										if(index &gt;= 0)
										{
											temp = temp.replace(".", '<xsl:value-of select="Guage/@showdecsep"/>');
										}
									</xsl:when>
									<xsl:otherwise>
										var temp = new String(number);
										var index = temp.indexOf(".");
									</xsl:otherwise>
								</xsl:choose>

								if (index &lt; 0)
								{
									temp += ".";
									for (var i = 0; i &lt; places; i++) temp += "0";
									return temp;
								}
								else if ((temp.length - index - 1) &lt; places)
								{
									for (var i = 0; i &lt; places - (temp.length - index - 1); i++) temp += "0";
									return temp;
								}
								else if ((temp.length - index - 1) == places)
								{
									return temp;
								}
								else
								{
									var str = "";
									for (var i = 0; i &lt;= (index + places); i++) str += temp.charAt(i);
									return str;
								}
							}


	function adjustThermoMeter()
				{
					try{

	
						var lowernum =parseInt(ncmin/cexp)*2 ;
						var uppernum =parseInt(ncmax/cexp)*2; 

var lowerfailure =parseInt(cmin/cexp)*2 ;
var upperfailure =parseInt(cmax/cexp)*2; 

var mark=parseInt(value/cexp)*2;

if(document.getElementById("thermometer_warning"))
	document.getElementById("thermometer_warning").style.bottom = lowernum + '%';
if(document.getElementById("lower_warning"))
	document.getElementById("lower_warning").style.bottom = lowernum + '%';
if(document.getElementById("thermometer_critical"))	
	document.getElementById("thermometer_critical").style.bottom = lowerfailure + '%';
if(document.getElementById("lower_failure"))
	document.getElementById("lower_failure").style.bottom = lowerfailure + '%';
if(document.getElementById("thermometer_critical"))
	document.getElementById("thermometer_critical").style.height = upperfailure - lowerfailure + '%';
if(document.getElementById("upper_failure")) { // Calculations for defect BITS040176
	if (lowerfailure == '-14') { // For 12G and above
		document.getElementById("upper_failure").style.bottom = upperfailure + lowerfailure + 20 + '%'; //BITS040176: Changed  minus(-) to plus (+) in the formula to address the defect. Calculation was done incorrectly here previously.
	} else 
		document.getElementById("upper_failure").style.bottom = upperfailure + lowerfailure + '%';  // For 11G and below
}
if(document.getElementById("thermometer_warning"))
	document.getElementById("thermometer_warning").style.height = uppernum - lowernum  + '%';
if(document.getElementById("upper_warning"))
	document.getElementById("upper_warning").style.bottom = uppernum  + '%';
if(document.getElementById("thermometer_marker"))
	document.getElementById("thermometer_marker").style.bottom =mark + '%';
if(document.getElementById("marker_text"))	
	document.getElementById("marker_text").style.bottom =mark + '%';

		if((lowerfailure+5) &gt; lowernum)
        {
			if(document.getElementById("lower_failure").innerHTML != '')
			{
				document.getElementById("lower_failure").innerHTML =  document.getElementById("lower_warning").innerHTML + ' / <br/>'  + document.getElementById("lower_failure").innerHTML;
				document.getElementById("lower_warning").innerHTML ='';
			}
		}
		if((lowerfailure+5) &gt; mark)
		{
			if(document.getElementById("lower_failure").innerHTML != '')
			{
				document.getElementById("lower_failure").innerHTML =  '<b>' + document.getElementById("marker_text").innerHTML + '</b> / <br/>'  + document.getElementById("lower_failure").innerHTML;
				document.getElementById("marker_text").innerHTML ='';
			}
		}
		else if((Math.abs(lowernum-mark) &lt; 5 ) )  //lowernum =min warning threshold  and mark=current reading . If difference in both is less than 5 then strings overlap hence concatenate strings
		{   // If current reading is greater than min warning threshold then form the string with lower value first and higher value next
			
			if(lowernum &lt; mark)
			{
				document.getElementById("marker_text").innerHTML =  document.getElementById("marker_text").innerHTML + ' / <br/>'  + document.getElementById("lower_warning").innerHTML;
			}
			else
			{
				document.getElementById("marker_text").innerHTML =   document.getElementById("lower_warning").innerHTML + '/ <br/>'  +document.getElementById("marker_text").innerHTML;
			}
				
				document.getElementById("lower_warning").innerHTML ='';
		}
		else if((Math.abs(uppernum-mark) &lt; 5) ) //uppernum =max warning threshold  and mark=current reading . If difference in both is less than 5 then strings overlap hence concatenate strings
		{  // If current reading is greater than max warning threshold then form the string with lower value first and higher value next 
			
			if(uppernum &lt; mark)
			   {
				
				document.getElementById("marker_text").innerHTML =   document.getElementById("marker_text").innerHTML + ' / <br/>'  + document.getElementById("upper_warning").innerHTML;
			   }
			   else
			   {
				document.getElementById("marker_text").innerHTML =   document.getElementById("upper_warning").innerHTML + '/ <br/>'+ document.getElementById("marker_text").innerHTML;
				
			   }
			   
			document.getElementById("upper_warning").innerHTML ='';
		}

		if((upperfailure-5) &lt; uppernum)
        {
			if(document.getElementById("upper_failure").innerHTML != '')
			{
				document.getElementById("upper_failure").innerHTML =  document.getElementById("upper_failure").innerHTML + ' / <br/>'  + document.getElementById("upper_warning").innerHTML;
				document.getElementById("upper_warning").innerHTML ='';
			}
		}		
		if((upperfailure-5) &lt; mark)
		{
			if(document.getElementById("upper_failure").innerHTML != '')
			{
				document.getElementById("upper_failure").innerHTML =  document.getElementById("upper_failure").innerHTML + ' / <br/>'+'<b>'  + document.getElementById("marker_text").innerHTML +'</b>';
				document.getElementById("marker_text").innerHTML ='';
			}
		}
		

					}catch(e){}
				}


						</xsl:if>
					<!-- End of Guage template script -->
					<!-- Start Performance script -->
						<xsl:if test="PerformanceData/@type='uidata'">
							function reDrawGraphs(name, percent, ptime, utime, pvtime, interrupts)
							{
								var temp = percent;
								percent = Math.ceil(percent/2);
								percent = Math.round(50 - percent);

								for(var y=1; y&lt;51; y++)
								{
									if(y &lt;= percent)
									{
										document.getElementById(name + y + "_1").style.backgroundColor = "#004000";
										document.getElementById(name + y + "_2").style.backgroundColor = "#004000";
									}
									else
									{
										document.getElementById(name + y + "_1").style.backgroundColor = "#00DC00";
										document.getElementById(name + y + "_2").style.backgroundColor = "#00DC00";
									}
								}

								document.getElementById(name + "_text").innerHTML = temp + "%";
								document.getElementById(name + "_ptime").innerHTML = ptime + "%";
								document.getElementById(name + "_utime").innerHTML = utime + "%";
								document.getElementById(name + "_pvtime").innerHTML = pvtime + "%";
								document.getElementById(name + "_intrpts").innerHTML = interrupts;
							}

							function reDrawDisk(name, wrs, bwps, rps, brps)
							{
								document.getElementById(name + "_wrs").innerHTML = wrs;
								document.getElementById(name + "_bwps").innerHTML = bwps;
								document.getElementById(name + "_rps").innerHTML = rps;
								document.getElementById(name + "_brps").innerHTML = brps;
							}

							function reDrawMem(name, pfps, pps, ab, cb, cl)
							{
								document.getElementById(name + "_pfps").innerHTML = pfps;
								document.getElementById(name + "_pps").innerHTML = pps;
								document.getElementById(name + "_ab").innerHTML = ab;
								document.getElementById(name + "_cb").innerHTML = cb;
								document.getElementById(name + "_cl").innerHTML = cl;
							}

							function reDrawVirMem(name, pu, pup)
							{
								document.getElementById(name + "_pu").innerHTML = pu;
								document.getElementById(name + "_pup").innerHTML = pup;
							}

							function reDrawNtw(name, btps, pps, prps, psps, cb, brps, bsps)
							{
								document.getElementById(name + "_btps").innerHTML = btps;
								document.getElementById(name + "_pps").innerHTML = pps;
								document.getElementById(name + "_prps").innerHTML = prps;
								document.getElementById(name + "_psps").innerHTML = psps;
								document.getElementById(name + "_cb").innerHTML = cb;
								document.getElementById(name + "_brps").innerHTML = brps;
								document.getElementById(name + "_bsps").innerHTML = bsps;
							}

						</xsl:if>
					<!-- End Performance script-->
					<!-- Start SelectionData script-->
						function selectionData(name)
						{
							var selectedRow = document.getElementById(name);
							var selectedRowImage = document.getElementById( "img_" + name );

							if (selectedRow.style.display == "")
							{
								selectedRowImage.src = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif" ;

								selectedRow.style.display = "none";
							}
							else
							{
								selectedRowImage.src = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctminus.gif";

								selectedRow.style.display = "";
							}
						}

						function expandSelectionData()
						{
							<xsl:if test="SelectionData">
								<xsl:for-each select="SelectionData/SelectionTable/Row">
									<xsl:call-template name="SelectionDataRowExpandFunction">
										<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:if>
						}

					<!-- End SelectionData script-->
					<!-- SelectionDataUI script -->
					<!-- C97788 - need to set default iframe height to 66% for screen resolution less than 800x600 -->
						function SetDefaultFrameHeight(iframe)
						{
							var x = screen.width;
							var defaultheight;
							var iframeobj = document.getElementById(iframe);
							
							if (x &lt; 640)	{
								iframeobj.height="66%";
							}
						}
					<!-- End SelectionDataUI script -->
					
					<xsl:if test="(/OMA/@userrights = '7' or /OMA/@userrights = '3')">
					<!-- Export Data script Start: Export button is not available to users group.-->
						var originalFormAction;
						var count = 0;
						var storedHref = new String(document.location.href);
						storedHref = top.gnv.appendVID(storedHref);
                                                var bEnableExportSpecialHandling = false;

						function saveExportDataSP(delimiteddata) {
                                                  bEnableExportSpecialHandling = true;
                                                  saveExportData(delimiteddata);
                                                }

						function saveExportData( delimiteddata )
						{
							document.getElementById("exportdatacontent").value = delimiteddata;
							originalFormAction = top.gnv.appendVID(document.dataarea.action);
                                                        if (bEnableExportSpecialHandling) {
							  document.dataarea.action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.oma.webplugins.ExportDataWebPlugin&amp;exportsp=true');
                                                        }
                                                        else {
                                                          document.dataarea.action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.oma.webplugins.ExportDataWebPlugin');
                                                        }
							document.dataarea.submit();
							document.dataarea.action = originalFormAction;
						}
					
						function exportCustomDelimitedData()
						{
							storedHref = top.gnv.appendVID(storedHref);
							if( count == 0 )
							{
								if( storedHref.indexOf("#") != -1 )
								{
									if( (storedHref.length - 1) == (storedHref.indexOf("#")))
									{
	 	 								storedHref = storedHref.substring(0, (storedHref.length) - 1);
									}
								}
								
								count++;
								var pageHref = storedHref;
								storedHref = pageHref + "&amp;fmt=cdsv";
								document.getElementById( "exportdataiframe" ).src = storedHref;
								
							}
							else
							{
								var exportFrameID = 0;
								for(var frameIndex = 0; frameIndex &lt; window.frames.length; frameIndex++)
								{
									if(window.frames[frameIndex].name == "exportdataiframe")
									{
										exportFrameID = frameIndex;
										break;
									}
								}
								window.frames[exportFrameID].location.href = storedHref;
							}
						}
					 <!--Export Data script End-->
					</xsl:if>				</script>
				<!-- Comment 13: -->
				<script language="javascript">
					function formSubmit()
					{
						document.dataarea.action = top.gnv.appendVID(document.dataarea.action);
						<xsl:choose>
						<xsl:when test="@validate='true'">
								if(validate())
									document.dataarea.submit();
							</xsl:when>
						<xsl:otherwise>
								document.dataarea.submit();
							</xsl:otherwise>
					</xsl:choose>
					}
				</script>
				<!-- Comment 13: END-->
				<!-- add these scripts only in case of list table presence -->
				<xsl:if test="ListTableData">
				<script language="javascript">
					var moveupbuttonInnerHTML = "";
					var movedownbuttonInnerHTML = "";
					var emptyRowInnerHTML = "";
					
				    function SelectRow(tblTable)
				    {
 
						var targ;
						if (tblTable.target)
						{
							  targ=tblTable.target;
						}
						else if (tblTable.srcElement)
						{
							  targ=tblTable.srcElement;
						}
						if (targ.nodeType==3) // defeat Safari bug
						{
							  targ = targ.parentNode;
						}
 
						var tname;
						tname=targ.tagName;
						tname=tname.toLowerCase();

						if( (tname != "input") &amp;&amp; (tname=="td" || tname=="div" || tname=="span") )
						{
							var rowIndex = null;
							var innerTable = null;
							
							if(tname=="td")
							{
									innerTable = targ.parentNode.parentNode;
									rowIndex = targ.parentNode.rowIndex;
							}
							else if(tname=="div")
							{
								innerTable = targ.parentNode.parentNode.parentNode;
								rowIndex = targ.parentNode.parentNode.rowIndex;
							}
							else if(tname=="span")
							{
								innerTable = targ.parentNode.parentNode.parentNode.parentNode;			
								rowIndex = targ.parentNode.parentNode.parentNode.rowIndex;
							}
							var cindex = innerTable.rows[0].cells.length - 2; //0 - index, leave out right cell
							var rindex = innerTable.rows.length - 1; //0-index calculate all
							moveupbuttonInnerHTML = innerTable.rows[0].cells[cindex].innerHTML;
							movedownbuttonInnerHTML = innerTable.rows[rindex].cells[cindex].innerHTML;

							if(innerTable.rows[1])
							{
								emptyRowInnerHTML = innerTable.rows[1].cells[cindex].innerHTML;
							}
							
							var rlength = innerTable.rows.length;
							for(var ii=0; ii &lt; rlength ; ii++) //looping thru entire table
							{
								var rowvar = innerTable.rows[ii];
								var rlength2 = rowvar.cells.length;
								for(var ij=2; ij &lt; rlength2-1 ; ij++) //leaving out left and number col, right
								{
									var str = rowvar.cells[ij].className;
									if(str.indexOf(" fill") != -1)
									{
										str = str.replace(" fill"," nofill");
									}
									rowvar.cells[ij].className = str;
								}
							}
 
							rowIndex = rowIndex - 1; //accounting for 0 based index
							var rowvar = innerTable.rows[rowIndex];
							rlength = rowvar.cells.length;
							for(var ii=2; ii &lt; rlength-2 ; ii++) //leaving out left,numbercol, right,action buttons
							{
								var str = rowvar.cells[ii].className;
								if(str.indexOf(" fill") != -1)
								{
									str = str.replace(" fill"," nofill");
								}else if(str.indexOf(" nofill") != -1){
									str = str.replace(" nofill"," fill");
								}else{
									str = str.concat(" fill");		
								}
								rowvar.cells[ii].className = str;
							}
							
							
						}
					}
 
 
			function MoveUp(tblTable)
			{
 
			  if(tblTable)
			  {
				  var targ;
 
				  if (tblTable.target)
				  {
				  targ=tblTable.target;
				  }
				  else if (tblTable.srcElement)
				  {
				  targ=tblTable.srcElement;
				  }
				  if (targ.nodeType==3) // defeat Safari bug
				  {
				  targ = targ.parentNode;
				  }
 
				
				  var innerTable = targ.parentNode.parentNode.parentNode; //stoping at tbody	
 
				  var i=0;
				  for(i=1; i &lt; innerTable.rows.length; i++)
					{
							   if((innerTable.rows[i].cells[2]) &amp;&amp; (innerTable.rows[i].cells[2].className.indexOf(" fill") != -1) ) //is selected ?
							   {
								eraseButtons(innerTable);							   
								SendUp(innerTable.rows[i],innerTable.rows[i-1]);
								keepButtons(innerTable);								
							   }
					}
 
				}	
			}
			function keepButtons(innerTable)
			{
				var cindex = innerTable.rows[0].cells.length - 2;
				var rindex = innerTable.rows.length - 1;
				innerTable.rows[0].cells[cindex].innerHTML= moveupbuttonInnerHTML;
				innerTable.rows[rindex].cells[cindex].innerHTML= movedownbuttonInnerHTML;
			
			}
			
			function eraseButtons(innerTable)
			{
				var startindex = 0;
				var endindex = innerTable.rows.length;
				var cindex = innerTable.rows[0].cells.length - 2;
				for(i=startindex; i &lt; endindex; i++)
					innerTable.rows[i].cells[cindex].innerHTML = emptyRowInnerHTML;
			}
			
			function interChangeFirstColumn(CurrentRow,PreviousRow)
			{
				if(CurrentRow &amp;&amp; PreviousRow)
				{
					var currval = CurrentRow.cells[1].innerHTML ; //for number value
					if(currval != "")
					{
					CurrentRow.cells[1].innerHTML = PreviousRow.cells[1].innerHTML;
					PreviousRow.cells[1].innerHTML = currval;
					}
				}	
			}
 
 
			function SendUp(CurrentRow,PreviousRow)
			{
				var cellInnerHtml = CurrentRow.cells[2].innerHTML; //for check box value
				PreviousRow.parentNode.insertBefore(CurrentRow,PreviousRow);
 
				if (navigator.appName == "Microsoft Internet Explorer")
				{ 						
					var sAppVersion = navigator.appVersion;
					sAppVersion = sAppVersion.replace (/.*MSIE /i, "");
					sAppVersion = sAppVersion.split (';')[0];
					if ( (sAppVersion == "6.0")  || (sAppVersion &lt; "6.0") )
					{
					CurrentRow.cells[2].innerHTML = cellInnerHtml;
					}
				}
 
				interChangeFirstColumn(CurrentRow,PreviousRow);
			}
 
 
          function moveRowNop()
          {
 
          }
 
        function MoveDown(tblTable)
        {
			if(tblTable)
			{
				var targ;
 
				if (tblTable.target)
				{
				  targ=tblTable.target;
				}
				else if (tblTable.srcElement)
				  {
				  targ=tblTable.srcElement;
				  }
				  if (targ.nodeType==3) // defeat Safari bug
				  {
				  targ = targ.parentNode;
				  }
 

			  var innerTable = targ.parentNode.parentNode.parentNode; //stoping at tbody	
			  var i=0;
			  var RowToMove=0;
			  var PreviousRow;
			  var CurrentRow;
 
					for(i=0; i &lt; innerTable.rows.length-1; i++)
						{
						 if((innerTable.rows[i].cells[2]) &amp;&amp; (innerTable.rows[i].cells[2].className.indexOf(" fill") != -1) ) //is selected ?
						  {
							eraseButtons(innerTable);
							 RowToMove = i;
							 var cellInnerHtml = innerTable.rows[i].cells[2].innerHTML;
							 //appends the selected row to the end of the Table
							 innerTable.rows[i].parentNode.appendChild(innerTable.rows[i]);
							if (navigator.appName == "Microsoft Internet Explorer")
							{ 						
								var sAppVersion = navigator.appVersion;
								sAppVersion = sAppVersion.replace (/.*MSIE /i, "");
								sAppVersion = sAppVersion.split (';')[0];
								if ( (sAppVersion == "6.0")  || (sAppVersion &lt; "6.0") )
								{
									 //change the value of check box of last element of inner table (newly added)
									 innerTable.rows[innerTable.rows.length-1].cells[2].innerHTML = cellInnerHtml;
								}
							}
 
							 var numofloop = (innerTable.rows.length-RowToMove);
							 for(i=0,j=innerTable.rows.length; i &lt; numofloop ; i++,j--)
							 {
								 if(j &gt; 0)
								 {
								CurrentRow = innerTable.rows[j];
								PreviousRow = innerTable.rows[j-1];
								interChangeFirstColumn(CurrentRow, PreviousRow);
								}
							 }
 
 
							 //this code moves the appended row up till it reaches 
							 //to one position less than its original position
							 for(i=innerTable.rows.length-1; i &gt; RowToMove+1; i--)
							 {
								 if(i &gt; 0)
								 {
								CurrentRow = innerTable.rows[i];
								PreviousRow = innerTable.rows[i-1];
								SendUp(CurrentRow, PreviousRow);
								}
							 }
							keepButtons(innerTable);					
						 }
					}
				
				} 
	    }

				</script>				
				
				
				</xsl:if>
        <xsl:if test="SummaryData">
		<script type="text/javascript">

          var duration = { duration: 0.5 };
          var delay = { delay: 0.25 };
          if (typeof document.observe == 'function') {
          //animation using scriptaculous and prototype
          document.observe("dom:loaded", function () {
          table_accordion_setup('health_accordion', 'health_closed_table', 'health_table', 'system');
          table_accordion_setup('notes_accordion', 'notes_closed_table', 'notes_table');
          container_accordion_setup('remote_title', 'remote_header', 'remote_body');
          container_accordion_setup('id', 'system_header', 'system_body');
          container_accordion_setup('quicklaunch_title', 'quicklaunch_header', 'quicklaunch_body');
          });

          function table_accordion_setup(accordion, closed_table, table, type) {
          accordion_setup_mouse(accordion);
		  if( (accordion != null) &amp;&amp; ($(accordion)))
			{
			  if (type == 'system') {
			  $(accordion).observe('click', function () { system_table_accordion_click(accordion, closed_table, table) });
			  } else {
			  $(accordion).observe('click', function () { table_accordion_click(accordion, closed_table, table) });
			  }
			}  
          }
          function container_accordion_setup(accordion, header, body) {
          accordion_setup_mouse(accordion);
		  if( (accordion != null) &amp;&amp; ($(accordion)))
			$(accordion).observe('click', function () { container_accordion_click(accordion, header, body) });
          }

          function accordion_setup_mouse(obj) {
          if (obj != null) {
			if($(obj))
			{
			  $(obj).observe('mouseover', function () { this.style.cursor = "pointer"; });
			  $(obj).observe('mouseout', function () { this.style.cursor = "default"; });
			  $(obj).observe('dblclick', function () { return false; });
			}
          }
          }
          function system_table_accordion_click(accordion, closed_table, table) {
          var obj = $(accordion).down();
          obj.toggleClassName('system_accordion_open');
          if (obj.hasClassName('system_accordion_open')) {
          Effect.SlideUp(table, duration);
          Effect.toggle(closed_table, 'appear', delay);
          } else {
          $(closed_table).hide();
          Effect.SlideDown(table, duration);
          }
          if (typeof pullTab.changePullTab == 'function') {
          setTimeout(function () { pullTab.changePullTab() }, 300);
          }

          }
          function table_accordion_click(accordion, closed_table, table) {
          var obj = $(accordion).down();
          obj.toggleClassName('table_accordion_open');
          if (obj.hasClassName('table_accordion_open')) {
          Effect.SlideUp(table, duration);
          Effect.toggle(closed_table, 'appear', delay);
          } else {
          $(closed_table).hide();
          Effect.SlideDown(table, duration);
          }
          if (typeof pullTab.changePullTab == 'function') {
          setTimeout(function () { pullTab.changePullTab() }, 300);
          }

          }
          function container_accordion_click(accordion, header, body) {
          var obj = $(accordion);

          if (obj.hasClassName('container_top_right_accordian_closed')) {
          Effect.SlideDown(header, duration);
          Effect.SlideDown(body, duration);
          } else {
          Effect.SlideUp(header, duration);
          Effect.SlideUp(body, duration);
          }
          obj.toggleClassName('container_top_right_accordian_closed');
          obj.select('div.container_gradient').first().toggleClassName('container_gradient_closed');
          obj.up().select('div.container_bottom').first().toggleClassName('container_bottom_closed');

          if (typeof pullTab.changePullTab == 'function') {
          setTimeout(function () { pullTab.changePullTab() }, 300);
          }
          }
          }



        </script>
		</xsl:if>
        <xsl:apply-templates select="script"/>
			</head>
			<!-- Have different bodies for Progressbar progress data and everything else -->
			<xsl:choose>
				<xsl:when test="ProgressBar/@progressdata='true'">
					<!-- Progress data does not need any html data to render the page.
						   It just needs few javascript functions for the iframe to update the progress bar.
						   Inserting unnecessary html data causes significant delay between consecutive
						   requests to the server. This delay in turn effects the performance of
						   progress bar.
					 -->
					<body onload="javascript:init();"></body>
				</xsl:when>
				<xsl:otherwise>
<!-- Begin Html body -->
			<body onload="javascript:init();">
			<xsl:if test="not(@nographics)">			
				<!--Borders in the data area left and right -->
				<div id="pullstrip" onmousedown="pullTab.ra_resizeStart(event, this);">
				</div>
				<div id="rightside">
				</div>
			</xsl:if>	
        <div class="data-area">
				<xsl:choose>
					<xsl:when test="SelectionData/@scrollablecontent= 'true'"></xsl:when>
					<xsl:otherwise>
						<a name="top" id="top"></a>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Comment 14: -->
				<xsl:if test="@date='true'">
					<!--102436 - Localization of calendar -->
					<iframe id='calendar' marginheight='0' marginwidth='0' frameborder='0' style='display: none; position: absolute; width: 157px; height: 161px; z-index: 100' scrolling='no'>
						<xsl:variable name="lang"><xsl:value-of select="/OMA/@language"/></xsl:variable>
						<xsl:variable name="country"><xsl:value-of select="/OMA/@country"/></xsl:variable>
						<xsl:attribute name="src">
							<xsl:choose>
	                            <xsl:when test="$lang='en'">/oma/calendar.html</xsl:when>
								<xsl:when test="$country='tw'">/oma/calendar.html</xsl:when>
								<xsl:otherwise>/oma/<xsl:value-of select="$lang"/>/calendar.html</xsl:otherwise>
	                        </xsl:choose>
						</xsl:attribute>
					</iframe>
					<xsl:element name="input">
						<xsl:attribute name="type">hidden</xsl:attribute>
						<xsl:attribute name="name">currentDateObj</xsl:attribute>
						<xsl:attribute name="id">currentDateObj</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<!-- Comment 14: END-->
				<!-- Comment 15: -->
				<xsl:if test="ProgressBar/@uidata='true'">
					<iframe id='progressbar' marginheight='0' marginwidth='0' frameborder='0' style='visibility: hidden; position: absolute;  width: 0px; height: 0px; z-index: -1;' scrolling='no'>
						<xsl:attribute name="src"><xsl:value-of select="ProgressBar/UIData/Update/@href"/></xsl:attribute>
					</iframe>
				</xsl:if>
				<!-- Comment 15: END-->
				<xsl:choose>
					<xsl:when test="SelectionData/@scrollablecontent= 'true'"></xsl:when>
					<xsl:otherwise>
						<div class="data-area-page-title">
						<table width="100%">
						<tr width="100%">
						<td width="70%" id="pagetitle_td">
						<xsl:apply-templates select="PageTitle"/>
						</td>
						
						<!-- Comment 16: Custom Buttons start with a default print button on the top right hand corner  (unless otherwise printable is set to false)-->

				<!-- no tool bar when no graphics is present -->
				<xsl:if test="not(@nographics)">						
				<td width="30%" id="toolbar_td">				
						<!--C88778 Added Custom buttons on left of frame-->
					<div class="toolbar" id="toolbar_div">
					<!-- <xsl:apply-templates select="CustomButton[@align='left']"/> -->
						<a>
						<xsl:attribute name="href">#</xsl:attribute>
						<xsl:attribute name="id">printbutton</xsl:attribute>
						<xsl:attribute name="title"><xsl:value-of select="$strPrint"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="@printable">
									<xsl:choose>
										<xsl:when test="@printable != 'false'">
											<xsl:attribute name="class">print</xsl:attribute>
											<xsl:choose>
												<xsl:when test="@expand">
													<xsl:attribute name="onclick">javascript:DataAreaPrint(<xsl:value-of select="@expand"/>);</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="onclick">javascript:DataAreaPrint(false);</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">print_disabled</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">print</xsl:attribute>
								<xsl:choose>
									<xsl:when test="@expand">
										<xsl:attribute name="onclick">javascript:DataAreaPrint(<xsl:value-of select="@expand"/>);</xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="onclick">javascript:DataAreaPrint(false);</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						</a>
						
						<a>
						<xsl:attribute name="id">exportbutton</xsl:attribute>
						<xsl:attribute name="formSubmit">true</xsl:attribute>
						<xsl:attribute name="href">#</xsl:attribute>						
						<xsl:attribute name="title"><xsl:value-of select="$strExport"/></xsl:attribute>
							<xsl:choose>
								<xsl:when test="(/OMA/@userrights = '7' or /OMA/@userrights = '3')">
									<xsl:choose>
											<xsl:when test="@exportdata">
												<xsl:choose>
													<xsl:when test="@exportdata != 'false'">
														<xsl:attribute name="class">export</xsl:attribute>
														<xsl:attribute name="onclick">javascript:exportCustomDelimitedData();</xsl:attribute>
													</xsl:when>
													<xsl:otherwise>
														<xsl:attribute name="class">export_disabled</xsl:attribute>
													</xsl:otherwise>
												</xsl:choose>	
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">export</xsl:attribute>
												<xsl:attribute name="onclick">javascript:exportCustomDelimitedData();</xsl:attribute>
											</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">export_disabled</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</a>		
									
						<a>
						<xsl:attribute name="id">emailbutton</xsl:attribute>	
						<xsl:attribute name="formSubmit">true</xsl:attribute>	
						<xsl:attribute name="title"><xsl:value-of select="$strEmail"/></xsl:attribute>						
						<xsl:attribute name="href">#</xsl:attribute>	
							<xsl:choose>
								<xsl:when test="@email">
									<xsl:choose>
										<xsl:when test="(@email != 'false') and (/OMA/@userrights = '7' or /OMA/@userrights = '3')">
											<xsl:attribute name="class">email</xsl:attribute>
											<xsl:choose>
												<xsl:when test="@expand">
														<xsl:attribute name="onclick">javascript:sendEmail(<xsl:value-of select="@expand"/>);</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="onclick">javascript:sendEmail(false);</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
												<xsl:attribute name="class">email_disabled</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="/OMA/@userrights = '7' or /OMA/@userrights = '3'">
											<xsl:attribute name="class">email</xsl:attribute>
											<xsl:choose>
												<xsl:when test="@expand">
													<xsl:attribute name="onclick">javascript:sendEmail(<xsl:value-of select="@expand"/>);</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="onclick">javascript:sendEmail(false);</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
												<xsl:attribute name="class">email_disabled</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>

								</xsl:otherwise>
							</xsl:choose>
						</a>
						<!-- Even though managing refresh with name alone is good enough, considering future 
							implementation like refresh button with name as refresh and no display string,
							doing check for name as well as the display -->
						<!-- <xsl:apply-templates select="CustomButton/Data[@name='Refresh']"/> -->
						<xsl:choose>
							<xsl:when test="CustomButton/Data[@name='Refresh' or @name='refresh']">
								<xsl:apply-templates select="CustomButton/Data[@name='Refresh' or @name='refresh']"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="CustomButton/Data[@display=$strRefresh]">
										<xsl:apply-templates select="CustomButton/Data[@display=$strRefresh]"/>
									</xsl:when>
									<xsl:otherwise>
										<a>
										<xsl:attribute name="href">#</xsl:attribute>
										<xsl:attribute name="id">refresh</xsl:attribute>
										<xsl:attribute name="title"><xsl:value-of select="$strRefresh"/></xsl:attribute>
										<xsl:attribute name="class">refresh_disabled</xsl:attribute>
										</a>			
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						
						<a>
						<xsl:attribute name="href">#</xsl:attribute>
						<xsl:attribute name="onclick">javascript:top.gnv.help ('./OMSAHelp?nbflag=true' , 'null');</xsl:attribute>
						<xsl:attribute name="id">helpbutton</xsl:attribute>
						<xsl:attribute name="title"><xsl:value-of select="$strHelp"/></xsl:attribute>
						<xsl:attribute name="class">help</xsl:attribute>
						</a>			
				</div>
				</td>
				
             </xsl:if> 
			 </tr>
			 </table>
			 <xsl:if test="not(@nographics)">
					<xsl:choose>
						<xsl:when test="PageTitle/@display!='' ">
							 <div class="da-line"></div>  
						</xsl:when>
					<xsl:otherwise>

						<xsl:choose>
							<xsl:when test="PageTitle='' ">
								<div class="da-line"></div>  
							</xsl:when>
			
							<xsl:when test="PageTitle/display='' ">
								<div class="da-line"></div>  
							</xsl:when>
							<xsl:otherwise>
								<div class="da-line da-line-nopagetitle"></div> 
							</xsl:otherwise>

						</xsl:choose>
				
					</xsl:otherwise>
		 	
					</xsl:choose>
			 </xsl:if>
		
		
             
				<xsl:if test="CustomButton/Data[ not( @name='Refresh' )] and CustomButton/Data[ not( @name='refresh' )] and CustomButton/Data[ not ( @display=$strRefresh )]">
          <div class="data-area-options">
            <div class="pageOptionCenter">
              <span>
                <xsl:value-of select="$strOptions"/>
              </span>
              <!--xsl:for-each select="CustomButton/Data[ (not( @name='Refresh' )) and (not ( @display=$strRefresh ))]">
                <ul>
                  <li class="divider">
                    <a class="task">
                    <xsl:apply-templates select="CustomButton/Data[ (not( @name='Refresh' )) and (not ( @display=$strRefresh ))]"/>
                    </a>
                  </li>
                </ul>
              </xsl:for-each-->
              <xsl:apply-templates select="CustomButton/Data[ (not( @name='Refresh' )) and (not ( @display=$strRefresh ))]"/>
            </div>
          </div>
          </xsl:if>      
					</div>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Comment 17: -->
				<form>
					<xsl:if test="@enctype = 'true'">
						<xsl:attribute name="ENCTYPE">multipart/form-data</xsl:attribute>
					</xsl:if>
					<xsl:if test="@validate='true'">
						<xsl:attribute name="onsubmit">return(validate());</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="action"><xsl:choose><xsl:when test="contains(@submit, 'javascript') = false"><xsl:value-of select="@submit"/><xsl:choose><xsl:when test="contains(@submit, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@submit"/></xsl:otherwise></xsl:choose></xsl:attribute>
					<xsl:attribute name="name">dataarea</xsl:attribute>
					<xsl:attribute name="id">dataarea</xsl:attribute>
					<xsl:attribute name="method">post</xsl:attribute>
					<input type="hidden" name="caller" id="caller" value=""/>
					<input type="hidden" name="pageCode" id="pageCode" value=""/>
					<input type="hidden" name="pageName" id="pageName" value=""/>
					<input type="hidden" name="csrfPreventionSalt" id="csrfPreventionSalt">
						<xsl:attribute name="value"><xsl:value-of select="//OMA/DataArea/CsrfSalt/"/></xsl:attribute>
					</input>
					<xsl:apply-templates select="CustomMessage"/>
					<xsl:apply-templates select="ProgressBar"/>
					<xsl:choose>
						<xsl:when test="(@ignoreJumpBar) or (SelectionData/@scrollablecontent ='true')"></xsl:when>
						<xsl:otherwise>
							<div id="tableBar" style="DISPLAY: none">
							<div id="tableBarContent"></div> 
							  <div class="jumpbar-line"></div>
							</div>
						</xsl:otherwise>
					</xsl:choose>
          <!-- Comment 16: END-->
          <xsl:if test="PromptText">
            <xsl:apply-templates select="PromptText"/>
          </xsl:if>
          <xsl:if test="AlertMessage">
            <xsl:apply-templates select="AlertMessage"/>
          </xsl:if>
		<xsl:if test="SubHeader">
			<xsl:apply-templates select="SubHeader">
				<xsl:with-param name="dataareasubheader" select="'true'" />
			</xsl:apply-templates>
		</xsl:if>	
		  <!-- HIIBios Apply/goBack-->  
		    <xsl:if test="@HIIBIOS">
				<xsl:if test="@submit or @cancel = 'true' or @backpagedisplay or @backpagedisplayfull or BottomCustomButton">
					<xsl:if test="((/OMA/DataArea/ListData) or (/OMA/DataArea/ComboData) or (not(/OMA/DataArea/ListData) and (position() &gt; 2)))">
					<div class="page_container">
							<div class="button_clear"> 
									<xsl:if test="@submit">
											<xsl:call-template name="button">
												<xsl:with-param name="href">javascript:formSubmit();</xsl:with-param>
												<xsl:with-param name="formSubmit">true</xsl:with-param>
												<xsl:with-param name="display">
													<xsl:choose>
														<xsl:when test="@submitdisplay != ''"><xsl:value-of select="@submitdisplay"/></xsl:when>
														<xsl:otherwise><xsl:value-of select="$strApply"/></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<!-- MM : Begin - D0196 - Fix for id issue -->
												<xsl:with-param name="id">submitbuttoncontent</xsl:with-param>
												<!-- MM : End - D0196- Fix for id issue -->
											</xsl:call-template>
									</xsl:if>
									<xsl:if test="@cancel = 'true'">
											<xsl:call-template name="button">
												<xsl:with-param name="href">
													<xsl:choose>
														<xsl:when test="@canceltarget != ''"><xsl:choose><xsl:when test="contains(@canceltarget, 'javascript') = false"><xsl:value-of select="@canceltarget"/><xsl:choose><xsl:when test="contains(@canceltarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@canceltarget"/></xsl:otherwise></xsl:choose></xsl:when>
														<xsl:otherwise>javascript:history.back ()</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												
												<!-- MM : Begin - D0195 - Fix for id issue -->
												<xsl:with-param name="id">cancelbutton</xsl:with-param>
												<xsl:with-param name="name">cancelbutton</xsl:with-param>
												<!-- MM : End - D0195 - Fix for id issue -->
												<xsl:with-param name="display">
													<xsl:choose>
													<xsl:when test="@canceldisplay!= ''"><xsl:value-of select="@canceldisplay"/></xsl:when>
                                                                    <xsl:otherwise><xsl:value-of select="$strCancel"/></xsl:otherwise>
     	                                                           </xsl:choose>
          	                                                  </xsl:with-param>
											</xsl:call-template>
									</xsl:if>
						
								<xsl:if test="@backpagedisplay">
											<xsl:call-template name="button">
												<xsl:with-param name="href">
										<xsl:choose><xsl:when test="contains(@backpagetarget, 'javascript') = false"><xsl:value-of select="@backpagetarget"/><xsl:choose><xsl:when test="contains(@backpagetarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@backpagetarget"/></xsl:otherwise></xsl:choose></xsl:with-param>
												<xsl:with-param name="display"><xsl:value-of select="$strGoBackToPage_part1"/><xsl:value-of select="@backpagedisplay"/> <xsl:value-of select="$strGoBackToPage_part3"/></xsl:with-param>
												<!-- MM : Begin - D0194 - Fix for id issue -->
												<xsl:with-param name="id">backbutton</xsl:with-param>
                        <xsl:with-param name="name">backbutton</xsl:with-param>
												<!-- MM : End - D0194- Fix for id issue -->
											</xsl:call-template>
									</xsl:if>
									<!--Addding new attribute to display the whole string incase plugins (i.e OMSS)need to display the whole string -->
									<xsl:if test="@backpagedisplayfull">
											<xsl:call-template name="button">
													<xsl:with-param name="href">
						<xsl:choose><xsl:when test="contains(@backpagetarget, 'javascript') = false"><xsl:value-of select="@backpagetarget"/><xsl:choose><xsl:when test="contains(@backpagetarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@backpagetarget"/></xsl:otherwise></xsl:choose></xsl:with-param>

													<xsl:with-param name="display"><xsl:value-of select="@backpagedisplayfull"/></xsl:with-param>
												<xsl:with-param name="formSubmit">true</xsl:with-param>
												<xsl:with-param name="id">backbutton</xsl:with-param>												
											</xsl:call-template>
									</xsl:if>						
									<!--End of backpagedisplayfull-->									
									<xsl:if test="BottomCustomButton">
										<xsl:for-each select="BottomCustomButton/Data">
											<!-- MM :Begin - D014 - fix for id issue -->
											<xsl:variable name="guid"><xsl:number count="node()" level="single"/></xsl:variable>
											<!-- MM :End - D014 - fix for id issue -->
											<xsl:call-template name="button_details">
												<xsl:with-param name="href">
													<xsl:choose>
														<xsl:when test="@name='Refresh'">
															<xsl:choose>
																<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
																<xsl:when test="@href"><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:when>
																<xsl:otherwise>#</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="onclick">
													<xsl:choose>
														<xsl:when test="@onclick"><xsl:value-of select="@onclick"/></xsl:when>
														<xsl:when test="@name='Refresh'">
															<xsl:choose>
																<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
																<xsl:when test="@href"></xsl:when>
																<xsl:otherwise>javascript:location.reload ()</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="formSubmit"><xsl:value-of select="@formSubmit"/></xsl:with-param>
												<xsl:with-param name="display"><xsl:value-of select="@display"/></xsl:with-param>
												<!-- MM : Begin - D014 - Fix for id issue -->
												<xsl:with-param name="id">
													<xsl:choose>
														<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
														<xsl:otherwise>bottomcustombutton_<xsl:value-of select="$guid"/></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<!-- MM : End - D014 - Fix for id issue -->
											</xsl:call-template>
										</xsl:for-each>
									</xsl:if>
							
							</div>
						</div>		
						</xsl:if>
					</xsl:if>
				</xsl:if>
		  
          <xsl:apply-templates select="TextArea"/>
          <xsl:apply-templates select="ListData"/>
          <xsl:apply-templates select="ComboData"/>
          <xsl:apply-templates select="TableData"/>
          <xsl:apply-templates select="SummaryData"/>
          <xsl:apply-templates select="HealthData"/>
          <xsl:apply-templates select="CustomTable"/>
          <xsl:apply-templates select="HTMLData"/>
          <xsl:apply-templates select="Guage"/>
          <xsl:apply-templates select="PerformanceData"/>
		  <xsl:apply-templates select="SelectionData"/>
		 <xsl:apply-templates select="SelectionDataUI"/>
		 <xsl:apply-templates select="ListTableData"/>
		 <xsl:if test="/OMA/DataArea/@statistics='true')">		
		  	<!--xsl:call-template name="plotstatistics"/-->
		 </xsl:if>
		
				<!-- Comment 17: END-->
				<xsl:choose>
					<xsl:when test="(SelectionData/@scrollablecontent = 'true')"></xsl:when>
					<xsl:otherwise>
						<!-- Comment 18: -->
					<xsl:if test="@submit or @cancel = 'true' or @backpagedisplay or @backpagedisplayfull or BottomCustomButton">
					<div class="page_container">
						<div class="button_vdivider"> 
							<div class="button_clear"> 
								<xsl:if test="@submit">
									<xsl:choose>
										<xsl:when test="@submitform"></xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="button">
												<xsl:with-param name="href">javascript:formSubmit();</xsl:with-param>
												<xsl:with-param name="formSubmit">true</xsl:with-param>
												<xsl:with-param name="display">
													<xsl:choose>
														<xsl:when test="@submitdisplay != ''"><xsl:value-of select="@submitdisplay"/></xsl:when>
														<xsl:otherwise><xsl:value-of select="$strApply"/></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<!-- MM : Begin - D0196 - Fix for id issue -->
												<xsl:with-param name="id">submitbuttoncontent</xsl:with-param>
												<!-- MM : End - D0196- Fix for id issue -->
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
									<xsl:if test="@cancel = 'true'">
											<xsl:call-template name="button">
												<xsl:with-param name="href">
													<xsl:choose>
														<xsl:when test="@canceltarget != ''"><xsl:choose><xsl:when test="contains(@canceltarget, 'javascript') = false"><xsl:value-of select="@canceltarget"/><xsl:choose><xsl:when test="contains(@canceltarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@canceltarget"/></xsl:otherwise></xsl:choose></xsl:when>
														<xsl:otherwise>javascript:history.back ()</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												
												<!-- MM : Begin - D0195 - Fix for id issue -->
												<xsl:with-param name="id">cancelbutton</xsl:with-param>
												<xsl:with-param name="name">cancelbutton</xsl:with-param>
												<!-- MM : End - D0195 - Fix for id issue -->
												<xsl:with-param name="display">
													<xsl:choose>
													<xsl:when test="@canceldisplay!= ''"><xsl:value-of select="@canceldisplay"/></xsl:when>
                                                                    <xsl:otherwise><xsl:value-of select="$strCancel"/></xsl:otherwise>
     	                                                           </xsl:choose>
          	                                                  </xsl:with-param>
											</xsl:call-template>
									</xsl:if>
						
								<xsl:if test="@backpagedisplay">
											<xsl:call-template name="button">
												<xsl:with-param name="href">
<xsl:choose><xsl:when test="contains(@backpagetarget, 'javascript') = false"><xsl:value-of select="@backpagetarget"/><xsl:choose><xsl:when test="contains(@backpagetarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@backpagetarget"/></xsl:otherwise></xsl:choose></xsl:with-param>
												<xsl:with-param name="display"><xsl:value-of select="$strGoBackToPage_part1"/><xsl:value-of select="@backpagedisplay"/> <xsl:value-of select="$strGoBackToPage_part3"/></xsl:with-param>
												<!-- MM : Begin - D0194 - Fix for id issue -->
												<xsl:with-param name="id">backbutton</xsl:with-param>
                        <xsl:with-param name="name">backbutton</xsl:with-param>
												<!-- MM : End - D0194- Fix for id issue -->
											</xsl:call-template>
									</xsl:if>
									<!--Addding new attribute to display the whole string incase plugins (i.e OMSS)need to display the whole string -->
									<xsl:if test="@backpagedisplayfull">
											<xsl:call-template name="button">
													<xsl:with-param name="href">
<xsl:choose><xsl:when test="contains(@backpagetarget, 'javascript') = false"><xsl:value-of select="@backpagetarget"/><xsl:choose><xsl:when test="contains(@backpagetarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@backpagetarget"/></xsl:otherwise></xsl:choose></xsl:with-param>

													<xsl:with-param name="display"><xsl:value-of select="@backpagedisplayfull"/></xsl:with-param>
												<xsl:with-param name="formSubmit">true</xsl:with-param>
												<xsl:with-param name="id">backbutton</xsl:with-param>												
											</xsl:call-template>
									</xsl:if>						
									<!--End of backpagedisplayfull-->									
									<xsl:if test="BottomCustomButton">
										<xsl:for-each select="BottomCustomButton/Data">
											<!-- MM :Begin - D014 - fix for id issue -->
											<xsl:variable name="guid"><xsl:number count="node()" level="single"/></xsl:variable>
											<!-- MM :End - D014 - fix for id issue -->
											<xsl:call-template name="button_details">
												<xsl:with-param name="href">
													<xsl:choose>
														<xsl:when test="@name='Refresh'">
															<xsl:choose>
																<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
																<xsl:when test="@href"><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:when>
																<xsl:otherwise>#</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="onclick">
													<xsl:choose>
														<xsl:when test="@onclick"><xsl:value-of select="@onclick"/></xsl:when>
														<xsl:when test="@name='Refresh'">
															<xsl:choose>
																<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
																<xsl:when test="@href"></xsl:when>
																<xsl:otherwise>javascript:location.reload ()</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="formSubmit"><xsl:value-of select="@formSubmit"/></xsl:with-param>
												<xsl:with-param name="display"><xsl:value-of select="@display"/></xsl:with-param>
												<!-- MM : Begin - D014 - Fix for id issue -->
												<xsl:with-param name="id">
													<xsl:choose>
														<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
														<xsl:otherwise>bottomcustombutton_<xsl:value-of select="$guid"/></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<!-- MM : End - D014 - Fix for id issue -->
											</xsl:call-template>
										</xsl:for-each>
									</xsl:if>
							</div>
						</div>
					</div>		
					</xsl:if>

					<!-- Comment 18: END-->
					</xsl:otherwise>
				</xsl:choose>
				<!--  Start Performance Iframe -->
				<xsl:if test="PerformanceData/@type='uidata'">
					<iframe id='perfmgnt' marginheight='0' marginwidth='0' frameborder='0' style='visibility: hidden; position: absolute;  width: 0px; height: 0px; z-index: -1;' scrolling='no'>
						<xsl:attribute name="src"><xsl:value-of select="PerformanceData/UIData/Update/@href"/></xsl:attribute>
					</iframe>
				</xsl:if>
				<xsl:if test="(/OMA/@userrights = '7' or /OMA/@userrights = '3')">
					<xsl:choose>
						<xsl:when test="@exportdata">
							<xsl:if test="@exportdata != 'false'">
								<iframe id='exportdataiframe' name="exportdataiframe" marginheight='0' marginwidth='0' frameborder='0' scrolling='no' style='visibility: hidden; position: absolute;  width: 0px; height: 0px; z-index: -1;'>
									<xsl:attribute name="src">javascript:top.gnv.appendVID('./DataArea?plugin=com.dell.oma.webplugins.EmptyDataWebPlugin')</xsl:attribute>
								</iframe>
								<input type="hidden" name="exportdatacontent" id="exportdatacontent" value=""/>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<iframe id='exportdataiframe' name="exportdataiframe" marginheight='0' marginwidth='0' frameborder='0' scrolling='no' style='visibility: hidden; position: absolute;  width: 0px; height: 0px; z-index: -1;'>
								<xsl:attribute name="src">javascript:top.gnv.appendVID('./DataArea?plugin=com.dell.oma.webplugins.EmptyDataWebPlugin')</xsl:attribute>
							</iframe>
							<input type="hidden" name="exportdatacontent" id="exportdatacontent" value=""/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if> 
				<!--  End Performance Iframe -->
					<xsl:apply-templates select="HiddenTable"/>
				</form>
			</div>
			</body>
<!-- End of Html Body -->
				</xsl:otherwise>
			</xsl:choose>
		</html>
	</xsl:template>
	<xsl:template name="SelectionDataRowExpandFunction">
		<xsl:param name="childrows"/>
		<xsl:if test=" $childrows &gt; 0 ">
			document.getElementById( '<xsl:value-of select="@name"/>' ).style.display = "";
		</xsl:if>

		<xsl:for-each select="ChildrenRows/Row">
			<xsl:call-template name="SelectionDataRowExpandFunction">
				<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="HiddenTable">
		<xsl:for-each select="Data">
			<xsl:call-template name="datatype">
				<xsl:with-param name="type">hidden</xsl:with-param>
				<xsl:with-param name="name"><xsl:value-of select="@name"/></xsl:with-param>
				<xsl:with-param name="returnvalue"><xsl:value-of select="@returnvalue"/></xsl:with-param>
				<!-- MM :Begin - D015 - fix for id issue -->
				<xsl:with-param name="id"><xsl:value-of select="@id"/></xsl:with-param>
				<!-- MM :End - D015 - fix for id issue -->
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="HealthData">
		<!-- MM :Begin - D016 - fix for id issue -->
		<xsl:variable name="row_id"><xsl:number count="node()" level="single"/></xsl:variable>
		<!-- MM :End - D016 - fix for id issue -->		
		<div class="table_container"> 
		<div class="table_gutter"> 
		<table border="0" cellpadding="0" cellspacing="0" class="container autolayout">
		<thead>
			<tr>
				<td class="topleft"> </td>
        <td class="top borderright" width="80%">
          <!-- MM : Begin - D016 - fix for id issue -->
          <xsl:attribute name="id">
            hdr_component_<xsl:value-of select="$row_id"/>
          </xsl:attribute>
          <!-- MM : End - D016 - fix for id issue -->
          <xsl:value-of select="$strComponent"/>
        </td>
        <td class="top center">
          <!-- MM : Begin - D016 - fix for id issue -->
          <xsl:attribute name="id">
            hdr_severity_<xsl:value-of select="$row_id"/>
          </xsl:attribute>
          <!-- MM : End - D016 - fix for id issue -->
          <xsl:value-of select="$strSeverity"/>
        </td>
				 <td class="topright"> </td> 
			</tr>
		</thead>
      <tr>
        <td class="left"> </td>
        <td class="instructions" colspan="2">
          <xsl:apply-templates select="./PromptText">
            <xsl:with-param name="caller">inline</xsl:with-param>
          </xsl:apply-templates>
        </td>
        <td class="right">  </td>
      </tr>
      <tbody>
			<xsl:for-each select="Data">
				<!-- MM :Begin - D017 - fix for id issue -->
				<xsl:variable name="col_id"><xsl:number count="node()" level="single"/></xsl:variable>
				<xsl:variable name="guid"><xsl:value-of select="$row_id"/>_<xsl:value-of select="$col_id"/></xsl:variable>
				<xsl:variable name="uid">
					<xsl:choose>
						<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
						<xsl:when test="@name != ''">link_<xsl:value-of select="@name"/></xsl:when>
						<xsl:otherwise>link_<xsl:value-of select="$guid"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="img_uid">
					<xsl:choose>
						<xsl:when test="@id != ''">img_<xsl:value-of select="@id"/></xsl:when>
						<xsl:otherwise>img_<xsl:value-of select="$guid"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>				
				<!-- MM :End - D017 - fix for id issue -->
				
					<xsl:choose>
						<xsl:when test="(position() mod 2)=1">
						<tr>
							<td class="left"></td>
              <td class="contents borderright borderbottom" align="left">
                <xsl:element name="a">
                  <xsl:attribute name="href">
                    <xsl:call-template name="add-href-data" />
                  </xsl:attribute>
                  <xsl:if test="@onclick">
                    <xsl:attribute name="onclick">
                      <xsl:value-of select="@onclick"/>
                    </xsl:attribute>
                  </xsl:if>
                  <!-- MM : Begin - D017 - fix for id issue -->
                  <xsl:attribute name="id">
                    <xsl:value-of select="$uid"/>
                  </xsl:attribute>
                  <!-- we give 'name' attribute as well as SilkTest doesnt use id for Hrefs -->
                  <xsl:attribute name="name">
                    <xsl:value-of select="$uid"/>
                  </xsl:attribute>
				  <xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
                  <!-- MM : End - D017 - fix for id issue -->
                  <xsl:value-of select="@display"/>
                </xsl:element>
              </td>
							<td class="contents borderbottom" align="center">
								<xsl:call-template name="display-status">
									<xsl:with-param name="name" select="@name" />
									<xsl:with-param name="status" select="@status" />
									<!-- MM :Begin - D017 - fix for id issue -->
									<xsl:with-param name="id"><xsl:value-of select="$img_uid"/></xsl:with-param>
									<!-- MM :End - D017 - fix for id issue -->
								</xsl:call-template>
							</td>
							<td class="right"></td>
						</tr>	
						</xsl:when>
						<xsl:otherwise>
						<tr class="fill">
							<!-- <td style="width: 15px" /> -->
							<td class="left"></td>
              <td class="contents borderright borderbottom" align="left">
                <xsl:element name="a">
                  <xsl:attribute name="href">
                    <xsl:call-template name="add-href-data" />
                  </xsl:attribute>
                  <xsl:if test="@onclick">
                    <xsl:attribute name="onclick">
                      <xsl:value-of select="@onclick"/>
                    </xsl:attribute>
                  </xsl:if>
                  <!-- MM : Begin - D017 - fix for id issue -->
                  <xsl:attribute name="id">
                    <xsl:value-of select="$uid"/>
                  </xsl:attribute>
                  <!-- we give 'name' attribute as well as SilkTest doesnt use id for Hrefs -->
                  <xsl:attribute name="name">
                    <xsl:value-of select="$uid"/>
                  </xsl:attribute>
				  <xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
                  <!-- MM : End - D017 - fix for id issue -->
                  <xsl:value-of select="@display"/>
                </xsl:element>
              </td>
							<td class="contents borderbottom" align="center">
								<xsl:call-template name="display-status">
									<xsl:with-param name="name" select="@name" />
									<xsl:with-param name="status" select="@status" />
									<!-- MM :Begin - D017 - fix for id issue -->
									<xsl:with-param name="id"><xsl:value-of select="$img_uid"/></xsl:with-param>
									<!-- MM :End - D017 - fix for id issue -->
								</xsl:call-template>
							</td>
							<td class="right"></td>
						</tr>	
						</xsl:otherwise>
					</xsl:choose>
			</xsl:for-each>
		</tbody>
		<tfoot> <tr> <td class="bottomleft"> </td> <td class="bottom" colspan="2"> </td> <td class="bottomright"> </td> </tr> </tfoot> 
		</table>
		</div>
		</div>
	</xsl:template>
	<xsl:template match="/OMA/DataArea/Statistics/ListData">
		<xsl:call-template name="ListDataEntries">
		<xsl:with-param name="caller">custom</xsl:with-param>
	</xsl:call-template>
	</xsl:template>
	<xsl:template match="ListData">
		<xsl:param name="noborder"/>
	<xsl:choose>
	<xsl:when test="count(Data[not(@type='hidden')]) = 0">
		<xsl:for-each select="Data">
			<xsl:call-template name="datatype">
				<xsl:with-param name="type">hidden</xsl:with-param>
				<xsl:with-param name="name"><xsl:value-of select="@name"/></xsl:with-param>
				<xsl:with-param name="returnvalue"><xsl:value-of select="@returnvalue"/></xsl:with-param>
				<!-- MM :Begin - D015 - fix for id issue -->
				<xsl:with-param name="id"><xsl:value-of select="@id"/></xsl:with-param>
				<!-- MM :End - D015 - fix for id issue -->
			</xsl:call-template>
		</xsl:for-each>
	</xsl:when>	
	<xsl:when test="$noborder='true'">
	<div>
	<xsl:choose>
   	<xsl:when test="position() &gt; 1">
      <xsl:choose>
    <xsl:when test="@extended='true'">
		<xsl:attribute name="class">list_container</xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
      <xsl:attribute name="class">table_container</xsl:attribute>
    </xsl:otherwise>
        </xsl:choose>
	</xsl:when>    
	<xsl:otherwise>
		<xsl:attribute name="class">empty_table_container</xsl:attribute>
	</xsl:otherwise>
	</xsl:choose>
        <xsl:apply-templates select="SubHeader">
          <xsl:with-param name="tablesubheader" select="'true'" />
        </xsl:apply-templates>
        
		<div class="container_title">
		  <xsl:apply-templates select="Header">
		  </xsl:apply-templates>
		  <xsl:choose>
			<xsl:when test="@display!=''">
			  <xsl:value-of select="@display"/>
			</xsl:when>
			<xsl:otherwise>
			  <xsl:value-of select="@name"/>
			</xsl:otherwise>
		  </xsl:choose>
		  </div>
		
		 <table class="infolist">
			  <tr>
				<td class="top_spacer_small" colspan="2">
				</td>
			  </tr>
			  <xsl:call-template name="ListDataEntries">
				<xsl:with-param name="caller">custom</xsl:with-param>
			  </xsl:call-template>
			  <tr>
				<td class="bottom_spacer_small" colspan="2">
				</td>
			  </tr>
		</table>
   	</div>
	</xsl:when>
	<xsl:otherwise>
    <xsl:variable name="guid">
      <xsl:choose>
        <xsl:when test="@name != ''">
          <xsl:value-of select="@name"/>
        </xsl:when>
        <xsl:otherwise>listtable<xsl:value-of select="position()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="width">
      <xsl:choose>
        <xsl:when test="@width != ''">
          <xsl:value-of select="@width"/>
        </xsl:when>
        <xsl:otherwise>100%</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <!-- MM : This value will be used to generate id for back to top -->
    <xsl:variable name="backToTopId" select="$guid"/>
    <!-- MM :End - D030 - fix for id issue -->

    <!-- fix for logs taking longer time to display - this is because of xsl functions (count, preceding) used in Row -->
    <!-- template to check for duplicate values, take longer time to complete. -->
    <!-- pass attribute to enable/disable unique ID generation. nouniqueids is an optional attribute. defaults to false -->
    <xsl:variable name="noUniqIDs">
      <xsl:choose>
        <xsl:when test="@nouniqueids ='true' ">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="@ignoreJumpBar"></xsl:when>
	  <xsl:when test="@name">
		  <script language="javascript">
				  addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>',"<xsl:value-of select='@display'/>");
				  incTableCount();
				</script>
			<a>
			  <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			  <xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
			</a>	  
	  </xsl:when>
      <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="SubHeader">
				<script language="javascript">
				  addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="$guid" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', "<xsl:value-of select='./SubHeader/@display'/>");
				  incTableCount();
				</script>
            </xsl:when>
			<xsl:when test="Header">
				<script language="javascript">
				  addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="$guid" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', "<xsl:value-of select='./Header/Data/@display'/>");
				  incTableCount();
				</script>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
          </xsl:choose>
		<a>
		<xsl:attribute name="name"><xsl:value-of select="$guid"/></xsl:attribute>
		<xsl:attribute name="id"><xsl:value-of select="$guid"/></xsl:attribute>
		</a>
			        
      </xsl:otherwise>
    </xsl:choose>

    <!--C106630 Allow script inside ListData-->
		<xsl:apply-templates select="script"/>
		<!-- MM :Begin - D033 - fix for id issue -->
		<xsl:variable name="guid">
			<xsl:choose>
				<!-- @name is required if more than one ListData is there and position() is required if more than one ListData has the same name. -->
				<xsl:when test="@name != ''"><xsl:value-of select="@name"/><xsl:value-of select="position()"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM :End - D033 - fix for id issue -->
    <xsl:choose>
      <xsl:when test="@type='custom'">
        <xsl:apply-templates select="SubHeader">
          <xsl:with-param name="puid" select="$guid"/>
          <xsl:with-param name="tablesubheader" select="'true'" />
        </xsl:apply-templates>
        <div>
          <xsl:choose>
            <xsl:when test="not(Header)">
              <xsl:attribute name="class">table_container_no_header</xsl:attribute>
            </xsl:when>
               <xsl:otherwise>
              <xsl:attribute name="class">table_container</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <div class="table_gutter">
            <div class="container_top_right" id="system_title">
              <div class="container_top_left">
                <div class="container_gradient">
                  <div class="container_title">
                    <xsl:apply-templates select="Header">
                      <xsl:with-param name="puid" select="$guid"/>
                    </xsl:apply-templates>
                    <!--					<xsl:apply-templates select="SubHeader">
					  <xsl:with-param name="puid" select="$guid"/>
					  <xsl:with-param name="tablesubheader" select="'true'" />
					</xsl:apply-templates>
					-->
                    <xsl:choose>
                      <xsl:when test="/OMA/DataArea/@ignoreJumpBar"></xsl:when>
                      <xsl:otherwise>
                        <xsl:if test="(((count( /OMA/DataArea/TableData ) &gt; 0) or (count( /OMA/DataArea/ListData ) &gt; 0) or (count( /OMA/DataArea/ComboData ) &gt; 0)) and (position() &gt; 1))">
                          <div class="backtotop backtotop_container_title">
                            <a href="#top">
                              <!-- MM :Begin - D041 - fix for id issue -->
                              <!-- Add 'id' and 'name' attribute -->
                              <xsl:attribute name="id">
                                backtotop_<xsl:value-of select="$backToTopId"/>
                              </xsl:attribute>
                              <xsl:attribute name="name">
                                backtotop_<xsl:value-of select="$backToTopId"/>
                              </xsl:attribute>
                              <!-- MM :End - D041 - fix for id issue -->
                              <xsl:value-of select="$strBackToTop"/>
                            </a>
                          </div>
                        </xsl:if>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>
                </div>
              </div>
            </div>

            <div class="container_right" id="system_body">
              <div class="container_left">
                <xsl:if test="./PromptText">
                  <div class="container_content instructions">
                    <div class="container_item">
                      <xsl:apply-templates select="./PromptText">
                        <xsl:with-param name="caller">inline</xsl:with-param>
                      </xsl:apply-templates>
                    </div>
                  </div>
                </xsl:if>


                <div class="empty_table_container_left">
                  <xsl:choose>
                    <xsl:when test ="./Data/@Control_left='true'">
                      <table>
                        <tr>
                          <td class="top_spacer_small" colspan="2">
                          </td>
                        </tr>
                        <xsl:call-template name="ListDataEntries">
                          <xsl:with-param name="caller">custom</xsl:with-param>
                          <!-- MM : Begin - D033 - fix -->
                          <xsl:with-param name="puid" select="$guid"></xsl:with-param>
                          <!-- MM : End - D033 - fix -->
                        </xsl:call-template>
                        <tr>
                          <td class="bottom_spacer_small" colspan="2">
                          </td>
                        </tr>
                      </table>
                    </xsl:when>
                    <xsl:otherwise>
                      <table class="infolist">
                        <tr>
                          <td class="top_spacer_small" colspan="2">
                          </td>
                        </tr>
                        <xsl:call-template name="ListDataEntries">
                          <xsl:with-param name="caller">custom</xsl:with-param>
                          <!-- MM : Begin - D033 - fix -->
                          <xsl:with-param name="puid" select="$guid"></xsl:with-param>
                          <!-- MM : End - D033 - fix -->
                        </xsl:call-template>
                        <tr>
                          <td class="bottom_spacer_small" colspan="2">
                          </td>
                        </tr>
                      </table>
                    </xsl:otherwise>
                  </xsl:choose>

                </div>
              </div>

            </div>
            <div class="container_bottom_right">
              <div class="container_bottom_left">
                <div class="container_bottom">
                </div>
              </div>
            </div>
          </div>
        </div>
        <br/>
      </xsl:when>
      <xsl:otherwise>
        <!--
        <xsl:if test="SubHeader">
          <xsl:apply-templates select="SubHeader">
            <xsl:with-param name="puid" select="$guid"/>
          </xsl:apply-templates>
        </xsl:if>
-->
        <div>        
        <xsl:choose>
          <xsl:when test="@extended='true'">
            <xsl:attribute name="class">list_container</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">table_container</xsl:attribute>
            </xsl:otherwise>
        </xsl:choose>
        
  <div class="table_gutter">
          <div class="container_top_right" id="system_title">
            <div class="container_top_left">
              <div class="container_gradient">
                <div class="container_title">
					<xsl:if test="SubHeader">
					  <xsl:apply-templates select="SubHeader">
						<xsl:with-param name="puid" select="$guid"/>
					  </xsl:apply-templates>
					</xsl:if>
				</div>
              </div>
            </div>
          </div>
          
          <!--
						When the parent node is a Section element, use 100% as the width of the table to provide
						proper alignment of  the columns of the summary report.
					-->
          <xsl:if test="name(..) = 'Section'">
            <xsl:attribute name="width">100%</xsl:attribute>
          </xsl:if>

          <div class="container_right" id="system_body">
            <div class="container_left">
              <div class="container_content">
                <table class="infolist">
                  <tr>
                    <td class="top_spacer_small" colspan="2">
                    </td>
                  </tr>
                    
                  <!-- MM : Begin - D033 - fix -->
                  <xsl:attribute name="id">
                    header_<xsl:value-of select="$guid"/>
                  </xsl:attribute>
                  <!-- MM : End - D033 - fix -->
                  <xsl:choose>
                    <xsl:when test="@display!=''">
                      <xsl:value-of select="@display"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="@name"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:call-template name="ListDataEntries">
                    <xsl:with-param name="caller">plain</xsl:with-param>
                    <!-- MM : Begin - D033 - fix -->
                    <xsl:with-param name="puid" select="$guid"></xsl:with-param>
                    <!-- MM : End - D033 - fix -->
                  </xsl:call-template>
                  <tr>
                    <td class="bottom_spacer_small" colspan="2">
                    </td>
                  </tr>
                </table>
              </div>
            </div>
          </div>
          
          <div class="container_bottom_right">
            <div class="container_bottom_left">
              <div class="container_bottom">
              </div>
            </div>
          </div>
        </div>
		</div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:otherwise>
</xsl:choose>
</xsl:template>
	<xsl:template name="ListDataEntries">
		<xsl:param name="caller"/>
		<!-- MM : Begin - D035 - fix for id issue -->
		<xsl:param name="puid" select="1"/>
		<xsl:variable name="table_id"><xsl:value-of select="$puid"/></xsl:variable>
		<!-- MM : End - D035 - fix for id issue -->
    
		<xsl:for-each select="Data">
			<!-- MM : Begin - D035 - fix for id issue -->
			<xsl:variable name="nameAttr" select="@name"/>
			<xsl:variable name="num">
				<xsl:choose>
					<xsl:when test="$nameAttr != ''"><xsl:value-of select="count(//ListData/Data[@name=$nameAttr])"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="col_id"><xsl:number count="node()" level="single"/></xsl:variable>
			<xsl:variable name="luid">
				<xsl:choose>
					<!-- if num is 0, it means the name attr is not present. In this case, generate the id -->
					<xsl:when test="$num = '0'">
						<xsl:value-of select="$table_id"/>_row<xsl:value-of select="$col_id"/>
					</xsl:when>
					<!-- if num is not 1, it means the name attr is repeated (duplicate), In this case, generate the id -->
					<xsl:when test="$num != '1'">
						<xsl:choose>
						<!-- if this returns true, then the attribute value is already present. In this case, generate the id -->
							<xsl:when test="$nameAttr=preceding::Data[ancestor::ListData]/@name">
								<xsl:value-of select="$table_id"/>_row<xsl:value-of select="$col_id"/>
							</xsl:when>
							<!-- if false, then this is the first instance of the attribute value. In this case, use the name as is for id-->
							<xsl:otherwise>
								<xsl:value-of select="@name"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- if num is 1, it means the name attr is not repeated. In this case, use the name as is for id.-->
					<xsl:when test="$num = '1'">
						<xsl:value-of select="@name"/>								
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<!-- MM : End - D035 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@ignoreonweb='true'"></xsl:when>
			<xsl:otherwise>
        <tr>

          <xsl:choose>
            <xsl:when test ="@Control_left ='true'">
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="$caller = 'plain'">
                <!--td style="width: 15px" class="left"/-->
              </xsl:if>
              <xsl:choose>
                <xsl:when test="$caller = 'custom'">
                  <xsl:choose>
                    <xsl:when test="(position() mod 2)=1">
                      <td>
                        <xsl:choose>
                          <xsl:when test="not(@type='hidden')">
                            <xsl:attribute name="class">item</xsl:attribute>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:attribute name="style">display:none</xsl:attribute>
                          </xsl:otherwise>
                        </xsl:choose>
                        <span>
                          <!-- MM : Begin - D035 - fix for id issue -->
                          <xsl:choose>
                            <xsl:when test="@id != ''">
                              <xsl:attribute name="id">
                                name_<xsl:value-of select="@id"/>
                              </xsl:attribute>
                            </xsl:when>
                            <!--xsl:when test="@name != ''">
												<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
											</xsl:when-->
                            <xsl:otherwise>
                              <xsl:attribute name="id">
                                name_<xsl:value-of select="$luid"/>
                              </xsl:attribute>
                            </xsl:otherwise>
                          </xsl:choose>
                          <!-- MM : End - D035 - fix for id issue -->
                          <xsl:value-of select="@display"/>
                        </span>
                      </td>
                    </xsl:when>
                    <xsl:otherwise>
                      <!--C88676 fix smallfont font size -->
                      <td>
                        <xsl:choose>
                          <xsl:when test="not(@type='hidden')">
                            <xsl:attribute name="class">item</xsl:attribute>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:attribute name="style">display:none</xsl:attribute>
                          </xsl:otherwise>
                        </xsl:choose>
                        <span>
                          <!-- MM : Begin - D035 - fix for id issue -->
                          <xsl:choose>
                            <xsl:when test="@id != ''">
                              <xsl:attribute name="id">
                                name_<xsl:value-of select="@id"/>
                              </xsl:attribute>
                            </xsl:when>
                            <!--xsl:when test="@name != ''">
												<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
											</xsl:when-->
                            <xsl:otherwise>
                              <xsl:attribute name="id">
                                name_<xsl:value-of select="$luid"/>
                              </xsl:attribute>
                            </xsl:otherwise>
                          </xsl:choose>
                          <!-- MM : End - D035 - fix for id issue -->
                          <xsl:value-of select="@display"/>
                        </span>
                      </td>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                  <td>
                    <xsl:choose>
                      <xsl:when test="not(@type='hidden')">
                        <xsl:attribute name="class">item</xsl:attribute>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:attribute name="style">display:none</xsl:attribute>
                      </xsl:otherwise>
                    </xsl:choose>
                    <!--
									When the parent of the parent is a Section element, use 50% as the width of the
									element to align the columns of the summary report.
								-->

                    <xsl:if test="name(../..) = 'Section'">
                      <xsl:attribute name="style">width: 50%</xsl:attribute>
                    </xsl:if>
                    <!-- MM : Begin - D035 - fix for id issue -->
                    <span>
                      <xsl:choose>
                        <xsl:when test="@id != ''">
                          <xsl:attribute name="id">
                            name_<xsl:value-of select="@id"/>
                          </xsl:attribute>
                        </xsl:when>
                        <!--xsl:when test="@name != ''">
										<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
									</xsl:when-->
                        <xsl:otherwise>
                          <xsl:attribute name="id">
                            name_<xsl:value-of select="$luid"/>
                          </xsl:attribute>
                        </xsl:otherwise>
                      </xsl:choose>
                      <!-- MM : End - D035 - fix for id issue -->
                      <xsl:value-of select="@display"/>
                    </span>
                  </td>

                </xsl:otherwise>
              </xsl:choose>
              <xsl:if test="$caller = 'plain'">
              </xsl:if>


            </xsl:otherwise>
          </xsl:choose>


          <xsl:choose>
							<xsl:when test="@splcase = 'true'">
							  <td>
								  <xsl:choose>
									  <xsl:when test="not(@type='hidden')">
										<xsl:attribute name="nowrap">nowrap</xsl:attribute>
									  </xsl:when>
									  <xsl:otherwise>
										<xsl:attribute name="style">display:none</xsl:attribute>
									  </xsl:otherwise>
								  </xsl:choose>								
									<xsl:call-template name="datatype">
										<!-- MM : Begin - D035- fix for id issue -->
										<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
										<xsl:with-param name="ignoreName">true</xsl:with-param>
										<!-- MM : End - D035 - fix for id issue -->
										<xsl:with-param name="display">
											<xsl:value-of select="@display"/>
										</xsl:with-param>
										<xsl:with-param name="type">
											<xsl:value-of select="@type"/>
										</xsl:with-param>
										<xsl:with-param name="name">
											<xsl:value-of select="@name"/>
										</xsl:with-param>
										<xsl:with-param name="id">
										<!-- MM : Begin - D035 - fix for id issue -->
											<xsl:value-of select="@id"/>
											<!-- xsl:value-of select="@name"/ -->
										<!-- MM : End - D035 - fix for id issue -->
										</xsl:with-param>
										<xsl:with-param name="value">
											<xsl:value-of select="@value"/>
										</xsl:with-param>
										<xsl:with-param name="returnvalue">
											<xsl:value-of select="@returnvalue"/>
										</xsl:with-param>
										<xsl:with-param name="state">
											<xsl:value-of select="@state"/>
										</xsl:with-param>
										<xsl:with-param name="size">
											<xsl:value-of select="@size"/>
										</xsl:with-param>
										<xsl:with-param name="uparrscript">
											<xsl:value-of select="@uparrscript"/>
										</xsl:with-param>
										<xsl:with-param name="downarrscript">
											<xsl:value-of select="@downarrscript"/>
										</xsl:with-param>
										<xsl:with-param name="sep">
											<xsl:value-of select="@sep"/>
										</xsl:with-param>
										<xsl:with-param name="value1">
											<xsl:value-of select="@value1"/>
										</xsl:with-param>
										<xsl:with-param name="value2">
											<xsl:value-of select="@value2"/>
										</xsl:with-param>
										<xsl:with-param name="value3">
											<xsl:value-of select="@value3"/>
										</xsl:with-param>
										<xsl:with-param name="value4">
											<xsl:value-of select="@value4"/>
										</xsl:with-param>
										<xsl:with-param name="event">
											<xsl:value-of select="@event"/>
										</xsl:with-param>
										<xsl:with-param name="handler">
											<xsl:value-of select="@handler"/>
										</xsl:with-param>
										<!--C91707 Ability to set selection box width-->
										<xsl:with-param name="width">
											<xsl:value-of select="@boxwidth"/>
										</xsl:with-param>
									</xsl:call-template>
								
								<!-- This is a special case, right now used for probe object settings only -->
								<xsl:for-each select="ExtraItem">
									<xsl:choose>
										<xsl:when test="@link='true'">
										<xsl:if test="$caller = 'custom'">
												<xsl:attribute name="class">contents borderright borderbottom</xsl:attribute>
											</xsl:if>
   												<!--xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute-->
												<xsl:element name="a">
													<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
													<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
													<xsl:call-template name="datatype">
														<!-- MM : Begin - D035 - fix for id issue -->
														<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
														<xsl:with-param name="ignoreName">true</xsl:with-param>
														<!-- MM : End - D035 - fix for id issue -->
														<xsl:with-param name="display">
															<xsl:value-of select="@display"/>
														</xsl:with-param>
														<xsl:with-param name="type">
															<xsl:value-of select="@type"/>
														</xsl:with-param>
														<xsl:with-param name="name">
															<xsl:value-of select="@name"/>
														</xsl:with-param>
														<xsl:with-param name="id">
															<!-- MM : Begin - D035 - fix for id issue -->
															<xsl:value-of select="@id"/>
															<!-- xsl:value-of select="@name"/ -->
															<!-- MM : End - D035 - fix for id issue -->
														</xsl:with-param>
														<xsl:with-param name="value">
															<xsl:value-of select="@value"/>
														</xsl:with-param>
														<xsl:with-param name="returnvalue">
															<xsl:value-of select="@returnvalue"/>
														</xsl:with-param>
														<xsl:with-param name="state">
															<xsl:value-of select="@state"/>
														</xsl:with-param>
														<xsl:with-param name="extraitem">true</xsl:with-param>
													</xsl:call-template>
												</xsl:element>							
										</xsl:when>
										<xsl:otherwise>										    						
											<!--87536 end -->
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D035 - fix for id issue -->
													<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D035 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D035 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D035 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="size">
														<xsl:value-of select="@size"/>
													</xsl:with-param>
													<xsl:with-param name="uparrscript">
														<xsl:value-of select="@uparrscript"/>
													</xsl:with-param>
													<xsl:with-param name="downarrscript">
														<xsl:value-of select="@downarrscript"/>
													</xsl:with-param>
													<xsl:with-param name="sep">
														<xsl:value-of select="@sep"/>
													</xsl:with-param>
													<xsl:with-param name="value1">
														<xsl:value-of select="@value1"/>
													</xsl:with-param>
													<xsl:with-param name="value2">
														<xsl:value-of select="@value2"/>
													</xsl:with-param>
													<xsl:with-param name="value3">
														<xsl:value-of select="@value3"/>
													</xsl:with-param>
													<xsl:with-param name="value4">
														<xsl:value-of select="@value4"/>
													</xsl:with-param>
													<xsl:with-param name="event">
														<xsl:value-of select="@event"/>
													</xsl:with-param>
													<xsl:with-param name="handler">
														<xsl:value-of select="@handler"/>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
													<xsl:with-param name="extraitem">true</xsl:with-param>
												</xsl:call-template>
												<xsl:value-of select="@unit"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>                  
              </td>
                  </xsl:when>
							<xsl:when test="@link='true'">

								<td>
									<xsl:if test="@type='hidden'">		
										<xsl:attribute name="style">display:none</xsl:attribute>
									</xsl:if>
									<xsl:if test="$caller = 'custom'">
										<!--xsl:attribute name="class">contents borderright borderbottom</xsl:attribute-->
                    
									</xsl:if>
                 
									<xsl:element name="a">
										<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
										<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
										<xsl:call-template name="datatype">
											<!-- MM : Begin - D035 - fix for id issue -->
											<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
											<xsl:with-param name="ignoreName">true</xsl:with-param>
											<!-- MM : End - D035 - fix for id issue -->
											<xsl:with-param name="display">
												<xsl:value-of select="@display"/>
											</xsl:with-param>
											<xsl:with-param name="type">
												<xsl:value-of select="@type"/>
											</xsl:with-param>
											<xsl:with-param name="name">
												<xsl:value-of select="@name"/>
											</xsl:with-param>
											<xsl:with-param name="id">
												<!-- MM : Begin - D035 - fix for id issue -->
												<xsl:value-of select="@id"/>
												<!-- xsl:value-of select="@name"/ -->
												<!-- MM : End - D035 - fix for id issue -->
											</xsl:with-param>
											<xsl:with-param name="value">
												<xsl:value-of select="@value"/>
											</xsl:with-param>
											<xsl:with-param name="returnvalue">
												<xsl:value-of select="@returnvalue"/>
											</xsl:with-param>
											<xsl:with-param name="state">
												<xsl:value-of select="@state"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:element>
								</td>

              </xsl:when>
							<xsl:otherwise>
                
								<td >
								<xsl:if test="@type='hidden'">
									<xsl:attribute name="style">display:none</xsl:attribute>
								</xsl:if>	
									<xsl:if test="$caller = 'custom'">
										<!---xsl:attribute name="class">contents borderright borderbottom</xsl:attribute-->
									</xsl:if>
                 
                    <xsl:attribute name="align">
                      <xsl:value-of select="@align"/>
                    </xsl:attribute>
                    <xsl:call-template name="datatype">
                      <!-- MM : Begin - D035 - fix for id issue -->
                      <xsl:with-param name="uid">
                        <xsl:value-of select="$luid"/>
                      </xsl:with-param>
                      <xsl:with-param name="ignoreName">true</xsl:with-param>
                      <!-- MM : End - D035 - fix for id issue -->
                      <xsl:with-param name="display">
                        <xsl:value-of select="@display"/>
                      </xsl:with-param>
                      <xsl:with-param name="type">
                        <xsl:value-of select="@type"/>
                      </xsl:with-param>
                      <xsl:with-param name="name">
                        <xsl:value-of select="@name"/>
                      </xsl:with-param>
                      <xsl:with-param name="id">
                        <!-- MM : Begin - D035 - fix for id issue -->
                        <xsl:value-of select="@id"/>
                        <!-- xsl:value-of select="@name"/ -->
                        <!-- MM : End - D035 - fix for id issue -->
                      </xsl:with-param>
                      <xsl:with-param name="value">
                        <xsl:value-of select="@value"/>
                      </xsl:with-param>
                      <xsl:with-param name="returnvalue">
                        <xsl:value-of select="@returnvalue"/>
                      </xsl:with-param>
                      <xsl:with-param name="state">
                        <xsl:value-of select="@state"/>
                      </xsl:with-param>
                      <xsl:with-param name="size">
                        <xsl:value-of select="@size"/>
                      </xsl:with-param>
                      <xsl:with-param name="uparrscript">
                        <xsl:value-of select="@uparrscript"/>
                      </xsl:with-param>
                      <xsl:with-param name="downarrscript">
                        <xsl:value-of select="@downarrscript"/>
                      </xsl:with-param>
                      <xsl:with-param name="sep">
                        <xsl:value-of select="@sep"/>
                      </xsl:with-param>
                      <xsl:with-param name="value1">
                        <xsl:value-of select="@value1"/>
                      </xsl:with-param>
                      <xsl:with-param name="value2">
                        <xsl:value-of select="@value2"/>
                      </xsl:with-param>
                      <xsl:with-param name="value3">
                        <xsl:value-of select="@value3"/>
                      </xsl:with-param>
                      <xsl:with-param name="value4">
                        <xsl:value-of select="@value4"/>
                      </xsl:with-param>
                      <xsl:with-param name="event">
                        <xsl:value-of select="@event"/>
                      </xsl:with-param>
                      <xsl:with-param name="handler">
                        <xsl:value-of select="@handler"/>
                      </xsl:with-param>
                      <!--C91707 Ability to set selection box width-->
                      <xsl:with-param name="width">
                        <xsl:value-of select="@boxwidth"/>
                      </xsl:with-param>
                    </xsl:call-template>
                    <xsl:if test="ValueList">
                      <xsl:for-each select="ValueList/value">
                        <xsl:value-of select="."/>
                        <xsl:if test="position() != last()">
                          <br/>
                        </xsl:if>
                      </xsl:for-each>
                    </xsl:if>
                    <xsl:value-of select="@unit"/>
                  <xsl:if test ="@Control_left='true'">
                    <xsl:if test="$caller = 'plain'">
                      <!--td style="width: 15px" class="left"/-->
                    </xsl:if>
                    <xsl:choose>
                      <xsl:when test="$caller = 'custom'">
                        <xsl:choose>
                          <xsl:when test="(position() mod 2)=1">
                            <td>
                              <xsl:choose>
                                <xsl:when test="not(@type='hidden')">
                                  <xsl:attribute name="class">item</xsl:attribute>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:attribute name="style">display:none</xsl:attribute>
                                </xsl:otherwise>
                              </xsl:choose>
                              <span>
                                <!-- MM : Begin - D035 - fix for id issue -->
                                <xsl:choose>
                                  <xsl:when test="@id != ''">
                                    <xsl:attribute name="id">
                                      name_<xsl:value-of select="@id"/>
                                    </xsl:attribute>
                                  </xsl:when>
                                  <!--xsl:when test="@name != ''">
												<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
											</xsl:when-->
                                  <xsl:otherwise>
                                    <xsl:attribute name="id">
                                      name_<xsl:value-of select="$luid"/>
                                    </xsl:attribute>
                                  </xsl:otherwise>
                                </xsl:choose>
                                <!-- MM : End - D035 - fix for id issue -->
                                <xsl:value-of select="@display"/>
                              </span>
                            </td>
                          </xsl:when>
                          <xsl:otherwise>
                            <!--C88676 fix smallfont font size -->
                            <td>
                              <xsl:choose>
                                <xsl:when test="not(@type='hidden')">
                                  <xsl:attribute name="class">item</xsl:attribute>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:attribute name="style">display:none</xsl:attribute>
                                </xsl:otherwise>
                              </xsl:choose>
                              <span>
                                <!-- MM : Begin - D035 - fix for id issue -->
                                <xsl:choose>
                                  <xsl:when test="@id != ''">
                                    <xsl:attribute name="id">
                                      name_<xsl:value-of select="@id"/>
                                    </xsl:attribute>
                                  </xsl:when>
                                  <!--xsl:when test="@name != ''">
												<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
											</xsl:when-->
                                  <xsl:otherwise>
                                    <xsl:attribute name="id">
                                      name_<xsl:value-of select="$luid"/>
                                    </xsl:attribute>
                                  </xsl:otherwise>
                                </xsl:choose>
                                <!-- MM : End - D035 - fix for id issue -->
                                <xsl:value-of select="@display"/>
                              </span>
                            </td>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <td>
                          <xsl:choose>
                            <xsl:when test="not(@type='hidden')">
                              <xsl:attribute name="class">item</xsl:attribute>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:attribute name="style">display:none</xsl:attribute>
                            </xsl:otherwise>
                          </xsl:choose>
                          <!--
									When the parent of the parent is a Section element, use 50% as the width of the
									element to align the columns of the summary report.
								-->

                          <xsl:if test="name(../..) = 'Section'">
                            <xsl:attribute name="style">width: 50%</xsl:attribute>
                          </xsl:if>
                          <!-- MM : Begin - D035 - fix for id issue -->
                          <span>
                            <xsl:choose>
                              <xsl:when test="@id != ''">
                                <xsl:attribute name="id">
                                  name_<xsl:value-of select="@id"/>
                                </xsl:attribute>
                              </xsl:when>
                              <!--xsl:when test="@name != ''">
										<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
									</xsl:when-->
                              <xsl:otherwise>
                                <xsl:attribute name="id">
                                  name_<xsl:value-of select="$luid"/>
                                </xsl:attribute>
                              </xsl:otherwise>
                            </xsl:choose>
                            <!-- MM : End - D035 - fix for id issue -->
                            <xsl:value-of select="@display"/>
                          </span>
                        </td>

                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="$caller = 'plain'">
                    </xsl:if>
                  </xsl:if>

                </td>
                
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="$caller = 'custom'">
							<!--td class="right"/-->
						</xsl:if>
						<xsl:if test="$caller = 'plain'">
							<!--td style="width: 15px" class="right"/-->
						</xsl:if>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="TableData">
		<!-- MM :Begin - D030- fix for id issue -->
		<xsl:variable name="guid">
			<xsl:choose>
				<xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="width">
			<xsl:choose>
				<xsl:when test="@width != ''"><xsl:value-of select="@width"/></xsl:when>
				<xsl:otherwise>100%</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- MM : This value will be used to generate id for back to top -->
		<xsl:variable name="backToTopId" select="$guid"/>
		<!-- MM :End - D030 - fix for id issue -->

		<!-- fix for logs taking longer time to display - this is because of xsl functions (count, preceding) used in Row -->
		<!-- template to check for duplicate values, take longer time to complete. -->
		<!-- pass attribute to enable/disable unique ID generation. nouniqueids is an optional attribute. defaults to false -->
		<xsl:variable name="noUniqIDs">
			<xsl:choose>
				<xsl:when test="@nouniqueids ='true' ">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
    <xsl:choose>
      <xsl:when test="@ignoreJumpBar"></xsl:when>
	  <xsl:when test="@name">
		  <script language="javascript">
				  addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', "<xsl:value-of select='@display'/>");
				  incTableCount();
				</script>
					<xsl:apply-templates select="script"/>	
			<a>
			  <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			  <xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
			 </a>	  
	  </xsl:when>
      <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="SubHeader">
				<script language="javascript">
				  addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="$guid" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', "<xsl:value-of select='./SubHeader/@display'/>");
				  incTableCount();
				</script>
            </xsl:when>
            <xsl:when test="Header">
				<script language="javascript">
				  addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="$guid" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', "<xsl:value-of select='./Header/Data/@display'/>");
				  incTableCount();
				</script>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
          </xsl:choose>
			<xsl:apply-templates select="script"/>	  
	<a>
	  <xsl:attribute name="name"><xsl:value-of select="$guid"/></xsl:attribute>
	  <xsl:attribute name="id"><xsl:value-of select="$guid"/></xsl:attribute>
	 </a>
			        
      </xsl:otherwise>
    </xsl:choose>		

		<xsl:apply-templates select="script"/>
		<div class="table_container">	
	
			<xsl:apply-templates select="SubHeader">
				<!-- MM :Begin - D030- fix for id issue -->
				<xsl:with-param name="puid" select="$guid"/>
					<xsl:with-param name="tablesubheader" select="'true'" />
				<!-- MM :End - D030- fix for id issue -->
			</xsl:apply-templates>
		<xsl:choose>
			<xsl:when test="/OMA/DataArea/@ignoreJumpBar"></xsl:when>
			<xsl:otherwise>
				<xsl:if test="(count( /OMA/DataArea/TableData ) &gt; 0) or (count( /OMA/DataArea/ListData ) &gt; 0) or (count( /OMA/DataArea/ComboData ) &gt; 0)">
				<xsl:if test="((/OMA/DataArea/ListData) or (/OMA/DataArea/ComboData) or (not(/OMA/DataArea/ListData) and (position() &gt; 1)))">
					  <div class="backtotop">
						<a href="#top">
										<!-- MM :Begin - D041 - fix for id issue -->
										<!-- Add 'id' and 'name' attribute -->
										<xsl:attribute name="id">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
										<xsl:attribute name="name">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
										<!-- MM :End - D041 - fix for id issue -->
										<xsl:value-of select="$strBackToTop"/>
									</a>
					</div>
				</xsl:if>	
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
      <div class="table_gutter">
        <table width="100%" cellpadding="0" cellspacing="0" border="0" class="container autolayout">
          <xsl:choose>
            <xsl:when test="@columnspacing='true'">
			<thead>
			<xsl:choose>
			<xsl:when test="@sortable">
              <xsl:apply-templates select="Header">
                <xsl:with-param name="columnspacing">true</xsl:with-param>
                <!-- MM : Begin - D030 - fix  for id issue -->
                <xsl:with-param name="puid" select="$guid"></xsl:with-param>
                <!-- MM : End - D030 - fix for id issue -->
				<xsl:with-param name="sortable" select="'true'"></xsl:with-param>
              </xsl:apply-templates>
			</xsl:when>
			<xsl:when test="@expandable">
			  <xsl:apply-templates select="Header">
                <xsl:with-param name="columnspacing">true</xsl:with-param>			  
				<!-- MM : Begin - D030 - fix  for id issue -->
				<xsl:with-param name="puid" select="$guid"></xsl:with-param>
				<!-- MM : End - D030 - fix for id issue -->
				<xsl:with-param name="expandable" select="@expandable" ></xsl:with-param>
				<xsl:with-param name="staticcols" select="@staticcols" ></xsl:with-param>
				<xsl:with-param name="expandableheader" select="@expandableheader" ></xsl:with-param>
			  </xsl:apply-templates>
			</xsl:when>					
			<xsl:otherwise>
              <xsl:apply-templates select="Header">
                <xsl:with-param name="columnspacing">true</xsl:with-param>
                <!-- MM : Begin - D030 - fix  for id issue -->
                <xsl:with-param name="puid" select="$guid"></xsl:with-param>
                <!-- MM : End - D030 - fix for id issue -->
              </xsl:apply-templates>
			</xsl:otherwise>
			</xsl:choose>	
			</thead>
              <xsl:choose>
                <xsl:when test="not(Header)">
                  <tr>
                    <td class="topleft" valign="middle" align="left">
                      <td class="top">
					  <xsl:attribute name="colspan">
						<xsl:variable name="rowcount" select="count(./Row)"></xsl:variable>
						<xsl:choose>
							<xsl:when test="$rowcount &gt; 1">
								<xsl:value-of select="count( ./Row[number($rowcount)]/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="count( ./Row/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' )) ] )"/>
							</xsl:otherwise>
						</xsl:choose>		
					   </xsl:attribute>
                      </td>
                      <td class="topright" rowspan="1" align="right"></td>
                    </td>
                  </tr>
                </xsl:when>
              </xsl:choose>
              <xsl:variable name="headercount" select="count(./Header)"></xsl:variable>
			  <xsl:if test="./PromptText">
				<tr>
					<td class="left"> </td>
					<td class="instructions">
					  <xsl:attribute name="colspan">
					    <xsl:variable name="headercount" select="count(./Header)"></xsl:variable>
						<xsl:choose>
						<xsl:when test="$headercount &gt; 1">
							<xsl:value-of select="count( ./Header[number($headercount)]/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
						</xsl:when>
					  <xsl:when test="not(Header)">
						<xsl:variable name="rowcount" select="count(./Row)"></xsl:variable>
						<xsl:choose>
							<xsl:when test="$rowcount &gt; 1">
								<xsl:value-of select="count( ./Row[number($rowcount)]/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="count( ./Row/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' )) ] )"/>
							</xsl:otherwise>
						</xsl:choose>		
					  </xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="count( ./Header/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
						</xsl:otherwise>
						</xsl:choose>
					  </xsl:attribute>
						<xsl:apply-templates select="./PromptText">
							<xsl:with-param name="puid" select="$guid"/>
							<xsl:with-param name="caller">inline</xsl:with-param>
						</xsl:apply-templates>
					</td>
					<td class="right">  </td>
				  </tr>

				</xsl:if>
			<tbody>
			<xsl:choose>
			<xsl:when test="@expandable">
				<xsl:apply-templates select="Row">
					<xsl:with-param name="columnspacing">true</xsl:with-param>
					<!-- MM : Begin - D030 - fix for id issue -->
					<xsl:with-param name="puid" select="$guid"></xsl:with-param>
					<!-- MM : End - D030 - fix  for id issue-->
					<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
					<xsl:with-param name="expandable" select="@expandable" ></xsl:with-param>
					<xsl:with-param name="staticcols" select="@staticcols" ></xsl:with-param>
					<xsl:with-param name="expandableheader" select="@expandableheader" ></xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="@nopadding">
				<xsl:apply-templates select="Row">
					<xsl:with-param name="columnspacing">true</xsl:with-param>
					<!-- MM : Begin - D030 - fix for id issue -->
					<xsl:with-param name="puid" select="$guid"></xsl:with-param>
					<!-- MM : End - D030 - fix  for id issue-->
					<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
					<xsl:with-param name="nopadding" select="@nopadding" ></xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="Row">
					<xsl:with-param name="columnspacing">true</xsl:with-param>
					<!-- MM : Begin - D030 - fix for id issue -->
					<xsl:with-param name="puid" select="$guid"></xsl:with-param>
					<!-- MM : End - D030 - fix  for id issue-->
					<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
				</xsl:apply-templates>
			</xsl:otherwise>
			</xsl:choose>	
			</tbody>	
			</xsl:when>
			<xsl:otherwise>
				<thead>
					<xsl:choose>
					<xsl:when test="@sortable">
					  <xsl:apply-templates select="Header">
						<!-- MM : Begin - D030 - fix  for id issue -->
						<xsl:with-param name="puid" select="$guid"></xsl:with-param>
						<!-- MM : End - D030 - fix for id issue -->
						<xsl:with-param name="sortable" select="'true'"></xsl:with-param>
					  </xsl:apply-templates>
					</xsl:when>
					<xsl:when test="@expandable">
					  <xsl:apply-templates select="Header">
						<!-- MM : Begin - D030 - fix  for id issue -->
						<xsl:with-param name="puid" select="$guid"></xsl:with-param>
						<!-- MM : End - D030 - fix for id issue -->
						<xsl:with-param name="expandable" select="@expandable" ></xsl:with-param>
						<xsl:with-param name="staticcols" select="@staticcols" ></xsl:with-param>
						<xsl:with-param name="expandableheader" select="@expandableheader" ></xsl:with-param>
					  </xsl:apply-templates>
					</xsl:when>					
					<xsl:otherwise>
					  <xsl:apply-templates select="Header">
						<!-- MM : Begin - D030 - fix  for id issue -->
						<xsl:with-param name="puid" select="$guid"></xsl:with-param>
						<!-- MM : End - D030 - fix for id issue -->
					  </xsl:apply-templates>
					</xsl:otherwise>
					</xsl:choose>	
				</thead>
                  <xsl:choose>
                    <xsl:when test="not(Header)">
                      <tr>
                        <td class="topleft" valign="middle" align="left">
                          <td class="top">
							  <xsl:attribute name="colspan">
								<xsl:variable name="rowcount" select="count(./Row)"></xsl:variable>
								<xsl:choose>
									<xsl:when test="$rowcount &gt; 1">
										<xsl:value-of select="count( ./Row[number($rowcount)]/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="count( ./Row/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' )) ] )"/>
									</xsl:otherwise>
								</xsl:choose>		
							   </xsl:attribute>
                          </td>
                          <td class="topright" rowspan="1" align="right"></td>
                        </td>
                      </tr>
                    </xsl:when>
                  </xsl:choose>
									<xsl:if test="./PromptText">
									  
										  <xsl:attribute name="colspan">
										    <xsl:variable name="headercount" select="count(./Header)"></xsl:variable>
											<xsl:choose>
											<xsl:when test="$headercount &gt; 1">
												<xsl:value-of select="count( ./Header[number($headercount)]/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
											</xsl:when>
										  <xsl:when test="not(Header)">
											<xsl:variable name="rowcount" select="count(./Row)"></xsl:variable>
											<xsl:choose>
												<xsl:when test="$rowcount &gt; 1">
													<xsl:value-of select="count( ./Row[number($rowcount)]/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="count( ./Row/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' )) ] )"/>
												</xsl:otherwise>
											</xsl:choose>		
										  </xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="count( ./Header/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
											</xsl:otherwise>
											</xsl:choose>
										  </xsl:attribute>
											<xsl:apply-templates select="./PromptText">
												<xsl:with-param name="puid" select="$guid"/>
												<xsl:with-param name="caller">inline</xsl:with-param>
											</xsl:apply-templates>
									
									</xsl:if>				  
									  
				  		<tbody>
							<xsl:choose>
							<xsl:when test="@expandable">
								<xsl:apply-templates select="Row">
									<!-- MM : Begin - D030 - fix for id issue -->
									<xsl:with-param name="puid" select="$guid"></xsl:with-param>
									<!-- MM : End - D030 - fix  for id issue-->
									<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
									<xsl:with-param name="expandable" select="@expandable" ></xsl:with-param>
									<xsl:with-param name="staticcols" select="@staticcols" ></xsl:with-param>
									<xsl:with-param name="expandableheader" select="@expandableheader" ></xsl:with-param>
								</xsl:apply-templates>
							</xsl:when>
							<xsl:when test="@nopadding">
								<xsl:apply-templates select="Row">
									<!-- MM : Begin - D030 - fix for id issue -->
									<xsl:with-param name="puid" select="$guid"></xsl:with-param>
									<!-- MM : End - D030 - fix  for id issue-->
									<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
									<xsl:with-param name="nopadding" select="@nopadding" ></xsl:with-param>
								</xsl:apply-templates>
							</xsl:when>							
							<xsl:otherwise>
								<xsl:apply-templates select="Row">
									<!-- MM : Begin - D030 - fix for id issue -->
									<xsl:with-param name="puid" select="$guid"></xsl:with-param>
									<!-- MM : End - D030 - fix  for id issue-->
									<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
								</xsl:apply-templates>
							</xsl:otherwise>
							</xsl:choose>	
						</tbody>			
						</xsl:otherwise>
					</xsl:choose>
				<tfoot> 
					<tr> 
						<td class="bottomleft"> </td> 
						<td class="bottom">
						  <xsl:attribute name="colspan">
						    <xsl:variable name="headercount" select="count(./Header)"></xsl:variable>
							<xsl:choose>
							<xsl:when test="@expandable ='true'"><xsl:value-of select="@staticcols"/></xsl:when>
							<xsl:when test="$headercount &gt; 1">
								<xsl:value-of select="count( ./Header[number($headercount)]/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
							</xsl:when>
						  <xsl:when test="not(Header)">
							<xsl:variable name="rowcount" select="count(./Row)"></xsl:variable>
							<xsl:choose>
								<xsl:when test="$rowcount &gt; 1">
									<xsl:value-of select="count( ./Row[number($rowcount)]/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="count( ./Row/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' )) ] )"/>
								</xsl:otherwise>
							</xsl:choose>		
						  </xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="count( ./Header/Data[ (not( @ignoreonweb = 'true' )) and  (not( @type = 'hidden' ))] )"/>
							</xsl:otherwise>
							</xsl:choose>
						  </xsl:attribute>
						</td> 
						<td class="bottomright"> </td> 
					</tr> 
				</tfoot>			
				</table>
			</div>
	</div>	
	</xsl:template>


	<xsl:template match="ListTableData">
		<!-- MM :Begin - D030- fix for id issue -->
		<xsl:variable name="guid">
			<xsl:choose>
				<xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : This value will be used to generate id for back to top -->
		<xsl:variable name="backToTopId" select="$guid"/>
		<!-- MM :End - D030 - fix for id issue -->

		<!-- fix for logs taking longer time to display - this is because of xsl functions (count, preceding) used in Row -->
		<!-- template to check for duplicate values, take longer time to complete. -->
		<!-- pass attribute to enable/disable unique ID generation. nouniqueids is an optional attribute. defaults to false -->
		<xsl:variable name="noUniqIDs">
			<xsl:choose>
				<xsl:when test="@nouniqueids ='true' ">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="@ignoreJumpBar"></xsl:when>
			<xsl:otherwise>
				<script language="javascript">
					addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>',"<xsl:value-of select='@display'/>");
					incTableCount();
				</script>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="script"/>
		<a>
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
		</a>	
			<xsl:apply-templates select="PromptText">
				<!-- MM :Begin - D030- fix for id issue -->
				<xsl:with-param name="puid" select="$guid"/>
				<!-- MM :End - D030- fix for id issue -->
			</xsl:apply-templates>
      <xsl:apply-templates select="AlertMessage">
        <!-- MM :Begin - D030- fix for id issue -->
        <xsl:with-param name="puid" select="$guid"/>
        <!-- MM :End - D030- fix for id issue -->
      </xsl:apply-templates>
			<div class="table_container">
		<xsl:choose>
			<xsl:when test="/OMA/DataArea/@ignoreJumpBar"></xsl:when>
			<xsl:otherwise>
				<xsl:if test="(count( /OMA/DataArea/ListTableData ) &gt; 1) and (position() &gt; 1)">
			    <div class="backtotop backtotop_list_table">
                  <a href="#top">
						<!-- MM :Begin - D041 - fix for id issue -->
						<!-- Add 'id' and 'name' attribute -->
						<xsl:attribute name="id">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
						<xsl:attribute name="name">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
						<!-- MM :End - D041 - fix for id issue -->
						<xsl:value-of select="$strBackToTop"/>
					</a>
				</div>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>

  <xsl:apply-templates select="SubHeader">
    <!-- MM :Begin - D030- fix for id issue -->
    <xsl:with-param name="puid" select="$guid"/>
    <xsl:with-param name="tablesubheader" select="'true'" />
    <!-- MM :End - D030- fix for id issue -->
  </xsl:apply-templates>
	

			<div class="table_gutter"> 
			
				<table class="container" onclick="SelectRow(event)" border="0" cellspacing="0" cellpadding="0" width="100%">
					<thead>
									<xsl:choose>
										<xsl:when test="@columnspacing='true'">
											<xsl:apply-templates select="Header">
												<xsl:with-param name="columnspacing">true</xsl:with-param>
												<!-- MM : Begin - D030 - fix  for id issue -->
												<xsl:with-param name="puid" select="$guid"></xsl:with-param>
												<!-- MM : End - D030 - fix for id issue -->
												<xsl:with-param name="ListTableDataHeader">true</xsl:with-param>
											</xsl:apply-templates>
											</xsl:when>
										<xsl:otherwise>
											<xsl:apply-templates select="Header">
												<!-- MM : Begin - D030 - fix for id issue -->
												<xsl:with-param name="puid" select="$guid"></xsl:with-param>
												<!-- MM : End - D030 - fix for id issue -->
												<xsl:with-param name="ListTableDataHeader">true</xsl:with-param>
											</xsl:apply-templates>
										</xsl:otherwise>
									</xsl:choose>	
					</thead>					
					<tbody>
									<xsl:choose>
										<xsl:when test="@columnspacing='true'">
									  <xsl:choose>
										<xsl:when test="count(./Row) &gt; 1">
											<xsl:apply-templates select="Row">
												<xsl:with-param name="columnspacing">true</xsl:with-param>
												<!-- MM : Begin - D030 - fix for id issue -->
												<xsl:with-param name="puid" select="$guid"></xsl:with-param>
												<!-- MM : End - D030 - fix  for id issue-->
												<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
												<xsl:with-param name="ListTableDataRow">true</xsl:with-param>
												<xsl:with-param name="evencolour">true</xsl:with-param>
											</xsl:apply-templates>
										</xsl:when>
										<xsl:otherwise>
											<xsl:apply-templates select="Row">
												<xsl:with-param name="columnspacing">true</xsl:with-param>
												<!-- MM : Begin - D030 - fix for id issue -->
												<xsl:with-param name="puid" select="$guid"></xsl:with-param>
												<!-- MM : End - D030 - fix  for id issue-->
												<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
												<xsl:with-param name="ListTableDataRow">false</xsl:with-param>
												<xsl:with-param name="evencolour">true</xsl:with-param>
											</xsl:apply-templates>
										</xsl:otherwise>	
										</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
									  <xsl:choose>
										<xsl:when test="count(./Row) &gt; 1">
											<xsl:apply-templates select="Row">
												<!-- MM : Begin - D030 - fix for id issue -->
												<xsl:with-param name="puid" select="$guid"></xsl:with-param>
												<!-- MM : End - D030 - fix  for id issue-->
												<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
												<xsl:with-param name="ListTableDataRow">true</xsl:with-param>
												<xsl:with-param name="evencolour">true</xsl:with-param>
											</xsl:apply-templates>
										</xsl:when>
										<xsl:otherwise>
											<xsl:apply-templates select="Row">
												<!-- MM : Begin - D030 - fix for id issue -->
												<xsl:with-param name="puid" select="$guid"></xsl:with-param>
												<!-- MM : End - D030 - fix  for id issue-->
												<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
												<xsl:with-param name="ListTableDataRow">false</xsl:with-param>
												<xsl:with-param name="evencolour">true</xsl:with-param>
											</xsl:apply-templates>
										</xsl:otherwise>	
										</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
						</tbody>
						
						<tfoot>
							<tr>
							  <td class="bottomleft"> </td>
							  <td class="bottom">
								<xsl:attribute name="colspan">
								  <xsl:value-of select="count(./Header/Data)"/>
								</xsl:attribute>
							  </td>
							  <td class="bottomright"> </td>
							</tr>
						</tfoot>
						
						</table>

		</div>
	 
	</div> 


	</xsl:template>


		
	<xsl:template match="SummaryData">
		<script language="javascript">
				var tmp_div	= document.getElementById("tableBar");
				if ( tmp_div!=null )
				{
					tmp_div.style.display = "";
					tmp_div.className="data-area-jump-bar";
				}
		</script>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="Section">
		<!-- MM : Begin - D024 - fix -->
		<!-- xsl:variable name="guid"><xsl:number count="node()" level="single"/></xsl:variable -->
		<xsl:variable name="guid"><xsl:value-of select="position()"/></xsl:variable>
		<!-- Jump Data Item already has id in the form of id=name, since this will be unique, id will not be required -->
		<!-- MM : This value will be used to generate id for back to top -->
		<xsl:variable name="backToTopId">
			<xsl:choose>
				<xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : End - D024 - fix -->
		<script language="javascript">
			addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>',"<xsl:value-of select='@display'/>");
		</script>
		<a>
				<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
				<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
		</a>
	<div class="table_container">

		<div class="container mw650"> 
			<div class="container_top_right_accordian_open"> 
				<xsl:attribute name="id">accordian_container_<xsl:value-of select="@name"/></xsl:attribute>
				<div class="container_top_left"> 
					<div class="container_gradient"> 
						<div class="accordian_container_title">		
							<div>
								<xsl:attribute name="id">section_header_<xsl:value-of select="$guid"/></xsl:attribute>
								<div><xsl:value-of select="@display"/></div>
							</div>
                      </div>
                    </div>
                </div>
            </div>
			<div class="container_right">
				<xsl:attribute name="id">container_right_<xsl:value-of select="$guid"/></xsl:attribute>
				<div class="container_left">					
				</div>
			</div>
      <div class="container_right">
        <xsl:attribute name="id">container_content_<xsl:value-of select="$guid"/></xsl:attribute>
        <div class="container_left">
          <div class="container_content">
			<xsl:choose>
				<xsl:when test="/OMA/DataArea/SummaryData/@statistics='true'">
					<xsl:apply-templates select="ListData">
							<xsl:with-param name="noborder" select="'true'"/>
					</xsl:apply-templates>
					<br/>
					<xsl:if test="@name='pie' and @plotpiegraph='true'">
					
						<a name="piegraph1" id="title" href="#piegraph1">
						 <xsl:attribute name="onclick">javascript:expandGraph(0,"pie",<xsl:value-of select="/OMA/@vid"/>)</xsl:attribute>
						<xsl:value-of select="$strExpandView"/>
						</a>
                 		<div id="container1" style="min-width: 300px; height: 400px; margin: 0 auto"></div>
					
					</xsl:if>	
					<xsl:if test="@name='line' and @plotlinegraph='true'">
					
						<a name="linegraph1" id="title" href="#linegraph1">
						 <xsl:attribute name="onclick">javascript:expandGraph(0,"line",<xsl:value-of select="/OMA/@vid"/>)</xsl:attribute>
						<xsl:value-of select="$strExpandView"/>
						</a>
						<div  id="container2" style="min-width: 200px; height: 300px; margin: 0 auto"></div>
						<br/>
						<a name="linegraph2" id="title" href="#linegraph2">
						 <xsl:attribute name="onclick">javascript:expandGraph(1,"line",<xsl:value-of select="/OMA/@vid"/>)</xsl:attribute>
						<xsl:value-of select="$strExpandView"/>
						</a>

						<div  id="container3" style="min-width: 100px; height: 300px; margin: 0 auto"></div>
			
					</xsl:if>	

					</xsl:when>
					<xsl:otherwise>
							<xsl:apply-templates select="ListData">
								<xsl:with-param name="noborder" select="'true'"/>
							</xsl:apply-templates>

							<xsl:if test="./TableData">
								<xsl:apply-templates select="TableData" />
							</xsl:if>
					</xsl:otherwise>
			
			</xsl:choose>
          </div>
        </div>
      </div>
              <div class="container_bottom_right">
                <div class="container_bottom_left">
                  <div class="container_bottom">
                  </div>
                </div>
              </div>
      
        </div>
	</div>	
		<script language="javascript">
			var acc_con_id = 'accordian_container_<xsl:value-of select="@name"/>';
      var acc_body_id = 'container_right_<xsl:value-of select="$guid"/>';
      var acc_content_id = 'container_content_<xsl:value-of select="$guid"/>';
      container_accordion_setup(acc_con_id, acc_body_id, acc_content_id);
    </script>	
		
	</xsl:template>

	<xsl:template match="Header">
		<xsl:param name="columnspacing"/>
		<xsl:param name="sortable"/>
		<xsl:param name="ListTableDataHeader"/>
		<xsl:param name="expandable"/>
		<xsl:param name="staticcols"/>
		<xsl:param name="expandableheader"/>
    <!-- MM : Begin - D031 - fix for id issue -->
		<xsl:param name="puid" select="1"/>
		<xsl:variable name="table_id"><xsl:value-of select="$puid"/></xsl:variable>
		<xsl:variable name="row_id"><xsl:value-of select="position()"/></xsl:variable>
		<xsl:variable name="row_id_last"><xsl:value-of select="last()"/></xsl:variable>
		<xsl:variable name="double_header">
			<xsl:choose>
				<xsl:when test="$row_id_last &gt; 1 " >true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : End - D031 - fix for id issue -->
		<!-- <thead> -->
		<tr>
		<xsl:choose>
			<xsl:when test="$double_header = 'true'">
				<xsl:choose>
					<xsl:when test="$row_id = $row_id_last"></xsl:when> <!-- second row of the header will be taken care since rowspan=2 for first header-->
  				    <xsl:when test="@noborder = 'true'">
					  <xsl:attribute name="class">lowertop</xsl:attribute>
				    </xsl:when>
					<xsl:otherwise><!-- first row of the header -->
						<td>
						<xsl:attribute name="class">doubletopleft</xsl:attribute>
						<xsl:attribute name="rowspan">2</xsl:attribute>
						<xsl:attribute name="align">left</xsl:attribute>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise><td><xsl:attribute name="class">topleft</xsl:attribute></td></xsl:otherwise>
		</xsl:choose>
		<!-- Adding extra column for expanding symbol -->	
		<xsl:if test="$expandable ='true'">
			<xsl:choose>
			<xsl:when test="$double_header = 'true'">
				<td rowspan="2"><xsl:attribute name="class">uppertop</xsl:attribute></td>
			</xsl:when>
			<xsl:otherwise>
				<td><xsl:attribute name="class">top borderright</xsl:attribute></td>
			</xsl:otherwise>
			</xsl:choose>	
		</xsl:if>
        <xsl:for-each select="Data">
				<!-- MM : Begin - D031 - fix for id issue -->						
				<xsl:variable name="nameAttr" select="@name"/>
				<xsl:variable name="num">
					<xsl:choose>
						<xsl:when test="$nameAttr != ''"><xsl:value-of select="count(//TableData/Header/Data[@name=$nameAttr])"/></xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="col_id"><xsl:value-of select="position()"/></xsl:variable>
				<xsl:variable name="luid">
					<xsl:choose>
						<!-- if num is 0, it means the name attr is not present. In this case, generate the id -->
						<xsl:when test="$num = '0'">
							<xsl:value-of select="$table_id"/>_hdr<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
						</xsl:when>
						<!-- if num is not 1, it means the name attr is repeated (duplicate), In this case, generate the id -->
						<xsl:when test="$num != '1'">
							<xsl:choose>
							<!-- if this returns true, then the attribute value is already present. In this case, generate the id -->
								<xsl:when test="$nameAttr=preceding::Data[ancestor::TableData]/@name">
									<xsl:value-of select="$table_id"/>_hdr<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
								</xsl:when>
								<!-- if false, then this is the first instance of the attribute value. In this case, use the name as is for id-->
								<xsl:otherwise>
									<xsl:value-of select="@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<!-- if num is 1, it means the name attr is not repeated. In this case, use the name as is for id.-->
						<xsl:when test="$num = '1'">
							<xsl:value-of select="@name"/>								
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<!-- MM : End - D031 - fix for id issue -->
				<xsl:choose>
					<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
					<xsl:when test="$expandable ='true' and ($col_id  &gt; $staticcols)"></xsl:when>
					<xsl:otherwise>
					<td valign="middle" align="left">
					<xsl:choose>
					<xsl:when test="@type = 'hidden'">
						<xsl:attribute name="style">display:None</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$double_header = 'true'">
							<xsl:choose>
								<xsl:when test="$row_id = $row_id_last"><!-- second row of the header -->
									<xsl:choose>
										<xsl:when test="position() = last()">
											<xsl:attribute name="class">lowertop</xsl:attribute>
										</xsl:when>
										<xsl:when test="@noborder = 'true' or @noborderright = 'true'">
										  <xsl:attribute name="class">lowertop</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">lowertop borderright</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when> 
								<xsl:otherwise><!-- first row of the header -->
									<xsl:choose>
										<xsl:when test="position() = last()">
											<xsl:attribute name="class">uppertop</xsl:attribute>
										</xsl:when>
										<xsl:when test="@noborder = 'true' or @noborderright = 'true'">
											<xsl:attribute name="class">uppertop</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">uppertop borderright</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
							</xsl:when>
							<xsl:otherwise> <!--single header only -->
                <xsl:choose>
                  <xsl:when test="position() = last()">
                    <xsl:choose>
                      <xsl:when test="$sortable='true'">
                        <xsl:choose>
                          <xsl:when test="@topsorted = 'true'">
                            <xsl:attribute name="class">top sortable topsorted</xsl:attribute>
                          </xsl:when>
                          <xsl:when test="@descendsorted = 'true'">
                            <xsl:attribute name="class">top sortable topsorteddescend</xsl:attribute>
                          </xsl:when>
						  <xsl:when test="@noborder = 'true' or @noborderright = 'true'">
                            <xsl:attribute name="class">top</xsl:attribute>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:attribute name="class">top sortable</xsl:attribute>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:attribute name="class">top</xsl:attribute>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:choose>
                      <xsl:when test="$sortable='true'">
                        <xsl:choose>
                          <xsl:when test="@topsorted = 'true'">
                            <xsl:attribute name="class">top borderright sortable topsorted</xsl:attribute>
                          </xsl:when>
                          <xsl:when test="@descendsorted = 'true'">
                            <xsl:attribute name="class">top borderright sortable topsorteddescend</xsl:attribute>
                          </xsl:when>
						  <xsl:when test="@noborder = 'true' or @noborderright = 'true'">
                            <xsl:attribute name="class">top</xsl:attribute>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:attribute name="class">top borderright sortable</xsl:attribute>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@noborder = 'true' or @noborderright = 'true'">
							  <xsl:attribute name="class">top</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">top borderright</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>	
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:otherwise>
                </xsl:choose>						
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>

							<xsl:if test="@width !=''">
								<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
							</xsl:if>

							<xsl:if test="@colspan">
								<xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
							<xsl:choose>
								<xsl:when test="@link='true'">
									<a>
										<xsl:attribute name="href">javascript:g_appendVid_InvokeAction('<xsl:value-of select="@href"/>')</xsl:attribute>
										<xsl:choose>
											<xsl:when test="@underlined='true'">
												<!-- MM : Begin - D031 - fix for id issue -->
												<xsl:attribute name="id">
													<xsl:choose>
														<!-- when id is given -->
														<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
														<!-- when name is given -->
														<!--xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when -->
														<!-- neither id nor name is given -->
														<xsl:otherwise><xsl:value-of select="$luid"/></xsl:otherwise>
													</xsl:choose>
												</xsl:attribute>
												<!-- We add 'name' attribute here for 2 reasons.  -->
												<!-- 1. SilkTest doesnt identify 'id' or 'name' for <span>, which means we have to provide 'id' attribute for <a> -->
												<!-- 2. SilkTest doesnt identify 'id' attribute for <a> which means we have to provide 'name' attribute for <a> -->
												<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
												<!-- MM : End - D031 - fix for id issue -->
												<span style="text-decoration: underline">
													<xsl:call-template name="datatype">
														<!-- MM : Begin - D031 - fix for id issue -->
														<xsl:with-param name="uid" select="$luid"></xsl:with-param>
  														<xsl:with-param name="ignoreName">true</xsl:with-param>
														<!-- MM : End - D031 - fix for id issue -->
														<xsl:with-param name="display">
															<xsl:value-of select="@display"/>
														</xsl:with-param>
														<xsl:with-param name="type">
															<xsl:value-of select="@type"/>
														</xsl:with-param>
														<xsl:with-param name="name">
															<xsl:value-of select="@name"/>
														</xsl:with-param>
														<xsl:with-param name="id">
															<!-- MM : Begin - D031 - fix for id issue -->
															<xsl:value-of select="@id"/>
															<!-- xsl:value-of select="@name"/ -->
															<!-- MM : End - D031 - fix for id issue -->
														</xsl:with-param>
														<xsl:with-param name="value">
															<xsl:value-of select="@value"/>
														</xsl:with-param>
														<xsl:with-param name="returnvalue">
															<xsl:value-of select="@returnvalue"/>
														</xsl:with-param>
														<xsl:with-param name="state">
															<xsl:value-of select="@state"/>
														</xsl:with-param>
													</xsl:call-template>
												</span>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D031 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D031 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D031 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D031 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
										<!-- Start CHNG99370 - Visual cue for sort order -->
										<xsl:variable name="lowercase">abcdefghijklmnopqrstuvwxyz</xsl:variable>
										<xsl:variable name="uppercase">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>										
										<xsl:choose>
											<xsl:when test="translate(@srtIdentifier,$lowercase, $uppercase)=translate(@name,$lowercase, $uppercase)">
												<xsl:call-template name="display-sortorder">
													<xsl:with-param name="name" select="@name" />												
													<xsl:with-param name="sortorder" select="@sortorder" />
												</xsl:call-template>
											</xsl:when>
										</xsl:choose>
										<!-- End CHNG99370 - Visual cue for sort order -->
									</a>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@underlined='true'">
											<!-- MM : Begin - D031 - fix for id issue -->
											<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
											<xsl:attribute name="id">
												<xsl:choose>
													<!-- when id is given -->
													<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
													<!-- when name is given -->
													<!--xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when-->
													<!-- neither id nor name is given -->
													<xsl:otherwise><xsl:value-of select="$luid"/></xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<!-- MM : End - D031 - fix for id issue -->
											<span style="text-decoration: underline">
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D031 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D031 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D031 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D031 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
												</xsl:call-template>
											</span>
										</xsl:when>
										<!--C72949.  Add italic attribute -->
										<xsl:when test="@italic='true'">
											<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
											<!-- MM : Begin - D031 - fix for id issue -->
											<xsl:attribute name="id">
												<xsl:choose>
													<!-- when id is given -->
													<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
													<!-- when name is given -->
													<!--xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when-->
													<!-- neither id nor name is given -->
													<xsl:otherwise><xsl:value-of select="$luid"/></xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<!-- MM : End - D031 - fix for id issue -->
											<span style="font-style: italic">
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D031 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D031 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D031 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D031 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
												</xsl:call-template>
											</span>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="datatype">
												<!-- MM : Begin - D031 - fix for id issue -->
												<xsl:with-param name="uid" select="$luid"></xsl:with-param>
												<xsl:with-param name="ignoreName">true</xsl:with-param>
												<!-- MM : End - D031 - fix for id issue -->											
												<xsl:with-param name="display">
													<xsl:value-of select="@display"/>
												</xsl:with-param>
												<xsl:with-param name="type">
													<xsl:value-of select="@type"/>
												</xsl:with-param>
												<xsl:with-param name="name">
													<xsl:value-of select="@name"/>
												</xsl:with-param>
												<xsl:with-param name="id">
													<!-- MM : Begin - D031 - fix for id issue -->
													<xsl:value-of select="@id"/>
													<!-- xsl:value-of select="@name"/ -->
													<!-- MM : End - D031 - fix for id issue -->
												</xsl:with-param>
												<xsl:with-param name="value">
													<xsl:value-of select="@value"/>
												</xsl:with-param>
												<xsl:with-param name="returnvalue">
													<xsl:value-of select="@returnvalue"/>
												</xsl:with-param>
												<xsl:with-param name="state">
													<xsl:value-of select="@state"/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					<!-- add empty data items -->
					<xsl:if test="($columnspacing='true') and (position() != last())">
						<!-- <td class="data-area-canvas" style="height: 1px"><img src='/oma/images/blank.gif'/></td> -->
					</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
      
				<xsl:choose>
					<xsl:when test="$double_header = 'true'">
						<xsl:choose>
							<xsl:when test="$row_id = $row_id_last"></xsl:when> <!-- second row of the header -->
							<xsl:otherwise><!-- first row of the header -->
							<td>
								<xsl:attribute name="class">doubletopright</xsl:attribute>
								<xsl:attribute name="rowspan">2</xsl:attribute>
							</td>	
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><td><xsl:attribute name="class">topright</xsl:attribute></td></xsl:otherwise>
				</xsl:choose>
			
		</tr>
		
	<!--	
		<xsl:if test="position() = last()">
			<tr>
				<xsl:for-each select="Data">
					<xsl:choose>
						<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="@underlined='true'">
									<td class="data-area-canvas" style="height: 1px">
										<img   style="width: 1px; height: 1px"/> //this line should be commented
									</td>
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="@display!=''">
										<xsl:call-template name="sep">
											<xsl:with-param name="colspan">
												<xsl:value-of select="@colspan"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:if test="($columnspacing='true') and (position() != last())">
								 <td class="data-area-separator" style="height: 1px"><img   style="width: 1px; height: 1px"/></td> 
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</tr>
		</xsl:if>
	-->	
	</xsl:template>
	<xsl:template match="Row">
		<xsl:param name="columnspacing"/>
		<xsl:param name="noUniqIDs"/>
		<xsl:param name="evencolour"/>
		<xsl:param name="ListTableDataRow"/>
		<xsl:param name="expandable"/>
		<xsl:param name="staticcols"/>
		<xsl:param name="expandableheader"/>
		<xsl:param name="nopadding"/>
    <!-- MM : Begin - D032 - fix for id issue -->
		<xsl:param name="puid" select="1"/>
		<xsl:variable name="table_id"><xsl:value-of select="$puid"/></xsl:variable>
		<xsl:variable name="row_id"><xsl:value-of select="position()"/></xsl:variable>		
		<xsl:variable name="row_id_last"><xsl:value-of select="last()"/></xsl:variable>		
		<!-- MM : End - D032 - fix for id issue -->
		<tr>
			<xsl:attribute name="id"><xsl:value-of select="$table_id"/>_row_<xsl:value-of select="$row_id"/></xsl:attribute>
			<xsl:if test="@height">
				<xsl:attribute name="style">height:<xsl:value-of select="@height"/></xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="($evencolour = 'true') or ((position() mod 2)=1)">
				<td class="left"></td>
			<xsl:if test="$expandable ='true'">
			<td>
				<xsl:choose>
					<xsl:when test="$row_id = $row_id_last">
						<xsl:attribute name="class">contents borderright centerattop</xsl:attribute>					
					</xsl:when>				
					<xsl:otherwise>
						<xsl:attribute name="class">contents borderbottom borderright centerattop</xsl:attribute>
					</xsl:otherwise>					
				</xsl:choose>	
				 <span class="table_accordion_row_close">
					<xsl:attribute name="onclick">javascript:toggleTableRow(this,'<xsl:value-of select="$table_id"/>_row_<xsl:value-of select="$row_id"/>', true)</xsl:attribute>
					<script language="javascript">document.write ("&amp;nbsp;");</script>
				 </span>
			</td>				
			</xsl:if>
					<xsl:for-each select="Data">
						<xsl:variable name="col_id_last"><xsl:value-of select="last()"/></xsl:variable>		
						<!-- MM : Begin - D032 - fix for id issue  -->
						<xsl:variable name="nameAttr" select="@name"/>
						<xsl:variable name="col_id"><xsl:value-of select="position()"/></xsl:variable>
						<xsl:variable name="luid">
							<!-- if noUniqIDs is set to true, disable the generation of unique IDs -->
							<xsl:choose>
								<xsl:when test="$noUniqIDs='true'"><xsl:value-of select="@name"/></xsl:when>
								<xsl:otherwise>
									<xsl:variable name="num">
										<xsl:choose>
											<xsl:when test="$nameAttr != ''"><xsl:value-of select="count(//TableData/Row/Data[@name=$nameAttr])"/></xsl:when>
											<xsl:otherwise>0</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:choose>
										<!-- if num is 0, it means the name attr is not present. In this case, generate the id -->
										<xsl:when test="$num = '0'">
											<xsl:value-of select="$table_id"/>_row_<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
										</xsl:when>
										<!-- if num is not 1, it means the name attr is repeated (duplicate), In this case, generate the id -->
										<xsl:when test="$num != '1'">
											<xsl:choose>
											<!-- if this returns true, then the attribute value is already present. In this case, generate the id -->
												<xsl:when test="$nameAttr=preceding::Data[ancestor::TableData]/@name">
													<xsl:value-of select="$table_id"/>_row_<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
												</xsl:when>
												<!-- if false, then this is the first instance of the attribute value. In this case, use the name as is for id.-->
												<xsl:otherwise>
													<xsl:value-of select="@name"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<!-- if num is 1, it means the name attr is not repeated. In this case, use the name as is for id.-->
										<xsl:when test="$num = '1'">
											<xsl:value-of select="@name"/>
										</xsl:when>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>							
						</xsl:variable>
						<!-- MM : End - D032 - for id issue  -->
						<xsl:choose>
							<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
							<xsl:when test="$expandable ='true' and $col_id &gt; $staticcols"></xsl:when>
							<xsl:otherwise>
							<td valign="middle">
							<xsl:choose>
							<xsl:when test="@type = 'hidden'">
								<xsl:attribute name="style">display:None</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="position() = last()">
									<xsl:choose>
										<xsl:when test="$row_id = $row_id_last and $nopadding != 'true'">
											<xsl:attribute name="class">contents</xsl:attribute>
										</xsl:when>
 									    <xsl:when test="@noborder = 'true' and $nopadding != 'true'">
										  <xsl:attribute name="class">contents</xsl:attribute>
									    </xsl:when>
 									    <xsl:when test="@noborderright = 'true' and $nopadding != 'true'">
										  <xsl:attribute name="class">contents borderbottom</xsl:attribute>
									    </xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$nopadding != 'true'">
													<xsl:attribute name="class">contents borderbottom</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">borderbottom</xsl:attribute>												
												</xsl:otherwise>
											</xsl:choose>	
										</xsl:otherwise>
									</xsl:choose>	
								</xsl:when>
							  <xsl:otherwise>
								<xsl:choose>
								  <xsl:when test="$row_id = $row_id_last">
									<xsl:choose>
									  <xsl:when test="(@noborder = 'true' or @noborderright = 'true') and $nopadding != 'true'">
										<xsl:attribute name="class">contents</xsl:attribute>
									  </xsl:when>
									  <xsl:when test="$expandable ='true' and $col_id = $staticcols and $nopadding != 'true'">
										<xsl:attribute name="class">contents</xsl:attribute>
									  </xsl:when>						  
									  <xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$nopadding != 'true'">
													<xsl:attribute name="class">contents borderright</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">borderright</xsl:attribute>												
												</xsl:otherwise>
											</xsl:choose>	
									  </xsl:otherwise>
									</xsl:choose>
								  </xsl:when>
								  <xsl:when test="@noborder = 'true' and $nopadding != 'true'">
									<xsl:attribute name="class">contents</xsl:attribute>
								  </xsl:when>
								  <xsl:when test="@noborderright = 'true' and $nopadding != 'true'">
									<xsl:attribute name="class">contents borderbottom</xsl:attribute>
								  </xsl:when>
								  <xsl:when test="$expandable ='true' and $col_id = $staticcols">
										<xsl:choose>
										<xsl:when test="$nopadding != 'true'">
											<xsl:attribute name="class">contents borderbottom</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">borderbottom</xsl:attribute>												
										</xsl:otherwise>
									</xsl:choose>										
								  </xsl:when>						  
								  <xsl:otherwise>
									<xsl:choose>
										<xsl:when test="$nopadding != 'true'">
											<xsl:attribute name="class">contents borderright borderbottom</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">borderright borderbottom</xsl:attribute>												
										</xsl:otherwise>
									</xsl:choose>	
								  </xsl:otherwise>
								</xsl:choose>
							  </xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
							</xsl:choose>

                                    <xsl:if test="@tooltip"><xsl:attribute name="title"><xsl:value-of select="@tooltip"/></xsl:attribute></xsl:if> 
 								    <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
									<xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
									<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
									<xsl:if test="@width !=''">
										<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
									</xsl:if>
									<xsl:choose>
									<xsl:when test="$expandable ='true' and $col_id = $staticcols">
									<div>
									<xsl:choose>
										<xsl:when test="@link='true'">
											<xsl:element name="a">
												<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
												<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D032 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D032 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D032 - fix for id issue -->
														<!-- xsl:value-of select="@name"/ -->
														<xsl:value-of select="@id"/>
														<!-- MM : End - D032 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="preserve_format">
														<xsl:if test="@name = 'Description'">yes</xsl:if>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
												</xsl:call-template>
											</xsl:element>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="datatype">
												<!-- MM : Begin - D032 - fix for id issue -->
												<xsl:with-param name="uid" select="$luid"></xsl:with-param>
												<xsl:with-param name="ignoreName">true</xsl:with-param>
												<!-- MM : End - D032 - fix for id issue -->
												<xsl:with-param name="display">
													<xsl:value-of select="@display"/>
												</xsl:with-param>
												<xsl:with-param name="type">
													<xsl:value-of select="@type"/>
												</xsl:with-param>
												<xsl:with-param name="name">
													<xsl:value-of select="@name"/>
												</xsl:with-param>
												<xsl:with-param name="id">
													<!-- MM : Begin - D032 - fix for id issue -->
													<!-- xsl:value-of select="@name"/ -->
													<xsl:value-of select="@id"/>
													<!-- MM : End - D032 - fix for id issue -->
												</xsl:with-param>
												<xsl:with-param name="value">
													<xsl:value-of select="@value"/>
												</xsl:with-param>
												<xsl:with-param name="returnvalue">
													<xsl:value-of select="@returnvalue"/>
												</xsl:with-param>
												<xsl:with-param name="state">
													<xsl:value-of select="@state"/>
												</xsl:with-param>
												<xsl:with-param name="size">
													<xsl:value-of select="@size"/>
												</xsl:with-param>
												<xsl:with-param name="uparrscript">
													<xsl:value-of select="@uparrscript"/>
												</xsl:with-param>
												<xsl:with-param name="downarrscript">
													<xsl:value-of select="@downarrscript"/>
												</xsl:with-param>
												<xsl:with-param name="sep">
													<xsl:value-of select="@sep"/>
												</xsl:with-param>
												<xsl:with-param name="value1">
													<xsl:value-of select="@value1"/>
												</xsl:with-param>
												<xsl:with-param name="value2">
													<xsl:value-of select="@value2"/>
												</xsl:with-param>
												<xsl:with-param name="value3">
													<xsl:value-of select="@value3"/>
												</xsl:with-param>
												<xsl:with-param name="value4">
													<xsl:value-of select="@value4"/>
												</xsl:with-param>
												<xsl:with-param name="event">
													<xsl:value-of select="@event"/>
												</xsl:with-param>
												<xsl:with-param name="handler">
													<xsl:value-of select="@handler"/>
												</xsl:with-param>
												<xsl:with-param name="preserve_format">
													<xsl:if test="@name = 'Description'">yes</xsl:if>
												</xsl:with-param>
												<!--C91707 Ability to set selection box width-->
												<xsl:with-param name="width">
													<xsl:value-of select="@boxwidth"/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
									</div>
									</xsl:when>
									<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@link='true'">
											<xsl:element name="a">
												<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
												<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D032 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D032 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D032 - fix for id issue -->
														<!-- xsl:value-of select="@name"/ -->
														<xsl:value-of select="@id"/>
														<!-- MM : End - D032 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="preserve_format">
														<xsl:if test="@name = 'Description'">yes</xsl:if>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
												</xsl:call-template>
											</xsl:element>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="datatype">
												<!-- MM : Begin - D032 - fix for id issue -->
												<xsl:with-param name="uid" select="$luid"></xsl:with-param>
												<xsl:with-param name="ignoreName">true</xsl:with-param>
												<!-- MM : End - D032 - fix for id issue -->
												<xsl:with-param name="display">
													<xsl:value-of select="@display"/>
												</xsl:with-param>
												<xsl:with-param name="type">
													<xsl:value-of select="@type"/>
												</xsl:with-param>
												<xsl:with-param name="name">
													<xsl:value-of select="@name"/>
												</xsl:with-param>
												<xsl:with-param name="id">
													<!-- MM : Begin - D032 - fix for id issue -->
													<!-- xsl:value-of select="@name"/ -->
													<xsl:value-of select="@id"/>
													<!-- MM : End - D032 - fix for id issue -->
												</xsl:with-param>
												<xsl:with-param name="value">
													<xsl:value-of select="@value"/>
												</xsl:with-param>
												<xsl:with-param name="returnvalue">
													<xsl:value-of select="@returnvalue"/>
												</xsl:with-param>
												<xsl:with-param name="state">
													<xsl:value-of select="@state"/>
												</xsl:with-param>
												<xsl:with-param name="size">
													<xsl:value-of select="@size"/>
												</xsl:with-param>
												<xsl:with-param name="uparrscript">
													<xsl:value-of select="@uparrscript"/>
												</xsl:with-param>
												<xsl:with-param name="downarrscript">
													<xsl:value-of select="@downarrscript"/>
												</xsl:with-param>
												<xsl:with-param name="sep">
													<xsl:value-of select="@sep"/>
												</xsl:with-param>
												<xsl:with-param name="value1">
													<xsl:value-of select="@value1"/>
												</xsl:with-param>
												<xsl:with-param name="value2">
													<xsl:value-of select="@value2"/>
												</xsl:with-param>
												<xsl:with-param name="value3">
													<xsl:value-of select="@value3"/>
												</xsl:with-param>
												<xsl:with-param name="value4">
													<xsl:value-of select="@value4"/>
												</xsl:with-param>
												<xsl:with-param name="event">
													<xsl:value-of select="@event"/>
												</xsl:with-param>
												<xsl:with-param name="handler">
													<xsl:value-of select="@handler"/>
												</xsl:with-param>
												<xsl:with-param name="preserve_format">
													<xsl:if test="@name = 'Description'">yes</xsl:if>
												</xsl:with-param>
												<!--C91707 Ability to set selection box width-->
												<xsl:with-param name="width">
													<xsl:value-of select="@boxwidth"/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
									
									</xsl:otherwise>
									</xsl:choose>
									<xsl:value-of select="@unit"/>
									<xsl:variable name="novalue"><xsl:choose>
										<xsl:when test="@value">
											<xsl:choose>
												<xsl:when test="@value='' ">true</xsl:when>
												<xsl:otherwise>false</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>true</xsl:otherwise>
									</xsl:choose></xsl:variable>
									<xsl:if test="ValueList">
										<xsl:for-each select="ValueList/value">
											<xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if>
										</xsl:for-each>
									</xsl:if>
									
									<xsl:if test="$expandable ='true' and $col_id = $staticcols">
									<div class="container_content hide">    
										<xsl:if test="$expandableheader">
											<div class="sub_header" align="left"><xsl:value-of select="$expandableheader"/></div>
										</xsl:if>	
                                                                    
                                        <table class="infolist">
                                                <tr>
                                                    <td colspan="2" class="top_spacer_small"></td>
                                                </tr>                      

											<xsl:call-template name="for-loop-sub-table">
												<xsl:with-param name="finalcount" select="$col_id_last+1"/>			
												<xsl:with-param name="i" select="1"/>
												<xsl:with-param name="increment" select="1"/>
											</xsl:call-template>

                                        </table>
									</div>
									
									</xsl:if>
									<!-- This is a special case, right now used for probe object settings only -->
								<xsl:for-each select="ExtraItem">
									<xsl:choose>
										<xsl:when test="@link='true'">
   												<!--xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute-->
												<xsl:element name="a">
													<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
													<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
													<xsl:call-template name="datatype">
														<!-- MM : Begin - D035 - fix for id issue -->
														<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
														<xsl:with-param name="ignoreName">true</xsl:with-param>
														<!-- MM : End - D035 - fix for id issue -->
														<xsl:with-param name="display">
															<xsl:value-of select="@display"/>
														</xsl:with-param>
														<xsl:with-param name="type">
															<xsl:value-of select="@type"/>
														</xsl:with-param>
														<xsl:with-param name="name">
															<xsl:value-of select="@name"/>
														</xsl:with-param>
														<xsl:with-param name="id">
															<!-- MM : Begin - D035 - fix for id issue -->
															<xsl:value-of select="@id"/>
															<!-- xsl:value-of select="@name"/ -->
															<!-- MM : End - D035 - fix for id issue -->
														</xsl:with-param>
														<xsl:with-param name="value">
															<xsl:value-of select="@value"/>
														</xsl:with-param>
														<xsl:with-param name="returnvalue">
															<xsl:value-of select="@returnvalue"/>
														</xsl:with-param>
														<xsl:with-param name="state">
															<xsl:value-of select="@state"/>
														</xsl:with-param>
														<xsl:with-param name="extraitem">true</xsl:with-param>
													</xsl:call-template>
												</xsl:element>							
										</xsl:when>
										<xsl:otherwise>										    						
											<!--87536 end -->
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D035 - fix for id issue -->
													<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D035 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D035 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D035 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="size">
														<xsl:value-of select="@size"/>
													</xsl:with-param>
													<xsl:with-param name="uparrscript">
														<xsl:value-of select="@uparrscript"/>
													</xsl:with-param>
													<xsl:with-param name="downarrscript">
														<xsl:value-of select="@downarrscript"/>
													</xsl:with-param>
													<xsl:with-param name="sep">
														<xsl:value-of select="@sep"/>
													</xsl:with-param>
													<xsl:with-param name="value1">
														<xsl:value-of select="@value1"/>
													</xsl:with-param>
													<xsl:with-param name="value2">
														<xsl:value-of select="@value2"/>
													</xsl:with-param>
													<xsl:with-param name="value3">
														<xsl:value-of select="@value3"/>
													</xsl:with-param>
													<xsl:with-param name="value4">
														<xsl:value-of select="@value4"/>
													</xsl:with-param>
													<xsl:with-param name="event">
														<xsl:value-of select="@event"/>
													</xsl:with-param>
													<xsl:with-param name="handler">
														<xsl:value-of select="@handler"/>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
													<xsl:with-param name="extraitem">true</xsl:with-param>
												</xsl:call-template>
												<xsl:value-of select="@unit"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>                  
              
								</td>
								<!-- add empty data items -->
								<xsl:if test="($columnspacing='true') and (position() != last())">
									<!-- <td class="data-area-canvas-odd" style="height: 1px"><img src='/oma/images/blank.gif'/></td> -->
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
				<xsl:choose>
				<xsl:when test="($evencolour = 'true') or ($expandable ='true')"></xsl:when>
				<xsl:otherwise><xsl:attribute name="class">fill</xsl:attribute></xsl:otherwise>
				</xsl:choose>
				<td class="left"></td>		
				<xsl:if test="$expandable ='true'">
				<td>
					<xsl:choose>
						<xsl:when test="$row_id = $row_id_last">
							<xsl:attribute name="class">contents borderright centerattop</xsl:attribute>					
						</xsl:when>				
						<xsl:otherwise>
							<xsl:attribute name="class">contents borderbottom borderright centerattop</xsl:attribute>
						</xsl:otherwise>					
					</xsl:choose>	
					 <span class="table_accordion_row_close">
						<xsl:attribute name="onclick">javascript:toggleTableRow(this,'<xsl:value-of select="$table_id"/>_row_<xsl:value-of select="$row_id"/>', true)</xsl:attribute>
						<script language="javascript">document.write ("&amp;nbsp;");</script>
					 </span>
				</td>				
				</xsl:if>
				<xsl:for-each select="Data">
						<xsl:variable name="col_id_last"><xsl:value-of select="last()"/></xsl:variable>		
						<!-- MM : Begin - D032 fix for id issue-->
						<xsl:variable name="nameAttr" select="@name"/>
						<xsl:variable name="col_id"><xsl:number count="node()" level="single"/></xsl:variable>
						<xsl:variable name="luid">
							<!-- if noUniqIDs is set to true, disable the generation of unique IDs -->
							<xsl:choose>
								<xsl:when test="$noUniqIDs='true'"><xsl:value-of select="@name"/></xsl:when>
								<xsl:otherwise>						
									<xsl:variable name="num">
										<xsl:choose>
											<xsl:when test="$nameAttr != ''"><xsl:value-of select="count(//TableData/Row/Data[@name=$nameAttr])"/></xsl:when>
											<xsl:otherwise>0</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:choose>
										<!-- if num is 0, it means the name attr is not present. In this case, generate the id -->
										<xsl:when test="$num = '0'">
											<xsl:value-of select="$table_id"/>_row_<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
										</xsl:when>
										<!-- if num is not 1, it means the name attr is repeated (duplicate), In this case, generate the id -->
										<xsl:when test="$num != '1'">
											<xsl:choose>
												<!-- if this returns true, then the attribute value is already present. In this case, generate the id -->
												<xsl:when test="$nameAttr=preceding::Data[ancestor::TableData]/@name">
													<xsl:value-of select="$table_id"/>_row_<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
												</xsl:when>
												<!-- if false, then this is the first instance of the attribute value. In this case, use the name as is for id -->
												<xsl:otherwise>
													<xsl:value-of select="@name"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<!-- if num is 1, it means the name attr is not repeated. In this case, use the name as is for id.-->
										<xsl:when test="$num = '1'">
											<xsl:value-of select="@name"/>
										</xsl:when>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<!-- MM : End - D032 - fix for id issue-->
						<xsl:choose>
							<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
							<xsl:when test="$expandable ='true' and $col_id &gt; $staticcols"></xsl:when>
							<xsl:otherwise>
							<td  valign="middle">
							<xsl:choose>
							<xsl:when test="@type = 'hidden'">
								<xsl:attribute name="style">display:None</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="position() = last()">
									<xsl:choose>
										<xsl:when test="$row_id = $row_id_last and $nopadding != 'true'">
											<xsl:attribute name="class">contents</xsl:attribute>
										</xsl:when>
 									    <xsl:when test="@noborder = 'true' and $nopadding != 'true'">
										  <xsl:attribute name="class">contents</xsl:attribute>
									    </xsl:when>
 									    <xsl:when test="@noborderright = 'true' and $nopadding != 'true'">
										  <xsl:attribute name="class">contents borderbottom</xsl:attribute>
									    </xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$nopadding != 'true'">
													<xsl:attribute name="class">contents borderbottom</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">borderbottom</xsl:attribute>												
												</xsl:otherwise>
											</xsl:choose>	
										</xsl:otherwise>
									</xsl:choose>	
								</xsl:when>
							  <xsl:otherwise>
								<xsl:choose>
								  <xsl:when test="$row_id = $row_id_last">
									<xsl:choose>
									  <xsl:when test="(@noborder = 'true' or @noborderright = 'true') and $nopadding != 'true'">
										<xsl:attribute name="class">contents</xsl:attribute>
									  </xsl:when>
									  <xsl:when test="$expandable ='true' and $col_id = $staticcols and $nopadding != 'true'">
										<xsl:attribute name="class">contents</xsl:attribute>
									  </xsl:when>						  
									  <xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$nopadding != 'true'">
													<xsl:attribute name="class">contents borderright</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="class">borderright</xsl:attribute>												
												</xsl:otherwise>
											</xsl:choose>	
									  </xsl:otherwise>
									</xsl:choose>
								  </xsl:when>
								  <xsl:when test="@noborder = 'true' and $nopadding != 'true'">
									<xsl:attribute name="class">contents</xsl:attribute>
								  </xsl:when>
								  <xsl:when test="@noborderright = 'true' and $nopadding != 'true'">
									<xsl:attribute name="class">contents borderbottom</xsl:attribute>
								  </xsl:when>
								  <xsl:when test="$expandable ='true' and $col_id = $staticcols">
										<xsl:choose>
										<xsl:when test="$nopadding != 'true'">
											<xsl:attribute name="class">contents borderbottom</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">borderbottom</xsl:attribute>												
										</xsl:otherwise>
									</xsl:choose>										
								  </xsl:when>						  
								  <xsl:otherwise>
									<xsl:choose>
										<xsl:when test="$nopadding != 'true'">
											<xsl:attribute name="class">contents borderright borderbottom</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">borderright borderbottom</xsl:attribute>												
										</xsl:otherwise>
									</xsl:choose>	
								  </xsl:otherwise>
								</xsl:choose>
							  </xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
							</xsl:choose>
						
							<xsl:if test="@tooltip"><xsl:attribute name="title"><xsl:value-of select="@tooltip"/></xsl:attribute></xsl:if>
                                                      <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
									<xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
									<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
                                                       
									<xsl:if test="@width !=''">
										<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
									</xsl:if>
									<xsl:choose>
									<xsl:when test="$expandable ='true' and $col_id = $staticcols">
									<div>
										<xsl:choose>
										<xsl:when test="@link='true'">
											<xsl:element name="a">
												<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
												<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D032 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D032 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
                          <xsl:with-param name="id">
														<!-- MM : Begin - D032 - fix for id issue -->
														<!-- xsl:value-of select="@name"/ -->
														<xsl:value-of select="@id"/>
														<!-- MM : End - D032 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="preserve_format">
														<xsl:if test="@name = 'Description'">yes</xsl:if>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
												</xsl:call-template>
											</xsl:element>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="datatype">
												<!-- MM : Begin - D032 - fix for id issue -->
												<xsl:with-param name="uid" select="$luid"></xsl:with-param>
												<xsl:with-param name="ignoreName">true</xsl:with-param>
												<!-- MM : End - D032 - fix for id issue -->
												<xsl:with-param name="display">
													<xsl:value-of select="@display"/>
												</xsl:with-param>
												<xsl:with-param name="type">
													<xsl:value-of select="@type"/>
												</xsl:with-param>
												<xsl:with-param name="name">
													<xsl:value-of select="@name"/>
												</xsl:with-param>
												<xsl:with-param name="id">
													<!-- MM : Begin - D032 - fix for id issue -->
													<!-- xsl:value-of select="@name"/ -->
													<xsl:value-of select="@id"/>
													<!-- MM : End - D032 - fix for id issue -->
												</xsl:with-param>
												<xsl:with-param name="value">
													<xsl:value-of select="@value"/>
												</xsl:with-param>
												<xsl:with-param name="returnvalue">
													<xsl:value-of select="@returnvalue"/>
												</xsl:with-param>
												<xsl:with-param name="state">
													<xsl:value-of select="@state"/>
												</xsl:with-param>
												<xsl:with-param name="size">
													<xsl:value-of select="@size"/>
												</xsl:with-param>
												<xsl:with-param name="uparrscript">
													<xsl:value-of select="@uparrscript"/>
												</xsl:with-param>
												<xsl:with-param name="downarrscript">
													<xsl:value-of select="@downarrscript"/>
												</xsl:with-param>
												<xsl:with-param name="sep">
													<xsl:value-of select="@sep"/>
												</xsl:with-param>
												<xsl:with-param name="value1">
													<xsl:value-of select="@value1"/>
												</xsl:with-param>
												<xsl:with-param name="value2">
													<xsl:value-of select="@value2"/>
												</xsl:with-param>
												<xsl:with-param name="value3">
													<xsl:value-of select="@value3"/>
												</xsl:with-param>
												<xsl:with-param name="value4">
													<xsl:value-of select="@value4"/>
												</xsl:with-param>
												<xsl:with-param name="event">
													<xsl:value-of select="@event"/>
												</xsl:with-param>
												<xsl:with-param name="handler">
													<xsl:value-of select="@handler"/>
												</xsl:with-param>
												<xsl:with-param name="preserve_format">
													<xsl:if test="@name = 'Description'">yes</xsl:if>
												</xsl:with-param>
												<!-- C91707 Ability to set selection box width-->
												<xsl:with-param name="width">
													<xsl:value-of select="@boxwidth"/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
									</div>
									</xsl:when>
									<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@link='true'">
											<xsl:element name="a">
												<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
												<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D032 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D032 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
                          <xsl:with-param name="id">
														<!-- MM : Begin - D032 - fix for id issue -->
														<!-- xsl:value-of select="@name"/ -->
														<xsl:value-of select="@id"/>
														<!-- MM : End - D032 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="preserve_format">
														<xsl:if test="@name = 'Description'">yes</xsl:if>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
												</xsl:call-template>
											</xsl:element>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="datatype">
												<!-- MM : Begin - D032 - fix for id issue -->
												<xsl:with-param name="uid" select="$luid"></xsl:with-param>
												<xsl:with-param name="ignoreName">true</xsl:with-param>
												<!-- MM : End - D032 - fix for id issue -->
												<xsl:with-param name="display">
													<xsl:value-of select="@display"/>
												</xsl:with-param>
												<xsl:with-param name="type">
													<xsl:value-of select="@type"/>
												</xsl:with-param>
												<xsl:with-param name="name">
													<xsl:value-of select="@name"/>
												</xsl:with-param>
												<xsl:with-param name="id">
													<!-- MM : Begin - D032 - fix for id issue -->
													<!-- xsl:value-of select="@name"/ -->
													<xsl:value-of select="@id"/>
													<!-- MM : End - D032 - fix for id issue -->
												</xsl:with-param>
												<xsl:with-param name="value">
													<xsl:value-of select="@value"/>
												</xsl:with-param>
												<xsl:with-param name="returnvalue">
													<xsl:value-of select="@returnvalue"/>
												</xsl:with-param>
												<xsl:with-param name="state">
													<xsl:value-of select="@state"/>
												</xsl:with-param>
												<xsl:with-param name="size">
													<xsl:value-of select="@size"/>
												</xsl:with-param>
												<xsl:with-param name="uparrscript">
													<xsl:value-of select="@uparrscript"/>
												</xsl:with-param>
												<xsl:with-param name="downarrscript">
													<xsl:value-of select="@downarrscript"/>
												</xsl:with-param>
												<xsl:with-param name="sep">
													<xsl:value-of select="@sep"/>
												</xsl:with-param>
												<xsl:with-param name="value1">
													<xsl:value-of select="@value1"/>
												</xsl:with-param>
												<xsl:with-param name="value2">
													<xsl:value-of select="@value2"/>
												</xsl:with-param>
												<xsl:with-param name="value3">
													<xsl:value-of select="@value3"/>
												</xsl:with-param>
												<xsl:with-param name="value4">
													<xsl:value-of select="@value4"/>
												</xsl:with-param>
												<xsl:with-param name="event">
													<xsl:value-of select="@event"/>
												</xsl:with-param>
												<xsl:with-param name="handler">
													<xsl:value-of select="@handler"/>
												</xsl:with-param>
												<xsl:with-param name="preserve_format">
													<xsl:if test="@name = 'Description'">yes</xsl:if>
												</xsl:with-param>
												<!-- C91707 Ability to set selection box width-->
												<xsl:with-param name="width">
													<xsl:value-of select="@boxwidth"/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
									
									</xsl:otherwise>
									</xsl:choose>
									<xsl:value-of select="@unit"/>
									<xsl:variable name="novalue"><xsl:choose>
										<xsl:when test="@value">
											<xsl:choose>
												<xsl:when test="@value='' ">true</xsl:when>
												<xsl:otherwise>false</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>true</xsl:otherwise>
									</xsl:choose></xsl:variable>
									<xsl:if test="ValueList">
										<xsl:for-each select="ValueList/value">
											<xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if>
										</xsl:for-each>
									</xsl:if>
									<xsl:if test="$expandable ='true' and $col_id = $staticcols">
										<div class="container_content hide">                                                    
										<xsl:if test="$expandableheader">
											<div class="sub_header" align="left"><xsl:value-of select="$expandableheader"/></div>
										</xsl:if>	
																		
											<table class="infolist">
													<tr>
														<td colspan="2" class="top_spacer_small"></td>
													</tr>                      

												<xsl:call-template name="for-loop-sub-table">
													<xsl:with-param name="finalcount" select="$col_id_last+1"/>			
													<xsl:with-param name="i" select="1"/>
													<xsl:with-param name="increment" select="1"/>
												</xsl:call-template>

											</table>
										</div>
									</xsl:if>
<!-- This is a special case, right now used for probe object settings only -->
								<xsl:for-each select="ExtraItem">
									<xsl:choose>
										<xsl:when test="@link='true'">
   												<!--xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute-->
												<xsl:element name="a">
													<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
													<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
													<xsl:call-template name="datatype">
														<!-- MM : Begin - D035 - fix for id issue -->
														<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
														<xsl:with-param name="ignoreName">true</xsl:with-param>
														<!-- MM : End - D035 - fix for id issue -->
														<xsl:with-param name="display">
															<xsl:value-of select="@display"/>
														</xsl:with-param>
														<xsl:with-param name="type">
															<xsl:value-of select="@type"/>
														</xsl:with-param>
														<xsl:with-param name="name">
															<xsl:value-of select="@name"/>
														</xsl:with-param>
														<xsl:with-param name="id">
															<!-- MM : Begin - D035 - fix for id issue -->
															<xsl:value-of select="@id"/>
															<!-- xsl:value-of select="@name"/ -->
															<!-- MM : End - D035 - fix for id issue -->
														</xsl:with-param>
														<xsl:with-param name="value">
															<xsl:value-of select="@value"/>
														</xsl:with-param>
														<xsl:with-param name="returnvalue">
															<xsl:value-of select="@returnvalue"/>
														</xsl:with-param>
														<xsl:with-param name="state">
															<xsl:value-of select="@state"/>
														</xsl:with-param>
														<xsl:with-param name="extraitem">true</xsl:with-param>
													</xsl:call-template>
												</xsl:element>							
										</xsl:when>
										<xsl:otherwise>										    						
											<!--87536 end -->
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D035 - fix for id issue -->
													<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D035 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D035 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D035 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="size">
														<xsl:value-of select="@size"/>
													</xsl:with-param>
													<xsl:with-param name="uparrscript">
														<xsl:value-of select="@uparrscript"/>
													</xsl:with-param>
													<xsl:with-param name="downarrscript">
														<xsl:value-of select="@downarrscript"/>
													</xsl:with-param>
													<xsl:with-param name="sep">
														<xsl:value-of select="@sep"/>
													</xsl:with-param>
													<xsl:with-param name="value1">
														<xsl:value-of select="@value1"/>
													</xsl:with-param>
													<xsl:with-param name="value2">
														<xsl:value-of select="@value2"/>
													</xsl:with-param>
													<xsl:with-param name="value3">
														<xsl:value-of select="@value3"/>
													</xsl:with-param>
													<xsl:with-param name="value4">
														<xsl:value-of select="@value4"/>
													</xsl:with-param>
													<xsl:with-param name="event">
														<xsl:value-of select="@event"/>
													</xsl:with-param>
													<xsl:with-param name="handler">
														<xsl:value-of select="@handler"/>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
													<xsl:with-param name="extraitem">true</xsl:with-param>
												</xsl:call-template>
												<xsl:value-of select="@unit"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>                  
              									
									
								</td>
								<!-- add empty data items -->
								<xsl:if test="($columnspacing='true') and (position() != last())">
									<!-- <td class="data-area-canvas" style="height: 1px"><img src='/oma/images/blank.gif'/></td> -->
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
      <xsl:choose>
        <xsl:when test="not(Header)">
          <xsl:choose>
            <xsl:when test="$ListTableDataRow ='true'">
				<xsl:choose>
					<xsl:when test="position() = 1">
						<xsl:if  test="/OMA/DataArea/@submit">
							<td class="contents" align="center">
										<xsl:call-template name="button">
										  <xsl:with-param name="id">moveup</xsl:with-param>
										  <xsl:with-param name="display">MoveUP</xsl:with-param>
										  <xsl:with-param name="tablebutton">true</xsl:with-param>
										  <xsl:with-param name="listtablebutton">true</xsl:with-param>
										  <xsl:with-param name="href">javascript:moveRowNop()</xsl:with-param>
										  <xsl:with-param name="onclick">javascript:MoveUp(event)</xsl:with-param>
										</xsl:call-template>
							</td>
						</xsl:if>
							<td class="right"></td>
					</xsl:when>
					<xsl:when test="position() = last()">
						 <xsl:if  test="/OMA/DataArea/@submit">
							<td class="contents" align="center">
										<xsl:call-template name="button">
										  <xsl:with-param name="id">movedown</xsl:with-param>
										  <xsl:with-param name="display">MoveDown</xsl:with-param>
										  <xsl:with-param name="tablebutton">true</xsl:with-param>
										  <xsl:with-param name="listtablebutton">true</xsl:with-param>
										  <xsl:with-param name="href">javascript:moveRowNop()</xsl:with-param>
										  <xsl:with-param name="onclick">javascript:MoveDown(event)</xsl:with-param>
										</xsl:call-template>
							</td>
						 </xsl:if>
							<td class="right"></td>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if  test="/OMA/DataArea/@submit">
							<td class="contents" align="center"></td>
						</xsl:if>
						<td class="right"></td>
					</xsl:otherwise>
					</xsl:choose>
			</xsl:when>	
			<xsl:when test="$ListTableDataRow ='false'">
				<td class="contents" align="center"></td>
				<td class="right"></td>
			</xsl:when>
            <xsl:otherwise>
              <td class="right">
                <xsl:attribute name="colspan">
                  <xsl:value-of select="count( ./Row/Data[ not( @ignoreonweb = 'true' ) ] )"/>
                </xsl:attribute>
              </td>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <td class="right"></td>
        </xsl:otherwise>
      </xsl:choose>
    </tr>	

	</xsl:template>

	<xsl:template name="for-loop-sub-table">
		<xsl:param name="finalcount"/>
		<xsl:param name="i"	select="1"/>
		<xsl:param name="increment" select="1"/>
		<xsl:if test="$i &lt; $finalcount">
			<xsl:if test="../Data[$i]/@type != 'button' and ../Data[$i]/@type != 'select' and ../Data[$i]/@type != 'skipSubtable'"> <!-- BITS040174: Excluding the type 'skipSubtable'[along with the types 'button' and 'select'] from displaying a row as part of sub table -->
				<tr align="left">
					<td class="item">
						<span><xsl:value-of select="../../Header/Data[$i]/@display"/></span>
					</td>
					<td>
						<span>
						<xsl:choose>
						<xsl:when test="../Data[$i]/@type = 'status'">
							<xsl:call-template name="display-status-text">
								<xsl:with-param name="status" select="../Data[$i]/@value" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="../Data[$i]/@value"/>
						</xsl:otherwise>
						</xsl:choose>	
	<!--					<xsl:choose>
						<xsl:when test="@id"><xsl:value-of select="../Data[$i]/@id"/></xsl:when>
						<xsl:when test="@display"><xsl:value-of select="../Data[$i]/@display"/></xsl:when>
						<xsl:when test="@value"><xsl:value-of select="../Data[$i]/@value"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="../Data[$i]/."/></xsl:otherwise>
						</xsl:choose>
	-->					
						
						</span>
					</td>
				</tr>
			</xsl:if>
			<xsl:call-template name="for-loop-sub-table">
				<xsl:with-param name="finalcount" select="$finalcount"/>			
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
			</xsl:call-template>

		</xsl:if>	
	</xsl:template>

	
	
	
	<xsl:template match="PageTitle">
		<span id="pageTitle">
   		 	 <xsl:value-of select="@display"/>
      		</span>
	</xsl:template>
	
	<xsl:template match="PromptText">
		<!-- MM :Begin - D021 - fix for id issue -->
		<xsl:param name="puid" select="1"></xsl:param>
		<xsl:param name="caller"></xsl:param>
		<!-- puid is used to assign unique id -->
		<xsl:variable name="guid"><xsl:value-of select="$puid"/><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM :End - D021 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
			<xsl:when test="$caller = 'inline'">
				<xsl:attribute name="id">prompttext_<xsl:value-of select="$guid"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="@alert='true'">
						<span>
						  <xsl:value-of select="$strInstructions"/>
						</span>
						<xsl:value-of select="."/>
					</xsl:when>
					<xsl:otherwise>
            <xsl:choose>
              <xsl:when test ="@instructions='true'">
              </xsl:when>
              <xsl:otherwise>
                <span>
                  <xsl:value-of select="$strInstructions"/>
                </span>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
			<div class="table_container"> 
				<div class="container"> 
					<div class="container_top_right"> 
						<div class="container_top_left"> 
							<div class="container_gradient"> 
								<div class="container_title"><xsl:value-of select="$strInstructions"/></div> 
							</div> 
						</div> 
					</div> 
					<div class="container_right"> 
						<div class="container_left"> 
							<div class="container_content instructions"> 
								<div class="container_item"><xsl:value-of select="."/></div> 
							</div> 
						</div> 
					</div> 
					<div class="container_bottom_right"> 
						<div class="container_bottom_left"> 
							<div class="container_bottom"> </div> 
						</div> 
					</div> 
				</div>			
			</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
  <xsl:template match="AlertMessage">
    <!-- MM :Begin - D021 - fix for id issue -->
    <xsl:param name="puid" select="1"></xsl:param>
    <xsl:param name="caller"></xsl:param>
    <xsl:param name="status"></xsl:param>
    <!-- puid is used to assign unique id -->
    <xsl:variable name="guid">
      <xsl:value-of select="$puid"/>
      <xsl:value-of select="position()"/>
    </xsl:variable>
    <!-- MM :End - D021 - fix for id issue -->
    <xsl:choose>
      <xsl:when test="@ignoreonweb = 'true'"></xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="@status='2'">
            <div class="table_container">
              <div class="container">
                <div class="ok_container_top_right">
                  <div class="ok_container_top_left">
                    <div class="ok_container_gradient">
                      <div class="alert_container_title">
                        <xsl:value-of select="$strSuccess"/>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="ok_container_right">
                  <div class="ok_container_left">
                    <div class="alert_container_content">
                      <table>
                        <tr>
                          <td class="ok"> </td>
                          <td class="alert_info">
                            <xsl:value-of select="@display"/>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="ok_container_bottom_right">
                  <div class="ok_container_bottom_left">
                    <div class="ok_container_bottom"> </div>
                  </div>
                </div>
              </div>
            </div>
        </xsl:when>
          <xsl:when test="@status='3'">
            <div class="table_container">
              <div class="container">
                <div class="nc_container_top_right">
                  <div class="nc_container_top_left">
                    <div class="nc_container_gradient">
                      <div class="alert_container_title">
                        <xsl:value-of select="$strCaution"/>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="nc_container_right">
                  <div class="nc_container_left">
                    <div class="alert_container_content">
                      <table>
                        <tr>
                          <td class="non-critical"> </td>
                          <td class="alert_info">
                            <xsl:value-of select="@display"/>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="nc_container_bottom_right">
                  <div class="nc_container_bottom_left">
                    <div class="nc_container_bottom"> </div>
                  </div>
                </div>
              </div>
            </div>
          </xsl:when>
          <xsl:when test="@status='4'">
            <div class="table_container">
              <div class="container">
                <div class="c_container_top_right">
                  <div class="c_container_top_left">
                    <div class="c_container_gradient">
                      <div class="alert_container_title">
                        <xsl:value-of select="$strAlert"/>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="c_container_right">
                  <div class="c_container_left">
                    <div class="alert_container_content">
                      <table>
                        <tr>
                          <td class="critical"> </td>
                          <td class="alert_info">
                            <xsl:value-of select="@display"/>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="c_container_bottom_right">
                  <div class="c_container_bottom_left">
                    <div class="c_container_bottom"> </div>
                  </div>
                </div>
              </div>
            </div>
          </xsl:when>
          <xsl:otherwise>
            <div class="table_container">
              <div class="container">
                <div class="info_container_top_right">
                  <div class="info_container_top_left">
                    <div class="info_container_gradient">
                      <div class="alert_container_title">
                        <xsl:value-of select="$strInformation"/>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="info_container_right">
                  <div class="info_container_left">
                    <div class="alert_container_content">
                      <table>
                        <tr>
                          <td class="info"> </td>
                          <td class="alert_info">
                            <xsl:value-of select="@display"/>
                          </td>
                        </tr>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="info_container_bottom_right">
                  <div class="info_container_bottom_left">
                    <div class="info_container_bottom">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
	<xsl:template match="SubHeader">
		<!-- MM :Begin - D025 - fix for id issue -->
		<xsl:param name="puid" select="1"></xsl:param>
		<xsl:param name="tablesubheader"></xsl:param>
		<xsl:param name="dataareasubheader"></xsl:param>
		<!-- puid is used to assign unique id -->
		<xsl:variable name="guid"><xsl:value-of select="$puid"/><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM :End - D025 - fix for id issue -->	
		<xsl:choose>
			<xsl:when test="@ignoreonweb='true'"></xsl:when>
			<xsl:when test="$tablesubheader='true'">
				
			<!-- MM : End - D025 - fix -->
				<div class="table_title">
					<xsl:choose>
						<xsl:when test="@id != ''">
							<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<!-- position is used to keep the id unique -->
							<xsl:attribute name="id">subheader_<xsl:value-of select="$guid"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="@display"/>
				</div>
			</xsl:when>
			<xsl:when test="$dataareasubheader='true' and @display">
			<div class="table_container"> 
				<div class="container"> 
					<div class="container_top_right"> 
						<div class="container_top_left"> 
							<div class="container_gradient"> 
								<div class="container_title"><xsl:value-of select="$strInstructions"/></div> 
							</div> 
						</div> 
					</div> 
					<div class="container_right"> 
						<div class="container_left"> 
							<div class="container_content instructions"> 
								<div class="container_item"><xsl:value-of select="@display"/></div> 
							</div> 
						</div> 
					</div> 
					<div class="container_bottom_right"> 
						<div class="container_bottom_left"> 
							<div class="container_bottom"> </div> 
						</div> 
					</div> 
				</div>			
			</div>
			</xsl:when>
			<xsl:otherwise>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						
						<td align="left" valign="center">
							<!-- MM : Begin - D025 - fix -->
							<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
							<xsl:choose>
								<xsl:when test="@id != ''">
									<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<!-- position is used to keep the id unique -->
									<xsl:attribute name="id">subheader_<xsl:value-of select="$guid"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<!-- MM : End - D025 - fix -->
							<span class="data-area-sub-header">
								<xsl:value-of select="@display"/>
							</span>
						</td>
					</tr>
				</table>
			</xsl:otherwise>

		</xsl:choose>
	</xsl:template>

		<xsl:template match="CustomButton/Data">
			<!-- MM :Begin - D012 - fix for id issue -->
			<xsl:variable name="guid">
				<xsl:choose>
					<xsl:when test="@uid != ''"><xsl:value-of select="@uid"/><xsl:value-of select="position()"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="position()"/><xsl:value-of select="position()"/></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<!-- MM :End - D012 - fix for id issue -->
			<xsl:call-template name="button_details">
				<xsl:with-param name="href">
					<xsl:choose>
						<xsl:when test="@name='Refresh'">
							<xsl:choose>
								<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
								<xsl:when test="@href"><xsl:if test="@href!=''"><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:if></xsl:when>
								<xsl:otherwise>#</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="onclick">
					<xsl:choose>
						<xsl:when test="@onclick"><xsl:value-of select="@onclick"/></xsl:when>
						<xsl:when test="@name='Refresh'">
							<xsl:choose>
								<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
								<xsl:when test="@href"></xsl:when>
								<xsl:otherwise>javascript:location.reload ()</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="formSubmit"><xsl:value-of select="@formSubmit"/></xsl:with-param>
				<xsl:with-param name="display"><xsl:value-of select="@display"/></xsl:with-param>
				<!-- MM : Begin - D012 - Fix for id issue -->
				<xsl:with-param name="id">
					<xsl:choose>
						<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
						<xsl:otherwise>custombutton_<xsl:value-of select="$guid"/></xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="name"><xsl:value-of select="@name"/></xsl:with-param>
					<!-- MM : End - D012 - Fix for id issue -->
			</xsl:call-template>
	
	</xsl:template>

	
	<xsl:template match="CustomButton">
		<!-- MM :Begin - D012 - fix for id issue -->
		<xsl:variable name="uid"><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM :Begin - D012 - fix for id issue -->
		<xsl:for-each select="Data">
			<xsl:apply-templates select="CustomButton/Data" />
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="CustomMessage">
		<!-- MM : Begin - D022 - Fix for id issue -->
		<xsl:variable name="guid"><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM : End - D022 - Fix for id issue -->
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td style="width: 15px" />
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
					</img>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td class="data-area-canvas">
					<table width="100%" cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td valign="top" align="center" style="width: 16px" class="data-area-canvas">
								<xsl:call-template name="display-status"><xsl:with-param name="status" select="@status" />
									<!-- MM : Begin - D022 - Fix for id issue -->
									<xsl:with-param name="id">img_<xsl:value-of select="guid"/></xsl:with-param>
									<!-- MM : End - D022 - Fix for id issue -->
								</xsl:call-template>
							</td>
							<td style="height: 10px" class="data-area-canvas">
								<img   style="width: 1px; height: 1px"/>
							</td>
							<!-- MM : Begin - D022 - fix for id issue -->
							<th valign="top" align="left" class="data-area-header">
								<xsl:choose>
									<xsl:when test="@id != ''">
										<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<!-- position is used to keep the id unique -->
										<xsl:attribute name="id">custommessage_<xsl:value-of select="$guid"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="."/>
							</th>
							<!-- MM : End - D022 - fix for id issue -->
						</tr>
					</table>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
					</img>

				</td>
				<td style="width: 15px" />
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="CustomTable">
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td style="width: 15px" />
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
					</img>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td class="data-area-canvas">
					<table width="100%" cellpadding="0" cellspacing="1" border="0">
						<xsl:if test="Header">
							<tr>
								<td valign="top" align="center" style="width: 20px" class="data-area-canvas"></td>
								<td valign="top" align="center" style="width: 16px" class="data-area-canvas"></td>
								<xsl:for-each select="Header/Data">
									<th valign="top" align="left" class="data-area-header"><xsl:value-of select="."/></th>
								</xsl:for-each>
							</tr>
							<tr>
								<td style="height: 1px" class="data-area-separator"><img   style="width: 1px; height: 1px"/></td>
								<td style="height: 1px" class="data-area-separator"><img   style="width: 1px; height: 1px"/></td>
								<xsl:for-each select="Header/Data">
									<td style="height: 1px" class="data-area-separator"><img   style="width: 1px; height: 1px"/></td>
								</xsl:for-each>
							</tr>
							<tr>
								<td style="height: 3px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
								<td style="height: 3px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
								<xsl:for-each select="Header/Data">
									<td style="height: 3px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
								</xsl:for-each>
							</tr>
						</xsl:if>
						<xsl:for-each select="CustomRow">
							<xsl:variable name="numofcolitems" select="count(ColumnItem)"/>
							<xsl:variable name="name"><xsl:value-of select="@name"/></xsl:variable>
							<tr>
								<td valign="top" align="left" style="width: 20px" class="data-area-canvas">
									<a>
										<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
										<xsl:attribute name="href">#<xsl:value-of select="@name"/></xsl:attribute>
										<xsl:attribute name="onclick">javascript:changeStateTbl('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', '<xsl:value-of select="$numofcolitems"/>')</xsl:attribute>
										<img>
											<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif</xsl:attribute>
											<xsl:attribute name="id">image_<xsl:value-of select="@name"/></xsl:attribute>
										</img>
									</a>
			    				</td>
								<td valign="top" align="center" style="width: 16px" class="data-area-background">
									<xsl:call-template name="display-status"><xsl:with-param name="status" select="@status" /></xsl:call-template>
								</td>
								<xsl:for-each select="ColumnItem">
									<xsl:variable name="pos"><xsl:value-of select="position()"/></xsl:variable>
									<td valign="top" align="left" class="data-area-background"><xsl:value-of select="@header"/>
										<div style="display:none">
											<xsl:attribute name="id">div<xsl:value-of select="$pos"/><xsl:value-of select="$name"/></xsl:attribute>
											<table width="100%" border="0" cellspacing="1" cellpadding="1">
												<xsl:for-each select="Row">
													<tr>
														<xsl:for-each select="Data">
															<td class="data-area-canvas" valign="top" align="left" style="width: 30%">
																<xsl:choose>
																	<xsl:when test="ValueList">
																		<xsl:for-each select="ValueList/value"><xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if></xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
																</xsl:choose>
															</td>
														</xsl:for-each>
													</tr>
												</xsl:for-each>
											</table>
										</div>
									</td>
								</xsl:for-each>
							</tr>
						</xsl:for-each>
					</table>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
					</img>
				</td>
				<td style="width: 15px" />
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="ProgressBar">
		<xsl:choose>
			<xsl:when test="@uidata='true'">
				<xsl:if test="UIData/Title">
					<table border='0' cellpadding='0' cellspacing='0'>
						<tr>
							<td style='width: 15px'> </td>
							<td class='data-area-title' align='left' valign='middle'><xsl:value-of select="UIData/Title"/></td>
						</tr>
					</table>
				</xsl:if>
							
			<!-- C68431 - Adding support for Multiple Interrupt Actions. -->
				<!--C86792 Change width to 200-->
				<table width="200" border="0" cellpadding="1" cellspacing="1">
					<tr>
						<td style="width: 15px">
							<img alt=""   style="height: 1px; width: 15px"/>
						</td>
						<xsl:for-each select="UIData/InterruptAction">
							<td style="width: 120px" align="left" valign="middle">
								<div>
								<xsl:attribute name="id"><xsl:value-of select="@action"/>button</xsl:attribute>
									<xsl:choose>
										<!-- suspend/resume actions will have hide attrib -->
										<xsl:when test="@hide">
											<xsl:choose>
												<xsl:when test="@hide='true'">
													<xsl:attribute name="style">DISPLAY: none</xsl:attribute>					
												</xsl:when>
												<xsl:when test="@hide='false'">
														<xsl:attribute name="style">DISPLAY: </xsl:attribute>
												</xsl:when>
											</xsl:choose>										
										</xsl:when>
										<!-- abort action will not have hide attrib -->
										<xsl:otherwise> 
											<xsl:choose>
												<xsl:when test="@href != ''">
													<xsl:attribute name="style">DISPLAY: </xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="style">DISPLAY: none</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
									
									<xsl:call-template name="button">
										<xsl:with-param name="href">javascript:buttonCall('<xsl:value-of select="@action"/>','<xsl:value-of select="@href"/>')</xsl:with-param>
										<xsl:with-param name="id">pgbar<xsl:value-of select="@action"/>intaction</xsl:with-param>
										<xsl:with-param name="display"><xsl:value-of select="@display"/></xsl:with-param>
									</xsl:call-template>
								</div>
							</td>
						</xsl:for-each>
					</tr>
				</table>
						
				<!-- Old code to be deleted -->			
				<!--<xsl:if test="UIData/InterruptAction">
					<div  id="abortbutton">
						<xsl:choose>
							<xsl:when test="UIData/InterruptAction/@href != ''">
								<xsl:attribute name="style">DISPLAY: </xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="style">DISPLAY: none</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<table width='200' border='0' cellpadding='0' cellspacing='0'>
							<tr>
								<td style='width: 15px'><img alt='' src='' style="height: 1px; width: 15px"/></td>
								<td style='width: 185px' align='left' valign='middle'>
									<xsl:call-template name="button">
										<xsl:with-param name="href">javascript:buttonCall()</xsl:with-param>
										<xsl:with-param name="id">pgbarintaction</xsl:with-param>
										<xsl:with-param name="display"><xsl:value-of select="UIData/InterruptAction/@display"/></xsl:with-param>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</div>
					<br/>
				</xsl:if> -->
				
				<xsl:if test="UIData/Result"><xsl:value-of select="ProgressBar/UIData/Result/@href"/>
					<div  id="resultbutton" style="DISPLAY: none">
						<!--C86792 Change width to 200-->
						<table width='200' border='0' cellpadding='0' cellspacing='0'>
							<tr>
								<td style='width: 15px'><img alt='' src='' style="height: 1px; width: 15px"/></td>
								<td style='width: 185px' align='left' valign='middle'>
									<xsl:call-template name="button">
										<xsl:with-param name="href"><xsl:value-of select="UIData/Result/@href"/></xsl:with-param>
										<xsl:with-param name="id">pgbarresult</xsl:with-param>
										<xsl:with-param name="display"><xsl:value-of select="UIData/Result/@display"/></xsl:with-param>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</div>
				</xsl:if>
				<table summary='' width='555' cellpadding='0' cellspacing='0' border='0'>
					<tr>
						<td style='width: 15px' rowspan='3'><img alt='' src='' style="height: 1px; width: 15px"/></td>
						<td style='width 10px; height: 10px'>
							<img alt='' style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
							</img>
						</td>
						<td style='width: 100%; height: 10px' class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
						<td style='width 10px; height: 10px'>
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
							</img>
						</td>
					</tr>
					<tr>
						<td class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
							<td class='data-area-canvas' align='left' valign='middle'>
								<table summary='' border='0' cellpadding='0' cellspacing='0'>
									<xsl:apply-templates select="UIData"/>
								</table>
							</td>
						<td class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
					</tr>
					<tr>
						<td style='width: 10px; height: 10px'>
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
							</img>
						</td>
						<td style='width: 40%; height: 10px' class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
						<td style='width: 10px; height: 10px'>
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
							</img>
						</td>
					</tr>
				</table>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="UIData">
		<xsl:apply-templates	/>
	</xsl:template>
	<xsl:template match="ProgressBarList">
		<xsl:apply-templates	/>
	</xsl:template>
	<xsl:template match="UIBar">
		<tr>
		<td class='data-area-canvas' align='left' valign='middle'>
			<table border='0' cellpadding='0' cellspacing='0'>
				<tr>
					<td class='data-area-background' colspan='79' align='left' valign='middle'>
						<img alt='' src='' style="width: 1px; height: 1px"/>
						<div id='titleText'><xsl:value-of select="@display"/></div>
					</td>
					<td class='data-area-background' colspan='2' align='left' valign='middle' width='200px'>
						<!-- MOH change 75429 . Only display pass if number of passes greater than 0 -->
						<div style='font-size: 8pt'>
							<xsl:attribute name="id">statusPass<xsl:value-of select="@name"/></xsl:attribute>
						</div>
					</td>
				</tr>
				<tr>
					<td style='height: 1px' class='data-area-canvas' colspan='81'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				</tr>
				<tr>
					<td style='width: 40px; height: 23px' class='data-area-background' rowspan='5' align='center' valign='middle'>
						<div style='font-size: 8pt'><xsl:attribute name="id">statusPercentage<xsl:value-of select="@name"/></xsl:attribute>0%</div>
					</td>
					<td style='width: 1px; height: 1px' class='data-area-shadow'>
						<img alt='' src='' style="width: 1px; height: 1px"/>
					</td>
					<td style='width: 350px; height: 1px' class='data-area-shadow' colspan='75'>
						<img alt='' src='' style="width: 1px; height: 1px"/>
					</td>
					<td style='width: 1px; height: 1px' class='data-area-background'>
						<img alt='' src='' style="width: 1px; height: 1px"/>
					</td>
					<td style='width: 30px; height: 23px' class='data-area-canvas' rowspan='5' align='center' valign='middle'>
						<img src='/oma/images/blank.gif'>
							<xsl:attribute name="id">statusImage<xsl:value-of select="@name"/></xsl:attribute>
						</img>
					</td>
					<td style='width: 55px' class='data-area-canvas' rowspan='5' align='center' valign='middle'>
						<div><xsl:attribute name="id">statusText<xsl:value-of select="@name"/></xsl:attribute></div>
					</td>
				</tr>
				<tr>
					<td style='width: 1px; height: 21px' class='data-area-shadow' rowspan='3'><img alt='' src='' style="width: 1px; height: 1px"/></td>
					<td style='width: 350px; height: 1px' class='data-area-canvas' colspan='75'><img alt='' src='' style="width: 1px; height: 1px"/></td>
					<td style='width: 1px; height: 21px' class='data-area-background' rowspan='3'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				</tr>
				<tr>
					<xsl:call-template name="draw_bars">
						<xsl:with-param name="index" select="1" />
					</xsl:call-template>
				</tr>
				<tr>
					<td style='width: 350px; height: 1px' class='data-area-canvas' colspan='75'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				</tr>
				<tr>
				    <td style='width: 1px; height: 1px' class='data-area-background'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				    <td style='width: 350x; height: 1px' class='data-area-background' colspan='75'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				    <td style='width: 1px; height: 1px' class='data-area-background'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				</tr>
				<tr>
					<td style='height: 7px' class='data-area-canvas' colspan='81'><img alt='' src='' style="width: 1px; height: 7px"/></td>
				</tr>
				</table>
		</td>
		</tr>
	</xsl:template>
	<xsl:template name="draw_bars">
		<xsl:param name="index" />
			<xsl:if test="$index &lt; 26">
				<td style='width: 1px; height: 19px' class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				<td style='width: 12px; height: 19px' class='data-area-canvas' align='center' valign='middle'>
					<xsl:attribute name="id">bar<xsl:value-of select="$index" />_<xsl:value-of select="@name"/></xsl:attribute>
					<img alt='' src='/oma/images/blank.gif' style="width: 12px; height: 19px"/>
				</td>
				<td style='width: 1px; height: 19px' class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				<xsl:call-template name="draw_bars">
					<xsl:with-param name="index" select="$index + 1" />
				</xsl:call-template>
			</xsl:if>
	</xsl:template>
	<xsl:template match="TextArea">
		<table>
			<tr>
				<td style="width: 10px" />
				<td>
					<!-- MM : Begin - D027 - fix for id issue -->
					<xsl:attribute name="id">header_<xsl:value-of select="position()"/></xsl:attribute>
					<!-- MM : End - D027 - fix for id issue -->
					<xsl:value-of select="@display"/></td>
			</tr>
		</table>
		<table>
			<tr>
				<xsl:choose>
							<xsl:when test="@name = 'csrcontent'">
								<td style="width: 30px" />

							</xsl:when>
							<xsl:otherwise>
								<td style="width: 10px" />
								
							</xsl:otherwise>
						</xsl:choose>


				<td>
					<textarea>
						<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
						<!-- MM : Begin - D027 - fix for id issue -->
						<!-- xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute -->
						<xsl:choose>
							<xsl:when test="@id != ''">
								<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<!-- position is used to keep the id unique -->
								<xsl:attribute name="id"><xsl:value-of select="@name"/>_<xsl:value-of select="position()"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<!-- MM : End - D027 - fix for id issue -->						
						<xsl:attribute name="rows"><xsl:value-of select="@rows"/></xsl:attribute>
						<xsl:attribute name="cols"><xsl:value-of select="@cols"/></xsl:attribute>
						<xsl:if test="@state = '2'">
							<xsl:attribute name="disabled"/>
						</xsl:if>
						<xsl:value-of select="@value"/>
					</textarea>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="HTMLData">
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="Guage">
		<!-- MM :Begin - D026 - fix for id issue -->
		<xsl:variable name="table_id">
			<xsl:choose>
				<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM :End - D026 - fix for id issue -->
    <!--table for the gauge itself-->
    <div class="table_container">
      <div class="container mw650">
        <div class="container_top_right">
          <div class="container_top_left">
            <div class="container_gradient">
              <div class="container_title">
                <xsl:apply-templates select="SubHeader">
                </xsl:apply-templates>
              </div>
            </div>
          </div>
        </div>
        <!--table for the inner gauge structure -->
        <div class="container_right">
          <div class="container_left">
            <div class="thermometer_container">
              <div class="thermometer_left">
                <div class="thermometer">
                  <div class="thermometer_outline">  </div>
                  <div class="thermometer_critical"> </div>
                  <div class="thermometer_warning" id="thermometer_critical" style="bottom: 6%; height: 88%"> </div>
                  <div class="thermometer_good" id="thermometer_warning" style="bottom: 16%; height: 64%;">  </div>
                  <div class="thermometer_marker" id="thermometer_marker" style="bottom: 50%;"> </div>
                  <xsl:if  test="(Probe ='Temperature')"> 
				<div class="marker_text" id="marker_text" style="bottom: 50%;"><xsl:value-of select="Reading"/><xsl:value-of select="$strUnit"/> - <xsl:value-of select="$strCurrentReading"/></div>
 				<div class="upper_failure" id="upper_failure" style="bottom: 14%; height:0%;"><xsl:value-of select="MXFThresh"/><xsl:value-of select="$strUnit"/> - <xsl:value-of select="$strMaxFailureThreshold"/></div>
                  	<div class="lower_failure" id="lower_failure" style="bottom: 6%;"><xsl:value-of select="MFThresh"/><xsl:value-of select="$strUnit"/> - <xsl:value-of select="$strMinFailureThreshold"/></div>
                  	<div class="lower_warning" id="lower_warning" style="bottom: 16%;"><xsl:value-of select="MWThresh"/><xsl:value-of select="$strUnit"/> - <xsl:value-of select="$strMinWarningThreshold"/></div>
                  	<div class="upper_warning" id="upper_warning" style="bottom: 66%; "><xsl:value-of select="MXWThresh"/><xsl:value-of select="$strUnit"/> - <xsl:value-of select="$strMaxWarningThreshold"/></div>

			</xsl:if>


             <xsl:if  test="(Probe ='PowerMon')"> 
				<div class="marker_text" id="marker_text" style="bottom: 50%;"><xsl:value-of select="Reading"/><xsl:value-of select="$strWatt"/> - <xsl:value-of select="$strCurrentReading"/></div>
 				<div class="upper_failure" id="upper_failure" style="bottom:19%;"><xsl:value-of select="MXFThresh"/><xsl:value-of select="$strWatt"/> - <xsl:value-of select="$strFailureThreshold"/></div>

                 		 <div class="lower_failure" id="lower_failure" style="bottom: 6%;"></div>
                  	<div class="lower_warning" id="lower_warning" style="bottom: 16%;"></div>
                  	<div class="upper_warning" id="upper_warning" style="bottom: 66%; "><xsl:value-of select="MXWThresh"/><xsl:value-of select="$strWatt"/> - <xsl:value-of select="$strWarningThreshold"/></div>

		</xsl:if>


  		<xsl:if  test="(Probe ='Fans')"> 
				<div class="marker_text" id="marker_text" style="bottom: 50%;"><xsl:value-of select="Reading"/><xsl:value-of select="$strRPM"/> - <xsl:value-of select="$strReading"/></div>
 				<div class="upper_failure" id="upper_failure" style="bottom: 14%; height:19%;"><xsl:value-of select="MXFThresh"/><xsl:value-of select="$strRPM"/> - <xsl:value-of select="$strMaxFailureThreshold"/></div>
                  	<div class="lower_failure" id="lower_failure" style="bottom: 6%;"><xsl:value-of select="MFThresh"/><xsl:value-of select="$strRPM"/> - <xsl:value-of select="$strMinFailureThreshold"/></div>
                  	<div class="lower_warning" id="lower_warning" style="bottom: 16%;"><xsl:value-of select="MWThresh"/><xsl:value-of select="$strRPM"/> - <xsl:value-of select="$strMinWarningThreshold"/></div>
                  	<div class="upper_warning" id="upper_warning" style="bottom: 66%; "><xsl:value-of select="MXWThresh"/><xsl:value-of select="$strRPM"/> - <xsl:value-of select="$strMaxWarningThreshold"/></div>

			</xsl:if>

		<xsl:if  test="(Probe ='PowerSup')"> 
				<div class="marker_text" id="marker_text" style="bottom: 50%;"><xsl:value-of select="Reading"/><xsl:value-of select="$strAmps"/> - <xsl:value-of select="$strReading"/></div>
 				<div class="upper_failure" id="upper_failure" style="bottom: 14%; height:19%;"><xsl:value-of select="MXFThresh"/><xsl:value-of select="$strAmps"/> - <xsl:value-of select="$strMaxFailureThreshold"/></div>
                  	<div class="lower_failure" id="lower_failure" style="bottom: 6%;"><xsl:value-of select="MFThresh"/><xsl:value-of select="$strAmps"/> - <xsl:value-of select="$strMinFailureThreshold"/></div>
                  	<div class="lower_warning" id="lower_warning" style="bottom: 16%;"><xsl:value-of select="MWThresh"/><xsl:value-of select="$strAmps"/> - <xsl:value-of select="$strMinWarningThreshold"/></div>
                  	<div class="upper_warning" id="upper_warning" style="bottom: 66%; "><xsl:value-of select="MXWThresh"/><xsl:value-of select="$strAmps"/> - <xsl:value-of select="$strMaxWarningThreshold"/></div>

			</xsl:if>
		<xsl:if  test="(Probe ='Volts')"> 
				<div class="marker_text" id="marker_text" style="bottom: 50%;"><xsl:value-of select="Reading"/><xsl:value-of select="$strVolt"/> - <xsl:value-of select="$strReading"/></div>
 				<div class="upper_failure" id="upper_failure" style="bottom: 14%; height:19%;"><xsl:value-of select="MXFThresh"/><xsl:value-of select="$strVolt"/> - <xsl:value-of select="$strMaxFailureThreshold"/></div>
                  	<div class="lower_failure" id="lower_failure" style="bottom: 6%;"><xsl:value-of select="MFThresh"/><xsl:value-of select="$strVolt"/> - <xsl:value-of select="$strMinFailureThreshold"/></div>
                  	<div class="lower_warning" id="lower_warning" style="bottom: 16%;"><xsl:value-of select="MWThresh"/><xsl:value-of select="$strVolt"/> - <xsl:value-of select="$strMinWarningThreshold"/></div>
                  	<div class="upper_warning" id="upper_warning" style="bottom: 66%; "><xsl:value-of select="MXWThresh"/><xsl:value-of select="$strVolt"/> - <xsl:value-of select="$strMaxWarningThreshold"/></div>

			</xsl:if>



                   

 
                </div>
              </div>
                <div class="groupbox_padding thermometer_right">
                  <div class="groupbox_position">
                    <div class="groupbox_title"><xsl:value-of select="$strThresholdSettings"/>
                    </div>
                    <div class="groupbox_outer">
                      <div class="groupbox_inner">
                        <table class="infolist">
                          <xsl:for-each select="ListData/Data">
                            <!-- MM :Begin - D026 - fix for id issue -->
                            <xsl:variable name="row_id">
                              <xsl:number count="node()" level="single"/>
                            </xsl:variable>
                            <xsl:variable name="guid">
                              <xsl:value-of select="$table_id"/>_row<xsl:value-of select="$row_id"/>
                            </xsl:variable>
                            <!-- MM :End - D026 - fix for id issue -->
                            <xsl:choose>
                              <xsl:when test="@type = 'radio'">
                                <tr>
                                  <td class="normal bold">
                                    <!-- MM :Begin - D0261 - fix for id issue -->
                                    <xsl:choose>
                                      <xsl:when test="@id != ''">
                                        <xsl:attribute name="id">
                                          name_<xsl:value-of select="@id"/>
                                        </xsl:attribute>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:attribute name="id">
                                          name_<xsl:value-of select="@name"/>
                                        </xsl:attribute>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                    <!-- MM :End - D0261 - fix for id issue -->
                                    <xsl:value-of select="@display"/>
                                  </td>
                                  <td class="nowrap inline">
                                    <input type="radio">
                                      <!--C88676 fix smallfont font size -->
                                      <xsl:attribute name="class">radio</xsl:attribute>
                                      <xsl:if test="@state=1">
                                        <xsl:attribute name="checked"/>
                                      </xsl:if>
                                      <xsl:if test="@state=2">
                                        <xsl:attribute name="disabled"/>
                                      </xsl:if>
                                      <xsl:if test="@state=3">
                                        <xsl:attribute name="disabled"/>
                                        <xsl:attribute name="checked"/>
                                      </xsl:if>
                                      <xsl:attribute name="name">
                                        <xsl:value-of select="@name"/>
                                      </xsl:attribute>
                                      <!-- MM :Begin - D0261 - fix for id issue -->
                                      <!-- xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute -->
                                      <xsl:choose>
                                        <xsl:when test="@id != ''">
                                          <xsl:attribute name="id">
                                            <xsl:value-of select="@id"/>
                                          </xsl:attribute>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:attribute name="id">
                                            <xsl:value-of select="@name"/>
                                          </xsl:attribute>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                      <!-- MM :End - D0261 - fix for id issue -->
                                      <xsl:attribute name="value">
                                        <xsl:value-of select="@returnvalue"/>
                                      </xsl:attribute>
                                      <xsl:attribute name="onClick">
                                        <xsl:value-of select="@handler"/>
                                      </xsl:attribute>
                                      <xsl:value-of select="@value"/>
                                    </input>
                                  </td>
                                </tr>
                              </xsl:when>
                              <xsl:when test="@type = 'editbox'">
                                <tr>
                                  <td class="normal">
                                    <!-- MM :Begin - D0262 - fix for id issue -->
                                    <xsl:choose>
                                      <xsl:when test="@id != ''">
                                        <xsl:attribute name="id">
                                          name_<xsl:value-of select="@id"/>
                                        </xsl:attribute>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:attribute name="id">
                                          name_<xsl:value-of select="@textboxname"/>
                                        </xsl:attribute>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                    <!-- MM :End - D0262 - fix for id issue -->
                                    <xsl:value-of select="@display"/>
                                  </td>
                                  <td class="nowrap inline">
                                    <xsl:attribute name="align">
                                      <xsl:value-of select="@align"/>
                                    </xsl:attribute>
                                    <xsl:attribute name="width">
                                      <xsl:value-of select="@width"/>
                                    </xsl:attribute>
                                    <input size="7">
                                      <!--C88676 fix smallfont font size -->
                                      <xsl:attribute name="name">
                                        <xsl:value-of select="@textboxname"/>
                                      </xsl:attribute>
                                      <!-- MM :Begin - D0262 - fix for id issue -->
                                      <!-- xsl:attribute name="id"><xsl:value-of select="@textboxname"/></xsl:attribute -->
                                      <xsl:choose>
                                        <xsl:when test="@id != ''">
                                          <xsl:attribute name="id">
                                            <xsl:value-of select="@id"/>
                                          </xsl:attribute>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:attribute name="id">
                                            <xsl:value-of select="@textboxname"/>
                                          </xsl:attribute>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                      <!-- MM :End - D0262 - fix for id issue -->
                                      <xsl:attribute name="value">
                                        <xsl:value-of select="@textboxvalue"/>
                                      </xsl:attribute>
                                      <xsl:value-of select="@unit"/>
                                      <xsl:if test="@maxlength">
                                        <xsl:attribute name="maxlength">
                                          <xsl:value-of select="@maxlength"/>
                                        </xsl:attribute>
                                      </xsl:if>
                                    </input>
                                  </td>
                                </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:choose>
                                  <xsl:when test="@reading='true'">
                                    <tr>
                                      <td class="item">
                                        <span class="current_reading">
                                        <!-- MM :Begin - D0263 - fix for id issue -->
                                        <xsl:choose>
                                          <xsl:when test="@id != ''">
                                            <xsl:attribute name="id">
                                              name_<xsl:value-of select="@id"/>
                                            </xsl:attribute>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:attribute name="id">
                                              name_<xsl:value-of select="@name"/>
                                            </xsl:attribute>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                        <!-- MM :End - D0263 - fix for id issue -->
                                        <xsl:value-of select="@display"/>
                                        </span>
                                      </td>
                                      <td>
                                        <span class="current_reading">
                                          <!-- MM :Begin - D0263 - fix for id issue -->
                                          <xsl:choose>
                                            <xsl:when test="@id != ''">
                                              <xsl:attribute name="id">
                                                <xsl:value-of select="@id"/>
                                              </xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:attribute name="id">
                                                value_<xsl:value-of select="$guid"/>
                                              </xsl:attribute>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                          <!-- MM :End - D0263 - fix for id issue -->
                                          <xsl:value-of select="@value"/>
                                        </span>
                                      </td>
                                    </tr>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <tr>
                                      <!--C88676 fix smallfont font size -->
                                      <td class="item">
                                        <span>
                                          <!-- MM :Begin - D0263 - fix for id issue -->
                                          <xsl:attribute name="id">
                                            name_<xsl:value-of select="$guid"/>
                                          </xsl:attribute>
                                          <!-- MM :End - D0263 - fix for id issue -->
                                          <xsl:value-of select="@display"/>
                                        </span>
                                      </td>
                                      <td>
                                          <!-- MM :Begin - D0263 - fix for id issue -->
                                          <xsl:choose>
                                            <xsl:when test="@id != ''">
                                              <xsl:attribute name="id">
                                                <xsl:value-of select="@id"/>
                                              </xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:attribute name="id">
                                                value_<xsl:value-of select="$guid"/>
                                              </xsl:attribute>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                          <!-- MM :End - D0263 - fix for id issue -->
                                          <xsl:choose>
                                            <xsl:when test="@align">
                                              <xsl:attribute name="align">
                                                <xsl:value-of select="@align"/>
                                              </xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:attribute name="align">left</xsl:attribute>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                          <xsl:choose>
                                            <xsl:when test="@type = 'status-text'">
                                              <xsl:call-template name="display-status-text">
                                                <xsl:with-param name="status" select="@value" />
                                              </xsl:call-template>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:value-of select="@value"/>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                      </td>
                                    </tr>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:for-each>
                          <xsl:for-each select="TableData/Row">
                            <tr>
                              <xsl:for-each select="Data">
                                <xsl:variable name="row_id">
                                  <xsl:number count="node()" level="single"/>
                                </xsl:variable>
                                <xsl:variable name="guid">
                                  <xsl:value-of select="$table_id"/>_row<xsl:value-of select="$row_id"/>
                                </xsl:variable>
                                <xsl:choose>
                                  <xsl:when test="@type = 'radio'">
                                    <td class="normal bold">
                                      <xsl:choose>
                                        <xsl:when test="@id != ''">
                                          <xsl:attribute name="id">
                                            name_<xsl:value-of select="@id"/>
                                          </xsl:attribute>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:attribute name="id">
                                            name_<xsl:value-of select="@name"/>
                                          </xsl:attribute>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                      <xsl:value-of select="@display"/>
                                    </td>
                                    <td class="inline">
                                      <input type="radio">
                                        <!--C88676 fix smallfont font size -->
                                        <xsl:attribute name="class">radio</xsl:attribute>
                                        <xsl:if test="@state=1">
                                          <xsl:attribute name="checked"/>
                                        </xsl:if>
                                        <xsl:if test="@state=2">
                                          <xsl:attribute name="disabled"/>
                                        </xsl:if>
                                        <xsl:if test="@state=3">
                                          <xsl:attribute name="disabled"/>
                                          <xsl:attribute name="checked"/>
                                        </xsl:if>
                                        <xsl:attribute name="name">
                                          <xsl:value-of select="@name"/>
                                        </xsl:attribute>
                                        <xsl:choose>
                                          <xsl:when test="@id != ''">
                                            <xsl:attribute name="id">
                                              <xsl:value-of select="@id"/>
                                            </xsl:attribute>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:attribute name="id">
                                              <xsl:value-of select="@name"/>
                                            </xsl:attribute>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:attribute name="value">
                                          <xsl:value-of select="@returnvalue"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="onClick">
                                          <xsl:value-of select="@handler"/>
                                        </xsl:attribute>
                                        <xsl:value-of select="@value"/>
                                      </input>
                                    </td>
                                  </xsl:when>
                                  <xsl:when test="@type = 'editbox'">
                                    <xsl:choose>
                                      <xsl:when test="@display != ''">
                                        <td class="normal">
                                          <xsl:choose>
                                            <xsl:when test="@id != ''">
                                              <xsl:attribute name="id">
                                                name_<xsl:value-of select="@id"/>
                                              </xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:attribute name="id">
                                                name_<xsl:value-of select="@textboxname"/>
                                              </xsl:attribute>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                          <xsl:value-of select="@display"/>
                                        </td>
                                      </xsl:when>
                                    </xsl:choose>
                                    <td class="nowrap inline">
                                      <xsl:attribute name="align">
                                        <xsl:value-of select="@align"/>
                                      </xsl:attribute>
                                      <xsl:attribute name="width">
                                        <xsl:value-of select="@width"/>
                                      </xsl:attribute>
                                      <input>
                                        <xsl:choose>
                                          <xsl:when test="@size">
                                            <xsl:attribute name="size">
                                              <xsl:value-of select="@size"/>
                                            </xsl:attribute>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:attribute name="size">7</xsl:attribute>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:if test="@maxlength">
                                          <xsl:attribute name="maxlength">
                                            <xsl:value-of select="@maxlength"/>
                                          </xsl:attribute>
                                        </xsl:if>
                                        <!--C88676 fix smallfont font size -->
                                        <xsl:attribute name="class">data-area</xsl:attribute>
                                        <xsl:if test="@event">
                                          <xsl:attribute name="{@event}">
                                            <xsl:value-of select="@handler"/>
                                          </xsl:attribute>
                                        </xsl:if>
                                        <xsl:attribute name="name">
                                          <xsl:value-of select="@textboxname"/>
                                        </xsl:attribute>
                                        <xsl:choose>
                                          <xsl:when test="@id != ''">
                                            <xsl:attribute name="id">
                                              <xsl:value-of select="@id"/>
                                            </xsl:attribute>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:attribute name="id">
                                              <xsl:value-of select="@textboxname"/>
                                            </xsl:attribute>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:attribute name="value">
                                          <xsl:value-of select="@textboxvalue"/>
                                        </xsl:attribute>
                                        <xsl:value-of select="@unit"/>
                                      </input>
                                    </td>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:choose>
                                      <xsl:when test="@reading='true'">
                                        <!--tr-->
                                        <td class="item">
                                          <span class="current_reading">
                                            <xsl:choose>
                                              <xsl:when test="@id != ''">
                                                <xsl:attribute name="id">
                                                  name_<xsl:value-of select="@id"/>
                                                </xsl:attribute>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                <xsl:attribute name="id">
                                                  name_<xsl:value-of select="@name"/>
                                                </xsl:attribute>
                                              </xsl:otherwise>
                                            </xsl:choose>
                                            <xsl:value-of select="@display"/>
                                          </span>
                                        </td>
                                        <td>
                                          <xsl:choose>
                                            <xsl:when test="@id != ''">
                                              <xsl:attribute name="id">
                                                <xsl:value-of select="@id"/>
                                              </xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:attribute name="id">
                                                value_<xsl:value-of select="$guid"/>
                                              </xsl:attribute>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                          <xsl:value-of select="@value"/>
                                        </td>
                                        </xsl:when>
                                      <xsl:otherwise>
                                        <!--tr-->
                                        <!--C88676 fix smallfont font size -->
                                        <td class="item">
                                          <span>
                                            <xsl:attribute name="id">
                                              name_<xsl:value-of select="$guid"/>
                                            </xsl:attribute>
                                            <xsl:value-of select="@display"/>
                                          </span>
                                        </td>
                                        <td>
                                          <xsl:choose>
                                            <xsl:when test="@id != ''">
                                              <xsl:attribute name="id">
                                                <xsl:value-of select="@id"/>
                                              </xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:attribute name="id">
                                                value_<xsl:value-of select="$guid"/>
                                              </xsl:attribute>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                          <xsl:choose>
                                            <xsl:when test="@align">
                                              <xsl:attribute name="align">
                                                <xsl:value-of select="@align"/>
                                              </xsl:attribute>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:attribute name="align">left</xsl:attribute>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                          <xsl:choose>
                                            <xsl:when test="@type = 'status-text'">
                                              <xsl:call-template name="display-status-text">
                                                <xsl:with-param name="status" select="@value" />
                                              </xsl:call-template>
                                            </xsl:when>
                                            <xsl:otherwise>
                                              <xsl:value-of select="@value"/>
                                            </xsl:otherwise>
                                          </xsl:choose>
                                        </td>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:for-each>
                            </tr>
                          </xsl:for-each>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
              
            </div>
          </div>
        <div class="container_bottom_right">
          <div class="container_bottom_left">
            <div class="container_bottom">
            </div>
          </div>

        </div>

      </div>
        </div>
      </xsl:template>
	<xsl:template match="ComboData">
    <!-- MM :Begin - D028 - fix for id issue -->
    <xsl:variable name="guid">
      <xsl:choose>
        <xsl:when test="@name != ''">
          <xsl:value-of select="@name"/>
        </xsl:when>
        <xsl:otherwise>
          table<xsl:value-of select="position()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <!-- MM : This value will be used to generate id for back to top -->
    <xsl:variable name="backToTopId" select="$guid"/>
	  <xsl:apply-templates select="ListData">
	  </xsl:apply-templates>
	  <xsl:apply-templates select="TableData">
	  </xsl:apply-templates>
				  
  </xsl:template>
  <xsl:template match="PerformanceData">
		<xsl:if test="@type='uidata'">
			<!-- start processor graphs -->
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">start</xsl:with-param></xsl:call-template>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="left" valign="center">
							<span class="data-area-sub-header">Processor(s)</span>
						</td>
					</tr>
					<xsl:for-each select="UIData/Graph">
						<xsl:call-template name="PerfElement"><xsl:with-param name="type">graph</xsl:with-param><xsl:with-param name="obj">proc</xsl:with-param></xsl:call-template>
					</xsl:for-each>
				</table>
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			<!-- end processor graphs -->
			<!-- start disk -->
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">start</xsl:with-param></xsl:call-template>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="left" valign="center">
							<span class="data-area-sub-header">Disk(s)</span>
						</td>
					</tr>
					<xsl:for-each select="UIData/BoxData/DiskData">
						<xsl:call-template name="PerfElement"><xsl:with-param name="type">box</xsl:with-param><xsl:with-param name="obj">disk</xsl:with-param></xsl:call-template>
					</xsl:for-each>
				</table>
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			<!-- end disk -->
			<!-- start memory -->
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">start</xsl:with-param></xsl:call-template>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="left" valign="center">
							<span class="data-area-sub-header">Memory</span>
						</td>
					</tr>
					<xsl:for-each select="UIData/BoxData/MemData">
						<xsl:call-template name="PerfElement"><xsl:with-param name="type">box</xsl:with-param><xsl:with-param name="obj">mem</xsl:with-param></xsl:call-template>
					</xsl:for-each>
				</table>
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			<!-- end memory -->
			<!-- start network -->
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">start</xsl:with-param></xsl:call-template>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="left" valign="center">
							<span class="data-area-sub-header">Network</span>
						</td>
					</tr>
					<xsl:for-each select="UIData/BoxData/NTWData">
						<xsl:call-template name="PerfElement"><xsl:with-param name="type">box</xsl:with-param><xsl:with-param name="obj">network</xsl:with-param></xsl:call-template>
					</xsl:for-each>
				</table>
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			<!-- end network -->
		</xsl:if>
	</xsl:template>
	<xsl:template name="PerfElement">
		<xsl:param name="type"/>
		<xsl:param name="obj"/>
			<xsl:if test="(position() mod 2)='1'">
				<script language="javascript">
					document.write('&lt;tr&gt;');
				</script>
			</xsl:if>
			<td>
				<table>
					<tr>
						<td>
							<table  cellpadding="0" cellspacing="0" style="border-style: solid; border-left-width:thin; border-right-width:thin ; border-top-width:thin; border-bottom-width:thin; border-color:gray">
								<xsl:if test="$type='graph'">
									<xsl:attribute name="height">200</xsl:attribute>
								</xsl:if>
								<xsl:if test="$obj='mem'">
									<xsl:attribute name="height">165</xsl:attribute>
								</xsl:if>
								<tr>
									<xsl:if test="$type='graph'">
										<td>
											<xsl:call-template name="DrawGraph"/>
										</td>
									</xsl:if>
									<td valign="top">
										<table>
											<tr>
												<td>
													<xsl:apply-templates select="SubHeader">
													</xsl:apply-templates>	
												</td>
											</tr>
											<tr>
												<td>
													<table>
														<tr>
															<td style="width: 10px; height: 10px"></td>
															<td style="height: 10px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
															<td style="width: 10px; height: 10px"></td>
														</tr>
														<tr>
															<td style="width: 10px; height: 10px"></td>
															<td>
															<table>
															<xsl:for-each select="ListData/Data">
															<tr>
																<td ><xsl:value-of select="@display"/>: </td>
																<td width="50">
																<div><xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute><xsl:value-of select="@value"/></div>
																</td>
															</tr>
															</xsl:for-each>
															</table>
															</td>
															<td style="width: 10px; height: 10px"></td>
														</tr>
														<tr>
															<td style="width: 10px; height: 10px"></td>
															<td style="height: 10px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
															<td style="width: 10px; height: 10px"></td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
			<xsl:if test="((position() mod 2)='0') or (position() = last())">
				<script language="javascript">
					document.write('&lt;/tr&gt;');
				</script>
			</xsl:if>
	</xsl:template>
	<xsl:template name="Lozenge">
		<xsl:param name="location"/>
		<xsl:param name="beginpadding">true</xsl:param>
		<xsl:param name="endpadding">true</xsl:param>
		<xsl:param name="ignorespacing">false</xsl:param>
		<xsl:choose>
			<xsl:when test="$location='start'">
				<xsl:if test="$ignorespacing = 'false'">
					<br/>
				</xsl:if>
					<!-- Start outer most lozenge -->
					<script language="javascript">
						document.write('&lt;table width="100%" cellpadding="0" cellspacing="0" border="0"&gt;');
					</script>
						<tr>
							<xsl:if test="$beginpadding = 'true'">
								<td style="width: 15px" />
							</xsl:if>
							<td style="width: 10px; height: 10px">
								<img style="width: 10px; height: 10px">
<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
								</img>
							</td>
							<td style="height: 10px" class="data-area-canvas">
								<img   style="width: 1px; height: 1px"/>
							</td>
							<td style="width: 10px; height: 10px">
								<img style="width: 10px; height: 10px">
<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of 	select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
								</img>
							</td>
							<xsl:if test="$endpadding = 'true'">
								<td style="width: 15px" />
							</xsl:if>
						</tr>
					<script language="javascript">
						document.write('&lt;tr&gt;');
					</script>
							<xsl:if test="$beginpadding = 'true'">
								<td style="width: 15px" />
							</xsl:if>
							<td style="height: 10px" class="data-area-canvas">
								<img   style="width: 1px; height: 1px"/>
							</td>
					<script language="javascript">
						document.write('&lt;td class="data-area-canvas"&gt;');
					</script>
			</xsl:when>
			<xsl:otherwise>
				<script language="javascript">
					document.write('&lt;/td&gt;');
				</script>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<xsl:if test="$endpadding = 'true'">
					<td style="width: 15px" />
				</xsl:if>
			<script language="javascript">
				document.write('&lt;/tr&gt;');
			</script>
			<tr>
				<xsl:if test="$beginpadding = 'true'">
					<td style="width: 15px" />
				</xsl:if>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
					</img>
				</td>
				<xsl:if test="$endpadding = 'true'">
					<td style="width: 15px" />
				</xsl:if>
			</tr>
			<script language="javascript">
				document.write('&lt;/table&gt;');
			</script>
			<!-- End outer most lozenge -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DrawGraph">
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td style="height: 9px; width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
				<td style="background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
				<td style="height: 9px; width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
			</tr>
			<tr>
				<td style="height: 3px; width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
				<td>
					<div>
						<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
						<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
						<table border="0" cellpadding="0" cellspacing="0">
							<xsl:call-template name="insertBars">
								<xsl:with-param name="id" select="@name"/>
								<xsl:with-param name="loop_var" select="1"/>
								<xsl:with-param name="prct" select="(50 - ceiling(@percent div 2))"/>
							</xsl:call-template>
						</table>
					</div>
				</td>
				<td style="height: 3px; width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
			</tr>
			<tr>
				<td style="width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
				<td style="background-color: black; color: #00D500" align="right">
					<div><xsl:attribute name="id"><xsl:value-of select="@name"/>_text</xsl:attribute><xsl:value-of select="@percent"/>%</div>
				</td>
				<td style="width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="insertBars">
		<xsl:param name="id"/>
		<xsl:param name="loop_var"/>
		<xsl:param name="prct"/>
		<xsl:if test="$loop_var &lt; '51'">
			<xsl:choose>
				<xsl:when test="$loop_var &lt; $prct">
					<tr>
						<td style="height: 2px; width: 17px;">
							<div style="background-color: #004000">
								<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$loop_var"/>_1</xsl:attribute>
								<img alt="" src="/oma/images/blank.gif" height="3" width="1"/>
							</div>
						</td>
						<td style="height: 2px; width: 1px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="3" width="1"/></td>
						<td style="height: 2px; width: 17px;">
							<div style="background-color: #004000">
								<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$loop_var"/>_2</xsl:attribute>
								<img alt="" src="/oma/images/blank.gif" height="3" width="1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td style="height: 1px; width: 17px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
						<td style="height: 1px; width: 1px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
						<td style="height: 1px; width: 17px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td style="height: 2px; width: 17px;">
							<div style="background-color: #00DC00">
								<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$loop_var"/>_1</xsl:attribute>
								<img alt="" src="/oma/images/blank.gif" height="3" width="1"/>
							</div>
						</td>
						<td style="height: 2px; width: 1px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="3" width="1"/></td>
						<td style="height: 2px; width: 17px;">
							<div style="background-color: #00DC00">
								<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$loop_var"/>_2</xsl:attribute>
								<img alt="" src="/oma/images/blank.gif" height="3" width="1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td style="height: 1px; width: 17px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
						<td style="height: 1px; width: 1px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
						<td style="height: 1px; width: 17px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="insertBars">
				<xsl:with-param name="id" select="$id"/>
				<xsl:with-param name="loop_var" select="$loop_var + 1"/>
				<xsl:with-param name="prct" select="$prct"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
<xsl:template match="SelectionDataUI">
	<table width="100%" height="100%">
	<tr>
	<td height="5px"></td>
	<td height="5px"></td>
	</tr>
	
		<xsl:choose>
			<xsl:when test="@tile = 'vertical' ">
				<xsl:choose>
					<xsl:when test=" @order='resultfirst' ">
					<tr>
					<td colspan="2">
						<iframe frameborder="0">
							<!--70936 - Adding code to allow user defined IFrame width and height. If user has not defined then take default -->
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@height"><xsl:value-of select="ResultTableUI/@height"/></xsl:when>
									<xsl:otherwise>38%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@width"><xsl:value-of select="ResultTableUI/@width"/></xsl:when>
									<xsl:otherwise>90%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(ResultTableUI/@href, 'javascript') = false"><xsl:value-of select="ResultTableUI/@href"/><xsl:choose><xsl:when test="contains(ResultTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="ResultTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</td>
					</tr>
					<tr>
					<td colspan="2">	
						<iframe frameborder="0">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@height"><xsl:value-of select="SelectionTableUI/@height"/></xsl:when>
									<xsl:otherwise>38%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@width"><xsl:value-of select="SelectionTableUI/@width"/></xsl:when>
									<xsl:otherwise>90%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, 'javascript') = false"><xsl:value-of select="SelectionTableUI/@href"/><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="SelectionTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</td>
					</tr>	
					</xsl:when>
					<!-- Selection Iframe is positioned first by default -->
					<xsl:otherwise>
					<tr>
					<td colspan="2">
						<iframe frameborder="0">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@height"><xsl:value-of select="SelectionTableUI/@height"/></xsl:when>
									<xsl:otherwise>38%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@width"><xsl:value-of select="SelectionTableUI/@width"/></xsl:when>
									<xsl:otherwise>90%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, 'javascript') = false"><xsl:value-of select="SelectionTableUI/@href"/><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="SelectionTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</td>
					</tr>
					<tr>
					<td colspan="2">	
						<iframe frameborder="0">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@height"><xsl:value-of select="ResultTableUI/@height"/></xsl:when>
									<xsl:otherwise>38%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@width"><xsl:value-of select="ResultTableUI/@width"/></xsl:when>
									<xsl:otherwise>90%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(ResultTableUI/@href, 'javascript') = false"><xsl:value-of select="ResultTableUI/@href"/><xsl:choose><xsl:when test="contains(ResultTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="ResultTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</td>
					</tr>	
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- Iframes are tiled horizontally by default -->
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test=" @order='resultfirst' ">
					<tr>
					<td height="400px">
						<iframe frameborder="0" name="ResultFrame" onload="javascript:SetDefaultFrameHeight('ResultFrame');">
							<!-- 70936 - Adding code to allow user defined IFrame width and height. If user has not defined then take default -->
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@height"><xsl:value-of select="ResultTableUI/@height"/></xsl:when>
									<xsl:otherwise>100%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@width"><xsl:value-of select="ResultTableUI/@width"/></xsl:when>
									<xsl:otherwise>100%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
								
							<xsl:if test="ResultTableUI/@hspace">
							<xsl:attribute name="hspace"><xsl:value-of select="ResultTableUI/@hspace"/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="id"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(ResultTableUI/@href, 'javascript') = false"><xsl:value-of select="ResultTableUI/@href"/><xsl:choose><xsl:when test="contains(ResultTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="ResultTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
						</td>
						<td height="400px">
						<iframe frameborder="0" name="SelectionFrame" onload="javascript:SetDefaultFrameHeight('SelectionFrame');">

							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@height"><xsl:value-of select="SelectionTableUI/@height"/></xsl:when>
									<xsl:otherwise>100%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@width"><xsl:value-of select="SelectionTableUI/@width"/></xsl:when>
									<xsl:otherwise>100%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:if test="SelectionTableUI/@hspace">
								<xsl:attribute name="hspace"><xsl:value-of select="SelectionTableUI/@hspace"/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="id"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, 'javascript') = false"><xsl:value-of select="SelectionTableUI/@href"/><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="SelectionTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
						</td>
					</tr>
					</xsl:when>
					<!-- Selection Iframe is positioned first by default -->
					<xsl:otherwise>
					<tr>
					<td>
						<iframe frameborder="0" name="SelectionFrame" onload="javascript:SetDefaultFrameHeight('SelectionFrame');">

							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@height"><xsl:value-of select="SelectionTableUI/@height"/></xsl:when>
									<xsl:otherwise>100%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@width"><xsl:value-of select="SelectionTableUI/@width"/></xsl:when>
									<xsl:otherwise>100%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:if test="SelectionTableUI/@hspace">
								<xsl:attribute name="hspace"><xsl:value-of select="SelectionTableUI/@hspace"/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="id"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, 'javascript') = false"><xsl:value-of select="SelectionTableUI/@href"/><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="SelectionTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</td>
					<td>	
				              	<iframe frameborder="0" name="ResultFrame" onload="javascript:SetDefaultFrameHeight('ResultFrame');">

							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@height"><xsl:value-of select="ResultTableUI/@height"/></xsl:when>
									<xsl:otherwise>100%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@width"><xsl:value-of select="ResultTableUI/@width"/></xsl:when>
									<xsl:otherwise>100%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:if test="ResultTableUI/@hspace">
								<xsl:attribute name="hspace"><xsl:value-of select="ResultTableUI/@hspace"/></xsl:attribute>
							</xsl:if>							
							<xsl:attribute name="id"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(ResultTableUI/@href, 'javascript') = false"><xsl:value-of select="ResultTableUI/@href"/><xsl:choose><xsl:when test="contains(ResultTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="ResultTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</td>
				</tr>		
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</table>	
	</xsl:template>
<xsl:template match="SelectionData">
		<!-- MM :Begin - D035 - fix for id issue -->
		<xsl:variable name="table_id"><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM :End - D035 - fix for id issue -->
		<!--AA Begin CR256287 fix-->
		<xsl:if test="PromptText">
		<xsl:apply-templates select="PromptText"/>
		</xsl:if>
 
		<!--MK CR284310 fix-->
	    <xsl:if test="TableData">		
			<xsl:apply-templates select="TableData"/>
		</xsl:if>

		<!--AA end CR256287 fix-->
		<xsl:choose>
			<xsl:when test="@multitable = 'true' ">
				<div class="table_container">
				<xsl:apply-templates select="SubHeader">
					<!-- MM :Begin - D030- fix for id issue -->
						<xsl:with-param name="tablesubheader" select="'true'" />
					<!-- MM :End - D030- fix for id issue -->
				</xsl:apply-templates>
				
					  <div class="table_gutter">
					  <table border="0" cellpadding="0" cellspacing="0" width="100%" height="100%">
					  <tr>
						<td valign="top">
						<table class="container autolayout" height="100%">
						  <thead>
							<tr>
								<td class="topleft"></td>
								<td align="left" class="top" valign="middle">
									<!--SelectionTable Header table goes here -->
									<table>
										<tr>
											<xsl:for-each select="SelectionTable/Header/Data">
												<td class="top" valign="middle" align="left">
													<xsl:call-template name="calldatatype">
														<!-- MM :Begin - D035 - fix for id issue -->
														<xsl:with-param name="puid">header_<xsl:value-of select="$table_id"/><xsl:value-of select="position()"/></xsl:with-param>
														<!-- MM :End - D035 - fix for id issue -->
													</xsl:call-template>
												</td>
											</xsl:for-each>
										</tr>
									</table>
								</td>
								<td class="topright"></td>
							</tr>
						</thead>
						<tbody>	
						<tr>
							<td class="left"></td>
							<td align="left" class="contents" valign="top">
									<!--SelectionTable Data Tree goes here-->
										<xsl:for-each select="SelectionTable/Row">
											<xsl:call-template name="SelectionDataRow">
												<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
												<!-- MM :Begin - D035 - fix for id issue -->
												<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
												<!-- MM :End - D035 - fix for id issue -->
											</xsl:call-template>
										</xsl:for-each>
							</td>
							<td class="right"></td>
						</tr>
						</tbody>
						<tfoot> 
							<tr>
							  <td class="bottomleft"> </td>
							  <td class="bottom">
								<xsl:attribute name="colspan">1</xsl:attribute>
								  <!-- <xsl:value-of select="count(./SelectionTable/Header/Data)"/> -->
							  </td>
							  <td class="bottomright"> </td>
							</tr>
					
						</tfoot>
				</table>
						</td>
						<td valign="middle" width="20px">
									<xsl:choose>
										<xsl:when test="not(@image) or @image = 'right'">
											<img alt="" src="/oma/images/arrow_right.gif" height="25" width="20"/>
										</xsl:when>
										<xsl:when test="@image = 'left'">
											<img alt="" src="/oma/images/arrow_left.gif" height="25" width="20"/>
										</xsl:when>
										<xsl:when test="@image = 'both'">
											<img alt="" src="/oma/images/arrow_left_right.gif" height="50" width="20"/>
										</xsl:when>
										<xsl:when test="@image = 'none'">
											<img alt="" src="/oma/images/spacer_Transparent.gif" height="25" width="20"/>
										</xsl:when>
										<xsl:otherwise>
											<img alt="" src="/oma/images/arrow_right.gif" height="25" width="20"/>
										</xsl:otherwise>
									</xsl:choose>
						</td>
						<td valign="top">
						<table class="container autolayout">
						  <thead>
							<tr>
								<td class="topleft"></td>
								<td align="left" class="top" valign="middle">
									<!--ResultTable Header table goes here -->
									<table>
										<tr>
											<xsl:for-each select="ResultTable/Header/Data">
												<td class="top" valign="middle" align="left">
													<xsl:call-template name="calldatatype">
														<!-- MM :Begin - D035 - fix for id issue -->
														<xsl:with-param name="puid">header_<xsl:value-of select="$table_id"/><xsl:value-of select="position()"/></xsl:with-param>
														<!-- MM :End - D035 - fix for id issue -->
													</xsl:call-template>
												</td>
											</xsl:for-each>
										</tr>
									</table>
								</td>
								<td class="topright"></td>
							</tr>
						</thead>
						<tbody>	
						<tr>
							<td class="left"></td>
							<td align="left" class="contents" valign="top">
									<!--ResultTable Data Tree goes here-->
								<xsl:for-each select="ResultTable/Row">
									<!-- <div> 
										<xsl:attribute name="id">rt_row_<xsl:value-of select="@name"/></xsl:attribute>
										<xsl:choose>
											<xsl:when test="@state = 'hide' ">
												<xsl:attribute name="style">DISPLAY: none</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="style">DISPLAY:</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose> -->
											<xsl:call-template name="SelectionDataRow">
												<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
												<!-- MM :Begin - D035 - fix for id issue -->
												<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
												<!-- MM :End - D035 - fix for id issue -->
											</xsl:call-template>
									<!-- </div> -->
								</xsl:for-each>
							</td>
							<td class="right"></td>
						</tr>
						</tbody>
						<tfoot> 
							<tr>
							  <td class="bottomleft"> </td>
							  <td class="bottom">
								<xsl:attribute name="colspan">1</xsl:attribute>
								  <!-- <xsl:value-of select="count(./SelectionTable/Header/Data)"/> -->
							  </td>
							  <td class="bottomright"> </td>
							</tr>
					
						</tfoot>
				</table>
						</td>
					 </tr>
					 </table>
					</div>
				</div>		
			</xsl:when>
			<xsl:otherwise>
			<xsl:variable name="doubleheader">
				<xsl:choose>
					<xsl:when test="count(./SelectionTable/Header) &gt; 1">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
				<div class="table_container">
				<xsl:apply-templates select="SubHeader">
					<!-- MM :Begin - D030- fix for id issue -->
						<xsl:with-param name="tablesubheader" select="'true'" />
					<!-- MM :End - D030- fix for id issue -->
				</xsl:apply-templates>
				
					  <div class="table_gutter">
						<table class="container autolayout">
						  <thead>
							<tr>
							  <td>
								<xsl:choose>
								<xsl:when test="$doubleheader ='true'">
									<xsl:attribute name="class">doubletopleft</xsl:attribute>
									<xsl:attribute name="rowspan">2</xsl:attribute>
								</xsl:when>	
								<xsl:otherwise>
									<xsl:attribute name="class">topleft</xsl:attribute>
								</xsl:otherwise>
								</xsl:choose>		
							  </td>
								<xsl:if test="SelectionTable/Header">
									<!-- Header Row -->
											<xsl:for-each select="SelectionTable/Header/Data">
												<td class="top" valign="middle" align="left">
													<xsl:call-template name="calldatatype">
																<!-- MM :Begin - D035 - fix for id issue -->
																<xsl:with-param name="puid">header_<xsl:value-of select="$table_id"/><xsl:value-of select="position()"/></xsl:with-param>
																<!-- MM :End - D035 - fix for id issue -->
													</xsl:call-template>
												</td>
													
											</xsl:for-each>
								</xsl:if>
							<td>	
								<xsl:choose>
								<xsl:when test="$doubleheader='true'">
									<xsl:attribute name="class">doubletopright</xsl:attribute>
									<xsl:attribute name="rowspan">2</xsl:attribute>
								</xsl:when>	
								<xsl:otherwise>
									<xsl:attribute name="class">topright</xsl:attribute>
								</xsl:otherwise>
								</xsl:choose>
							</td>	
							</tr>
						
							<tr>
							  <td class="left">
							  </td>
							  <td>
								<xsl:attribute name="colspan">
								  <xsl:value-of select="count(./SelectionTable/Header/Data)"/>
								</xsl:attribute>
							  
							  <xsl:if test="SelectionTable/PromptText">
							    <xsl:attribute name="class">instructions</xsl:attribute>
								<span>Instructions:</span><xsl:value-of select="SelectionTable/PromptText"/>
							  </xsl:if>
							  </td>
							  <td class="right">
							  </td>
							</tr>
						</thead>
						<!-- Data Rows  -->
					<tbody>
					<tr>
					  <td class="left"></td>
					  <td class="contents">
						<xsl:attribute name="colspan">
						  <xsl:value-of select="count(./SelectionTable/Header/Data)"/>
						</xsl:attribute>
						
						<xsl:for-each select="SelectionTable/Row">
							<xsl:call-template name="SelectionDataRow">
								<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
								<!-- MM :Begin - D035 - fix for id issue -->
								<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
								<!-- MM :End - D035 - fix for id issue -->
							</xsl:call-template>
						</xsl:for-each>
					</td>
					<td class="right"></td>
					</tr>
					</tbody>
					<tfoot> 
							<tr>
							  <td class="bottomleft"> </td>
							  <td class="bottom">
								<xsl:attribute name="colspan">
								  <xsl:value-of select="count(./SelectionTable/Header/Data)"/>
								</xsl:attribute>
							  </td>
							  <td class="bottomright"> </td>
							</tr>
					
					</tfoot>
				</table>
				</div>
				
				</div>		

			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="SelectionDataRow">
		<xsl:param name="childrows"/>
		<!-- MM :Begin - D036 - fix for id issue -->
		<xsl:param name="puid" select="1"/>
		<xsl:param name="level" />
		<xsl:variable name="guid"><xsl:value-of select="$puid"/></xsl:variable>
		<!-- MM :End - D036 - fix for id issue -->
		<xsl:variable name="id"><xsl:value-of select="@name"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="@type='header'">
				<xsl:for-each select="ColumnData/Data">
					<th valign="top">
							<xsl:call-template name="calldatatype">
								<!-- MM :Begin - D036 - fix for id issue -->
								<xsl:with-param name="puid"><xsl:value-of select="../../SelectDataItem/Data/@name"/>_text<xsl:value-of select="$guid"/></xsl:with-param>
								<!-- MM :End - D036 - fix for id issue -->
							</xsl:call-template>
					</th>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$level='first'">
						<table>
						<tr>
						<xsl:attribute name="id">parentrow_<xsl:value-of select="$id"/></xsl:attribute>
						<!-- Column 2 : Selection Indicator data Item like.. check box or radio button, etc-->
						<xsl:for-each select="SelectDataItem/Data">
							<td>	<xsl:call-template name="calldatatype"/> </td>
						</xsl:for-each>

						<xsl:for-each select="ColumnData/Data">
						<td>
							<xsl:call-template name="calldatatype">
								<!-- MM :Begin - D036 - fix for id issue -->
								<xsl:with-param name="puid"><xsl:value-of select="../../SelectDataItem/Data/@name"/>_text<xsl:value-of select="$guid"/></xsl:with-param>
								<!-- MM :End - D036 - fix for id issue -->
							</xsl:call-template>
						</td>	
						</xsl:for-each>
						</tr>
						</table>
			</xsl:when>
			
			<xsl:otherwise>
                <ul>
				<xsl:choose>
				<xsl:when test="$level='child'">
					<xsl:attribute name="style">list-style: none;</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="class">container_tree</xsl:attribute>
				</xsl:otherwise>
				</xsl:choose>

				
                <li>
					<xsl:attribute name="style">display: inline;</xsl:attribute>
                    <div class="leaf">
						<xsl:attribute name="id">parentrow_<xsl:value-of select="$id"/></xsl:attribute>
					<table>
					<tr>
						<td>
						<xsl:choose>
						<xsl:when test="@tree = 'expand'">
							<span class="opened top" onclick="javascript:containerTree.toggle(this);"></span>
						</xsl:when>
						<xsl:otherwise>
							<span class="closed top" onclick="javascript:containerTree.toggle(this);"></span>
						</xsl:otherwise>
						</xsl:choose>		
						</td>
						<!-- Column 2 : Selection Indicator data Item like.. check box or radio button, etc-->
						<xsl:for-each select="SelectDataItem/Data">
								<td><xsl:call-template name="calldatatype"/></td>
						</xsl:for-each>

						<xsl:for-each select="ColumnData/Data">
						<td>
							<xsl:call-template name="calldatatype">
								<!-- MM :Begin - D036 - fix for id issue -->
								<xsl:with-param name="puid"><xsl:value-of select="../../SelectDataItem/Data/@name"/>_text<xsl:value-of select="$guid"/></xsl:with-param>
								<!-- MM :End - D036 - fix for id issue -->
							</xsl:call-template>
						</td>	
						</xsl:for-each>
						</tr>
						</table>
						
						<div>
						<xsl:if test="@tree = 'expand'">
							<xsl:attribute name="class">expand</xsl:attribute>						
						</xsl:if>
						<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>						
						<xsl:for-each select="ChildrenRows/Row[not(ChildrenRows)]">
							<xsl:call-template name="SelectionDataRow">
								<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
									<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
									<xsl:with-param name="level">first</xsl:with-param>
							</xsl:call-template>						
						</xsl:for-each>
						</div>
						</div>
						<xsl:for-each select="ChildrenRows/Row[ChildrenRows]">
							<xsl:call-template name="SelectionDataRow">
								<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
									<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
									<xsl:with-param name="level">child</xsl:with-param>
							</xsl:call-template>						
						</xsl:for-each>
				</li>
				</ul>
		  </xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>

	
	<xsl:template name="calldatatype">
		<!-- MM : Begin - D034 - fix for id issue -->
		<xsl:param name="puid"/>
		<!-- MM : End - D034 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@align != '' ">
				<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="align">left</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@width !=''">
			<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="@link='true'">
				<xsl:element name="a">
					<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
					<xsl:attribute name="title"><xsl:value-of select="@display"/></xsl:attribute>
					<xsl:call-template name="datatype">
						<!-- MM : Begin - D034 - fix for id issue -->
						<xsl:with-param name="uid" select="$puid"/>
						<!-- MM : End - D034 - fix for id issue -->
						<xsl:with-param name="display">
							<xsl:value-of select="@display"/>
						</xsl:with-param>
						<xsl:with-param name="type">
							<xsl:value-of select="@type"/>
						</xsl:with-param>
						<xsl:with-param name="name">
							<xsl:value-of select="@name"/>
						</xsl:with-param>
						<xsl:with-param name="id">
							<!-- MM : Begin - D034 - fix for id issue -->
							<xsl:value-of select="@id"/>
							<!-- xsl:value-of select="@name"/ -->
							<!-- MM : End - D034 - fix for id issue -->
						</xsl:with-param>
						<xsl:with-param name="value">
							<xsl:value-of select="@value"/>
						</xsl:with-param>
						<xsl:with-param name="returnvalue">
							<xsl:value-of select="@returnvalue"/>
						</xsl:with-param>
						<xsl:with-param name="state">
							<xsl:value-of select="@state"/>
						</xsl:with-param>
						<xsl:with-param name="preserve_format">
							<xsl:if test="@name = 'Description'">yes</xsl:if>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="datatype">
					<!-- MM : Begin - D034 - fix for id issue -->
					<xsl:with-param name="uid" select="$puid"/>
					<!-- MM : End - D034 - fix for id issue -->				
					<xsl:with-param name="display">
						<xsl:value-of select="@display"/>
					</xsl:with-param>
					<xsl:with-param name="type">
						<xsl:value-of select="@type"/>
					</xsl:with-param>
					<xsl:with-param name="name">
						<xsl:value-of select="@name"/>
					</xsl:with-param>
					<xsl:with-param name="id">
						<!-- MM : Begin - D034 - fix for id issue -->
						<xsl:value-of select="@id"/>
						<!-- xsl:value-of select="@name"/ -->
						<!-- MM : End - D034 - fix for id issue -->
					</xsl:with-param>
					<xsl:with-param name="value">
						<xsl:value-of select="@value"/>
					</xsl:with-param>
					<xsl:with-param name="returnvalue">
						<xsl:value-of select="@returnvalue"/>
					</xsl:with-param>
					<xsl:with-param name="state">
						<xsl:value-of select="@state"/>
					</xsl:with-param>
					<xsl:with-param name="size">
						<xsl:value-of select="@size"/>
					</xsl:with-param>
					<xsl:with-param name="uparrscript">
						<xsl:value-of select="@uparrscript"/>
					</xsl:with-param>
					<xsl:with-param name="downarrscript">
						<xsl:value-of select="@downarrscript"/>
					</xsl:with-param>
					<xsl:with-param name="sep">
						<xsl:value-of select="@sep"/>
					</xsl:with-param>
					<xsl:with-param name="value1">
						<xsl:value-of select="@value1"/>
					</xsl:with-param>
					<xsl:with-param name="value2">
						<xsl:value-of select="@value2"/>
					</xsl:with-param>
					<xsl:with-param name="value3">
						<xsl:value-of select="@value3"/>
					</xsl:with-param>
					<xsl:with-param name="value4">
						<xsl:value-of select="@value4"/>
					</xsl:with-param>
					<xsl:with-param name="event">
						<xsl:value-of select="@event"/>
					</xsl:with-param>
					<xsl:with-param name="handler">
						<xsl:value-of select="@handler"/>
					</xsl:with-param>
					<xsl:with-param name="preserve_format">
						<xsl:if test="@name = 'Description'">yes</xsl:if>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="@unit"/>
									<xsl:variable name="novalue"><xsl:choose>
										<xsl:when test="@value">
											<xsl:choose>
												<xsl:when test="@value='' ">true</xsl:when>
												<xsl:otherwise>false</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>true</xsl:otherwise>
									</xsl:choose></xsl:variable>
									<xsl:if test="ValueList">
										<xsl:for-each select="ValueList/value">
											<xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if>
										</xsl:for-each>
									</xsl:if>
	</xsl:template>
	<xsl:template name="datatype">
		<!-- MM : Begin - D005 - fix for id issue -->
		<xsl:param name="uid"/>
		<xsl:param name="ignoreName" select="false"/>
		<!-- MM : End - D005 - fix for id issue -->
		<xsl:param name="display"/>
		<xsl:param name="type"/>
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="value"/>
		<xsl:param name="value1"/>
		<xsl:param name="value2"/>
		<xsl:param name="value3"/>
		<xsl:param name="value4"/>
		<xsl:param name="returnvalue"/>
		<xsl:param name="state"/>
		<xsl:param name="size"/>
		<xsl:param name="uparrscript"/>
		<xsl:param name="downarrscript"/>
		<xsl:param name="sep"/>
		<xsl:param name="event"/>
		<xsl:param name="handler"/>
		<xsl:param name="preserve_format"/>
		<!--C91707 Ability to set selection box width-->
		<xsl:param name="width"/>
		<xsl:param name="extraitem"/>
		<xsl:choose>
			<xsl:when test="$type='password'">
				<xsl:element name="input">
					<!-- C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:attribute name="type">password</xsl:attribute>
					<xsl:attribute name="maxlength"><xsl:value-of select="$size"/></xsl:attribute>
					
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D001 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D001 - Fix for id issue -->
					<xsl:if test="@maxlength">
						<xsl:attribute name="maxlength">
						  <xsl:value-of select="@maxlength"/>
						</xsl:attribute>
                    </xsl:if>
					<xsl:choose>
						<xsl:when test="$size !=''">
							<xsl:attribute name="size"><xsl:value-of select="$size + 5"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="size">10</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='textarea'">
				<xsl:element name="textarea">
					<xsl:if test="@state = '2'">
						<xsl:attribute name="disabled"/>
					</xsl:if>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D002 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D002 - Fix for id issue -->
					<xsl:choose>
						<xsl:when test="@cols !=''">
							<xsl:attribute name="cols"><xsl:value-of select="@cols"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="cols">30</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@rows !=''">
							<xsl:attribute name="rows"><xsl:value-of select="@rows"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="rows">1</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="$value"/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='editbox'">
				<xsl:element name="input">
					<!-- C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D003 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D003 - Fix for id issue -->
					<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
					<xsl:if test="@maxlength"><xsl:attribute name="maxlength"><xsl:value-of select="@maxlength"/></xsl:attribute></xsl:if>
					<xsl:choose>
						<xsl:when test="$size !=''">
							<xsl:attribute name="size"><xsl:value-of select="$size"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="size">10</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="@state=2">
						<xsl:attribute name="disabled"/>
					</xsl:if>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='checkbox'">
				<xsl:element name="input">
					<!--C88676 fix smallfont font size -->
					<xsl:attribute name="class">checkbox</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="type">checkbox</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D004 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D004 - Fix for id issue -->
					<xsl:attribute name="value"><xsl:value-of select="$returnvalue"/></xsl:attribute>
					<xsl:if test="@state=1">
						<xsl:attribute name="checked"/>
					</xsl:if>
					<xsl:if test="@state=2">
						<xsl:attribute name="disabled"/>
					</xsl:if>
					<xsl:if test="@state=3">
						<xsl:attribute name="disabled"/>
						<xsl:attribute name="checked"/>
					</xsl:if>
					<xsl:value-of select="$value"/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='radio'">
				<xsl:element name="input">
				<!-- 102437 UI:Disable Radio Button are not clear -->
				<xsl:attribute name="style"><xsl:value-of select="'background-color:transparent'"/></xsl:attribute>
					<!--88676 fix smallfont font size -->
					<xsl:attribute name="class">radio</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="type">radio</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D005 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D005 - Fix for id issue -->
					<xsl:attribute name="value"><xsl:value-of select="$returnvalue"/></xsl:attribute>
					<xsl:if test="@state=1">
						<xsl:attribute name="checked"/>
					</xsl:if>
					<xsl:if test="@state=2">
						<xsl:attribute name="disabled"/>
					</xsl:if>
					<xsl:if test="@state=3">
						<xsl:attribute name="disabled"/>
						<xsl:attribute name="checked"/>
					</xsl:if>
					<xsl:value-of select="$value"/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='hidden'">
				<xsl:element name="input">
					<!--C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:attribute name="type">hidden</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D006  - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D006 - Fix for id issue -->
					<xsl:attribute name="value"><xsl:value-of select="$returnvalue"/></xsl:attribute>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='select'">
				<xsl:element name="select">
					<!--C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<!--C91707 Ability to set selection box width-->
					<xsl:attribute name="style">
					<xsl:choose>
					<xsl:when test="@width != ''"><xsl:value-of select="@width"/></xsl:when>
					<xsl:otherwise>width:auto</xsl:otherwise>
					</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D011 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D011 - Fix for id issue -->
					<xsl:for-each select="Choice">
						<xsl:element name="option">
							<xsl:if test="@default = 'true'">
								<xsl:attribute name="selected"/>
							</xsl:if>
							<xsl:attribute name="value"><xsl:value-of select="@returnvalue"/></xsl:attribute>
							<xsl:value-of select="@value"/>
						</xsl:element>
					</xsl:for-each>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='icon'">
				<!-- MM : Begin - D008 - Fix for id issue -->
				<xsl:variable name="idval">
					<xsl:choose>
						<!-- when id is given -->
						<xsl:when test="$id != ''"><xsl:value-of select="$id"/></xsl:when>
						<!-- when name is given -->
						<xsl:when test="$name != ''"><xsl:value-of select="$name"/></xsl:when>
						<!-- neither id nor name is given -->
						<xsl:otherwise>icon_<xsl:value-of select="$uid"/></xsl:otherwise>
					</xsl:choose>				
				</xsl:variable>
				<!-- MM : End - D008 - Fix for id issue -->
				<xsl:element name="img">
					<!-- MM : Begin - D008 - Fix for id issue -->
					<!-- xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<!-- for img, silktest requires name attribute, hence ensure name attribute is not null -->
					<xsl:choose>
						<xsl:when test="$name != ''">
							<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="name"><xsl:value-of select="$idval"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="id"><xsl:value-of select="$idval"/></xsl:attribute>
					<!-- MM : End - D008 - Fix for id issue -->
					<xsl:attribute name="src"><xsl:value-of select="$value"/></xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
					<xsl:attribute name="title"><xsl:value-of select="@alt"/></xsl:attribute>
					<xsl:attribute name="border">0</xsl:attribute>
					<!-- C73437 - Added EventHandling capability to status icon -->
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='status'">
				<xsl:call-template name="display-status">
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="status" select="$value" />
					<!-- MM : Begin - D023 - Fix for id issue -->
					<xsl:with-param name="id">
						<xsl:choose>
							<xsl:when test="$id != ''"><xsl:value-of select="$id"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$uid"/></xsl:otherwise>
						</xsl:choose>						
					</xsl:with-param>
					<!-- MM : End - D023 - Fix for id issue -->
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='status-text'">
				<xsl:call-template name="display-status-text">
					<xsl:with-param name="status" select="$value" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='button'">
				<xsl:call-template name="button">
					<xsl:with-param name="href">
						<xsl:choose>
							<xsl:when test="@href"><xsl:value-of select="@href"/></xsl:when>
							<xsl:otherwise>javascript:history.go(0)</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
					<xsl:with-param name="formSubmit">true</xsl:with-param>
					<xsl:with-param name="tablebutton">true</xsl:with-param>			
					<xsl:with-param name="browsercssfix">
						<xsl:choose>
							<xsl:when test="@browsercssfix"><xsl:value-of select="@browsercssfix"/></xsl:when>
							<xsl:otherwise><xsl:text></xsl:text></xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
	
					<xsl:with-param name="display"><xsl:value-of select="@display" /></xsl:with-param>
					<xsl:with-param name="extraitem">
					<xsl:choose>
						<xsl:when test="$extraitem!=''"><xsl:value-of select="$extraitem"/></xsl:when>
						<xsl:otherwise>false</xsl:otherwise>
					</xsl:choose>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='spincontrol'">
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td style="width: 50px; height: 30px">
							<xsl:element name="input">
								<xsl:if test="@event">
									<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
								</xsl:if>
								<xsl:for-each select="EventHandler">
									<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
								</xsl:for-each>
								<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
								<!-- MM : Begin - D009 - Fix for id issue -->
								<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
								<xsl:choose>
									<xsl:when test="$id != ''">
										<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<!-- MM : End - D009 - Fix for id issue -->
								<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
								<xsl:attribute name="size"><xsl:value-of select="$size"/></xsl:attribute>
								<xsl:if test="@maxlength"><xsl:attribute name="maxlength"><xsl:value-of select="@maxlength"/></xsl:attribute></xsl:if>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@state=3">
									<xsl:attribute name="readonly"/>
								</xsl:if>
							</xsl:element>
						</td>
						<td style="width: 19px; height: 30px">
							<table border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td>
										<xsl:element name="a">
											<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
											<xsl:choose>
												<xsl:when test="contains($uparrscript, 'javascript')">
													<xsl:attribute name="href">#spincontrolanchor</xsl:attribute>
													<!-- 108933 - Upper button highlighted when lower button clicked -->
													<!-- MM : Begin - D009 - Fix for id issue -->
													<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
													<xsl:choose>
														<xsl:when test="$id != ''">
															<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
													<!-- MM : End - D009 - Fix for id issue -->
													<xsl:attribute name="onclick"><xsl:value-of select="$uparrscript" /></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="href"><xsl:value-of select="$uparrscript" /></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<img src="/oma/images/accordion_close.png" style="width: 16px; height: 11px" />
										</xsl:element>
									</td>
								</tr>
								<tr>
									<td>
										<xsl:element name="a">
											<!-- 108933 - Upper button highlighted when lower button clicked -->
											<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
											<xsl:choose>
												<xsl:when test="contains($downarrscript, 'javascript')">
													<xsl:attribute name="href">#spincontrolanchor</xsl:attribute>
													<!-- 108933 - Upper button highlighted when lower button clicked -->
													<!-- MM : Begin - D009 - Fix for id issue -->
													<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
													<xsl:choose>
														<xsl:when test="$id != ''">
															<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
													<!-- MM : End - D009 - Fix for id issue -->
													<xsl:attribute name="onclick"><xsl:value-of select="$downarrscript" /></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="href"><xsl:value-of select="$downarrscript" /></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<img src="/oma/images/accordion_open.png" style="width: 16px; height: 11px" />
										</xsl:element>
									</td>
								</tr>
							</table>
						</td>

            <xsl:if test="@posttext != ''">
              <td style="height: 10px">
                <xsl:value-of select="@posttext"/>
              </td>
            </xsl:if>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="$type='ipaddrbox'">
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="name"><xsl:value-of select="$name"/>1</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>1</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value1"/></xsl:attribute>
								<xsl:attribute name="size">4</xsl:attribute>
								<xsl:attribute name="maxlength">3</xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@autocursoroff != 'true'">
									<xsl:attribute name="onfocus">if (this.value.length==3) {mj=false;}else{mj=true;}</xsl:attribute>
									<xsl:attribute name="onkeypress">mj=true</xsl:attribute>
									<xsl:attribute name="onkeyup">javascript:rchar('<xsl:value-of select="$name"/>',1,2);</xsl:attribute>
								</xsl:if>
							</xsl:element>
						</td>
						<td valign="bottom"><xsl:value-of select="$sep"/></td>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="name"><xsl:value-of select="$name"/>2</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>2</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value2"/></xsl:attribute>
								<xsl:attribute name="size">4</xsl:attribute>
								<xsl:attribute name="maxlength">3</xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@autocursoroff != 'true'">
									<xsl:attribute name="onfocus">if (this.value.length==3) {mj=false;}else{mj=true;}</xsl:attribute>
									<xsl:attribute name="onkeypress">mj=true</xsl:attribute>
									<xsl:attribute name="onkeyup">javascript:rchar('<xsl:value-of select="$name"/>',2,3);</xsl:attribute>
								</xsl:if>
							</xsl:element>
						</td>
						<td valign="bottom"><xsl:value-of select="$sep"/></td>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="name"><xsl:value-of select="$name"/>3</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>3</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value3"/></xsl:attribute>
								<xsl:attribute name="size">4</xsl:attribute>
								<xsl:attribute name="maxlength">3</xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@autocursoroff != 'true'">
									<xsl:attribute name="onfocus">if (this.value.length==3) {mj=false;}else{mj=true;}</xsl:attribute>
									<xsl:attribute name="onkeypress">mj=true</xsl:attribute>
									<xsl:attribute name="onkeyup">javascript:rchar('<xsl:value-of select="$name"/>',3,4);</xsl:attribute>
								</xsl:if>
							</xsl:element>
						</td>
						<td valign="bottom"><xsl:value-of select="$sep"/></td>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="name"><xsl:value-of select="$name"/>4</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>4</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value4"/></xsl:attribute>
								<xsl:attribute name="size">4</xsl:attribute>
								<xsl:attribute name="maxlength">3</xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@autocursoroff != 'true'">
									<xsl:attribute name="onfocus">if (this.value.length==3) {mj=false;}else{mj=true;}</xsl:attribute>
									<xsl:attribute name="onkeypress">mj=true</xsl:attribute>
									<xsl:attribute name="onkeyup">javascript:rchar('<xsl:value-of select="$name"/>',4,4);</xsl:attribute>
								</xsl:if>
							</xsl:element>
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="$type='date'">
				
							<xsl:element name="input">								
								<xsl:attribute name="name"><xsl:value-of select="$name"/>Hid</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>Hid</xsl:attribute>
								<xsl:choose>
									<xsl:when test="@width">
										<xsl:attribute name="size"><xsl:value-of select="@width"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="size">29</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:attribute name="disabled"/>
							</xsl:element>
							<xsl:element name="input">
								<xsl:attribute name="type">hidden</xsl:attribute>
								<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
							</xsl:element>
						
						<script language="javascript">
							<xsl:choose>
								<xsl:when test="$value = 'Please set the value'">
									document.getElementById('<xsl:value-of select="$name"/>Hid').value = '<xsl:value-of select="$value"/>';
								</xsl:when>
								<xsl:otherwise>
									{
										var client_offset_cal = new Date();
										var date_var1 = new Date ('<xsl:value-of select="$value"/>');
										var clientOffsetMins = client_offset_cal.getTimezoneOffset();
										
										<xsl:if test="@srvOffset">
											var finalTime = '<xsl:value-of select="$value"/>';
											var adjustedFinalTime = new Number(finalTime) + new Number(<xsl:value-of select="@srvOffset"/>) + new Number(clientOffsetMins * 60 * 1000);
											date_var1 = new Date(adjustedFinalTime);											
										</xsl:if>
										
										var sdispLongDate = date_var1.toString();
										
										var sdateString1 = sdispLongDate.substr(0,sdispLongDate.indexOf(':')-2);
										var sYear = date_var1.getYear();
										if (navigator.appName == 'Netscape')
								        	{
								        	    var sdispDate = sdateString1;
								        	}
								        	else
								        	{
								        	    var sdispDate = sdateString1 + sYear;
								        	}
										if (sdispDate != "NaN")
										{
											document.getElementById('<xsl:value-of select="$name"/>Hid').value = sdispDate;
										}
									}

								</xsl:otherwise>
                        				</xsl:choose>
						</script>
						
							<img>
								<xsl:attribute name="name"><xsl:value-of select="$name"/>Img</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>Img</xsl:attribute>
								<xsl:attribute name="src">/oma/images/calendar.gif</xsl:attribute>
								<xsl:attribute name="onClick">javascript:showCalendar('<xsl:value-of select="$name"/>Img', '<xsl:value-of select="$name"/>')</xsl:attribute>
								<xsl:attribute name="border">0</xsl:attribute>
								<xsl:attribute name="align">top</xsl:attribute>
							</img>
						
				<!-- 89828 Allow initialize of date value-->
		         <script language="javascript">
			           convertDate('<xsl:value-of select="@name"/>', '<xsl:value-of select="@value"/>', '<xsl:value-of select="@srvOffset"/>');
			    </script>				
			</xsl:when>
			<!-- input tag with type=file will display a text box with a "Browse..." button for file sytem exploring -->
			<xsl:when test="$type='file'">
				<xsl:element name="input">
					<xsl:attribute name="type">file</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D010 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D010 - Fix for id issue -->
				</xsl:element>
			</xsl:when>
			<!--88595 OMSS Fix custom data type -->
               <xsl:when test="@type='custom'">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<!-- MM : Begin - D007 - Fix for id issue -->
				<xsl:variable name="idval">
					<xsl:choose>
						<!-- when id is given -->
						<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
						<!-- when name is given -->
						<xsl:when test="@name != '' and $ignoreName ='false'"><xsl:value-of select="@name"/></xsl:when>
						<!-- neither id nor name is given -->
						<xsl:otherwise><xsl:value-of select="$uid"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!-- MM : End - D007 - Fix for id issue -->
				<xsl:choose>
					<xsl:when test="$preserve_format = 'yes'">
						<!-- MM : Begin - D007 - Fix for id issue -->
						<!-- id is set for <td> and not for <pre>, because if set for <pre>, silktest is not able to identify it. -->
						<xsl:choose>
							<!-- when id is given -->
							<xsl:when test="@id != ''">
								<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>							
							</xsl:when>
							<!-- when id is not given -->
							<xsl:otherwise>
								<xsl:attribute name="id"><xsl:value-of select="$uid"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<!-- MM : End - D007 - Fix for id issue -->
						<pre class="data-area-information">
							<xsl:choose>
								<xsl:when test="@value">
									<xsl:choose>
										<xsl:when test="@value=''">
											<xsl:choose>
												<xsl:when test="ValueList"></xsl:when>
												<xsl:otherwise></xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise><xsl:value-of select="@value"/></xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="ValueList"></xsl:when>
										<xsl:otherwise></xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</pre>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@value">
								<xsl:choose>
									<xsl:when test="@value=''">
										<xsl:choose>
											<xsl:when test="ValueList"></xsl:when>
											<xsl:otherwise>
												<!-- MM : Begin - D007 - Fix for id issue -->
												<!-- xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute -->
												<!-- xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute-->
												<xsl:attribute name="id"><xsl:value-of select="$idval"/></xsl:attribute>
												<xsl:choose>
													<xsl:when test="@name != ''">
														<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
													</xsl:when>
													<xsl:otherwise>
														<!-- we ensure 'name' attribute is not null because SilkTest doesnt use id for Hrefs -->
														<xsl:attribute name="name"><xsl:value-of select="$idval"/></xsl:attribute>
													</xsl:otherwise>
												</xsl:choose>
												<!-- MM : End - D007 - Fix for id issue -->
												<!-- <img src='/oma/images/blank.gif'/> -->
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<!-- MM : Begin - D007 - Fix for id issue -->
										<!-- xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute -->
										<!-- xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute -->
										<xsl:attribute name="id"><xsl:value-of select="$idval"/></xsl:attribute>
										<xsl:choose>
											<xsl:when test="@name != ''">
												<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<!-- we ensure 'name' attribute is not null because SilkTest doesnt use id for Hrefs -->
												<xsl:attribute name="name"><xsl:value-of select="$idval"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>

										<!-- OMSS font bold changes -->
										<xsl:if test="@bold='true'">
											<xsl:attribute name="style">font-weight:bold</xsl:attribute>
										</xsl:if>


										<!-- MM : End - D007 - Fix for id issue -->
										<xsl:value-of select="@value"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="ValueList"></xsl:when> 
									<xsl:otherwise><!--<img src='/oma/images/blank.gif'/>--></xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="sep">
		<xsl:param name="colspan"/>
<!--		<td class="data-area-separator" style="height: 1px">
			<img   style="width: 1px; height: 1px"/>
		</td>
-->		
		<xsl:if test="$colspan > 0">
			<xsl:call-template name="sep">
				<xsl:with-param name="colspan">
					<xsl:value-of select="($colspan)-1"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="script">
		<xsl:copy-of select="." />
	</xsl:template>


	<xsl:template name="button">
		<xsl:param name="href" />
		<xsl:param name="display" />
		<xsl:param name="value" />
		<xsl:param name="onclick" />
		<xsl:param name="formSubmit" />
		<xsl:param name="tablebutton" />
		<xsl:param name="browsercssfix" />
		<xsl:param name="id" />
		<xsl:param name="listtablebutton" />
		<xsl:param name="name" />
		<xsl:param name="extraitem"/>
		
		<xsl:call-template name="button_details">
			<xsl:with-param name="href"><xsl:value-of select="$href" /></xsl:with-param>
			<xsl:with-param name="display">
				<xsl:choose>
					<xsl:when test="@value !=''"><xsl:value-of select="@value"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$display"/></xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="onclick"><xsl:value-of select="$onclick" /></xsl:with-param>
			<xsl:with-param name="formSubmit"><xsl:value-of select="$formSubmit" /></xsl:with-param>
			<xsl:with-param name="tablebutton"><xsl:value-of select="$tablebutton" /></xsl:with-param>
			<xsl:with-param name="browsercssfix"><xsl:value-of select="$browsercssfix" /></xsl:with-param>
			<xsl:with-param name="id"><xsl:value-of select="$id" /></xsl:with-param>
			<xsl:with-param name="listtablebutton"><xsl:value-of select="$listtablebutton" /></xsl:with-param>
			<xsl:with-param name="name"><xsl:value-of select="$name" /></xsl:with-param>
			<xsl:with-param name="extraitem"><xsl:value-of select="$extraitem" /></xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="button_details">
		<xsl:param name="href" />
		<xsl:param name="display" />
		<xsl:param name="onclick" />
		<xsl:param name="formSubmit" />
		<xsl:param name="tablebutton" />
		<xsl:param name="browsercssfix" />
		<xsl:param name="id" />
		<xsl:param name="listtablebutton" />
		<xsl:param name="name" />
		<xsl:param name="extraitem"/>
		
		<!-- MM : Begin - D013 - Fix for id issue -->
		<xsl:variable name="uid">
			<xsl:choose>
				<xsl:when test="$id != ''"><xsl:value-of select="$id"/></xsl:when>
				<xsl:otherwise><!-- check if you need to assign some default id --></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : End - D013 - Fix for id issue -->
			<xsl:choose>
				<xsl:when test="$formSubmit = 'true'">
					<script language="javascript">
						var browserHack = false;
						document.write ("&lt;a");
						if (navigator.appName == "Microsoft Internet Explorer") {
							var sAppVersion = navigator.appVersion;
							sAppVersion = sAppVersion.replace (/.*MSIE /i, "");
							sAppVersion = parseFloat(sAppVersion.split (';')[0]);
							if (sAppVersion >= "5.5") {
								<xsl:choose>
									<xsl:when test="contains($href, 'javascript')">
										document.write (" href='#' onclick='<xsl:value-of select="$href" />'");
									</xsl:when>
									<xsl:otherwise>document.write (" href='<xsl:value-of select="$href" />'");</xsl:otherwise>
								</xsl:choose>
							}
							else
								document.write (" href='<xsl:value-of select="$href" />'");
								
							if ( (sAppVersion == parseFloat("7.0"))  || (sAppVersion &lt; parseFloat("8.0")) )
							{
								<xsl:choose>
								<xsl:when test="$uid='submitbuttoncontent'">
								document.write (" class='page_button_emphasized'");
								</xsl:when>
								<xsl:when test="$tablebutton = 'true' and $extraitem = 'true'">
								document.write (" class='table_button table_button_ie7_hack'");
								</xsl:when>
								<xsl:when test="$tablebutton = 'true'">
								document.write (" class='table_button'");
								</xsl:when>
								<xsl:when test="starts-with($uid, 'custombutton')">
								document.write (" class='task'");
								</xsl:when>
								<xsl:otherwise>
								document.write (" class='page_button'");
								</xsl:otherwise>
								</xsl:choose>							
								browserHack = true;
							}

						}
						else {
								if(navigator.userAgent.indexOf("Firefox/") != -1)
								{		
									var sAppVersion = navigator.userAgent;
									sAppVersion = sAppVersion.split (' ');
									var sAppVersion1 = sAppVersion[sAppVersion.length -1];
									sAppVersion = sAppVersion1.split ('/');
									sAppVersion1 = sAppVersion[sAppVersion.length -1];
									sAppVersion = sAppVersion1.split ('.');
									sAppVersion1 = sAppVersion[0]+'.'+sAppVersion[1];
									if ( (parseFloat(sAppVersion1) == parseFloat('3.0')) || (parseFloat(sAppVersion1) &lt; parseFloat('3.0')) )
									{
										<xsl:choose>
										<xsl:when test="$uid='submitbuttoncontent'">
											document.write (" class='page_button_emphasized'");
										</xsl:when>
										<xsl:when test="$tablebutton = 'true' and $extraitem = 'true'">
											document.write (" class='table_button table_button_ff30_hack'");
										</xsl:when>
										<xsl:when test="$tablebutton = 'true'">
											document.write (" class='table_button'");
										</xsl:when>
										<xsl:when test="starts-with($uid, 'custombutton')">
											document.write (" class='task'");
										</xsl:when>
										<xsl:otherwise>
											document.write (" class='page_button'");
										</xsl:otherwise>
										</xsl:choose>							
										browserHack = true;
									}	
								}else if(navigator.userAgent.indexOf("Safari/") != -1) <!-- Added for IE11 and Above. IE11 uses Mozilla as user Agent. Also "safari" string has been reused. -->
								{
										<xsl:choose>
										<xsl:when test="$uid='submitbuttoncontent'">
											document.write (" class='page_button_emphasized'");
										</xsl:when>
										<xsl:when test="$tablebutton = 'true' and $extraitem = 'true'">
											document.write (" class='table_button table_button_safari'");
										</xsl:when>
										<xsl:when test="$tablebutton = 'true' and $browsercssfix!= '' and contains($browsercssfix,'safari')">
										document.write (" class='table_button <xsl:value-of select="$browsercssfix" />'");
										</xsl:when>
										<xsl:when test="$tablebutton = 'true'">
											document.write (" class='table_button table_button_safari'");
										</xsl:when>
										<xsl:when test="starts-with($uid, 'custombutton')">
											document.write (" class='task'");
										</xsl:when>
										<xsl:otherwise>
											document.write (" class='page_button'");
										</xsl:otherwise>
										</xsl:choose>							
										browserHack = true;
									
								}else if(navigator.userAgent.indexOf("Mozilla/") != -1)
								{
										<xsl:choose>
										<xsl:when test="$uid='submitbuttoncontent'">
											document.write (" class='page_button_emphasized'");
										</xsl:when>
										<xsl:when test="$tablebutton = 'true' and $extraitem = 'true'">
											document.write (" class='table_button table_button_safari'");
										</xsl:when>
										<xsl:when test="$tablebutton = 'true' and $browsercssfix!= '' and contains($browsercssfix,'safari')">
										document.write (" class='table_button <xsl:value-of select="$browsercssfix" />'");
										</xsl:when>
										<xsl:when test="$tablebutton = 'true'">
											document.write (" class='table_button table_button_safari'");
										</xsl:when>
										<xsl:when test="starts-with($uid, 'custombutton')">
											document.write (" class='task'");
										</xsl:when>
										<xsl:otherwise>
											document.write (" class='page_button'");
										</xsl:otherwise>
										</xsl:choose>							
										browserHack = true;
									
								}
							
							
							document.write (" href="+encodeURI('<xsl:value-of select="$href" />'));	

						}
						<!-- MM : Begin - D013 - Fix for id issue -->
						<!-- document.write ("<xsl:if test="$id != ''"> id='<xsl:value-of select="$id" />'</xsl:if>&gt;"); -->
						<!-- we give 'name' attribute as well as SilkTest doesnt use id for Hrefs -->
						document.write ("<xsl:if test="$uid != ''"> name='<xsl:value-of select="$uid" />'</xsl:if>");
						document.write ("<xsl:if test="$uid != ''"> id='<xsl:value-of select="$uid" />'</xsl:if>");
						if( browserHack == false)
						{
							<xsl:choose>
							<xsl:when test="$uid='submitbuttoncontent'">
							document.write (" class='page_button_emphasized'");
							</xsl:when>
							<xsl:when test="$tablebutton = 'true'">
							document.write (" class='table_button'");
							</xsl:when>
							<xsl:when test="starts-with($uid, 'custombutton')">
							document.write (" class='task'");
							</xsl:when>
							<xsl:otherwise>
							document.write (" class='page_button'");
							</xsl:otherwise>
							</xsl:choose>
						}	
						<!-- MM : End - D013 - Fix for id issue -->
						document.write (">&lt;span><xsl:value-of select="$display" />&lt;/span>");
						document.write ("&lt;/a>");
						<xsl:if test="starts-with($uid, 'custombutton')">
							<xsl:if test="position() != last()">
								document.write ("&lt;ul>&lt;li class='divider'>&lt;/li>&lt;/ul>");
							</xsl:if>	
						</xsl:if>	
						
					</script>
				</xsl:when>
				<xsl:otherwise>
					<a>
						<xsl:choose>
							<xsl:when test="$name='Refresh' or $display=$strRefresh">
								<xsl:attribute name="class">refresh</xsl:attribute>
							</xsl:when>
						  <xsl:when test="$id='backbutton'">
							<xsl:attribute name="class">page_button</xsl:attribute>
						  </xsl:when>
						  <xsl:when test="$id='cancelbutton'">
							<xsl:attribute name="class">page_button</xsl:attribute>
						  </xsl:when>
						  <xsl:when test="starts-with($id, 'custombutton')">
							<xsl:attribute name="class">task</xsl:attribute>
						  </xsl:when>						  
						<xsl:otherwise>
							<xsl:choose>
							<xsl:when test="$listtablebutton = 'true'">
								<xsl:choose>
									<xsl:when test="$id = 'moveup'">
										<xsl:attribute name="class">container_plus_button</xsl:attribute>
									</xsl:when>
									<xsl:when test="$id = 'movedown'">								
										<xsl:attribute name="class">container_minus_button</xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="class">container_button</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>										
							</xsl:when>
							<xsl:when test="$tablebutton = 'true'">
								<xsl:attribute name="class">table_button</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">page_button</xsl:attribute>
							</xsl:otherwise>
							</xsl:choose>		
						</xsl:otherwise>
						</xsl:choose>

						<xsl:choose>
						<xsl:when test="$listtablebutton = 'true'">
							<xsl:attribute name="href"><xsl:value-of select="$href" /></xsl:attribute>
							<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick" /></xsl:attribute></xsl:if>
						</xsl:when>	
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="contains($href, 'javascript')">
									<xsl:attribute name="href">#</xsl:attribute>
									<xsl:attribute name="onclick"><xsl:value-of select="$href" /></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="href"><xsl:value-of select="$href" /></xsl:attribute>
									<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick" /></xsl:attribute></xsl:if>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
						</xsl:choose>
						<!-- MM : Begin - D013 - Fix for id issue -->
						<!-- xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id" /></xsl:attribute></xsl:if -->
						<xsl:attribute name="id"><xsl:value-of select="$uid" /></xsl:attribute>
						<!-- we give 'name' attribute as well as SilkTest doesnt use id for Hrefs -->
						<xsl:attribute name="name"><xsl:value-of select="$uid" /></xsl:attribute>
						<!-- MM : End - D013 - Fix for id issue -->
						<xsl:choose>
						<xsl:when test="$name='Refresh' or $display=$strRefresh">
							<xsl:attribute name="title"><xsl:value-of select="$display" /></xsl:attribute>
						</xsl:when>
						<xsl:when test="$listtablebutton = 'true'">
							<span><script language="javascript">document.write ("&amp;nbsp;");</script></span>
							<xsl:attribute name="title"><xsl:value-of select="$display" /></xsl:attribute>
						</xsl:when>
					  <xsl:otherwise>
							<span><xsl:value-of select="$display" /></span>
						</xsl:otherwise>
						</xsl:choose>
					</a>
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>

	<!--<xsl:template name="replace-substring">
		<xsl:param name="text" />
		<xsl:param name="from" />
		<xsl:param name="to" />
		<xsl:call-template name="_replace-substring">
			<xsl:with-param name="text"><xsl:value-of select="$text" /></xsl:with-param>
			<xsl:with-param name="from" select="$from" />
			<xsl:with-param name="to" select="$to" />
		</xsl:call-template>
	</xsl:template>-->

	<xsl:template name="replace-substring">
		<xsl:param name="text" />
		<xsl:param name="from"/>
		<xsl:param name="to"/>
		<xsl:variable name="backslash">
			<xsl:call-template name="_replace-substring">
				<xsl:with-param name="text"><xsl:value-of select="$text" /></xsl:with-param>
				<xsl:with-param name="from">\</xsl:with-param>
				<xsl:with-param name="to">\\</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="singlequote">
			<xsl:call-template name="_replace-substring">
				<xsl:with-param name="text"><xsl:value-of select="$backslash" /></xsl:with-param>
				<xsl:with-param name="from">'</xsl:with-param>
				<xsl:with-param name="to">\'</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="doublequote">
			<xsl:call-template name="_replace-substring">
				<xsl:with-param name="text"><xsl:value-of select="$singlequote" /></xsl:with-param>
				<xsl:with-param name="from">"</xsl:with-param>
				<xsl:with-param name="to">\"</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="$doublequote"/>
	</xsl:template>

	<xsl:template name="_replace-substring">
		<xsl:param name="text" />
		<xsl:param name="from" />
		<xsl:param name="to" />
		<xsl:choose>
			<xsl:when test="contains($text, $from)">
				<xsl:value-of select="substring-before ($text, $from)" />
				<xsl:value-of select="$to" />
				<xsl:call-template name="_replace-substring">
					<xsl:with-param name="text" select="substring-after($text, $from)" />
					<xsl:with-param name="from" select="$from" />
					<xsl:with-param name="to" select="$to" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="plotstatistics">
	<!--For Statistics/graphs plot on multiple windows-->
	  <div class="table_gutter"> 
        <table class="system_summary" id="statisticsTbl">
           <tbody>
		    <tr> <!-- first row -->
				<td class="system_top"> <!-- first row First column Lists the possible options -->
				  <div class="relative">  
              		  <div id="tbl1_title" class="container_top_right"> 
						<div class="container_top_left"> 
						  <div class="container_gradient"> 
							<div class="container_title"> 
								<xsl:value-of select="/OMA/DataArea/statGraph/statTitle"/>
							</div>
						  </div>
						</div>
					  </div>
					   <div id="tbl1_body" class="container_right"> 
						<div class="container_left"> 
						  <div class="container_content"> 
							 <table  width="430" height="130" class="infolist"> <!-- ListData -->
							   <tbody>
							     <tr>
									<td class="top_spacer_small" colspan="2"/>
								 </tr>
									 <xsl:apply-templates select="/OMA/DataArea/Statistics/ListData"/>
								  <tr>
										<td class="bottom_spacer_small" colspan="2"/>
								  </tr>
							    </tbody>
						    </table>
						 </div>
					    </div>
				       </div>
				  	<div class="container_bottom_right_buttons">  <!-- Add submit Button-->
						<div class="container_bottom_left_buttons">     
							<div class="container_bottom_gradient">  
								<div class="button_footer">
									<div class="button_clear">  
										<xsl:call-template name="button">
											<xsl:with-param name="href">javascript:submitData()</xsl:with-param>
											<xsl:with-param name="formSubmit">true</xsl:with-param>
											<xsl:with-param name="display">
												<xsl:choose>
													<xsl:when test="@submitdisplay != ''"><xsl:value-of select="@submitdisplay"/></xsl:when>
													<xsl:otherwise><xsl:value-of select="@plotgraph"/></xsl:otherwise>
												</xsl:choose>
											</xsl:with-param>
											<xsl:with-param name="id">submitbuttoncontent</xsl:with-param>		
										</xsl:call-template>
									</div> 
								</div> 
							</div> 
						</div> 
					</div>
				
				 </div>
				</td><!-- End of Statistic List Data-->
     			<xsl:if test="/OMA/DataArea/statGraph/@type='pie'">  <!-- First Row second column Cache usage Graph begin-->
						<td class="system_top"> 
						  <div class="relative"> 
						
							<div id="tbl2_title" class="container_top_right"> 
								<div class="container_top_left"> 
									<div class="container_gradient"> 
										<div class="container_title"> 
												<xsl:value-of select="/OMA/DataArea/statGraph/@pietitle"/>
										</div>
									</div>
								</div>
							</div>
							<div class="container_right" id="tbl2_body">
								<div class="container_left">
						  			<div class="empty_table_container_left">
											<div id="container1" style="min-width: 200px; height: 300px; margin: 0 auto"></div>
									</div>
								</div>
							</div>    
							<div class="container_bottom_right"> 
							  <div class="container_bottom_left"> 
								<div class="container_bottom"> </div>
							  </div>
							</div>
                     </div>
					</td>
			 </xsl:if>
		</tr><!-- END of First Row-->
	<!-- Cache disk performance Line chart begin-->
	<!-- second row--><!-- second row first column Line chart-->
	  <xsl:if test="/OMA/DataArea/statGraph/@type='line'">   
      <tr> 
        <td class="system_bottom"> 
		   <div class="relative"> 
			    <div id="tbl3_title" class="container_top_right"> 
				   <div class="container_top_left"> 
					 <div class="container_gradient"> 
					   <div class="container_title"> 
						<xsl:value-of select="/OMA/DataArea/statGraph/@linegraphtitle"/>
					   </div>
					</div>
				  </div>
				</div>
				<div id="tbl3_body" class="container_right"> 
				  <div class="container_left"> 
					<div class="container_content"> 
					    <table  class="infolist ">
						<tbody>
						<tr> 
							
					    </tr>
							<div id="container2" style="min-width: 500px; height: 300px; margin: 0 auto"></div>
							
						<tr> 
							
						</tr>
						</tbody>
						</table>
					  </div>
				  </div>
				</div>
				<div class="container_bottom_right_buttons">  <!-- Add expand view Button-->
						<div class="container_bottom_left_buttons">     
							<div class="container_bottom_gradient">  
								<div class="button_footer">
									<div class="button_clear">  
										<xsl:call-template name="button">
											<xsl:with-param name="href">javascript:expandGraph(<xsl:value-of select="/OMA/@vid" />)</xsl:with-param>
											<xsl:with-param name="formSubmit">true</xsl:with-param>
											<xsl:with-param name="display">
												<xsl:choose>
													<xsl:when test="@submitdisplay != ''"><xsl:value-of select="@submitdisplay"/></xsl:when>
													<xsl:otherwise><xsl:value-of select="@expandview"/></xsl:otherwise>
												</xsl:choose>
											</xsl:with-param>
											<xsl:with-param name="id">submitbuttoncontent</xsl:with-param>		
										</xsl:call-template>
									</div> 
								</div> 
							</div> 
						</div> 
					</div>
			  </div>
			</td>
     
			<td class="system_bottom"> 
				<div class="relative"> 
                      <div id="tbl4_title" class="container_top_right"> 
							<div class="container_top_left"> 
								<div class="container_gradient"> 
									<div class="container_title"> 
										<xsl:value-of select="/OMA/DataArea/statGraph/@bargraphtitle"/>
									</div>
								</div>
							</div>
						</div>
						<div id="tbl4_body" class="container_right"> 
							<div class="container_left"> 
								<div class="container_content"> 
                 				  <table width="430" class="infolist">
								   <tbody>
								   <tr> 
										<div id="container3" style="min-width: 200px; height: 300px; margin: 0 auto"></div>
									</tr>
									</tbody>
								  </table>
								</div>
							</div>
						</div>
						<div class="container_bottom_right"> 
						  <div class="container_bottom_left"> 
							<div class="container_bottom"> </div>
						  </div>
						</div>
			  </div>
			  </td>
		</tr>
		 <!--tr> 
        
			<td class="system_bottom"> 
				<div class="relative"> 
                      <div id="tbl4_title" class="container_top_right"> 
							<div class="container_top_left"> 
								<div class="container_gradient"> 
									<div class="container_title"> 
										Average Data / cacheDisk
									</div>
								</div>
							</div>
						</div>
						<div id="tbl4_body" class="container_right"> 
							<div class="container_left"> 
								<div class="container_content"> 
                 				  <table width="430" class="infolist">
								   <tbody>
								   <tr> 
										<div id="container3" style="min-width: 200px; height: 300px; margin: 0 auto"></div>
									</tr>
									</tbody>
								  </table>
								</div>
							</div>
						</div>
						<div class="container_bottom_right"> 
						  <div class="container_bottom_left"> 
							<div class="container_bottom"> </div>
						  </div>
						</div>
			  </div>
			  </td>
		</tr-->
	 
		
	   </xsl:if>  <!-- bar chart end-->
	   
    
      </tbody>
	  </table><!-- End of statistics table -->
      </div>
      <br/>
	</xsl:template>
	<!--End of statistic changes-->
	
	<xsl:template name="display-status">
		<xsl:param name="name" />
		<xsl:param name="status" />
		<!-- MM : Begin - D023 - Fix for id issue -->
		<xsl:param name="id"/>
		<xsl:variable name="idval">
			<xsl:choose>
				<!-- when id is given -->
				<xsl:when test="$id != ''"><xsl:value-of select="$id"/></xsl:when>
				<!-- if id not given -->
				<xsl:otherwise>img_<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="nameval">
			<xsl:choose>
				<xsl:when test="$name != ''"><xsl:value-of select="$name"/></xsl:when>
				<!-- if name not  given, we ensure 'name' attribute is not null because SilkTest doesnt use id for Hrefs -->
				<xsl:otherwise><xsl:value-of select="$idval"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : End - D023 - Fix for id issue -->
		
		<xsl:element name="img">			
			<xsl:attribute name="name"><xsl:value-of select="$nameval" /></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="$idval" /></xsl:attribute>
			<xsl:attribute name="src">
				<xsl:choose>
					<xsl:when test="$status='0'">/oma/images/status_icons/statusUnknown_16.png</xsl:when>
					<xsl:when test="$status='1'">/oma/images/status_icons/statusUnknown_16.png</xsl:when>
					<xsl:when test="$status='2'">/oma/images/status_icons/statusOK_16.png</xsl:when>
					<xsl:when test="$status='3'">/oma/images/status_icons/nonCritical_16.png</xsl:when>
					<xsl:when test="$status='4'">/oma/images/status_icons/critical_16.png</xsl:when>
					<xsl:when test="$status='5'">/oma/images/status_icons/critical_16.png</xsl:when>
					<xsl:when test="$status='6'">/oma/images/action_icons/abort_16.png</xsl:when>
					<xsl:when test="$status='7'">/oma/images/progress.gif</xsl:when>
					<xsl:when test="$status='8'">/oma/images/action_icons/suspend_16.png</xsl:when>
					<xsl:when test="$status='9'">/oma/images/action_icons/resume_16.png</xsl:when>
					<xsl:when test="$status='10'">/oma/images/pending.gif</xsl:when>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="border">0</xsl:attribute>
			<xsl:attribute name="align">absmiddle</xsl:attribute>
			<xsl:attribute name="alt"><xsl:value-of select="$strStatus2"/><xsl:call-template name="display-status-text"><xsl:with-param name="status" select="$status" /></xsl:call-template></xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="$strStatus3"/><xsl:call-template name="display-status-text"><xsl:with-param name="status" select="$status" /></xsl:call-template></xsl:attribute>
		<!-- C73437 - Added EventHandling capability to status icon -->
		<xsl:for-each select="EventHandler">
			<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
		</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<!-- Start CHNG99370 - Visual cue for sort order -->
	<xsl:template name="display-sortorder">
		<xsl:param name="name" />	
		<xsl:param name="sortorder" />
		<img name="sortOrderImg">
			<xsl:choose>
				<xsl:when test="$sortorder='ascending'">
					<xsl:attribute name="src">/oma/images/ascend.gif</xsl:attribute>
				</xsl:when>
				<xsl:when test="$sortorder!='ascending'">
					<xsl:attribute name="src">/oma/images/descend.gif</xsl:attribute>
				</xsl:when> 
			</xsl:choose>
		</img>
	</xsl:template>
	<!-- End CHNG99370 - Visual cue for sort order -->

	<xsl:template name="display-status-text">
		<xsl:param name="status" />
			<xsl:choose>
				<xsl:when test="$status='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
				<xsl:when test="$status='1'"><xsl:value-of select="$strUnknown1"/></xsl:when>
				<xsl:when test="$status='2'"><xsl:value-of select="$strOK"/></xsl:when>
				<xsl:when test="$status='3'"><xsl:value-of select="$strNonCritical"/></xsl:when>
				<xsl:when test="$status='4'"><xsl:value-of select="$strCritical"/></xsl:when>
				<xsl:when test="$status='5'"><xsl:value-of select="$strNonRecoverable"/></xsl:when>
				<xsl:when test="$status='6'"><xsl:value-of select="$strAborted"/></xsl:when>
				<xsl:when test="$status='7'"><xsl:value-of select="$strProgress"/></xsl:when>
				<xsl:when test="$status='8'"><xsl:value-of select="$strSuspended"/></xsl:when>
				<xsl:when test="$status='9'"><xsl:value-of select="$strResume"/></xsl:when>
				<xsl:when test="$status='10'"><xsl:value-of select="$strPending"/></xsl:when>
			</xsl:choose>
	</xsl:template>

	<!--
		This template re-writes the URL to add the menu selection data; this is needed to support the browser's back button
		Keep in one line!!!
	 -->
	<xsl:template name="add-href-data">
		<xsl:value-of select="@href"/><xsl:if test="contains(@href, 'javascript') = false"><xsl:choose><xsl:when test="contains(@href, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose>ct=<xsl:value-of select="/OMA/@component" />&amp;snb=<xsl:value-of select="/OMA/@snb" />&amp;lsnb=<xsl:value-of select="/OMA/@lsnb" />&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:if>
	</xsl:template>

	<!-- This template is commented because.... Identity transformation is not possible in it's presence.
	<xsl:template match="*"/>-->
	
	<xsl:template match="Reminder">
    <html>
      <head>
        <title/>
        <link href="/oma/css/loginmaster.css" rel="stylesheet" type="text/css" />
        <script src="/oma/js/prototype.js" type="text/javascript"></script>
        <script src="/oma/js/Clarity.js" type="text/javascript"></script>
        <script src="/oma/js/gnavbar.js" type="text/javascript"></script>
        <script language="javascript">
          function reminderSubmit()
          {
              document.reminder.submit();
          }
        </script>
      </head>
      <body>
        <div class="login">
          <div class="login_header_brand">
	  <xsl:attribute name="style">background-image:url('/oma/images/<xsl:value-of select="Brand"/>/login_table_header.png')</xsl:attribute>	
           <xsl:choose>
		  <xsl:when test="Brand = 'dell'">
		   <img alt="OpenManage" title="OpenManage" >
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="Brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:when>
		  <xsl:otherwise>
		   <img>
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="Brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:otherwise>
	     </xsl:choose> 
          </div>
          <div class="login_left">
            <div class="login_right">
              <div class="login_content">
                <div class="hr"> </div>
                <div id="reboot">
                  <div id="login_failed_text"><xsl:value-of select="PageTitle/@display"/> </div>
                  <div id="server_reboot_message">
                    <xsl:value-of select="PromptText"/>
                  </div>
                </div>
                <div class="hr"> </div>
                <div>
                  <form>
                    <xsl:attribute name="action">
                      <xsl:choose>
                        <xsl:when test="contains(@submit, 'javascript') = false">
                          <xsl:value-of select="@submit"/>
                          <xsl:choose>
                            <xsl:when test="contains(@submit, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when>
                            <xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise>
                          </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="@submit"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:attribute>
                    <xsl:attribute name="name">reminder</xsl:attribute>
                    <xsl:attribute name="id">reminder</xsl:attribute>
                    <xsl:attribute name="method">post</xsl:attribute>
                    <input type="hidden" name="caller" id="caller" value=""/>
                    <input type="hidden" name="pageCode" id="pageCode" value=""/>
                    <input type="hidden" name="pageName" id="pageName" value=""/>

                    <div class="button_clear" id="login_buttons">
                    <a id="login_submit" class="blackpage_button_emphasized">
                        <xsl:attribute name="href">javascript:reminderSubmit()</xsl:attribute>
                      <span>
                        <xsl:value-of select="@submitdisplay"/>
                      </span>
                    </a>
                    <a class="blackpage_button">
                      <xsl:attribute name="href">
                        <xsl:choose>
                          <xsl:when test="contains(@LogOuthref, 'javascript') = false">
                            <xsl:value-of select="@LogOuthref"/>
                            <xsl:choose>
                              <xsl:when test="contains(@LogOuthref, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when>
                              <xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="@LogOuthref"/>
                          </xsl:otherwise>
                        </xsl:choose>
                        </xsl:attribute>
                      <span>
                        <xsl:value-of select="@LogOutDisplay"/>
                      </span>
                    </a>
                  </div>
                    <xsl:if test="HiddenTable">
                      <xsl:for-each select="HiddenTable/Data">
                        <xsl:call-template name="datatype">
                          <xsl:with-param name="type">hidden</xsl:with-param>
                          <xsl:with-param name="name"><xsl:value-of select="@name"/></xsl:with-param>
                          <xsl:with-param name="returnvalue"><xsl:value-of select="@returnvalue"/></xsl:with-param>
                          <!-- MM :Begin - D015 - fix for id issue -->
                          <xsl:with-param name="id"><xsl:value-of select="@id"/></xsl:with-param>
                          <!-- MM :End - D015 - fix for id issue -->
                        </xsl:call-template>
                      </xsl:for-each>                      
                    </xsl:if>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <div class="login_footer"> </div>
          <div class="title_links">
	   <xsl:choose>		 
		  <xsl:when test="Brand = 'dell'">
			 <a href="#" onclick="javascript:popUp.openWindow('http://support.dell.com/','null');">
			  <xsl:value-of select="$strSupport"/>
			</a>
		  </xsl:when>
		  <xsl:otherwise>
			<a href="#" onclick="javascript:popUp.openWindow('./SupportPageServlet','support');">
			<xsl:value-of select="$strSupport"/>
			</a>
		  </xsl:otherwise>
	   </xsl:choose> |            
            <a onclick="">
            <xsl:attribute name="href">javascript:popUp.openWindow ('./OMSAAbout?nbflag=true&amp;vid=<xsl:value-of select="/OMA/@vid" />','null')</xsl:attribute>
            <xsl:value-of select="$strAbout"/>
          </a>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
	
</xsl:stylesheet>
