<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:apply-templates select="DataArea"/>
	</xsl:template>
	<xsl:template match="DataArea">
		<xsl:apply-templates select="PageTitle"/>
		<xsl:apply-templates select="PromptText"/>
		<xsl:apply-templates select="SubHeader"/>
		<xsl:apply-templates select="ListData"/>
		<xsl:apply-templates select="TableData"/>
		<xsl:apply-templates select="ComboData"/>
		<xsl:apply-templates select="SummaryData"/>
	</xsl:template>
	<xsl:template match="PageTitle">
		<xsl:if test="@display">
			<xsl:value-of select="@display"/>
			<xsl:if test="@status!=''">
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>	
				<xsl:value-of select="$strHealth"/><xsl:call-template name="display-status">
				    	<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="NewLine"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="PromptText">
		<xsl:if test=". !=''">
			<xsl:choose>
				<xsl:when test="@ignoreoncli = 'true'"></xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="NewLine"/>
					<xsl:value-of select="."/>
					<xsl:call-template name="NewLine"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SubHeader">
		<xsl:call-template name="NewLine"/>
		<xsl:choose>
			<xsl:when test="@banner">
				<xsl:choose>
					<xsl:when test="@status">		
						<xsl:call-template name="banner-status">
							<xsl:with-param name="status">
		  						<xsl:value-of select="@status" /> 
		  					</xsl:with-param>
							<xsl:with-param name="display">
		  						<xsl:value-of select="@display" /> 
		  					</xsl:with-param>
		  				</xsl:call-template>
		  			</xsl:when>
					<xsl:otherwise>
	  					<xsl:value-of select="@display" />
	  				</xsl:otherwise>
	  				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@status">
						<xsl:value-of select="@display"/><xsl:text> : </xsl:text><xsl:call-template name="display-status">
						    	<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
						</xsl:call-template>
					 </xsl:when>
					 <xsl:otherwise>
						<xsl:value-of select="@display"/>
					</xsl:otherwise>
		           </xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="NewLine"/>
		<!--xsl:if test="@display">
			<xsl:call-template name="NewLine"/>
			<xsl:value-of select="@display"/>
			<xsl:call-template name="NewLine"/>
		</xsl:if-->
	</xsl:template>
	<xsl:template match="ListData">
		<xsl:apply-templates select="SubHeader"/>
		<xsl:call-template name="NewLine"/>
		<xsl:variable name="tmpattlen">
			<xsl:call-template name="MAX">
				<xsl:with-param name="list" select="Data"/>
				<xsl:with-param name="type">display</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="tmpvallen">
			<xsl:call-template name="MAX">
				<xsl:with-param name="list" select="Data"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="maxatt">
			<xsl:choose>
				<xsl:when test="@type='noheader'"><xsl:value-of select="$tmpattlen"/></xsl:when>
				<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$tmpattlen &gt; '9'"><xsl:value-of select="$tmpattlen"/></xsl:when>
					<xsl:otherwise>9</xsl:otherwise>
				</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="maxval">
			<xsl:choose>
				<xsl:when test="@type='noheader'"><xsl:value-of select="$tmpvallen"/></xsl:when>
				<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$tmpvallen &gt; '5'"><xsl:value-of select="$tmpvallen"/></xsl:when>
					<xsl:otherwise>5</xsl:otherwise>
				</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="maxlength"><xsl:value-of select="$maxatt + $maxval + 6"/></xsl:variable>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="$maxlength"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template>
		<xsl:call-template name="NewLine"/>
		<xsl:choose>
			<xsl:when test="@type='noheader'"></xsl:when>
			<xsl:otherwise>
					<xsl:text> ATTRIBUTE</xsl:text><xsl:call-template name="spaces">
					<xsl:with-param name="length" select="($maxatt - 9)"/><xsl:with-param name="character" select="' '"/>
					</xsl:call-template><xsl:text> | VALUE</xsl:text><xsl:call-template name="spaces">
					<xsl:with-param name="length" select="($maxval - 5)"/><xsl:with-param name="character" select="' '"/>
					</xsl:call-template><xsl:call-template name="endRow"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="spaces">
					<xsl:with-param name="length" select="$maxlength"/>
					<xsl:with-param name="character" select="'-'"/>
				</xsl:call-template>
				<xsl:call-template name="NewLine"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:for-each select="Data">
			<xsl:text> </xsl:text><xsl:value-of select="@display"/><xsl:call-template name="spaces">
			<xsl:with-param name="length" select="($maxatt - string-length(@display))"/><xsl:with-param name="character" select="' '"/>
			</xsl:call-template><xsl:text> | </xsl:text><xsl:call-template name="PrintValue"/><xsl:variable name="printvallen"><xsl:call-template name="MAX">
				<xsl:with-param name="list" select="."/>
			</xsl:call-template></xsl:variable><xsl:call-template name="spaces"><xsl:with-param name="length" select="($maxval - $printvallen)"/>
			<xsl:with-param name="character" select="' '"/></xsl:call-template>
			<xsl:call-template name="endRow"/>
			<xsl:call-template name="NewLine"/>
			<xsl:call-template name="spaces">
				<xsl:with-param name="length" select="$maxlength"/>
				<xsl:with-param name="character" select="'-'"/>
			</xsl:call-template>
			<xsl:call-template name="NewLine"/>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="PrintValue">
		<xsl:choose>
			<xsl:when test="@ignoreoncli='true'"></xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@type">
						<xsl:if test="@type!='hidden'">
							<xsl:choose>
								<xsl:when test="@type">
									<xsl:choose>
										<xsl:when test="@type='icon'">
											<xsl:value-of select="@alt"/>
										</xsl:when>
										<xsl:when test="@type='status'">
											<xsl:call-template name="display-status">
												<xsl:with-param name="status" select="@value" />
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="@type='status-text'">
											<xsl:call-template name="display-status">
												<xsl:with-param name="status" select="@value" />
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="@type='editbox'">
											<xsl:value-of select="@value"/>
										</xsl:when>
										<xsl:when test="@type='radio'">
											<xsl:call-template name="GetState">
												<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="@type='checkbox'">
											<xsl:call-template name="GetState">
												<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="@type='ipaddrbox'">
											<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
										</xsl:when>
										<xsl:when test="@type='select'">
											<xsl:for-each select="Choice">
												<xsl:if test="@default='true'">
													<xsl:value-of select="@value"/>
												</xsl:if>
											</xsl:for-each>
										</xsl:when>
										<xsl:when test="@type='password'">
											<xsl:call-template name="PassWord">
												<xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param>
											</xsl:call-template>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@value"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@value"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@value"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="TableData">
		<xsl:choose>
			<xsl:when test="(count(SubHeader)) > 1">
				<xsl:for-each select="SubHeader">
					<xsl:call-template name="NewLine"/>
					<xsl:choose>
						<xsl:when test="@banner">
							<xsl:choose>
								<xsl:when test="@status">		
									<xsl:call-template name="banner-status">
										<xsl:with-param name="status">
					  						<xsl:value-of select="@status" /> 
					  					</xsl:with-param>
										<xsl:with-param name="display">
					  						<xsl:value-of select="@display" /> 
					  					</xsl:with-param>
					  				</xsl:call-template>
					  			</xsl:when>
								<xsl:otherwise>
				  					<xsl:value-of select="@display" />
				  				</xsl:otherwise>
			  				</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="@status">
									<xsl:value-of select="@display"/><xsl:text> : </xsl:text><xsl:call-template name="display-status">
									    	<xsl:with-param name="status"><xsl:value-of select="@status"/></xsl:with-param>
									</xsl:call-template>
								 </xsl:when>
								 <xsl:otherwise>
									<xsl:value-of select="@display"/>
								</xsl:otherwise>
					           </xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:call-template name="NewLine"/>
				</xsl:for-each>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="SubHeader/@display">
						<xsl:call-template name="NewLine"/>
						<xsl:choose>
							<xsl:when test="SubHeader/@banner">
								<xsl:choose>
									<xsl:when test="SubHeader/@status">		
										<xsl:call-template name="banner-status">
											<xsl:with-param name="status">
						  						<xsl:value-of select="SubHeader/@status" /> 
						  					</xsl:with-param>
											<xsl:with-param name="display">
						  						<xsl:value-of select="SubHeader/@display" /> 
						  					</xsl:with-param>
						  				</xsl:call-template>
						  				<xsl:call-template name="NewLine" />
						  			</xsl:when>
									<xsl:otherwise>
					  					<xsl:value-of select="SubHeader/@display" /> 
					  					<xsl:call-template name="NewLine" /> 
					  				</xsl:otherwise>
				  				</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="SubHeader/@status">
										<xsl:value-of select="SubHeader/@display"/><xsl:text> : </xsl:text><xsl:call-template name="display-status">
										    	<xsl:with-param name="status"><xsl:value-of select="SubHeader/@status"/></xsl:with-param>
										</xsl:call-template>
									 </xsl:when>
									 <xsl:otherwise>
										<xsl:value-of select="SubHeader/@display"/>
									</xsl:otherwise>
						           </xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:call-template name="NewLine"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="NewLine"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:variable name="cols" select="count(Header/Data)"/>
		<xsl:variable name="currenttable" select="node()"/>
		<xsl:variable name="tableindex" select="position()"/>
		<xsl:variable name="columnwidths">
			<xsl:for-each select="Header/Data">
				<xsl:variable name="pos">
					<xsl:choose>
						<xsl:when test="position()=$cols">0</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="position()"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="maxlength">
					<xsl:call-template name="MAX">
						<xsl:with-param name="list" select="//TableData[$tableindex]//Data[position() mod $cols=$pos]"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$maxlength"/>
				<xsl:if test="$pos !=0">,</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="separator">
			<xsl:call-template name="AddLine">
				<xsl:with-param name="columnwidths" select="$columnwidths"/>
				<xsl:with-param name="cols" select="$cols"/>
				<xsl:with-param name="Data" select="Header/Data"/>
			</xsl:call-template>
		</xsl:variable>	
		<xsl:call-template name="Header">
			<xsl:with-param name="columnwidths" select="$columnwidths"/>
			<xsl:with-param name="cols" select="$cols"/>
			<xsl:with-param name="Header" select="Header"/>
			<xsl:with-param name="separator" select="$separator"/>
		</xsl:call-template>
		<xsl:call-template name="Row">
			<xsl:with-param name="columnwidths" select="$columnwidths"/>
			<xsl:with-param name="cols" select="$cols"/>
			<xsl:with-param name="Row" select="Row"/>
			<xsl:with-param name="header" select="Header"/>
			<xsl:with-param name="separator" select="$separator"/>								
		</xsl:call-template>
		<xsl:call-template name="NewLine"/>
	</xsl:template>
	<xsl:template match="ComboData">
		<xsl:if test="ListData/SubHeader/@display">
			<xsl:call-template name="NewLine"/>
			<xsl:value-of select="ListData/SubHeader/@display"/>
			<xsl:call-template name="NewLine"/>
		</xsl:if>
		<xsl:apply-templates select="ListData"/>
		<xsl:if test="TableData">
			<xsl:apply-templates select="TableData"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SummaryData">
		<xsl:variable name="tempAttLen">
			<xsl:call-template name="MAX">
				<xsl:with-param name="list" select="//Section//ListData//Data"/>
				<xsl:with-param name="type">display</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="tempValLen">
			<xsl:call-template name="MAX">
				<xsl:with-param name="list" select="//Section//ListData//Data"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="tempSecLen">
			<xsl:call-template name="MAX">
				<xsl:with-param name="list" select="//Section"/>
				<xsl:with-param name="type">display</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="tempLDLen">
			<xsl:call-template name="MAX">
				<xsl:with-param name="list" select="//Section//ListData"/>
				<xsl:with-param name="type">display</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="maxSingle">
			<xsl:choose>
				<xsl:when test="$tempSecLen &gt; $tempValLen"><xsl:value-of select="$tempSecLen"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$tempValLen"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>			
		<xsl:variable name="maxAtt">
			<xsl:choose>
				<xsl:when test="$tempAttLen &gt; '9'"><xsl:value-of select="$tempAttLen"/></xsl:when>
				<xsl:otherwise>9</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="maxVal">
			<xsl:choose>
				<xsl:when test="$tempValLen &gt; '5'"><xsl:value-of select="$tempValLen"/></xsl:when>
				<xsl:otherwise>5</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="maxAttVal"><xsl:value-of select="($maxAtt + 3 + $maxVal)"/></xsl:variable>
		<xsl:variable name="maxRowLen">
			<xsl:choose>
				<xsl:when test="$maxAttVal &gt; $maxSingle"><xsl:value-of select="$maxAttVal"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$maxSingle"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Start printing the Summary Table -->
		<!-- 1. Print the starting line -->
			<xsl:call-template name="AddSummaryLine"><xsl:with-param name="len"><xsl:value-of select="($maxRowLen + 3)"/></xsl:with-param></xsl:call-template>
			<xsl:call-template name="NewLine"/>
		<!-- 1. End -->
			<xsl:for-each select="Section">
				<xsl:if test="ListData">
					<!-- add empty row -->
						<xsl:call-template name="startRow"/><xsl:call-template name="spaces">
						<xsl:with-param name="length" select="($maxRowLen - 1)"/>
						<xsl:with-param name="character" select="' '"/>
						</xsl:call-template><xsl:call-template name="endRow"/>
						<xsl:call-template name="NewLine"/>
					<!-- end -->
					<!-- 2. Section name  -->
						<xsl:call-template name="startRow"/><xsl:call-template name="spaces">
						<xsl:with-param name="length" select="($maxRowLen - string-length(@display) - 1)"/>
						<xsl:with-param name="character" select="' '"/>
						</xsl:call-template><xsl:value-of select="@display"/><xsl:call-template name="endRow"/>
						<xsl:call-template name="NewLine"/>
					<!-- 2. End Section name  -->
					<!-- 3. Next Line  -->
					<xsl:call-template name="AddSummaryLine"><xsl:with-param name="len"><xsl:value-of select="($maxRowLen + 3)"/></xsl:with-param></xsl:call-template>
					<xsl:call-template name="NewLine"/>
					<!-- 3. End Next Line  -->
					<xsl:for-each select="ListData">
						<!-- 4. List Name -->
							<xsl:if test="@display">
								<xsl:call-template name="startRow"/><xsl:value-of select="@display"/><xsl:call-template name="spaces">
								<xsl:with-param name="length" select="($maxRowLen - string-length(@display) - 1)"/>
								<xsl:with-param name="character" select="' '"/>
								</xsl:call-template><xsl:call-template name="endRow"/>
								<xsl:call-template name="NewLine"/>
								<!-- 5. Next Line  -->
									<xsl:call-template name="AddSummaryLine"><xsl:with-param name="len"><xsl:value-of select="($maxRowLen + 3)"/></xsl:with-param></xsl:call-template>
									<xsl:call-template name="NewLine"/>
								<!-- 5. End Next Line  -->
							</xsl:if>
						<!-- 4. End List Name -->
						<!-- 6. Print Attribute and Value Strings  -->
							<xsl:call-template name="attValHeader">
								<xsl:with-param name="attLen"><xsl:value-of select="$maxAtt"/></xsl:with-param>
								<xsl:with-param name="rowLen"><xsl:value-of select="$maxRowLen"/></xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="NewLine"/>
						<!-- 6. End Print Attribute and Value Header  -->
						<!-- 7. Next Line  -->
							<xsl:call-template name="AddSummaryLine"><xsl:with-param name="len"><xsl:value-of select="($maxRowLen + 3)"/></xsl:with-param></xsl:call-template>
							<xsl:call-template name="NewLine"/>
						<!-- 7. End Next Line -->
						<!-- 8. Print Data  -->
						<xsl:for-each select="Data">
							<xsl:call-template name="startRow"/><xsl:value-of select="@display"/><xsl:call-template name="spaces">
								<xsl:with-param name="length"><xsl:value-of select="($maxAtt - string-length(@display))"/></xsl:with-param><xsl:with-param name="character" select="' '"/>	</xsl:call-template><xsl:text> | </xsl:text><xsl:value-of select="@value"/><xsl:call-template name="spaces"><xsl:with-param name="length"><xsl:value-of select="($maxRowLen 	- ($maxAtt + string-length(@value) + 3))"/></xsl:with-param><xsl:with-param name="character" select="' '"/></xsl:call-template>
							<xsl:text>|</xsl:text>
							<xsl:call-template name="NewLine"/>
							<!-- 9. Last Line  -->
								<xsl:call-template name="AddSummaryLine"><xsl:with-param name="len"><xsl:value-of select="($maxRowLen + 3)"/></xsl:with-param></xsl:call-template>
								<xsl:call-template name="NewLine"/>
							<!-- 9. End Last Line  -->
						</xsl:for-each>
						<!-- 8. End Print Data -->
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		<!-- End printing the Summary Table -->
	</xsl:template>
	<xsl:template name="AddSummaryLine">
		<xsl:param name="len"/>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length"><xsl:value-of select="$len"/></xsl:with-param>
			<xsl:with-param name="character">-</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="startRow"><xsl:text>| </xsl:text></xsl:template>
	<xsl:template name="endRow"><xsl:text> |</xsl:text></xsl:template>
	<xsl:template name="attValHeader">
		<xsl:param name="attLen"/>
		<xsl:param name="rowLen"/><xsl:text>| ATTRIBUTE</xsl:text><xsl:call-template name="spaces">
				<xsl:with-param name="length" select="($attLen - 9)"/>
				<xsl:with-param name="character" select="' '"/>
			</xsl:call-template><xsl:text> | VALUE</xsl:text><xsl:call-template name="spaces">
				<xsl:with-param name="length" select="($rowLen - ($attLen + 3 + 5))"/>
				<xsl:with-param name="character" select="' '"/>
			</xsl:call-template><xsl:text>|</xsl:text>
	</xsl:template>
	<xsl:template match="Section">
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="string-length(@display)"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template>	
		<xsl:call-template name="NewLine"/>
		<xsl:value-of select="@display"/>
		<xsl:call-template name="NewLine"/>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="string-length(@display)"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template>
		<xsl:call-template name="NewLine"/>
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template name="Header">
		<xsl:param name="columnwidths"/>
		<xsl:param name="cols"/>
		<xsl:param name="Header"/>
		<xsl:param name="separator"/>
			<xsl:value-of select="$separator"/>
			<xsl:call-template name="NewLine"/>
			<xsl:call-template name="HeaderData">
				<xsl:with-param name="columnwidths" select="$columnwidths"/>
				<xsl:with-param name="cols" select="$cols"/>
				<xsl:with-param name="Data" select="$Header/Data"/>
				<xsl:with-param name="separator" select="$separator"/>
			</xsl:call-template>
	</xsl:template>
	<xsl:template name="Row">
		<xsl:param name="columnwidths"/>
		<xsl:param name="cols"/>
		<xsl:param name="Row"/>
		<xsl:param name="header"/>
		<xsl:param name="separator"/>				
		<xsl:for-each select="$Row">
			<xsl:call-template name="RowData">
				<xsl:with-param name="columnwidths" select="$columnwidths"/>
				<xsl:with-param name="cols" select="$cols"/>
				<xsl:with-param name="Data" select="Data"/>
				<xsl:with-param name="header" select="$header"/>
				<xsl:with-param name="separator" select="$separator"/>
			</xsl:call-template>
			<xsl:if test="position() != last()">
				<xsl:call-template name="NewLine"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="HeaderData">
		<xsl:param name="cols"/>
		<xsl:param name="columnwidths"/>
		<xsl:param name="Data"/>
		<xsl:param name="separator"/>
			<xsl:for-each select="$Data">
				<xsl:choose>
					<xsl:when test="@ignoreoncli='true'"></xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@display"/>
						<xsl:variable name="column">
							<xsl:choose>
								<xsl:when test="(position() mod $cols)=0"><xsl:value-of select="$cols"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="position()"/></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>	
						<xsl:variable name="columnwidth">
							<xsl:call-template name="getcolumnwidth">
								<xsl:with-param name="list" select="$columnwidths"/>
								<xsl:with-param name="column" select="$column"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="spaces">
							<xsl:value-of select="(($columnwidth) - string-length(@display))"/>
						</xsl:variable>
						<xsl:call-template name="spaces">
							<xsl:with-param name="length" select="$spaces"/>
							<xsl:with-param name="character" select="' '"/>
						</xsl:call-template>
						<xsl:choose>
							<xsl:when test="position()!=last()"><xsl:text>| </xsl:text></xsl:when>
							<xsl:otherwise><xsl:text>|</xsl:text></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<xsl:call-template name="NewLine"/>
			<xsl:value-of select="$separator"/>
			<xsl:call-template name="NewLine"/>
	</xsl:template>
	<xsl:template name="RowData">
		<xsl:param name="columnwidths"/>
		<xsl:param name="cols"/>
		<xsl:param name="Data"/>
		<xsl:param name="header"/>
		<xsl:param name="separator"/>
		<xsl:for-each select="$Data">
			<xsl:choose>
				<xsl:when test="@ignoreoncli='true'"></xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@type">
							<xsl:choose>
								<xsl:when test="@type='icon'">
									<xsl:value-of select="@alt"/>
								</xsl:when>
								<xsl:when test="@type='status'">
									<xsl:call-template name="display-status">
										<xsl:with-param name="status" select="@value" />
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="@type='status-text'">
									<xsl:call-template name="display-status">
										<xsl:with-param name="status" select="@value" />
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="@type='editbox'">
									<xsl:value-of select="@value"/>
								</xsl:when>
								<xsl:when test="@type='radio'">
									<xsl:call-template name="GetState">
										<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="@type='checkbox'">
									<xsl:call-template name="GetState">
										<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="@type='ipaddrbox'">
									<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
								</xsl:when>
								<xsl:when test="@type='select'">
									<xsl:for-each select="Choice">
										<xsl:if test="@default='true'"><xsl:value-of select="@value"/></xsl:if>
									</xsl:for-each>
								</xsl:when>
								<xsl:when test="@type='password'">
									<xsl:call-template name="PassWord">
										<xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@value"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
						
							<xsl:choose>
								<xsl:when test="ValueList">
									<xsl:for-each select="ValueList/value"><xsl:value-of select="."/><xsl:text>. </xsl:text> </xsl:for-each>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@value"/>
								</xsl:otherwise>
							</xsl:choose>
						
						</xsl:otherwise>
					</xsl:choose>
					<xsl:variable name="column">
						<xsl:choose>
							<xsl:when test="(position() mod $cols)=0"><xsl:value-of select="$cols"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="position()"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>		
					<xsl:variable name="columnwidth">
						<xsl:call-template name="getcolumnwidth">
							<xsl:with-param name="list" select="$columnwidths"/>
							<xsl:with-param name="column" select="$column"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="spaces">
						<xsl:choose>
							<xsl:when test="@type">
								<xsl:choose>
									<xsl:when test="@type='status'">
										<xsl:variable name="statusLen"><xsl:call-template name="status-length"><xsl:with-param name="status" select="@value" /></xsl:call-template></xsl:variable><xsl:value-of select="(($columnwidth) - ($statusLen))"/></xsl:when>
									<xsl:when test="@type='status-text'">	
										<xsl:variable name="status-textLen"><xsl:call-template name="status-length"><xsl:with-param name="status" select="@value" /></xsl:call-template></xsl:variable><xsl:value-of select="(($columnwidth) - ($status-textLen))"/></xsl:when>
									<xsl:when test="@type='icon'"><xsl:value-of select="(($columnwidth) - string-length(@alt))"/></xsl:when>
									<xsl:when test="@type='editbox'"><xsl:value-of select="(($columnwidth) - string-length(@value))"/>	</xsl:when>
									<xsl:when test="@type='radio'">
										<xsl:variable name="radiostr">
											<xsl:call-template name="GetState">
												<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:value-of select="(($columnwidth) - string-length($radiostr))"/>
									</xsl:when>
									<xsl:when test="@type='checkbox'">
										<xsl:variable name="chboxstr">
											<xsl:call-template name="GetState">
												<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:value-of select="(($columnwidth) - string-length($chboxstr))"/>
									</xsl:when>
									<xsl:when test="@type='ipaddrbox'">
										<xsl:variable name="ipadd"><xsl:value-of select="@value1"/>.<xsl:value-of select="@value2"/>.<xsl:value-of select="@value3"/>.<xsl:value-of 		select="@value4"/></xsl:variable>
										<xsl:value-of select="(($columnwidth) - string-length($ipadd))"/>
									</xsl:when>
									<xsl:when test="@type='password'">
										<xsl:value-of select="($columnwidth - (@size))"/>
									</xsl:when>
									<xsl:when test="@type='select'">
										<xsl:for-each select="Choice">
											<xsl:if test="@default='true'"><xsl:value-of select="(($columnwidth) - string-length(@value))"/></xsl:if>
										</xsl:for-each>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="(($columnwidth) - string-length(@value))"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="ValueList/value">
										<xsl:variable name="tmpNodesString">
											<xsl:for-each select="ValueList/value"><xsl:value-of select="."/><xsl:text>. </xsl:text></xsl:for-each>
										</xsl:variable>
										<xsl:value-of select="(($columnwidth) - string-length($tmpNodesString))"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="(($columnwidth) - string-length(@value))"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:call-template name="spaces">
						<xsl:with-param name="length" select="$spaces"/>
						<xsl:with-param name="character" select="' '"/>
					</xsl:call-template>
					<xsl:choose>
						<xsl:when test="position()!=last()"><xsl:text>| </xsl:text></xsl:when>
						<xsl:otherwise><xsl:text>|</xsl:text></xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:call-template name="NewLine"/>
		<xsl:value-of select="$separator"/>
	</xsl:template>
	<xsl:template name="DataList">
		<xsl:param name="columnwidth"/>
		<xsl:param name="Data"/>
			<xsl:for-each select="$Data">
				<xsl:choose>
					<xsl:when test="@ignoreoncli='true'"></xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@type">
								<xsl:if test="@type!='hidden'">
									<xsl:value-of select="@display"/>
									<xsl:variable name="spaces">
										<xsl:value-of select="(($columnwidth) - string-length(@display))"/>
									</xsl:variable>
									<xsl:call-template name="spaces">
										<xsl:with-param name="length" select="$spaces"/>
										<xsl:with-param name="character" select="' '"/>
									</xsl:call-template>
									<xsl:text> : </xsl:text>
									<xsl:choose>
										<xsl:when test="@type">
											<xsl:choose>
												<xsl:when test="@type='icon'">
													<xsl:value-of select="@alt"/>
												</xsl:when>
												<xsl:when test="@type='status'">
													<xsl:call-template name="display-status">
														<xsl:with-param name="status" select="@value" />
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='status-text'">
													<xsl:call-template name="display-status">
														<xsl:with-param name="status" select="@value" />
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='editbox'">
													<xsl:value-of select="@value"/>
												</xsl:when>
												<xsl:when test="@type='radio'">
													<xsl:call-template name="GetState">
														<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='checkbox'">
													<xsl:call-template name="GetState">
														<xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="@type='ipaddrbox'">
													<xsl:value-of select="@value1"/><xsl:text>.</xsl:text><xsl:value-of select="@value2"/><xsl:text>.</xsl:text><xsl:value-of select="@value3"/><xsl:text>.</xsl:text><xsl:value-of select="@value4"/>
												</xsl:when>
												<xsl:when test="@type='select'">
													<xsl:for-each select="Choice">
														<xsl:if test="@default='true'">
															<xsl:value-of select="@value"/>
														</xsl:if>
													</xsl:for-each>
												</xsl:when>
												<xsl:when test="@type='password'">
													<xsl:call-template name="PassWord">
														<xsl:with-param name="size"><xsl:value-of select="@size"/></xsl:with-param>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="@value"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@value"/>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:call-template name="NewLine"/>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@display"/>
								<xsl:variable name="spaces">
									<xsl:value-of select="(($columnwidth) - string-length(@display))"/>
								</xsl:variable>
								<xsl:call-template name="spaces">
									<xsl:with-param name="length" select="$spaces"/>
									<xsl:with-param name="character" select="' '"/>
								</xsl:call-template>
								<xsl:text> : </xsl:text>
								<xsl:value-of select="@value"/>
								<xsl:call-template name="NewLine"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>	
	</xsl:template>
	<xsl:template name="getcolumnwidth">
		<xsl:param name="list"/>
		<xsl:param name="column"/>
		<xsl:choose>
			<xsl:when test="$list">
				<xsl:choose>
					<xsl:when test="$column=1">
						<xsl:choose>
							<xsl:when test="contains($list,',')">
								<xsl:value-of select="substring-before($list,',')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$list"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="$column &gt; 1">
						<xsl:variable name="last">
							<xsl:value-of select="substring-after($list,',')"/>
						</xsl:variable>
						<xsl:call-template name="getcolumnwidth">
							<xsl:with-param name="list" select="$last"/>
							<xsl:with-param name="column" select="($column)-1"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="MAX">
		<xsl:param name="list"/>
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$list">
				<xsl:variable name="first">
					<xsl:choose>
						<xsl:when test="$type='display'">
							<xsl:choose>
								<xsl:when test="($list[1]/@ignoreoncli)='true'">0</xsl:when>
								<xsl:otherwise><xsl:value-of select="string-length($list[1]/@display)"/></xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="($list[1]/@ignoreoncli)='true'">0</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="($list[1]/@type)='editbox'"><xsl:value-of select="string-length($list[1]/@value)"/></xsl:when>
										<xsl:when test="($list[1]/@type)='radio'">
											<xsl:choose>
												<xsl:when test="$list[1]/@state='2'">5</xsl:when>
												<xsl:otherwise>4</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:when test="($list[1]/@type)='checkbox'">
											<xsl:choose>
												<xsl:when test="$list[1]/@state='2'">5</xsl:when>
												<xsl:otherwise>4</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:when test="($list[1]/@type)='select'">
											<xsl:for-each select="$list[1]/Choice">
												<xsl:if test="@default='true'">
													<xsl:value-of select="string-length(@value)"/>
												</xsl:if>
											</xsl:for-each>
										</xsl:when>
										<xsl:when test="($list[1]/@type)='password'"><xsl:value-of select="$list[1]/@size"/></xsl:when>
										<xsl:when test="($list[1]/@type)='ipaddrbox'">15</xsl:when>
										<xsl:when test="($list[1]/@type)='icon'"><xsl:value-of select="string-length($list[1]/@alt)"/></xsl:when>
										<xsl:when test="$list[1]/@type='status'"><xsl:call-template name="status-length"><xsl:with-param name="status" select="$list[1]/@value" /></xsl:call-template></xsl:when>
										<xsl:when test="$list[1]/@type='status-text'"><xsl:call-template name="status-length"><xsl:with-param name="status" select="$list[1]/@value" /></xsl:call-template></xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$list[1]/ValueList/value">
													<xsl:variable name="tmpNodesString">
														<xsl:for-each select="$list[1]/ValueList/value"><xsl:value-of select="."/><xsl:text>. </xsl:text></xsl:for-each>
													</xsl:variable>
													<xsl:value-of select="string-length($tmpNodesString) + 2"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="string-length($list[1]/@value)"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="rest">
					<xsl:call-template name="MAX">
						<xsl:with-param name="list" select="$list[position()!=1]"/>
						<xsl:with-param name="type" select="$type"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:choose>
				     <!--The following translate stuff removes spurious comma inserted when in French or German Locale under Linux 7.2  -->
					<xsl:when test="normalize-space(translate($first,',',' ')) &gt; normalize-space(translate($rest,',',' ')) ">
						<xsl:value-of select="normalize-space(translate($first,',',' '))"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$rest"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="spaces">
		<xsl:param name="length"/>
		<xsl:param name="character"/>
		<xsl:if test="$length!=0">
			<xsl:value-of select="$character"/>
			<xsl:call-template name="spaces">
				<!--The following translate stuff removes spurious comma inserted when in French or German Locale under Linux 7.2  -->
				<xsl:with-param name="length" select="normalize-space(translate($length,',',' '))-1"/>
				<xsl:with-param name="character" select="$character"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>	
	<xsl:template name="AddLine">
		<xsl:param name="cols"/>
		<xsl:param name="columnwidths"/>
		<xsl:param name="Data"/>
		<xsl:for-each select="$Data">
			<xsl:choose>
				<xsl:when test="@ignoreoncli='true'"></xsl:when>
				<xsl:otherwise>
					<xsl:if test="position() != 1"><xsl:text>-</xsl:text></xsl:if>
					<xsl:variable name="column">
						<xsl:choose>
							<xsl:when test="(position() mod $cols)=0"><xsl:value-of select="$cols"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="position()"/></xsl:otherwise>
						</xsl:choose>
					</xsl:variable>	
					<xsl:variable name="columnwidth">
						<xsl:call-template name="getcolumnwidth">
							<xsl:with-param name="list" select="$columnwidths"/>
							<xsl:with-param name="column" select="$column"/>
						</xsl:call-template>
					</xsl:variable>	
					<xsl:call-template name="spaces">
						<xsl:with-param name="length" select="$columnwidth"/>
						<xsl:with-param name="character" select="'-'"/>
					</xsl:call-template>
					<xsl:text>-</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>
	<xsl:template name="GetState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state=1">true</xsl:when>
			<xsl:when test="$state=3">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="PassWord">
		<xsl:param name="size"/>
		<xsl:if test="$size &gt; '0'">
			<xsl:text>*</xsl:text>
			<xsl:call-template name="PassWord">
				<xsl:with-param name="size"><xsl:value-of select="($size) - 1"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
<xsl:template name="banner-status">
		<xsl:param name="status" />
		<xsl:param name="display" />
		<xsl:variable name="StatusLen">
			<xsl:call-template name="GetStatusLen">
				<xsl:with-param name="status" select="$status"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="(string-length(@display) + 1 +$StatusLen )"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template>
		<xsl:call-template name="NewLine"/>
		<xsl:value-of select="@display" /> 
		<xsl:text>: </xsl:text>
		<xsl:call-template name="GetStatus">
			<xsl:with-param name="status" select="$status"/>
		</xsl:call-template>
		<xsl:call-template name="NewLine"/>
		<xsl:call-template name="spaces">
			<xsl:with-param name="length" select="(string-length(@display) + 1 +$StatusLen )"/>
			<xsl:with-param name="character" select="'-'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="GetStatusLen">
		<xsl:param name="status" />
		<xsl:variable name="StatusStr">
			<xsl:call-template name="GetStatus">
				<xsl:with-param name="status" select="$status"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="(string-length( $StatusStr ) + 1)"/>
	</xsl:template>

	<xsl:template name="GetStatus">
		<xsl:param name="status" />
		<xsl:choose>
			<xsl:when test="$status='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
			<xsl:when test="$status='1'"><xsl:value-of select="$strUnknown1"/></xsl:when>
			<xsl:when test="$status='2'"><xsl:value-of select="$strOk"/></xsl:when>
			<xsl:when test="$status='3'"><xsl:value-of select="$strNonCritical"/></xsl:when>
			<xsl:when test="$status='4'"><xsl:value-of select="$strCritical"/></xsl:when>
			<xsl:when test="$status='5'"><xsl:value-of select="$strNonRecoverable"/></xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="display-status">
		<xsl:param name="status" />
		<xsl:call-template name="GetStatus">
			<xsl:with-param name="status" select="$status"/>
		</xsl:call-template>		
	</xsl:template>
	<xsl:template name="status-length">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status='0'">7</xsl:when>
			<xsl:when test="$status='1'">7</xsl:when>
			<xsl:when test="$status='2'">2</xsl:when>
			<xsl:when test="$status='3'">12</xsl:when>
			<xsl:when test="$status='4'">8</xsl:when>
			<xsl:when test="$status='5'">15</xsl:when>
			<xsl:otherwise>7</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
