<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea>
			<xsl:if test="Failure/@mode !='port' and  Failure/@mode !='snmp'">
				<xsl:attribute name="email">false</xsl:attribute>
			</xsl:if>
			
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strGoBack"/></xsl:attribute>
			<xsl:attribute name="submit">
				<xsl:choose>
					<xsl:when test="Caller">
						<xsl:call-template name="Caller">
							<xsl:with-param name="caller">
								<xsl:value-of select="translate(Caller, &apos;;&apos;,&apos;&amp;&apos;)"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>javascript:history.back ()</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

					<script language="javascript">
					function clearCmdLog()
					{
						document.dataarea.action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.oma.webplugins.ClearCmdLogWebPlugin');
						if(confirm('<xsl:value-of select="$strAreYouSure"/>'))
							document.dataarea.submit();
					}
					
						function clearAltLog()
						{
							document.dataarea.action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.hip.webplugins.ClearAlertLogWebPlugin');
							if(confirm('<xsl:value-of select="$strAreYouSure"/>'))
							{
								document.dataarea.submit();
							}
						}

					</script>
		

			<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strFailureMessage"/></xsl:attribute>
			</PageTitle>
				<CustomButton>
					<xsl:if test="/OMA/log='CommandLog'">

							<Data name="Clear"><xsl:attribute name="display"><xsl:value-of select="$strClearLog"/></xsl:attribute>
								<xsl:attribute name="href">javascript:clearCmdLog()</xsl:attribute>
								<xsl:attribute name="formSubmit">true</xsl:attribute>
							</Data>
				</xsl:if>	
				<xsl:if test="/OMA/log='AlertLog'">

							<Data name="Clear"><xsl:attribute name="display"><xsl:value-of select="$strClearLog"/></xsl:attribute>
								<xsl:attribute name="href">javascript:clearAltLog()</xsl:attribute>
								<xsl:attribute name="formSubmit">true</xsl:attribute>
							</Data>
				</xsl:if>	
				</CustomButton>

			<ListData>
				<Data  name="Failure  Reason : ">
					<xsl:attribute name="display">
						<xsl:choose>
							<xsl:when test="Failure/@mode='port'">
								<xsl:value-of select="$strPort"/><xsl:text disable-output-escaping="yes">  </xsl:text><xsl:value-of select="Failure"/><xsl:text disable-output-escaping="yes">  </xsl:text><xsl:value-of select="$strIsAlreadyIn"/>
							</xsl:when>
							<xsl:when test="Failure/@mode='snmp'">
								<xsl:choose>
									<xsl:when test="Failure='2'"><xsl:value-of select="$strOldSNMPRoot"/></xsl:when>
									<xsl:when test="Failure='100'"><xsl:value-of select="$strSNMPSet"/></xsl:when>
									<xsl:when test="Failure='200'"><xsl:value-of select="$strSNMPErr"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$strSNMPRootPassword"/></xsl:otherwise>
								</xsl:choose>								
							</xsl:when>
							<xsl:when test="Failure/@mode='xmlerror'">
								<xsl:value-of select="$strXMLError"/>
							</xsl:when>
							<xsl:when test="SMStatus='4308' ">
								<xsl:value-of select="$strInbandErr"/>
							</xsl:when>
							<xsl:when test="SMStatus='212' ">
								<xsl:value-of select="$strInbandErr"/>
							</xsl:when>
							<xsl:when test="SMStatus='303' ">
								<xsl:value-of select="$strIPv4andIPv6Err"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strGenericErr"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</Data>
			</ListData>
		</DataArea>
	</xsl:template>
	
	<xsl:template name="Caller">
		<xsl:param name="caller"/>
		<xsl:choose>
			<xsl:when test="contains ( $caller , 'onload=true')">
				<xsl:variable name="first" select="substring-before($caller , 'onload=true')"/>
				<xsl:variable name="second" select="substring-after($caller , 'onload=true')"/>				
				<xsl:value-of select="concat($first , 'onload=false' , $second)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$caller"/>
			</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	
	<xsl:template match="*"/>	
</xsl:stylesheet>
