<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>

	<xsl:variable name="subCommandIndentSize">17</xsl:variable>

	<xsl:template match="/OMA">
		<xsl:call-template name="CLISubCommand">
			<xsl:with-param name="command"><xsl:value-of select="CLISubCommand"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="CLIMsgID">
			<xsl:with-param name="id"><xsl:value-of select="CLIMsgID"/></xsl:with-param>
			<xsl:with-param name="shownvpairs"><xsl:value-of select="CLIShowNVPairs"/></xsl:with-param>
			<xsl:with-param name="nametxt">
				<xsl:value-of select="CLIParseName"/>
			</xsl:with-param>
			<xsl:with-param name="paramtxt">
				<xsl:value-of select="CLIParamName"/>
			</xsl:with-param>
			<xsl:with-param name="parsetxt">
				<xsl:value-of select="CLIParseTxt"/>
			</xsl:with-param>
			<xsl:with-param name="parsetxt2">
				<xsl:value-of select="CLIParseTxt2"/>
			</xsl:with-param>
			<xsl:with-param name="hipstat">
				<xsl:value-of select="CustomStat"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="CLIMsgID">
		<xsl:param name="id"/>
		<xsl:param name="shownvpairs"/>
		<xsl:param name="nametxt"/>
		<xsl:param name="paramtxt"/>
		<xsl:param name="parsetxt"/>
		<xsl:param name="parsetxt2"/>
		<xsl:param name="hipstat"/>
		<xsl:choose>
		<xsl:when test="$id = '20'">
				<!--XLATESTART-->Webserver preferences.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>

					<xsl:text>attribute=geturl             </xsl:text><!--XLATESTART-->Displays webserver URL information.<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>attribute=getsignalgorithm   </xsl:text><!--XLATESTART-->Displays current key sign algorithm.<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>attribute=getjre             </xsl:text><!--XLATESTART-->Displays JRE currently being used.<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>attribute=getjrelist         </xsl:text><!--XLATESTART-->Displays available JREs in the System.<!--XLATESTOP-->
		</xsl:when>
					
			
				<xsl:when test="$id = '22'">
				<!--XLATESTART-->Messages preferences.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
					<xsl:call-template name="NewLine"/>
					<xsl:text>attribute=format             </xsl:text><!--XLATESTART-->Displays the currently configured format for the event messages preference.<!--XLATESTOP-->
				</xsl:when>	
			
			<xsl:when test="$id = '999'">
				<!--XLATETHIS-->For further help, type the command followed by -?<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1000'">
                     <xsl:call-template name="ConfigSuccess">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
					<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
					<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
					<xsl:with-param name="parseTxt2"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1001'">
				<!--XLATETHIS-->Error! Signed number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
			</xsl:when>
            <xsl:when test="$id = '1002'">
                <!--XLATETHIS-->Error!. Unsigned, whole number expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1003'">
                <!--XLATETHIS-->Error! true or false expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
            <xsl:when test="$id = '1004'">
                <!--XLATETHIS-->Error! alphanumeric or symbol expected, read: <!--XLATETHIS--><xsl:value-of select="$parsetxt2"/><xsl:text>=</xsl:text><xsl:value-of select="$parsetxt"/>
            </xsl:when>
	         	<xsl:when test="$id = '1005'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
			      <xsl:call-template name="CLIParamFormat"><xsl:with-param name="format"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			
			<xsl:when test="$id = '1007'">
				<!--XLATETHIS-->Error! Command incomplete: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1008'">
			      <xsl:call-template name="CLIObjNotFound">
					<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
			      </xsl:call-template>
			</xsl:when>
			<xsl:when test="$id = '1009'">
				<!--XLATETHIS-->Error! cannot load data accessor: <!--XLATETHIS-->
			</xsl:when>
			
			<xsl:when test="$id = '1011'">
			      <xsl:call-template name="CLICommandFailed">
				<xsl:with-param name="subCom"><xsl:value-of select="$nametxt"/></xsl:with-param>
     				<xsl:with-param name="paramNam"><xsl:value-of select="$paramtxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt"><xsl:value-of select="$parsetxt"/></xsl:with-param>
     				<xsl:with-param name="parseTxt2"><xsl:value-of select="$parsetxt2"/></xsl:with-param>
				<xsl:with-param name="stat"><xsl:value-of select="$hipstat"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<xsl:when test="$id = '1012'">
				<!--XLATETHIS-->Error! Unrecognized command value: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			
			<xsl:when test="$id = '1014'">
				<!--XLATETHIS-->Error! Value incorrect : <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
			</xsl:when>
					
			<xsl:when test="$id = '1025'">
				<!--XLATETHIS-->Error! Unrecognized parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1028'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
			</xsl:when>

			<xsl:when test="$id = '1040'">
				<!--XLATETHIS-->Error! Unrecognized parameter <!--XLATETHIS-->
			</xsl:when>
				
			<xsl:when test="$id = '2180'">
				<xsl:call-template name="CLISubCommand">
				<xsl:with-param name="command">webserver</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set the webserver preferences.<!--XLATESTOP-->
			</xsl:when>

			<xsl:when test="$id = '2181'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">webserver</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Set the webserver preferences.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->attribute=&lt;sslencryption&gt;	setting=&lt;autonegotiate|128bitorhigher&gt;<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->attribute=&lt;seturl&gt;	        host=&lt;string&gt; port=&lt;value&gt;<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->attribute=&lt;signalgorithm&gt;    	setting=&lt;MD5|SHA1|SHA256|SHA512&gt;<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->attribute=&lt;setjre&gt;    	        jreversion=&lt;bundled|value&gt;<!--XLATESTOP-->
				
				</xsl:when>			

				<xsl:when test="$id = '2183'">
				<xsl:call-template name="CLISubCommand">
				<xsl:with-param name="command">messages</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Sets the format for the event messages preference.<!--XLATESTOP-->
				</xsl:when>

				<xsl:when test="$id = '2184'">
				<xsl:call-template name="CLISubCommand">
					<xsl:with-param name="command">messages</xsl:with-param>
				</xsl:call-template>
				<!--XLATESTART-->Sets the format for the event messages preference.<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
				<!--XLATESTART-->Valid parameters are:<!--XLATESTOP-->
				<xsl:call-template name="NewLine"/>
					<!--XLATESTART-->attribute=&lt;format&gt;    	setting=&lt;traditional|enhanced&gt;<!--XLATESTOP-->
				</xsl:when>			
				<xsl:when test="$id = '1310'">
				<!--XLATETHIS-->Error! Host address is not valid or number of characters are exceeded more than 255.<!--XLATETHIS-->
				</xsl:when>
				<xsl:when test="$id = '1375'">
				<!--XLATETHIS-->URL configuration is not supported because Server Administrator web server is present on this system<!--XLATETHIS-->
				</xsl:when>
				<xsl:when test="$id = '1376'">
					<xsl:choose>
					<xsl:when test="$paramtxt='signalgorithm'">
						<!--XLATETHIS-->Certificate key sign algorithm configuration is not supported because Server Administrator web server is not present on this system<!--XLATETHIS-->
					</xsl:when>
					<xsl:when test="$paramtxt='setjre'">
						<!--XLATETHIS-->Error! Webserver not present. JRE get and set operations not supported.<!--XLATETHIS-->
					</xsl:when>
					<xsl:otherwise>
						<!--XLATETHIS-->Certificate key sign algorithm retrieval is not supported because Server Administrator web server is not present on this system<!--XLATETHIS-->
					</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="NewLine"/>
	</xsl:template>
	
	<xsl:template name="ConfigSuccess">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="parseTxt2"/>
		<xsl:choose>
			
			<xsl:when test="$subCom = 'webserver' and $paramNam='seturl' " >
			   <xsl:text>Server Administrator Webserver URL is configured successfully.</xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = 'webserver' and $paramNam='sslencryption' " >
			   <xsl:text>SSL encryption value set successfully. You need to restart the webserver in order to make the change(s) effective. </xsl:text>
			</xsl:when>

			<xsl:when test="$subCom = 'webserver' and $paramNam='signalgorithm' " >
			   <xsl:text>Certificate signing algorithm for self signed certificates is set successfully. You need to restart the webserver in order to make the change(s) effective. </xsl:text>
			   <xsl:choose>
			   <xsl:when test="$parseTxt = 'sha512' or $parseTxt = 'sha256'">
			   <xsl:call-template name="NewLine"/>
			   <xsl:call-template name="NewLine"/>
			   	<xsl:text>Note: SHA256/SHA512 may not be supported by all browsers and operating systems.</xsl:text>
			   <xsl:call-template name="NewLine"/>
			   	<xsl:text>      This setting will be effective only for Server Administrator self-signed certificate.</xsl:text>			   	
			   </xsl:when>
			   <xsl:when test="$parseTxt = 'md5'">
			   <xsl:call-template name="NewLine"/>
			   <xsl:call-template name="NewLine"/>
			   	<xsl:text>Note: MD5 is deprecated.</xsl:text>
			   <xsl:call-template name="NewLine"/>
			   	<xsl:text>      This setting will be effective only for Server Administrator self-signed certificate.</xsl:text>			   	
			   </xsl:when>			   
			   <xsl:otherwise>
			   <xsl:call-template name="NewLine"/>
			   <xsl:call-template name="NewLine"/>
			   	<xsl:text>Note: This setting will be effective only for Server Administrator self-signed certificate.</xsl:text>			   	
			   </xsl:otherwise>
			   </xsl:choose>
			</xsl:when>
      
      <xsl:when test="$subCom = 'webserver' and $paramNam='setjre' " >
        <xsl:text>JRE value is set successfully. Restart the webserver to make the change(s) effective.</xsl:text>
      </xsl:when>


      <xsl:otherwise>
				<!--XLATESTART-->Command successful.<!--XLATESTOP-->
                </xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CLICommandFailed">
		<xsl:param name="subCom"/>
		<xsl:param name="paramNam"/>
		<xsl:param name="parseTxt"/>
		<xsl:param name="parseTxt2"/>
		<xsl:param name="stat"/>
		<xsl:choose>
		<xsl:when test="$stat">
			<xsl:call-template name="GetErrorMessage">
				<xsl:with-param name="ErrorMsgID">
					<xsl:value-of select="$stat"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="$subCom = 'webserver' and $paramNam='sslencryption' ">
					<xsl:text>Error!Feature is not present. Since the webserver component is not installed.</xsl:text>
				</xsl:when>
				<xsl:when test="$subCom = 'webserver' and $paramNam='signalgorithm' ">
					<xsl:text>Error!Feature is not present. Since the webserver component is not installed.</xsl:text>
				</xsl:when>
				<xsl:when test="$subCom = 'webserver' and $paramNam='setjre' ">
				<xsl:text>Error! Webserver not present. JRE get and set operations not supported.</xsl:text>
				</xsl:when>
				<xsl:otherwise><!--XLATESTART-->Error! Hardware subsystem reports command failed. <!--XLATESTOP--></xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template >
	<xsl:template name="CLISubCommand">
		<xsl:param name="command"/>
		<xsl:if test="$command != ''">
			<xsl:value-of select="$command"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="(17) - string-length($command)"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Spaces">
		<xsl:param name="num"/>
		<xsl:choose>
			<xsl:when test="$num = '19'">
				<xsl:text>                   </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '18'">
				<xsl:text>                  </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '17'">
				<xsl:text>                 </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '16'">
				<xsl:text>                </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '15'">
				<xsl:text>               </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '14'">
				<xsl:text>              </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '13'">
				<xsl:text>             </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '12'">
				<xsl:text>            </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '11'">
				<xsl:text>           </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '10'">
				<xsl:text>          </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '9'">
				<xsl:text>         </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '8'">
				<xsl:text>        </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '7'">
				<xsl:text>       </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '6'">
				<xsl:text>      </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '5'">
				<xsl:text>     </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '4'">
				<xsl:text>    </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '3'">
				<xsl:text>   </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '2'">
				<xsl:text>  </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '1'">
				<xsl:text> </xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="NewLine">
	<xsl:text>
</xsl:text>
	</xsl:template>

	<xsl:template name="CLIParamFormat">
		<xsl:param name="format"/>
		<xsl:choose>
			<xsl:when test="$format = '1'">
			     <xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '2'">
			     <xsl:text>text</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '3'">
			     <xsl:text>text (alphanumeric only)</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '4'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '5'">
			     <xsl:text>&lt;true|false&gt;</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '6'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '7'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '8'">
			     <xsl:text>d.d</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '9'">
			     <xsl:text>number</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '10'">
			     <xsl:text>date</xsl:text>
			</xsl:when>
			<xsl:when test="$format = '19'">
			     <xsl:text>percent (0-100)</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<!--XLATESTART-->value<!--XLATESTOP-->
                    </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetErrorMessage">
		<xsl:param name="ErrorMsgID"/>
		<xsl:choose>
			<xsl:when test="$ErrorMsgID='261'">Error! Configuration file is missing.</xsl:when>
			<xsl:when test="$ErrorMsgID='263'">Error! Configuration key is missing.</xsl:when>
			<xsl:when test="$ErrorMsgID='271'">Error! Value incorrect. setting=&lt;MD5|SHA1|SHA256|SHA512&gt;</xsl:when>
			<xsl:when test="$ErrorMsgID='1377'">Error! The JRE version is either not available on the system or not supported by the Server Administrator.</xsl:when>
			<xsl:otherwise>Error occured while configuring !</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
</xsl:stylesheet>
