<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>

	<xsl:template match="*">	
	<xsl:choose>
		<xsl:when test="SMStatus='0'"><xsl:call-template name="success"/></xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="failure">
				<xsl:with-param name="ErrorMsgID"><xsl:value-of select="SMStatus"/></xsl:with-param>
			</xsl:call-template>		
		</xsl:otherwise>
	</xsl:choose>
	</xsl:template>
<xsl:template name="success">
      <DataArea>
		
		<PageTitle display="JRE Information"/>
		
		<TableData>
				<Header>					
				<Data value="version" display="Version" name="version"/>
				<Data value="path" display="Path" name="path"/>		
                
				</Header>
				
				<xsl:apply-templates select="java">					
				</xsl:apply-templates>
		</TableData>		
			
		</DataArea>	
</xsl:template>


	<xsl:template name="failure">
		<xsl:param name="ErrorMsgID" />
		<DataArea>			
			<xsl:choose>
				<xsl:when test="$ErrorMsgID='261'"><xsl:text>Error! Configuration file is missing.</xsl:text></xsl:when>
				<xsl:when test="$ErrorMsgID='263'"><xsl:text>Error! Configuration key is missing.</xsl:text></xsl:when>
				<xsl:when test="$ErrorMsgID='272'"><xsl:text>Error! Out of memory.</xsl:text></xsl:when>
				<xsl:when test="$ErrorMsgID='1376'"><xsl:text>Error! Webserver not present. JRE get and set operations not supported.</xsl:text></xsl:when>
				<xsl:otherwise><xsl:text>Error occured!</xsl:text></xsl:otherwise>
			</xsl:choose>	
		</DataArea>	
	</xsl:template>
	
	<xsl:template match="java">
		<Row>
			<Data name="version">
				<xsl:attribute name="display"><xsl:value-of select="version"/></xsl:attribute>
				<xsl:choose>
				<xsl:when test="bundled  = 'true'">
				<xsl:attribute name="value"><xsl:value-of select="version"/> (Bundled)</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="version"/></xsl:attribute>
				</xsl:otherwise>
				</xsl:choose>
			</Data>
			<Data name="path">
				<xsl:attribute name="display"><xsl:value-of select="path"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="path"/></xsl:attribute>
			</Data>			
		</Row>
	</xsl:template>
</xsl:stylesheet>
