<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Main Component Tree -->
  <xsl:variable name="chassisblade">
    <xsl:value-of select="/OMA/Chassisinfo/chassistype"/>
  </xsl:variable>
	<xsl:template match="/">
    <ComponentTree>
      <xsl:choose>
        <xsl:when test="$chassisblade=25 or $chassisblade=29">
         <xsl:call-template name="BladeCompTree"></xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="MonoCompTree"></xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </ComponentTree>
  </xsl:template>
  <!-- End of Main Component Tree -->

  <!-- template for chassistype 25 alone-->
  <xsl:template name="BladeCompTree">
    <Component name="Module" help="System">
      <xsl:attribute name="display">
        <xsl:value-of select ="$strModularChassis"/>
      </xsl:attribute>
      <SNBMenuItem name="Properties" help="">
        <xsl:attribute name="display">
          <xsl:value-of select="$strProperties"/>
        </xsl:attribute>
        <xsl:variable name="ModChassisOid" select="/OMA/System/Hardware/MainChassis/@oid"/>
        <LSNBMenuItem name="ModInformation" href="./DataArea?plugin=com.dell.hip.webplugins.ModChassisWebplugin&amp;amp;oid={$ModChassisOid}" help="ModChassis" app="hip">
          <xsl:attribute name="display">
            <xsl:value-of select="$strInformation"/>
          </xsl:attribute>
        </LSNBMenuItem>
      </SNBMenuItem>
      <xsl:call-template name="MonoCompTree"></xsl:call-template>
    </Component>
    

  </xsl:template>
  <!-- put all functionality inside this functional template-->
  <xsl:template name="MonoCompTree">
    <Component name="System" help="System">
      <xsl:choose>
        <xsl:when test="$chassisblade=25 or $chassisblade=29">
          <xsl:attribute name="display">
            <xsl:value-of select="$strBlade"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="display">
            <xsl:value-of select="$strSystem"/>
          </xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
     
      <SNBMenuItem name="Properties" help="" default="true">
        <xsl:attribute name="display">
          <xsl:value-of select="$strProperties"/>
        </xsl:attribute>
<xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'"> <!-- show health only when instrumentation is present -->        
        <LSNBMenuItem name="Health" href="./DataArea?plugin=com.dell.oma.webplugins.OverallHealthWebPlugin&amp;amp;component=System&amp;amp;root=true" help="OverallHealth" app="oma">
          <xsl:attribute name="display">
            <xsl:value-of select="$strHealth"/>
          </xsl:attribute>
        </LSNBMenuItem>

        <LSNBMenuItem name="Summary" href="./DataArea?plugin=com.dell.oma.webplugins.SummaryWebPlugin" help="Summary" app="oma">
          <xsl:attribute name="display">
            <xsl:value-of select="$strSummary"/>
          </xsl:attribute>
        </LSNBMenuItem>
</xsl:if> <!-- show only when instrumentation is present -->                
<xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">        
        <LSNBMenuItem name="SystemInfo" href="./DataArea?plugin=com.dell.hip.webplugins.AssetInfoWebPlugin&amp;amp;cmd=list" help="AssetInfo">
          <xsl:attribute name="display">
            <xsl:value-of select="$strAssetInformation"/>
          </xsl:attribute>
        </LSNBMenuItem>
        <xsl:apply-templates select="/OMA/System/OSWatchdog"/>
</xsl:if>        
      </SNBMenuItem>
      
      <SNBMenuItem name="Shutdown" help="">
        <xsl:attribute name="display">
          <xsl:value-of select="$strShutdown"/>
        </xsl:attribute>
    <xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">          
        <xsl:apply-templates select="/OMA/System/Shutdown"/>
        <!--xsl:apply-templates select="/OMA/System/ThermalShutdown"/-->
        <xsl:variable name="ThermalShutdownOid" select="/OMA/System/ThermalShutdown/@poid"/>
        <LSNBMenuItem name="ThermalShutdown" href="./DataArea?plugin=com.dell.hip.webplugins.LRAProtectWebPlugin&amp;amp;poid={$ThermalShutdownOid}" help="ThermalShutdown">
          <xsl:attribute name="display">
            <xsl:value-of select="$strThermalShutdown"/>
          </xsl:attribute>
        </LSNBMenuItem>
    </xsl:if> <!-- show shutdown only if instrumentation -->	
<!-- This block has been modified to hide web server shutdown tab in MN login -->
<!-- Web server will be shown only when show web server is true -->        
        <!-- WebServer Shutdown -->
<xsl:if test="/OMA/SHOWWEBSERVER='TRUE'">
     <LSNBMenuItem name="webserver" help="WebServerShutdown" app="oma">
          <xsl:attribute name="display">
            <xsl:value-of select="$strWebServerShutdown"/>
          </xsl:attribute>
          <xsl:attribute name="href">./DataArea?plugin=com.dell.oma.webplugins.WebServerWebPlugin</xsl:attribute>
        </LSNBMenuItem>
</xsl:if>
      </SNBMenuItem>

	
	<xsl:if test="/OMA/SHOWWEBSERVER='TRUE' or /OMA/SHOWINSTRUMENTATION='TRUE' ">
		<xsl:apply-templates select="/OMA/System/Logs"/>
	</xsl:if>
	

<xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">            
      
      <SNBMenuItem name="alertmgmt" help="">
        <xsl:attribute name="display">
          <xsl:value-of select="$strAlertManagement"/>
        </xsl:attribute>
        <!--xsl:apply-templates select="/OMA/System/AlertActions"/-->

	<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin" help="ListLRA">
          <xsl:attribute name="display">
            <xsl:value-of select="$strAlertActions4"/>
          </xsl:attribute>
        </LSNBMenuItem>

        <!--MOH-->
        <xsl:apply-templates select="/OMA/BMC/EMPPEFEvtFltrListObj"/>
        <!--LSNBMenuItem name="PlatformEvents" href="./DataArea?plugin=com.dell.hip.webplugins.ListPEFWebPlugin" help="ListLRA">
						<xsl:attribute name="display"><xsl:value-of select="$strPlatformEvents"/></xsl:attribute>
					</LSNBMenuItem-->

	<LSNBMenuItem name="snmptraps" help="snmptraps" app="hip">
          <xsl:attribute name="display">
            <xsl:value-of select="$strSNMPTraps"/>
          </xsl:attribute>
          <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsWebPlugin</xsl:attribute>
        </LSNBMenuItem>

      </SNBMenuItem>
 </xsl:if> <!-- Show logs & Alert management only if instrumentation is present -->     
      <!-- For User Session Management -->
<!-- This block has been modified to hide web server shutdown tab in MN login -->
<!-- Web server will be shown only when show web server is true -->        
<!-- Session management will be the default page on DWS only installation, if instrumentation is also present 
then don't make this as default, just go ahead with default behaviour -->

<xsl:if test="/OMA/SHOWWEBSERVER='TRUE'">
     <SNBMenuItem name="userSession" help="">
	<xsl:if test="not(/OMA/SHOWINSTRUMENTATION)">
		<xsl:attribute name="default">true</xsl:attribute>
	</xsl:if>     
        <xsl:attribute name="display">
          <xsl:value-of select="$strUserSession"/>
        </xsl:attribute>
        <LSNBMenuItem name="Sessions" href="./DataArea?plugin=com.dell.oma.webplugins.SessionMgmtWebPlugin" help="SessionManagement" app="oma">
          <xsl:attribute name="display">
            <xsl:value-of select="$strSession"/>
          </xsl:attribute>
        </LSNBMenuItem>
      </SNBMenuItem>
</xsl:if>
<xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">    <!-- show entire tree only if instrumentation is present -->  
      <xsl:variable name="MainChassisName" select="/OMA/System/Hardware/MainChassis/@name"/>
      <xsl:variable name="OID" select="/OMA/System/Hardware/MainChassis/@oid"/>
      <Component name="MainChassis" help="MainChassis" app="hip">
        <xsl:attribute name="display">
          <xsl:choose>
            <xsl:when test="$OID='2'">
              <xsl:choose>
                <xsl:when test="$chassisblade=25 or $chassisblade=29">
                  <xsl:value-of select="$strMainSystem"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$strMainSystemChassis"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$MainChassisName"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <xsl:variable name="ESMLogOid" select="/OMA/System/Logs/ESMLog/@poid"/>
        <VirtualComponent name="HardwareLog" app="hip" cl="System" snb="Logs" lsnb="Hardware">
          <xsl:attribute name="display">
            <xsl:value-of select="$strHardwareLog"/>
          </xsl:attribute>
          <HealthCommand application="hip" databridge="hipda" omacmd="getcomphealth">
            <param name="poid" value="{$ESMLogOid}"/>
            <param name="comp" value="esmlog"/>
          </HealthCommand>
        </VirtualComponent>
        <SNBMenuItem name="Properties">
          <xsl:attribute name="display">
            <xsl:value-of select="$strProperties1"/>
          </xsl:attribute>
          <LSNBMenuItem name="Health" default="true" href="./DataArea?plugin=com.dell.oma.webplugins.OverallHealthWebPlugin&amp;amp;component=MainChassis" help="MainChassis" app="hip">
            <xsl:attribute name="display">
              <xsl:value-of select="$strHealth1"/>
            </xsl:attribute>
          </LSNBMenuItem>
          <xsl:variable name="MainChassisOid" select="/OMA/System/Hardware/MainChassis/@oid"/>
          <LSNBMenuItem name="Information" href="./DataArea?plugin=com.dell.hip.webplugins.ChassisWebPlugin&amp;amp;oid={$MainChassisOid}" help="MainChassisInfo" app="hip">
            <xsl:attribute name="display">
              <xsl:value-of select="$strInformation"/>
            </xsl:attribute>
          </LSNBMenuItem>
          <LSNBMenuItem name="Fru" href="./DataArea?plugin=com.dell.hip.webplugins.FRUWebPlugin" help="FRU">
            <xsl:attribute name="display">
              <xsl:value-of select="$strFRU"/>
            </xsl:attribute>
          </LSNBMenuItem>
          <!-- Display Front-Panel in the LSNB if either Power Button or NMI Button or LCD are supported -->
          <xsl:if test="(/OMA/System/Hardware/MainChassis/PowerButton) or (/OMA/System/Hardware/MainChassis/NMIButton) or (/OMA/BMC/LCDObj/maxLines &gt; 0)">
            <xsl:call-template name="FrontPanel"/>
          </xsl:if>
        </SNBMenuItem>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/ACSwitch"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/BIOS"/>
        <xsl:choose>
          <!--xsl:when test="/OMA/BMC/SMStatus = '0'"-->
          <!--xsl:when test="/OMA/BMC/EMPObj/@ons = 'Root/MainSystemChassis/EMPObj'"-->
          <xsl:when test="/OMA/BMC/EMPObj">

            <!--xsl:when test="/OMA/BMC/ObjCount='11'"-->
            <xsl:apply-templates select="/OMA/BMC"/>
          </xsl:when>
        </xsl:choose>
        <!--<xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Currents"/>-->
	<xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Fans"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Firmware"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Intrusion"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Memory"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Nic"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Ports"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/PowerSupply"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Processor"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Slots"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Temperatures"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Voltages"/>
        <xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Batteries"/>
        <xsl:apply-templates select="/OMA/BMC/PerformanceSensorObj"/>
	<xsl:apply-templates select="/OMA/BMC/SDCardObj"/>

	
       <!-- Power Monitoring tab -->
        <xsl:call-template name="PowerMonitoring"/>
        <HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=17">
               <param name="poid" value="{$OID}"/>
               <param name="comp" value="MainChassis"/>
        </HealthCommand>
      </Component>
      <!--<xsl:apply-templates select="/OMA/System/Hardware/ExtChassis"/>-->
      <xsl:for-each select="/OMA/System/Hardware/ExtChassis">
        <xsl:variable name="count" select="position()"/>
        <xsl:variable name="ExtChassisOid" select="@oid"/>
        <xsl:variable name="ExtChassisName" select="@name"/>
        <Component name="ExtChassis{$count}" display="{$ExtChassisName}" help="ExtChassis" app="hip">
          <!--<xsl:attribute name="name">ExtChassis<xsl:value-of select="$count"/></xsl:attribute>-->
          <SNBMenuItem name="Properties">
            <xsl:attribute name="display">
              <xsl:value-of select="$strProperties2"/>
            </xsl:attribute>
            <LSNBMenuItem name="Health" default="true" href="./DataArea?plugin=com.dell.oma.webplugins.OverallHealthWebPlugin&amp;amp;component=ExtChassis{$count}" help="ExtChassis" app="hip">
              <xsl:attribute name="display">
                <xsl:value-of select="$strHealth2"/>
              </xsl:attribute>
            </LSNBMenuItem>
            <LSNBMenuItem name="Information" href="./DataArea?plugin=com.dell.hip.webplugins.ChassisWebPlugin&amp;amp;oid={$ExtChassisOid}" help="ExtChassis" app="hip">
              <xsl:attribute name="display">
                <xsl:value-of select="$strInformation1"/>
              </xsl:attribute>
            </LSNBMenuItem>
          </SNBMenuItem>

          <xsl:if test="Fans">
            <xsl:variable name="ExtFansOid" select="Fans/@poid"/>
            <Component name="ExtFans{$count}" help="Fans">
              <xsl:attribute name="display">
                <xsl:value-of select="$strFans"/>
              </xsl:attribute>
              <HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=23">
                <param name="poid" value="{$ExtFansOid}"/>
                <param name="comp" value="fans"/>
              </HealthCommand>
              <SNBMenuItem name="Properties" default="true">
                <xsl:attribute name="display">
                  <xsl:value-of select="$strProperties3"/>
                </xsl:attribute>
                <LSNBMenuItem name="Probes" href="./DataArea?plugin=com.dell.hip.webplugins.FanProbesWebPlugin&amp;amp;poid={$ExtFansOid}&amp;amp;objtype=23" help="ExtChFansInfo">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strProbes"/>
                  </xsl:attribute>
                </LSNBMenuItem>
                <xsl:if test="FanControl">
                  <xsl:variable name="FanCtrlOid" select="/OMA/System/Hardware/ExtChassis/Fans/FanControl/@poid"/>
                  <LSNBMenuItem name="FanControl" href="./DataArea?plugin=com.dell.hip.webplugins.FanControlWebPlugin&amp;amp;poid={$FanCtrlOid}" help="FanControl">
                    <xsl:attribute name="display">
                      <xsl:value-of select="$strFanControl"/>
                    </xsl:attribute>
                  </LSNBMenuItem>
                </xsl:if>
              </SNBMenuItem>
               
              <SNBMenuItem name="extfansalertmgmt">
                <xsl:attribute name="display">
                  <xsl:value-of select="$strAlertManagement"/>
                </xsl:attribute>
                <LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=fan" help="ListLRA">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strAlertActions"/>
                  </xsl:attribute>
                </LSNBMenuItem>
                <LSNBMenuItem name="extfansnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=23" help="snmptraps">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strSNMPTraps5"/>
                  </xsl:attribute>
                </LSNBMenuItem>
              </SNBMenuItem>

            </Component>
          </xsl:if>
          <xsl:if test="Intrusion">
            <xsl:variable name="ExtIntrusionOid" select="Intrusion/@poid"/>
            <Component name="ExtIntrusion{$count}" help="Intrusion">
              <xsl:attribute name="display">
                <xsl:value-of select="$strIntrusion"/>
              </xsl:attribute>
              <HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=28">
                <param name="poid" value="{$ExtIntrusionOid}"/>
                <param name="comp" value="intrusion"/>
              </HealthCommand>
              <SNBMenuItem name="Properties" default="true">
                <xsl:attribute name="display">
                  <xsl:value-of select="$strProperties4"/>
                </xsl:attribute>
                <LSNBMenuItem name="Intrusion" href="./DataArea?plugin=com.dell.hip.webplugins.IntrusionWebPlugin&amp;amp;poid={$ExtIntrusionOid}" help="Intrusion">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strIntrusion1"/>
                  </xsl:attribute>
                </LSNBMenuItem>
              </SNBMenuItem>

              <SNBMenuItem name="extintrusionalertmgmt">
                <xsl:attribute name="display">
                  <xsl:value-of select="$strAlertManagement"/>
                </xsl:attribute>
                <LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=intrusion" help="ListLRA">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strAlertActions1"/>
                  </xsl:attribute>
                </LSNBMenuItem>
                <LSNBMenuItem name="extintrusionsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=28" help="snmptraps">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strSNMPTraps2"/>
                  </xsl:attribute>
                </LSNBMenuItem>
              </SNBMenuItem>

            </Component>
          </xsl:if>
          <xsl:if test="PowerSupply">
            <xsl:variable name="ExtPwrSupplyOid" select="PowerSupply/@poid"/>
            <Component name="ExtPowerSupply{$count}" help="PowerSuppliesinfo">
              <xsl:attribute name="display">
                <xsl:value-of select="$strPowerSupplies"/>
              </xsl:attribute>
              <HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=21">
                <param name="poid" value="{$ExtPwrSupplyOid}"/>
                <param name="comp" value="powersupply"/>
              </HealthCommand>
              <SNBMenuItem name="Properties">
                <xsl:attribute name="display">
                  <xsl:value-of select="$strProperties5"/>
                </xsl:attribute>
                <LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.PowerSupplyWebPlugin&amp;amp;poid={$ExtPwrSupplyOid}" help="ExtChPwrsupplInfo">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strElements"/>
                  </xsl:attribute>
                </LSNBMenuItem>
              </SNBMenuItem>

              <SNBMenuItem name="extpwrsuppliesalertmgmt">
                <xsl:attribute name="display">
                  <xsl:value-of select="$strAlertManagement"/>
                </xsl:attribute>
                <LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=powersupply" help="ListLRA">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strAlertActions2"/>
                  </xsl:attribute>
                </LSNBMenuItem>
                <LSNBMenuItem name="extpwrsupplysnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=21" help="snmptraps">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strSNMPTraps8"/>
                  </xsl:attribute>
                </LSNBMenuItem>
              </SNBMenuItem>

            </Component>
          </xsl:if>
          <xsl:if test="Temperatures">
            <xsl:variable name="ExtTempOid" select="Temperatures/@poid"/>
            <Component name="ExtTemperatures{$count}" help="Temperatures">
              <xsl:attribute name="display">
                <xsl:value-of select="$strTemperatures"/>
              </xsl:attribute>
              <HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=22">
                <param name="poid" value="{$ExtTempOid}"/>
                <param name="comp" value="temperatures"/>
              </HealthCommand>
              <SNBMenuItem name="Properties" default="true">
                <xsl:attribute name="display">
                  <xsl:value-of select="$strProperties6"/>
                </xsl:attribute>
                <LSNBMenuItem name="Probes" href="./DataArea?plugin=com.dell.hip.webplugins.ListTemperatureWebPlugin&amp;amp;poid={$ExtTempOid}" help="ExtChTempsInfo">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strProbes1"/>
                  </xsl:attribute>
                </LSNBMenuItem>
              </SNBMenuItem>

              <SNBMenuItem name="exttempsalertmgmt">
                <xsl:attribute name="display">
                  <xsl:value-of select="$strAlertManagement"/>
                </xsl:attribute>
                <LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=temperature" help="ListLRA">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strAlertActions3"/>
                  </xsl:attribute>
                </LSNBMenuItem>
                <LSNBMenuItem name="exttempsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=22" help="snmptraps">
                  <xsl:attribute name="display">
                    <xsl:value-of select="$strSNMPTraps4"/>
                  </xsl:attribute>
                </LSNBMenuItem>
              </SNBMenuItem>

            </Component>
          </xsl:if>
        </Component>
      
      </xsl:for-each>
      </xsl:if> <!-- show the entire tree only when instrumentation is present -->
      <Component name="Software" help="">
        <xsl:attribute name="display">
          <xsl:value-of select="$strSoftware"/>
        </xsl:attribute>
        <xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">      <!-- show operating system info only when instrumentation is present -->
        <Component name="OperatingSystem">
          <xsl:attribute name="display">
            <xsl:value-of select="$strOperatingSystem"/>
          </xsl:attribute>
          <SNBMenuItem name="Properties">
            <xsl:attribute name="display">
              <xsl:value-of select="$strProperties7"/>
            </xsl:attribute>
            <LSNBMenuItem name="Information" href="./DataArea?plugin=com.dell.hip.webplugins.OSInfoWebPlugin" help="OSInfo" app="hip">
              <xsl:attribute name="display">
                <xsl:value-of select="$strInformation2"/>
              </xsl:attribute>
            </LSNBMenuItem>
          </SNBMenuItem>
        </Component>
        </xsl:if> <!-- show operating system info only when instrumentation is present -->
      </Component>
	<Component name="Licenses" help="">
		<xsl:if test ="/OMA/BMC/EMPObj/type &gt; '15'">
			<xsl:if test="/OMA/licensereport/licenses">
				<xsl:attribute name="display">
				  <xsl:value-of select="$strLicenses"/>
				</xsl:attribute>
				<xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">
					<SNBMenuItem name="Properties">
						<xsl:attribute name="display">
							<xsl:value-of select="$strProperties7"/>
						</xsl:attribute>
						<LSNBMenuItem name="Information" href="./DataArea?plugin=com.dell.hip.webplugins.LicenseReportWebPlugin" help="LicenseReport" app="hip">
							<xsl:attribute name="display">
								<xsl:value-of select="$strInformation2"/>
							</xsl:attribute>
						</LSNBMenuItem>
					</SNBMenuItem>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</Component>
    </Component>
  </xsl:template>
	<!-- Templates for Checking for specific components -->
	<xsl:template match="AlertActions">
		<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin" help="ListLRA">
			<xsl:attribute name="display"><xsl:value-of select="$strAlertActions4"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<!--MOH Platform Events-->
	<xsl:template match="EMPPEFEvtFltrListObj">
		<LSNBMenuItem name="PlatformEvents" href="./DataArea?plugin=com.dell.hip.webplugins.ListPEFWebPlugin" help="ListPEF">
			<xsl:attribute name="display"><xsl:value-of select="$strPlatformEvents"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template match="OSWatchdog">
		<LSNBMenuItem name="OSRecovery" href="./DataArea?plugin=com.dell.hip.webplugins.WatchdogWebPlugin" help="AutoRecovery">
			<xsl:attribute name="display"><xsl:value-of select="$strAutoRecovery"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template match="Shutdown">
		<LSNBMenuItem name="RemoteShutdown" href="./DataArea?plugin=com.dell.hip.webplugins.GetshtdwnWebPlugin" help="Shutdown">
			<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdown"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template match="ThermalShutdown">
		<xsl:variable name="ThermalShutdownOid" select="/OMA/System/ThermalShutdown/@poid"/>
		<LSNBMenuItem name="ThermalShutdown" href="./DataArea?plugin=com.dell.hip.webplugins.LRAProtectWebPlugin&amp;amp;poid={$ThermalShutdownOid}" help="ThermalShutdown">
			<xsl:attribute name="display"><xsl:value-of select="$strThermalShutdown"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template match="Logs">
		<SNBMenuItem name="Logs" help="HardwareLog" app="help">
		<xsl:attribute name="display"><xsl:value-of select="$strLogs"/></xsl:attribute>
		 <xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'">
			<xsl:apply-templates select="/OMA/System/Logs/ESMLog"/>
			<xsl:apply-templates select="/OMA/System/Logs/AlertLog"/>
			<xsl:apply-templates select="/OMA/System/Logs/PostLog"/>
		</xsl:if>
			<xsl:apply-templates select="/OMA/System/Logs/CommandLog"/>
		</SNBMenuItem>
	</xsl:template>
	<xsl:template match="ESMLog">
		<LSNBMenuItem name="ESMLog" help="HardwareLog">
			<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ESMLogWebPlugin&amp;amp;sortkey=date&amp;amp;order=ascending</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="$strHardware"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template match="PostLog">
		<LSNBMenuItem name="PostLog" href="./DataArea?plugin=com.dell.hip.webplugins.PostLogWebPlugin" help="PostLog">
			<xsl:attribute name="display"><xsl:value-of select="$strPOST"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template match="AlertLog">
		<LSNBMenuItem name="AlertLog" href="./DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin" help="AlertLog">
			<xsl:attribute name="display"><xsl:value-of select="$strAlert"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template match="CommandLog">
		<LSNBMenuItem name="CommandLog" href="./DataArea?plugin=com.dell.oma.webplugins.CmdLogWebPlugin" help="CommandLog">
			<xsl:attribute name="display"><xsl:value-of select="$strCommand"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template name="FrontPanel">
		<xsl:variable name="ChassisOid" select="/OMA/System/Hardware/MainChassis/@oid"/>
		<LSNBMenuItem name="PowerButton" href="./DataArea?plugin=com.dell.hip.webplugins.PwrButtonWebPlugin&amp;amp;poid={$ChassisOid}" help="pwrbutton">
			<xsl:attribute name="display"><xsl:value-of select="$strFrontPanel"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<!--xsl:template match="/OMA/System/Hardware/MainChassis/PowerButton">
		<xsl:variable name="PwrButtonOid" select="/OMA/System/Hardware/MainChassis/PowerButton/@poid"/>
		<LSNBMenuItem name="PowerButton" href="./DataArea?plugin=com.dell.hip.webplugins.PwrButtonWebPlugin&amp;amp;poid={$PwrButtonOid}" help="pwrbutton">
			<xsl:attribute name="display"><xsl:value-of select="$strPowerButton"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template-->
	<xsl:template match="/OMA/System/Hardware/MainChassis/Intrusion">
		<xsl:variable name="IntrusionOid" select="/OMA/System/Hardware/MainChassis/Intrusion/@poid"/>
		<Component name="Intrusion" help="Intrusion">
			<xsl:attribute name="display"><xsl:value-of select="$strIntrusion2"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=28">
				<param name="poid" value="{$IntrusionOid}"/>
				<param name="comp" value="intrusion"/>
			</HealthCommand>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties8"/></xsl:attribute>
				<LSNBMenuItem name="Intrusion" href="./DataArea?plugin=com.dell.hip.webplugins.IntrusionWebPlugin&amp;amp;poid={$IntrusionOid}" help="Intrusion">
					<xsl:attribute name="display"><xsl:value-of select="$strIntrusion3"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="intrusionalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement1"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=intrusion" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions5"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="intrusionsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=28" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps2"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Voltages">
		<xsl:variable name="VoltagesOid" select="/OMA/System/Hardware/MainChassis/Voltages/@poid"/>
		<Component name="Voltages" help="Voltages">
			<xsl:attribute name="display"><xsl:value-of select="$strVoltages"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=24">
				<param name="poid" value="{$VoltagesOid}"/>
				<param name="comp" value="voltages"/>
			</HealthCommand>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties9"/></xsl:attribute>
				<LSNBMenuItem name="Probes" href="./DataArea?plugin=com.dell.hip.webplugins.ListVoltageWebPlugin&amp;amp;poid={$VoltagesOid}" help="Voltages">
					<xsl:attribute name="display"><xsl:value-of select="$strVoltageProbes"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="voltalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement2"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=voltage" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions6"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="voltsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=24" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps3"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Batteries">
		<xsl:variable name="BatteriesOid" select="/OMA/System/Hardware/MainChassis/Batteries/@poid"/>
		<Component name="Batteries" help="Batteries">
			<xsl:attribute name="display"><xsl:value-of select="$strBatteries"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=27">
				<param name="poid" value="{$BatteriesOid}"/>
				<param name="comp" value="Batteries"/>
			</HealthCommand>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties9"/></xsl:attribute>
				<LSNBMenuItem name="Probes" href="./DataArea?plugin=com.dell.hip.webplugins.ListBatteryWebPlugin&amp;amp;poid={$BatteriesOid}" help="Batteries">
					<xsl:attribute name="display"><xsl:value-of select="$strBatteries"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="battalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement2"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=battery" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions6"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="battsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=27" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps3"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
  </xsl:template>
  <xsl:template match="/OMA/BMC/PerformanceSensorObj">
    <Component name="Performance" help="Performance">
      <xsl:attribute name="display">
        <xsl:value-of select="$strHWPerformance"/>
      </xsl:attribute>
      <SNBMenuItem name="Properties" default="true">
        <xsl:attribute name="display">
          <xsl:value-of select="$strProperties9"/>
        </xsl:attribute>
        <LSNBMenuItem name="Probes" href="./DataArea?plugin=com.dell.hip.webplugins.ListPerformanceWebPlugin" help="HardwarePerformance">
          <xsl:attribute name="display">
            <xsl:value-of select="$strInformation"/>
          </xsl:attribute>
        </LSNBMenuItem>
      </SNBMenuItem>
    </Component>
  </xsl:template>

  <xsl:template match="/OMA/BMC/SDCardObj">
	     <xsl:if test="count(SDCard[Type='3']) > 0 or count(SDCard[Type='4']) > 0">	      
		     <Component name="Hypervisor">
			      <xsl:attribute name="display">
					<xsl:value-of select="$strRemovableFlashMedia"/>
			      </xsl:attribute>
				  <xsl:if test="count(SDCard[Type='3' ]) > 0 "> 
		      <HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=52">
		      </HealthCommand>
			  </xsl:if>
		      <SNBMenuItem name="Properties">
				<xsl:attribute name="display">
					 <xsl:value-of select="$strProperties5"/>
				</xsl:attribute>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.SDCardWebPlugin" help="sdcard">
					  <xsl:attribute name="display">
					    <xsl:value-of select="$strInformation3"/>
					  </xsl:attribute>
				</LSNBMenuItem>
		      </SNBMenuItem>
		      <SNBMenuItem name="sdcardalertmgmt">
				<xsl:attribute name="display">
					<xsl:value-of select="$strAlertManagement"/>
				</xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=sdcard" help="ListLRA">
					  <xsl:attribute name="display">
					    <xsl:value-of select="$strAlertActions2"/>
				  </xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="sdcardsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=52" help="snmptraps">
					  <xsl:attribute name="display">
					    <xsl:value-of select="$strSNMPTraps8"/>
					  </xsl:attribute>
				</LSNBMenuItem>
		      </SNBMenuItem>
		      </Component>
		</xsl:if>
 
	</xsl:template>

  <xsl:template match="/OMA/System/Hardware/MainChassis/Temperatures">
		<xsl:variable name="TemperaturesOid" select="/OMA/System/Hardware/MainChassis/Temperatures/@poid"/>
		<Component name="Temperatures" help="Temperatures">
			<xsl:attribute name="display"><xsl:value-of select="$strTemperatures1"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=22">
				<param name="poid" value="{$TemperaturesOid}"/>
				<param name="comp" value="temperatures"/>
			</HealthCommand>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties10"/></xsl:attribute>
				<LSNBMenuItem name="Probes" href="./DataArea?plugin=com.dell.hip.webplugins.ListTemperatureWebPlugin&amp;amp;poid={$TemperaturesOid}" help="Temperatures">
					<xsl:attribute name="display"><xsl:value-of select="$strTemperatureProbes"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="tempalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement3"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=temperature" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions7"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="tempsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=22" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps4"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Fans">
		<xsl:variable name="FansOid" select="/OMA/System/Hardware/MainChassis/Fans/@poid"/>
		<Component name="Fans" help="Fans">
			<xsl:attribute name="display"><xsl:value-of select="$strFans1"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=23">
				<param name="poid" value="{$FansOid}"/>
				<param name="comp" value="fans"/>
			</HealthCommand>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties11"/></xsl:attribute>
				<xsl:variable name="FansObjType" select="/OMA/System/Hardware/MainChassis/Fans/@objtype"/>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.FanProbesWebPlugin&amp;amp;poid={$FansOid}&amp;amp;objtype={$FansObjType}" help="Fans">
					<xsl:attribute name="display"><xsl:value-of select="$strFanProbes"/></xsl:attribute>
				</LSNBMenuItem>
				<xsl:apply-templates select="/OMA/System/Hardware/MainChassis/Fans/FanControl"/>
			</SNBMenuItem>

			<SNBMenuItem name="fanalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement4"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=fan" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions8"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="fansnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=23" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps5"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Fans/FanControl">
		<xsl:variable name="FanCtrlOid" select="/OMA/System/Hardware/MainChassis/Fans/FanControl/@poid"/>
		<LSNBMenuItem name="FanControl" href="./DataArea?plugin=com.dell.hip.webplugins.FanControlWebPlugin&amp;amp;poid={$FanCtrlOid}" help="FanControl">
			<xsl:attribute name="display"><xsl:value-of select="$strFanControl1"/></xsl:attribute>
		</LSNBMenuItem>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/ACSwitch">
		<xsl:variable name="ACSwitchOid" select="/OMA/System/Hardware/MainChassis/ACSwitch/@poid"/>
		<Component name="ACSwitch" help="ACSwitch">
			<xsl:attribute name="display"><xsl:value-of select="$strACSwitch"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=37">
				<param name="poid" value="{$ACSwitchOid}"/>
				<param name="comp" value="acswitch"/>
			</HealthCommand>
			<SNBMenuItem name="Properties">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties12"/></xsl:attribute>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.ACSwitchWebPlugin&amp;amp;poid={$ACSwitchOid}" help="ACSwitch">
					<xsl:attribute name="display"><xsl:value-of select="$strInformation3"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="acswitchalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement5"/></xsl:attribute>
				<LSNBMenuItem name="accordsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=37" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps6"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Currents">
		<xsl:variable name="CurrentsOid" select="/OMA/System/Hardware/MainChassis/Currents/@poid"/>
		<Component name="Currents" help="ListCurrent">
			<xsl:attribute name="display"><xsl:value-of select="$strCurrents"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=27">
				<param name="poid" value="{$CurrentsOid}"/>
				<param name="comp" value="currents"/>
			</HealthCommand>
			<SNBMenuItem name="Properties">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties13"/></xsl:attribute>
				<xsl:variable name="CurrentsObjType" select="/OMA/System/Hardware/MainChassis/Currents/@objtype"/>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.ListCurrentWebPlugin&amp;amp;poid={$CurrentsOid}&amp;amp;objtype={$CurrentsObjType}" help="ListCurrent">
					<xsl:attribute name="display"><xsl:value-of select="$strProbes2"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="currentalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement5"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=current" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions9"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="currentsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=25" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps7"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/PowerSupply">
		<xsl:variable name="PowerSupplyOid" select="/OMA/System/Hardware/MainChassis/PowerSupply/@poid"/>
		<Component name="PowerSupply" help="PowerSuppliesinfo">
			<xsl:attribute name="display"><xsl:value-of select="$strPowerSupplies1"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=21">
				<param name="poid" value="{$PowerSupplyOid}"/>
				<param name="comp" value="powersupply"/>
			</HealthCommand>
			<SNBMenuItem name="Properties">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties14"/></xsl:attribute>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.PowerSupplyWebPlugin&amp;amp;poid={$PowerSupplyOid}" help="PowerSuppliesinfo">
					<xsl:attribute name="display"><xsl:value-of select="$strElements1"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="pwrsupplyalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement6"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=powersupply" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions10"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="pwrsupplysnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=21" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps8"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Processor">
		<xsl:variable name="ProcessorOid" select="/OMA/System/Hardware/MainChassis/Processor/@poid"/>
		<Component name="Processor" help="Processor">
			<xsl:attribute name="display"><xsl:value-of select="$strProcessors"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=210">
				<param name="byobjtype" value="26" />
			</HealthCommand>
			<SNBMenuItem name="Properties">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties15"/></xsl:attribute>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.ProcessorWebPlugin&amp;amp;poid={$ProcessorOid}" help="Processor">
					<xsl:attribute name="display"><xsl:value-of select="$strInformation4"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="extprocessorsalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=processor" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions3"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Memory">
		<xsl:variable name="MemoryOid" select="/OMA/System/Hardware/MainChassis/Memory/@poid"/>
		<Component name="Memory" help="Memory">
			<xsl:attribute name="display"><xsl:value-of select="$strMemory"/></xsl:attribute>
			<HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=225">
				<param name="poid" value="{$MemoryOid}"/>
				<param name="comp" value="memory"/>
			</HealthCommand>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties16"/></xsl:attribute>
				<LSNBMenuItem name="Memory" href="./DataArea?plugin=com.dell.hip.webplugins.MemoryArrayWebPlugin&amp;amp;poid={$MemoryOid}" help="Memory">
					<xsl:attribute name="display"><xsl:value-of select="$strMemory1"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

			<SNBMenuItem name="memoryalertmgmt">
				<xsl:attribute name="display"><xsl:value-of select="$strAlertManagement7"/></xsl:attribute>
				<LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=memory" help="ListLRA">
					<xsl:attribute name="display"><xsl:value-of select="$strAlertActions11"/></xsl:attribute>
				</LSNBMenuItem>
				<LSNBMenuItem name="memorysnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=225" help="snmptraps">
					<xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps9"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>

		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Nic">
		<xsl:variable name="NicOid" select="/OMA/System/Hardware/MainChassis/Nic/@poid"/>
		<Component name="Network" help="NIC">
			<xsl:attribute name="display"><xsl:value-of select="$strNetwork"/></xsl:attribute>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties17"/></xsl:attribute>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.NICListWebPlugin&amp;amp;poid={$NicOid}" help="NIC">
					<xsl:attribute name="display"><xsl:value-of select="$strInformation5"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Slots">
		<xsl:variable name="SlotsOid" select="/OMA/System/Hardware/MainChassis/Slots/@poid"/>
		<Component name="Slots" help="Slots">
			<xsl:attribute name="display"><xsl:value-of select="$strSlots"/></xsl:attribute>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties18"/></xsl:attribute>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.SlotsWebPlugin&amp;amp;poid={$SlotsOid}" help="Slots">
					<xsl:attribute name="display"><xsl:value-of select="$strInformation6"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/Ports">
		<xsl:variable name="PortPOID" select="/OMA/System/Hardware/MainChassis/Ports/@poid"/>
		<Component name="Ports" help="Ports">
			<xsl:attribute name="display"><xsl:value-of select="$strPorts"/></xsl:attribute>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties19"/></xsl:attribute>
				<LSNBMenuItem name="View" href="./DataArea?plugin=com.dell.hip.webplugins.PortsWebPlugin&amp;amp;poid={$PortPOID}" help="Ports">
					<xsl:attribute name="display"><xsl:value-of select="$strInformation7"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/BIOS">
		<Component name="BIOS" help="Bios">
			<xsl:attribute name="display"><xsl:value-of select="$strBIOS"/></xsl:attribute>
			<SNBMenuItem name="Properties">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties20"/></xsl:attribute>
				<LSNBMenuItem name="BIOSView" help="Bios" href="./DataArea?plugin=com.dell.hip.webplugins.BIOSViewWebPlugin">
					<xsl:attribute name="display"><xsl:value-of select="$strInformation8"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
		<xsl:apply-templates select="/OMA/System/Hardware/MainChassis/BIOSSetup"/>
		</Component>
	</xsl:template>
	<xsl:template match="/OMA/System/Hardware/MainChassis/BIOSSetup">
		<SNBMenuItem name="BIOSSetup">
			<xsl:attribute name="display"><xsl:value-of select="$strSetup"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test ="/OMA/BMC/EMPObj/type &gt; '15'">
					<LSNBMenuItem name="BIOSSetup" href="./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin" help="hiiBiosSetup">
						<xsl:attribute name="display"><xsl:value-of select="$strBIOS1"/></xsl:attribute>
					</LSNBMenuItem>
				</xsl:when>
				<xsl:otherwise>
					<LSNBMenuItem name="BIOSSetup" href="./DataArea?plugin=com.dell.hip.webplugins.biossetupWebPlugin" help="BiosSetup">
						<xsl:attribute name="display"><xsl:value-of select="$strBIOS1"/></xsl:attribute>
					</LSNBMenuItem>
				</xsl:otherwise>
			</xsl:choose>
		</SNBMenuItem>
	</xsl:template>
	<xsl:template match="/OMA/BMC">
		<Component name="BMC" help="RemoteAccess">
			<xsl:attribute name="display"><xsl:value-of select="$strRemoteAccess"/></xsl:attribute>
			<SNBMenuItem name="Properties" default="true">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties22"/></xsl:attribute>
				<LSNBMenuItem help="RemoteAccess" name="View" href="./DataArea?plugin=com.dell.hip.webplugins.BMCViewWebPlugin">
					<xsl:attribute name="display"><xsl:value-of select="$strInfo"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
			
			<xsl:if test="/OMA/BMC/EMPObj">
			<SNBMenuItem name="Configuration" default="false">
				<xsl:attribute name="display"><xsl:value-of select="$strBmcConfiguration"/></xsl:attribute>
				<LSNBMenuItem help="RemoteAccessLan" name="lanConfiguration" href="./DataArea?plugin=com.dell.hip.webplugins.BMCNICWebPlugin">
					<xsl:attribute name="display"><xsl:value-of select="$strLAN"/></xsl:attribute>
				</LSNBMenuItem>
				<xsl:if test="/OMA/BMC/EMPSerialConfigObj">
					<LSNBMenuItem help="RemoteAccessSer" name="BmcSerial" href="./DataArea?plugin=com.dell.hip.webplugins.BMCSerialWebPlugin">
						<xsl:attribute name="display"><xsl:value-of select="$strSerial"/></xsl:attribute>
					</LSNBMenuItem>
				</xsl:if>
				<xsl:if test="/OMA/BMC/EMPSOLConfigObj">
					<LSNBMenuItem help="RemoteAccessSol" name="BmcSOL" href="./DataArea?plugin=com.dell.hip.webplugins.BMCSOLWebPlugin">
						<xsl:attribute name="display"><xsl:value-of select="$strSOL"/></xsl:attribute>
					</LSNBMenuItem>
				</xsl:if>
				<xsl:if test="/OMA/BMC/EMPV6LANConfigObj or /OMA/BMC/EMPObj/ipv4State='1' or /OMA/BMC/EMPObj/ipv4State='0'">
					<xsl:if test ="/OMA/BMC/EMPObj/type !='8' ">
						<LSNBMenuItem help="iDRAC_AddConfig" name="BmcIPv6" href="./DataArea?plugin=com.dell.hip.webplugins.BMCIPv6WebPlugin">
							<xsl:attribute name="display"><xsl:value-of select="$strAdditionalConfig"/></xsl:attribute>
						</LSNBMenuItem>
					</xsl:if>
				</xsl:if>
			</SNBMenuItem>
			<SNBMenuItem name="Users" default="false">
				<xsl:attribute name="display"><xsl:value-of select="$strBmcUsers"/></xsl:attribute>
				<LSNBMenuItem help="RemoteAccessUsers" name="Users" href="./DataArea?plugin=com.dell.hip.webplugins.BMCUserWebPlugin">
					<xsl:attribute name="display"><xsl:value-of select="$strBmcUsers"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
			</xsl:if>
		</Component>
	</xsl:template>	
	<xsl:template match="/OMA/System/Hardware/MainChassis/Firmware">
		<Component name="Firmware" help="Firmware">
			<xsl:attribute name="display"><xsl:value-of select="$strFirmware"/></xsl:attribute>
			<SNBMenuItem name="Properties">
				<xsl:attribute name="display"><xsl:value-of select="$strProperties21"/></xsl:attribute>
				<LSNBMenuItem name="FWView" help="Firmware" href="./DataArea?plugin=com.dell.hip.webplugins.FWViewWebPlugin">
					<xsl:attribute name="display"><xsl:value-of select="$strInformation9"/></xsl:attribute>
				</LSNBMenuItem>
			</SNBMenuItem>
		</Component>
	</xsl:template>
	<!-- For BMC Serial Configutaion -->
	<xsl:template name="getSerialPortOneOID">
		<xsl:for-each select="/OMA/bioscomp/BIOSSetupList/BIOSSetup">
			<xsl:if test="ObjName = 'Serial Port 1'">
				<xsl:value-of select="@oid"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- For BMC Console Redirection -->
	<xsl:template name="getConsoleRedirectOID">
		<xsl:for-each select="/OMA/bioscomp/BIOSSetupList/BIOSSetup">
			<xsl:if test="ObjName = 'Console Redirection'">
				<xsl:value-of select="@oid"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- For BMC FailSafe BAUD Rate -->
	<xsl:template name="getFailSafeOID">
		<xsl:for-each select="/OMA/bioscomp/BIOSSetupList/BIOSSetup">
			<xsl:if test="ObjName = 'Console Redirection Failsafe BAUD Rate'">
				<xsl:value-of select="@oid"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
  
  <xsl:template name="PowerMonitoring">
    <!-- display 'Power Monitoring' tab in CT if atleast one PSUs is PMBus capable. On blade, since we do not have -->
    <!-- PSU data, we check for type > 7 (this means blade has iDRAC and it supports PM -->
    <xsl:if test="/OMA/PowerSupplyData/PSAtleastOnePMCapable = 'true' or /OMA/BMC/EMPObj/type &gt; '7'">
      <xsl:variable name="poidval"><xsl:value-of select="/OMA/System/Hardware/MainChassis/@oid"/></xsl:variable>
      <Component name="PowerManagement" help="PowerMonitoring">
        <xsl:attribute name="display"><xsl:value-of select="$strPowerManagement"/></xsl:attribute>
        <HealthCommand application="hip" databridge="dceda" omacmd="byobjtype=25">
          <param name="poid" value="{$poidval}"/>
          <param name="comp" value="powermonitoring"/>
        </HealthCommand>
        <SNBMenuItem name="Monitoring">
          <xsl:attribute name="display"><xsl:value-of select="$strPowerMonitoring"/></xsl:attribute>
          <LSNBMenuItem name="powermon" href="./DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringWebPlugin&amp;amp;poid={$poidval}" help="PowerMonitoring">
            <xsl:attribute name="display"><xsl:value-of select="$strPowerConsumption"/></xsl:attribute>
          </LSNBMenuItem>
          <LSNBMenuItem name="powermonstats" href="./DataArea?plugin=com.dell.hip.webplugins.ListPowerMonitoringStatsWebPlugin" help="PowerMonitoringstats">
            <xsl:attribute name="display"><xsl:value-of select="$strPowerStatistics"/></xsl:attribute>
          </LSNBMenuItem>          
        </SNBMenuItem>
        <SNBMenuItem name="Management">
          <xsl:attribute name="display"><xsl:value-of select="$strManagement"/></xsl:attribute>
          <xsl:if test="/OMA/BMC/PowerConsumptionDataObj/minPower !='65535' and /OMA/BMC/PowerConsumptionDataObj/powerCapCaps !='0'">  
          <LSNBMenuItem name="budget" href="./DataArea?plugin=com.dell.hip.webplugins.PowerBudgetWebPlugin" help="Powerbudget">
            <xsl:attribute name="display"><xsl:value-of select="$strPowerBudget"/></xsl:attribute>
          </LSNBMenuItem>
	  </xsl:if>
          <xsl:if test="/OMA/BMC/PowerProfilesObject">            
            <LSNBMenuItem name="policies" href="./DataArea?plugin=com.dell.hip.webplugins.PowerProfilesWebPlugin" help="powerprofiles">
              <xsl:attribute name="display"><xsl:value-of select="$strPowerProfiles"/></xsl:attribute>
            </LSNBMenuItem>
          </xsl:if>
        </SNBMenuItem>

        <SNBMenuItem name="pwrmonitoringalertmgmt">
          <xsl:attribute name="display"><xsl:value-of select="$strAlertManagement6"/></xsl:attribute>
          <LSNBMenuItem name="AlertActions" href="./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;amp;type=powermonitoring" help="ListLRA">
            <xsl:attribute name="display"><xsl:value-of select="$strAlertActions10"/></xsl:attribute>
          </LSNBMenuItem>
          <LSNBMenuItem name="pwrmonitoringsnmptraps" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPTrapsByObjTypeWebPlugin&amp;amp;objtype=25" help="snmptraps">
            <xsl:attribute name="display"><xsl:value-of select="$strSNMPTraps8"/></xsl:attribute>
          </LSNBMenuItem>
        </SNBMenuItem>

      </Component>
    </xsl:if>
  </xsl:template>
	<!-- End of Templates for Checking for specific components -->
</xsl:stylesheet>