<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="SMStatus='0'">
				<xsl:call-template name="success"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="failure"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
			<xsl:variable name="ShowReboot">
		<xsl:choose>
			<xsl:when test="(/OMA/HostControlObj/capabilities/RebootWithOSShutdown='false' and 										/OMA/HostControlObj/capabilities/RebootWithoutOSShutdown='false') or (/OMA/HostControl/Capabilities/Reboot='false' )">0</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="ShowPoweroff">
		<xsl:choose>
			<xsl:when test="(/OMA/HostControlObj/capabilities/PwrOffWithOSShutdown='false' and 												/OMA/HostControlObj/capabilities/PwrOffWithoutOSShutdown='false') or (/OMA/HostControl/Capabilities/PwrOff='false') ">0</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="ShowPowerCycle">
		<xsl:choose>
			<xsl:when test="(/OMA/HostControlObj/capabilities/PwrCycleWithOSShutdown='false' and 												/OMA/HostControlObj/capabilities/PwrCycleWithoutOSShutdown='false') or (/OMA/HostControl/Capabilities/PwrCycle='false')  ">0</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="RebootWithOSShutdownCab">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/capabilities/RebootWithOSShutdown='true'  or (/OMA/HostControl/Capabilities/Reboot='true' ) ">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="RebootWithoutOSShutdownCab">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/capabilities/RebootWithoutOSShutdown='true'  or ((/OMA/HostControl/Capabilities/Reboot='true' ) ) ">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PwrOffWithOSShutdownCab">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/capabilities/PwrOffWithOSShutdown='true' or /OMA/HostControl/Capabilities/PwrOff='true' ">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PwrOffWithoutOSShutdownCab">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/capabilities/PwrOffWithoutOSShutdown='true' or  /OMA/HostControl/Capabilities/PwrOff='true'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PwrCycleWithOSShutdownCab">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/capabilities/PwrCycleWithOSShutdown='true' or  /OMA/HostControl/Capabilities/PwrCycle!='true' ">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PwrCycleWithoutOSShutdownCab">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/capabilities/PwrCycleWithoutOSShutdown='true' or /OMA/HostControl /Capabilities/PwrCycle='true'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="RebootWithOSShutdownSet">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/settings/RebootWithOSShutdown='true' or (/OMA/HostControl/Settings/Reboot='true' and /OMA/HostControl/Settings/OSShutdown='true') ">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="RebootWithoutOSShutdownSet">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/settings/RebootWithoutOSShutdown='true' or (/OMA/HostControl/Settings/Reboot='true' and /OMA/HostControl/Settings/OSShutdown='false') ">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PwrOffWithOSShutdownSet">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/settings/PwrOffWithOSShutdown='true' or (/OMA/HostControl/Settings/PwrOff='true' and /OMA/HostControl/Settings/OSShutdown='true') ">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PwrOffWithoutOSShutdownSet">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/settings/PwrOffWithoutOSShutdown='true' or (/OMA/HostControl/Settings/PwrOff='true' and /OMA/HostControl/Settings/OSShutdown='false') ">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PwrCycleWithOSShutdownSet">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/settings/PwrCycleWithOSShutdown='true' or (/OMA/HostControl/Settings/PwrCycle='true' and /OMA/HostControl/Settings/OSShutdown='true') ">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="PwrCycleWithoutOSShutdownSet">
		<xsl:choose>
			<xsl:when test="/OMA/HostControlObj/settings/PwrCycleWithoutOSShutdown='true' or (/OMA/HostControl /Settings/PwrCycle='true' and /OMA/HostControl/Settings/OSShutdown='false') ">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:template name="failure">
		<DataArea exportdata="false">
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdown"/></xsl:attribute>
			</PageTitle>
			<TableData>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:call-template name="smstatus"><xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
					</Data>
				</Row>
			</TableData>
		</DataArea>
	</xsl:template>
	<xsl:template name="success">
		<xsl:choose>
			<xsl:when test="@cli='true'">
				<xsl:call-template name="cli"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="web"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="web">
		<xsl:choose>
			<xsl:when test="OMAUserRights='7'">
				<xsl:call-template name="edit"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="view"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="edit">
		<DataArea onLoad="true" validate="true" exportdata="false">
		
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;oid=<xsl:value-of select="/OMA/HostControl/@oid"/></xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strShutdown"/></xsl:attribute>
			<xsl:attribute name="email">false</xsl:attribute>
			<xsl:attribute name="printable">false</xsl:attribute>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.GetshtdwnWebPlugin&amp;help=Shutdown</xsl:attribute>
				</Data>
			</CustomButton>
			
			<HiddenTable>
		<Data name="DatypeTag" type="hidden">
				<xsl:choose>
						<xsl:when test="/OMA/HostControlObj/capabilities">							
								<xsl:attribute name="returnvalue">dceda</xsl:attribute>			
						 </xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="returnvalue">hipda</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>			
		</HiddenTable>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdown1"/></xsl:attribute>
			</PageTitle>
			<xsl:choose>
				<xsl:when test="$RebootWithOSShutdownCab=0 and $PwrOffWithOSShutdownCab=0 and $PwrCycleWithOSShutdownCab=0 and $RebootWithOSShutdownSet='false' and $PwrOffWithOSShutdownSet='false' and $PwrCycleWithOSShutdownSet='false'">
					<PromptText>
						<xsl:attribute name="display"><xsl:value-of select="$strOSShutdownIsDisabled"/></xsl:attribute>
						<xsl:value-of select="$strOSShutdownIsDisabled1"/>
					</PromptText>
				</xsl:when>
				<xsl:otherwise>
					<HiddenTable>
						<xsl:attribute name="display"><xsl:value-of select="$strOSShutdown"/></xsl:attribute>
							<Data>
														
								<xsl:attribute name="name">os</xsl:attribute>
								<xsl:attribute name="display"><xsl:value-of select="$strShutdownOSFirst"/></xsl:attribute>
								<xsl:attribute name="type">checkbox</xsl:attribute>
								<xsl:attribute name="returnvalue">8</xsl:attribute>
								<xsl:attribute name="state">3</xsl:attribute>
								<!-- 121245 - OS Shutdown First not selected by default under system shutdown-->
								<xsl:attribute name="event">onclick</xsl:attribute>
								<xsl:attribute name="handler">javascript:flipOption()</xsl:attribute>
							</Data>
					</HiddenTable>
					<PromptText>
						<xsl:attribute name="display"><xsl:value-of select="$strShutdownOSFirstWarning"/></xsl:attribute>
						<!-- <xsl:value-of select="$strRemoteShutdownAction1"/> -->
						<xsl:value-of select="$strShutdownOSFirstWarning"/>
					</PromptText>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="($ShowReboot=0) and ($RebootWithOSShutdownSet='false') and ($RebootWithoutOSShutdownSet='false') and ($ShowPoweroff=0) and ($PwrOffWithOSShutdownSet='false') and ($PwrOffWithoutOSShutdownSet='false')and ($ShowPowerCycle=0) and ($PwrCycleWithOSShutdownSet='false') and ($PwrCycleWithoutOSShutdownSet='false')">
					<PromptText>
						<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction"/></xsl:attribute>
						<xsl:value-of select="$strRemoteShutdownAction1"/>
					</PromptText>
				</xsl:when>
				<xsl:otherwise>
					<ListData type="custom" name="rshutdownaction">
						<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction2"/></xsl:attribute>
						<Header>
							<Data name="">
								<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction3"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strRemoteShutdownAction4"/></xsl:attribute>
							</Data>
						</Header>
						<xsl:call-template name="edit1"/>
					</ListData>
				</xsl:otherwise>
			</xsl:choose>
			<script language="javascript">
				<!--
			In this shutdown page, action1[2] represents power cycle. If you add or remove any
			element, please take care of index.
			-->
			var vRebootWithOSShutdownCab="<xsl:value-of select="$RebootWithOSShutdownCab"/>";
			var vRebootWithoutOSShutdownCab="<xsl:value-of select="$RebootWithoutOSShutdownCab"/>";
			var vPwrOffWithOSShutdownCab="<xsl:value-of select="$PwrOffWithOSShutdownCab"/>";
			var vPwrOffWithoutOSShutdownCab="<xsl:value-of select="$PwrOffWithoutOSShutdownCab"/>";
			 var vPwrCycleWithOSShutdownCab="<xsl:value-of select="$PwrCycleWithOSShutdownCab"/>";
			var vPwrCycleWithoutOSShutdownCab="<xsl:value-of select="$PwrCycleWithoutOSShutdownCab"/>";
var vShowReboot="<xsl:value-of select="$ShowReboot"/>";
var vShowPoweroff="<xsl:value-of select="$ShowPoweroff"/>";
var vShowPowerCycle="<xsl:value-of select="$ShowPowerCycle"/>";

  
			function initializationRoutine()
			{			   
			   
			    if	(vShowReboot==1 || 1==vShowPoweroff || 1==vShowPowerCycle)
					  {	
			   			flipOption();
			   		 }
			}
			
			function singleBtnAction(param1,param2,param3){
				    if((param1==1&amp;&amp;vShowReboot==1)||(param2==1&amp;&amp;vShowPoweroff==1)||(param3==1&amp;&amp;vShowPowerCycle==1))
				    {
					document.getElementById("dataarea").action1.disabled = false;
				    }else{
					document.getElementById("dataarea").action1.disabled = true;
				    }
			}

			function btnAction(param1,param2,param3){
					var num=0;
					if(param1==1){
						document.getElementById("dataarea").action1[num].disabled = false;									
						num++;
					}
					else
					{		
					  if	(vShowReboot==1)
					  {		  
					   document.getElementById("dataarea").action1[num].disabled = true;
					   if(document.getElementById("dataarea").action1[num].checked)
					    	 document.getElementById("dataarea").action1[num].checked = false;
						 num++;
					   }
					}
				

					if(param2==1){
						document.getElementById("dataarea").action1[num].disabled = false;
						num++;
					}
					else
					{	
						if(vShowPoweroff ==1)
						{			  
					 	 document.getElementById("dataarea").action1[num].disabled = true;
					  	if(document.getElementById("dataarea").action1[num].checked)
					    		document.getElementById("dataarea").action1[num].checked = false;
							num++;
					    	}
					}
				
					if(param3==1){
						document.getElementById("dataarea").action1[num].disabled = false;									
						num++;
					}
					else
					{	
					    if(vShowPowerCycle==1)
					    {				  
					 		document.getElementById("dataarea").action1[num].disabled = true;
					  		if(document.getElementById("dataarea").action1[num].checked)
					    			document.getElementById("dataarea").action1[num].checked = false;
								num++;
					    	}
					}

			}

			function flipOption()	{

				if(document.getElementById("dataarea").os!=null &amp;&amp; document.getElementById("dataarea").os.checked == true)
				{		
				
					if(document.getElementById("dataarea").action1.length!=null)				
						btnAction(vRebootWithOSShutdownCab,vPwrOffWithOSShutdownCab,vPwrCycleWithOSShutdownCab);
					else
						singleBtnAction(vRebootWithOSShutdownCab,vPwrOffWithOSShutdownCab,vPwrCycleWithOSShutdownCab);

				}				
				else
				{
					if(document.getElementById("dataarea").action1.length!=null)				
						btnAction(vRebootWithoutOSShutdownCab,vPwrOffWithoutOSShutdownCab,vPwrCycleWithoutOSShutdownCab);
					else
						singleBtnAction(vRebootWithoutOSShutdownCab,vPwrOffWithoutOSShutdownCab,vPwrCycleWithoutOSShutdownCab);
				}
			}


			
			
			function validate(){
				<xsl:choose>
					<xsl:when test="($RebootWithoutOSShutdownCab=0) and ($PwrOffWithoutOSShutdownCab=0) and ($PwrCycleWithoutOSShutdownCab=0)">
						if (confirm("<xsl:value-of select="$strDoYouReally"/>")){
							return true;
						}
						else{
							return false;
						}				
					</xsl:when>
					<xsl:otherwise>
					
						if (document.getElementById("dataarea").os!=null &amp;&amp; document.getElementById("dataarea").os.checked == true){
							if (confirm("<xsl:value-of select="$strDoYouReally1"/>")){
								return true;
							}
							else{
								return false;
							}	
						}
					
						else {
							if (confirm("<xsl:value-of select="$strDoYouReally1"/>")){
								return true;
							}
							else{
								return false;
							}	
						}
						
					</xsl:otherwise>
				</xsl:choose>
				
			}								
		</script>
		</DataArea>
	</xsl:template>
	<xsl:template name="edit1">
		
		<xsl:if test="$ShowReboot=1">
			
				<Data type="radio">
					<xsl:attribute name="name">action1</xsl:attribute>
					<xsl:attribute name="returnvalue">1</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strRebootSystem"/></xsl:attribute>
					<xsl:attribute name="state"><xsl:call-template name="rebootselect1"/></xsl:attribute>
				</Data>
		
		</xsl:if>
		<xsl:if test="$ShowPoweroff=1">
		
				<Data type="radio">
					<xsl:attribute name="name">action1</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strPowerOffSystem"/></xsl:attribute>
					<xsl:attribute name="returnvalue">2</xsl:attribute>
					<xsl:attribute name="state"><xsl:call-template name="poweroffselect1"/></xsl:attribute>
				</Data>
			
		</xsl:if>
		<xsl:if test="$ShowPowerCycle=1">
		
				<Data type="radio">
					<xsl:attribute name="name">action1</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strPowerCycleSystem"/></xsl:attribute>
					<xsl:attribute name="returnvalue">4</xsl:attribute>
					<xsl:attribute name="state"><xsl:call-template name="powercycleselect1"/></xsl:attribute>
				</Data>
		
		</xsl:if>
	</xsl:template>
	<xsl:template name="rebootselect1">	
		<xsl:choose>
			<xsl:when test="($RebootWithOSShutdownSet='true' or $RebootWithoutOSShutdownSet='true') or($PwrOffWithOSShutdownSet='false' and $PwrOffWithoutOSShutdownSet='false') or ($PwrCycleWithOSShutdownSet='false' and $PwrCycleWithoutOSShutdownSet='false' )">1</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="poweroffselect1">
		<xsl:if test="$PwrOffWithOSShutdownSet='true' or $PwrOffWithoutOSShutdownSet='true'">1</xsl:if>
	</xsl:template>
	<xsl:template name="powercycleselect1">
		<xsl:if test="$PwrCycleWithOSShutdownSet='true' or $PwrCycleWithoutOSShutdownSet='true'">1</xsl:if>
	</xsl:template>
	<xsl:template name="OSselect1">
		<!-- 107768 Changed the value for otherwise to 0, it was 1 (?) , This was later deemed as incorrect per 121245 -->
		<!--removing the above condition-->
		<xsl:choose>
			<xsl:when test="($RebootWithOSShutdownSet='true' or $PwrOffWithOSShutdownSet='true' or $PwrCycleWithOSShutdownSet='true' ) or ($RebootWithoutOSShutdownSet='false' or $PwrOffWithoutOSShutdownSet='false' or $PwrCycleWithoutOSShutdownSet='false') ">1</xsl:when>
			<xsl:when test="$RebootWithoutOSShutdownSet='true' or $PwrOffWithoutOSShutdownSet='true' or $PwrCycleWithoutOSShutdownSet='true' ">0</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="view">
		<DataArea exportdata="false">
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh1"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.GetshtdwnWebPlugin&amp;help=Shutdown</xsl:attribute>
				</Data>
			</CustomButton>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strShutdown1"/></xsl:attribute>
			</PageTitle>
			<TableData name="osshutdown">
				<xsl:attribute name="display"><xsl:value-of select="$strOSShutdown3"/></xsl:attribute>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strOSShutdown4"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strOSShutdown5"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data>
						<xsl:attribute name="name">os</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strShutdownOSFirst1"/></xsl:attribute>
						<xsl:attribute name="type">checkbox</xsl:attribute>
						<xsl:attribute name="returnvalue">8</xsl:attribute>
						<xsl:attribute name="state">2<!-- DF:111122--><!--xsl:call-template name="OSselect1"/--></xsl:attribute>
						<!-- 121245 - OS Shutdown First not selected by default under system shutdown -->
					</Data>
				</Row>
			</TableData>
			<TableData name="rshutdownaction">
				<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction5"/></xsl:attribute>
				<Header>
					<Data name="">
						<xsl:attribute name="display"><xsl:value-of select="$strRemoteShutdownAction6"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strRemoteShutdownAction7"/></xsl:attribute>
					</Data>
				</Header>
				<xsl:call-template name="view1"/>
			</TableData>
		</DataArea>
	</xsl:template>
	<xsl:template name="view1">
		<Row>
			<Data type="radio">
				<xsl:attribute name="name">action1</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strRebootSystem1"/></xsl:attribute>
				<xsl:attribute name="returnvalue">1</xsl:attribute>
				<xsl:attribute name="state"><xsl:call-template name="rebootselect"/></xsl:attribute>
			</Data>
		</Row>
		<xsl:if test="$ShowPoweroff=1">
			<Row>
				<Data type="radio">
					<xsl:attribute name="name">action1</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strPowerOffSystem1"/></xsl:attribute>
					<xsl:attribute name="returnvalue">2</xsl:attribute>
					<xsl:attribute name="state"><xsl:call-template name="poweroffselect"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
		<xsl:if test="$ShowPowerCycle=1">
			<Row>
				<Data type="radio">
					<xsl:attribute name="name">action1</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strPowerCycleSystem1"/></xsl:attribute>
					<xsl:attribute name="returnvalue">4</xsl:attribute>
					<xsl:attribute name="state"><xsl:call-template name="powercycleselect"/></xsl:attribute>
				</Data>
			</Row>
		</xsl:if>
	</xsl:template>
	<xsl:template name="rebootselect">
		<xsl:choose>
			<xsl:when test="$RebootWithOSShutdownSet='true' or $RebootWithoutOSShutdownSet='true'">3</xsl:when>
			<xsl:when test="$PwrOffWithOSShutdownSet='false' and $PwrOffWithoutOSShutdownSet='false'">
				<xsl:choose>
					<xsl:when test="$PwrCycleWithOSShutdownSet='false' and $PwrCycleWithoutOSShutdownSet='false'">3</xsl:when>
					<xsl:otherwise>2</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>2</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="poweroffselect">
		<xsl:choose>
			<xsl:when test="$PwrOffWithOSShutdownSet='true' or $PwrOffWithoutOSShutdownSet='true'">3</xsl:when>
			<xsl:otherwise>2</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="powercycleselect">
		<xsl:choose>
			<xsl:when test="$PwrCycleWithOSShutdownSet='true' or $PwrCycleWithoutOSShutdownSet='true'">3</xsl:when>
			<xsl:otherwise>2</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="OSselect">
		<xsl:variable name="setting" select="HostControlObj/settings/OSShutdown"/>
		<xsl:choose>
			<!--107768, changed values to 1 and 0, it was 3 and 3, this was later deemed incorrect per 121245 -->
			<xsl:when test="$setting='true'">1</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="cli">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strShutdown2"/></xsl:attribute>
			</PageTitle>		
			<xsl:choose>
				<xsl:when test="$RebootWithOSShutdownSet='false' and $RebootWithoutOSShutdownSet='false' and $PwrOffWithOSShutdownSet='false' and $PwrOffWithoutOSShutdownSet='false' and $PwrCycleWithOSShutdownSet='false' and $PwrCycleWithoutOSShutdownSet='false' ">
					<ListData>
						<Data value="None">
							<xsl:attribute name="display"><xsl:value-of select="$strShutdownActionPending"/></xsl:attribute>
						</Data>
					</ListData>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="cliotherwise"/>
				</xsl:otherwise>
			</xsl:choose>
		</DataArea>
	</xsl:template>
	<xsl:template name="cliotherwise">		
		<ListData>
			<xsl:for-each select="HostControlObj/capabilities/*">			
					<xsl:if test=".='true'">				
					<xsl:call-template name="cliotherwise1">
						<xsl:with-param name="name1"><xsl:value-of select="name()"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
		</ListData>
	</xsl:template>
	<xsl:template name="cliotherwise1">
		<xsl:param name="name1"/>
		<xsl:for-each select="/OMA/HostControlObj/settings/*">		
			<xsl:if test="$name1=name()">
				<xsl:if test=".='true'">
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strShutdownAction"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$name1"/></xsl:attribute>
					</Data>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'">
				<xsl:value-of select="$strCommandUnsuccessful"/>
			</xsl:when>
			<xsl:when test="$status = '1'">
				<xsl:value-of select="$strCommandNotImplemented"/>
			</xsl:when>
			<xsl:when test="$status = '2'">
				<xsl:value-of select="$strBadCommand"/>
			</xsl:when>
			<xsl:when test="$status = '3'">
				<xsl:value-of select="$strCommandTimeout"/>
			</xsl:when>
			<xsl:when test="$status = '4'">
				<xsl:value-of select="$strCommandCancelled"/>
			</xsl:when>
			<xsl:when test="$status = '5'">
				<xsl:value-of select="$strCommandAborted"/>
			</xsl:when>
			<xsl:when test="$status = '6'">
				<xsl:value-of select="$strCommandPending"/>
			</xsl:when>
			<xsl:when test="$status = '7'">
				<xsl:value-of select="$strNoSuchDevice"/>
			</xsl:when>
			<xsl:when test="$status = '8'">
				<xsl:value-of select="$strDeviceBusy"/>
			</xsl:when>
			<xsl:when test="$status = '9'">
				<xsl:value-of select="$strBadDevice"/>
			</xsl:when>
			<xsl:when test="$status = '10'">
				<xsl:value-of select="$strSpuriousInterrupt"/>
			</xsl:when>
			<xsl:when test="$status = '11'">
				<xsl:value-of select="$strResourceLocked"/>
			</xsl:when>
			<xsl:when test="$status = '12'">
				<xsl:value-of select="$strInvalidIndex"/>
			</xsl:when>
			<xsl:when test="$status = '13'">
				<xsl:value-of select="$strSMBError"/>
			</xsl:when>
			<xsl:when test="$status = '14'">
				<xsl:value-of select="$strDataRequestedIs"/>
			</xsl:when>
			<xsl:when test="$status = '15'">
				<xsl:value-of select="$strDataRequestedIs1"/>
			</xsl:when>
			<xsl:when test="$status = '16'">
				<xsl:value-of select="$strDataRequestedIs2"/>
			</xsl:when>
			<xsl:when test="$status = '17'">
				<xsl:value-of select="$strDeviceNotYet"/>
			</xsl:when>
			<xsl:when test="$status = '18'">
				<xsl:value-of select="$strDeviceDoesNot"/>
			</xsl:when>
			<xsl:when test="$status = '19'">
				<xsl:value-of select="$strDeviceOutOf"/>
			</xsl:when>
			<xsl:when test="$status = '20'">
				<xsl:value-of select="$strDeviceAlreadyExists"/>
			</xsl:when>
			<xsl:when test="$status = '256'">
				<xsl:value-of select="$strObjectNotFound"/>
			</xsl:when>
			<xsl:when test="$status = '257'">
				<xsl:value-of select="$strObjectMalformedCorrupt"/>
			</xsl:when>
			<xsl:when test="$status = '258'">
				<xsl:value-of select="$strObjectAlreadyExists"/>
			</xsl:when>
			<xsl:when test="$status = '260'">
				<xsl:value-of select="$strINIFileNot"/>
			</xsl:when>
			<xsl:when test="$status = '261'">
				<xsl:value-of select="$strINIMalformedCorrupt"/>
			</xsl:when>
			<xsl:when test="$status = '262'">
				<xsl:value-of select="$strINISectionDoes"/>
			</xsl:when>
			<xsl:when test="$status = '263'">
				<xsl:value-of select="$strINIKeyDoes"/>
			</xsl:when>
			<xsl:when test="$status = '264'">
				<xsl:value-of select="$strINIValueMalformed"/>
			</xsl:when>
			<xsl:when test="$status = '270'">
				<xsl:value-of select="$strInsufficientAccessRights"/>
			</xsl:when>
			<xsl:when test="$status = '271'">
				<xsl:value-of select="$strInvalidParameterName"/>
				<xsl:value-of select="$mssg"/>
			</xsl:when>
			<xsl:when test="$status = '272'">
				<xsl:value-of select="$strOutOfMemory"/>
			</xsl:when>
			<xsl:when test="$status = '280'">
				<xsl:value-of select="$strXMLFileNot"/>
			</xsl:when>
			<xsl:when test="$status = '281'">
				<xsl:value-of select="$strXMLMalformedCorrupt"/>
			</xsl:when>
			<xsl:when test="$status = '282'">
				<xsl:value-of select="$strXMLNodeDoes"/>
			</xsl:when>
			<xsl:when test="$status = '283'">
				<xsl:value-of select="$strXMLValueMalformed"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strSMStatus"/>
				<xsl:value-of select="$status"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
