<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<xsl:apply-templates select="PerformanceData"/>
</xsl:template>
<xsl:template match="PerformanceData">
	<xsl:choose>
		<xsl:when test="@type='uidata'">
			<DataArea onLoad="true">
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strPerformance"/></xsl:attribute>
				</PageTitle>
				<script language="javascript">
					function initializationRoutine()
					{
						getUpdate();
					}

					function getUpdate()
					{
						var timerprf1 = setTimeout("getUpdate()", 3000);
						window.frames[0].location.reload(true);
					}
				</script>
				<PerformanceData>
					<xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
					<UIData>
						<Update>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PerfMgntWebPlugin&amp;datatype=realdata</xsl:attribute>
						</Update>
						<xsl:for-each select="PerfObjList/PerfObj">
							<xsl:if test="PerfObjName='PerfProcessor'">
								<Graph>
									<xsl:attribute name="name">processor_<xsl:value-of select="InstanceName"/></xsl:attribute>
									<xsl:attribute name="percent"><xsl:value-of select="PercentProcessorTime"/></xsl:attribute>
									<SubHeader>
										<xsl:attribute name="display"><xsl:value-of select="$strProcessor"/><xsl:value-of select="InstanceName"/></xsl:attribute>
									</SubHeader>
									<ListData>
										<Data>
											<xsl:attribute name="name">processor_<xsl:value-of select="InstanceName"/>_ptime</xsl:attribute>
											<xsl:attribute name="display"><xsl:value-of select="$strProcessorTime"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="PercentProcessorTime"/>%</xsl:attribute>
										</Data>
										<Data>
											<xsl:attribute name="name">processor_<xsl:value-of select="InstanceName"/>_utime</xsl:attribute>
											<xsl:attribute name="display"><xsl:value-of select="$strUserTime"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="PercentUserTime"/>%</xsl:attribute>
										</Data>
										<Data>
											<xsl:attribute name="name">processor_<xsl:value-of select="InstanceName"/>_pvtime</xsl:attribute>
											<xsl:attribute name="display"><xsl:value-of select="$strPrivilegedTime"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="PercentPrivilegedTime"/>%</xsl:attribute>
										</Data>
										<Data>
											<xsl:attribute name="name">processor_<xsl:value-of select="InstanceName"/>_intrpts</xsl:attribute>
											<xsl:attribute name="display"><xsl:value-of select="$strInterruptsPerSecond"/></xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="InterruptsPerSec"/></xsl:attribute>
										</Data>
									</ListData>
								</Graph>
							</xsl:if>
						</xsl:for-each>
						<BoxData>
							<xsl:for-each select="PerfObjList/PerfObj">
								<xsl:if test="PerfObjName='PerfDisk'">
									<DiskData>
										<SubHeader>
											<xsl:attribute name="display"><xsl:value-of select="InstanceName"/></xsl:attribute>
										</SubHeader>
										<ListData>
											<Data>
												<xsl:attribute name="name">disk_<xsl:value-of select="@oid"/>_wrs</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strWritesPerSecond"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="WritesPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">disk_<xsl:value-of select="@oid"/>_bwps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strBytesWrittenPer"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="BytesWrittenPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">disk_<xsl:value-of select="@oid"/>_rps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strReadsPerSecond"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="ReadsPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">disk_<xsl:value-of select="@oid"/>_brps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strBytesReadPer"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="BytesReadsPerSec"/></xsl:attribute>
											</Data>
										</ListData>
									</DiskData>
								</xsl:if>
							</xsl:for-each>
						</BoxData>
						<BoxData>
							<xsl:for-each select="PerfObjList/PerfObj">
								<xsl:if test="PerfObjName='PerfMemory'">
									<MemData>
										<SubHeader>
											<xsl:attribute name="display"><xsl:value-of select="$strMemory"/></xsl:attribute>
										</SubHeader>
										<ListData>
											<Data>
												<xsl:attribute name="name">mem_<xsl:value-of select="PerfObjName"/>_pfps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strPageFaultsPer"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="PageFaultsPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">mem_<xsl:value-of select="PerfObjName"/>_pps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strPagesPerSecond"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="PagesPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">mem_<xsl:value-of select="PerfObjName"/>_ab</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strAvailableBytes"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="AvailableBytes"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">mem_<xsl:value-of select="PerfObjName"/>_cb</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strCommittedBytes"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="CommittedBytes"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">mem_<xsl:value-of select="PerfObjName"/>_cl</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strCommitLimit"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="CommitLimit"/></xsl:attribute>
											</Data>
										</ListData>
									</MemData>
								</xsl:if>
								<xsl:if test="PerfObjName='PerfVirtualMemory'">
									<MemData>
										<SubHeader>
											<xsl:attribute name="display"><xsl:value-of select="$strVirtualMemory"/><xsl:value-of select="InstanceName"/></xsl:attribute>
										</SubHeader>
										<ListData>
											<Data>
												<xsl:attribute name="name">vrtlmem_<xsl:value-of select="@oid"/>_pu</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strPercentUsage"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="PercentUsage"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">vrtlmem_<xsl:value-of select="@oid"/>_pup</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strPercentUsagePeak"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="PercentUsagePeak"/></xsl:attribute>
											</Data>
										</ListData>
									</MemData>
								</xsl:if>
							</xsl:for-each>
						</BoxData>
						<BoxData>
							<xsl:for-each select="PerfObjList/PerfObj">
								<xsl:if test="PerfObjName='PerfNetwork'">
									<NTWData>
										<SubHeader>
											<xsl:choose>
												<xsl:when test="InstanceName!=''">
													<xsl:attribute name="display"><xsl:value-of select="InstanceName"/></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="display"><xsl:value-of select="$strNetwork"/></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</SubHeader>
										<ListData>
											<Data>
												<xsl:attribute name="name">ntwk_<xsl:value-of select="InstanceName"/>_btps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strBytesTotalPer"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="BytesTotalPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">ntwk_<xsl:value-of select="InstanceName"/>_pps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strPacketsPerSecond"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="PacketsPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">ntwk_<xsl:value-of select="InstanceName"/>_prps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strPacketsReceivedPer"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="PacketsReceivedPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">ntwk_<xsl:value-of select="InstanceName"/>_psps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strPacketsSentPer"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="PacketsSentPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">ntwk_<xsl:value-of select="InstanceName"/>_cb</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strCurrentBandwidth"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="CurrentBandwidth"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">ntwk_<xsl:value-of select="InstanceName"/>_brps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strBytesReceivedPer"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="BytesReceivedPerSec"/></xsl:attribute>
											</Data>
											<Data>
												<xsl:attribute name="name">ntwk_<xsl:value-of select="InstanceName"/>_bsps</xsl:attribute>
												<xsl:attribute name="display"><xsl:value-of select="$strBytesSentPer"/></xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="BytesSentPerSec"/></xsl:attribute>
											</Data>
										</ListData>
									</NTWData>
								</xsl:if>
							</xsl:for-each>
						</BoxData>
					</UIData>
				</PerformanceData>
			</DataArea>
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<PerformanceData>					
					<xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
					<UpdateData>
						<xsl:for-each select="PerfObjList/PerfObj">
							<xsl:if test="PerfObjName='PerfProcessor'">
								<Graph>
									<xsl:attribute name="name">processor_<xsl:value-of select="InstanceName"/></xsl:attribute>
									<xsl:attribute name="percent"><xsl:value-of select="PercentProcessorTime"/></xsl:attribute>
									<Data><xsl:attribute name="ptime"><xsl:value-of select="PercentProcessorTime"/></xsl:attribute></Data>
									<Data><xsl:attribute name="utime"><xsl:value-of select="PercentUserTime"/></xsl:attribute></Data>
									<Data><xsl:attribute name="pvtime"><xsl:value-of select="PercentPrivilegedTime"/></xsl:attribute></Data>
									<Data><xsl:attribute name="interrupts"><xsl:value-of select="InterruptsPerSec"/></xsl:attribute></Data>
								</Graph>
							</xsl:if>
						</xsl:for-each>
						<BoxData>
							<xsl:for-each select="PerfObjList/PerfObj">
								<xsl:if test="PerfObjName='PerfDisk'">
									<DiskData>
										<xsl:attribute name="name">disk_<xsl:value-of select="@oid"/></xsl:attribute>
										<Data><xsl:attribute name="wrs"><xsl:value-of select="WritesPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="bwps"><xsl:value-of select="BytesWrittenPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="rps"><xsl:value-of select="ReadsPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="brps"><xsl:value-of select="BytesReadsPerSec"/></xsl:attribute></Data>
									</DiskData>
								</xsl:if>
								<xsl:if test="PerfObjName='PerfMemory'">
									<MemData>
										<xsl:attribute name="name">mem_<xsl:value-of select="PerfObjName"/></xsl:attribute>
										<Data><xsl:attribute name="pfps"><xsl:value-of select="PageFaultsPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="pps"><xsl:value-of select="PagesPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="ab"><xsl:value-of select="AvailableBytes"/></xsl:attribute></Data>
										<Data><xsl:attribute name="cb"><xsl:value-of select="CommittedBytes"/></xsl:attribute></Data>
										<Data><xsl:attribute name="cl"><xsl:value-of select="CommitLimit"/></xsl:attribute></Data>
									</MemData>
								</xsl:if>
								<xsl:if test="PerfObjName='PerfVirtualMemory'">
									<VirMemData>
										<xsl:attribute name="name">vrtlmem_<xsl:value-of select="@oid"/></xsl:attribute>
										<Data><xsl:attribute name="pu"><xsl:value-of select="PercentUsage"/></xsl:attribute></Data>
										<Data><xsl:attribute name="pup"><xsl:value-of select="PercentUsagePeak"/></xsl:attribute></Data>
									</VirMemData>
								</xsl:if>
								<xsl:if test="PerfObjName='PerfNetwork'">
									<NTWData>
										<xsl:attribute name="name">ntwk_<xsl:value-of select="InstanceName"/></xsl:attribute>
										<Data><xsl:attribute name="btps"><xsl:value-of select="BytesTotalPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="pps"><xsl:value-of select="PacketsPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="prps"><xsl:value-of select="PacketsReceivedPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="psps"><xsl:value-of select="PacketsSentPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="cb"><xsl:value-of select="CurrentBandwidth"/></xsl:attribute></Data>
										<Data><xsl:attribute name="brps"><xsl:value-of select="BytesReceivedPerSec"/></xsl:attribute></Data>
										<Data><xsl:attribute name="bsps"><xsl:value-of select="BytesSentPerSec"/></xsl:attribute></Data>
									</NTWData>
								</xsl:if>
							</xsl:for-each>
						</BoxData>
					</UpdateData>
				</PerformanceData>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>
