
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <!-- including globals for CLI. GUI automatically loads globals.xsl -->
  <xsl:include href="../en/globals.xsl"/>
  
  <xsl:template name="formatWattValue">
    <xsl:param name="value"/>
    <xsl:param name="unit" select="watt"/>
    <xsl:choose>
      <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$gstrNA"/></xsl:when>
      <xsl:when test="$value = ''"><xsl:value-of select="$gstrNA"/></xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <!-- display both watt and btuphr. eg. "100 W ( 341 BTU/hr )" -->
          <xsl:when test="$unit = 'all'">
            <xsl:value-of select="$value"/><xsl:value-of select="$gstrWattUnit"/>
            <xsl:value-of select="$gstrOpenBrace"/>
            <xsl:call-template name="convertWattToBTUhr">
              <xsl:with-param name="value"><xsl:value-of select="$value"/></xsl:with-param>
            </xsl:call-template>
            <xsl:value-of select="$gstrCloseBrace"/>
          </xsl:when>
          <!-- for BTU/hr -->
          <xsl:when test="$unit = 'btuphr'">
            <xsl:call-template name="convertWattToBTUhr">
              <xsl:with-param name="value"><xsl:value-of select="$value"/></xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <!-- default to watt -->
          <xsl:otherwise>
            <xsl:value-of select="$value"/><xsl:value-of select="$gstrWattUnit"/>
          </xsl:otherwise>          
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="formatKiloWattValue">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$gstrNA"/></xsl:when>
      <xsl:when test="$value = ''"><xsl:value-of select="$gstrNA"/></xsl:when>
      <xsl:otherwise>
        <xsl:variable name="formatval"><xsl:value-of select="format-number($value div 1000,'##0.0')"/></xsl:variable>
					<xsl:variable name="univdecsep">
						<xsl:choose>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="localdecsep"><xsl:value-of select="$gstrDecimalFractionSeperator"/></xsl:variable>
					<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$gstrKiloWattHrUnit"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="formatDeciAmpsValue">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$value = '-2147483648'"><xsl:value-of select="$gstrNA"/></xsl:when>
      <xsl:when test="$value = ''"><xsl:value-of select="$gstrNA"/></xsl:when>
      <xsl:otherwise>
        <xsl:variable name="formatval"><xsl:value-of select="format-number($value div 10,'##0.0')"/></xsl:variable>
					<xsl:variable name="univdecsep">
						<xsl:choose>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="localdecsep"><xsl:value-of select="$gstrDecimalFractionSeperator"/></xsl:variable>
					<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$gstrAmperageUnit"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="convertWattToBTUhr">
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="$value = '-2147483648'"></xsl:when>
      <xsl:when test="$value = ''"></xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="calculateFromWattToBTUhr">
          <xsl:with-param name="value"><xsl:value-of select="$value"/></xsl:with-param>
        </xsl:call-template>
        <xsl:value-of select="$gstrBTUhrUnit"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="calculateFromWattToBTUhr">
    <xsl:param name="value"/>
    <xsl:value-of select="round($value * 3.413)"/>
  </xsl:template>

  <xsl:template name="calculateFromWattToPercentage">
    <xsl:param name="wattValue"/>
    <xsl:param name="minPower"/>
    <xsl:param name="maxPower"/>
	<xsl:param name="iDRACType"/>
    <xsl:variable name="denoVal" select="$maxPower - $minPower" />
    <xsl:if test="$denoVal &gt; '0' and $iDRACType &lt; '15'">
      <xsl:value-of select="round( (($wattValue - $minPower) div $denoVal) * 100 )"/>
    </xsl:if>
	 <xsl:if test="$denoVal &gt; '0' and $iDRACType &gt; '15'">
		<xsl:choose>
			<xsl:when test="$wattValue &lt; $minPower">
				<xsl:value-of select="0"/>
			</xsl:when>	
			<xsl:otherwise>
				<xsl:value-of select="round( (($wattValue - $minPower) div $denoVal) * 100 )"/>
	        </xsl:otherwise> 
		</xsl:choose>	
	</xsl:if>
  </xsl:template>

</xsl:stylesheet>
