<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:import href="Util.xsl"/>
  <xsl:variable name="varUnit">
    <xsl:choose>
      <xsl:when test="/OMA/@cli = 'true'"><xsl:value-of select="/OMA/UnitType"/></xsl:when>
      <xsl:otherwise>all</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="varMaxPotPower"><xsl:value-of select="/OMA/PowerConsumptionDataObj/maxPower"/></xsl:variable>
  <xsl:variable name="varMinPotPower"><xsl:value-of select="/OMA/PowerConsumptionDataObj/minPower"/></xsl:variable>
  <xsl:variable name="variDRACType"><xsl:value-of select="/OMA/EMPObj/type"/></xsl:variable>
                
  <xsl:template match="OMA">
    <xsl:choose>
      <!-- Power Monitoring not available -->
      <xsl:when test="count(/OMA/PowerConsumptionDataObj) &lt; 1">
        <DataArea>
          <CustomButton>
            <Data>
              <xsl:attribute name="display"><xsl:value-of select="$gstrRefresh"/></xsl:attribute>
              <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PowerBudgetWebPlugin&amp;help=Powerbudget</xsl:attribute>
            </Data>
          </CustomButton>
          <PromptText><xsl:value-of select="$strPowerBudgetNAMessage"/></PromptText>
        </DataArea>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
	 <!-- Power Monitoring Object is available, but Power budget is not availlable condition -->
          <xsl:when test="/OMA/PowerConsumptionDataObj/minPower = '65535' or /OMA/PowerConsumptionDataObj/powerCapCaps = '0'">
		 <PromptText><xsl:value-of select="$strPowerBudgetNAMessage"/></PromptText>
	   </xsl:when>
          <!-- Power Monitoring available, but error condition -->
          <xsl:when test="SMStatus != '0'">
            <DataArea>
              <PageTitle><xsl:attribute name="display"><xsl:value-of select="$strPwrInventoryandBudget"/></xsl:attribute></PageTitle>
              <TableData>
                <Header>
                  <Data>
                    <xsl:attribute name="display"><xsl:value-of select="$gstrError"/></xsl:attribute>
                    <xsl:attribute name="value"><xsl:value-of select="$gstrError"/></xsl:attribute>
                  </Data>
                </Header>
                <Row>
                  <Data>
                    <xsl:attribute name="display"><xsl:value-of select="$gstr"/></xsl:attribute>
                    <xsl:attribute name="value">
                      <xsl:call-template name="smstatus">
                        <xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
                      </xsl:call-template>
                    </xsl:attribute>
                  </Data>
                </Row>
              </TableData>
            </DataArea>
          </xsl:when>
          <!-- Power Monitoring available and success condition -->
          <xsl:otherwise>
            <DataArea onLoad="true">
              <xsl:if test="(/OMA/OMAUserRights = '7')">
                <xsl:attribute name="validate">true</xsl:attribute>
                <xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetPowerBudgetWebPlugin</xsl:attribute>
              </xsl:if>
              <PageTitle><xsl:attribute name="display"><xsl:value-of select="$strPwrInventoryandBudget"/></xsl:attribute></PageTitle>
              <CustomButton>
                <Data>
                  <xsl:attribute name="display"><xsl:value-of select="$gstrRefresh"/></xsl:attribute>
                  <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.PowerBudgetWebPlugin&amp;help=Powerbudget</xsl:attribute>
                </Data>
              </CustomButton>
              <xsl:apply-templates select="PowerConsumptionDataObj"/>			  
              
              <script language="javascript" src="/oma/js/UtilPM.js"/>
              <script language="javascript">

	            function initializationRoutine()
	            {			
		            DisableEnableCap();
	            }
	            function DisableEnableCap()
	            {		
		            var userRights = "<xsl:value-of select="/OMA/OMAUserRights"/>";
		            if((document.getElementById("CapEnable").checked) &amp;&amp; (userRights == 7))
		            {	
			            document.getElementById("wattcap").disabled  =false;
			            document.getElementById("btucap").disabled  =false;
			            document.getElementById("percentcap").disabled  =false;
		            }
		            else
		            {					
			            document.getElementById("wattcap").disabled  =true;
			            document.getElementById("btucap").disabled  =true;
			            document.getElementById("percentcap").disabled  =true;
		            }
	            }

              function validate()
              {
                var iDRACType = <xsl:value-of select="$variDRACType"/>;
				var minPotPower =<xsl:value-of select="$varMinPotPower"/>;
				
                var maxPotPower = <xsl:value-of select="$varMaxPotPower"/>;
                var watt = document.getElementById("wattcap").value;
		            var orgVal = <xsl:value-of select="/OMA/PowerConsumptionDataObj/powerCap"/>
				
				if(iDRACType &gt; 15)
				{
					if (watt &lt; minPotPower)
					{
						if (confirm("<xsl:value-of select="$strthtottlemsg"/>"))
							return true;
						else
						{
							document.getElementById("wattcap").value = orgVal;
							updateCorrespondingFields("wattcap");
							return false;
						}
					}
				
					if ((watt &lt; 0) || (watt &gt; maxPotPower))
					{
					  alert(<xsl:value-of select="$strErrorValueOutOfRange"/>);
				
						document.getElementById("wattcap").value = orgVal;
						updateCorrespondingFields("wattcap");

					  return false;
					}
					
				}
				if(iDRACType &lt; 15)
				{
					if ((watt &lt; minPotPower) || (watt &gt; maxPotPower))
					{
					  alert(<xsl:value-of select="$strErrorValueOutOfRange"/>);
				
						document.getElementById("wattcap").value = orgVal;
						updateCorrespondingFields("wattcap");

					  return false;
					}
				}
             
                return true;
              }

              function validateBudget(component)
              {
                validateAndAllowNumbers(component);
                updateCorrespondingFields(component.name);
              }

              function updateCorrespondingFields(name)
              {
                var minPotPower = <xsl:value-of select="$varMinPotPower"/>;
                var maxPotPower = <xsl:value-of select="$varMaxPotPower"/>;

                if( "wattcap" == name )
                {
                  var wattvalue = document.getElementById("wattcap").value;
                  document.getElementById("btucap").value = convertFromWattToBTUhr(wattvalue);
                  document.getElementById("percentcap").value = 
                                               convertFromWattToPercentage(wattvalue, minPotPower, maxPotPower);
                }

                if( "btucap" == name )
                {
                  var btuvalue = document.getElementById("btucap").value;
                  var wattvalue = document.getElementById("wattcap").value = convertFromBTUhrToWatt(btuvalue);
                  document.getElementById("percentcap").value =
                                                convertFromWattToPercentage(wattvalue, minPotPower, maxPotPower);
                }

                if( "percentcap" == name )
                {
                  var percentvalue = document.getElementById("percentcap").value;
                  var wattvalue = document.getElementById("wattcap").value =
                  convertFromPercentageToWatt(percentvalue, minPotPower, maxPotPower);
                  document.getElementById("btucap").value = convertFromWattToBTUhr(wattvalue);
                }
              }

              function convertFromWattToPercentage(wattValue, minPotPower, maxPotPower)
              {
				var iDRACType = <xsl:value-of select="$variDRACType"/>;
				if (iDRACType &lt; 15)
				{
					var denoVal = maxPotPower - minPotPower;
					var percentVal = 0;
					if(denoVal > 0)
					{
					  percentVal = Math.round( ((wattValue - minPotPower)/denoVal) * 100 );
					  if(percentVal &lt; 0 || percentVal &gt; 100 )
						percentVal = "<xsl:value-of select="$strInvalid"/>";
					}
				}
				if (iDRACType &gt; 15)
				{					
					var percentVal = 0;
					var denoVal = maxPotPower - minPotPower;
					if( wattValue &lt; minPotPower )
					 {
					   percentVal = 0;
					 }
                     else if(denoVal > 0)
					{
							percentVal = Math.round( ((wattValue - minPotPower)/denoVal) * 100 );
							if(percentVal &lt; 0 || percentVal &gt; 100 )
							percentVal = "<xsl:value-of select="$strInvalid"/>";
					}
					  			
				}
                return percentVal;
              }

              function convertFromPercentageToWatt(percentValue, minPotPower, maxPotPower)
              {
				var wattVal = Math.round( ((maxPotPower - minPotPower) * (percentValue/100))+ minPotPower);				
				return wattVal;
              }

		          function incr1(x, y)
		          {
		            var CapEnable = document.getElementById("CapEnable").checked;
			          var userRights = "<xsl:value-of select="/OMA/OMAUserRights"/>";
			          if ((CapEnable == true) &amp;&amp; (userRights == 7))
			          {
			           curobj=parseInt(document.dataarea.percentcap.value);

			           curobj = curobj + x;
			           if ( y &gt;= curobj ){
			                document.dataarea.percentcap.value = curobj;
			           }
			            else{
			                document.dataarea.percentcap.value = y;	
			            }
                            
			           updateCorrespondingFields("percentcap");
		            }
	            }
		          function decr1(a, b)	
              {
		            var CapEnable = document.getElementById("CapEnable").checked;
			          var userRights = "<xsl:value-of select="/OMA/OMAUserRights"/>";
			          if ((CapEnable == true) &amp;&amp; (userRights == 7))
			          {
			            curobj=parseInt(document.dataarea.percentcap.value);
			            curobj = curobj - a;
				          if ( b &lt;= curobj ){
			                document.dataarea.percentcap.value = curobj;
			            }
			            else{
			                document.dataarea.percentcap.value = b;
			            }
                            
                  updateCorrespondingFields("percentcap");
		          }
	           }
            </script>
            </DataArea>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="PowerConsumptionDataObj">
  <xsl:call-template name="PowerInventory"/>
  <xsl:call-template name="PowerBudget"/>
  </xsl:template>
    
  <xsl:template name="PowerInventory">
    <ListData type="custom" columnspacing="true" name="inventory" >
      <xsl:attribute name="display"><xsl:value-of select="$strPwrInventory"/></xsl:attribute>
	    <Header>
        <Data>
        <xsl:attribute name="display"><xsl:value-of select="$strPwrInventory"/></xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="$strPwrInventory"/></xsl:attribute>
        </Data>
      </Header>
 
    
        <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strIdlePower"/></xsl:attribute>
          <xsl:attribute name="value">
          <xsl:call-template name="formatWattValue">
            <xsl:with-param name="value"><xsl:value-of select="minPower"/></xsl:with-param>
            <xsl:with-param name="unit"><xsl:value-of select="$varUnit"/></xsl:with-param>            			
	        </xsl:call-template>
	        </xsl:attribute>
        </Data>
	  
	 
         <Data>
          <xsl:attribute name="display"><xsl:value-of select="$strMaxPotentialPwrConsumption"/></xsl:attribute>        
	        <xsl:attribute name="value">
            <xsl:call-template name="formatWattValue">
              <xsl:with-param name="value"><xsl:value-of select="maxPower"/></xsl:with-param>
              <xsl:with-param name="unit"><xsl:value-of select="$varUnit"/></xsl:with-param>            
            </xsl:call-template>
	      </xsl:attribute>
        </Data>
   
    </ListData>
  </xsl:template>

  <xsl:template name="PowerBudget">
    <TableData name="showbudget" columnspacing="true">
		  <xsl:attribute name="display"><xsl:value-of select="$strPowerBudget"/></xsl:attribute>
      <SubHeader>
        <xsl:attribute name="display"><xsl:value-of select="$strPowerBudget"/></xsl:attribute>
      </SubHeader>
      <xsl:if test="(/OMA/OMAUserRights = '7') and (powerCapCaps = '3')">
	 			<PromptText><xsl:value-of select="$strEditPowerCap"/> ( 0% = <xsl:value-of select="minPower"/> <xsl:value-of select="$gstrWattUnit"/>, 100% = <xsl:value-of select="maxPower"/> <xsl:value-of select="$gstrWattUnit"/> )</PromptText>
	      </xsl:if>
		  <Header>
			  <Data width="50%">
				  <xsl:attribute name="value"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
				  <xsl:attribute name="display"><xsl:value-of select="$gstrAttribute"/></xsl:attribute>
			  </Data>
        <Data name="h2" align="center">
        <xsl:attribute name="display"><xsl:value-of select="$gstrValues"/></xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$gstrValues"/></xsl:attribute>
	  <xsl:attribute name="noborder">true</xsl:attribute>
        </Data>
	 <Data>
        <xsl:attribute name="noborder">true</xsl:attribute>
        </Data>
	 <Data>      
        </Data>
      </Header>
      <xsl:choose>
        <xsl:when test="/OMA/@cli = 'true'"><xsl:call-template name="cli"/></xsl:when>
        <xsl:otherwise><xsl:call-template name="web"/></xsl:otherwise>
      </xsl:choose>
    </TableData>
  </xsl:template>
 
  <xsl:template name="web">
	<Row>
	<Data >
	      <xsl:attribute name="value"><xsl:value-of select="$strEnableCap"/></xsl:attribute>
	      <xsl:attribute name="display"><xsl:value-of select="$strEnableCap"/></xsl:attribute>
	</Data>
	<Data align="center" name ="CapEnable" type="checkbox" returnvalue="1"  colspan="3">
		<xsl:choose>
			<!-- cannot enable/disable the cap -->
			<xsl:when test="powerCapCaps = '0' and powerCapSetting='1'">
				<xsl:attribute name="state">3</xsl:attribute>
			</xsl:when>
			<xsl:when test="powerCapCaps = '0' ">
				<xsl:attribute name="state">2</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="(/OMA/OMAUserRights != '7')">		
						<xsl:if test="powerCapSetting = '1'">
							<xsl:attribute name="state">3</xsl:attribute>
						</xsl:if>
						<xsl:if test="powerCapSetting = '0'">
							<xsl:attribute name="state">2</xsl:attribute>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="powerCapSetting = '1' ">		
							<xsl:attribute name="state">1</xsl:attribute>
						</xsl:if>					
					</xsl:otherwise>			
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:attribute name="event">onClick</xsl:attribute>
		<xsl:attribute name="handler">javascript:DisableEnableCap()</xsl:attribute>
	</Data>
	</Row>      

      <xsl:element name="Row">
        <Data name="action">
          <xsl:attribute name="value"><xsl:value-of select="$strBudgetCap"/></xsl:attribute>
        </Data>
        <xsl:element name="Data">
          <xsl:attribute name="align">center</xsl:attribute>
          <xsl:attribute name="type">editbox</xsl:attribute>
          <xsl:if test="(/OMA/OMAUserRights != '7')">
            <xsl:attribute name="state">2</xsl:attribute>
          </xsl:if>
          <xsl:attribute name="name">wattcap</xsl:attribute>
          <xsl:attribute name="size">4</xsl:attribute>
          <xsl:attribute name="maxlength">4</xsl:attribute>
          <xsl:attribute name="value"><xsl:value-of select="powerCap"/></xsl:attribute>
          <xsl:attribute name="unit"><xsl:value-of select="$gstrWattUnit"/></xsl:attribute>
          <xsl:attribute name="event">onKeyUp</xsl:attribute>
          <xsl:attribute name="handler">javascript:validateBudget(this);</xsl:attribute>
        </xsl:element>
        <xsl:element name="Data">
          <xsl:attribute name="align">center</xsl:attribute>
            <xsl:attribute name="type">editbox</xsl:attribute>
          <xsl:if test="(/OMA/OMAUserRights != '7')">
            <xsl:attribute name="state">2</xsl:attribute>
          </xsl:if>          
          <xsl:attribute name="name">btucap</xsl:attribute>
          <xsl:attribute name="size">4</xsl:attribute>
          <xsl:attribute name="maxlength">4</xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="calculateFromWattToBTUhr">
              <xsl:with-param name="value"><xsl:value-of select="powerCap"/></xsl:with-param>
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="unit"><xsl:value-of select="$gstrBTUhrUnit"/></xsl:attribute>
          <EventHandler>
            <xsl:attribute name="event">onKeyUp</xsl:attribute>
            <xsl:attribute name="handler">javascript:validateBudget(this);</xsl:attribute>
          </EventHandler>
        </xsl:element>
        <xsl:element name="Data">
          <xsl:attribute name="align">center</xsl:attribute>
          <xsl:attribute name="type">spincontrol</xsl:attribute>
          <xsl:if test="(/OMA/OMAUserRights != '7')">
            <xsl:attribute name="state">2</xsl:attribute>
          </xsl:if>
          <xsl:attribute name="name">percentcap</xsl:attribute>
          <xsl:attribute name="size">7</xsl:attribute>
          <xsl:attribute name="maxlength">3</xsl:attribute>
          <xsl:attribute name="value">
            <xsl:call-template name="calculateFromWattToPercentage">
              <xsl:with-param name="wattValue"><xsl:value-of select="powerCap"/></xsl:with-param>
              <xsl:with-param name="minPower"><xsl:value-of select="minPower"/></xsl:with-param>
              <xsl:with-param name="maxPower"><xsl:value-of select="maxPower"/></xsl:with-param>
			   <xsl:with-param name="iDRACType"><xsl:value-of select="$variDRACType"/></xsl:with-param>            
            </xsl:call-template>
          </xsl:attribute>
          <xsl:attribute name="posttext"><xsl:value-of select="$gstrPercentSymbol"/></xsl:attribute>
          <xsl:attribute name="event">onKeyUp</xsl:attribute>
          <xsl:attribute name="handler">javascript:validateBudget(this);</xsl:attribute>
					<xsl:attribute name="uparrscript"><xsl:call-template name="increment"/></xsl:attribute>
					<xsl:attribute name="downarrscript"><xsl:call-template name="decrement"/></xsl:attribute>          
        </xsl:element>
      </xsl:element>
  </xsl:template>

  <xsl:template name="cli">
  <Row >
	<Data >
	      <xsl:attribute name="value"><xsl:value-of select="$strEnableCap"/></xsl:attribute>
	      <xsl:attribute name="display"><xsl:value-of select="$strEnableCap"/></xsl:attribute>
	</Data>
	<Data >
	<xsl:choose>
		<xsl:when test="powerCapSetting ='1'">
			<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="powerCapSetting ='0'">
			<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
		</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
	</Data>
      </Row>
      <xsl:element name="Row">
        <Data name="action">
          <xsl:attribute name="value"><xsl:value-of select="$strBudgetCap"/></xsl:attribute>
        </Data>
        <xsl:element name="Data">
          <xsl:attribute name="align">right</xsl:attribute>
          <xsl:attribute name="value">
            <xsl:choose>
              <xsl:when test="$varUnit = 'btuphr'">
                <xsl:call-template name="convertWattToBTUhr">
                  <xsl:with-param name="value"><xsl:value-of select="powerCap"/></xsl:with-param>
                </xsl:call-template>
                <xsl:text> ( </xsl:text>
                <xsl:call-template name="calculateFromWattToPercentage">
                  <xsl:with-param name="wattValue"><xsl:value-of select="powerCap"/></xsl:with-param>
                  <xsl:with-param name="minPower"><xsl:value-of select="minPower"/></xsl:with-param>
                  <xsl:with-param name="maxPower"><xsl:value-of select="maxPower"/></xsl:with-param>
				  <xsl:with-param name="iDRACType"><xsl:value-of select="/OMA/EMPObj/type"/></xsl:with-param> </xsl:call-template>
                <xsl:text>% )</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="formatWattValue">
                  <xsl:with-param name="value"><xsl:value-of select="powerCap"/></xsl:with-param>
                </xsl:call-template>
                <xsl:text> ( </xsl:text>
                <xsl:call-template name="calculateFromWattToPercentage">
                  <xsl:with-param name="wattValue"><xsl:value-of select="powerCap"/></xsl:with-param>
                  <xsl:with-param name="minPower"><xsl:value-of select="minPower"/></xsl:with-param>
                  <xsl:with-param name="maxPower"><xsl:value-of select="maxPower"/></xsl:with-param>
				   <xsl:with-param name="iDRACType"><xsl:value-of select="/OMA/EMPObj/type"/></xsl:with-param> 
                </xsl:call-template>
                <xsl:text>% )</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>            
        </xsl:element>
      </xsl:element>
  </xsl:template>
  
  <xsl:template name="increment">javascript:incr1(1,100)</xsl:template>
  <xsl:template name="decrement">javascript:decr1(1,0)</xsl:template>

  <xsl:template name="smstatus">
    <xsl:param name="status"/>
    <xsl:param name="mssg"/>
    <xsl:choose>
      <xsl:when test="$status = '-1'"><xsl:value-of select="$gstrCommandUnsuccessful"/></xsl:when>
      <xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
