<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:template match="OMA">
	<xsl:choose>
		<xsl:when test="VoltageProbeList/@count = '0' or SMStatus != '0'">
			<xsl:call-template name="failure"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="VoltageProbeList"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="failure">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strVoltageProbes"/></xsl:attribute>
		</PageTitle>
		<TableData>
			<Header>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="$strError"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strError1"/></xsl:attribute>
				</Data>
			</Header>
			<Row>
				<Data>
				 	<xsl:attribute name="value"><xsl:value-of select="$strNoVoltageProbe"/></xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>
<xsl:template match="VoltageProbeList">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strVoltageProbes1"/></xsl:attribute>
			<xsl:if test="not(/OMA/@cli) or /OMA/@cli != 'true'">
				<xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
			</xsl:if>
		</PageTitle>
		<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
			<PromptText><xsl:value-of select="$strClickTheProbe"/></PromptText>
		</xsl:if>
		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ListVoltageWebPlugin&amp;help=Voltages&amp;poid=<xsl:value-of select="@poid"/></xsl:attribute>
			</Data>
		</CustomButton>
				
		<xsl:if test="/OMA/@cli = 'true'">
			<TableData columnspacing="true" name="probestable">
                               	<SubHeader>
                                    	<xsl:attribute name="display"><xsl:value-of select="@display"/><xsl:value-of select="$strHealth"/></xsl:attribute>
                                    	<xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
				</SubHeader>
			</TableData>
		</xsl:if>

		<TableData columnspacing="true">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true'">
					<Header>
						<Data name="index">
							<xsl:attribute name="ignoreonweb">true</xsl:attribute>				
							<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
						</Data>
						<Data name="Status" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
						</Data>
						<Data name="ProbeName">
							<xsl:attribute name="display"><xsl:value-of select="$strProbeName"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strProbeName1"/></xsl:attribute>
						</Data>
						<Data name="Reading" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strReading1"/></xsl:attribute>
						</Data>
						<Data name="min" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strMinimumWarningThreshold"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMinimumWarningThreshold1"/></xsl:attribute>
						</Data>
						<Data name="max" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strMaximumWarningThreshold"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMaximumWarningThreshold1"/></xsl:attribute>
						</Data>
						<Data name="min" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strMinimumFailureThreshold"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMinimumFailureThreshold1"/></xsl:attribute>
						</Data>
						<Data name="max" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strMaximumFailureThreshold"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMaximumFailureThreshold1"/></xsl:attribute>
						</Data>
					</Header>
				</xsl:when>
				<xsl:otherwise>
					<Header>
						<Data name="" ignoreonweb="true"><xsl:attribute name="value"><xsl:value-of select="$str"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str1"/></xsl:attribute></Data>
						<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str2"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str3"/></xsl:attribute></Data>
						<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str4"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str5"/></xsl:attribute></Data>
						<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str6"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str7"/></xsl:attribute></Data>
						<Data name="MinimumThreshold"  colspan="2" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strWarningThreshold"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strWarningThreshold1"/></xsl:attribute>
						</Data>
						<Data name="MaximumThreshold" colspan="2" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strFailureThreshold"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strFailureThreshold1"/></xsl:attribute>
						</Data>
					</Header>
					<Header>
						<Data name="index">
							<xsl:attribute name="ignoreonweb">true</xsl:attribute>				
							<xsl:attribute name="display"><xsl:value-of select="$strIndex2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strIndex3"/></xsl:attribute>
						</Data>
						<Data name="Status" align="center">
							<xsl:attribute name="display"><xsl:value-of select="$strStatus2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strStatus3"/></xsl:attribute>
						</Data>
						<Data name="ProbeName">
							<xsl:attribute name="display"><xsl:value-of select="$strProbeName2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strProbeName3"/></xsl:attribute>
						</Data>
						<Data name="Reading" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strReading2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strReading3"/></xsl:attribute>
						</Data>
						<Data name="min" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strMinimum"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMinimum1"/></xsl:attribute>
							<xsl:attribute name="append"><xsl:value-of select="$strWarningThreshold2"/></xsl:attribute>
              <xsl:attribute name="noborder">true</xsl:attribute>           
            </Data>
            <Data name="max" align="left">
              <xsl:attribute name="display"><xsl:value-of select="$strMaximum"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMaximum1"/></xsl:attribute>
							<xsl:attribute name="append"><xsl:value-of select="$strWarningThreshold3"/></xsl:attribute>
						</Data>
						<Data name="min" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strMinimum2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMinimum3"/></xsl:attribute>
							<xsl:attribute name="append"><xsl:value-of select="$strFailureThreshold2"/></xsl:attribute>
              <xsl:attribute name="noborder">true</xsl:attribute>           
						</Data>
						<Data name="max" align="left">
							<xsl:attribute name="display"><xsl:value-of select="$strMaximum2"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strMaximum3"/></xsl:attribute>
							<xsl:attribute name="append"><xsl:value-of select="$strFailureThreshold3"/></xsl:attribute>
						</Data>
					</Header>
				</xsl:otherwise>
			</xsl:choose>
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true'">
				<xsl:apply-templates select="VoltageProbe">
					<xsl:sort data-type="number" select="@index" order="ascending"/>
					<xsl:with-param name="poid"><xsl:value-of select="@poid"/></xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="VoltageProbe">
					<xsl:sort data-type="number" select="@index" order="ascending"/>
					<xsl:with-param name="poid"><xsl:value-of select="@poid"/></xsl:with-param>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template match="VoltageProbe">
	<xsl:param name="poid"/>
<xsl:choose>
		<xsl:when test="SubType=17">
			<Row>
				<xsl:element name="Data">
					<xsl:attribute name="ignoreonweb">true</xsl:attribute>
					<xsl:attribute name="display" ><xsl:value-of select="@index"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
				</xsl:element>
				<xsl:element name="Data">
					<xsl:attribute name="align">center</xsl:attribute>
					<xsl:attribute name="type">status</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
				</xsl:element>
				<xsl:element name="Data">
					<xsl:attribute name="value"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
					<xsl:attribute name="type">ustring</xsl:attribute>
					<xsl:attribute name="editable">false</xsl:attribute>
				</xsl:element>	
				<Data>
					<xsl:attribute name="align">left</xsl:attribute>
					<xsl:attribute name="value">
						<xsl:choose>
		                    <xsl:when test="ProbeReading='1'"><xsl:value-of select="$strGood"/></xsl:when>
							<xsl:when test="ProbeReading='2'"><xsl:value-of select="$strBad"/></xsl:when>
		                </xsl:choose>
					</xsl:attribute>
				</Data>			
				<Data>
					<xsl:attribute name="align">left</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="align">left</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="align">left</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="align">left</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</Data>
			 </Row>			
	 	</xsl:when>				
<xsl:otherwise> 
	<Row>
		<xsl:element name="Data">
			<xsl:attribute name="ignoreonweb">true</xsl:attribute>
			<xsl:attribute name="display" ><xsl:value-of select="@index"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="align">center</xsl:attribute>
			<xsl:attribute name="type">status</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
		</xsl:element>
			<xsl:element name="Data">
			<xsl:attribute name="value"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
				<xsl:if test="(ProbeThresholds/LCThreshold != '-2147483648') and (ProbeThresholds/UCThreshold != '-2147483648') and (ProbeThresholds/LNCThreshold != '-2147483648') and (ProbeThresholds/UNCThreshold != '-2147483648') and (ProbeReading != '-2147483648')">
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.VoltageWebPlugin&amp;help=EditVoltageProbes&amp;oid=<xsl:value-of select="@oid"/>&amp;poid=<xsl:value-of select="$poid"/></xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="volt"><xsl:value-of select="ProbeReading"/></xsl:with-param>
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeReading"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:with-param>
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param>
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:with-param>
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param>
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:element>
 </Row>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template name="calVolt">
	<xsl:param name="volt"/>
	<xsl:param name="type"/>
	<xsl:choose>
		<xsl:when test="$volt = '-2147483648'">
			<xsl:choose>
            			<xsl:when test="$type = '12' or $type = '17'"><xsl:value-of select="$strNA"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$strNA"/></xsl:otherwise>
	            </xsl:choose>
		</xsl:when>
		<!-- for PMBUS PSU Input Voltage Readings -->
		<xsl:when test="$volt &gt; 60000">
			<xsl:variable name="formatval"><xsl:value-of select="format-number($volt div 1000,'##0')"/></xsl:variable>
			<xsl:value-of select="$formatval"/><xsl:value-of select="$strVolt"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="formatval"><xsl:value-of select="format-number($volt div 1000,'##0.000')"/></xsl:variable>
			<xsl:variable name="univdecsep">
				<xsl:choose>
					<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
					<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="localdecsep"><xsl:value-of select="$strDecimalFractionSeperatorPart2"/></xsl:variable>
			<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$strVolt"/>
		</xsl:otherwise>	
	</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
