<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:template match="OMA">
	<xsl:choose>
	<xsl:when test="SMStatus='0'"><xsl:apply-templates select="CurrentProbeList"/></xsl:when>
	<xsl:otherwise><xsl:call-template name="failure"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="failure">
	<DataArea>
		<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strCurrentProbes"/></xsl:attribute></PageTitle>
		<TableData>
			<Header>
				<Data name=""><xsl:attribute name="value"><xsl:value-of select="$strCurrentProbes1"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$strCurrentProbes2"/></xsl:attribute></Data>
			</Header>
			<Row>
				<Data name="" ><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
					<xsl:attribute name="value">
						<xsl:call-template name="smstatus">
							<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
						</xsl:call-template>
					</xsl:attribute>
				</Data>
			</Row>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template match="CurrentProbeList">
	<DataArea>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strCurrentProbes3"/></xsl:attribute>
			<xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
		</PageTitle>
		<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
			<PromptText><xsl:value-of select="$strClickTheProbe"/></PromptText>
		</xsl:if>
		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ListCurrentWebPlugin&amp;poid=<xsl:value-of select="@poid"/></xsl:attribute>
			</Data>
		</CustomButton>
		<TableData columnspacing="true">
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true'">
				<Header>
					<Data name="index">
						<xsl:attribute name="ignoreonweb">true</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strIndex"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strIndex1"/></xsl:attribute>
					</Data>
					<Data name="Status" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strStatus1"/></xsl:attribute>
					</Data>
					<Data name="ProbeName">
						<xsl:attribute name="display"><xsl:value-of select="$strProbeName"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strProbeName1"/></xsl:attribute>
					</Data>
					<Data name="Reading" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strReading1"/></xsl:attribute>
					</Data>
					<Data name="min" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMinimumWarningThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMinimumWarningThreshold1"/></xsl:attribute>
					</Data>
					<Data name="max" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMaximumWarningThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMaximumWarningThreshold1"/></xsl:attribute>
					</Data>
					<Data name="min" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMinimumFailureThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMinimumFailureThreshold1"/></xsl:attribute>
					</Data>
					<Data name="max" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMaximumFailureThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMaximumFailureThreshold1"/></xsl:attribute>
					</Data>
				</Header>
			</xsl:when>
			<xsl:otherwise>
				<Header>
					<Data name="" ignoreonweb="true"><xsl:attribute name="value"><xsl:value-of select="$str1"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str2"/></xsl:attribute></Data>
					<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str3"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str4"/></xsl:attribute></Data>
					<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str5"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str6"/></xsl:attribute></Data>
					<Data name=""><xsl:attribute name="value"><xsl:value-of select="$str7"/></xsl:attribute><xsl:attribute name="display"><xsl:value-of select="$str8"/></xsl:attribute></Data>
					<Data name="WarningThreshold"  colspan="3" italic="true" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strWarningThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strWarningThreshold1"/></xsl:attribute>
					</Data>
					<Data name="FailureThreshold" colspan="3" italic="true" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strFailureThreshold"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strFailureThreshold1"/></xsl:attribute>
					</Data>
				</Header>
				<Header>
					<Data name="index">
						<xsl:attribute name="ignoreonweb">true</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strIndex2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strIndex3"/></xsl:attribute>
					</Data>
					<Data name="Status" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strStatus2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strStatus3"/></xsl:attribute>
					</Data>
					<Data name="ProbeName">
						<xsl:attribute name="display"><xsl:value-of select="$strProbeName2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strProbeName3"/></xsl:attribute>
					</Data>
					<Data name="Reading" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strReading2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strReading3"/></xsl:attribute>
					</Data>
					<Data name="min" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMinimum"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMinimum1"/></xsl:attribute>
						<xsl:attribute name="append"><xsl:value-of select="$strWarningThreshold2"/></xsl:attribute>
					</Data>
					<Data name="max" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMaximum"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMaximum1"/></xsl:attribute>
						<xsl:attribute name="append"><xsl:value-of select="$strWarningThreshold3"/></xsl:attribute>
					</Data>
					<Data name="min" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMinimum2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMinimum3"/></xsl:attribute>
						<xsl:attribute name="append"><xsl:value-of select="$strFailureThreshold2"/></xsl:attribute>
					</Data>
					<Data name="max" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strMaximum2"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strMaximum3"/></xsl:attribute>
						<xsl:attribute name="append"><xsl:value-of select="$strFailureThreshold3"/></xsl:attribute>
					</Data>
				</Header>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="/OMA/@cli = 'true'">
				<xsl:apply-templates select="CurrentProbe">
					<xsl:sort data-type="number" select="@index" order="ascending"/>
					<xsl:with-param name="poid"><xsl:value-of select="@poid"/></xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="CurrentProbe">
					<xsl:sort data-type="text" select="ProbeLocation" order="ascending"/>
					<xsl:with-param name="poid"><xsl:value-of select="@poid"/></xsl:with-param>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
		</TableData>
	</DataArea>
</xsl:template>

<xsl:template match="CurrentProbe">
	<xsl:param name="poid"/>
	<Row>
		<xsl:element name="Data">
			<xsl:attribute name="ignoreonweb">true</xsl:attribute>
			<xsl:attribute name="display" ><xsl:value-of select="@index"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@index"/></xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="align">center</xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@status"/></xsl:attribute>
			<xsl:attribute name="type">status</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
		</xsl:element>
			<xsl:element name="Data">
			<xsl:attribute name="value"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeLocation"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
				<xsl:if test="(ProbeThresholds/LCThreshold != '-2147483648') and (ProbeThresholds/UCThreshold != '-2147483648') and (ProbeThresholds/LNCThreshold != '-2147483648') and (ProbeThresholds/UNCThreshold != '-2147483648') and (ProbeReading != '-2147483648') and (SubType!='19')">
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.CurrentWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;poid=<xsl:value-of select="@poid"/>&amp;help=EditCurrentProbes</xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
					<xsl:with-param name="volt"><xsl:value-of select="ProbeReading"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeReading"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">center</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
					<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/LNCThreshold"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">center</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
					<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/UNCThreshold"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">center</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
					<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/LCThreshold"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">center</xsl:attribute>
		</xsl:element>
		<xsl:element name="Data">
			<xsl:attribute name="value">
				<xsl:call-template name="calVolt">
					<xsl:with-param name="type"><xsl:value-of select="SubType"/></xsl:with-param>
					<xsl:with-param name="volt"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
			<xsl:attribute name="display"><xsl:value-of select="ProbeThresholds/UCThreshold"/></xsl:attribute>
			<xsl:attribute name="type">ustring</xsl:attribute>
			<xsl:attribute name="editable">false</xsl:attribute>
			<xsl:attribute name="align">center</xsl:attribute>
		</xsl:element>
	</Row>
</xsl:template>

<xsl:template name="calVolt">
	<xsl:param name="type"/>
	<xsl:param name="volt"/>
	<xsl:choose>
		<xsl:when test="$type='19'">
			<xsl:choose>
				<xsl:when test="$volt = '-2147483648'"><xsl:value-of select="$strNotApplicable"/></xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$volt = '1'"><xsl:value-of select="$strGood"/></xsl:when>
                        <xsl:when test="$volt = '2'"><xsl:value-of select="$strBad"/></xsl:when>
                   </xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="$volt = '-2147483648'"><xsl:value-of select="$strNA"/></xsl:when>
				<xsl:otherwise>
					<xsl:variable name="formatval"><xsl:value-of select="format-number($volt div 1000,'##0.000')"/></xsl:variable>
					<xsl:variable name="univdecsep">
						<xsl:choose>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.</xsl:when>
							<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="localdecsep"><xsl:value-of select="$strDecimalFractionSeperatorPart2"/></xsl:variable>
					<xsl:value-of select="translate($formatval, $univdecsep,$localdecsep)"/><xsl:value-of select="$strAmps"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
    	</xsl:choose>
</xsl:template>

<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '1'"><xsl:value-of select="$strCommandNotImplemented"/></xsl:when>
			<xsl:when test="$status = '2'"><xsl:value-of select="$strBadCommand"/></xsl:when>
			<xsl:when test="$status = '3'"><xsl:value-of select="$strCommandTimeout"/></xsl:when>
			<xsl:when test="$status = '4'"><xsl:value-of select="$strCommandCancelled"/></xsl:when>
			<xsl:when test="$status = '5'"><xsl:value-of select="$strCommandAborted"/></xsl:when>
			<xsl:when test="$status = '6'"><xsl:value-of select="$strCommandPending"/></xsl:when>
			<xsl:when test="$status = '7'"><xsl:value-of select="$strNoSuchDevice"/></xsl:when>
			<xsl:when test="$status = '8'"><xsl:value-of select="$strDeviceBusy"/></xsl:when>
			<xsl:when test="$status = '9'"><xsl:value-of select="$strBadDevice"/></xsl:when>
			<xsl:when test="$status = '10'"><xsl:value-of select="$strSpuriousInterrupt"/></xsl:when>
			<xsl:when test="$status = '11'"><xsl:value-of select="$strResourceLocked"/></xsl:when>
			<xsl:when test="$status = '12'"><xsl:value-of select="$strInvalidIndex"/></xsl:when>
			<xsl:when test="$status = '13'"><xsl:value-of select="$strSMBError"/></xsl:when>
			<xsl:when test="$status = '14'"><xsl:value-of select="$strDataRequestedIs"/></xsl:when>
			<xsl:when test="$status = '15'"><xsl:value-of select="$strDataRequestedIs1"/></xsl:when>
			<xsl:when test="$status = '16'"><xsl:value-of select="$strDataRequestedIs2"/></xsl:when>
			<xsl:when test="$status = '17'"><xsl:value-of select="$strDeviceNotYet"/></xsl:when>
			<xsl:when test="$status = '18'"><xsl:value-of select="$strDeviceDoesNot"/></xsl:when>
			<xsl:when test="$status = '19'"><xsl:value-of select="$strDeviceOutOf"/></xsl:when>
			<xsl:when test="$status = '20'"><xsl:value-of select="$strDeviceAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '256'"><xsl:value-of select="$strCurrentProbesNot"/></xsl:when>
			<xsl:when test="$status = '257'"><xsl:value-of select="$strObjectMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '258'"><xsl:value-of select="$strObjectAlreadyExists"/></xsl:when>
			<xsl:when test="$status = '260'"><xsl:value-of select="$strINIFileNot"/></xsl:when>
			<xsl:when test="$status = '261'"><xsl:value-of select="$strINIMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '262'"><xsl:value-of select="$strINISectionDoes"/></xsl:when>
			<xsl:when test="$status = '263'"><xsl:value-of select="$strINIKeyDoes"/></xsl:when>
			<xsl:when test="$status = '264'"><xsl:value-of select="$strINIValueMalformed"/></xsl:when>
			<xsl:when test="$status = '270'"><xsl:value-of select="$strInsufficientAccessRights"/></xsl:when>
			<xsl:when test="$status = '271'"><xsl:value-of select="$strInvalidParameterName"/></xsl:when>
			<xsl:when test="$status = '272'"><xsl:value-of select="$strOutOfMemory"/></xsl:when>
			<xsl:when test="$status = '280'"><xsl:value-of select="$strXMLFileNot"/></xsl:when>
			<xsl:when test="$status = '281'"><xsl:value-of select="$strXMLMalformedCorrupt"/></xsl:when>
			<xsl:when test="$status = '282'"><xsl:value-of select="$strXMLNodeDoes"/></xsl:when>
			<xsl:when test="$status = '283'"><xsl:value-of select="$strXMLValueMalformed"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
