<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:variable name="ConsAlertTag">
	    <xsl:choose>
	      <xsl:when test="not(/OMA/LRAResponse/lroGlobalCapabilities/ConsAlert) or /OMA/LRAResponse/lroGlobalCapabilities/ConsAlert='false'">false</xsl:when>
	      <xsl:otherwise>true</xsl:otherwise>
	    </xsl:choose>
 </xsl:variable>
 
<xsl:variable name="BcastMssgTag">
	    <xsl:choose>
	      <xsl:when test="not(/OMA/LRAResponse/lroGlobalCapabilities/BcastMssg) or /OMA/LRAResponse/lroGlobalCapabilities/BcastMssg='false'">false</xsl:when>
	      <xsl:otherwise>true</xsl:otherwise>
	    </xsl:choose>
 </xsl:variable>
<xsl:variable name="ExecAppTag">
	    <xsl:choose>
	      <xsl:when test="not(/OMA/LRAResponse/lroGlobalCapabilities/ExecApp) or /OMA/LRAResponse/lroGlobalCapabilities/ExecApp='false'">false</xsl:when>
	      <xsl:otherwise>true</xsl:otherwise>
	    </xsl:choose>
 </xsl:variable>


	<xsl:template match="/OMA">
		<xsl:choose>
			<xsl:when test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
				<xsl:apply-templates select="LRAResponse"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="LRAResponse">
					<xsl:apply-templates select="lroConfigSDOArrayarray/lroConfigSDOArray"/>	
	</xsl:template>
	<xsl:template match="lroConfigSDOArray">
		<xsl:if test="lrcLraType = /OMA/LraType">
	    <!--DataArea>
		   <PromptText>/OMA/LraType : <xsl:value-of select="/OMA/LraType"/> lrcLraType: <xsl:value-of select="lrcLraType"/> : Working				   </PromptText>
	    </DataArea-->

		<DataArea validate="true" onLoad="true" exportdata="false"><xsl:attribute name="backpagedisplay"><xsl:value-of select="$strAlertActions"/></xsl:attribute>
			<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetLRAWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;lratype=<xsl:value-of select="/OMA/LraType"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.ListLRAWebPlugin&amp;help=ListLRA&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;help=ListLRA</xsl:attribute>
			<script language="javascript">
                function initializationRoutine()
                {
                }
                function validate()
                {
                <xsl:if test="(/OMA/OMAUserRights = '7') and (/OMA/IsTrueAdmin = 'true')">                
					if(document.getElementById("ExecApp").checked == true)
					{
						var EPFval = document.getElementById("EPFName").value;

						if(EPFval == "" || EPFval == null)
						{
							alert("<xsl:value-of select="$strEnterAbsolutePath"/>");
							document.getElementById("EPFName").focus();
							return false;
						}

						if(document.getElementById("EPFName").value.length > 255)
						{
							alert("<xsl:value-of select="$strAbsolutePathTo"/>");
							document.getElementById("EPFName").focus();
							return false;
						}
					}
                </xsl:if>
					return true;
				}
				function clearAll()
				{
					
				 <xsl:if test="(/OMA/OMAUserRights = '7') and (/OMA/IsTrueAdmin = 'true')">                
					document.getElementById("EPFName").value = "";
					document.getElementById("ExecApp").checked = false;
				</xsl:if>
					document.getElementById("ConsAlert").checked = false; 
					document.getElementById("BcastMssg").checked = false;
				}

				function setDefault()
				{
					document.getElementById("ConsAlert").checked = true;
					document.getElementById("BcastMssg").checked = true;
					//[pp] 02/28/2003 : DFCT77805 : clearing Exec App and App Name for 'Set to Default' option
					document.getElementById("ExecApp").checked = false;
					document.getElementById("EPFName").value='';
				}
				function checkExecApp()
				{
					document.getElementById("ExecApp").checked = true;
				}
			</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strSetAlertActions"/>
					<xsl:call-template name="Getname">
								<xsl:with-param name="type"><xsl:value-of select="/OMA/LraType"/></xsl:with-param>
							</xsl:call-template>
				</xsl:attribute>
			</PageTitle>
			<PromptText><xsl:value-of select="$strCheckTheAction"/></PromptText>
			<CustomButton>
				<Data name="ClearAll">
					<xsl:attribute name="display"><xsl:value-of select="$strClearAll"/></xsl:attribute>
					<xsl:attribute name="href">javascript:clearAll();</xsl:attribute>
				</Data>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.LRAWebPlugin&amp;oid=<xsl:value-of select="@oid"/>&amp;type=<xsl:value-of select="/OMA/Type"/>&amp;lratype=<xsl:value-of select="/OMA/LraType"/>&amp;help=ListLRA</xsl:attribute>
				</Data>
			</CustomButton>
      <TableData>
        <xsl:if test="$ConsAlertTag ='true' ">
          <Row>
            <xsl:element name="Data">

              <xsl:attribute name="name">ConsAlert</xsl:attribute>
              <xsl:attribute name="display">
                <xsl:value-of select="$strDisplayAnAlert"/>
              </xsl:attribute>
              <xsl:attribute name="value">
                <xsl:value-of select="$strDisplayAnAlert1"/>
              </xsl:attribute>
              <xsl:attribute name="returnvalue">true</xsl:attribute>
              <xsl:attribute name="type">checkbox</xsl:attribute>

              <xsl:if test="lrcBitmapSettings/ConsAlert='true'">
                <xsl:attribute name="state">1</xsl:attribute>
              </xsl:if>
              <xsl:attribute name="align">left</xsl:attribute>
            </xsl:element>
            <xsl:element name="Data">
						<xsl:attribute name="name">type</xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="/OMA/Type"/></xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select="/OMA/Type"/></xsl:attribute>
						<xsl:attribute name="type">hidden</xsl:attribute>
					</xsl:element>
			<xsl:if test="(/OMA/OMAUserRights = '7') and (/OMA/IsTrueAdmin = 'true')">
			<Data>
              <xsl:attribute name="colspan">2</xsl:attribute>
            </Data>
			</xsl:if>
          </Row>
        </xsl:if>
        <xsl:if test="$BcastMssgTag='true' ">
          <Row>
            <xsl:element name="Data">

              <xsl:attribute name="name">BcastMssg</xsl:attribute>
              <xsl:attribute name="display">
                <xsl:value-of select="$strBroadcastAMessage"/>
              </xsl:attribute>
              <xsl:attribute name="value">
                <xsl:value-of select="$strBroadcastAMessage1"/>
              </xsl:attribute>
              <xsl:attribute name="returnvalue">true</xsl:attribute>
              <xsl:attribute name="type">checkbox</xsl:attribute>
              <xsl:if test="lrcBitmapSettings/BcastMssg='true'">
                <xsl:attribute name="state">1</xsl:attribute>
              </xsl:if>
              <xsl:attribute name="align">left</xsl:attribute>
            </xsl:element>
            <xsl:if test="(/OMA/OMAUserRights = '7') and (/OMA/IsTrueAdmin = 'true')">
			<Data>
              <xsl:attribute name="colspan">2</xsl:attribute>
            </Data>
			</xsl:if>
          </Row>
        </xsl:if>
        <xsl:if test="(/OMA/OMAUserRights = '7') and (/OMA/IsTrueAdmin = 'true') and ($ExecAppTag = 'true')">
          <Row>
            <xsl:element name="Data">
              <xsl:attribute name="name">ExecApp</xsl:attribute>
              <xsl:attribute name="display">
                <xsl:value-of select="$strExecuteAnApplication"/>
              </xsl:attribute>
              <xsl:attribute name="value">
                <xsl:value-of select="$strExecuteApplication"/>
              </xsl:attribute>
              <xsl:attribute name="returnvalue">true</xsl:attribute>
              <xsl:attribute name="type">checkbox</xsl:attribute>
              <xsl:if test="lrcBitmapSettings/ExecApp='true'">
                <xsl:attribute name="state">1</xsl:attribute>
              </xsl:if>
              <xsl:attribute name="align">left</xsl:attribute>
            </xsl:element>
            <xsl:element name="Data">
              <xsl:attribute name="value">
                <xsl:value-of select="$strAbsolutePathTo1"/>
              </xsl:attribute>
              <xsl:attribute name="align">right</xsl:attribute>
              <xsl:attribute name="noborder">true</xsl:attribute>
              <xsl:attribute name="noborderright">true</xsl:attribute>
            </xsl:element>
            <xsl:element name="Data">
              <xsl:attribute name="align">left</xsl:attribute>
              <xsl:attribute name="event">onFocus</xsl:attribute>
              <xsl:attribute name="handler">checkExecApp();</xsl:attribute>
              <xsl:attribute name="name">EPFName</xsl:attribute>
              <xsl:attribute name="display"></xsl:attribute>
              <xsl:attribute name="value">
                <xsl:value-of select="lrcEpfName"/>
              </xsl:attribute>
              <xsl:attribute name="type">editbox</xsl:attribute>
              <xsl:attribute name="maxlength">255</xsl:attribute>

              <xsl:attribute name="noborder">true</xsl:attribute>
              <xsl:attribute name="noborderright">true</xsl:attribute>
            </xsl:element>

          </Row>
        </xsl:if>
      </TableData>
		</DataArea>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Getname">
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$type='177'"><xsl:value-of select="$strPowerSupplyCritical"/></xsl:when>
			<xsl:when test="$type='178'"><xsl:value-of select="$strTemperatureProbeWarning"/></xsl:when>
			<xsl:when test="$type='179'"><xsl:value-of select="$strTemperatureProbeFailure"/></xsl:when>
			<xsl:when test="$type='180'"><xsl:value-of select="$strFanProbeWarning"/></xsl:when>
			<xsl:when test="$type='181'"><xsl:value-of select="$strFanProbeFailure"/></xsl:when>
			<xsl:when test="$type='182'"><xsl:value-of select="$strVoltageProbeWarning"/></xsl:when>
			<xsl:when test="$type='183'"><xsl:value-of select="$strVoltageProbeFailure"/></xsl:when>
			<xsl:when test="$type='184'"><xsl:value-of select="$strSystemPowerProbeWarning"/></xsl:when>
			<xsl:when test="$type='185'"><xsl:value-of select="$strSystemPowerProbeFailure"/></xsl:when>
			<xsl:when test="$type='186'"><xsl:value-of select="$strChassisIntrusion"/></xsl:when>
			<xsl:when test="$type='187'"><xsl:value-of select="$strRedundancyDegraded"/></xsl:when>
			<xsl:when test="$type='188'"><xsl:value-of select="$strRedundancyLost"/></xsl:when>
			<xsl:when test="$type='189'"><xsl:value-of select="$strMemoryPrefailure"/></xsl:when>
			<xsl:when test="$type='190'"><xsl:value-of select="$strMemoryFailure"/></xsl:when>
			<xsl:when test="$type='304'"><xsl:value-of select="$strHardwareLogWarning"/></xsl:when>
			<xsl:when test="$type='305'"><xsl:value-of select="$strHardwareLogFailure"/></xsl:when>
			<xsl:when test="$type='308'"><xsl:value-of select="$strPowerSupplyWarning"/></xsl:when>
			<xsl:when test="$type='306'"><xsl:value-of select="$strProcessorWarning"/></xsl:when>
			<xsl:when test="$type='307'"><xsl:value-of select="$strProcessorFailure"/></xsl:when>
			<xsl:when test="$type='175'"><xsl:value-of select="$strWatchdogASR"/></xsl:when>
			<xsl:when test="$type='309'"><xsl:value-of select="$strBatteryProbeWarning"/></xsl:when>
			<xsl:when test="$type='310'"><xsl:value-of select="$strBatteryProbeDetects"/></xsl:when>
			<xsl:when test="$type='311'"><xsl:value-of select="$strSystemPeakPower"/></xsl:when>
			<xsl:when test="$type='312'"><xsl:value-of select="$strSDCardPresent"/></xsl:when>
			<xsl:when test="$type='313'"><xsl:value-of select="$strSDCardRemoved"/></xsl:when>
			<xsl:when test="$type='314'"><xsl:value-of select="$strSDCardFailure"/></xsl:when>
			<xsl:when test="$type='2050'"><xsl:value-of select="$strStorageSysWarning"/></xsl:when>
			<xsl:when test="$type='2051'"><xsl:value-of select="$strStorageSysFailure"/></xsl:when>
			<xsl:when test="$type='2060'"><xsl:value-of select="$strStorageCtrlWarning"/></xsl:when>
			<xsl:when test="$type='2061'"><xsl:value-of select="$strStorageCtrlFailure"/></xsl:when>
			<xsl:when test="$type='2070'"><xsl:value-of select="$strPhysicalDiskWarning"/></xsl:when>
			<xsl:when test="$type='2071'"><xsl:value-of select="$strPhysicalDiskFailure"/></xsl:when>
			<xsl:when test="$type='2080'"><xsl:value-of select="$strVirtualDiskWarning"/></xsl:when>
			<xsl:when test="$type='2081'"><xsl:value-of select="$strVirtualDiskFailure"/></xsl:when>
			<xsl:when test="$type='2090'"><xsl:value-of select="$strEnclosureWarning"/></xsl:when>
			<xsl:when test="$type='2091'"><xsl:value-of select="$strEnclosureFailure"/></xsl:when>
			<xsl:when test="$type='2100'"><xsl:value-of select="$strStorageCtrlBatteryWarning"/></xsl:when>
			<xsl:when test="$type='2101'"><xsl:value-of select="$strStorageCtrlBatteryFailure"/></xsl:when>
			
		</xsl:choose>
	</xsl:template>
	</xsl:stylesheet>
